/*
 * Decompiled with CFR 0.152.
 */
package processing.filters;

import dv.DV;
import imageTiTi.ImageNew;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import java.util.List;
import processing.filters.ConvolutionFilterAdaptativeI;
import processing.filters.SignalFilter;

public class ConvolutionFilterAdaptative
implements SignalFilter {
    protected ConvolutionFilterAdaptativeI maskclass = null;
    private ConvolutionFilterAdaptativeThread[] threads = null;
    private ConvolutionFilterAdaptativeFVThread[] threadsfv = null;
    private int nbFreeThreads = 0;
    private int ForbiddenValue = -1;

    public BufferedImage Filter(BufferedImage source, ConvolutionFilterAdaptativeI maskclass, int ForbiddenValue, int nbCPU) {
        this.Parameters(maskclass, ForbiddenValue);
        BufferedImage result = ImageNew.Same((BufferedImage)source);
        this.Filter(source, result, nbCPU);
        return result;
    }

    public void Filter(BufferedImage source, BufferedImage result, ConvolutionFilterAdaptativeI maskclass, int ForbiddenValue, int nbCPU) {
        this.Parameters(maskclass, ForbiddenValue);
        this.Filter(source, result, nbCPU);
    }

    public BufferedImage Filter(BufferedImage source, int nbCPU) {
        BufferedImage result = ImageNew.Same((BufferedImage)source);
        this.Filter(source, result, nbCPU);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Filter(BufferedImage source, BufferedImage result, int nbCPU) {
        Object object;
        int i2;
        if (nbCPU < 1) {
            throw new IllegalArgumentException("nbCPU < 1.");
        }
        if (!ImageTools.areDimensionsAndTypeEqual((BufferedImage)source, (BufferedImage)result)) {
            throw new IllegalArgumentException("Images source and result must have identic dimensions and types.");
        }
        if (0 <= this.ForbiddenValue) {
            Object e2;
            int i3;
            if (this.threadsfv == null || this.threadsfv.length != nbCPU) {
                this.nbFreeThreads = 0;
                this.threadsfv = null;
                this.threadsfv = new ConvolutionFilterAdaptativeFVThread[nbCPU];
                for (i3 = 0; i3 < nbCPU; ++i3) {
                    this.threadsfv[i3] = new ConvolutionFilterAdaptativeFVThread();
                    this.threadsfv[i3].start();
                }
                ConvolutionFilterAdaptative convolutionFilterAdaptative = this;
                synchronized (convolutionFilterAdaptative) {
                    while (this.nbFreeThreads != nbCPU) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException e2) {
                            e2.printStackTrace();
                        }
                    }
                }
            }
            this.nbFreeThreads = 0;
            int step = source.getHeight() / nbCPU;
            for (i3 = 0; i3 < nbCPU - 1; ++i3) {
                this.threadsfv[i3].setConditions(source, result, 0, i3 * step, source.getWidth(), (i3 + 1) * step);
                e2 = this.threadsfv[i3].lock;
                synchronized (e2) {
                    this.threadsfv[i3].lock.notify();
                    continue;
                }
            }
            this.threadsfv[i3].setConditions(source, result, 0, i3 * step, source.getWidth(), source.getHeight());
            e2 = this.threadsfv[i3].lock;
            synchronized (e2) {
                this.threadsfv[i3].lock.notify();
            }
            e2 = this;
            synchronized (e2) {
                while (this.nbFreeThreads != nbCPU) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e3) {
                        e3.printStackTrace();
                    }
                }
            }
            return;
        }
        if (this.threads == null || this.threads.length != nbCPU) {
            this.nbFreeThreads = 0;
            this.threads = null;
            this.threads = new ConvolutionFilterAdaptativeThread[nbCPU];
            for (i2 = 0; i2 < nbCPU; ++i2) {
                this.threads[i2] = new ConvolutionFilterAdaptativeThread();
                this.threads[i2].start();
            }
            ConvolutionFilterAdaptative step = this;
            synchronized (step) {
                while (this.nbFreeThreads != nbCPU) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        this.nbFreeThreads = 0;
        int step = source.getHeight() / nbCPU;
        for (i2 = 0; i2 < nbCPU - 1; ++i2) {
            this.threads[i2].setConditions(source, result, 0, i2 * step, source.getWidth(), (i2 + 1) * step);
            object = this.threads[i2].lock;
            synchronized (object) {
                this.threads[i2].lock.notify();
                continue;
            }
        }
        this.threads[i2].setConditions(source, result, 0, i2 * step, source.getWidth(), source.getHeight());
        object = this.threads[i2].lock;
        synchronized (object) {
            this.threads[i2].lock.notify();
        }
        object = this;
        synchronized (object) {
            while (this.nbFreeThreads != nbCPU) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public DV Filter(DV source, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public void Filter(DV source, DV result, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    protected synchronized void addFreeThread() {
        ++this.nbFreeThreads;
        this.notify();
    }

    public void Parameters(Object ... parameters) {
        if (parameters.length != 2) {
            throw new IllegalArgumentException("Exactly 2 parameters required.");
        }
        this.maskclass = (ConvolutionFilterAdaptativeI)parameters[0];
        this.ForbiddenValue = (Integer)parameters[1];
    }

    public List<Object> Parameters() {
        ArrayList<Object> params = new ArrayList<Object>(2);
        params.add(this.maskclass);
        params.add(this.ForbiddenValue);
        return params;
    }

    public int BorderEffectSizeX() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public int BorderEffectSizeY() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public int BorderEffectSizeZ() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public SignalFilter Clone() {
        throw new UnsupportedOperationException("Not supported (yet).");
    }

    private class ConvolutionFilterAdaptativeFVThread
    extends Thread {
        private WritableRaster wr = null;
        private WritableRaster wrr = null;
        private int Type;
        private int order = -1;
        private double[][] mask = null;
        private int minx;
        private int miny;
        private int maxx;
        private int maxy;
        public Object lock = new Object();

        public void setConditions(BufferedImage source, BufferedImage result, int minx, int miny, int maxx, int maxy) {
            this.wr = source.getRaster();
            this.wrr = result.getRaster();
            this.Type = source.getType();
            this.order = ConvolutionFilterAdaptative.this.maskclass.MaximumSize();
            this.minx = minx;
            this.miny = miny;
            this.maxx = maxx;
            this.maxy = maxy;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            block9: while (true) lbl-1000:
            // 3 sources

            {
                var20_17 = this.lock;
                synchronized (var20_17) {
                    try {
                        ConvolutionFilterAdaptative.this.addFreeThread();
                        this.lock.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                width = this.wr.getWidth();
                height = this.wr.getHeight();
                MinX = this.minx < this.order ? this.order : this.minx;
                MinY = this.miny < this.order ? this.order : this.miny;
                MaxX = this.maxx >= width - this.order ? width - this.order : this.maxx;
                MaxY = this.maxy >= height - this.order ? height - this.order : this.maxy;
                switch (this.Type) {
                    case 10: 
                    case 11: {
                        for (y = MinY; y < MaxY; ++y) {
                            for (x = MinX; x < MaxX; ++x) {
                                if (this.wr.getSample(x, y, 0) == ConvolutionFilterAdaptative.this.ForbiddenValue) continue;
                                this.mask = ConvolutionFilterAdaptative.this.maskclass.Mask(x, y, this.wr.getSample(x, y, 0));
                                sizex = this.mask[0].length / 2;
                                sizey = this.mask.length / 2;
                                Sum = 0.0;
                                Val = 0.0;
                                for (k = -sizey; k <= sizey; ++k) {
                                    for (l = -sizex; l <= sizex; ++l) {
                                        if (this.wr.getSample(x + l, y + k, 0) == ConvolutionFilterAdaptative.this.ForbiddenValue) continue;
                                        Val += this.wr.getSampleDouble(x + l, y + k, 0) * this.mask[k + sizey][l + sizex];
                                        Sum += this.mask[k + sizey][l + sizex];
                                    }
                                }
                                this.wrr.setSample(x, y, 0, (int)(Val / Sum + 0.5));
                            }
                        }
                        y = this.miny;
                        while (true) {
                            if (y >= this.maxy) ** GOTO lbl-1000
                            for (x = this.minx; x < this.maxx; ++x) {
                                if (y >= this.order && x >= this.order && y < height - this.order && x < width - this.order || this.wr.getSample(x, y, 0) == ConvolutionFilterAdaptative.this.ForbiddenValue) continue;
                                this.mask = ConvolutionFilterAdaptative.this.maskclass.Mask(x, y, this.wr.getSample(x, y, 0));
                                sizex = this.mask[0].length / 2;
                                sizey = this.mask.length / 2;
                                Sum = 0.0;
                                Val = 0.0;
                                for (k = -sizey; k <= sizey; ++k) {
                                    for (l = -sizex; l <= sizex; ++l) {
                                        v = ImageTools.PixelMirorDouble((WritableRaster)this.wr, (int)(x + l), (int)(y + k), (int)0);
                                        if (v == (double)ConvolutionFilterAdaptative.this.ForbiddenValue) continue;
                                        Val += v * this.mask[k + sizey][l + sizex];
                                        Sum += this.mask[k + sizey][l + sizex];
                                    }
                                }
                                this.wrr.setSample(x, y, 0, (int)(Val / Sum + 0.5));
                            }
                            ++y;
                        }
                    }
                    case 1: 
                    case 4: 
                    case 5: 
                    case 6: {
                        for (y = MinY; y < MaxY; ++y) {
                            for (x = MinX; x < MaxX; ++x) {
                                for (c = 0; c < 3; ++c) {
                                    if (this.wr.getSample(x, y, c) == ConvolutionFilterAdaptative.this.ForbiddenValue) continue;
                                    this.mask = ConvolutionFilterAdaptative.this.maskclass.Mask(x, y, this.wr.getSample(x, y, c));
                                    sizex = this.mask[0].length;
                                    sizey = this.mask.length;
                                    Sum = 0.0;
                                    Val = 0.0;
                                    for (k = -sizey; k <= sizey; ++k) {
                                        for (l = -sizex; l <= sizex; ++l) {
                                            if (this.wr.getSampleDouble(x + l, y + k, c) == (double)ConvolutionFilterAdaptative.this.ForbiddenValue) continue;
                                            Val += this.wr.getSampleDouble(x + l, y + k, c) * this.mask[k + sizey][l + sizex];
                                            Sum += this.mask[k + sizey][l + sizex];
                                        }
                                    }
                                    this.wrr.setSample(x, y, c, (int)(Val / Sum + 0.5));
                                }
                            }
                        }
                        y = this.miny;
                        while (true) {
                            if (y >= this.maxy) continue block9;
                            for (x = this.minx; x < this.maxx; ++x) {
                                if (y >= this.order && x >= this.order && y < height - this.order && x < width - this.order) continue;
                                for (c = 0; c < 3; ++c) {
                                    if (this.wr.getSampleDouble(x, y, c) == (double)ConvolutionFilterAdaptative.this.ForbiddenValue) continue;
                                    this.mask = ConvolutionFilterAdaptative.this.maskclass.Mask(x, y, this.wr.getSample(x, y, c));
                                    sizex = this.mask[0].length;
                                    sizey = this.mask.length;
                                    Sum = 0.0;
                                    Val = 0.0;
                                    for (k = -sizey; k <= sizey; ++k) {
                                        for (l = -sizex; l <= sizex; ++l) {
                                            v = ImageTools.PixelMirorDouble((WritableRaster)this.wr, (int)(x + l), (int)(y + k), (int)c);
                                            if (v == (double)ConvolutionFilterAdaptative.this.ForbiddenValue) continue;
                                            Val += v * this.mask[k + sizey][l + sizex];
                                            Sum += this.mask[k + sizey][l + sizex];
                                        }
                                    }
                                    this.wrr.setSample(x, y, c, (int)(Val / Sum + 0.5));
                                }
                            }
                            ++y;
                        }
                    }
                }
                break;
            }
            throw new IllegalArgumentException("Image type not supported.");
        }
    }

    private class ConvolutionFilterAdaptativeThread
    extends Thread {
        private WritableRaster wr = null;
        private WritableRaster wrr = null;
        private int Type;
        private int order = -1;
        private double[][] mask = null;
        private int minx;
        private int miny;
        private int maxx;
        private int maxy;
        public Object lock = new Object();

        public void setConditions(BufferedImage source, BufferedImage result, int minx, int miny, int maxx, int maxy) {
            this.wr = source.getRaster();
            this.wrr = result.getRaster();
            this.Type = source.getType();
            this.order = ConvolutionFilterAdaptative.this.maskclass.MaximumSize() >> 1;
            this.minx = minx;
            this.miny = miny;
            this.maxx = maxx;
            this.maxy = maxy;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            block9: while (true) lbl-1000:
            // 3 sources

            {
                var16_15 = this.lock;
                synchronized (var16_15) {
                    try {
                        ConvolutionFilterAdaptative.this.addFreeThread();
                        this.lock.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                width = this.wr.getWidth();
                height = this.wr.getHeight();
                MinX = this.minx < this.order ? this.order : this.minx;
                MinY = this.miny < this.order ? this.order : this.miny;
                MaxX = this.maxx >= width - this.order ? width - this.order : this.maxx;
                MaxY = this.maxy >= height - this.order ? height - this.order : this.maxy;
                switch (this.Type) {
                    case 10: 
                    case 11: {
                        for (y = MinY; y < MaxY; ++y) {
                            for (x = MinX; x < MaxX; ++x) {
                                this.mask = ConvolutionFilterAdaptative.this.maskclass.Mask(x, y, this.wr.getSample(x, y, 0));
                                sizex = this.mask[0].length / 2;
                                sizey = this.mask.length / 2;
                                Val = 0.0;
                                for (k = -sizey; k <= sizey; ++k) {
                                    for (l = -sizex; l <= sizex; ++l) {
                                        Val += this.wr.getSampleDouble(x + l, y + k, 0) * this.mask[k + sizey][l + sizex];
                                    }
                                }
                                this.wrr.setSample(x, y, 0, (int)(Val + 0.5));
                            }
                        }
                        y = this.miny;
                        while (true) {
                            if (y >= this.maxy) ** GOTO lbl-1000
                            for (x = this.minx; x < this.maxx; ++x) {
                                this.mask = ConvolutionFilterAdaptative.this.maskclass.Mask(x, y, this.wr.getSample(x, y, 0));
                                sizex = this.mask[0].length / 2;
                                sizey = this.mask.length / 2;
                                if (y >= sizey && x >= sizex && y < height - sizey && x < width - sizex) continue;
                                Val = 0.0;
                                for (k = -sizey; k <= sizey; ++k) {
                                    for (l = -sizex; l <= sizex; ++l) {
                                        Val += ImageTools.PixelMirorDouble((WritableRaster)this.wr, (int)(x + l), (int)(y + k), (int)0) * this.mask[k + sizey][l + sizex];
                                    }
                                }
                                this.wrr.setSample(x, y, 0, (int)(Val + 0.5));
                            }
                            ++y;
                        }
                    }
                    case 1: 
                    case 4: 
                    case 5: 
                    case 6: {
                        for (y = MinY; y < MaxY; ++y) {
                            for (x = MinX; x < MaxX; ++x) {
                                for (c = 0; c < 3; ++c) {
                                    this.mask = ConvolutionFilterAdaptative.this.maskclass.Mask(x, y, this.wr.getSample(x, y, c));
                                    sizex = this.mask[0].length / 2;
                                    sizey = this.mask.length / 2;
                                    Val = 0.0;
                                    for (k = -sizey; k <= sizey; ++k) {
                                        for (l = -sizex; l <= sizex; ++l) {
                                            Val += this.wr.getSampleDouble(x + l, y + k, c) * this.mask[k + sizey][l + sizex];
                                        }
                                    }
                                    this.wrr.setSample(x, y, c, (int)(Val + 0.5));
                                }
                            }
                        }
                        y = this.miny;
                        while (true) {
                            if (y >= this.maxy) continue block9;
                            for (x = this.minx; x < this.maxx; ++x) {
                                for (c = 0; c < 3; ++c) {
                                    this.mask = ConvolutionFilterAdaptative.this.maskclass.Mask(x, y, this.wr.getSample(x, y, c));
                                    sizex = this.mask[0].length / 2;
                                    sizey = this.mask.length / 2;
                                    if (y >= sizey && x >= sizex && y < height - sizey && x < width - sizex) continue;
                                    Val = 0.0;
                                    for (k = -sizey; k <= sizey; ++k) {
                                        for (l = -sizex; l <= sizex; ++l) {
                                            Val += ImageTools.PixelMirorDouble((WritableRaster)this.wr, (int)(x + l), (int)(y + k), (int)c) * this.mask[k + sizey][l + sizex];
                                        }
                                    }
                                    this.wrr.setSample(x, y, c, (int)(Val + 0.5));
                                }
                            }
                            ++y;
                        }
                    }
                }
                break;
            }
            throw new IllegalArgumentException("Image type not supported.");
        }
    }
}

