/*
 * Decompiled with CFR 0.152.
 */
package processing.filters;

import arrayTiTi.ArrayNew;
import arrayTiTi.ArrayTools;
import dv.DV;
import dv.DvNew;
import dv.DvTools;
import imageTiTi.ImageNew;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mathematics.fourier.FFT;
import mathematics.fourier.FastFourierTransform;
import mathematics.primitives.pointsTiTi.CoordinatesWeighted;
import morphee.MorphoFilter;
import morphee.StructuringElement;
import morphee.StructuringElement3D;
import pl.edu.icm.jlargearrays.ConcurrencyUtils;
import processing.filters.SignalFilter;

public class ConvolutionFilter
implements MorphoFilter {
    private StructuringElement se = null;
    private StructuringElement3D se3 = null;
    private ConvolutionFilterThread[] threads = null;
    private ConvolutionFilterFVThread[] threadsfv = null;
    private ConvolutionFilterFlatThread[] threadsflat = null;
    private ConvolutionFilterFlatFVThread[] threadsflatfv = null;
    private ConvolutionFilterDoubleThread[] threadsdouble = null;
    private ConvolutionFilter3DThread[] threads3d = null;
    private ConvolutionFilter3DFlatThread[] threads3flat = null;
    private ConvolutionFilter3DFlatFVThread[] threads3flatfv = null;
    private ConvolutionFilter3DFVThread[] threads3fv = null;
    private int nbFreeThreads = 0;
    private int ForbiddenValue = -1;
    private Object MaskFFT = null;
    private Object SourceFFT = null;
    private Object ResultFFT = null;
    private FFT fft = null;

    public void Kill() {
        if (this.threads != null) {
            for (Thread thread : this.threads) {
                ((ConvolutionFilterThread)thread).Kill();
            }
            Arrays.fill(this.threads, null);
            this.threads = null;
        }
        if (this.threadsfv != null) {
            for (Thread thread : this.threadsfv) {
                ((ConvolutionFilterFVThread)thread).Kill();
            }
            Arrays.fill(this.threadsfv, null);
            this.threadsfv = null;
        }
        if (this.threadsflat != null) {
            for (Thread thread : this.threadsflat) {
                ((ConvolutionFilterFlatThread)thread).Kill();
            }
            Arrays.fill(this.threadsflat, null);
            this.threadsflat = null;
        }
        if (this.threadsflatfv != null) {
            for (Thread thread : this.threadsflatfv) {
                ((ConvolutionFilterFlatFVThread)thread).Kill();
            }
            Arrays.fill(this.threadsflatfv, null);
            this.threadsflatfv = null;
        }
        if (this.threadsdouble != null) {
            for (Thread thread : this.threadsdouble) {
                ((ConvolutionFilterDoubleThread)thread).Kill();
            }
            Arrays.fill(this.threadsdouble, null);
            this.threadsdouble = null;
        }
        if (this.threads3d != null) {
            for (Thread thread : this.threads3d) {
                ((ConvolutionFilter3DThread)thread).Kill();
            }
            Arrays.fill(this.threads3d, null);
            this.threads3d = null;
        }
        if (this.threads3flat != null) {
            for (Thread thread : this.threads3flat) {
                ((ConvolutionFilter3DFlatThread)thread).Kill();
            }
            Arrays.fill(this.threads, null);
            this.threads3flat = null;
        }
        if (this.threads3flatfv != null) {
            for (Thread thread : this.threads3flatfv) {
                ((ConvolutionFilter3DFlatFVThread)thread).Kill();
            }
            Arrays.fill(this.threads3flatfv, null);
            this.threads3flatfv = null;
        }
        if (this.threads3fv != null) {
            for (Thread thread : this.threads3fv) {
                ((ConvolutionFilter3DFVThread)thread).Kill();
            }
            Arrays.fill(this.threads3fv, null);
            this.threads3fv = null;
        }
        this.ResultFFT = null;
        this.SourceFFT = null;
        this.MaskFFT = null;
        this.fft = null;
    }

    public BufferedImage Filter(BufferedImage source, StructuringElement se, int nbCPU) {
        BufferedImage result = ImageNew.Same((BufferedImage)source);
        this.Filter(source, se, result, nbCPU);
        return result;
    }

    public void Filter(BufferedImage source, StructuringElement se, BufferedImage result, int nbCPU) {
        this.setStructuringElement(se);
        this.Filter(source, result, nbCPU);
    }

    public BufferedImage Filter(BufferedImage source, int nbCPU) {
        BufferedImage result = ImageNew.Same((BufferedImage)source);
        this.Filter(source, result, nbCPU);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Filter(BufferedImage source, BufferedImage result, int nbCPU) {
        Object object;
        int i2;
        if (this.se == null) {
            throw new IllegalArgumentException("Any StructuringElement defined.");
        }
        if (nbCPU < 1) {
            throw new IllegalArgumentException("nbCPU < 1.");
        }
        if (!ImageTools.areDimensionsAndTypeEqual((BufferedImage)source, (BufferedImage)result)) {
            throw new IllegalArgumentException("Images source and result must have identic dimensions and types.");
        }
        if (this.fft != null) {
            if (!ImageTools.isGrayLevel((BufferedImage)source)) {
                throw new IllegalArgumentException("Only gray level images supported.");
            }
            if (this.SourceFFT == null || !this.fft.fft.areDimensionsCorrect(source, this.SourceFFT)) {
                this.SourceFFT = null;
                this.SourceFFT = this.fft.fft.CreateObject(source);
                this.ResultFFT = null;
                this.ResultFFT = this.fft.fft.CreateObject(source);
                this.MaskFFT = null;
                this.MaskFFT = this.fft.fft.CreateObject(source);
            }
            ConcurrencyUtils.setNumberOfThreads((int)nbCPU);
            this.fft.fft.Transform(this.se, this.MaskFFT);
            this.fft.Compute2D(this.MaskFFT, -1, nbCPU);
            this.fft.fft.Transform(source, this.SourceFFT);
            this.fft.Compute2D(this.SourceFFT, -1, nbCPU);
            this.fft.fft.Multiply2D(this.SourceFFT, this.MaskFFT, this.ResultFFT);
            this.fft.Compute2D(this.ResultFFT, 1, nbCPU);
            if (this.fft.fft.ShiftRequired()) {
                this.fft.fft.Shift(this.ResultFFT);
            }
            this.fft.fft.Transform(this.ResultFFT, result);
            return;
        }
        switch (this.se.getType()) {
            case -10: 
            case -9: 
            case -4: 
            case -3: {
                throw new IllegalArgumentException("Segment type structuring element must be used with Fourier transform.");
            }
        }
        this.se.PreComputePositions(source.getWidth(), source.getRaster().getNumBands());
        if (this.se.isFlat()) {
            Object e4;
            int i3;
            if (0 <= this.ForbiddenValue) {
                Object e22;
                int i4;
                if (this.threadsflatfv == null || this.threadsflatfv.length != nbCPU) {
                    this.nbFreeThreads = 0;
                    this.threadsflatfv = null;
                    this.threadsflatfv = new ConvolutionFilterFlatFVThread[nbCPU];
                    for (i4 = 0; i4 < nbCPU; ++i4) {
                        this.threadsflatfv[i4] = new ConvolutionFilterFlatFVThread();
                        this.threadsflatfv[i4].start();
                    }
                    ConvolutionFilter convolutionFilter = this;
                    synchronized (convolutionFilter) {
                        while (this.nbFreeThreads != nbCPU) {
                            try {
                                this.wait();
                            }
                            catch (InterruptedException e22) {
                                e22.printStackTrace();
                            }
                        }
                    }
                }
                this.nbFreeThreads = 0;
                int step = source.getHeight() / nbCPU;
                for (i4 = 0; i4 < nbCPU - 1; ++i4) {
                    this.threadsflatfv[i4].setConditions(source, result, this.se, 0, i4 * step, source.getWidth(), (i4 + 1) * step);
                    e22 = this.threadsflatfv[i4].lock;
                    synchronized (e22) {
                        this.threadsflatfv[i4].lock.notify();
                        continue;
                    }
                }
                this.threadsflatfv[i4].setConditions(source, result, this.se, 0, i4 * step, source.getWidth(), source.getHeight());
                e22 = this.threadsflatfv[i4].lock;
                synchronized (e22) {
                    this.threadsflatfv[i4].lock.notify();
                }
                e22 = this;
                synchronized (e22) {
                    while (this.nbFreeThreads != nbCPU) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException e3) {
                            e3.printStackTrace();
                        }
                    }
                }
                return;
            }
            if (this.threadsflat == null || this.threadsflat.length != nbCPU) {
                this.nbFreeThreads = 0;
                this.threadsflat = null;
                this.threadsflat = new ConvolutionFilterFlatThread[nbCPU];
                for (i3 = 0; i3 < nbCPU; ++i3) {
                    this.threadsflat[i3] = new ConvolutionFilterFlatThread();
                    this.threadsflat[i3].start();
                }
                ConvolutionFilter step = this;
                synchronized (step) {
                    while (this.nbFreeThreads != nbCPU) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException e4) {
                            e4.printStackTrace();
                        }
                    }
                }
            }
            this.nbFreeThreads = 0;
            int step = source.getHeight() / nbCPU;
            for (i3 = 0; i3 < nbCPU - 1; ++i3) {
                this.threadsflat[i3].setConditions(source, result, this.se, 0, i3 * step, source.getWidth(), (i3 + 1) * step);
                e4 = this.threadsflat[i3].lock;
                synchronized (e4) {
                    this.threadsflat[i3].lock.notify();
                    continue;
                }
            }
            this.threadsflat[i3].setConditions(source, result, this.se, 0, i3 * step, source.getWidth(), source.getHeight());
            e4 = this.threadsflat[i3].lock;
            synchronized (e4) {
                this.threadsflat[i3].lock.notify();
            }
            e4 = this;
            synchronized (e4) {
                while (this.nbFreeThreads != nbCPU) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e5) {
                        e5.printStackTrace();
                    }
                }
            }
            return;
        }
        if (0 <= this.ForbiddenValue) {
            Object e6;
            int i5;
            if (this.threadsfv == null || this.threadsfv.length != nbCPU) {
                this.nbFreeThreads = 0;
                this.threadsfv = null;
                this.threadsfv = new ConvolutionFilterFVThread[nbCPU];
                for (i5 = 0; i5 < nbCPU; ++i5) {
                    this.threadsfv[i5] = new ConvolutionFilterFVThread();
                    this.threadsfv[i5].start();
                }
                ConvolutionFilter step = this;
                synchronized (step) {
                    while (this.nbFreeThreads != nbCPU) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException e6) {
                            e6.printStackTrace();
                        }
                    }
                }
            }
            this.nbFreeThreads = 0;
            int step = source.getHeight() / nbCPU;
            for (i5 = 0; i5 < nbCPU - 1; ++i5) {
                this.threadsfv[i5].setConditions(source, result, this.se, 0, i5 * step, source.getWidth(), (i5 + 1) * step);
                e6 = this.threadsfv[i5].lock;
                synchronized (e6) {
                    this.threadsfv[i5].lock.notify();
                    continue;
                }
            }
            this.threadsfv[i5].setConditions(source, result, this.se, 0, i5 * step, source.getWidth(), source.getHeight());
            e6 = this.threadsfv[i5].lock;
            synchronized (e6) {
                this.threadsfv[i5].lock.notify();
            }
            e6 = this;
            synchronized (e6) {
                while (this.nbFreeThreads != nbCPU) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e7) {
                        e7.printStackTrace();
                    }
                }
            }
            return;
        }
        if (this.threads == null || this.threads.length != nbCPU) {
            this.nbFreeThreads = 0;
            this.threads = null;
            this.threads = new ConvolutionFilterThread[nbCPU];
            for (i2 = 0; i2 < nbCPU; ++i2) {
                this.threads[i2] = new ConvolutionFilterThread();
                this.threads[i2].start();
            }
            ConvolutionFilter step = this;
            synchronized (step) {
                while (this.nbFreeThreads != nbCPU) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        this.nbFreeThreads = 0;
        int step = source.getHeight() / nbCPU;
        for (i2 = 0; i2 < nbCPU - 1; ++i2) {
            this.threads[i2].setConditions(source, result, this.se, 0, i2 * step, source.getWidth(), (i2 + 1) * step);
            object = this.threads[i2].lock;
            synchronized (object) {
                this.threads[i2].lock.notify();
                continue;
            }
        }
        this.threads[i2].setConditions(source, result, this.se, 0, i2 * step, source.getWidth(), source.getHeight());
        object = this.threads[i2].lock;
        synchronized (object) {
            this.threads[i2].lock.notify();
        }
        object = this;
        synchronized (object) {
            while (this.nbFreeThreads != nbCPU) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    protected synchronized void addFreeThread() {
        ++this.nbFreeThreads;
        this.notify();
    }

    public DV Filter(DV source, int nbCPU) {
        DV res = DvNew.Same((DV)source);
        this.Filter(source, res, nbCPU);
        return res;
    }

    public DV Filter(DV source, StructuringElement3D se, int nbCPU) {
        this.setStructuringElement3D(se);
        return this.Filter(source, nbCPU);
    }

    public void Filter(DV source, StructuringElement3D se, DV result, int nbCPU) {
        this.setStructuringElement3D(se);
        this.Filter(source, result, nbCPU);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Filter(DV source, DV result, int nbCPU) {
        Object object;
        int i2;
        if (this.se3 == null) {
            throw new IllegalArgumentException("Any StructuringElement3D defined.");
        }
        if (nbCPU < 1) {
            throw new IllegalArgumentException("nbCPU < 1.");
        }
        if (!DvTools.areDimensionsAndTypeEqual((DV)source, (DV)result)) {
            throw new IllegalArgumentException("Images source and result must have identic dimensions and types.");
        }
        if (this.fft != null) {
            if (!DvTools.isGrayLevel((DV)source)) {
                throw new IllegalArgumentException("Only gray level images supported.");
            }
            if (this.SourceFFT == null || !this.fft.fft.areDimensionsCorrect(source, this.SourceFFT)) {
                this.SourceFFT = null;
                this.SourceFFT = this.fft.fft.CreateObject(source);
                this.ResultFFT = null;
                this.ResultFFT = this.fft.fft.CreateObject(source);
                this.MaskFFT = null;
                this.MaskFFT = this.fft.fft.CreateObject(source);
            }
            ConcurrencyUtils.setNumberOfThreads((int)nbCPU);
            this.fft.fft.Transform(this.se3, this.MaskFFT);
            this.fft.Compute3D(this.MaskFFT, -1, nbCPU);
            this.fft.fft.Transform(source, this.SourceFFT);
            this.fft.Compute3D(this.SourceFFT, -1, nbCPU);
            this.fft.fft.Multiply3D(this.SourceFFT, this.MaskFFT, this.ResultFFT);
            this.fft.Compute3D(this.ResultFFT, 1, nbCPU);
            if (this.fft.fft.ShiftRequired()) {
                this.fft.fft.Shift(this.ResultFFT);
            }
            this.fft.fft.Transform(this.ResultFFT, result);
            return;
        }
        this.se3.PreComputePositions(source.SizeX, source.SizeY);
        int step = source.SizeZ / nbCPU;
        if (this.se3.isFlat()) {
            Object object2;
            int i3;
            if (0 <= this.ForbiddenValue) {
                Object object3;
                int i4;
                if (this.threads3flatfv == null || this.threads3flatfv.length != nbCPU) {
                    this.nbFreeThreads = 0;
                    this.threads3flatfv = null;
                    this.threads3flatfv = new ConvolutionFilter3DFlatFVThread[nbCPU];
                    for (i4 = 0; i4 < nbCPU; ++i4) {
                        this.threads3flatfv[i4] = new ConvolutionFilter3DFlatFVThread();
                        this.threads3flatfv[i4].start();
                    }
                    object3 = this;
                    synchronized (object3) {
                        while (this.nbFreeThreads != nbCPU) {
                            try {
                                this.wait();
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }
                for (int c = 0; c < source.Channel; ++c) {
                    this.nbFreeThreads = 0;
                    for (i4 = 0; i4 < nbCPU - 1; ++i4) {
                        this.threads3flatfv[i4].setConditions(source, c, result, this.se3, 0, 0, i4 * step, source.SizeX, source.SizeY, (i4 + 1) * step);
                        object3 = this.threads3flatfv[i4].lock;
                        synchronized (object3) {
                            this.threads3flatfv[i4].lock.notify();
                            continue;
                        }
                    }
                    this.threads3flatfv[i4].setConditions(source, c, result, this.se3, 0, 0, i4 * step, source.SizeX, source.SizeY, (i4 + 1) * step);
                    object3 = this.threads3flatfv[i4].lock;
                    synchronized (object3) {
                        this.threads3flatfv[i4].lock.notify();
                    }
                    object3 = this;
                    synchronized (object3) {
                        while (this.nbFreeThreads != nbCPU) {
                            try {
                                this.wait();
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                        }
                        continue;
                    }
                }
                return;
            }
            if (this.threads3flat == null || this.threads3flat.length != nbCPU) {
                this.nbFreeThreads = 0;
                this.threads3flat = null;
                this.threads3flat = new ConvolutionFilter3DFlatThread[nbCPU];
                for (i3 = 0; i3 < nbCPU; ++i3) {
                    this.threads3flat[i3] = new ConvolutionFilter3DFlatThread();
                    this.threads3flat[i3].start();
                }
                object2 = this;
                synchronized (object2) {
                    while (this.nbFreeThreads != nbCPU) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
            for (int c = 0; c < source.Channel; ++c) {
                this.nbFreeThreads = 0;
                for (i3 = 0; i3 < nbCPU - 1; ++i3) {
                    this.threads3flat[i3].setConditions(source, c, result, this.se3, 0, 0, i3 * step, source.SizeX, source.SizeY, (i3 + 1) * step);
                    object2 = this.threads3flat[i3].lock;
                    synchronized (object2) {
                        this.threads3flat[i3].lock.notify();
                        continue;
                    }
                }
                this.threads3flat[i3].setConditions(source, c, result, this.se3, 0, 0, i3 * step, source.SizeX, source.SizeY, source.SizeZ);
                object2 = this.threads3flat[i3].lock;
                synchronized (object2) {
                    this.threads3flat[i3].lock.notify();
                }
                object2 = this;
                synchronized (object2) {
                    while (this.nbFreeThreads != nbCPU) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                    continue;
                }
            }
            return;
        }
        if (0 <= this.ForbiddenValue) {
            Object object4;
            int i5;
            if (this.threads3fv == null || this.threads3fv.length != nbCPU) {
                this.nbFreeThreads = 0;
                this.threads3fv = null;
                this.threads3fv = new ConvolutionFilter3DFVThread[nbCPU];
                for (i5 = 0; i5 < nbCPU; ++i5) {
                    this.threads3fv[i5] = new ConvolutionFilter3DFVThread();
                    this.threads3fv[i5].start();
                }
                object4 = this;
                synchronized (object4) {
                    while (this.nbFreeThreads != nbCPU) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
            for (int c = 0; c < source.Channel; ++c) {
                this.nbFreeThreads = 0;
                for (i5 = 0; i5 < nbCPU - 1; ++i5) {
                    this.threads3fv[i5].setConditions(source, c, result, this.se3, 0, 0, i5 * step, source.SizeX, source.SizeY, (i5 + 1) * step);
                    object4 = this.threads3fv[i5].lock;
                    synchronized (object4) {
                        this.threads3fv[i5].lock.notify();
                        continue;
                    }
                }
                this.threads3fv[i5].setConditions(source, c, result, this.se3, 0, 0, i5 * step, source.SizeX, source.SizeY, (i5 + 1) * step);
                object4 = this.threads3fv[i5].lock;
                synchronized (object4) {
                    this.threads3fv[i5].lock.notify();
                }
                object4 = this;
                synchronized (object4) {
                    while (this.nbFreeThreads != nbCPU) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                    continue;
                }
            }
            return;
        }
        if (this.threads3d == null || this.threads3d.length != nbCPU) {
            this.nbFreeThreads = 0;
            this.threads3d = null;
            this.threads3d = new ConvolutionFilter3DThread[nbCPU];
            for (i2 = 0; i2 < nbCPU; ++i2) {
                this.threads3d[i2] = new ConvolutionFilter3DThread();
                this.threads3d[i2].start();
            }
            object = this;
            synchronized (object) {
                while (this.nbFreeThreads != nbCPU) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        for (int c = 0; c < source.Channel; ++c) {
            this.nbFreeThreads = 0;
            for (i2 = 0; i2 < nbCPU - 1; ++i2) {
                this.threads3d[i2].setConditions(source, c, result, this.se3, 0, 0, i2 * step, source.SizeX, source.SizeY, (i2 + 1) * step);
                object = this.threads3d[i2].lock;
                synchronized (object) {
                    this.threads3d[i2].lock.notify();
                    continue;
                }
            }
            this.threads3d[i2].setConditions(source, c, result, this.se3, 0, 0, i2 * step, source.SizeX, source.SizeY, source.SizeZ);
            object = this.threads3d[i2].lock;
            synchronized (object) {
                this.threads3d[i2].lock.notify();
            }
            object = this;
            synchronized (object) {
                while (this.nbFreeThreads != nbCPU) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                continue;
            }
        }
    }

    public double[][] Filter(double[][] source, StructuringElement se, int nbCPU) {
        double[][] result = ArrayNew.Same((double[][])source);
        this.Filter(source, se, result, nbCPU);
        return result;
    }

    public void Filter(double[][] source, StructuringElement se, double[][] result, int nbCPU) {
        this.setStructuringElement(se);
        this.Filter(source, result, nbCPU);
    }

    public double[][] Filter(double[][] source, int nbCPU) {
        double[][] result = ArrayNew.Same((double[][])source);
        this.Filter(source, result, nbCPU);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Filter(double[][] source, double[][] result, int nbCPU) {
        Object object;
        int i2;
        if (nbCPU < 1) {
            throw new IllegalArgumentException("nbCPU < 1.");
        }
        if (!ArrayTools.areDimensionsEqual((double[][])source, (double[][])result)) {
            throw new IllegalArgumentException("Arrays source and result must have identic dimensions.");
        }
        if (this.fft != null) {
            if (this.SourceFFT == null || !this.fft.fft.areDimensionsCorrect(source, this.SourceFFT)) {
                this.SourceFFT = null;
                this.SourceFFT = this.fft.fft.CreateObject(source);
                this.ResultFFT = null;
                this.ResultFFT = this.fft.fft.CreateObject(source);
                this.MaskFFT = null;
                this.MaskFFT = this.fft.fft.CreateObject(source);
            }
            this.fft.fft.Transform(this.se, this.MaskFFT);
            this.fft.Compute2D(this.MaskFFT, -1, nbCPU);
            this.fft.fft.Transform(source, this.SourceFFT);
            this.fft.Compute2D(this.SourceFFT, -1, nbCPU);
            this.fft.fft.Multiply2D(this.SourceFFT, this.MaskFFT, this.ResultFFT);
            this.fft.Compute2D(this.ResultFFT, 1, nbCPU);
            if (this.fft.fft.ShiftRequired()) {
                this.fft.fft.Shift(this.ResultFFT);
            }
            this.fft.fft.Transform(this.ResultFFT, result);
            return;
        }
        if (this.threadsdouble == null || this.threadsdouble.length != nbCPU) {
            this.nbFreeThreads = 0;
            this.threadsdouble = null;
            this.threadsdouble = new ConvolutionFilterDoubleThread[nbCPU];
            for (i2 = 0; i2 < nbCPU; ++i2) {
                this.threadsdouble[i2] = new ConvolutionFilterDoubleThread();
                this.threadsdouble[i2].start();
            }
            ConvolutionFilter convolutionFilter = this;
            synchronized (convolutionFilter) {
                while (this.nbFreeThreads != nbCPU) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        this.nbFreeThreads = 0;
        int step = source.length / nbCPU;
        for (i2 = 0; i2 < nbCPU - 1; ++i2) {
            this.threadsdouble[i2].setConditions(source, result, this.se, 0, i2 * step, source[0].length, (i2 + 1) * step);
            object = this.threadsdouble[i2].lock;
            synchronized (object) {
                this.threadsdouble[i2].lock.notify();
                continue;
            }
        }
        this.threadsdouble[i2].setConditions(source, result, this.se, 0, i2 * step, source[0].length, source.length);
        object = this.threadsdouble[i2].lock;
        synchronized (object) {
            this.threadsdouble[i2].lock.notify();
        }
        object = this;
        synchronized (object) {
            while (this.nbFreeThreads != nbCPU) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void setStructuringElement(StructuringElement se) {
        this.se = se;
    }

    public StructuringElement getStructuringElement() {
        return this.se;
    }

    public StructuringElement3D getStructuringElement3D() {
        return this.se3;
    }

    public void setStructuringElement3D(StructuringElement3D se) {
        this.se3 = se;
    }

    public FastFourierTransform getFastFourierTransform() {
        return this.fft.fft;
    }

    public void Parameters(Object ... parameters) {
        if (parameters.length != 3) {
            throw new IllegalArgumentException("Exactly 3 parameters required.");
        }
        if (parameters[0] instanceof StructuringElement) {
            this.setStructuringElement((StructuringElement)parameters[0]);
        } else if (parameters[0] instanceof StructuringElement3D) {
            this.setStructuringElement3D((StructuringElement3D)parameters[0]);
        } else {
            throw new IllegalArgumentException("The first parameter is not a structuring element (2D or 3D).");
        }
        FastFourierTransform algo = (FastFourierTransform)parameters[1];
        this.fft = algo != null ? new FFT(algo) : null;
        this.ForbiddenValue = (Integer)parameters[2];
        if (this.fft != null && this.ForbiddenValue >= 0) {
            throw new IllegalArgumentException("fft != null && ForbiddenValue >= 0.\nFFT can't be used with a forbidden value.");
        }
    }

    public List<Object> Parameters() {
        ArrayList<Object> params = new ArrayList<Object>(3);
        if (this.se != null) {
            params.add(this.se);
        } else {
            params.add(this.se3);
        }
        params.add(this.fft.fft);
        params.add(this.ForbiddenValue);
        return params;
    }

    public int BorderEffectSizeX() {
        if (this.se != null) {
            return this.se.getSizeX() >> 1;
        }
        if (this.se3 != null) {
            return this.se3.getSizeX() >> 1;
        }
        throw new IllegalStateException("Any structuring element defined.");
    }

    public int BorderEffectSizeY() {
        if (this.se != null) {
            return this.se.getSizeY() >> 1;
        }
        if (this.se3 != null) {
            return this.se3.getSizeY() >> 1;
        }
        throw new IllegalStateException("Any structuring element defined.");
    }

    public int BorderEffectSizeZ() {
        if (this.se != null) {
            return 0;
        }
        if (this.se3 != null) {
            return this.se3.getSizeZ() >> 1;
        }
        throw new IllegalStateException("Any structuring element defined.");
    }

    public SignalFilter Clone() {
        ConvolutionFilter filter = new ConvolutionFilter();
        filter.Parameters(this.se != null ? this.se.Clone() : this.se3.Clone(), this.fft != null ? this.fft.fft.Clone() : null, this.ForbiddenValue);
        return filter;
    }

    private class ConvolutionFilter3DFVThread
    extends Thread {
        private DV dv;
        private DV dvres;
        private int channel;
        private int Type;
        private int sizex = -1;
        private int sizey = -1;
        private int sizez = -1;
        private StructuringElement3D se = null;
        private int minx;
        private int miny;
        private int minz;
        private int maxx;
        private int maxy;
        private int maxz;
        private boolean Kill = false;
        public Object lock = new Object();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void Kill() {
            this.se = null;
            this.dvres = null;
            this.dv = null;
            this.Kill = true;
            Object object = this.lock;
            synchronized (object) {
                this.lock.notify();
            }
        }

        public void setConditions(DV source, int channel, DV result, StructuringElement3D se, int minx, int miny, int minz, int maxx, int maxy, int maxz) {
            this.dv = source;
            this.dvres = result;
            this.Type = source.Type;
            this.se = se;
            this.sizex = se.getSizeX() >> 1;
            this.sizey = se.getSizeY() >> 1;
            this.sizez = se.getSizeZ() >> 1;
            this.minx = minx;
            this.miny = miny;
            this.minz = minz;
            this.maxx = maxx;
            this.maxy = maxy;
            this.maxz = maxz;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block10: while (true) {
                Object object = this.lock;
                synchronized (object) {
                    try {
                        ConvolutionFilter.this.addFreeThread();
                        this.lock.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                if (this.Kill) {
                    return;
                }
                int width = this.dv.SizeX;
                int height = this.dv.SizeY;
                int depth = this.dv.SizeZ;
                int MinX = this.minx < this.sizex ? this.sizex : this.minx;
                int MinY = this.miny < this.sizey ? this.sizey : this.miny;
                int MinZ = this.minz < this.sizez ? this.sizez : this.minz;
                int MaxX = this.maxx >= width - this.sizex ? width - this.sizex : this.maxx;
                int MaxY = this.maxy >= height - this.sizey ? height - this.sizey : this.maxy;
                int MaxZ = this.maxz >= depth - this.sizez ? depth - this.sizez : this.maxz;
                int widthminussizex = width - this.sizex;
                int heightminussizey = height - this.sizey;
                int depthminussizez = depth - this.sizez;
                CoordinatesWeighted[] cws = this.se.getSE();
                switch (this.Type) {
                    case 8: {
                        double Sum2;
                        double Val;
                        int pos;
                        int x;
                        int y;
                        int z;
                        byte[] srcbb = this.dv.getDataBufferByte(this.channel);
                        byte[] resbb = this.dvres.getDataBufferByte(this.channel);
                        for (z = MinZ; z < MaxZ; ++z) {
                            for (y = MinY; y < MaxY; ++y) {
                                x = MinX;
                                pos = z * this.dv.LayerSize + y * width + x;
                                while (x < MaxX) {
                                    if ((srcbb[pos] & 0xFF) != ConvolutionFilter.this.ForbiddenValue) {
                                        Val = 0.0;
                                        Sum2 = 0.0;
                                        for (CoordinatesWeighted cw : cws) {
                                            int v = srcbb[pos + cw.Pos] & 0xFF;
                                            if (v == ConvolutionFilter.this.ForbiddenValue) continue;
                                            Val += (double)v * cw.Wd;
                                            Sum2 += cw.Wd;
                                        }
                                        resbb[pos] = (byte)(Val / Sum2 + 0.5);
                                    }
                                    ++x;
                                    ++pos;
                                }
                            }
                        }
                        for (z = this.minz; z < this.maxz; ++z) {
                            if (z >= this.sizez && depthminussizez > z) continue;
                            for (y = this.miny; y < this.maxy; ++y) {
                                if (y >= this.sizey && heightminussizey > y) continue;
                                for (x = this.minx; x < this.maxx; ++x) {
                                    if (x >= this.sizex && widthminussizex > x || (srcbb[pos = x + y * width + z * this.dv.LayerSize] & 0xFF) == ConvolutionFilter.this.ForbiddenValue) continue;
                                    Val = 0.0;
                                    Sum2 = 0.0;
                                    for (CoordinatesWeighted cw : cws) {
                                        int v;
                                        int dx = x + cw.X;
                                        int dy = y + cw.Y;
                                        int dz = z + cw.Z;
                                        if (0 > dx || dx >= width || 0 > dy || dy >= height || 0 > dz || dz >= depth || (v = srcbb[pos + cw.Pos] & 0xFF) == ConvolutionFilter.this.ForbiddenValue) continue;
                                        Val += (double)v * cw.Wd;
                                        Sum2 += cw.Wd;
                                    }
                                    resbb[pos] = (byte)(Val / Sum2 + 0.5);
                                }
                            }
                        }
                        resbb = null;
                        srcbb = null;
                        continue block10;
                    }
                    case 16: {
                        int pos;
                        int z;
                        short[] srcsb = this.dv.getDataBufferShort(this.channel);
                        short[] ressb = this.dvres.getDataBufferShort(this.channel);
                        for (z = MinZ; z < MaxZ; ++z) {
                            for (int y = MinY; y < MaxY; ++y) {
                                int x = MinX;
                                pos = z * this.dv.LayerSize + y * width + x;
                                while (x < MaxX) {
                                    if ((srcsb[pos] & 0xFFFF) != ConvolutionFilter.this.ForbiddenValue) {
                                        double Val = 0.0;
                                        double Sum3 = 0.0;
                                        for (CoordinatesWeighted cw : cws) {
                                            int v = srcsb[pos + cw.Pos] & 0xFFFF;
                                            if (v == ConvolutionFilter.this.ForbiddenValue) continue;
                                            Val += (double)v * cw.Wd;
                                            Sum3 += cw.Wd;
                                        }
                                        ressb[pos] = (short)(Val / Sum3 + 0.5);
                                    }
                                    ++x;
                                    ++pos;
                                }
                            }
                        }
                        for (z = this.minz; z < this.maxz; ++z) {
                            if (z >= this.sizez && depthminussizez > z) continue;
                            for (int y = this.miny; y < this.maxy; ++y) {
                                if (y >= this.sizey && heightminussizey > y) continue;
                                for (int x = this.minx; x < this.maxx; ++x) {
                                    if (x >= this.sizex && widthminussizex > x || (srcsb[pos = x + y * width + z * this.dv.LayerSize] & 0xFFFF) == ConvolutionFilter.this.ForbiddenValue) continue;
                                    double Val = 0.0;
                                    double Sum4 = 0.0;
                                    for (CoordinatesWeighted cw : cws) {
                                        int v;
                                        int dx = x + cw.X;
                                        int dy = y + cw.Y;
                                        int dz = z + cw.Z;
                                        if (0 > dx || dx >= width || 0 > dy || dy >= height || 0 > dz || dz >= depth || (v = srcsb[pos + cw.Pos] & 0xFFFF) == ConvolutionFilter.this.ForbiddenValue) continue;
                                        Val += (double)v * cw.Wd;
                                        Sum4 += cw.Wd;
                                    }
                                    ressb[pos] = (short)(Val / Sum4 + 0.5);
                                }
                            }
                        }
                        ressb = null;
                        srcsb = null;
                        continue block10;
                    }
                    case 32: {
                        int pos;
                        int y;
                        int z;
                        int[] srcib = this.dv.getDataBufferInt(this.channel);
                        int[] resib = this.dvres.getDataBufferInt(this.channel);
                        for (z = MinZ; z < MaxZ; ++z) {
                            for (y = MinY; y < MaxY; ++y) {
                                int x = MinX;
                                pos = z * this.dv.LayerSize + y * width + x;
                                while (x < MaxX) {
                                    if (srcib[pos] != ConvolutionFilter.this.ForbiddenValue) {
                                        double Val = 0.0;
                                        double Sum5 = 0.0;
                                        for (CoordinatesWeighted cw : cws) {
                                            int v = srcib[pos + cw.Pos];
                                            if (v == ConvolutionFilter.this.ForbiddenValue) continue;
                                            Val += (double)v * cw.Wd;
                                            Sum5 += cw.Wd;
                                        }
                                        resib[pos] = (int)(Val / Sum5 + 0.5);
                                    }
                                    ++x;
                                    ++pos;
                                }
                            }
                        }
                        for (z = this.minz; z < this.maxz; ++z) {
                            if (z >= this.sizez && depthminussizez > z) continue;
                            for (y = this.miny; y < this.maxy; ++y) {
                                if (y >= this.sizey && heightminussizey > y) continue;
                                for (int x = this.minx; x < this.maxx; ++x) {
                                    if (x >= this.sizex && widthminussizex > x || srcib[pos = x + y * width + z * this.dv.LayerSize] == ConvolutionFilter.this.ForbiddenValue) continue;
                                    double Val = 0.0;
                                    double Sum6 = 0.0;
                                    for (CoordinatesWeighted cw : cws) {
                                        int v;
                                        int dx = x + cw.X;
                                        int dy = y + cw.Y;
                                        int dz = z + cw.Z;
                                        if (0 > dx || dx >= width || 0 > dy || dy >= height || 0 > dz || dz >= depth || (v = srcib[pos + cw.Pos]) == ConvolutionFilter.this.ForbiddenValue) continue;
                                        Val += (double)v * cw.Wd;
                                        Sum6 += cw.Wd;
                                    }
                                    resib[pos] = (int)(Val / Sum6 + 0.5);
                                }
                            }
                        }
                        resib = null;
                        srcib = null;
                        continue block10;
                    }
                }
                break;
            }
            throw new IllegalArgumentException("DV type not supported.");
        }
    }

    private class ConvolutionFilter3DFlatFVThread
    extends Thread {
        private DV dv;
        private DV dvres;
        private int Type;
        private int channel = 0;
        private int sizex = -1;
        private int sizey = -1;
        private int sizez = -1;
        private StructuringElement3D se = null;
        private int minx;
        private int miny;
        private int minz;
        private int maxx;
        private int maxy;
        private int maxz;
        private boolean Kill = false;
        public Object lock = new Object();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void Kill() {
            this.se = null;
            this.dvres = null;
            this.dv = null;
            this.Kill = true;
            Object object = this.lock;
            synchronized (object) {
                this.lock.notify();
            }
        }

        public void setConditions(DV source, int channel, DV result, StructuringElement3D se, int minx, int miny, int minz, int maxx, int maxy, int maxz) {
            this.dv = source;
            this.dvres = result;
            this.channel = channel;
            this.Type = source.Type;
            this.se = se;
            this.sizex = se.getSizeX() >> 1;
            this.sizey = se.getSizeY() >> 1;
            this.sizez = se.getSizeZ() >> 1;
            this.minx = minx;
            this.miny = miny;
            this.minz = minz;
            this.maxx = maxx;
            this.maxy = maxy;
            this.maxz = maxz;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            CoordinatesWeighted[] sec = null;
            CoordinatesWeighted[] forward = null;
            CoordinatesWeighted[] backward = null;
            CoordinatesWeighted coord = null;
            block10: while (true) {
                Object object = this.lock;
                synchronized (object) {
                    try {
                        ConvolutionFilter.this.addFreeThread();
                        this.lock.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                if (this.Kill) {
                    return;
                }
                int width = this.dv.SizeX;
                int height = this.dv.SizeY;
                int depth = this.dv.SizeZ;
                int MinX = this.minx < this.sizex ? this.sizex : this.minx;
                int MinY = this.miny < this.sizey ? this.sizey : this.miny;
                int MinZ = this.minz < this.sizez ? this.sizez : this.minz;
                int MaxX = this.maxx >= width - this.sizex ? width - this.sizex : this.maxx;
                int MaxY = this.maxy >= height - this.sizey ? height - this.sizey : this.maxy;
                int MaxZ = this.maxz >= depth - this.sizez ? depth - this.sizez : this.maxz;
                sec = this.se.getSE();
                forward = this.se.getForward();
                backward = this.se.getBackward();
                switch (this.Type) {
                    case 8: {
                        int v;
                        int x;
                        int l;
                        int nbpixel;
                        int SumPixel;
                        int pos;
                        int y;
                        int z;
                        byte[] srcbb = this.dv.getDataBufferByte(this.channel);
                        byte[] resbb = this.dvres.getDataBufferByte(this.channel);
                        for (z = this.minz; z < this.maxz; ++z) {
                            y = this.miny;
                            pos = z * this.dv.LayerSize + y * width;
                            while (y < this.maxy) {
                                if (y < MinY || MaxY <= y || z < MinZ || MaxZ <= z) {
                                    SumPixel = 0;
                                    nbpixel = 0;
                                    for (l = 0; l < sec.length; ++l) {
                                        coord = sec[l];
                                        if (0 > coord.X || 0 > y + coord.Y || y + coord.Y >= height || 0 > z + coord.Z || z + coord.Z >= depth || (srcbb[pos + coord.Pos] & 0xFF) == ConvolutionFilter.this.ForbiddenValue) continue;
                                        SumPixel += srcbb[pos + coord.Pos] & 0xFF;
                                        ++nbpixel;
                                    }
                                    if ((srcbb[pos] & 0xFF) != ConvolutionFilter.this.ForbiddenValue) {
                                        resbb[pos] = (byte)((double)SumPixel / (double)nbpixel + 0.5);
                                    }
                                    for (x = 1; x <= MinX; ++x) {
                                        for (l = 0; l < forward.length; ++l) {
                                            coord = forward[l];
                                            if (x + coord.X >= width || 0 > y + coord.Y || y + coord.Y >= height || 0 > z + coord.Z || z + coord.Z >= depth || (srcbb[pos + coord.Pos + x] & 0xFF) == ConvolutionFilter.this.ForbiddenValue) continue;
                                            SumPixel += srcbb[pos + coord.Pos + x] & 0xFF;
                                            ++nbpixel;
                                        }
                                        for (l = 0; l < backward.length; ++l) {
                                            coord = backward[l];
                                            if (0 > x + coord.X || 0 > y + coord.Y || y + coord.Y >= height || 0 > z + coord.Z || z + coord.Z >= depth || (srcbb[pos + coord.Pos + x] & 0xFF) == ConvolutionFilter.this.ForbiddenValue) continue;
                                            SumPixel -= srcbb[pos + coord.Pos + x] & 0xFF;
                                            --nbpixel;
                                        }
                                        if ((srcbb[pos + x] & 0xFF) == ConvolutionFilter.this.ForbiddenValue) continue;
                                        resbb[pos + x] = (byte)((double)SumPixel / (double)nbpixel + 0.5);
                                    }
                                    while (x < MaxX) {
                                        for (l = 0; l < forward.length; ++l) {
                                            coord = forward[l];
                                            if (0 > y + coord.Y || y + coord.Y >= height || 0 > z + coord.Z || z + coord.Z >= depth || (srcbb[pos + coord.Pos + x] & 0xFF) == ConvolutionFilter.this.ForbiddenValue) continue;
                                            SumPixel += srcbb[pos + coord.Pos + x] & 0xFF;
                                            ++nbpixel;
                                        }
                                        for (l = 0; l < backward.length; ++l) {
                                            coord = backward[l];
                                            if (0 > y + coord.Y || y + coord.Y >= height || 0 > z + coord.Z || z + coord.Z >= depth || (srcbb[pos + coord.Pos + x] & 0xFF) == ConvolutionFilter.this.ForbiddenValue) continue;
                                            SumPixel -= srcbb[pos + coord.Pos + x] & 0xFF;
                                            --nbpixel;
                                        }
                                        if ((srcbb[pos + x] & 0xFF) != ConvolutionFilter.this.ForbiddenValue) {
                                            resbb[pos + x] = (byte)((double)SumPixel / (double)nbpixel + 0.5);
                                        }
                                        ++x;
                                    }
                                    while (x < this.maxx) {
                                        for (l = 0; l < forward.length; ++l) {
                                            coord = forward[l];
                                            if (x + coord.X >= width || 0 > y + coord.Y || y + coord.Y >= height || 0 > z + coord.Z || z + coord.Z >= depth || (srcbb[pos + coord.Pos + x] & 0xFF) == ConvolutionFilter.this.ForbiddenValue) continue;
                                            SumPixel += srcbb[pos + coord.Pos + x] & 0xFF;
                                            ++nbpixel;
                                        }
                                        for (l = 0; l < backward.length; ++l) {
                                            coord = backward[l];
                                            if (0 > y + coord.Y || y + coord.Y >= height || 0 > z + coord.Z || z + coord.Z >= depth || x + coord.X >= width || (srcbb[pos + coord.Pos + x] & 0xFF) == ConvolutionFilter.this.ForbiddenValue) continue;
                                            SumPixel -= srcbb[pos + coord.Pos + x] & 0xFF;
                                            --nbpixel;
                                        }
                                        if ((srcbb[pos + x] & 0xFF) != ConvolutionFilter.this.ForbiddenValue) {
                                            resbb[pos + x] = (byte)((double)SumPixel / (double)nbpixel + 0.5);
                                        }
                                        ++x;
                                    }
                                } else {
                                    SumPixel = 0;
                                    nbpixel = 0;
                                    for (l = 0; l < sec.length; ++l) {
                                        if (0 > sec[l].X || sec[l].X >= width || (srcbb[pos + sec[l].Pos] & 0xFF) == ConvolutionFilter.this.ForbiddenValue) continue;
                                        SumPixel += srcbb[pos + sec[l].Pos] & 0xFF;
                                        ++nbpixel;
                                    }
                                    if ((srcbb[pos] & 0xFF) != ConvolutionFilter.this.ForbiddenValue) {
                                        resbb[pos] = (byte)((double)SumPixel / (double)nbpixel + 0.5);
                                    }
                                    for (x = 1; x <= MinX; ++x) {
                                        for (l = 0; l < forward.length; ++l) {
                                            if (x + forward[l].X >= width || (srcbb[pos + forward[l].Pos + x] & 0xFF) == ConvolutionFilter.this.ForbiddenValue) continue;
                                            SumPixel += srcbb[pos + forward[l].Pos + x] & 0xFF;
                                            ++nbpixel;
                                        }
                                        for (l = 0; l < backward.length; ++l) {
                                            if (0 > x + backward[l].X || (srcbb[pos + backward[l].Pos + x] & 0xFF) == ConvolutionFilter.this.ForbiddenValue) continue;
                                            SumPixel -= srcbb[pos + backward[l].Pos + x] & 0xFF;
                                            --nbpixel;
                                        }
                                        if ((srcbb[pos + x] & 0xFF) == ConvolutionFilter.this.ForbiddenValue) continue;
                                        resbb[pos + x] = (byte)((double)SumPixel / (double)nbpixel + 0.5);
                                    }
                                    while (x < MaxX) {
                                        for (l = 0; l < forward.length; ++l) {
                                            v = srcbb[pos + forward[l].Pos + x] & 0xFF;
                                            if (v == ConvolutionFilter.this.ForbiddenValue) continue;
                                            SumPixel += v;
                                            ++nbpixel;
                                        }
                                        for (l = 0; l < backward.length; ++l) {
                                            v = srcbb[pos + backward[l].Pos + x] & 0xFF;
                                            if (v == ConvolutionFilter.this.ForbiddenValue) continue;
                                            SumPixel -= v;
                                            --nbpixel;
                                        }
                                        if ((srcbb[pos + x] & 0xFF) != ConvolutionFilter.this.ForbiddenValue) {
                                            resbb[pos + x] = (byte)((double)SumPixel / (double)nbpixel + 0.5);
                                        }
                                        ++x;
                                    }
                                    while (x < this.maxx) {
                                        for (l = 0; l < forward.length; ++l) {
                                            if (x + forward[l].X >= width || (srcbb[pos + forward[l].Pos + x] & 0xFF) == ConvolutionFilter.this.ForbiddenValue) continue;
                                            SumPixel += srcbb[pos + forward[l].Pos + x] & 0xFF;
                                            ++nbpixel;
                                        }
                                        for (l = 0; l < backward.length; ++l) {
                                            if (x + backward[l].X >= width || (srcbb[pos + backward[l].Pos + x] & 0xFF) == ConvolutionFilter.this.ForbiddenValue) continue;
                                            SumPixel -= srcbb[pos + backward[l].Pos + x] & 0xFF;
                                            --nbpixel;
                                        }
                                        if ((srcbb[pos + x] & 0xFF) != ConvolutionFilter.this.ForbiddenValue) {
                                            resbb[pos + x] = (byte)((double)SumPixel / (double)nbpixel + 0.5);
                                        }
                                        ++x;
                                    }
                                }
                                ++y;
                                pos += width;
                            }
                        }
                        resbb = null;
                        srcbb = null;
                        continue block10;
                    }
                    case 16: {
                        int v;
                        int x;
                        int l;
                        int nbpixel;
                        int SumPixel;
                        int pos;
                        int y;
                        int z;
                        short[] srcsb = this.dv.getDataBufferShort(this.channel);
                        short[] ressb = this.dvres.getDataBufferShort(this.channel);
                        for (z = this.minz; z < this.maxz; ++z) {
                            y = this.miny;
                            pos = z * this.dv.LayerSize + y * width;
                            while (y < this.maxy) {
                                if (y < MinY || MaxY <= y || z < MinZ || MaxZ <= z) {
                                    SumPixel = 0;
                                    nbpixel = 0;
                                    for (l = 0; l < sec.length; ++l) {
                                        coord = sec[l];
                                        if (0 > coord.X || 0 > y + coord.Y || y + coord.Y >= height || 0 > z + coord.Z || z + coord.Z >= depth || (srcsb[pos + coord.Pos] & 0xFFFF) == ConvolutionFilter.this.ForbiddenValue) continue;
                                        SumPixel += srcsb[pos + coord.Pos] & 0xFFFF;
                                        ++nbpixel;
                                    }
                                    if ((srcsb[pos] & 0xFF) != ConvolutionFilter.this.ForbiddenValue) {
                                        ressb[pos] = (short)((double)SumPixel / (double)nbpixel + 0.5);
                                    }
                                    for (x = 1; x <= MinX; ++x) {
                                        for (l = 0; l < forward.length; ++l) {
                                            coord = forward[l];
                                            if (x + coord.X >= width || 0 > y + coord.Y || y + coord.Y >= height || 0 > z + coord.Z || z + coord.Z >= depth || (srcsb[pos + coord.Pos + x] & 0xFFFF) == ConvolutionFilter.this.ForbiddenValue) continue;
                                            SumPixel += srcsb[pos + coord.Pos + x] & 0xFFFF;
                                            ++nbpixel;
                                        }
                                        for (l = 0; l < backward.length; ++l) {
                                            coord = backward[l];
                                            if (0 > x + coord.X || 0 > y + coord.Y || y + coord.Y >= height || 0 > z + coord.Z || z + coord.Z >= depth || (srcsb[pos + coord.Pos + x] & 0xFFFF) == ConvolutionFilter.this.ForbiddenValue) continue;
                                            SumPixel -= srcsb[pos + coord.Pos + x] & 0xFFFF;
                                            --nbpixel;
                                        }
                                        if ((srcsb[pos + x] & 0xFFFF) == ConvolutionFilter.this.ForbiddenValue) continue;
                                        ressb[pos + x] = (short)((double)SumPixel / (double)nbpixel + 0.5);
                                    }
                                    while (x < MaxX) {
                                        for (l = 0; l < forward.length; ++l) {
                                            coord = forward[l];
                                            if (0 > y + coord.Y || y + coord.Y >= height || 0 > z + coord.Z || z + coord.Z >= depth || (srcsb[pos + coord.Pos + x] & 0xFFFF) == ConvolutionFilter.this.ForbiddenValue) continue;
                                            SumPixel += srcsb[pos + coord.Pos + x] & 0xFFFF;
                                            ++nbpixel;
                                        }
                                        for (l = 0; l < backward.length; ++l) {
                                            coord = backward[l];
                                            if (0 > y + coord.Y || y + coord.Y >= height || 0 > z + coord.Z || z + coord.Z >= depth || (srcsb[pos + coord.Pos + x] & 0xFFFF) == ConvolutionFilter.this.ForbiddenValue) continue;
                                            SumPixel -= srcsb[pos + coord.Pos + x] & 0xFFFF;
                                            --nbpixel;
                                        }
                                        if ((srcsb[pos + x] & 0xFFFF) != ConvolutionFilter.this.ForbiddenValue) {
                                            ressb[pos + x] = (short)((double)SumPixel / (double)nbpixel + 0.5);
                                        }
                                        ++x;
                                    }
                                    while (x < this.maxx) {
                                        for (l = 0; l < forward.length; ++l) {
                                            coord = forward[l];
                                            if (x + coord.X >= width || 0 > y + coord.Y || y + coord.Y >= height || 0 > z + coord.Z || z + coord.Z >= depth || (srcsb[pos + coord.Pos + x] & 0xFFFF) == ConvolutionFilter.this.ForbiddenValue) continue;
                                            SumPixel += srcsb[pos + coord.Pos + x] & 0xFFFF;
                                            ++nbpixel;
                                        }
                                        for (l = 0; l < backward.length; ++l) {
                                            coord = backward[l];
                                            if (0 > y + coord.Y || y + coord.Y >= height || 0 > z + coord.Z || z + coord.Z >= depth || x + coord.X >= width || (srcsb[pos + coord.Pos + x] & 0xFFFF) == ConvolutionFilter.this.ForbiddenValue) continue;
                                            SumPixel -= srcsb[pos + coord.Pos + x] & 0xFFFF;
                                            --nbpixel;
                                        }
                                        if ((srcsb[pos + x] & 0xFFFF) != ConvolutionFilter.this.ForbiddenValue) {
                                            ressb[pos + x] = (short)((double)SumPixel / (double)nbpixel + 0.5);
                                        }
                                        ++x;
                                    }
                                } else {
                                    SumPixel = 0;
                                    nbpixel = 0;
                                    for (l = 0; l < sec.length; ++l) {
                                        if (0 > sec[l].X || sec[l].X >= width || (srcsb[pos + sec[l].Pos] & 0xFFFF) == ConvolutionFilter.this.ForbiddenValue) continue;
                                        SumPixel += srcsb[pos + sec[l].Pos] & 0xFFFF;
                                        ++nbpixel;
                                    }
                                    if ((srcsb[pos] & 0xFFFF) != ConvolutionFilter.this.ForbiddenValue) {
                                        ressb[pos] = (short)((double)SumPixel / (double)nbpixel + 0.5);
                                    }
                                    for (x = 1; x <= MinX; ++x) {
                                        for (l = 0; l < forward.length; ++l) {
                                            if (x + forward[l].X >= width || (srcsb[pos + forward[l].Pos + x] & 0xFFFF) == ConvolutionFilter.this.ForbiddenValue) continue;
                                            SumPixel += srcsb[pos + forward[l].Pos + x] & 0xFFFF;
                                            ++nbpixel;
                                        }
                                        for (l = 0; l < backward.length; ++l) {
                                            if (0 > x + backward[l].X || (srcsb[pos + backward[l].Pos + x] & 0xFFFF) == ConvolutionFilter.this.ForbiddenValue) continue;
                                            SumPixel -= srcsb[pos + backward[l].Pos + x] & 0xFFFF;
                                            --nbpixel;
                                        }
                                        if ((srcsb[pos + x] & 0xFFFF) == ConvolutionFilter.this.ForbiddenValue) continue;
                                        ressb[pos + x] = (short)((double)SumPixel / (double)nbpixel + 0.5);
                                    }
                                    while (x < MaxX) {
                                        for (l = 0; l < forward.length; ++l) {
                                            v = srcsb[pos + forward[l].Pos + x] & 0xFFFF;
                                            if (v == ConvolutionFilter.this.ForbiddenValue) continue;
                                            SumPixel += v;
                                            ++nbpixel;
                                        }
                                        for (l = 0; l < backward.length; ++l) {
                                            v = srcsb[pos + backward[l].Pos + x] & 0xFFFF;
                                            if (v == ConvolutionFilter.this.ForbiddenValue) continue;
                                            SumPixel -= v;
                                            --nbpixel;
                                        }
                                        if ((srcsb[pos + x] & 0xFFFF) != ConvolutionFilter.this.ForbiddenValue) {
                                            ressb[pos + x] = (short)((double)SumPixel / (double)nbpixel + 0.5);
                                        }
                                        ++x;
                                    }
                                    while (x < this.maxx) {
                                        for (l = 0; l < forward.length; ++l) {
                                            if (x + forward[l].X >= width || (srcsb[pos + forward[l].Pos + x] & 0xFFFF) == ConvolutionFilter.this.ForbiddenValue) continue;
                                            SumPixel += srcsb[pos + forward[l].Pos + x] & 0xFFFF;
                                            ++nbpixel;
                                        }
                                        for (l = 0; l < backward.length; ++l) {
                                            if (x + backward[l].X >= width || (srcsb[pos + backward[l].Pos + x] & 0xFFFF) == ConvolutionFilter.this.ForbiddenValue) continue;
                                            SumPixel -= srcsb[pos + backward[l].Pos + x] & 0xFF;
                                            --nbpixel;
                                        }
                                        if ((srcsb[pos + x] & 0xFFFF) != ConvolutionFilter.this.ForbiddenValue) {
                                            ressb[pos + x] = (short)((double)SumPixel / (double)nbpixel + 0.5);
                                        }
                                        ++x;
                                    }
                                }
                                ++y;
                                pos += width;
                            }
                        }
                        ressb = null;
                        srcsb = null;
                        continue block10;
                    }
                    case 32: {
                        int v;
                        int x;
                        int l;
                        int nbpixel;
                        int SumPixel;
                        int pos;
                        int y;
                        int z;
                        int[] srcib = this.dv.getDataBufferInt(this.channel);
                        int[] resib = this.dvres.getDataBufferInt(this.channel);
                        for (z = this.minz; z < this.maxz; ++z) {
                            y = this.miny;
                            pos = z * this.dv.LayerSize + y * width;
                            while (y < this.maxy) {
                                if (y < MinY || MaxY <= y || z < MinZ || MaxZ <= z) {
                                    SumPixel = 0;
                                    nbpixel = 0;
                                    for (l = 0; l < sec.length; ++l) {
                                        coord = sec[l];
                                        if (0 > coord.X || 0 > y + coord.Y || y + coord.Y >= height || 0 > z + coord.Z || z + coord.Z >= depth || srcib[pos + coord.Pos] == ConvolutionFilter.this.ForbiddenValue) continue;
                                        SumPixel += srcib[pos + coord.Pos];
                                        ++nbpixel;
                                    }
                                    if (srcib[pos] != ConvolutionFilter.this.ForbiddenValue) {
                                        resib[pos] = (int)((double)SumPixel / (double)nbpixel + 0.5);
                                    }
                                    for (x = 1; x <= MinX; ++x) {
                                        for (l = 0; l < forward.length; ++l) {
                                            coord = forward[l];
                                            if (x + coord.X >= width || 0 > y + coord.Y || y + coord.Y >= height || 0 > z + coord.Z || z + coord.Z >= depth || srcib[pos + coord.Pos + x] == ConvolutionFilter.this.ForbiddenValue) continue;
                                            SumPixel += srcib[pos + coord.Pos + x];
                                            ++nbpixel;
                                        }
                                        for (l = 0; l < backward.length; ++l) {
                                            coord = backward[l];
                                            if (0 > x + coord.X || 0 > y + coord.Y || y + coord.Y >= height || 0 > z + coord.Z || z + coord.Z >= depth || srcib[pos + coord.Pos + x] == ConvolutionFilter.this.ForbiddenValue) continue;
                                            SumPixel -= srcib[pos + coord.Pos + x];
                                            --nbpixel;
                                        }
                                        if (srcib[pos + x] == ConvolutionFilter.this.ForbiddenValue) continue;
                                        resib[pos + x] = (int)((double)SumPixel / (double)nbpixel + 0.5);
                                    }
                                    while (x < MaxX) {
                                        for (l = 0; l < forward.length; ++l) {
                                            coord = forward[l];
                                            if (0 > y + coord.Y || y + coord.Y >= height || 0 > z + coord.Z || z + coord.Z >= depth || srcib[pos + coord.Pos + x] == ConvolutionFilter.this.ForbiddenValue) continue;
                                            SumPixel += srcib[pos + coord.Pos + x];
                                            ++nbpixel;
                                        }
                                        for (l = 0; l < backward.length; ++l) {
                                            coord = backward[l];
                                            if (0 > y + coord.Y || y + coord.Y >= height || 0 > z + coord.Z || z + coord.Z >= depth || srcib[pos + coord.Pos + x] == ConvolutionFilter.this.ForbiddenValue) continue;
                                            SumPixel -= srcib[pos + coord.Pos + x];
                                            --nbpixel;
                                        }
                                        if (srcib[pos + x] != ConvolutionFilter.this.ForbiddenValue) {
                                            resib[pos + x] = (int)((double)SumPixel / (double)nbpixel + 0.5);
                                        }
                                        ++x;
                                    }
                                    while (x < this.maxx) {
                                        for (l = 0; l < forward.length; ++l) {
                                            coord = forward[l];
                                            if (x + coord.X >= width || 0 > y + coord.Y || y + coord.Y >= height || 0 > z + coord.Z || z + coord.Z >= depth || srcib[pos + coord.Pos + x] == ConvolutionFilter.this.ForbiddenValue) continue;
                                            SumPixel += srcib[pos + coord.Pos + x];
                                            ++nbpixel;
                                        }
                                        for (l = 0; l < backward.length; ++l) {
                                            coord = backward[l];
                                            if (0 > y + coord.Y || y + coord.Y >= height || 0 > z + coord.Z || z + coord.Z >= depth || x + coord.X >= width || srcib[pos + coord.Pos + x] == ConvolutionFilter.this.ForbiddenValue) continue;
                                            SumPixel -= srcib[pos + coord.Pos + x];
                                            --nbpixel;
                                        }
                                        if (srcib[pos + x] != ConvolutionFilter.this.ForbiddenValue) {
                                            resib[pos + x] = (int)((double)SumPixel / (double)nbpixel + 0.5);
                                        }
                                        ++x;
                                    }
                                } else {
                                    SumPixel = 0;
                                    nbpixel = 0;
                                    for (l = 0; l < sec.length; ++l) {
                                        if (0 > sec[l].X || sec[l].X >= width || srcib[pos + sec[l].Pos] == ConvolutionFilter.this.ForbiddenValue) continue;
                                        SumPixel += srcib[pos + sec[l].Pos];
                                        ++nbpixel;
                                    }
                                    if ((srcib[pos] & 0xFF) != ConvolutionFilter.this.ForbiddenValue) {
                                        resib[pos] = (int)((double)SumPixel / (double)nbpixel + 0.5);
                                    }
                                    for (x = 1; x <= MinX; ++x) {
                                        for (l = 0; l < forward.length; ++l) {
                                            if (x + forward[l].X >= width || srcib[pos + forward[l].Pos + x] == ConvolutionFilter.this.ForbiddenValue) continue;
                                            SumPixel += srcib[pos + forward[l].Pos + x];
                                            ++nbpixel;
                                        }
                                        for (l = 0; l < backward.length; ++l) {
                                            if (0 > x + backward[l].X || srcib[pos + backward[l].Pos + x] == ConvolutionFilter.this.ForbiddenValue) continue;
                                            SumPixel -= srcib[pos + backward[l].Pos + x];
                                            --nbpixel;
                                        }
                                        if (srcib[pos + x] == ConvolutionFilter.this.ForbiddenValue) continue;
                                        resib[pos + x] = (int)((double)SumPixel / (double)nbpixel + 0.5);
                                    }
                                    while (x < MaxX) {
                                        for (l = 0; l < forward.length; ++l) {
                                            v = srcib[pos + forward[l].Pos + x];
                                            if (v == ConvolutionFilter.this.ForbiddenValue) continue;
                                            SumPixel += v;
                                            ++nbpixel;
                                        }
                                        for (l = 0; l < backward.length; ++l) {
                                            v = srcib[pos + backward[l].Pos + x];
                                            if (v == ConvolutionFilter.this.ForbiddenValue) continue;
                                            SumPixel -= v;
                                            --nbpixel;
                                        }
                                        if (srcib[pos + x] != ConvolutionFilter.this.ForbiddenValue) {
                                            resib[pos + x] = (int)((double)SumPixel / (double)nbpixel + 0.5);
                                        }
                                        ++x;
                                    }
                                    while (x < this.maxx) {
                                        for (l = 0; l < forward.length; ++l) {
                                            if (x + forward[l].X >= width || srcib[pos + forward[l].Pos + x] == ConvolutionFilter.this.ForbiddenValue) continue;
                                            SumPixel += srcib[pos + forward[l].Pos + x];
                                            ++nbpixel;
                                        }
                                        for (l = 0; l < backward.length; ++l) {
                                            if (x + backward[l].X >= width || srcib[pos + backward[l].Pos + x] == ConvolutionFilter.this.ForbiddenValue) continue;
                                            SumPixel -= srcib[pos + backward[l].Pos + x];
                                            --nbpixel;
                                        }
                                        if (srcib[pos + x] != ConvolutionFilter.this.ForbiddenValue) {
                                            resib[pos + x] = (int)((double)SumPixel / (double)nbpixel + 0.5);
                                        }
                                        ++x;
                                    }
                                }
                                ++y;
                                pos += width;
                            }
                        }
                        resib = null;
                        srcib = null;
                        continue block10;
                    }
                }
                break;
            }
            throw new IllegalArgumentException("DV type not supported.");
        }
    }

    private class ConvolutionFilter3DFlatThread
    extends Thread {
        private int Type;
        private int sizex = -1;
        private int sizey = -1;
        private int sizez = -1;
        private StructuringElement3D se = null;
        private int channel = 0;
        private int minx;
        private int miny;
        private int minz;
        private int maxx;
        private int maxy;
        private int maxz;
        private DV dv;
        private DV dvres;
        private boolean Kill = false;
        public Object lock = new Object();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void Kill() {
            this.se = null;
            this.dvres = null;
            this.dv = null;
            this.Kill = true;
            Object object = this.lock;
            synchronized (object) {
                this.lock.notify();
            }
        }

        public void setConditions(DV source, int channel, DV result, StructuringElement3D se, int minx, int miny, int minz, int maxx, int maxy, int maxz) {
            this.dv = source;
            this.dvres = result;
            this.channel = channel;
            this.Type = source.Type;
            this.se = se;
            this.sizex = se.getSizeX() >> 1;
            this.sizey = se.getSizeY() >> 1;
            this.sizez = se.getSizeZ() >> 1;
            this.minx = minx;
            this.miny = miny;
            this.minz = minz;
            this.maxx = maxx;
            this.maxy = maxy;
            this.maxz = maxz;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            CoordinatesWeighted[] sec = null;
            CoordinatesWeighted[] forward = null;
            CoordinatesWeighted[] backward = null;
            CoordinatesWeighted coord = null;
            block12: while (true) {
                Object object = this.lock;
                synchronized (object) {
                    try {
                        ConvolutionFilter.this.addFreeThread();
                        this.lock.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                if (this.Kill) {
                    return;
                }
                int width = this.dv.SizeX;
                int height = this.dv.SizeY;
                int depth = this.dv.SizeZ;
                int MinX = this.minx < this.sizex ? this.sizex : this.minx;
                int MinY = this.miny < this.sizey ? this.sizey : this.miny;
                int MinZ = this.minz < this.sizez ? this.sizez : this.minz;
                int MaxX = this.maxx >= width - this.sizex ? width - this.sizex : this.maxx;
                int MaxY = this.maxy >= height - this.sizey ? height - this.sizey : this.maxy;
                int MaxZ = this.maxz >= depth - this.sizez ? depth - this.sizez : this.maxz;
                sec = this.se.getSE();
                forward = this.se.getForward();
                backward = this.se.getBackward();
                switch (this.Type) {
                    case 8: {
                        int x;
                        int l;
                        int nbpixel;
                        int SumPixel;
                        int pos;
                        int y;
                        int z;
                        byte[] srcbb = this.dv.getDataBufferByte(this.channel);
                        byte[] resbb = this.dvres.getDataBufferByte(this.channel);
                        for (z = this.minz; z < this.maxz; ++z) {
                            y = this.miny;
                            pos = z * this.dv.LayerSize + y * width;
                            while (y < this.maxy) {
                                if (y < MinY || MaxY <= y || z < MinZ || MaxZ <= z) {
                                    SumPixel = 0;
                                    nbpixel = 0;
                                    for (l = 0; l < sec.length; ++l) {
                                        coord = sec[l];
                                        if (0 > coord.X || coord.X >= width || 0 > y + coord.Y || y + coord.Y >= height || 0 > z + coord.Z || z + coord.Z >= depth) continue;
                                        SumPixel += srcbb[pos + coord.Pos] & 0xFF;
                                        ++nbpixel;
                                    }
                                    resbb[pos] = (byte)((double)SumPixel / (double)nbpixel + 0.5);
                                    for (x = 1; x <= MinX; ++x) {
                                        for (l = 0; l < forward.length; ++l) {
                                            coord = forward[l];
                                            if (0 > x + coord.X || x + coord.X >= width || 0 > y + coord.Y || y + coord.Y >= height || 0 > z + coord.Z || z + coord.Z >= depth) continue;
                                            SumPixel += srcbb[pos + coord.Pos + x] & 0xFF;
                                            ++nbpixel;
                                        }
                                        for (l = 0; l < backward.length; ++l) {
                                            coord = backward[l];
                                            if (0 > x + coord.X || 0 > y + coord.Y || y + coord.Y >= height || 0 > z + coord.Z || z + coord.Z >= depth) continue;
                                            SumPixel -= srcbb[pos + coord.Pos + x] & 0xFF;
                                            --nbpixel;
                                        }
                                        resbb[pos + x] = (byte)((double)SumPixel / (double)nbpixel + 0.5);
                                    }
                                    while (x < MaxX) {
                                        for (l = 0; l < forward.length; ++l) {
                                            coord = forward[l];
                                            if (0 > y + coord.Y || y + coord.Y >= height || 0 > z + coord.Z || z + coord.Z >= depth) continue;
                                            SumPixel += srcbb[pos + coord.Pos + x] & 0xFF;
                                            ++nbpixel;
                                        }
                                        for (l = 0; l < backward.length; ++l) {
                                            coord = backward[l];
                                            if (0 > y + coord.Y || y + coord.Y >= height || 0 > z + coord.Z || z + coord.Z >= depth) continue;
                                            SumPixel -= srcbb[pos + coord.Pos + x] & 0xFF;
                                            --nbpixel;
                                        }
                                        resbb[pos + x] = (byte)((double)SumPixel / (double)nbpixel + 0.5);
                                        ++x;
                                    }
                                    while (x < this.maxx) {
                                        for (l = 0; l < forward.length; ++l) {
                                            coord = forward[l];
                                            if (x + coord.X >= width || 0 > y + coord.Y || y + coord.Y >= height || 0 > z + coord.Z || z + coord.Z >= depth) continue;
                                            SumPixel += srcbb[pos + coord.Pos + x] & 0xFF;
                                            ++nbpixel;
                                        }
                                        for (l = 0; l < backward.length; ++l) {
                                            coord = backward[l];
                                            if (0 > y + coord.Y || y + coord.Y >= height || x + coord.X >= width || 0 > z + coord.Z || z + coord.Z >= depth) continue;
                                            SumPixel -= srcbb[pos + coord.Pos + x] & 0xFF;
                                            --nbpixel;
                                        }
                                        resbb[pos + x] = (byte)((double)SumPixel / (double)nbpixel + 0.5);
                                        ++x;
                                    }
                                } else {
                                    SumPixel = 0;
                                    nbpixel = 0;
                                    for (l = 0; l < sec.length; ++l) {
                                        if (0 > sec[l].X) continue;
                                        SumPixel += srcbb[pos + sec[l].Pos] & 0xFF;
                                        ++nbpixel;
                                    }
                                    resbb[pos] = (byte)((double)SumPixel / (double)nbpixel + 0.5);
                                    for (x = 1; x <= MinX; ++x) {
                                        for (l = 0; l < forward.length; ++l) {
                                            if (0 > x + forward[l].X || x + forward[l].X >= width) continue;
                                            SumPixel += srcbb[pos + forward[l].Pos + x] & 0xFF;
                                            ++nbpixel;
                                        }
                                        for (l = 0; l < backward.length; ++l) {
                                            if (0 > x + backward[l].X || x + backward[l].X >= width) continue;
                                            SumPixel -= srcbb[pos + backward[l].Pos + x] & 0xFF;
                                            --nbpixel;
                                        }
                                        resbb[pos + x] = (byte)((double)SumPixel / (double)nbpixel + 0.5);
                                    }
                                    while (x < MaxX) {
                                        for (l = 0; l < forward.length; ++l) {
                                            SumPixel += srcbb[pos + forward[l].Pos + x] & 0xFF;
                                            ++nbpixel;
                                        }
                                        for (l = 0; l < backward.length; ++l) {
                                            SumPixel -= srcbb[pos + backward[l].Pos + x] & 0xFF;
                                            --nbpixel;
                                        }
                                        resbb[pos + x] = (byte)((double)SumPixel / (double)nbpixel + 0.5);
                                        ++x;
                                    }
                                    while (x < this.maxx) {
                                        for (l = 0; l < forward.length; ++l) {
                                            if (x + forward[l].X >= width) continue;
                                            SumPixel += srcbb[pos + forward[l].Pos + x] & 0xFF;
                                            ++nbpixel;
                                        }
                                        for (l = 0; l < backward.length; ++l) {
                                            if (x + backward[l].X >= width) continue;
                                            SumPixel -= srcbb[pos + backward[l].Pos + x] & 0xFF;
                                            --nbpixel;
                                        }
                                        resbb[pos + x] = (byte)((double)SumPixel / (double)nbpixel + 0.5);
                                        ++x;
                                    }
                                }
                                ++y;
                                pos += width;
                            }
                        }
                        resbb = null;
                        srcbb = null;
                        continue block12;
                    }
                    case 16: {
                        int x;
                        int l;
                        int nbpixel;
                        int SumPixel;
                        int pos;
                        int y;
                        int z;
                        short[] srcsb = this.dv.getDataBufferShort(this.channel);
                        short[] ressb = this.dvres.getDataBufferShort(this.channel);
                        for (z = this.minz; z < this.maxz; ++z) {
                            y = this.miny;
                            pos = z * this.dv.LayerSize + y * width;
                            while (y < this.maxy) {
                                if (y < MinY || MaxY <= y || z < MinZ || MaxZ <= z) {
                                    SumPixel = 0;
                                    nbpixel = 0;
                                    for (l = 0; l < sec.length; ++l) {
                                        coord = sec[l];
                                        if (0 > coord.X || 0 > y + coord.Y || y + coord.Y >= height || 0 > z + coord.Z || z + coord.Z >= depth) continue;
                                        SumPixel += srcsb[pos + coord.Pos] & 0xFFFF;
                                        ++nbpixel;
                                    }
                                    ressb[pos] = (short)((double)SumPixel / (double)nbpixel + 0.5);
                                    for (x = 1; x <= MinX; ++x) {
                                        for (l = 0; l < forward.length; ++l) {
                                            coord = forward[l];
                                            if (x + coord.X >= width || 0 > y + coord.Y || y + coord.Y >= height || 0 > z + coord.Z || z + coord.Z >= depth) continue;
                                            SumPixel += srcsb[pos + coord.Pos + x] & 0xFFFF;
                                            ++nbpixel;
                                        }
                                        for (l = 0; l < backward.length; ++l) {
                                            coord = backward[l];
                                            if (0 > x + coord.X || 0 > y + coord.Y || y + coord.Y >= height || 0 > z + coord.Z || z + coord.Z >= depth) continue;
                                            SumPixel -= srcsb[pos + coord.Pos + x] & 0xFFFF;
                                            --nbpixel;
                                        }
                                        ressb[pos + x] = (short)((double)SumPixel / (double)nbpixel + 0.5);
                                    }
                                    while (x < MaxX) {
                                        for (l = 0; l < forward.length; ++l) {
                                            coord = forward[l];
                                            if (0 > y + coord.Y || y + coord.Y >= height || 0 > z + coord.Z || z + coord.Z >= depth) continue;
                                            SumPixel += srcsb[pos + coord.Pos + x] & 0xFFFF;
                                            ++nbpixel;
                                        }
                                        for (l = 0; l < backward.length; ++l) {
                                            coord = backward[l];
                                            if (0 > y + coord.Y || y + coord.Y >= height || 0 > z + coord.Z || z + coord.Z >= depth) continue;
                                            SumPixel -= srcsb[pos + coord.Pos + x] & 0xFFFF;
                                            --nbpixel;
                                        }
                                        ressb[pos + x] = (short)((double)SumPixel / (double)nbpixel + 0.5);
                                        ++x;
                                    }
                                    while (x < this.maxx) {
                                        for (l = 0; l < forward.length; ++l) {
                                            coord = forward[l];
                                            if (x + coord.X >= width || 0 > y + coord.Y || y + coord.Y >= height || 0 > z + coord.Z || z + coord.Z >= depth) continue;
                                            SumPixel += srcsb[pos + coord.Pos + x] & 0xFFFF;
                                            ++nbpixel;
                                        }
                                        for (l = 0; l < backward.length; ++l) {
                                            coord = backward[l];
                                            if (0 > y + coord.Y || y + coord.Y >= height || x + coord.X >= width || 0 > z + coord.Z || z + coord.Z >= depth) continue;
                                            SumPixel -= srcsb[pos + coord.Pos + x] & 0xFFFF;
                                            --nbpixel;
                                        }
                                        ressb[pos + x] = (short)((double)SumPixel / (double)nbpixel + 0.5);
                                        ++x;
                                    }
                                } else {
                                    SumPixel = 0;
                                    nbpixel = 0;
                                    for (l = 0; l < sec.length; ++l) {
                                        if (0 > sec[l].X) continue;
                                        SumPixel += srcsb[pos + sec[l].Pos] & 0xFFFF;
                                        ++nbpixel;
                                    }
                                    ressb[pos] = (short)((double)SumPixel / (double)nbpixel + 0.5);
                                    for (x = 1; x <= MinX; ++x) {
                                        for (l = 0; l < forward.length; ++l) {
                                            if (x + forward[l].X >= width) continue;
                                            SumPixel += srcsb[pos + forward[l].Pos + x] & 0xFFFF;
                                            ++nbpixel;
                                        }
                                        for (l = 0; l < backward.length; ++l) {
                                            if (0 > x + backward[l].X) continue;
                                            SumPixel -= srcsb[pos + backward[l].Pos + x] & 0xFFFF;
                                            --nbpixel;
                                        }
                                        ressb[pos + x] = (short)((double)SumPixel / (double)nbpixel + 0.5);
                                    }
                                    while (x < MaxX) {
                                        for (l = 0; l < forward.length; ++l) {
                                            SumPixel += srcsb[pos + forward[l].Pos + x] & 0xFFFF;
                                            ++nbpixel;
                                        }
                                        for (l = 0; l < backward.length; ++l) {
                                            SumPixel -= srcsb[pos + backward[l].Pos + x] & 0xFFFF;
                                            --nbpixel;
                                        }
                                        ressb[pos + x] = (short)((double)SumPixel / (double)nbpixel + 0.5);
                                        ++x;
                                    }
                                    while (x < this.maxx) {
                                        for (l = 0; l < forward.length; ++l) {
                                            if (x + forward[l].X >= width) continue;
                                            SumPixel += srcsb[pos + forward[l].Pos + x] & 0xFFFF;
                                            ++nbpixel;
                                        }
                                        for (l = 0; l < backward.length; ++l) {
                                            if (x + backward[l].X >= width) continue;
                                            SumPixel -= srcsb[pos + backward[l].Pos + x] & 0xFFFF;
                                            --nbpixel;
                                        }
                                        ressb[pos + x] = (short)((double)SumPixel / (double)nbpixel + 0.5);
                                        ++x;
                                    }
                                }
                                ++y;
                                pos += width;
                            }
                        }
                        ressb = null;
                        srcsb = null;
                        continue block12;
                    }
                    case 32: {
                        int x;
                        int l;
                        int nbpixel;
                        int SumPixel;
                        int pos;
                        int y;
                        int z;
                        int[] srcib = this.dv.getDataBufferInt(this.channel);
                        int[] resib = this.dvres.getDataBufferInt(this.channel);
                        for (z = this.minz; z < this.maxz; ++z) {
                            y = this.miny;
                            pos = z * this.dv.LayerSize + y * width;
                            while (y < this.maxy) {
                                if (y < MinY || MaxY <= y || z < MinZ || MaxZ <= z) {
                                    SumPixel = 0;
                                    nbpixel = 0;
                                    for (l = 0; l < sec.length; ++l) {
                                        coord = sec[l];
                                        if (0 > coord.X || 0 > y + coord.Y || y + coord.Y >= height || 0 > z + coord.Z || z + coord.Z >= depth) continue;
                                        SumPixel += srcib[pos + coord.Pos];
                                        ++nbpixel;
                                    }
                                    resib[pos] = (int)((double)SumPixel / (double)nbpixel + 0.5);
                                    for (x = 1; x <= MinX; ++x) {
                                        for (l = 0; l < forward.length; ++l) {
                                            coord = forward[l];
                                            if (x + coord.X >= width || 0 > y + coord.Y || y + coord.Y >= height || 0 > z + coord.Z || z + coord.Z >= depth) continue;
                                            SumPixel += srcib[pos + coord.Pos + x];
                                            ++nbpixel;
                                        }
                                        for (l = 0; l < backward.length; ++l) {
                                            coord = backward[l];
                                            if (0 > x + coord.X || 0 > y + coord.Y || y + coord.Y >= height || 0 > z + coord.Z || z + coord.Z >= depth) continue;
                                            SumPixel -= srcib[pos + coord.Pos + x];
                                            --nbpixel;
                                        }
                                        resib[pos + x] = (int)((double)SumPixel / (double)nbpixel + 0.5);
                                    }
                                    while (x < MaxX) {
                                        for (l = 0; l < forward.length; ++l) {
                                            coord = forward[l];
                                            if (0 > y + coord.Y || y + coord.Y >= height || 0 > z + coord.Z || z + coord.Z >= depth) continue;
                                            SumPixel += srcib[pos + coord.Pos + x];
                                            ++nbpixel;
                                        }
                                        for (l = 0; l < backward.length; ++l) {
                                            coord = backward[l];
                                            if (0 > y + coord.Y || y + coord.Y >= height || 0 > z + coord.Z || z + coord.Z >= depth) continue;
                                            SumPixel -= srcib[pos + coord.Pos + x];
                                            --nbpixel;
                                        }
                                        resib[pos + x] = (int)((double)SumPixel / (double)nbpixel + 0.5);
                                        ++x;
                                    }
                                    while (x < this.maxx) {
                                        for (l = 0; l < forward.length; ++l) {
                                            coord = forward[l];
                                            if (x + coord.X >= width || 0 > y + coord.Y || y + coord.Y >= height || 0 > z + coord.Z || z + coord.Z >= depth) continue;
                                            SumPixel += srcib[pos + coord.Pos + x];
                                            ++nbpixel;
                                        }
                                        for (l = 0; l < backward.length; ++l) {
                                            coord = backward[l];
                                            if (0 > y + coord.Y || y + coord.Y >= height || x + coord.X >= width || 0 > z + coord.Z || z + coord.Z >= depth) continue;
                                            SumPixel -= srcib[pos + coord.Pos + x];
                                            --nbpixel;
                                        }
                                        resib[pos + x] = (int)((double)SumPixel / (double)nbpixel + 0.5);
                                        ++x;
                                    }
                                } else {
                                    SumPixel = 0;
                                    nbpixel = 0;
                                    for (l = 0; l < sec.length; ++l) {
                                        if (0 > sec[l].X) continue;
                                        SumPixel += srcib[pos + sec[l].Pos];
                                        ++nbpixel;
                                    }
                                    resib[pos] = (int)((double)SumPixel / (double)nbpixel + 0.5);
                                    for (x = 1; x <= MinX; ++x) {
                                        for (l = 0; l < forward.length; ++l) {
                                            if (x + forward[l].X >= width) continue;
                                            SumPixel += srcib[pos + forward[l].Pos + x];
                                            ++nbpixel;
                                        }
                                        for (l = 0; l < backward.length; ++l) {
                                            if (0 > x + backward[l].X) continue;
                                            SumPixel -= srcib[pos + backward[l].Pos + x];
                                            --nbpixel;
                                        }
                                        resib[pos + x] = (int)((double)SumPixel / (double)nbpixel + 0.5);
                                    }
                                    while (x < MaxX) {
                                        for (l = 0; l < forward.length; ++l) {
                                            SumPixel += srcib[pos + forward[l].Pos + x];
                                            ++nbpixel;
                                        }
                                        for (l = 0; l < backward.length; ++l) {
                                            SumPixel -= srcib[pos + backward[l].Pos + x];
                                            --nbpixel;
                                        }
                                        resib[pos + x] = (int)((double)SumPixel / (double)nbpixel + 0.5);
                                        ++x;
                                    }
                                    while (x < this.maxx) {
                                        for (l = 0; l < forward.length; ++l) {
                                            if (x + forward[l].X >= width) continue;
                                            SumPixel += srcib[pos + forward[l].Pos + x];
                                            ++nbpixel;
                                        }
                                        for (l = 0; l < backward.length; ++l) {
                                            if (x + backward[l].X >= width) continue;
                                            SumPixel -= srcib[pos + backward[l].Pos + x];
                                            --nbpixel;
                                        }
                                        resib[pos + x] = (int)((double)SumPixel / (double)nbpixel + 0.5);
                                        ++x;
                                    }
                                }
                                ++y;
                                pos += width;
                            }
                        }
                        resib = null;
                        srcib = null;
                        continue block12;
                    }
                    case -32: {
                        double SumPixelD;
                        int x;
                        int l;
                        int nbpixel;
                        int pos;
                        int y;
                        int z;
                        float[] srcfb = this.dv.getDataBufferFloat(this.channel);
                        float[] resfb = this.dvres.getDataBufferFloat(this.channel);
                        for (z = this.minz; z < this.maxz; ++z) {
                            y = this.miny;
                            pos = z * this.dv.LayerSize + y * width;
                            while (y < this.maxy) {
                                if (y < MinY || MaxY <= y || z < MinZ || MaxZ <= z) {
                                    SumPixelD = 0.0;
                                    nbpixel = 0;
                                    for (l = 0; l < sec.length; ++l) {
                                        coord = sec[l];
                                        if (0 > coord.X || 0 > y + coord.Y || y + coord.Y >= height || 0 > z + coord.Z || z + coord.Z >= depth) continue;
                                        SumPixelD += (double)srcfb[pos + coord.Pos];
                                        ++nbpixel;
                                    }
                                    resfb[pos] = (float)(SumPixelD / (double)nbpixel);
                                    for (x = 1; x <= MinX; ++x) {
                                        for (l = 0; l < forward.length; ++l) {
                                            coord = forward[l];
                                            if (x + coord.X >= width || 0 > y + coord.Y || y + coord.Y >= height || 0 > z + coord.Z || z + coord.Z >= depth) continue;
                                            SumPixelD += (double)srcfb[pos + coord.Pos + x];
                                            ++nbpixel;
                                        }
                                        for (l = 0; l < backward.length; ++l) {
                                            coord = backward[l];
                                            if (0 > x + coord.X || 0 > y + coord.Y || y + coord.Y >= height || 0 > z + coord.Z || z + coord.Z >= depth) continue;
                                            SumPixelD -= (double)srcfb[pos + coord.Pos + x];
                                            --nbpixel;
                                        }
                                        resfb[pos + x] = (float)(SumPixelD / (double)nbpixel);
                                    }
                                    while (x < MaxX) {
                                        for (l = 0; l < forward.length; ++l) {
                                            coord = forward[l];
                                            if (0 > y + coord.Y || y + coord.Y >= height || 0 > z + coord.Z || z + coord.Z >= depth) continue;
                                            SumPixelD += (double)srcfb[pos + coord.Pos + x];
                                            ++nbpixel;
                                        }
                                        for (l = 0; l < backward.length; ++l) {
                                            coord = backward[l];
                                            if (0 > y + coord.Y || y + coord.Y >= height || 0 > z + coord.Z || z + coord.Z >= depth) continue;
                                            SumPixelD -= (double)srcfb[pos + coord.Pos + x];
                                            --nbpixel;
                                        }
                                        resfb[pos + x] = (float)(SumPixelD / (double)nbpixel + 0.5);
                                        ++x;
                                    }
                                    while (x < this.maxx) {
                                        for (l = 0; l < forward.length; ++l) {
                                            coord = forward[l];
                                            if (x + coord.X >= width || 0 > y + coord.Y || y + coord.Y >= height || 0 > z + coord.Z || z + coord.Z >= depth) continue;
                                            SumPixelD += (double)srcfb[pos + coord.Pos + x];
                                            ++nbpixel;
                                        }
                                        for (l = 0; l < backward.length; ++l) {
                                            coord = backward[l];
                                            if (0 > y + coord.Y || y + coord.Y >= height || x + coord.X >= width || 0 > z + coord.Z || z + coord.Z >= depth) continue;
                                            SumPixelD -= (double)srcfb[pos + coord.Pos + x];
                                            --nbpixel;
                                        }
                                        resfb[pos + x] = (float)(SumPixelD / (double)nbpixel);
                                        ++x;
                                    }
                                } else {
                                    SumPixelD = 0.0;
                                    nbpixel = 0;
                                    for (l = 0; l < sec.length; ++l) {
                                        if (0 > sec[l].X) continue;
                                        SumPixelD += (double)srcfb[pos + sec[l].Pos];
                                        ++nbpixel;
                                    }
                                    resfb[pos] = (float)(SumPixelD / (double)nbpixel + 0.5);
                                    for (x = 1; x <= MinX; ++x) {
                                        for (l = 0; l < forward.length; ++l) {
                                            if (x + forward[l].X >= width) continue;
                                            SumPixelD += (double)srcfb[pos + forward[l].Pos + x];
                                            ++nbpixel;
                                        }
                                        for (l = 0; l < backward.length; ++l) {
                                            if (0 > x + backward[l].X) continue;
                                            SumPixelD -= (double)srcfb[pos + backward[l].Pos + x];
                                            --nbpixel;
                                        }
                                        resfb[pos + x] = (float)(SumPixelD / (double)nbpixel);
                                    }
                                    while (x < MaxX) {
                                        for (l = 0; l < forward.length; ++l) {
                                            SumPixelD += (double)srcfb[pos + forward[l].Pos + x];
                                            ++nbpixel;
                                        }
                                        for (l = 0; l < backward.length; ++l) {
                                            SumPixelD -= (double)srcfb[pos + backward[l].Pos + x];
                                            --nbpixel;
                                        }
                                        resfb[pos + x] = (float)(SumPixelD / (double)nbpixel);
                                        ++x;
                                    }
                                    while (x < this.maxx) {
                                        for (l = 0; l < forward.length; ++l) {
                                            if (x + forward[l].X >= width) continue;
                                            SumPixelD += (double)srcfb[pos + forward[l].Pos + x];
                                            ++nbpixel;
                                        }
                                        for (l = 0; l < backward.length; ++l) {
                                            if (x + backward[l].X >= width) continue;
                                            SumPixelD -= (double)srcfb[pos + backward[l].Pos + x];
                                            --nbpixel;
                                        }
                                        resfb[pos + x] = (float)(SumPixelD / (double)nbpixel);
                                        ++x;
                                    }
                                }
                                ++y;
                                pos += width;
                            }
                        }
                        resfb = null;
                        srcfb = null;
                        continue block12;
                    }
                    case 64: {
                        double SumPixelD;
                        int x;
                        int l;
                        int nbpixel;
                        int pos;
                        int y;
                        int z;
                        double[] srcdb = this.dv.getDataBufferDouble(this.channel);
                        double[] resdb = this.dvres.getDataBufferDouble(this.channel);
                        for (z = this.minz; z < this.maxz; ++z) {
                            y = this.miny;
                            pos = z * this.dv.LayerSize + y * width;
                            while (y < this.maxy) {
                                if (y < MinY || MaxY <= y || z < MinZ || MaxZ <= z) {
                                    SumPixelD = 0.0;
                                    nbpixel = 0;
                                    for (l = 0; l < sec.length; ++l) {
                                        coord = sec[l];
                                        if (0 > coord.X || 0 > y + coord.Y || y + coord.Y >= height || 0 > z + coord.Z || z + coord.Z >= depth) continue;
                                        SumPixelD += srcdb[pos + coord.Pos];
                                        ++nbpixel;
                                    }
                                    resdb[pos] = SumPixelD / (double)nbpixel;
                                    for (x = 1; x <= MinX; ++x) {
                                        for (l = 0; l < forward.length; ++l) {
                                            coord = forward[l];
                                            if (x + coord.X >= width || 0 > y + coord.Y || y + coord.Y >= height || 0 > z + coord.Z || z + coord.Z >= depth) continue;
                                            SumPixelD += srcdb[pos + coord.Pos + x];
                                            ++nbpixel;
                                        }
                                        for (l = 0; l < backward.length; ++l) {
                                            coord = backward[l];
                                            if (0 > x + coord.X || 0 > y + coord.Y || y + coord.Y >= height || 0 > z + coord.Z || z + coord.Z >= depth) continue;
                                            SumPixelD -= srcdb[pos + coord.Pos + x];
                                            --nbpixel;
                                        }
                                        resdb[pos + x] = SumPixelD / (double)nbpixel;
                                    }
                                    while (x < MaxX) {
                                        for (l = 0; l < forward.length; ++l) {
                                            coord = forward[l];
                                            if (0 > y + coord.Y || y + coord.Y >= height || 0 > z + coord.Z || z + coord.Z >= depth) continue;
                                            SumPixelD += srcdb[pos + coord.Pos + x];
                                            ++nbpixel;
                                        }
                                        for (l = 0; l < backward.length; ++l) {
                                            coord = backward[l];
                                            if (0 > y + coord.Y || y + coord.Y >= height || 0 > z + coord.Z || z + coord.Z >= depth) continue;
                                            SumPixelD -= srcdb[pos + coord.Pos + x];
                                            --nbpixel;
                                        }
                                        resdb[pos + x] = SumPixelD / (double)nbpixel;
                                        ++x;
                                    }
                                    while (x < this.maxx) {
                                        for (l = 0; l < forward.length; ++l) {
                                            coord = forward[l];
                                            if (x + coord.X >= width || 0 > y + coord.Y || y + coord.Y >= height || 0 > z + coord.Z || z + coord.Z >= depth) continue;
                                            SumPixelD += srcdb[pos + coord.Pos + x];
                                            ++nbpixel;
                                        }
                                        for (l = 0; l < backward.length; ++l) {
                                            coord = backward[l];
                                            if (0 > y + coord.Y || y + coord.Y >= height || x + coord.X >= width || 0 > z + coord.Z || z + coord.Z >= depth) continue;
                                            SumPixelD -= srcdb[pos + coord.Pos + x];
                                            --nbpixel;
                                        }
                                        resdb[pos + x] = SumPixelD / (double)nbpixel;
                                        ++x;
                                    }
                                } else {
                                    SumPixelD = 0.0;
                                    nbpixel = 0;
                                    for (l = 0; l < sec.length; ++l) {
                                        if (0 > sec[l].X) continue;
                                        SumPixelD += srcdb[pos + sec[l].Pos];
                                        ++nbpixel;
                                    }
                                    resdb[pos] = SumPixelD / (double)nbpixel;
                                    for (x = 1; x <= MinX; ++x) {
                                        for (l = 0; l < forward.length; ++l) {
                                            if (x + forward[l].X >= width) continue;
                                            SumPixelD += srcdb[pos + forward[l].Pos + x];
                                            ++nbpixel;
                                        }
                                        for (l = 0; l < backward.length; ++l) {
                                            if (0 > x + backward[l].X) continue;
                                            SumPixelD -= srcdb[pos + backward[l].Pos + x];
                                            --nbpixel;
                                        }
                                        resdb[pos + x] = SumPixelD / (double)nbpixel;
                                    }
                                    while (x < MaxX) {
                                        for (l = 0; l < forward.length; ++l) {
                                            SumPixelD += srcdb[pos + forward[l].Pos + x];
                                            ++nbpixel;
                                        }
                                        for (l = 0; l < backward.length; ++l) {
                                            SumPixelD -= srcdb[pos + backward[l].Pos + x];
                                            --nbpixel;
                                        }
                                        resdb[pos + x] = SumPixelD / (double)nbpixel;
                                        ++x;
                                    }
                                    while (x < this.maxx) {
                                        for (l = 0; l < forward.length; ++l) {
                                            if (x + forward[l].X >= width) continue;
                                            SumPixelD += srcdb[pos + forward[l].Pos + x];
                                            ++nbpixel;
                                        }
                                        for (l = 0; l < backward.length; ++l) {
                                            if (x + backward[l].X >= width) continue;
                                            SumPixelD -= srcdb[pos + backward[l].Pos + x];
                                            --nbpixel;
                                        }
                                        resdb[pos + x] = SumPixelD / (double)nbpixel;
                                        ++x;
                                    }
                                }
                                ++y;
                                pos += width;
                            }
                        }
                        resdb = null;
                        srcdb = null;
                        continue block12;
                    }
                }
                break;
            }
            throw new IllegalArgumentException("DV type not supported.");
        }
    }

    private class ConvolutionFilter3DThread
    extends Thread {
        private DV dv = null;
        private DV dvres = null;
        private int Type;
        private int channel = 0;
        private int sizex = -1;
        private int sizey = -1;
        private int sizez = -1;
        private StructuringElement3D se = null;
        private int minx;
        private int miny;
        private int minz;
        private int maxx;
        private int maxy;
        private int maxz;
        private boolean Kill = false;
        public Object lock = new Object();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void Kill() {
            this.se = null;
            this.dvres = null;
            this.dv = null;
            this.Kill = true;
            Object object = this.lock;
            synchronized (object) {
                this.lock.notify();
            }
        }

        public void setConditions(DV source, int channel, DV result, StructuringElement3D se, int minx, int miny, int minz, int maxx, int maxy, int maxz) {
            this.dv = source;
            this.channel = channel;
            this.dvres = result;
            this.Type = source.Type;
            this.se = se;
            this.sizex = se.getSizeX() >> 1;
            this.sizey = se.getSizeY() >> 1;
            this.sizez = se.getSizeZ() >> 1;
            this.minx = minx;
            this.miny = miny;
            this.minz = minz;
            this.maxx = maxx;
            this.maxy = maxy;
            this.maxz = maxz;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block12: while (true) {
                Object object = this.lock;
                synchronized (object) {
                    try {
                        ConvolutionFilter.this.addFreeThread();
                        this.lock.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                if (this.Kill) {
                    return;
                }
                int width = this.dv.SizeX;
                int height = this.dv.SizeY;
                int depth = this.dv.SizeZ;
                int MinX = this.minx < this.sizex ? this.sizex : this.minx;
                int MinY = this.miny < this.sizey ? this.sizey : this.miny;
                int MinZ = this.minz < this.sizez ? this.sizez : this.minz;
                int MaxX = this.maxx >= width - this.sizex ? width - this.sizex : this.maxx;
                int MaxY = this.maxy >= height - this.sizey ? height - this.sizey : this.maxy;
                int MaxZ = this.maxz >= depth - this.sizez ? depth - this.sizez : this.maxz;
                int widthminussizex = width - this.sizex;
                int heightminussizey = height - this.sizey;
                int depthminussizez = depth - this.sizez;
                int popy = width - MaxX + MinX;
                int popz = (height - MaxY + MinY) * width;
                CoordinatesWeighted[] cws = this.se.getSE();
                switch (this.Type) {
                    case 8: {
                        byte[] srcbb = this.dv.getDataBufferByte(this.channel);
                        byte[] resbb = this.dvres.getDataBufferByte(this.channel);
                        int z = MinZ;
                        int pos = MinZ * this.dv.LayerSize + MinY * width + MinX;
                        while (z < MaxZ) {
                            int y = MinY;
                            while (y < MaxY) {
                                int x = MinX;
                                while (x < MaxX) {
                                    double Val = 0.0;
                                    for (CoordinatesWeighted coord : cws) {
                                        Val += (double)(srcbb[pos + coord.Pos] & 0xFF) * coord.Wd;
                                    }
                                    resbb[pos] = (byte)(Val + 0.5);
                                    ++x;
                                    ++pos;
                                }
                                ++y;
                                pos += popy;
                            }
                            ++z;
                            pos += popz;
                        }
                        for (z = this.minz; z < this.maxz; ++z) {
                            if (z >= this.sizez && depthminussizez > z) continue;
                            for (int y = this.miny; y < this.maxy; ++y) {
                                if (y >= this.sizey && heightminussizey > y) continue;
                                for (int x = this.minx; x < this.maxx; ++x) {
                                    if (x >= this.sizex && widthminussizex > x) continue;
                                    double Val = 0.0;
                                    double Sum2 = 0.0;
                                    int pos2 = x + y * width + z * this.dv.LayerSize;
                                    for (CoordinatesWeighted coord : cws) {
                                        int dx = x + coord.X;
                                        int dy = y + coord.Y;
                                        int dz = z + coord.Z;
                                        if (0 > dx || dx >= width || 0 > dy || dy >= height || 0 > dz || dz >= depth) continue;
                                        Val += (double)(srcbb[pos2 + coord.Pos] & 0xFF) * coord.Wd;
                                        Sum2 += coord.Wd;
                                    }
                                    resbb[pos2] = (byte)(Val / Sum2 + 0.5);
                                }
                            }
                        }
                        resbb = null;
                        srcbb = null;
                        continue block12;
                    }
                    case 16: {
                        short[] srcsb = this.dv.getDataBufferShort(this.channel);
                        short[] ressb = this.dvres.getDataBufferShort(this.channel);
                        int z = MinZ;
                        int pos = MinZ * this.dv.LayerSize + MinY * width + MinX;
                        while (z < MaxZ) {
                            int y = MinY;
                            while (y < MaxY) {
                                int x = MinX;
                                while (x < MaxX) {
                                    double Val = 0.0;
                                    for (CoordinatesWeighted cw : cws) {
                                        Val += (double)(srcsb[pos + cw.Pos] & 0xFFFF) * cw.Wd;
                                    }
                                    ressb[pos] = (short)(Val + 0.5);
                                    ++x;
                                    ++pos;
                                }
                                ++y;
                                pos += popy;
                            }
                            ++z;
                            pos += popz;
                        }
                        for (z = this.minz; z < this.maxz; ++z) {
                            if (z >= this.sizez && depthminussizez > z) continue;
                            for (int y = this.miny; y < this.maxy; ++y) {
                                if (y >= this.sizey && heightminussizey > y) continue;
                                for (int x = this.minx; x < this.maxx; ++x) {
                                    if (x >= this.sizex && widthminussizex > x) continue;
                                    double Val = 0.0;
                                    double Sum3 = 0.0;
                                    int pos3 = x + y * width + z * this.dv.LayerSize;
                                    for (CoordinatesWeighted cw : cws) {
                                        int dx = x + cw.X;
                                        int dy = y + cw.Y;
                                        int dz = z + cw.Z;
                                        if (0 > dx || dx >= width || 0 > dy || dy >= height || 0 > dz || dz >= depth) continue;
                                        Val += (double)(srcsb[pos3 + cw.Pos] & 0xFFFF) * cw.Wd;
                                        Sum3 += cw.Wd;
                                    }
                                    ressb[pos3] = (short)(Val / Sum3 + 0.5);
                                }
                            }
                        }
                        ressb = null;
                        srcsb = null;
                        continue block12;
                    }
                    case 32: {
                        int[] srcib = this.dv.getDataBufferInt(this.channel);
                        int[] resib = this.dvres.getDataBufferInt(this.channel);
                        int z = MinZ;
                        int pos = MinZ * this.dv.LayerSize + MinY * width + MinX;
                        while (z < MaxZ) {
                            int y = MinY;
                            while (y < MaxY) {
                                int x = MinX;
                                while (x < MaxX) {
                                    double Val = 0.0;
                                    for (CoordinatesWeighted cw : cws) {
                                        Val += (double)srcib[pos + cw.Pos] * cw.Wd;
                                    }
                                    resib[pos] = (int)(Val + 0.5);
                                    ++x;
                                    ++pos;
                                }
                                ++y;
                                pos += popy;
                            }
                            ++z;
                            pos += popz;
                        }
                        for (z = this.minz; z < this.maxz; ++z) {
                            if (z >= this.sizez && depthminussizez > z) continue;
                            for (int y = this.miny; y < this.maxy; ++y) {
                                if (y >= this.sizey && heightminussizey > y) continue;
                                for (int x = this.minx; x < this.maxx; ++x) {
                                    if (x >= this.sizex && widthminussizex > x) continue;
                                    double Val = 0.0;
                                    double Sum4 = 0.0;
                                    int pos4 = x + y * width + z * this.dv.LayerSize;
                                    for (CoordinatesWeighted cw : cws) {
                                        int dx = x + cw.X;
                                        int dy = y + cw.Y;
                                        int dz = z + cw.Z;
                                        if (0 > dx || dx >= width || 0 > dy || dy >= height || 0 > dz || dz >= depth) continue;
                                        Val += (double)srcib[pos4 + cw.Pos] * cw.Wd;
                                        Sum4 += cw.Wd;
                                    }
                                    resib[pos4] = (int)(Val / Sum4 + 0.5);
                                }
                            }
                        }
                        resib = null;
                        srcib = null;
                        continue block12;
                    }
                    case -32: {
                        float[] srcfb = this.dv.getDataBufferFloat(this.channel);
                        float[] resfb = this.dvres.getDataBufferFloat(this.channel);
                        int z = MinZ;
                        int pos = MinZ * this.dv.LayerSize + MinY * width + MinX;
                        while (z < MaxZ) {
                            int y = MinY;
                            while (y < MaxY) {
                                int x = MinX;
                                while (x < MaxX) {
                                    double Val = 0.0;
                                    for (CoordinatesWeighted cw : cws) {
                                        Val += (double)srcfb[pos + cw.Pos] * cw.Wd;
                                    }
                                    resfb[pos] = (float)Val;
                                    ++x;
                                    ++pos;
                                }
                                ++y;
                                pos += popy;
                            }
                            ++z;
                            pos += popz;
                        }
                        for (z = this.minz; z < this.maxz; ++z) {
                            if (z >= this.sizez && depthminussizez > z) continue;
                            for (int y = this.miny; y < this.maxy; ++y) {
                                if (y >= this.sizey && heightminussizey > y) continue;
                                for (int x = this.minx; x < this.maxx; ++x) {
                                    if (x >= this.sizex && widthminussizex > x) continue;
                                    double Val = 0.0;
                                    double Sum5 = 0.0;
                                    int pos5 = x + y * width + z * this.dv.LayerSize;
                                    for (CoordinatesWeighted cw : cws) {
                                        int dx = x + cw.X;
                                        int dy = y + cw.Y;
                                        int dz = z + cw.Z;
                                        if (0 > dx || dx >= width || 0 > dy || dy >= height || 0 > dz || dz >= depth) continue;
                                        Val += (double)srcfb[pos5 + cw.Pos] * cw.Wd;
                                        Sum5 += cw.Wd;
                                    }
                                    resfb[pos5] = (float)(Val / Sum5);
                                }
                            }
                        }
                        resfb = null;
                        srcfb = null;
                        continue block12;
                    }
                    case 64: {
                        double[] srcdb = this.dv.getDataBufferDouble(this.channel);
                        double[] resdb = this.dvres.getDataBufferDouble(this.channel);
                        int z = MinZ;
                        int pos = MinZ * this.dv.LayerSize + MinY * width + MinX;
                        while (z < MaxZ) {
                            int y = MinY;
                            while (y < MaxY) {
                                int x = MinX;
                                while (x < MaxX) {
                                    double Val = 0.0;
                                    for (CoordinatesWeighted cw : cws) {
                                        Val += srcdb[pos + cw.Pos] * cw.Wd;
                                    }
                                    resdb[pos] = Val;
                                    ++x;
                                    ++pos;
                                }
                                ++y;
                                pos += popy;
                            }
                            ++z;
                            pos += popz;
                        }
                        for (z = this.minz; z < this.maxz; ++z) {
                            if (z >= this.sizez && depthminussizez > z) continue;
                            for (int y = this.miny; y < this.maxy; ++y) {
                                if (y >= this.sizey && heightminussizey > y) continue;
                                for (int x = this.minx; x < this.maxx; ++x) {
                                    if (x >= this.sizex && widthminussizex > x) continue;
                                    double Val = 0.0;
                                    double Sum6 = 0.0;
                                    int pos6 = x + y * width + z * this.dv.LayerSize;
                                    for (CoordinatesWeighted cw : cws) {
                                        int dx = x + cw.X;
                                        int dy = y + cw.Y;
                                        int dz = z + cw.Z;
                                        if (0 > dx || dx >= width || 0 > dy || dy >= height || 0 > dz || dz >= depth) continue;
                                        Val += srcdb[pos6 + cw.Pos] * cw.Wd;
                                        Sum6 += cw.Wd;
                                    }
                                    resdb[pos6] = Val / Sum6;
                                }
                            }
                        }
                        resdb = null;
                        srcdb = null;
                        continue block12;
                    }
                }
                break;
            }
            throw new IllegalArgumentException("DV type not supported.");
        }
    }

    private class ConvolutionFilterDoubleThread
    extends Thread {
        private double[][] src = null;
        private double[][] res = null;
        private int sizex = -1;
        private int sizey = -1;
        private StructuringElement se = null;
        private int minx;
        private int miny;
        private int maxx;
        private int maxy;
        private boolean Kill = false;
        public Object lock = new Object();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void Kill() {
            this.se = null;
            this.res = null;
            this.src = null;
            this.Kill = true;
            Object object = this.lock;
            synchronized (object) {
                this.lock.notify();
            }
        }

        public void setConditions(double[][] source, double[][] result, StructuringElement se, int minx, int miny, int maxx, int maxy) {
            this.src = source;
            this.res = result;
            this.se = se;
            this.sizex = se.getSizeX() >> 1;
            this.sizey = se.getSizeY() >> 1;
            this.minx = minx;
            this.miny = miny;
            this.maxx = maxx;
            this.maxy = maxy;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            CoordinatesWeighted[] cws = null;
            CoordinatesWeighted cw = null;
            block5: while (true) {
                int c;
                double Val;
                int x;
                int y;
                Object object = this.lock;
                synchronized (object) {
                    try {
                        ConvolutionFilter.this.addFreeThread();
                        this.lock.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                if (this.Kill) {
                    return;
                }
                int width = this.src[0].length;
                int height = this.src.length;
                int MinX = this.minx < this.sizex ? this.sizex : this.minx;
                int MinY = this.miny < this.sizey ? this.sizey : this.miny;
                int MaxX = this.maxx >= width - this.sizex ? width - this.sizex : this.maxx;
                int MaxY = this.maxy >= height - this.sizey ? height - this.sizey : this.maxy;
                int widthminussizex = width - this.sizex;
                int heightminussizey = height - this.sizey;
                cws = this.se.getSE();
                for (y = MinY; y < MaxY; ++y) {
                    for (x = MinX; x < MaxX; ++x) {
                        Val = 0.0;
                        for (c = 0; c < cws.length; ++c) {
                            cw = cws[c];
                            Val += this.src[y + cw.Y][x + cw.X] * cw.Wd;
                            cw = null;
                        }
                        this.res[y][x] = Val;
                    }
                }
                y = this.miny;
                while (true) {
                    if (y >= this.maxy) continue block5;
                    if (y < this.sizey || heightminussizey <= y) {
                        for (x = this.minx; x < this.maxx; ++x) {
                            if (x >= this.sizex && widthminussizex > x) continue;
                            double Sum2 = 0.0;
                            Val = 0.0;
                            for (c = 0; c < cws.length; ++c) {
                                cw = cws[c];
                                int dx = x + cw.X;
                                int dy = y + cw.Y;
                                if (0 <= dx && dx < width && 0 <= dy && dy < height) {
                                    Val += this.src[dy][dx] * cw.Wd;
                                    Sum2 += cw.Wd;
                                }
                                cw = null;
                            }
                            this.res[y][x] = Val / Sum2;
                        }
                    }
                    ++y;
                }
                break;
            }
        }
    }

    private class ConvolutionFilterFlatFVThread
    extends Thread {
        private WritableRaster wr = null;
        private WritableRaster wrr = null;
        private int Type;
        private int sizex = -1;
        private int sizey = -1;
        private StructuringElement se = null;
        private int minx;
        private int miny;
        private int maxx;
        private int maxy;
        private boolean Kill = false;
        public Object lock = new Object();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void Kill() {
            this.se = null;
            this.wrr = null;
            this.wr = null;
            this.Kill = true;
            Object object = this.lock;
            synchronized (object) {
                this.lock.notify();
            }
        }

        public void setConditions(BufferedImage source, BufferedImage result, StructuringElement se, int minx, int miny, int maxx, int maxy) {
            this.wr = source.getRaster();
            this.wrr = result.getRaster();
            this.Type = source.getType();
            this.se = se;
            this.sizex = se.getSizeX() >> 1;
            this.sizey = se.getSizeY() >> 1;
            this.minx = minx;
            this.miny = miny;
            this.maxx = maxx;
            this.maxy = maxy;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block11: while (true) {
                Object object = this.lock;
                synchronized (object) {
                    try {
                        ConvolutionFilter.this.addFreeThread();
                        this.lock.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                if (this.Kill) {
                    return;
                }
                int width = this.wr.getWidth();
                int height = this.wr.getHeight();
                int MinX = this.minx < this.sizex ? this.sizex : this.minx;
                int MinY = this.miny < this.sizey ? this.sizey : this.miny;
                int MaxX = this.maxx >= width - this.sizex ? width - this.sizex : this.maxx;
                int MaxY = this.maxy >= height - this.sizey ? height - this.sizey : this.maxy;
                int channel = this.wr.getNumBands();
                int widthchannel = width * channel;
                CoordinatesWeighted[] sec = this.se.getSE();
                CoordinatesWeighted[] forward = this.se.getForward();
                CoordinatesWeighted[] backward = this.se.getBackward();
                switch (this.Type) {
                    case 10: {
                        byte[] srcbb = ((DataBufferByte)this.wr.getDataBuffer()).getData();
                        byte[] resbb = ((DataBufferByte)this.wrr.getDataBuffer()).getData();
                        int i2 = this.miny;
                        int pos = this.miny * width;
                        while (i2 < this.maxy) {
                            int j;
                            int nbpixel;
                            int SumPixel;
                            if (i2 < MinY || MaxY <= i2) {
                                SumPixel = 0;
                                nbpixel = 0;
                                for (CoordinatesWeighted coord : sec) {
                                    if (0 > coord.X || coord.X >= width || 0 > i2 + coord.Y || i2 + coord.Y >= height || (srcbb[pos + coord.Pos] & 0xFF) == ConvolutionFilter.this.ForbiddenValue) continue;
                                    SumPixel += srcbb[pos + coord.Pos] & 0xFF;
                                    ++nbpixel;
                                }
                                if ((srcbb[pos] & 0xFF) != ConvolutionFilter.this.ForbiddenValue) {
                                    resbb[pos] = (byte)((double)SumPixel / (double)nbpixel + 0.5);
                                }
                                for (j = 1; j <= MinX; ++j) {
                                    for (CoordinatesWeighted coord : forward) {
                                        if (j + coord.X >= width || 0 > i2 + coord.Y || i2 + coord.Y >= height || (srcbb[pos + coord.Pos + j] & 0xFF) == ConvolutionFilter.this.ForbiddenValue) continue;
                                        SumPixel += srcbb[pos + coord.Pos + j] & 0xFF;
                                        ++nbpixel;
                                    }
                                    for (CoordinatesWeighted coord : backward) {
                                        if (0 > j + coord.X || 0 > i2 + coord.Y || i2 + coord.Y >= height || (srcbb[pos + coord.Pos + j] & 0xFF) == ConvolutionFilter.this.ForbiddenValue) continue;
                                        SumPixel -= srcbb[pos + coord.Pos + j] & 0xFF;
                                        --nbpixel;
                                    }
                                    if ((srcbb[pos + j] & 0xFF) == ConvolutionFilter.this.ForbiddenValue) continue;
                                    resbb[pos + j] = (byte)((double)SumPixel / (double)nbpixel + 0.5);
                                }
                                while (j < MaxX) {
                                    for (CoordinatesWeighted coord : forward) {
                                        if (0 > i2 + coord.Y || i2 + coord.Y >= height || (srcbb[pos + coord.Pos + j] & 0xFF) == ConvolutionFilter.this.ForbiddenValue) continue;
                                        SumPixel += srcbb[pos + coord.Pos + j] & 0xFF;
                                        ++nbpixel;
                                    }
                                    for (CoordinatesWeighted coord : backward) {
                                        if (0 > i2 + coord.Y || i2 + coord.Y >= height || (srcbb[pos + coord.Pos + j] & 0xFF) == ConvolutionFilter.this.ForbiddenValue) continue;
                                        SumPixel -= srcbb[pos + coord.Pos + j] & 0xFF;
                                        --nbpixel;
                                    }
                                    if ((srcbb[pos + j] & 0xFF) != ConvolutionFilter.this.ForbiddenValue) {
                                        resbb[pos + j] = (byte)((double)SumPixel / (double)nbpixel + 0.5);
                                    }
                                    ++j;
                                }
                                while (j < this.maxx) {
                                    for (CoordinatesWeighted coord : forward) {
                                        if (j + coord.X >= width || 0 > i2 + coord.Y || i2 + coord.Y >= height || (srcbb[pos + coord.Pos + j] & 0xFF) == ConvolutionFilter.this.ForbiddenValue) continue;
                                        SumPixel += srcbb[pos + coord.Pos + j] & 0xFF;
                                        ++nbpixel;
                                    }
                                    for (CoordinatesWeighted coord : backward) {
                                        if (0 > i2 + coord.Y || i2 + coord.Y >= height || j + coord.X >= width || (srcbb[pos + coord.Pos + j] & 0xFF) == ConvolutionFilter.this.ForbiddenValue) continue;
                                        SumPixel -= srcbb[pos + coord.Pos + j] & 0xFF;
                                        --nbpixel;
                                    }
                                    if ((srcbb[pos + j] & 0xFF) != ConvolutionFilter.this.ForbiddenValue) {
                                        resbb[pos + j] = (byte)((double)SumPixel / (double)nbpixel + 0.5);
                                    }
                                    ++j;
                                }
                            } else {
                                SumPixel = 0;
                                nbpixel = 0;
                                for (CoordinatesWeighted coord : sec) {
                                    if (0 > coord.X || coord.X >= width || (srcbb[pos + coord.Pos] & 0xFF) == ConvolutionFilter.this.ForbiddenValue) continue;
                                    SumPixel += srcbb[pos + coord.Pos] & 0xFF;
                                    ++nbpixel;
                                }
                                if ((srcbb[pos] & 0xFF) != ConvolutionFilter.this.ForbiddenValue) {
                                    resbb[pos] = (byte)((double)SumPixel / (double)nbpixel + 0.5);
                                }
                                for (j = 1; j < MinX + 1; ++j) {
                                    for (CoordinatesWeighted coord : forward) {
                                        if (j + coord.X >= width || (srcbb[pos + coord.Pos + j] & 0xFF) == ConvolutionFilter.this.ForbiddenValue) continue;
                                        SumPixel += srcbb[pos + coord.Pos + j] & 0xFF;
                                        ++nbpixel;
                                    }
                                    for (CoordinatesWeighted coord : backward) {
                                        if (0 > j + coord.X || (srcbb[pos + coord.Pos + j] & 0xFF) == ConvolutionFilter.this.ForbiddenValue) continue;
                                        SumPixel -= srcbb[pos + coord.Pos + j] & 0xFF;
                                        --nbpixel;
                                    }
                                    if ((srcbb[pos + j] & 0xFF) == ConvolutionFilter.this.ForbiddenValue) continue;
                                    resbb[pos + j] = (byte)((double)SumPixel / (double)nbpixel + 0.5);
                                }
                                while (j < MaxX) {
                                    int v;
                                    for (CoordinatesWeighted coord : forward) {
                                        v = srcbb[pos + coord.Pos + j] & 0xFF;
                                        if (v == ConvolutionFilter.this.ForbiddenValue) continue;
                                        SumPixel += v;
                                        ++nbpixel;
                                    }
                                    for (CoordinatesWeighted coord : backward) {
                                        v = srcbb[pos + coord.Pos + j] & 0xFF;
                                        if (v == ConvolutionFilter.this.ForbiddenValue) continue;
                                        SumPixel -= v;
                                        --nbpixel;
                                    }
                                    if ((srcbb[pos + j] & 0xFF) != ConvolutionFilter.this.ForbiddenValue) {
                                        resbb[pos + j] = (byte)((double)SumPixel / (double)nbpixel + 0.5);
                                    }
                                    ++j;
                                }
                                while (j < this.maxx) {
                                    for (CoordinatesWeighted coord : forward) {
                                        if (j + coord.X >= width || (srcbb[pos + coord.Pos + j] & 0xFF) == ConvolutionFilter.this.ForbiddenValue) continue;
                                        SumPixel += srcbb[pos + coord.Pos + j] & 0xFF;
                                        ++nbpixel;
                                    }
                                    for (CoordinatesWeighted coord : backward) {
                                        if (j + coord.X >= width || (srcbb[pos + coord.Pos + j] & 0xFF) == ConvolutionFilter.this.ForbiddenValue) continue;
                                        SumPixel -= srcbb[pos + coord.Pos + j] & 0xFF;
                                        --nbpixel;
                                    }
                                    if ((srcbb[pos + j] & 0xFF) != ConvolutionFilter.this.ForbiddenValue) {
                                        resbb[pos + j] = (byte)((double)SumPixel / (double)nbpixel + 0.5);
                                    }
                                    ++j;
                                }
                            }
                            ++i2;
                            pos += width;
                        }
                        resbb = null;
                        srcbb = null;
                        break;
                    }
                    case 11: {
                        short[] srcsb = ((DataBufferUShort)this.wr.getDataBuffer()).getData();
                        short[] ressb = ((DataBufferUShort)this.wrr.getDataBuffer()).getData();
                        int i3 = this.miny;
                        int pos = this.miny * width;
                        while (true) {
                            int j;
                            int nbpixel;
                            int SumPixel;
                            if (i3 >= this.maxy) continue block11;
                            if (i3 < MinY || MaxY <= i3) {
                                SumPixel = 0;
                                nbpixel = 0;
                                for (CoordinatesWeighted coord : sec) {
                                    if (0 > coord.X || coord.X >= width || 0 > i3 + coord.Y || i3 + coord.Y >= height || (srcsb[pos + coord.Pos] & 0xFFFF) == ConvolutionFilter.this.ForbiddenValue) continue;
                                    SumPixel += srcsb[pos + coord.Pos] & 0xFFFF;
                                    ++nbpixel;
                                }
                                if ((srcsb[pos] & 0xFFFF) != ConvolutionFilter.this.ForbiddenValue) {
                                    ressb[pos] = (short)((double)SumPixel / (double)nbpixel + 0.5);
                                }
                                for (j = 1; j <= MinX; ++j) {
                                    for (CoordinatesWeighted coord : forward) {
                                        if (j + coord.X >= width || 0 > i3 + coord.Y || i3 + coord.Y >= height || (srcsb[pos + coord.Pos + j] & 0xFFFF) == ConvolutionFilter.this.ForbiddenValue) continue;
                                        SumPixel += srcsb[pos + coord.Pos + j] & 0xFFFF;
                                        ++nbpixel;
                                    }
                                    for (CoordinatesWeighted coord : backward) {
                                        if (0 > j + coord.X || 0 > i3 + coord.Y || i3 + coord.Y >= height || (srcsb[pos + coord.Pos + j] & 0xFFFF) == ConvolutionFilter.this.ForbiddenValue) continue;
                                        SumPixel -= srcsb[pos + coord.Pos + j] & 0xFFFF;
                                        --nbpixel;
                                    }
                                    if ((srcsb[pos + j] & 0xFFFF) == ConvolutionFilter.this.ForbiddenValue) continue;
                                    ressb[pos + j] = (short)((double)SumPixel / (double)nbpixel + 0.5);
                                }
                                while (j < MaxX) {
                                    for (CoordinatesWeighted coord : forward) {
                                        if (0 > i3 + coord.Y || i3 + coord.Y >= height || (srcsb[pos + coord.Pos + j] & 0xFFFF) == ConvolutionFilter.this.ForbiddenValue) continue;
                                        SumPixel += srcsb[pos + coord.Pos + j] & 0xFFFF;
                                        ++nbpixel;
                                    }
                                    for (CoordinatesWeighted coord : backward) {
                                        if (0 > i3 + coord.Y || i3 + coord.Y >= height || (srcsb[pos + coord.Pos + j] & 0xFFFF) == ConvolutionFilter.this.ForbiddenValue) continue;
                                        SumPixel -= srcsb[pos + coord.Pos + j] & 0xFFFF;
                                        --nbpixel;
                                    }
                                    if ((srcsb[pos + j] & 0xFFFF) != ConvolutionFilter.this.ForbiddenValue) {
                                        ressb[pos + j] = (short)((double)SumPixel / (double)nbpixel + 0.5);
                                    }
                                    ++j;
                                }
                                while (j < this.maxx) {
                                    for (CoordinatesWeighted coord : forward) {
                                        if (j + coord.X >= width || 0 > i3 + coord.Y || i3 + coord.Y >= height || (srcsb[pos + coord.Pos + j] & 0xFFFF) == ConvolutionFilter.this.ForbiddenValue) continue;
                                        SumPixel += srcsb[pos + coord.Pos + j] & 0xFFFF;
                                        ++nbpixel;
                                    }
                                    for (CoordinatesWeighted coord : backward) {
                                        if (0 > i3 + coord.Y || i3 + coord.Y >= height || j + coord.X >= width || (srcsb[pos + coord.Pos + j] & 0xFFFF) == ConvolutionFilter.this.ForbiddenValue) continue;
                                        SumPixel -= srcsb[pos + coord.Pos + j] & 0xFFFF;
                                        --nbpixel;
                                    }
                                    if ((srcsb[pos + j] & 0xFFFF) != ConvolutionFilter.this.ForbiddenValue) {
                                        ressb[pos + j] = (short)((double)SumPixel / (double)nbpixel + 0.5);
                                    }
                                    ++j;
                                }
                            } else {
                                SumPixel = 0;
                                nbpixel = 0;
                                for (CoordinatesWeighted sec1 : sec) {
                                    if (0 > sec1.X || sec1.X >= width || (srcsb[pos + sec1.Pos] & 0xFFFF) == ConvolutionFilter.this.ForbiddenValue) continue;
                                    SumPixel += srcsb[pos + sec1.Pos] & 0xFFFF;
                                    ++nbpixel;
                                }
                                if ((srcsb[pos] & 0xFFFF) != ConvolutionFilter.this.ForbiddenValue) {
                                    ressb[pos] = (short)((double)SumPixel / (double)nbpixel + 0.5);
                                }
                                for (j = 1; j < MinX + 1; ++j) {
                                    for (CoordinatesWeighted coord : forward) {
                                        if (j + coord.X >= width || (srcsb[pos + coord.Pos + j] & 0xFF) == ConvolutionFilter.this.ForbiddenValue) continue;
                                        SumPixel += srcsb[pos + coord.Pos + j] & 0xFFFF;
                                        ++nbpixel;
                                    }
                                    for (CoordinatesWeighted coord : backward) {
                                        if (0 > j + coord.X || (srcsb[pos + coord.Pos + j] & 0xFFFF) == ConvolutionFilter.this.ForbiddenValue) continue;
                                        SumPixel -= srcsb[pos + coord.Pos + j] & 0xFFFF;
                                        --nbpixel;
                                    }
                                    if ((srcsb[pos + j] & 0xFFFF) == ConvolutionFilter.this.ForbiddenValue) continue;
                                    ressb[pos + j] = (short)((double)SumPixel / (double)nbpixel + 0.5);
                                }
                                while (j < MaxX) {
                                    int v;
                                    for (CoordinatesWeighted coord : forward) {
                                        v = srcsb[pos + coord.Pos + j] & 0xFFFF;
                                        if (v == ConvolutionFilter.this.ForbiddenValue) continue;
                                        SumPixel += v;
                                        ++nbpixel;
                                    }
                                    for (CoordinatesWeighted coord : backward) {
                                        v = srcsb[pos + coord.Pos + j] & 0xFFFF;
                                        if (v == ConvolutionFilter.this.ForbiddenValue) continue;
                                        SumPixel -= v;
                                        --nbpixel;
                                    }
                                    if ((srcsb[pos + j] & 0xFF) != ConvolutionFilter.this.ForbiddenValue) {
                                        ressb[pos + j] = (short)((double)SumPixel / (double)nbpixel + 0.5);
                                    }
                                    ++j;
                                }
                                while (j < this.maxx) {
                                    for (CoordinatesWeighted coord : forward) {
                                        if (j + coord.X >= width || (srcsb[pos + coord.Pos + j] & 0xFF) == ConvolutionFilter.this.ForbiddenValue) continue;
                                        SumPixel += srcsb[pos + coord.Pos + j] & 0xFFFF;
                                        ++nbpixel;
                                    }
                                    for (CoordinatesWeighted coord : backward) {
                                        if (j + coord.X >= width || (srcsb[pos + coord.Pos + j] & 0xFFFF) == ConvolutionFilter.this.ForbiddenValue) continue;
                                        SumPixel -= srcsb[pos + coord.Pos + j] & 0xFF;
                                        --nbpixel;
                                    }
                                    if ((srcsb[pos + j] & 0xFFFF) != ConvolutionFilter.this.ForbiddenValue) {
                                        ressb[pos + j] = (short)((double)SumPixel / (double)nbpixel + 0.5);
                                    }
                                    ++j;
                                }
                            }
                            ++i3;
                            pos += width;
                        }
                    }
                    case 5: 
                    case 6: {
                        byte[] srcbbcol = ((DataBufferByte)this.wr.getDataBuffer()).getData();
                        byte[] resbbcol = ((DataBufferByte)this.wrr.getDataBuffer()).getData();
                        for (int c = 0; c < channel; ++c) {
                            int i4 = this.miny;
                            int pos = this.miny * widthchannel + c;
                            while (i4 < this.maxy) {
                                int jchan;
                                int j;
                                int nbpixel;
                                int SumPixel;
                                if (i4 < MinY || MaxY <= i4) {
                                    SumPixel = 0;
                                    nbpixel = 0;
                                    for (CoordinatesWeighted coord : sec) {
                                        if (0 > coord.X || coord.X >= width || 0 > i4 + coord.Y || i4 + coord.Y >= height || (srcbbcol[pos + coord.Pos] & 0xFF) == ConvolutionFilter.this.ForbiddenValue) continue;
                                        SumPixel += srcbbcol[pos + coord.Pos] & 0xFF;
                                        ++nbpixel;
                                    }
                                    if ((srcbbcol[pos] & 0xFF) != ConvolutionFilter.this.ForbiddenValue) {
                                        resbbcol[pos] = (byte)((double)SumPixel / (double)nbpixel + 0.5);
                                    }
                                    j = 1;
                                    jchan = channel;
                                    while (j <= MinX) {
                                        for (CoordinatesWeighted coord : forward) {
                                            if (j + coord.X >= width || 0 > i4 + coord.Y || i4 + coord.Y >= height || (srcbbcol[pos + coord.Pos + j] & 0xFF) == ConvolutionFilter.this.ForbiddenValue) continue;
                                            SumPixel += srcbbcol[pos + coord.Pos + jchan] & 0xFF;
                                            ++nbpixel;
                                        }
                                        for (CoordinatesWeighted coord : backward) {
                                            if (0 > j + coord.X || 0 > i4 + coord.Y || i4 + coord.Y >= height || (srcbbcol[pos + coord.Pos + jchan] & 0xFF) == ConvolutionFilter.this.ForbiddenValue) continue;
                                            SumPixel -= srcbbcol[pos + coord.Pos + jchan] & 0xFF;
                                            --nbpixel;
                                        }
                                        if ((srcbbcol[pos + jchan] & 0xFF) != ConvolutionFilter.this.ForbiddenValue) {
                                            resbbcol[pos + jchan] = (byte)((double)SumPixel / (double)nbpixel + 0.5);
                                        }
                                        ++j;
                                        jchan += channel;
                                    }
                                    while (j < MaxX) {
                                        for (CoordinatesWeighted coord : forward) {
                                            if (0 > i4 + coord.Y || i4 + coord.Y >= height || (srcbbcol[pos + coord.Pos + jchan] & 0xFF) == ConvolutionFilter.this.ForbiddenValue) continue;
                                            SumPixel += srcbbcol[pos + coord.Pos + jchan] & 0xFF;
                                            ++nbpixel;
                                        }
                                        for (CoordinatesWeighted coord : backward) {
                                            if (0 > i4 + coord.Y || i4 + coord.Y >= height || (srcbbcol[pos + coord.Pos + jchan] & 0xFF) == ConvolutionFilter.this.ForbiddenValue) continue;
                                            SumPixel -= srcbbcol[pos + coord.Pos + jchan] & 0xFF;
                                            --nbpixel;
                                        }
                                        if ((srcbbcol[pos + jchan] & 0xFF) != ConvolutionFilter.this.ForbiddenValue) {
                                            resbbcol[pos + jchan] = (byte)((double)SumPixel / (double)nbpixel + 0.5);
                                        }
                                        ++j;
                                        jchan += channel;
                                    }
                                    while (j < this.maxx) {
                                        for (CoordinatesWeighted coord : forward) {
                                            if (j + coord.X >= width || 0 > i4 + coord.Y || i4 + coord.Y >= height || (srcbbcol[pos + coord.Pos + jchan] & 0xFF) == ConvolutionFilter.this.ForbiddenValue) continue;
                                            SumPixel += srcbbcol[pos + coord.Pos + jchan] & 0xFF;
                                            ++nbpixel;
                                        }
                                        for (CoordinatesWeighted coord : backward) {
                                            if (0 > i4 + coord.Y || i4 + coord.Y >= height || j + coord.X >= width || (srcbbcol[pos + coord.Pos + jchan] & 0xFF) == ConvolutionFilter.this.ForbiddenValue) continue;
                                            SumPixel -= srcbbcol[pos + coord.Pos + jchan] & 0xFF;
                                            --nbpixel;
                                        }
                                        if ((srcbbcol[pos + jchan] & 0xFF) != ConvolutionFilter.this.ForbiddenValue) {
                                            resbbcol[pos + jchan] = (byte)((double)SumPixel / (double)nbpixel + 0.5);
                                        }
                                        ++j;
                                        jchan += channel;
                                    }
                                } else {
                                    SumPixel = 0;
                                    nbpixel = 0;
                                    for (CoordinatesWeighted sec1 : sec) {
                                        if (0 > sec1.X || sec1.X >= width || (srcbbcol[pos + sec1.Pos] & 0xFF) == ConvolutionFilter.this.ForbiddenValue) continue;
                                        SumPixel += srcbbcol[pos + sec1.Pos] & 0xFF;
                                        ++nbpixel;
                                    }
                                    if ((srcbbcol[pos] & 0xFF) != ConvolutionFilter.this.ForbiddenValue) {
                                        resbbcol[pos] = (byte)((double)SumPixel / (double)nbpixel + 0.5);
                                    }
                                    j = 1;
                                    jchan = channel;
                                    while (j < MinX + 1) {
                                        for (CoordinatesWeighted coord : forward) {
                                            if (j + coord.X >= width || (srcbbcol[pos + coord.Pos + jchan] & 0xFF) == ConvolutionFilter.this.ForbiddenValue) continue;
                                            SumPixel += srcbbcol[pos + coord.Pos + jchan] & 0xFF;
                                            ++nbpixel;
                                        }
                                        for (CoordinatesWeighted coord : backward) {
                                            if (0 > j + coord.X || (srcbbcol[pos + coord.Pos + jchan] & 0xFF) == ConvolutionFilter.this.ForbiddenValue) continue;
                                            SumPixel -= srcbbcol[pos + coord.Pos + jchan] & 0xFF;
                                            --nbpixel;
                                        }
                                        if ((srcbbcol[pos + jchan] & 0xFF) != ConvolutionFilter.this.ForbiddenValue) {
                                            resbbcol[pos + jchan] = (byte)((double)SumPixel / (double)nbpixel + 0.5);
                                        }
                                        ++j;
                                        jchan += channel;
                                    }
                                    while (j < MaxX) {
                                        int v;
                                        for (CoordinatesWeighted coord : forward) {
                                            v = srcbbcol[pos + coord.Pos + jchan] & 0xFF;
                                            if (v == ConvolutionFilter.this.ForbiddenValue) continue;
                                            SumPixel += v;
                                            ++nbpixel;
                                        }
                                        for (CoordinatesWeighted coord : backward) {
                                            v = srcbbcol[pos + coord.Pos + jchan] & 0xFF;
                                            if (v == ConvolutionFilter.this.ForbiddenValue) continue;
                                            SumPixel -= v;
                                            --nbpixel;
                                        }
                                        if ((srcbbcol[pos + jchan] & 0xFF) != ConvolutionFilter.this.ForbiddenValue) {
                                            resbbcol[pos + jchan] = (byte)((double)SumPixel / (double)nbpixel + 0.5);
                                        }
                                        ++j;
                                        jchan += channel;
                                    }
                                    while (j < this.maxx) {
                                        for (CoordinatesWeighted coord : forward) {
                                            if (j + coord.X >= width || (srcbbcol[pos + coord.Pos + jchan] & 0xFF) == ConvolutionFilter.this.ForbiddenValue) continue;
                                            SumPixel += srcbbcol[pos + coord.Pos + jchan] & 0xFF;
                                            ++nbpixel;
                                        }
                                        for (CoordinatesWeighted coord : backward) {
                                            if (j + coord.X >= width || (srcbbcol[pos + coord.Pos + jchan] & 0xFF) == ConvolutionFilter.this.ForbiddenValue) continue;
                                            SumPixel -= srcbbcol[pos + coord.Pos + jchan] & 0xFF;
                                            --nbpixel;
                                        }
                                        if ((srcbbcol[pos + jchan] & 0xFF) != ConvolutionFilter.this.ForbiddenValue) {
                                            resbbcol[pos + jchan] = (byte)((double)SumPixel / (double)nbpixel + 0.5);
                                        }
                                        ++j;
                                        jchan += channel;
                                    }
                                }
                                ++i4;
                                pos += widthchannel;
                            }
                        }
                        resbbcol = null;
                        srcbbcol = null;
                        break;
                    }
                    case 1: 
                    case 4: {
                        int[] srcibcol = ((DataBufferInt)this.wr.getDataBuffer()).getData();
                        int[] resibcol = ((DataBufferInt)this.wrr.getDataBuffer()).getData();
                        for (int c = 0; c < channel; ++c) {
                            int i5 = this.miny;
                            int pos = this.miny * widthchannel + c;
                            while (i5 < this.maxy) {
                                int jchan;
                                int j;
                                int nbpixel;
                                int SumPixel;
                                if (i5 < MinY || MaxY <= i5) {
                                    SumPixel = 0;
                                    nbpixel = 0;
                                    for (CoordinatesWeighted coord : sec) {
                                        if (0 > coord.X || coord.X >= width || 0 > i5 + coord.Y || i5 + coord.Y >= height || srcibcol[pos + coord.Pos] == ConvolutionFilter.this.ForbiddenValue) continue;
                                        SumPixel += srcibcol[pos + coord.Pos];
                                        ++nbpixel;
                                    }
                                    if (srcibcol[pos] != ConvolutionFilter.this.ForbiddenValue) {
                                        resibcol[pos] = (int)((double)SumPixel / (double)nbpixel + 0.5);
                                    }
                                    j = 1;
                                    jchan = channel;
                                    while (j <= MinX) {
                                        for (CoordinatesWeighted coord : forward) {
                                            if (j + coord.X >= width || 0 > i5 + coord.Y || i5 + coord.Y >= height || srcibcol[pos + coord.Pos + j] == ConvolutionFilter.this.ForbiddenValue) continue;
                                            SumPixel += srcibcol[pos + coord.Pos + jchan];
                                            ++nbpixel;
                                        }
                                        for (CoordinatesWeighted coord : backward) {
                                            if (0 > j + coord.X || 0 > i5 + coord.Y || i5 + coord.Y >= height || srcibcol[pos + coord.Pos + jchan] == ConvolutionFilter.this.ForbiddenValue) continue;
                                            SumPixel -= srcibcol[pos + coord.Pos + jchan];
                                            --nbpixel;
                                        }
                                        if (srcibcol[pos + jchan] != ConvolutionFilter.this.ForbiddenValue) {
                                            resibcol[pos + jchan] = (int)((double)SumPixel / (double)nbpixel + 0.5);
                                        }
                                        ++j;
                                        jchan += channel;
                                    }
                                    while (j < MaxX) {
                                        for (CoordinatesWeighted coord : forward) {
                                            if (0 > i5 + coord.Y || i5 + coord.Y >= height || srcibcol[pos + coord.Pos + jchan] == ConvolutionFilter.this.ForbiddenValue) continue;
                                            SumPixel += srcibcol[pos + coord.Pos + jchan];
                                            ++nbpixel;
                                        }
                                        for (CoordinatesWeighted coord : backward) {
                                            if (0 > i5 + coord.Y || i5 + coord.Y >= height || srcibcol[pos + coord.Pos + jchan] == ConvolutionFilter.this.ForbiddenValue) continue;
                                            SumPixel -= srcibcol[pos + coord.Pos + jchan];
                                            --nbpixel;
                                        }
                                        if (srcibcol[pos + jchan] != ConvolutionFilter.this.ForbiddenValue) {
                                            resibcol[pos + jchan] = (int)((double)SumPixel / (double)nbpixel + 0.5);
                                        }
                                        ++j;
                                        jchan += channel;
                                    }
                                    while (j < this.maxx) {
                                        for (CoordinatesWeighted coord : forward) {
                                            if (j + coord.X >= width || 0 > i5 + coord.Y || i5 + coord.Y >= height || srcibcol[pos + coord.Pos + jchan] == ConvolutionFilter.this.ForbiddenValue) continue;
                                            SumPixel += srcibcol[pos + coord.Pos + jchan];
                                            ++nbpixel;
                                        }
                                        for (CoordinatesWeighted coord : backward) {
                                            if (0 > i5 + coord.Y || i5 + coord.Y >= height || j + coord.X >= width || srcibcol[pos + coord.Pos + jchan] == ConvolutionFilter.this.ForbiddenValue) continue;
                                            SumPixel -= srcibcol[pos + coord.Pos + jchan];
                                            --nbpixel;
                                        }
                                        if (srcibcol[pos + jchan] != ConvolutionFilter.this.ForbiddenValue) {
                                            resibcol[pos + jchan] = (int)((double)SumPixel / (double)nbpixel + 0.5);
                                        }
                                        ++j;
                                        jchan += channel;
                                    }
                                } else {
                                    SumPixel = 0;
                                    nbpixel = 0;
                                    for (CoordinatesWeighted coord : sec) {
                                        if (0 > coord.X || coord.X >= width || srcibcol[pos + coord.Pos] == ConvolutionFilter.this.ForbiddenValue) continue;
                                        SumPixel += srcibcol[pos + coord.Pos];
                                        ++nbpixel;
                                    }
                                    if (srcibcol[pos] != ConvolutionFilter.this.ForbiddenValue) {
                                        resibcol[pos] = (int)((double)SumPixel / (double)nbpixel + 0.5);
                                    }
                                    j = 1;
                                    jchan = channel;
                                    while (j < MinX + 1) {
                                        for (CoordinatesWeighted coord : forward) {
                                            if (j + coord.X >= width || srcibcol[pos + coord.Pos + jchan] == ConvolutionFilter.this.ForbiddenValue) continue;
                                            SumPixel += srcibcol[pos + coord.Pos + jchan];
                                            ++nbpixel;
                                        }
                                        for (CoordinatesWeighted coord : backward) {
                                            if (0 > j + coord.X || srcibcol[pos + coord.Pos + jchan] == ConvolutionFilter.this.ForbiddenValue) continue;
                                            SumPixel -= srcibcol[pos + coord.Pos + jchan];
                                            --nbpixel;
                                        }
                                        if (srcibcol[pos + jchan] != ConvolutionFilter.this.ForbiddenValue) {
                                            resibcol[pos + jchan] = (int)((double)SumPixel / (double)nbpixel + 0.5);
                                        }
                                        ++j;
                                        jchan += channel;
                                    }
                                    while (j < MaxX) {
                                        int v;
                                        for (CoordinatesWeighted coord : forward) {
                                            v = srcibcol[pos + coord.Pos + jchan];
                                            if (v == ConvolutionFilter.this.ForbiddenValue) continue;
                                            SumPixel += v;
                                            ++nbpixel;
                                        }
                                        for (CoordinatesWeighted coord : backward) {
                                            v = srcibcol[pos + coord.Pos + jchan];
                                            if (v == ConvolutionFilter.this.ForbiddenValue) continue;
                                            SumPixel -= v;
                                            --nbpixel;
                                        }
                                        if (srcibcol[pos + jchan] != ConvolutionFilter.this.ForbiddenValue) {
                                            resibcol[pos + jchan] = (int)((double)SumPixel / (double)nbpixel + 0.5);
                                        }
                                        ++j;
                                        jchan += channel;
                                    }
                                    while (j < this.maxx) {
                                        for (CoordinatesWeighted coord : forward) {
                                            if (j + coord.X >= width || srcibcol[pos + coord.Pos + jchan] == ConvolutionFilter.this.ForbiddenValue) continue;
                                            SumPixel += srcibcol[pos + coord.Pos + jchan];
                                            ++nbpixel;
                                        }
                                        for (CoordinatesWeighted coord : backward) {
                                            if (j + coord.X >= width || srcibcol[pos + coord.Pos + jchan] == ConvolutionFilter.this.ForbiddenValue) continue;
                                            SumPixel -= srcibcol[pos + coord.Pos + jchan];
                                            --nbpixel;
                                        }
                                        if (srcibcol[pos + jchan] != ConvolutionFilter.this.ForbiddenValue) {
                                            resibcol[pos + jchan] = (int)((double)SumPixel / (double)nbpixel + 0.5);
                                        }
                                        ++j;
                                        jchan += channel;
                                    }
                                }
                                ++i5;
                                pos += widthchannel;
                            }
                        }
                        Object resbbcol = null;
                        Object srcbbcol = null;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Image type not supported.");
                    }
                }
            }
        }
    }

    private class ConvolutionFilterFlatThread
    extends Thread {
        private WritableRaster wr = null;
        private WritableRaster wrr = null;
        private int Type;
        private int sizex = -1;
        private int sizey = -1;
        private StructuringElement se = null;
        private int minx;
        private int miny;
        private int maxx;
        private int maxy;
        private boolean Kill = false;
        public Object lock = new Object();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void Kill() {
            this.se = null;
            this.wrr = null;
            this.wr = null;
            this.Kill = true;
            Object object = this.lock;
            synchronized (object) {
                this.lock.notify();
            }
        }

        public void setConditions(BufferedImage source, BufferedImage result, StructuringElement se, int minx, int miny, int maxx, int maxy) {
            this.wr = source.getRaster();
            this.wrr = result.getRaster();
            this.Type = source.getType();
            this.se = se;
            this.sizex = se.getSizeX() >> 1;
            this.sizey = se.getSizeY() >> 1;
            this.minx = minx;
            this.miny = miny;
            this.maxx = maxx;
            this.maxy = maxy;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block11: while (true) {
                Object object = this.lock;
                synchronized (object) {
                    try {
                        ConvolutionFilter.this.addFreeThread();
                        this.lock.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                if (this.Kill) {
                    return;
                }
                int width = this.wr.getWidth();
                int height = this.wr.getHeight();
                int MinX = this.minx < this.sizex ? this.sizex : this.minx;
                int MinY = this.miny < this.sizey ? this.sizey : this.miny;
                int MaxX = this.maxx >= width - this.sizex ? width - this.sizex : this.maxx;
                int MaxY = this.maxy >= height - this.sizey ? height - this.sizey : this.maxy;
                CoordinatesWeighted[] sec = this.se.getSE();
                CoordinatesWeighted[] forward = this.se.getForward();
                CoordinatesWeighted[] backward = this.se.getBackward();
                switch (this.Type) {
                    case 10: {
                        int j;
                        byte[] srcbb = ((DataBufferByte)this.wr.getDataBuffer()).getData();
                        byte[] resbb = ((DataBufferByte)this.wrr.getDataBuffer()).getData();
                        int i2 = this.miny;
                        int pos = this.miny * width;
                        while (i2 < this.maxy) {
                            int nbpixel;
                            int SumPixel;
                            if (i2 < MinY || MaxY <= i2) {
                                SumPixel = 0;
                                nbpixel = 0;
                                for (CoordinatesWeighted coord : sec) {
                                    if (0 > coord.X || coord.X >= width || 0 > i2 + coord.Y || i2 + coord.Y >= height) continue;
                                    SumPixel += srcbb[pos + coord.Pos] & 0xFF;
                                    ++nbpixel;
                                }
                                resbb[pos] = (byte)((double)SumPixel / (double)nbpixel + 0.5);
                                for (j = 1; j <= MinX; ++j) {
                                    for (CoordinatesWeighted coord : forward) {
                                        if (j + coord.X >= width || 0 > i2 + coord.Y || i2 + coord.Y >= height) continue;
                                        SumPixel += srcbb[pos + coord.Pos + j] & 0xFF;
                                        ++nbpixel;
                                    }
                                    for (CoordinatesWeighted coord : backward) {
                                        if (0 > j + coord.X || 0 > i2 + coord.Y || i2 + coord.Y >= height) continue;
                                        SumPixel -= srcbb[pos + coord.Pos + j] & 0xFF;
                                        --nbpixel;
                                    }
                                    resbb[pos + j] = (byte)((double)SumPixel / (double)nbpixel + 0.5);
                                }
                                while (j < MaxX) {
                                    for (CoordinatesWeighted coord : forward) {
                                        if (0 > i2 + coord.Y || i2 + coord.Y >= height) continue;
                                        SumPixel += srcbb[pos + coord.Pos + j] & 0xFF;
                                        ++nbpixel;
                                    }
                                    for (CoordinatesWeighted coord : backward) {
                                        if (0 > i2 + coord.Y || i2 + coord.Y >= height) continue;
                                        SumPixel -= srcbb[pos + coord.Pos + j] & 0xFF;
                                        --nbpixel;
                                    }
                                    resbb[pos + j] = (byte)((double)SumPixel / (double)nbpixel + 0.5);
                                    ++j;
                                }
                                while (j < this.maxx) {
                                    for (CoordinatesWeighted coord : forward) {
                                        if (j + coord.X >= width || 0 > i2 + coord.Y || i2 + coord.Y >= height) continue;
                                        SumPixel += srcbb[pos + coord.Pos + j] & 0xFF;
                                        ++nbpixel;
                                    }
                                    for (CoordinatesWeighted coord : backward) {
                                        if (0 > i2 + coord.Y || i2 + coord.Y >= height || j + coord.X >= width) continue;
                                        SumPixel -= srcbb[pos + coord.Pos + j] & 0xFF;
                                        --nbpixel;
                                    }
                                    resbb[pos + j] = (byte)((double)SumPixel / (double)nbpixel + 0.5);
                                    ++j;
                                }
                            } else {
                                SumPixel = 0;
                                nbpixel = 0;
                                for (CoordinatesWeighted coord : sec) {
                                    if (0 > coord.X || coord.X >= width) continue;
                                    SumPixel += srcbb[pos + coord.Pos] & 0xFF;
                                    ++nbpixel;
                                }
                                resbb[pos] = (byte)((double)SumPixel / (double)nbpixel + 0.5);
                                for (j = 1; j <= MinX; ++j) {
                                    for (CoordinatesWeighted coord : forward) {
                                        if (j + coord.X >= width) continue;
                                        SumPixel += srcbb[pos + coord.Pos + j] & 0xFF;
                                        ++nbpixel;
                                    }
                                    for (CoordinatesWeighted coord : backward) {
                                        if (0 > j + coord.X) continue;
                                        SumPixel -= srcbb[pos + coord.Pos + j] & 0xFF;
                                        --nbpixel;
                                    }
                                    resbb[pos + j] = (byte)((double)SumPixel / (double)nbpixel + 0.5);
                                }
                                while (j < MaxX) {
                                    for (CoordinatesWeighted coord : forward) {
                                        SumPixel += srcbb[pos + coord.Pos + j] & 0xFF;
                                        ++nbpixel;
                                    }
                                    for (CoordinatesWeighted coord : backward) {
                                        SumPixel -= srcbb[pos + coord.Pos + j] & 0xFF;
                                        --nbpixel;
                                    }
                                    resbb[pos + j] = (byte)((double)SumPixel / (double)nbpixel + 0.5);
                                    ++j;
                                }
                                while (j < this.maxx) {
                                    for (CoordinatesWeighted coord : forward) {
                                        if (j + coord.X >= width) continue;
                                        SumPixel += srcbb[pos + coord.Pos + j] & 0xFF;
                                        ++nbpixel;
                                    }
                                    for (CoordinatesWeighted coord : backward) {
                                        if (j + coord.X >= width) continue;
                                        SumPixel -= srcbb[pos + coord.Pos + j] & 0xFF;
                                        --nbpixel;
                                    }
                                    resbb[pos + j] = (byte)((double)SumPixel / (double)nbpixel + 0.5);
                                    ++j;
                                }
                            }
                            ++i2;
                            pos += width;
                        }
                        resbb = null;
                        srcbb = null;
                        continue block11;
                    }
                    case 11: {
                        int j;
                        short[] srcsb = ((DataBufferUShort)this.wr.getDataBuffer()).getData();
                        short[] ressb = ((DataBufferUShort)this.wrr.getDataBuffer()).getData();
                        int i3 = this.miny;
                        int pos = this.miny * width;
                        while (i3 < this.maxy) {
                            int nbpixel;
                            int SumPixel;
                            if (i3 < MinY || MaxY <= i3) {
                                SumPixel = 0;
                                nbpixel = 0;
                                for (CoordinatesWeighted coord : sec) {
                                    if (0 > coord.X || coord.X >= width || 0 > i3 + coord.Y || i3 + coord.Y >= height) continue;
                                    SumPixel += srcsb[pos + coord.Pos] & 0xFFFF;
                                    ++nbpixel;
                                }
                                ressb[pos] = (short)((double)SumPixel / (double)nbpixel + 0.5);
                                for (j = 1; j <= MinX; ++j) {
                                    for (CoordinatesWeighted coord : forward) {
                                        if (j + coord.X >= width || 0 > i3 + coord.Y || i3 + coord.Y >= height) continue;
                                        SumPixel += srcsb[pos + coord.Pos + j] & 0xFFFF;
                                        ++nbpixel;
                                    }
                                    for (CoordinatesWeighted coord : backward) {
                                        if (0 > j + coord.X || 0 > i3 + coord.Y || i3 + coord.Y >= height) continue;
                                        SumPixel -= srcsb[pos + coord.Pos + j] & 0xFFFF;
                                        --nbpixel;
                                    }
                                    ressb[pos + j] = (short)((double)SumPixel / (double)nbpixel + 0.5);
                                }
                                while (j < MaxX) {
                                    for (CoordinatesWeighted coord : forward) {
                                        if (0 > i3 + coord.Y || i3 + coord.Y >= height) continue;
                                        SumPixel += srcsb[pos + coord.Pos + j] & 0xFFFF;
                                        ++nbpixel;
                                    }
                                    for (CoordinatesWeighted coord : backward) {
                                        if (0 > i3 + coord.Y || i3 + coord.Y >= height) continue;
                                        SumPixel -= srcsb[pos + coord.Pos + j] & 0xFFFF;
                                        --nbpixel;
                                    }
                                    ressb[pos + j] = (short)((double)SumPixel / (double)nbpixel + 0.5);
                                    ++j;
                                }
                                while (j < this.maxx) {
                                    for (CoordinatesWeighted coord : forward) {
                                        if (j + coord.X >= width || 0 > i3 + coord.Y || i3 + coord.Y >= height) continue;
                                        SumPixel += srcsb[pos + coord.Pos + j] & 0xFFFF;
                                        ++nbpixel;
                                    }
                                    for (CoordinatesWeighted coord : backward) {
                                        if (0 > i3 + coord.Y || i3 + coord.Y >= height || j + coord.X >= width) continue;
                                        SumPixel -= srcsb[pos + coord.Pos + j] & 0xFFFF;
                                        --nbpixel;
                                    }
                                    ressb[pos + j] = (short)((double)SumPixel / (double)nbpixel + 0.5);
                                    ++j;
                                }
                            } else {
                                SumPixel = 0;
                                nbpixel = 0;
                                for (CoordinatesWeighted coord : sec) {
                                    if (0 > coord.X || coord.X >= width) continue;
                                    SumPixel += srcsb[pos + coord.Pos] & 0xFFFF;
                                    ++nbpixel;
                                }
                                ressb[pos] = (short)((double)SumPixel / (double)nbpixel + 0.5);
                                for (j = 1; j < MinX + 1; ++j) {
                                    for (CoordinatesWeighted coord : forward) {
                                        if (j + coord.X >= width) continue;
                                        SumPixel += srcsb[pos + coord.Pos + j] & 0xFFFF;
                                        ++nbpixel;
                                    }
                                    for (CoordinatesWeighted coord : backward) {
                                        if (0 > j + coord.X) continue;
                                        SumPixel -= srcsb[pos + coord.Pos + j] & 0xFFFF;
                                        --nbpixel;
                                    }
                                    ressb[pos + j] = (short)((double)SumPixel / (double)nbpixel + 0.5);
                                }
                                while (j < MaxX) {
                                    for (CoordinatesWeighted coord : forward) {
                                        SumPixel += srcsb[pos + coord.Pos + j] & 0xFFFF;
                                        ++nbpixel;
                                    }
                                    for (CoordinatesWeighted coord : backward) {
                                        SumPixel -= srcsb[pos + coord.Pos + j] & 0xFFFF;
                                        --nbpixel;
                                    }
                                    ressb[pos + j] = (short)((double)SumPixel / (double)nbpixel + 0.5);
                                    ++j;
                                }
                                while (j < this.maxx) {
                                    for (CoordinatesWeighted coord : forward) {
                                        if (j + coord.X >= width) continue;
                                        SumPixel += srcsb[pos + coord.Pos + j] & 0xFFFF;
                                        ++nbpixel;
                                    }
                                    for (CoordinatesWeighted coord : backward) {
                                        if (j + coord.X >= width) continue;
                                        SumPixel -= srcsb[pos + coord.Pos + j] & 0xFFFF;
                                        --nbpixel;
                                    }
                                    ressb[pos + j] = (short)((double)SumPixel / (double)nbpixel + 0.5);
                                    ++j;
                                }
                            }
                            ++i3;
                            pos += width;
                        }
                        ressb = null;
                        srcsb = null;
                        continue block11;
                    }
                    case 5: 
                    case 6: {
                        int jchan;
                        int j;
                        byte[] srcbbcol = ((DataBufferByte)this.wr.getDataBuffer()).getData();
                        byte[] resbbcol = ((DataBufferByte)this.wrr.getDataBuffer()).getData();
                        int channel = this.wr.getNumBands();
                        int widthchannel = width * channel;
                        for (int c = 0; c < channel; ++c) {
                            int i4 = this.miny;
                            int pos = this.miny * widthchannel + c;
                            while (i4 < this.maxy) {
                                int nbpixel;
                                int SumPixel;
                                if (i4 < MinY || MaxY <= i4) {
                                    SumPixel = 0;
                                    nbpixel = 0;
                                    for (CoordinatesWeighted coord : sec) {
                                        if (0 > coord.X || coord.X >= width || 0 > i4 + coord.Y || i4 + coord.Y >= height) continue;
                                        SumPixel += srcbbcol[pos + coord.Pos] & 0xFF;
                                        ++nbpixel;
                                    }
                                    resbbcol[pos] = (byte)((double)SumPixel / (double)nbpixel + 0.5);
                                    j = 1;
                                    jchan = channel;
                                    while (j <= MinX) {
                                        for (CoordinatesWeighted coord : forward) {
                                            if (j + coord.X >= width || 0 > i4 + coord.Y || i4 + coord.Y >= height) continue;
                                            SumPixel += srcbbcol[pos + coord.Pos + jchan] & 0xFF;
                                            ++nbpixel;
                                        }
                                        for (CoordinatesWeighted coord : backward) {
                                            if (0 > j + coord.X || 0 > i4 + coord.Y || i4 + coord.Y >= height) continue;
                                            SumPixel -= srcbbcol[pos + coord.Pos + jchan] & 0xFF;
                                            --nbpixel;
                                        }
                                        resbbcol[pos + jchan] = (byte)((double)SumPixel / (double)nbpixel + 0.5);
                                        ++j;
                                        jchan += channel;
                                    }
                                    while (j < MaxX) {
                                        for (CoordinatesWeighted coord : forward) {
                                            if (0 > i4 + coord.Y || i4 + coord.Y >= height) continue;
                                            SumPixel += srcbbcol[pos + coord.Pos + jchan] & 0xFF;
                                            ++nbpixel;
                                        }
                                        for (CoordinatesWeighted coord : backward) {
                                            if (0 > i4 + coord.Y || i4 + coord.Y >= height) continue;
                                            SumPixel -= srcbbcol[pos + coord.Pos + jchan] & 0xFF;
                                            --nbpixel;
                                        }
                                        resbbcol[pos + jchan] = (byte)((double)SumPixel / (double)nbpixel + 0.5);
                                        ++j;
                                        jchan += channel;
                                    }
                                    while (j < this.maxx) {
                                        for (CoordinatesWeighted coord : forward) {
                                            if (j + coord.X >= width || 0 > i4 + coord.Y || i4 + coord.Y >= height) continue;
                                            SumPixel += srcbbcol[pos + coord.Pos + jchan] & 0xFF;
                                            ++nbpixel;
                                        }
                                        for (CoordinatesWeighted coord : backward) {
                                            if (0 > i4 + coord.Y || i4 + coord.Y >= height || j + coord.X >= width) continue;
                                            SumPixel -= srcbbcol[pos + coord.Pos + jchan] & 0xFF;
                                            --nbpixel;
                                        }
                                        resbbcol[pos + jchan] = (byte)((double)SumPixel / (double)nbpixel + 0.5);
                                        ++j;
                                        jchan += channel;
                                    }
                                } else {
                                    SumPixel = 0;
                                    nbpixel = 0;
                                    for (CoordinatesWeighted coord : sec) {
                                        if (0 > coord.X || coord.X >= width) continue;
                                        SumPixel += srcbbcol[pos + coord.Pos] & 0xFF;
                                        ++nbpixel;
                                    }
                                    resbbcol[pos] = (byte)((double)SumPixel / (double)nbpixel + 0.5);
                                    j = 1;
                                    jchan = channel;
                                    while (j < MinX + 1) {
                                        for (CoordinatesWeighted coord : forward) {
                                            if (j + coord.X >= width) continue;
                                            SumPixel += srcbbcol[pos + coord.Pos + jchan] & 0xFF;
                                            ++nbpixel;
                                        }
                                        for (CoordinatesWeighted coord : backward) {
                                            if (0 > j + coord.X) continue;
                                            SumPixel -= srcbbcol[pos + coord.Pos + jchan] & 0xFF;
                                            --nbpixel;
                                        }
                                        resbbcol[pos + jchan] = (byte)((double)SumPixel / (double)nbpixel + 0.5);
                                        ++j;
                                        jchan += channel;
                                    }
                                    while (j < MaxX) {
                                        for (CoordinatesWeighted coord : forward) {
                                            SumPixel += srcbbcol[pos + coord.Pos + jchan] & 0xFF;
                                            ++nbpixel;
                                        }
                                        for (CoordinatesWeighted coord : backward) {
                                            SumPixel -= srcbbcol[pos + coord.Pos + jchan] & 0xFF;
                                            --nbpixel;
                                        }
                                        resbbcol[pos + jchan] = (byte)((double)SumPixel / (double)nbpixel + 0.5);
                                        ++j;
                                        jchan += channel;
                                    }
                                    while (j < this.maxx) {
                                        for (CoordinatesWeighted coord : forward) {
                                            if (j + coord.X >= width) continue;
                                            SumPixel += srcbbcol[pos + coord.Pos + jchan] & 0xFF;
                                            ++nbpixel;
                                        }
                                        for (CoordinatesWeighted coord : backward) {
                                            if (j + coord.X >= width) continue;
                                            SumPixel -= srcbbcol[pos + coord.Pos + jchan] & 0xFF;
                                            --nbpixel;
                                        }
                                        resbbcol[pos + jchan] = (byte)((double)SumPixel / (double)nbpixel + 0.5);
                                        ++j;
                                        jchan += channel;
                                    }
                                }
                                ++i4;
                                pos += widthchannel;
                            }
                        }
                        resbbcol = null;
                        srcbbcol = null;
                        continue block11;
                    }
                    case 1: 
                    case 4: {
                        int jchan;
                        int j;
                        int channel = this.wr.getNumBands();
                        int[] srcibcol = ((DataBufferInt)this.wr.getDataBuffer()).getData();
                        int[] resibcol = ((DataBufferInt)this.wrr.getDataBuffer()).getData();
                        channel = this.wr.getNumBands();
                        int widthchannel = width * channel;
                        for (int c = 0; c < channel; ++c) {
                            int i5 = this.miny;
                            int pos = this.miny * widthchannel + c;
                            while (i5 < this.maxy) {
                                int nbpixel;
                                int SumPixel;
                                if (i5 < MinY || MaxY <= i5) {
                                    SumPixel = 0;
                                    nbpixel = 0;
                                    for (CoordinatesWeighted coord : sec) {
                                        if (0 > coord.X || coord.X >= width || 0 > i5 + coord.Y || i5 + coord.Y >= height) continue;
                                        SumPixel += srcibcol[pos + coord.Pos];
                                        ++nbpixel;
                                    }
                                    resibcol[pos] = (int)((double)SumPixel / (double)nbpixel + 0.5);
                                    j = 1;
                                    jchan = channel;
                                    while (j <= MinX) {
                                        for (CoordinatesWeighted coord : forward) {
                                            if (j + coord.X >= width || 0 > i5 + coord.Y || i5 + coord.Y >= height) continue;
                                            SumPixel += srcibcol[pos + coord.Pos + jchan];
                                            ++nbpixel;
                                        }
                                        for (CoordinatesWeighted coord : backward) {
                                            if (0 > j + coord.X || 0 > i5 + coord.Y || i5 + coord.Y >= height) continue;
                                            SumPixel -= srcibcol[pos + coord.Pos + jchan];
                                            --nbpixel;
                                        }
                                        resibcol[pos + jchan] = (int)((double)SumPixel / (double)nbpixel + 0.5);
                                        ++j;
                                        jchan += channel;
                                    }
                                    while (j < MaxX) {
                                        for (CoordinatesWeighted coord : forward) {
                                            if (0 > i5 + coord.Y || i5 + coord.Y >= height) continue;
                                            SumPixel += srcibcol[pos + coord.Pos + jchan];
                                            ++nbpixel;
                                        }
                                        for (CoordinatesWeighted coord : backward) {
                                            if (0 > i5 + coord.Y || i5 + coord.Y >= height) continue;
                                            SumPixel -= srcibcol[pos + coord.Pos + jchan];
                                            --nbpixel;
                                        }
                                        resibcol[pos + jchan] = (int)((double)SumPixel / (double)nbpixel + 0.5);
                                        ++j;
                                        jchan += channel;
                                    }
                                    while (j < this.maxx) {
                                        for (CoordinatesWeighted coord : forward) {
                                            if (j + coord.X >= width || 0 > i5 + coord.Y || i5 + coord.Y >= height) continue;
                                            SumPixel += srcibcol[pos + coord.Pos + jchan];
                                            ++nbpixel;
                                        }
                                        for (CoordinatesWeighted coord : backward) {
                                            if (0 > i5 + coord.Y || i5 + coord.Y >= height || j + coord.X >= width) continue;
                                            SumPixel -= srcibcol[pos + coord.Pos + jchan];
                                            --nbpixel;
                                        }
                                        resibcol[pos + jchan] = (int)((double)SumPixel / (double)nbpixel + 0.5);
                                        ++j;
                                        jchan += channel;
                                    }
                                } else {
                                    SumPixel = 0;
                                    nbpixel = 0;
                                    for (CoordinatesWeighted coord : sec) {
                                        if (0 > coord.X || coord.X >= width) continue;
                                        SumPixel += srcibcol[pos + coord.Pos];
                                        ++nbpixel;
                                    }
                                    resibcol[pos] = (int)((double)SumPixel / (double)nbpixel + 0.5);
                                    j = 1;
                                    jchan = channel;
                                    while (j < MinX + 1) {
                                        for (CoordinatesWeighted coord : forward) {
                                            if (j + coord.X >= width) continue;
                                            SumPixel += srcibcol[pos + coord.Pos + jchan];
                                            ++nbpixel;
                                        }
                                        for (CoordinatesWeighted coord : backward) {
                                            if (0 > j + coord.X) continue;
                                            SumPixel -= srcibcol[pos + coord.Pos + jchan];
                                            --nbpixel;
                                        }
                                        resibcol[pos + jchan] = (int)((double)SumPixel / (double)nbpixel + 0.5);
                                        ++j;
                                        jchan += channel;
                                    }
                                    while (j < MaxX) {
                                        for (CoordinatesWeighted coord : forward) {
                                            SumPixel += srcibcol[pos + coord.Pos + jchan];
                                            ++nbpixel;
                                        }
                                        for (CoordinatesWeighted coord : backward) {
                                            SumPixel -= srcibcol[pos + coord.Pos + jchan];
                                            --nbpixel;
                                        }
                                        resibcol[pos + jchan] = (int)((double)SumPixel / (double)nbpixel + 0.5);
                                        ++j;
                                        jchan += channel;
                                    }
                                    while (j < this.maxx) {
                                        for (CoordinatesWeighted coord : forward) {
                                            if (j + coord.X >= width) continue;
                                            SumPixel += srcibcol[pos + coord.Pos + jchan];
                                            ++nbpixel;
                                        }
                                        for (CoordinatesWeighted coord : backward) {
                                            if (j + coord.X >= width) continue;
                                            SumPixel -= srcibcol[pos + coord.Pos + jchan];
                                            --nbpixel;
                                        }
                                        resibcol[pos + jchan] = (int)((double)SumPixel / (double)nbpixel + 0.5);
                                        ++j;
                                        jchan += channel;
                                    }
                                }
                                ++i5;
                                pos += widthchannel;
                            }
                        }
                        resibcol = null;
                        srcibcol = null;
                        continue block11;
                    }
                }
                break;
            }
            throw new IllegalArgumentException("Image type not supported.");
        }
    }

    private class ConvolutionFilterFVThread
    extends Thread {
        private WritableRaster wr = null;
        private WritableRaster wrr = null;
        private int Type;
        private int sizex = -1;
        private int sizey = -1;
        private StructuringElement se = null;
        private int minx;
        private int miny;
        private int maxx;
        private int maxy;
        private boolean Kill = false;
        public Object lock = new Object();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void Kill() {
            this.se = null;
            this.wrr = null;
            this.wr = null;
            this.Kill = true;
            Object object = this.lock;
            synchronized (object) {
                this.lock.notify();
            }
        }

        public void setConditions(BufferedImage source, BufferedImage result, StructuringElement se, int minx, int miny, int maxx, int maxy) {
            this.wr = source.getRaster();
            this.wrr = result.getRaster();
            this.Type = source.getType();
            this.se = se;
            this.sizex = se.getSizeX() >> 1;
            this.sizey = se.getSizeY() >> 1;
            this.minx = minx;
            this.miny = miny;
            this.maxx = maxx;
            this.maxy = maxy;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block11: while (true) {
                Object object = this.lock;
                synchronized (object) {
                    try {
                        ConvolutionFilter.this.addFreeThread();
                        this.lock.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                if (this.Kill) {
                    return;
                }
                int width = this.wr.getWidth();
                int height = this.wr.getHeight();
                int MinX = this.minx < this.sizex ? this.sizex : this.minx;
                int MinY = this.miny < this.sizey ? this.sizey : this.miny;
                int MaxX = this.maxx >= width - this.sizex ? width - this.sizex : this.maxx;
                int MaxY = this.maxy >= height - this.sizey ? height - this.sizey : this.maxy;
                int widthminussizex = width - this.sizex;
                int heightminussizey = height - this.sizey;
                int channel = this.wr.getNumBands();
                int widthchannel = width * channel;
                CoordinatesWeighted[] cws = this.se.getSE();
                switch (this.Type) {
                    case 10: {
                        int v;
                        double Sum2;
                        double Val;
                        int pos;
                        int x;
                        int y;
                        byte[] srcbb = ((DataBufferByte)this.wr.getDataBuffer()).getData();
                        byte[] resbb = ((DataBufferByte)this.wrr.getDataBuffer()).getData();
                        for (y = MinY; y < MaxY; ++y) {
                            x = MinX;
                            pos = y * width + x;
                            while (x < MaxX) {
                                if ((srcbb[pos] & 0xFF) != ConvolutionFilter.this.ForbiddenValue) {
                                    Val = 0.0;
                                    Sum2 = 0.0;
                                    for (CoordinatesWeighted cw : cws) {
                                        int v2 = srcbb[pos + cw.Pos] & 0xFF;
                                        if (v2 == ConvolutionFilter.this.ForbiddenValue) continue;
                                        Val += (double)v2 * cw.Wd;
                                        Sum2 += cw.Wd;
                                    }
                                    resbb[pos] = (byte)(Val / Sum2 + 0.5);
                                }
                                ++x;
                                ++pos;
                            }
                        }
                        for (y = this.miny; y < this.maxy; ++y) {
                            if (y >= this.sizey && heightminussizey > y) continue;
                            for (x = this.minx; x < this.maxx; ++x) {
                                if (x >= this.sizex && widthminussizex > x || (srcbb[pos = x + y * width] & 0xFF) == ConvolutionFilter.this.ForbiddenValue) continue;
                                Val = 0.0;
                                Sum2 = 0.0;
                                for (CoordinatesWeighted cw : cws) {
                                    int dx = x + cw.X;
                                    int dy = y + cw.Y;
                                    if (0 > dx || dx >= width || 0 > dy || dy >= height || (v = srcbb[pos + cw.Pos] & 0xFF) == ConvolutionFilter.this.ForbiddenValue) continue;
                                    Val += (double)v * cw.Wd;
                                    Sum2 += cw.Wd;
                                }
                                resbb[pos] = (byte)(Val / Sum2 + 0.5);
                            }
                        }
                        resbb = null;
                        srcbb = null;
                        continue block11;
                    }
                    case 11: {
                        int pos;
                        int y;
                        int v;
                        short[] srcsb = ((DataBufferUShort)this.wr.getDataBuffer()).getData();
                        short[] ressb = ((DataBufferUShort)this.wrr.getDataBuffer()).getData();
                        for (y = MinY; y < MaxY; ++y) {
                            int x = MinX;
                            pos = y * width + x;
                            while (x < MaxX) {
                                if ((srcsb[pos] & 0xFFFF) != ConvolutionFilter.this.ForbiddenValue) {
                                    double Val = 0.0;
                                    double Sum3 = 0.0;
                                    for (CoordinatesWeighted cw : cws) {
                                        v = srcsb[pos + cw.Pos] & 0xFFFF;
                                        if (v == ConvolutionFilter.this.ForbiddenValue) continue;
                                        Val += (double)v * cw.Wd;
                                        Sum3 += cw.Wd;
                                    }
                                    ressb[pos] = (short)(Val / Sum3 + 0.5);
                                }
                                ++x;
                                ++pos;
                            }
                        }
                        for (y = this.miny; y < this.maxy; ++y) {
                            if (y >= this.sizey && heightminussizey > y) continue;
                            for (int x = this.minx; x < this.maxx; ++x) {
                                if (x >= this.sizex && widthminussizex > x || (srcsb[pos = x + y * width] & 0xFFFF) == ConvolutionFilter.this.ForbiddenValue) continue;
                                double Val = 0.0;
                                double Sum4 = 0.0;
                                for (CoordinatesWeighted cw : cws) {
                                    int v3;
                                    int dx = x + cw.X;
                                    int dy = y + cw.Y;
                                    if (0 > dx || dx >= width || 0 > dy || dy >= height || (v3 = srcsb[pos + cw.Pos] & 0xFFFF) == ConvolutionFilter.this.ForbiddenValue) continue;
                                    Val += (double)v3 * cw.Wd;
                                    Sum4 += cw.Wd;
                                }
                                ressb[pos] = (short)(Val / Sum4 + 0.5);
                            }
                        }
                        ressb = null;
                        srcsb = null;
                        continue block11;
                    }
                    case 5: 
                    case 6: {
                        int v;
                        int ch;
                        byte[] srcbbcol = ((DataBufferByte)this.wr.getDataBuffer()).getData();
                        byte[] resbbcol = ((DataBufferByte)this.wrr.getDataBuffer()).getData();
                        for (int ch2 = 0; ch2 < channel; ++ch2) {
                            for (int y = MinY; y < MaxY; ++y) {
                                int x = MinX;
                                int pos = y * widthchannel + MinX * channel + ch2;
                                while (x < MaxX) {
                                    if ((srcbbcol[pos] & 0xFF) != ConvolutionFilter.this.ForbiddenValue) {
                                        double Val = 0.0;
                                        double Sum5 = 0.0;
                                        for (CoordinatesWeighted cw : cws) {
                                            int v4 = srcbbcol[pos + cw.Pos] & 0xFF;
                                            if (v4 == ConvolutionFilter.this.ForbiddenValue) continue;
                                            Val += (double)v4 * cw.Wd;
                                            Sum5 += cw.Wd;
                                        }
                                        resbbcol[pos] = (byte)(Val / Sum5 + 0.5);
                                    }
                                    ++x;
                                    pos += channel;
                                }
                            }
                        }
                        for (int y = this.miny; y < this.maxy; ++y) {
                            if (y >= this.sizey && heightminussizey > y) continue;
                            for (int x = this.minx; x < this.maxx; ++x) {
                                if (x >= this.sizex && widthminussizex > x) continue;
                                for (ch = 0; ch < channel; ++ch) {
                                    int pos = x * channel + y * widthchannel + ch;
                                    if ((srcbbcol[pos] & 0xFF) == ConvolutionFilter.this.ForbiddenValue) continue;
                                    double Val = 0.0;
                                    double Sum6 = 0.0;
                                    for (CoordinatesWeighted cw : cws) {
                                        int dx = x + cw.X;
                                        int dy = y + cw.Y;
                                        if (0 > dx || dx >= width || 0 > dy || dy >= height || (v = srcbbcol[pos + cw.Pos] & 0xFF) == ConvolutionFilter.this.ForbiddenValue) continue;
                                        Val += (double)v * cw.Wd;
                                        Sum6 += cw.Wd;
                                    }
                                    resbbcol[pos] = (byte)(Val / Sum6 + 0.5);
                                }
                            }
                        }
                        resbbcol = null;
                        srcbbcol = null;
                        continue block11;
                    }
                    case 1: 
                    case 4: {
                        int v;
                        int ch;
                        int[] srcibcol = ((DataBufferInt)this.wr.getDataBuffer()).getData();
                        int[] resibcol = ((DataBufferInt)this.wrr.getDataBuffer()).getData();
                        for (ch = 0; ch < channel; ++ch) {
                            for (int y = MinY; y < MaxY; ++y) {
                                int x = MinX;
                                int pos = y * widthchannel + MinX * channel + ch;
                                while (x < MaxX) {
                                    if (srcibcol[pos] != ConvolutionFilter.this.ForbiddenValue) {
                                        double Val = 0.0;
                                        double Sum7 = 0.0;
                                        for (CoordinatesWeighted cw : cws) {
                                            v = srcibcol[pos + cw.Pos];
                                            if (v == ConvolutionFilter.this.ForbiddenValue) continue;
                                            Val += (double)v * cw.Wd;
                                            Sum7 += cw.Wd;
                                        }
                                        resibcol[pos] = (int)(Val / Sum7 + 0.5);
                                    }
                                    ++x;
                                    pos += channel;
                                }
                            }
                        }
                        for (int y = this.miny; y < this.maxy; ++y) {
                            if (y >= this.sizey && heightminussizey > y) continue;
                            for (int x = this.minx; x < this.maxx; ++x) {
                                if (x >= this.sizex && widthminussizex > x) continue;
                                for (int ch3 = 0; ch3 < channel; ++ch3) {
                                    int pos = x * channel + y * widthchannel + ch3;
                                    if (srcibcol[pos] == ConvolutionFilter.this.ForbiddenValue) continue;
                                    double Val = 0.0;
                                    double Sum8 = 0.0;
                                    for (CoordinatesWeighted cw : cws) {
                                        int v5;
                                        int dx = x + cw.X;
                                        int dy = y + cw.Y;
                                        if (0 > dx || dx >= width || 0 > dy || dy >= height || (v5 = srcibcol[pos + cw.Pos]) == ConvolutionFilter.this.ForbiddenValue) continue;
                                        Val += (double)v5 * cw.Wd;
                                        Sum8 += cw.Wd;
                                    }
                                    resibcol[pos] = (int)(Val / Sum8 + 0.5);
                                }
                            }
                        }
                        resibcol = null;
                        srcibcol = null;
                        continue block11;
                    }
                }
                break;
            }
            throw new IllegalArgumentException("Image type not supported.");
        }
    }

    private class ConvolutionFilterThread
    extends Thread {
        private WritableRaster wr = null;
        private WritableRaster wrr = null;
        private int Type;
        private int sizex = -1;
        private int sizey = -1;
        private StructuringElement se = null;
        private int minx;
        private int miny;
        private int maxx;
        private int maxy;
        private boolean Kill = false;
        public Object lock = new Object();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void Kill() {
            this.se = null;
            this.wrr = null;
            this.wr = null;
            this.Kill = true;
            Object object = this.lock;
            synchronized (object) {
                this.lock.notify();
            }
        }

        public void setConditions(BufferedImage source, BufferedImage result, StructuringElement se, int minx, int miny, int maxx, int maxy) {
            this.wr = source.getRaster();
            this.wrr = result.getRaster();
            this.Type = source.getType();
            this.se = se;
            this.sizex = se.getSizeX() >> 1;
            this.sizey = se.getSizeY() >> 1;
            this.minx = minx;
            this.miny = miny;
            this.maxx = maxx;
            this.maxy = maxy;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block10: while (true) {
                Object object = this.lock;
                synchronized (object) {
                    try {
                        ConvolutionFilter.this.addFreeThread();
                        this.lock.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                if (this.Kill) {
                    return;
                }
                int width = this.wr.getWidth();
                int height = this.wr.getHeight();
                int MinX = this.minx < this.sizex ? this.sizex : this.minx;
                int MinY = this.miny < this.sizey ? this.sizey : this.miny;
                int MaxX = this.maxx >= width - this.sizex ? width - this.sizex : this.maxx;
                int MaxY = this.maxy >= height - this.sizey ? height - this.sizey : this.maxy;
                int widthminussizex = width - this.sizex;
                int heightminussizey = height - this.sizey;
                int popy = width - MaxX + MinX;
                CoordinatesWeighted[] cws = this.se.getSE();
                switch (this.Type) {
                    case 10: {
                        byte[] srcbb = ((DataBufferByte)this.wr.getDataBuffer()).getData();
                        byte[] resbb = ((DataBufferByte)this.wrr.getDataBuffer()).getData();
                        int y = MinY;
                        int pos = MinY * width + MinX;
                        while (y < MaxY) {
                            int x = MinX;
                            while (x < MaxX) {
                                double Val = 0.0;
                                for (CoordinatesWeighted cw : cws) {
                                    Val += (double)(srcbb[pos + cw.Pos] & 0xFF) * cw.Wd;
                                }
                                resbb[pos] = (byte)(Val + 0.5);
                                ++x;
                                ++pos;
                            }
                            ++y;
                            pos += popy;
                        }
                        for (y = this.miny; y < this.maxy; ++y) {
                            if (y >= this.sizey && heightminussizey > y) continue;
                            for (int x = this.minx; x < this.maxx; ++x) {
                                if (x >= this.sizex && widthminussizex > x) continue;
                                double Val = 0.0;
                                double Sum2 = 0.0;
                                int pos2 = x + y * width;
                                for (CoordinatesWeighted cw : cws) {
                                    int dx = x + cw.X;
                                    int dy = y + cw.Y;
                                    if (0 > dx || dx >= width || 0 > dy || dy >= height) continue;
                                    Val += (double)(srcbb[pos2 + cw.Pos] & 0xFF) * cw.Wd;
                                    Sum2 += cw.Wd;
                                }
                                resbb[pos2] = (byte)(Val / Sum2 + 0.5);
                            }
                        }
                        resbb = null;
                        srcbb = null;
                        continue block10;
                    }
                    case 11: {
                        short[] srcsb = ((DataBufferUShort)this.wr.getDataBuffer()).getData();
                        short[] ressb = ((DataBufferUShort)this.wrr.getDataBuffer()).getData();
                        int y = MinY;
                        int pos = MinY * width + MinX;
                        while (y < MaxY) {
                            int x = MinX;
                            while (x < MaxX) {
                                double Val = 0.0;
                                for (int c = 0; c < cws.length; ++c) {
                                    Val += (double)(srcsb[pos + cws[c].Pos] & 0xFFFF) * cws[c].Wd;
                                }
                                ressb[pos] = (short)(Val + 0.5);
                                ++x;
                                ++pos;
                            }
                            ++y;
                            pos += popy;
                        }
                        for (y = this.miny; y < this.maxy; ++y) {
                            if (y >= this.sizey && heightminussizey > y) continue;
                            for (int x = this.minx; x < this.maxx; ++x) {
                                if (x >= this.sizex && widthminussizex > x) continue;
                                double Val = 0.0;
                                double Sum3 = 0.0;
                                int pos3 = x + y * width;
                                for (CoordinatesWeighted cw : cws) {
                                    int dx = x + cw.X;
                                    int dy = y + cw.Y;
                                    if (0 > dx || dx >= width || 0 > dy || dy >= height) continue;
                                    Val += (double)(srcsb[pos3 + cw.Pos] & 0xFFFF) * cw.Wd;
                                    Sum3 += cw.Wd;
                                }
                                ressb[pos3] = (short)(Val / Sum3 + 0.5);
                            }
                        }
                        ressb = null;
                        srcsb = null;
                        continue block10;
                    }
                    case 5: 
                    case 6: {
                        byte[] srcbbcol = ((DataBufferByte)this.wr.getDataBuffer()).getData();
                        byte[] resbbcol = ((DataBufferByte)this.wrr.getDataBuffer()).getData();
                        int channel = this.wr.getNumBands();
                        popy *= channel;
                        for (int ch = 0; ch < channel; ++ch) {
                            int y = MinY;
                            int pos = (MinY * width + MinX) * channel + ch;
                            while (y < MaxY) {
                                int x = MinX;
                                while (x < MaxX) {
                                    double Val = 0.0;
                                    for (CoordinatesWeighted cw : cws) {
                                        Val += (double)(srcbbcol[pos + cw.Pos] & 0xFF) * cw.Wd;
                                    }
                                    resbbcol[pos] = (byte)(Val + 0.5);
                                    ++x;
                                    pos += channel;
                                }
                                ++y;
                                pos += popy;
                            }
                        }
                        for (int y = this.miny; y < this.maxy; ++y) {
                            if (y >= this.sizey && heightminussizey > y) continue;
                            for (int x = this.minx; x < this.maxx; ++x) {
                                if (x >= this.sizex && widthminussizex > x) continue;
                                for (int ch = 0; ch < channel; ++ch) {
                                    double Val = 0.0;
                                    double Sum4 = 0.0;
                                    int pos = (y * width + x) * channel + ch;
                                    for (CoordinatesWeighted cw : cws) {
                                        int dx = x + cw.X;
                                        int dy = y + cw.Y;
                                        if (0 > dx || dx >= width || 0 > dy || dy >= height) continue;
                                        Val += (double)(srcbbcol[pos + cw.Pos] & 0xFF) * cw.Wd;
                                        Sum4 += cw.Wd;
                                    }
                                    resbbcol[pos] = (byte)(Val / Sum4 + 0.5);
                                }
                            }
                        }
                        resbbcol = null;
                        srcbbcol = null;
                        continue block10;
                    }
                }
                break;
            }
            throw new IllegalArgumentException("Image type not supported.");
        }
    }
}

