/*
 * Decompiled with CFR 0.152.
 */
package processing.filters;

import arrayTiTi.ArrayComparator;
import imageTiTi.ImageNew;
import imageTiTi.ImageOperations;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import mathematics.functions.Function;
import mathematics.functions.Function1D;

public class ContrastModifier {
    private Function1D function;
    private int[] lut = null;

    public BufferedImage Filter(BufferedImage source, Function1D function, int nbCPU) {
        BufferedImage result = ImageNew.Same((BufferedImage)source);
        this.Filter(source, function, result, nbCPU);
        return result;
    }

    public void Filter(BufferedImage source, Function1D function, BufferedImage result, int nbCPU) {
        this.function = function;
        this.Filter(source, result, nbCPU);
    }

    public BufferedImage Filter(BufferedImage source, int nbCPU) {
        BufferedImage result = ImageNew.Same((BufferedImage)source);
        this.Filter(source, result, nbCPU);
        return result;
    }

    public void Filter(BufferedImage source, BufferedImage result, int nbCPU) {
        int max;
        if (this.function == null) {
            throw new IllegalArgumentException("Any function defined.");
        }
        switch (source.getType()) {
            case 10: {
                max = 255;
                break;
            }
            case 11: {
                max = 65535;
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported (yet).");
            }
        }
        if (this.lut == null || this.lut.length != max + 1) {
            this.lut = null;
            this.lut = new int[max + 1];
        }
        for (int i2 = 0; i2 < this.lut.length; ++i2) {
            this.lut[i2] = (int)Math.round(this.function.Compute((double)i2));
        }
        ArrayComparator.Compare((int[])this.lut, (String)">=", (int)0, (int[])this.lut, (int)0, (int[])this.lut);
        ArrayComparator.Compare((int[])this.lut, (String)"<=", (int)max, (int[])this.lut, (int)max, (int[])this.lut);
        ImageOperations.Lut((BufferedImage)source, (int[])this.lut, (BufferedImage)result);
    }

    public void Parameters(Object ... parameters) {
        if (parameters.length != 1) {
            throw new IllegalArgumentException("Exactly 1 parameter required.");
        }
        this.function = (Function1D)parameters[0];
    }

    public List<Object> Parameters() {
        ArrayList<Object> params = new ArrayList<Object>(1);
        params.add(this.function);
        return params;
    }

    public Function1D Linear(final double lambda, final int max) {
        return new Function1D(){
            private double mid;
            {
                this.mid = (double)max / 2.0;
            }

            @Override
            public double Compute(double X) {
                return this.mid + lambda * (X - this.mid);
            }

            @Override
            public float Compute(float X) {
                return (float)(this.mid + lambda * ((double)X - this.mid));
            }

            @Override
            public double Compute(double[] variables) {
                return this.Compute(variables[0]);
            }

            @Override
            public float Compute(float[] variables) {
                return this.Compute(variables[0]);
            }

            @Override
            public double ComputeSafer(double[] variables) {
                return this.Compute(variables[0]);
            }

            @Override
            public float ComputeSafer(float[] variables) {
                return this.Compute(variables[0]);
            }

            @Override
            public void setCoefficients(double[] Coefficients) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public void setCoefficients(float[] Coefficients) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public double[] getCoefficients(double[] useless) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public float[] getCoefficients(float[] useless) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public double Coefficient(int num, double[] useless) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public float Coefficient(int num, float[] useless) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public void Coefficient(int num, double value) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public void Coefficient(int num, float value) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public int Dimension() {
                return 1;
            }

            @Override
            public boolean hasConstant() {
                return false;
            }

            @Override
            public Function Clone() {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public Function Instance(double[] coefficients) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public Function Instance(float[] coefficients) {
                throw new UnsupportedOperationException("Not supported yet.");
            }
        };
    }

    public Function1D Sigmoid(final double lambda, final int max) {
        return new Function1D(){
            private double gap = 30.0;
            private double mid = (double)max / 2.0;

            @Override
            public double Compute(double X) {
                double LX = -lambda * (X / this.mid - 1.0) * this.gap;
                if (LX < -this.gap) {
                    return 0.0;
                }
                if (this.gap < LX) {
                    return max;
                }
                double val = 1.0 / (1.0 + Math.exp(LX));
                return val * (double)max;
            }

            @Override
            public float Compute(float X) {
                double LX = -lambda * ((double)X / this.mid - 1.0) * this.gap;
                if (LX < -this.gap) {
                    return 0.0f;
                }
                if (this.gap < LX) {
                    return max;
                }
                double val = 1.0 / (1.0 + Math.exp(LX));
                return (float)(val * (double)max);
            }

            @Override
            public double Compute(double[] variables) {
                return this.Compute(variables[0]);
            }

            @Override
            public float Compute(float[] variables) {
                return this.Compute(variables[0]);
            }

            @Override
            public double ComputeSafer(double[] variables) {
                return this.Compute(variables[0]);
            }

            @Override
            public float ComputeSafer(float[] variables) {
                return this.Compute(variables[0]);
            }

            @Override
            public void setCoefficients(double[] Coefficients) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public void setCoefficients(float[] Coefficients) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public double[] getCoefficients(double[] useless) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public float[] getCoefficients(float[] useless) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public double Coefficient(int num, double[] useless) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public float Coefficient(int num, float[] useless) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public void Coefficient(int num, double value) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public void Coefficient(int num, float value) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public int Dimension() {
                return 1;
            }

            @Override
            public boolean hasConstant() {
                return false;
            }

            @Override
            public Function Clone() {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public Function Instance(double[] coefficients) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public Function Instance(float[] coefficients) {
                throw new UnsupportedOperationException("Not supported yet.");
            }
        };
    }

    public Function1D HyperbolicTangent(final double lambda, final int max) {
        return new Function1D(){
            private double stretcher = 15.0;
            private double mid = (double)max / 2.0;

            @Override
            public double Compute(double X) {
                double LX = lambda * (X / this.mid - 1.0) * this.stretcher;
                double val = Math.exp(2.0 * LX);
                return this.mid * (val - 1.0) / (val + 1.0) + this.mid;
            }

            @Override
            public float Compute(float X) {
                double LX = lambda * ((double)X / this.mid - 1.0) * this.stretcher;
                double val = Math.exp(2.0 * LX);
                return (float)(this.mid * (val - 1.0) / (val + 1.0) + this.mid);
            }

            @Override
            public double Compute(double[] variables) {
                return this.Compute(variables[0]);
            }

            @Override
            public float Compute(float[] variables) {
                return this.Compute(variables[0]);
            }

            @Override
            public double ComputeSafer(double[] variables) {
                return this.Compute(variables[0]);
            }

            @Override
            public float ComputeSafer(float[] variables) {
                return this.Compute(variables[0]);
            }

            @Override
            public void setCoefficients(double[] Coefficients) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public void setCoefficients(float[] Coefficients) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public double[] getCoefficients(double[] useless) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public float[] getCoefficients(float[] useless) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public double Coefficient(int num, double[] useless) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public float Coefficient(int num, float[] useless) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public void Coefficient(int num, double value) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public void Coefficient(int num, float value) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public int Dimension() {
                return 1;
            }

            @Override
            public boolean hasConstant() {
                return false;
            }

            @Override
            public Function Clone() {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public Function Instance(double[] coefficients) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public Function Instance(float[] coefficients) {
                throw new UnsupportedOperationException("Not supported yet.");
            }
        };
    }
}

