/*
 * Decompiled with CFR 0.152.
 */
package processing.filters;

import arrayTiTi.ArrayArithmetic;
import dv.DV;
import imageTiTi.ImageFeatures;
import imageTiTi.ImageIO;
import imageTiTi.ImageNew;
import imageTiTi.ImageOperations;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferUShort;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import measures.histogram.Histogram;
import processing.filters.DynamicExpansion;
import processing.filters.SignalFilter;
import utils.strings.StringToolsImageDV;

public class ContrastEqualizer
implements SignalFilter {
    private Equalization mode;
    private int[] lut = null;
    private final Histogram hist = new Histogram();
    private final DynamicExpansion dynexp = new DynamicExpansion();
    private int WindowRadius = 256;
    private int Bins = 256;
    private float Slope = 5.0f;
    private int nbFreeThreads = 0;
    private CLAHEthread[] threads = null;
    private final ImageFeatures IF = new ImageFeatures();

    public BufferedImage Filter(BufferedImage source, Equalization mode, int nbCPU) {
        BufferedImage result = ImageNew.Same((BufferedImage)source);
        this.Filter(source, mode, result, nbCPU);
        return result;
    }

    public void Filter(BufferedImage source, Equalization mode, BufferedImage result, int nbCPU) {
        this.mode = mode;
        this.Filter(source, result, nbCPU);
    }

    public BufferedImage Filter(BufferedImage source, int nbCPU) {
        BufferedImage result = ImageNew.Same((BufferedImage)source);
        this.Filter(source, result, nbCPU);
        return result;
    }

    public void Filter(BufferedImage source, BufferedImage result, int nbCPU) {
        int max;
        switch (source.getType()) {
            case 10: {
                max = 255;
                this.Bins = 256;
                break;
            }
            case 11: {
                max = 65535;
                this.Bins = 65536;
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported (yet).");
            }
        }
        switch (this.mode) {
            case CLAHE: {
                this.CLAHE(source, this.WindowRadius, this.Bins, this.Slope, result, nbCPU);
                return;
            }
            case Stretching: {
                this.dynexp.Filter(source, 0, max, result, nbCPU);
                return;
            }
        }
        if (this.lut == null || this.lut.length != max + 1) {
            this.lut = null;
            this.lut = new int[max + 1];
        }
        this.hist.Fill(source);
        int[] histogram = this.hist.getValues(0);
        this.FillLut(histogram, max, source.getWidth() * source.getHeight(), this.lut);
        ImageOperations.Lut((BufferedImage)source, (int[])this.lut, (BufferedImage)result);
    }

    private void FillLut(int[] histogram, int max, int size, int[] lut) {
        switch (this.mode) {
            case Mode1: {
                int i2;
                double sum = histogram[0];
                for (i2 = 1; i2 < max; ++i2) {
                    sum += 2.0 * (double)histogram[i2];
                }
                double scale = (double)max / (sum += (double)histogram[max]);
                lut[0] = 0;
                sum = histogram[0];
                for (i2 = 1; i2 < max; ++i2) {
                    double delta = histogram[i2];
                    lut[i2] = (int)Math.round((sum += delta) * scale);
                    sum += delta;
                }
                lut[max] = max;
                break;
            }
            case Mode2: {
                int i3;
                double sum = this.getWeightedValueFalse(histogram, 0);
                for (i3 = 1; i3 < max; ++i3) {
                    sum += 2.0 * this.getWeightedValueFalse(histogram, i3);
                }
                double scale = (double)max / (sum += this.getWeightedValueFalse(histogram, max));
                lut[0] = 0;
                sum = this.getWeightedValueFalse(histogram, 0);
                for (i3 = 1; i3 < max; ++i3) {
                    double delta = this.getWeightedValueFalse(histogram, i3);
                    lut[i3] = (int)Math.round((sum += delta) * scale);
                    sum += delta;
                }
                lut[max] = max;
                break;
            }
            case Classic: {
                double sum = 0.0;
                for (int i4 = 0; i4 <= max; ++i4) {
                    lut[i4] = (int)Math.round((double)max * (sum += (double)histogram[i4] / (double)size));
                }
                break;
            }
            case CLAHE: {
                throw new IllegalArgumentException("Must not occur!");
            }
            case Stretching: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown mode.");
            }
        }
    }

    private double getWeightedValueFalse(int[] histogram, int i2) {
        int h = histogram[i2];
        if (h < 2) {
            return h;
        }
        return Math.sqrt(h);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void CLAHE(BufferedImage source, int blockRadius, int bins, float slope, BufferedImage result, int nbCPU) {
        Object object;
        int i2;
        if (!ImageTools.areDimensionsAndTypeEqual((BufferedImage)source, (BufferedImage)result)) {
            throw new IllegalArgumentException("Images have different  types or dimensions");
        }
        int height = source.getHeight();
        if (this.threads == null || this.threads.length != nbCPU) {
            this.nbFreeThreads = 0;
            this.threads = null;
            this.threads = new CLAHEthread[nbCPU];
            for (i2 = 0; i2 < nbCPU; ++i2) {
                this.threads[i2] = new CLAHEthread();
                this.threads[i2].start();
            }
        }
        ContrastEqualizer contrastEqualizer = this;
        synchronized (contrastEqualizer) {
            while (this.nbFreeThreads != nbCPU) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        int step = height / nbCPU;
        this.nbFreeThreads = 0;
        for (i2 = 0; i2 < nbCPU - 1; ++i2) {
            this.threads[i2].setConditions(source, blockRadius, bins, slope, result, i2 * step, (i2 + 1) * step);
            object = this.threads[i2].lock;
            synchronized (object) {
                this.threads[i2].lock.notify();
                continue;
            }
        }
        this.threads[i2].setConditions(source, blockRadius, bins, slope, result, i2 * step, height);
        object = this.threads[i2].lock;
        synchronized (object) {
            this.threads[i2].lock.notify();
        }
        object = this;
        synchronized (object) {
            while (this.nbFreeThreads != nbCPU) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void Filter(File[] images, Equalization mode, String resultdirpath) throws IOException {
        File resdir;
        int max;
        if (mode == Equalization.CLAHE) {
            throw new UnsupportedOperationException("Cannot work here.");
        }
        this.mode = mode;
        BufferedImage image = ImageIO.Read(images[0]);
        int length = image.getWidth() * image.getHeight();
        switch (image.getType()) {
            case 10: {
                max = 255;
                break;
            }
            case 11: {
                max = 65535;
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported (yet).");
            }
        }
        if (this.lut == null || this.lut.length != max + 1) {
            this.lut = null;
            this.lut = new int[max + 1];
        }
        if (!(resdir = new File(resultdirpath)).exists()) {
            resdir.mkdirs();
        }
        switch (mode) {
            case Classic: {
                double[] histogram = new double[max + 1];
                Arrays.fill(histogram, 0.0);
                File[] fileArray = images;
                int n = fileArray.length;
                for (int j = 0; j < n; ++j) {
                    File file = fileArray[j];
                    image = ImageIO.Read(file);
                    this.hist.Fill(image);
                    int[] histo = this.hist.getValues(0);
                    for (int x = 0; x < histo.length; ++x) {
                        int n2 = x;
                        histogram[n2] = histogram[n2] + (double)histo[x] / (double)length;
                    }
                    image = null;
                }
                ArrayArithmetic.Divide((double[])histogram, (double)images.length, (double[])histogram);
                double sum = 0.0;
                for (int i2 = 0; i2 <= max; ++i2) {
                    this.lut[i2] = (int)Math.round((double)max * (sum += histogram[i2]));
                }
                break;
            }
            case Mode1: 
            case Mode2: {
                int[] histo = new int[max + 1];
                Arrays.fill(histo, 0);
                for (File image1 : images) {
                    image = ImageIO.Read(image1);
                    this.hist.Fill(image);
                    ArrayArithmetic.Add((int[])histo, (int[])this.hist.getValues(0), (int[])histo);
                    image = null;
                }
                this.FillLut(histo, max, length, this.lut);
                break;
            }
            case Stretching: {
                int n;
                int n3 = Integer.MAX_VALUE;
                int graymax = Integer.MIN_VALUE;
                for (File image1 : images) {
                    image = ImageIO.Read(image1);
                    int v = (int)this.IF.Minimum(image);
                    if (v < n) {
                        n = v;
                    }
                    if (graymax < (v = (int)this.IF.Maximum(image))) {
                        graymax = v;
                    }
                    image = null;
                }
                for (File image1 : images) {
                    image = ImageIO.Read(image1);
                    String name = image1.getName();
                    String ext = StringToolsImageDV.FindExtension((String)name);
                    if (!ext.equals("png")) {
                        name = name.replace(ext, "png");
                    }
                    this.dynexp.Filter(image, n, graymax, 0, max, image, -1);
                    ImageIO.Write(image, resdir.getAbsolutePath() + "/" + name, 6);
                    image = null;
                }
                System.out.println("\n\n\nmin/max = " + n + " / " + graymax + "\n\n\n");
                return;
            }
        }
        for (File image1 : images) {
            void var12_24;
            image = ImageIO.Read(image1);
            ImageOperations.Lut((BufferedImage)image, (int[])this.lut, (BufferedImage)image);
            String string = image1.getName();
            String ext = StringToolsImageDV.FindExtension((String)string);
            if (!ext.equals("png")) {
                String string2 = string.replace(ext, "png");
            }
            ImageIO.Write(image, resdir.getAbsolutePath() + "/" + (String)var12_24, 6);
            image = null;
            ext = null;
            Object var12_25 = null;
        }
    }

    public DV Filter(DV source, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public void Filter(DV source, DV result, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public void WindowRadius(int WindowRadius) {
        if (WindowRadius < 1) {
            throw new IllegalArgumentException("WindowRadius < 1");
        }
        this.WindowRadius = WindowRadius;
    }

    public int WindowRadius() {
        return this.WindowRadius;
    }

    public void Bins(int Bins) {
        if (Bins < 2 || 65536 < Bins) {
            throw new IllegalArgumentException("Bins < 2 || 256 < Bins");
        }
        this.Bins = Bins;
    }

    public int Bins() {
        return this.Bins;
    }

    public void Slope(float Slope) {
        if (Slope < 1.0f) {
            throw new IllegalArgumentException("Slope < 1");
        }
        this.Slope = Slope;
    }

    public float Slope() {
        return this.Slope;
    }

    public void Parameters(Object ... parameters) {
        if (parameters.length != 1) {
            throw new IllegalArgumentException("Exactly 1 parameter required.");
        }
        this.mode = (Equalization)((Object)parameters[0]);
    }

    public List<Object> Parameters() {
        ArrayList<Object> params = new ArrayList<Object>(1);
        params.add((Object)this.mode);
        return params;
    }

    public int BorderEffectSizeX() {
        return 0;
    }

    public int BorderEffectSizeY() {
        return 0;
    }

    public int BorderEffectSizeZ() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public SignalFilter Clone() {
        ContrastEqualizer clone = new ContrastEqualizer();
        clone.Parameters(new Object[]{this.mode});
        clone.Bins(this.Bins);
        clone.Slope(this.Slope);
        clone.WindowRadius(this.WindowRadius);
        return clone;
    }

    protected synchronized void addFreeThread() {
        ++this.nbFreeThreads;
        this.notify();
    }

    private class CLAHEthread
    extends Thread {
        private int miny;
        private int maxy;
        private BufferedImage source;
        private BufferedImage result;
        private int blockRadius;
        private int bins;
        private float slope;
        public final Object lock = new Object();
        private boolean Kill = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void Kill() {
            this.result = null;
            this.source = null;
            this.Kill = true;
            Object object = this.lock;
            synchronized (object) {
                this.lock.notify();
            }
        }

        public void setConditions(BufferedImage source, int blockRadius, int bins, float slope, BufferedImage result, int miny, int maxy) {
            this.source = source;
            this.blockRadius = blockRadius;
            this.bins = bins;
            this.slope = slope;
            this.result = result;
            this.miny = miny;
            this.maxy = maxy;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            block9: while (true) {
                var1_2 = this.lock;
                synchronized (var1_2) {
                    try {
                        ContrastEqualizer.this.addFreeThread();
                        this.lock.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                if (this.Kill) {
                    return;
                }
                MinY = this.miny;
                MaxY = this.maxy;
                width = this.source.getWidth();
                height = this.source.getHeight();
                hist = new int[this.bins + 1];
                clippedHist = new int[this.bins + 1];
                switch (this.source.getType()) {
                    case 10: {
                        bbsrc = ((DataBufferByte)this.source.getRaster().getDataBuffer()).getData();
                        bbres = ((DataBufferByte)this.result.getRaster().getDataBuffer()).getData();
                        y = MinY;
                        pos = y * width;
                        while (true) {
                            if (y >= MaxY) continue block9;
                            yMin = Math.max(0, y - this.blockRadius);
                            yMax = Math.min(height, y + this.blockRadius + 1);
                            h = yMax - yMin;
                            xMin0 = false;
                            xMax0 = this.blockRadius;
                            Arrays.fill(hist, 0);
                            for (yi = yMin; yi < yMax; ++yi) {
                                xi = 0;
                                p = yi * width + xi;
                                while (xi < xMax0) {
                                    v0 = (int)((float)(bbsrc[p] & 255) / 255.0f * (float)this.bins + 0.5f);
                                    hist[v0] = hist[v0] + 1;
                                    ++xi;
                                    ++p;
                                }
                            }
                            x = 0;
                            while (x < width) {
                                v = (int)((float)(bbsrc[pos] & 255) / 255.0f * (float)this.bins + 0.5f);
                                xMin = Math.max(0, x - this.blockRadius);
                                xMax = x + this.blockRadius + 1;
                                w = Math.min(width, xMax) - xMin;
                                n = h * w;
                                limit = (int)(this.slope * (float)n / (float)this.bins + 0.5f);
                                if (0 < xMin) {
                                    xMin1 = xMin - 1;
                                    yi = yMin;
                                    p = yi * width + xMin1;
                                    while (yi < yMax) {
                                        v1 = (int)((float)(bbsrc[p] & 255) / 255.0f * (float)this.bins + 0.5f);
                                        hist[v1] = hist[v1] - 1;
                                        ++yi;
                                        p += width;
                                    }
                                }
                                if (xMax <= width) {
                                    xMax1 = xMax - 1;
                                    yi = yMin;
                                    p = yi * width + xMax1;
                                    while (yi < yMax) {
                                        v2 = (int)((float)(bbsrc[p] & 255) / 255.0f * (float)this.bins + 0.5f);
                                        hist[v2] = hist[v2] + 1;
                                        ++yi;
                                        p += width;
                                    }
                                }
                                System.arraycopy(hist, 0, clippedHist, 0, hist.length);
                                clippedEntries = 0;
                                do {
                                    clippedEntriesBefore = clippedEntries;
                                    clippedEntries = 0;
                                    for (i = 0; i <= this.bins; ++i) {
                                        d = clippedHist[i] - limit;
                                        if (0 >= d) continue;
                                        clippedEntries += d;
                                        clippedHist[i] = limit;
                                    }
                                    d = clippedEntries / hist.length;
                                    m = clippedEntries % hist.length;
                                    i = 0;
                                    while (i <= this.bins) {
                                        v3 = i++;
                                        clippedHist[v3] = clippedHist[v3] + d;
                                    }
                                    if (m == 0) continue;
                                    s = this.bins / m;
                                    for (i = 0; i <= this.bins; i += s) {
                                        v4 = i;
                                        clippedHist[v4] = clippedHist[v4] + 1;
                                    }
                                } while (clippedEntries != clippedEntriesBefore);
                                hMin = this.bins;
                                for (i = 0; i < hMin; ++i) {
                                    if (clippedHist[i] == 0) continue;
                                    hMin = i;
                                }
                                cdf = 0;
                                for (i = hMin; i <= v; ++i) {
                                    cdf += clippedHist[i];
                                }
                                cdfMax = cdf;
                                for (i = v + 1; i <= this.bins; ++i) {
                                    cdfMax += clippedHist[i];
                                }
                                cdfMin = clippedHist[hMin];
                                bbres[pos] = (byte)((float)(cdf - cdfMin) / (float)(cdfMax - cdfMin) * 255.0f + 0.5f);
                                ++x;
                                ++pos;
                            }
                            ++y;
                        }
                    }
                    case 11: {
                        sbsrc = ((DataBufferUShort)this.source.getRaster().getDataBuffer()).getData();
                        sbres = ((DataBufferUShort)this.result.getRaster().getDataBuffer()).getData();
                        y = MinY;
                        pos = y * width;
                        while (true) {
                            if (y < MaxY) ** break;
                            continue block9;
                            yMin = Math.max(0, y - this.blockRadius);
                            yMax = Math.min(height, y + this.blockRadius + 1);
                            h = yMax - yMin;
                            xMin0 = false;
                            xMax0 = this.blockRadius;
                            Arrays.fill(hist, 0);
                            for (yi = yMin; yi < yMax; ++yi) {
                                xi = 0;
                                p = yi * width + xi;
                                while (xi < xMax0) {
                                    v5 = (int)((float)(sbsrc[p] & 65535) / 65535.0f * (float)this.bins + 0.5f);
                                    hist[v5] = hist[v5] + 1;
                                    ++xi;
                                    ++p;
                                }
                            }
                            x = 0;
                            while (x < width) {
                                v = (int)((float)(sbsrc[pos] & 65535) / 65535.0f * (float)this.bins + 0.5f);
                                xMin = Math.max(0, x - this.blockRadius);
                                xMax = x + this.blockRadius + 1;
                                w = Math.min(width, xMax) - xMin;
                                n = h * w;
                                limit = (int)(this.slope * (float)n / (float)this.bins + 0.5f);
                                if (0 < xMin) {
                                    xMin1 = xMin - 1;
                                    yi = yMin;
                                    p = yi * width + xMin1;
                                    while (yi < yMax) {
                                        v6 = (int)((float)(sbsrc[p] & 65535) / 65535.0f * (float)this.bins + 0.5f);
                                        hist[v6] = hist[v6] - 1;
                                        ++yi;
                                        p += width;
                                    }
                                }
                                if (xMax <= width) {
                                    xMax1 = xMax - 1;
                                    yi = yMin;
                                    p = yi * width + xMax1;
                                    while (yi < yMax) {
                                        v7 = (int)((float)(sbsrc[p] & 65535) / 65535.0f * (float)this.bins + 0.5f);
                                        hist[v7] = hist[v7] + 1;
                                        ++yi;
                                        p += width;
                                    }
                                }
                                System.arraycopy(hist, 0, clippedHist, 0, hist.length);
                                clippedEntries = 0;
                                do {
                                    clippedEntriesBefore = clippedEntries;
                                    clippedEntries = 0;
                                    for (i = 0; i <= this.bins; ++i) {
                                        d = clippedHist[i] - limit;
                                        if (0 >= d) continue;
                                        clippedEntries += d;
                                        clippedHist[i] = limit;
                                    }
                                    d = clippedEntries / hist.length;
                                    m = clippedEntries % hist.length;
                                    i = 0;
                                    while (i <= this.bins) {
                                        v8 = i++;
                                        clippedHist[v8] = clippedHist[v8] + d;
                                    }
                                    if (m == 0) continue;
                                    s = this.bins / m;
                                    for (i = 0; i <= this.bins; i += s) {
                                        v9 = i;
                                        clippedHist[v9] = clippedHist[v9] + 1;
                                    }
                                } while (clippedEntries != clippedEntriesBefore);
                                hMin = this.bins;
                                for (i = 0; i < hMin; ++i) {
                                    if (clippedHist[i] == 0) continue;
                                    hMin = i;
                                }
                                cdf = 0;
                                for (i = hMin; i <= v; ++i) {
                                    cdf += clippedHist[i];
                                }
                                cdfMax = cdf;
                                for (i = v + 1; i <= this.bins; ++i) {
                                    cdfMax += clippedHist[i];
                                }
                                cdfMin = clippedHist[hMin];
                                sbres[pos] = (short)((float)(cdf - cdfMin) / (float)(cdfMax - cdfMin) * 65535.0f + 0.5f);
                                ++x;
                                ++pos;
                            }
                            ++y;
                        }
                    }
                    default: {
                        throw new UnsupportedOperationException("Image type not supported (yet).");
                    }
                }
                break;
            }
        }
    }

    public static enum Equalization {
        Mode1,
        Mode2,
        Classic,
        CLAHE,
        Stretching;

    }
}

