/*
 * Decompiled with CFR 0.152.
 */
package processing.filters;

import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;

public class ColourDeconvolution {
    public static final int HE = 0;
    public static final int HE2 = 1;
    public static final int HDAB = 2;
    public static final int FeulgenLightGreen = 3;
    public static final int Giemsa = 4;
    public static final int FastRedFastBlueDAB = 5;
    public static final int MethylGreenDAB = 6;
    public static final int HEDAB = 7;
    public static final int HAEC = 8;
    public static final int AzanMallory = 9;
    public static final int MassonTrichrome = 10;
    public static final int AlcianBlueH = 12;
    public static final int HPAS = 13;
    public static final int RGB = 14;
    public static final int CMY = 15;
    private double[][] MODx = new double[16][3];
    private double[][] MODy = new double[16][3];
    private double[][] MODz = new double[16][3];

    public ColourDeconvolution() {
        this.MODx[0][0] = 0.644211;
        this.MODy[0][0] = 0.716556;
        this.MODz[0][0] = 0.266844;
        this.MODx[0][1] = 0.092789;
        this.MODy[0][1] = 0.954111;
        this.MODz[0][1] = 0.283111;
        this.MODx[0][2] = 0.0;
        this.MODy[0][2] = 0.0;
        this.MODz[0][2] = 0.0;
        this.MODx[1][0] = 0.49015734;
        this.MODy[1][0] = 0.76897085;
        this.MODz[1][0] = 0.41040173;
        this.MODx[1][1] = 0.04615336;
        this.MODy[1][1] = 0.8420684;
        this.MODz[1][1] = 0.5373925;
        this.MODx[1][2] = 0.0;
        this.MODy[1][2] = 0.0;
        this.MODz[1][2] = 0.0;
        this.MODx[2][0] = 0.65;
        this.MODy[2][0] = 0.704;
        this.MODz[2][0] = 0.286;
        this.MODx[2][1] = 0.268;
        this.MODy[2][1] = 0.57;
        this.MODz[2][1] = 0.776;
        this.MODx[2][2] = 0.0;
        this.MODy[2][2] = 0.0;
        this.MODz[2][2] = 0.0;
        this.MODx[3][0] = 0.46420921;
        this.MODy[3][0] = 0.83008335;
        this.MODz[3][0] = 0.30827187;
        this.MODx[3][1] = 0.94705542;
        this.MODy[3][1] = 0.25373821;
        this.MODz[3][1] = 0.19650764;
        this.MODx[3][2] = 0.0;
        this.MODy[3][2] = 0.0;
        this.MODz[3][2] = 0.0;
        this.MODx[4][0] = 0.834750233;
        this.MODy[4][0] = 0.513556283;
        this.MODz[4][0] = 0.196330403;
        this.MODx[4][1] = 0.092789;
        this.MODy[4][1] = 0.954111;
        this.MODz[4][1] = 0.283111;
        this.MODx[4][2] = 0.0;
        this.MODy[4][2] = 0.0;
        this.MODz[4][2] = 0.0;
        this.MODx[5][0] = 0.21393921;
        this.MODy[5][0] = 0.85112669;
        this.MODz[5][0] = 0.47794022;
        this.MODx[5][1] = 0.74890292;
        this.MODy[5][1] = 0.60624161;
        this.MODz[5][1] = 0.26731082;
        this.MODx[5][2] = 0.268;
        this.MODy[5][2] = 0.57;
        this.MODz[5][2] = 0.776;
        this.MODx[6][0] = 0.98003;
        this.MODy[6][0] = 0.144316;
        this.MODz[6][0] = 0.133146;
        this.MODx[6][1] = 0.268;
        this.MODy[6][1] = 0.57;
        this.MODz[6][1] = 0.776;
        this.MODx[6][2] = 0.0;
        this.MODy[6][2] = 0.0;
        this.MODz[6][2] = 0.0;
        this.MODx[7][0] = 0.65;
        this.MODy[7][0] = 0.704;
        this.MODz[7][0] = 0.286;
        this.MODx[7][1] = 0.072;
        this.MODy[7][1] = 0.99;
        this.MODz[7][1] = 0.105;
        this.MODx[7][2] = 0.268;
        this.MODy[7][2] = 0.57;
        this.MODz[7][2] = 0.776;
        this.MODx[8][0] = 0.65;
        this.MODy[8][0] = 0.704;
        this.MODz[8][0] = 0.286;
        this.MODx[8][1] = 0.2743;
        this.MODy[8][1] = 0.6796;
        this.MODz[8][1] = 0.6803;
        this.MODx[8][2] = 0.0;
        this.MODy[8][2] = 0.0;
        this.MODz[8][2] = 0.0;
        this.MODx[9][0] = 0.853033;
        this.MODy[9][0] = 0.508733;
        this.MODz[9][0] = 0.112656;
        this.MODx[9][1] = 0.09289875;
        this.MODy[9][1] = 0.8662008;
        this.MODz[9][1] = 0.49098468;
        this.MODx[9][2] = 0.10732849;
        this.MODy[9][2] = 0.36765403;
        this.MODz[9][2] = 0.9237484;
        this.MODx[10][0] = 0.7995107;
        this.MODy[10][0] = 0.5913521;
        this.MODz[10][0] = 0.10528667;
        this.MODx[10][1] = 0.09997159;
        this.MODy[10][1] = 0.73738605;
        this.MODz[10][1] = 0.6680326;
        this.MODx[10][2] = 0.0;
        this.MODy[10][2] = 0.0;
        this.MODz[10][2] = 0.0;
        this.MODx[12][0] = 0.874622;
        this.MODy[12][0] = 0.457711;
        this.MODz[12][0] = 0.158256;
        this.MODx[12][1] = 0.552556;
        this.MODy[12][1] = 0.7544;
        this.MODz[12][1] = 0.353744;
        this.MODx[12][2] = 0.0;
        this.MODy[12][2] = 0.0;
        this.MODz[12][2] = 0.0;
        this.MODx[13][0] = 0.644211;
        this.MODy[13][0] = 0.716556;
        this.MODz[13][0] = 0.266844;
        this.MODx[13][1] = 0.175411;
        this.MODy[13][1] = 0.972178;
        this.MODz[13][1] = 0.154589;
        this.MODx[13][2] = 0.0;
        this.MODy[13][2] = 0.0;
        this.MODz[13][2] = 0.0;
        this.MODx[14][0] = 0.0;
        this.MODy[14][0] = 1.0;
        this.MODz[14][0] = 1.0;
        this.MODx[14][1] = 1.0;
        this.MODy[14][1] = 0.0;
        this.MODz[14][1] = 1.0;
        this.MODx[14][2] = 1.0;
        this.MODy[14][2] = 1.0;
        this.MODz[14][2] = 0.0;
        this.MODx[15][0] = 1.0;
        this.MODy[15][0] = 0.0;
        this.MODz[15][0] = 0.0;
        this.MODx[15][1] = 0.0;
        this.MODy[15][1] = 1.0;
        this.MODz[15][1] = 0.0;
        this.MODx[15][2] = 0.0;
        this.MODy[15][2] = 0.0;
        this.MODz[15][2] = 1.0;
    }

    public BufferedImage[] Compute(BufferedImage source, BufferedImage result, int Operation) {
        int i2;
        int width = source.getWidth();
        int height = source.getHeight();
        double log255 = Math.log(255.0);
        double[] cosx = new double[3];
        double[] cosy = new double[3];
        double[] cosz = new double[3];
        double[] len = new double[3];
        double[] q = new double[9];
        byte[] rLUT = new byte[256];
        byte[] gLUT = new byte[256];
        byte[] bLUT = new byte[256];
        switch (Operation) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown technique.");
            }
        }
        for (i2 = 0; i2 < 3; ++i2) {
            cosz[i2] = 0.0;
            cosy[i2] = 0.0;
            cosx[i2] = 0.0;
            len[i2] = Math.sqrt(this.MODx[Operation][i2] * this.MODx[Operation][i2] + this.MODy[Operation][i2] * this.MODy[Operation][i2] + this.MODz[Operation][i2] * this.MODz[Operation][i2]);
            if (len[i2] == 0.0) continue;
            cosx[i2] = this.MODx[Operation][i2] / len[i2];
            cosy[i2] = this.MODy[Operation][i2] / len[i2];
            cosz[i2] = this.MODz[Operation][i2] / len[i2];
        }
        if (cosx[1] == 0.0 && cosy[1] == 0.0 && cosz[1] == 0.0) {
            cosx[1] = cosz[0];
            cosy[1] = cosx[0];
            cosz[1] = cosy[0];
        }
        if (cosx[2] == 0.0 && cosy[2] == 0.0 && cosz[2] == 0.0) {
            cosx[2] = cosx[0] * cosx[0] + cosx[1] * cosx[1] > 1.0 ? 0.0 : Math.sqrt(1.0 - cosx[0] * cosx[0] - cosx[1] * cosx[1]);
            cosy[2] = cosy[0] * cosy[0] + cosy[1] * cosy[1] > 1.0 ? 0.0 : Math.sqrt(1.0 - cosy[0] * cosy[0] - cosy[1] * cosy[1]);
            cosz[2] = cosz[0] * cosz[0] + cosz[1] * cosz[1] > 1.0 ? 0.0 : Math.sqrt(1.0 - cosz[0] * cosz[0] - cosz[1] * cosz[1]);
        }
        double leng = Math.sqrt(cosx[2] * cosx[2] + cosy[2] * cosy[2] + cosz[2] * cosz[2]);
        cosx[2] = cosx[2] / leng;
        cosy[2] = cosy[2] / leng;
        cosz[2] = cosz[2] / leng;
        for (i2 = 0; i2 < 3; ++i2) {
            if (cosx[i2] == 0.0) {
                cosx[i2] = 0.001;
            }
            if (cosy[i2] == 0.0) {
                cosy[i2] = 0.001;
            }
            if (cosz[i2] != 0.0) continue;
            cosz[i2] = 0.001;
        }
        double A = cosy[1] - cosx[1] * cosy[0] / cosx[0];
        double V = cosz[1] - cosx[1] * cosz[0] / cosx[0];
        double C = cosz[2] - cosy[2] * V / A + cosx[2] * (V / A * cosy[0] / cosx[0] - cosz[0] / cosx[0]);
        q[2] = (-cosx[2] / cosx[0] - cosx[2] / A * cosx[1] / cosx[0] * cosy[0] / cosx[0] + cosy[2] / A * cosx[1] / cosx[0]) / C;
        q[1] = -q[2] * V / A - cosx[1] / (cosx[0] * A);
        q[0] = 1.0 / cosx[0] - q[1] * cosy[0] / cosx[0] - q[2] * cosz[0] / cosx[0];
        q[5] = (-cosy[2] / A + cosx[2] / A * cosy[0] / cosx[0]) / C;
        q[4] = -q[5] * V / A + 1.0 / A;
        q[3] = -q[4] * cosy[0] / cosx[0] - q[5] * cosz[0] / cosx[0];
        q[8] = 1.0 / C;
        q[7] = -q[8] * V / A;
        q[6] = -q[7] * cosy[0] / cosx[0] - q[8] * cosz[0] / cosx[0];
        BufferedImage[] outputstack = new BufferedImage[3];
        for (i2 = 0; i2 < 3; ++i2) {
            for (int j = 0; j < 256; ++j) {
                rLUT[255 - j] = (byte)(255.0 - (double)j * cosx[i2]);
                gLUT[255 - j] = (byte)(255.0 - (double)j * cosy[i2]);
                bLUT[255 - j] = (byte)(255.0 - (double)j * cosz[i2]);
            }
            IndexColorModel cm = new IndexColorModel(8, 256, rLUT, gLUT, bLUT);
            outputstack[i2] = new BufferedImage(width, height, 13, cm);
        }
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int p = source.getRGB(x, y);
                int R = (p & 0xFF0000) >> 16;
                int G = (p & 0xFF00) >> 8;
                int B = p & 0xFF;
                double Rlog = -(255.0 * Math.log(((double)R + 1.0) / 255.0) / log255);
                double Glog = -(255.0 * Math.log(((double)G + 1.0) / 255.0) / log255);
                double Blog = -(255.0 * Math.log(((double)B + 1.0) / 255.0) / log255);
                for (i2 = 0; i2 < 3; ++i2) {
                    double Rscaled = Rlog * q[i2 * 3];
                    double Gscaled = Glog * q[i2 * 3 + 1];
                    double Bscaled = Blog * q[i2 * 3 + 2];
                    double output = Math.exp(-(Rscaled + Gscaled + Bscaled - 255.0) * log255 / 255.0);
                    if (output > 255.0) {
                        output = 255.0;
                    }
                    result.getRaster().setSample(x, y, i2, 0xFF & (int)Math.floor(output + 0.5));
                    outputstack[i2].getRaster().setSample(x, y, 0, 0xFF & (int)Math.floor(output + 0.5));
                }
            }
        }
        return outputstack;
    }
}

