/*
 * Decompiled with CFR 0.152.
 */
package processing.filters;

import dv.DV;
import imageTiTi.ImageNew;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import processing.filters.SignalFilter;

public class ColorNormalization
implements SignalFilter {
    private double[] averages;
    private double[] variances;
    private int[] sizes;
    private int[] ForbiddenValues = new int[3];

    public ColorNormalization() {
        Arrays.fill(this.ForbiddenValues, -1);
    }

    public BufferedImage Filter(BufferedImage source, int nbCPU) {
        BufferedImage result = ImageNew.Same((BufferedImage)source);
        this.Filter(source, result, nbCPU);
        return result;
    }

    public void Filter(BufferedImage source, BufferedImage result, int nbCPU) {
        int c;
        int x;
        int y;
        int max;
        int channel;
        if (this.averages == null) {
            throw new IllegalArgumentException("Any image reference affected.");
        }
        if (!ImageTools.areDimensionsAndTypeEqual((BufferedImage)source, (BufferedImage)result)) {
            throw new IllegalArgumentException("Images source and result have different type or dimension");
        }
        int width = source.getWidth();
        int height = source.getHeight();
        WritableRaster wrs = source.getRaster();
        WritableRaster wrr = result.getRaster();
        switch (source.getType()) {
            case 10: {
                channel = 1;
                max = 255;
                break;
            }
            case 11: {
                channel = 1;
                max = 65535;
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                channel = 3;
                max = 255;
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported.");
            }
        }
        if (this.averages.length != channel) {
            throw new IllegalArgumentException("Images reference and source have a different number of channel.");
        }
        int[] szs = new int[channel];
        double[] ave = new double[channel];
        double[] var = new double[channel];
        double[] ci = new double[channel];
        double[] mi = new double[channel];
        Arrays.fill(ave, 0.0);
        Arrays.fill(szs, 0);
        Arrays.fill(var, 0.0);
        for (y = 0; y < height; ++y) {
            for (x = 0; x < width; ++x) {
                for (c = 0; c < channel; ++c) {
                    if (wrs.getSample(x, y, c) == this.ForbiddenValues[c]) continue;
                    int n = c;
                    ave[n] = ave[n] + wrs.getSampleDouble(x, y, c);
                    int n2 = c;
                    szs[n2] = szs[n2] + 1;
                }
            }
        }
        for (c = 0; c < channel; ++c) {
            int n = c;
            ave[n] = ave[n] / (double)szs[c];
        }
        for (y = 0; y < height; ++y) {
            for (x = 0; x < width; ++x) {
                for (c = 0; c < channel; ++c) {
                    if (wrs.getSample(x, y, c) == this.ForbiddenValues[c]) continue;
                    int n = c;
                    var[n] = var[n] + Math.pow(wrs.getSampleDouble(x, y, c) - ave[c], 2.0);
                }
            }
        }
        for (c = 0; c < channel; ++c) {
            var[c] = Math.sqrt(var[c] / (double)szs[c]);
        }
        for (c = 0; c < channel; ++c) {
            mi[c] = this.variances[c] / var[c];
            ci[c] = this.averages[c] - mi[c] / ave[c];
        }
        for (y = 0; y < height; ++y) {
            for (x = 0; x < width; ++x) {
                for (c = 0; c < channel; ++c) {
                    if (wrs.getSample(x, y, c) == this.ForbiddenValues[c]) continue;
                    int p = (int)(mi[c] * wrs.getSampleDouble(x, y, c) + ci[c] + 0.5);
                    if (p < 0) {
                        p = 0;
                    }
                    if (p > max) {
                        p = max;
                    }
                    wrr.setSample(x, y, c, p);
                }
            }
        }
    }

    public DV Filter(DV source, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public void Filter(DV source, DV result, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public void setReference(BufferedImage reference) {
        int c;
        int x;
        int y;
        int channel;
        int width = reference.getWidth();
        int height = reference.getHeight();
        WritableRaster wr = reference.getRaster();
        switch (reference.getType()) {
            case 10: 
            case 11: {
                channel = 1;
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                channel = 3;
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported.");
            }
        }
        if (this.averages == null || this.averages.length != channel) {
            this.averages = null;
            this.averages = new double[channel];
            this.sizes = null;
            this.sizes = new int[channel];
            this.variances = null;
            this.variances = new double[channel];
        }
        Arrays.fill(this.averages, 0.0);
        Arrays.fill(this.sizes, 0);
        Arrays.fill(this.variances, 0.0);
        for (y = 0; y < height; ++y) {
            for (x = 0; x < width; ++x) {
                for (c = 0; c < channel; ++c) {
                    if (wr.getSample(x, y, c) == this.ForbiddenValues[c]) continue;
                    int n = c;
                    this.averages[n] = this.averages[n] + wr.getSampleDouble(x, y, c);
                    int n2 = c;
                    this.sizes[n2] = this.sizes[n2] + 1;
                }
            }
        }
        for (c = 0; c < channel; ++c) {
            int n = c;
            this.averages[n] = this.averages[n] / (double)this.sizes[c];
        }
        for (y = 0; y < height; ++y) {
            for (x = 0; x < width; ++x) {
                for (c = 0; c < channel; ++c) {
                    if (wr.getSample(x, y, c) == this.ForbiddenValues[c]) continue;
                    int n = c;
                    this.variances[n] = this.variances[n] + Math.pow(wr.getSampleDouble(x, y, c) - this.averages[c], 2.0);
                }
            }
        }
        for (c = 0; c < channel; ++c) {
            this.variances[c] = Math.sqrt(this.variances[c] / (double)this.sizes[c]);
        }
    }

    public void Parameters(Object ... parameters) {
        if (parameters.length != 5) {
            throw new IllegalArgumentException("Exactly 1 parameter required.");
        }
        this.setReference((BufferedImage)parameters[0]);
        this.setForbiddenValues((Integer)parameters[1], (Integer)parameters[2], (Integer)parameters[3]);
    }

    public List<Object> Parameters() {
        ArrayList<Object> params = new ArrayList<Object>(5);
        params.add(this.averages);
        params.add(this.variances);
        params.add(this.ForbiddenValues[0]);
        params.add(this.ForbiddenValues[1]);
        params.add(this.ForbiddenValues[2]);
        return params;
    }

    public int BorderEffectSizeX() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public int BorderEffectSizeY() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public int BorderEffectSizeZ() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public SignalFilter Clone() {
        throw new UnsupportedOperationException("Not supported (yet).");
    }

    public void setForbiddenValues(int value) {
        this.setForbiddenValues(value, value, value);
    }

    public void setForbiddenValues(int R, int G, int B) {
        this.ForbiddenValues[0] = R;
        this.ForbiddenValues[1] = G;
        this.ForbiddenValues[2] = B;
    }
}

