/*
 * Decompiled with CFR 0.152.
 */
package processing.filters;

import imageTiTi.ImageNew;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import java.util.List;

public class Bilateral {
    private double[][] w_similarity = new double[256][256];
    private int Radius = 0;
    private int Iter = 0;
    private double Factor = 0.0;

    public BufferedImage Filter(BufferedImage source, int nbCPU) {
        BufferedImage result = ImageNew.Same((BufferedImage)source);
        this.Filter(source, result, nbCPU);
        return result;
    }

    public void Filter(BufferedImage input, BufferedImage output, int nbCPU) {
        if (this.Radius <= 0) {
            throw new IllegalArgumentException("Parameters not defined.");
        }
        this.Filter(input, this.Radius, this.Iter, this.Factor, output, nbCPU);
    }

    public void Filter(BufferedImage Original, int radius, int iter, double factor, BufferedImage Result, int nbCPU) {
        double yy;
        int j;
        double xx;
        int i2;
        int dim = 2 * radius + 1;
        if (!ImageTools.areDimensionsAndTypeEqual((BufferedImage)Original, (BufferedImage)Result)) {
            throw new IllegalArgumentException("Image have different type or dimensions");
        }
        switch (Original.getType()) {
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 10: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported.");
            }
        }
        for (i2 = 0; i2 < 256; ++i2) {
            xx = (double)i2 / 255.0;
            double lx = Math.pow(xx, 0.33);
            for (j = 0; j < 256; ++j) {
                yy = (double)j / 255.0;
                double ly = Math.pow(yy, 0.33);
                double d = Math.abs(lx - ly) * Math.pow(2.0, factor);
                this.w_similarity[i2][j] = Math.exp(-d * d);
            }
        }
        double[][] w_spatial = new double[dim][dim];
        double w_spatial_sum = 0.0;
        double sigma2 = 2.0 * Math.pow((double)radius / 2.5, 2.0);
        for (i2 = 0; i2 < dim; ++i2) {
            for (j = 0; j < dim; ++j) {
                xx = i2 - radius;
                yy = j - radius;
                w_spatial[i2][j] = Math.exp(-(xx * xx + yy * yy) / sigma2);
                w_spatial_sum += w_spatial[i2][j];
            }
        }
        for (i2 = 0; i2 < dim; ++i2) {
            j = 0;
            while (j < dim) {
                double[] dArray = w_spatial[i2];
                int n = j++;
                dArray[n] = dArray[n] / w_spatial_sum;
            }
        }
        int W = Original.getWidth();
        int H = Original.getHeight();
        BufferedImage input = ImageNew.Clone((BufferedImage)Original);
        BufferedImage output = Result;
        WritableRaster wr = Original.getRaster();
        WritableRaster wrin = input.getRaster();
        WritableRaster wrout = output.getRaster();
        for (int loop = 0; loop < iter; ++loop) {
            if (loop > 0) {
                BufferedImage temp = input;
                input = output;
                output = temp;
            }
            for (int c = 0; c < wrin.getNumBands(); ++c) {
                for (int y = 0; y < H; ++y) {
                    for (int x = 0; x < W; ++x) {
                        int v = wrin.getSample(x, y, c);
                        double newv = 0.0;
                        double sumvw = 0.0;
                        for (int dy = -radius; dy <= radius; ++dy) {
                            for (int dx = -radius; dx <= radius; ++dx) {
                                int xk = x + dx;
                                int yk = y + dy;
                                if (xk < 0 || xk >= W || yk < 0 || yk >= H) continue;
                                int vk = wrin.getSample(xk, yk, c);
                                int v0k = wr.getSample(xk, yk, c);
                                double vw = w_spatial[dx + radius][dy + radius] * this.w_similarity[v][vk];
                                newv += vw * (double)v0k;
                                sumvw += vw;
                            }
                        }
                        wrout.setSample(x, y, c, (int)(0.5 + newv / sumvw));
                    }
                }
            }
        }
    }

    public void Parameters(Object ... parameters) {
        if (parameters.length != 3) {
            throw new IllegalArgumentException("Exactly 3 parameters required.");
        }
        this.Radius = (Integer)parameters[0];
        this.Iter = (Integer)parameters[1];
        this.Factor = (Double)parameters[2];
        if (this.Radius < 1) {
            throw new IllegalArgumentException("Radius < 1.");
        }
        if (this.Iter < 1) {
            throw new IllegalArgumentException("Iter < 1.");
        }
    }

    public List<Object> Parameters() {
        ArrayList<Object> params = new ArrayList<Object>(3);
        params.add(this.Radius);
        params.add(this.Iter);
        params.add(this.Factor);
        return params;
    }
}

