/*
 * Decompiled with CFR 0.152.
 */
package processing.filters;

import dv.DV;
import imageTiTi.ImageNew;
import imageTiTi.ImageOperations;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import morphee.Close;
import morphee.MorphoFilter;
import morphee.Open;
import morphee.StructuringElement;
import morphee.StructuringElement3D;
import processing.filters.Average;
import processing.filters.Median;
import processing.filters.SignalFilter;

public class Backgrounds
implements MorphoFilter {
    public static final int FromMaxima = -1;
    public static final int FromMinima = -2;
    public static final int FromMedian = -3;
    private Average average = new Average();
    private Close close = new Close();
    private Median median = new Median();
    private Open open = new Open();
    private StructuringElement se = null;
    private BufferedImage tmp;
    public int mode = -1;

    public BufferedImage Filter(BufferedImage source, int nbCPU) {
        BufferedImage result = ImageNew.Same((BufferedImage)source);
        this.Filter(source, result, nbCPU);
        return result;
    }

    public void Filter(BufferedImage source, BufferedImage result, int nbCPU) {
        if (this.se == null) {
            throw new IllegalArgumentException("Structuring element not defined.");
        }
        this.Filter(source, this.se, result, nbCPU);
    }

    public BufferedImage Filter(BufferedImage source, StructuringElement se, int nbCPU) {
        BufferedImage result = ImageNew.Same((BufferedImage)source);
        this.Filter(source, se, result, nbCPU);
        return result;
    }

    public void Filter(BufferedImage source, StructuringElement se, BufferedImage result, int nbCPU) {
        if (!ImageTools.areDimensionsAndTypeEqual((BufferedImage)source, (BufferedImage)result)) {
            throw new IllegalArgumentException("Images source and result have different type or dimensions.");
        }
        if (this.tmp == null || !ImageTools.areDimensionsAndTypeEqual((BufferedImage)source, (BufferedImage)this.tmp)) {
            this.tmp = null;
            this.tmp = ImageNew.Same((BufferedImage)source);
        } else {
            ImageOperations.Fill((BufferedImage)this.tmp, (int)0);
        }
        switch (this.mode) {
            case -1: {
                this.close.Filter(source, se, this.tmp, nbCPU);
                break;
            }
            case -2: {
                this.open.Filter(source, se, this.tmp, nbCPU);
                break;
            }
            case -3: {
                this.median.Filter(source, se, this.tmp, nbCPU);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown mode.");
            }
        }
        Average.CreateMask(se);
        this.average.Filter(this.tmp, se, result, nbCPU);
    }

    public DV Filter(DV source, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public void Filter(DV source, DV result, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public DV Filter(DV source, StructuringElement3D se, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public void Filter(DV source, StructuringElement3D se, DV result, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public StructuringElement getStructuringElement() {
        return this.se;
    }

    public void setStructuringElement(StructuringElement se) {
        this.se = se;
    }

    public StructuringElement3D getStructuringElement3D() {
        return null;
    }

    public void setStructuringElement3D(StructuringElement3D se) {
    }

    public void Parameters(Object ... parameters) {
        if (parameters.length != 2) {
            throw new IllegalArgumentException("Exactly two parameters required.");
        }
        this.se = (StructuringElement)parameters[0];
        this.mode = (Integer)parameters[1];
    }

    public List<Object> Parameters() {
        ArrayList<Object> list = new ArrayList<Object>(2);
        list.add(this.se);
        list.add(this.mode);
        return list;
    }

    public int BorderEffectSizeX() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public int BorderEffectSizeY() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public int BorderEffectSizeZ() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public SignalFilter Clone() {
        throw new UnsupportedOperationException("Not supported (yet).");
    }
}

