/*
 * Decompiled with CFR 0.152.
 */
package processing.filters;

import dv.DV;
import dv.DvNew;
import dv.DvTools;
import imageTiTi.ImageIO;
import imageTiTi.ImageNew;
import imageTiTi.ImageOperations;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.io.IOException;
import mathematics.fourier.Butterfly;
import mathematics.fourier.JTransformsComplex;
import mathematics.fourier.JTransformsReal;
import morphee.StructuringElement;
import morphee.StructuringElement3D;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import processing.filters.Average;
import utils.memory.Allocator;
import utils.times.Chronometer;

public class AverageTest {
    private final Allocator allocator = Allocator.Instance();
    private static final Chronometer chrono = new Chronometer();
    private static int TimePoint = -1;

    @BeforeAll
    public static void setUpClass() {
        System.out.println("\n ---------------------------------- Starting test on class Average ---------------------------------- ");
        TimePoint = chrono.NewMarker();
    }

    @AfterAll
    public static void tearDownClass() {
        System.out.println("Class Average tests done in " + chrono.getTimeSinceMarker(TimePoint) + "s.\n\n");
    }

    private int getRandomDim(int base, int var) {
        return base + (Math.random() < 0.5 ? -1 : 1) * (int)(Math.random() * (double)var + 0.5);
    }

    private void LogError(BufferedImage src, BufferedImage res1, BufferedImage res2, String prefix) throws IOException {
        ImageIO.Write(src, prefix + " - Source.png", 6);
        ImageIO.Write(res1, prefix + " - Result 1.png", 6);
        ImageIO.Write(res2, prefix + " - Result 2.png", 6);
        ImageIO.Write(ImageOperations.Differences((BufferedImage)res1, (BufferedImage)res2), prefix + " - Differences.png", 6);
    }

    public void testFilter_BufferedImage_int() throws IOException {
        String text;
        BufferedImage res4;
        BufferedImage res3;
        BufferedImage res2;
        BufferedImage res1;
        int height;
        int width;
        int sy;
        int sx;
        BufferedImage source;
        System.out.println("Filter(BufferedImage, nbCPU)");
        Average instance = new Average();
        StructuringElement[] ses = new StructuringElement[]{Average.CreateMask(1, -1), Average.CreateMask(3, -1), Average.CreateMask(7, -1), Average.CreateMask(1, -2), Average.CreateMask(5, -2), Average.CreateMask(11, -2), Average.CreateMask(4, -5), Average.CreateMask(7, -5), Average.CreateMask(3, -6), Average.CreateMask(6, -6), Average.CreateMask(3, -8)};
        int BaseDim = 256;
        int VarDim = 13;
        Butterfly butterfly = new Butterfly();
        JTransformsReal jtr = new JTransformsReal(false, true);
        JTransformsComplex jtc = new JTransformsComplex();
        for (StructuringElement se : ses) {
            source = ImageNew.Random((int)this.getRandomDim(256, 13), (int)this.getRandomDim(256, 13), (int)10);
            sx = se.getOrder();
            sy = se.getOrder();
            width = source.getWidth() - 2 * sx;
            height = source.getHeight() - 2 * sy;
            instance.Parameters(se, null, -1);
            res1 = ImageNew.SubImageWH((BufferedImage)instance.Filter(source, 4), (int)sx, (int)sy, (int)width, (int)height);
            instance.Parameters(se, butterfly, -1);
            res2 = ImageNew.SubImageWH((BufferedImage)instance.Filter(source, 3), (int)sx, (int)sy, (int)width, (int)height);
            instance.Parameters(se, jtr, -1);
            res3 = ImageNew.SubImageWH((BufferedImage)instance.Filter(source, 5), (int)sx, (int)sy, (int)width, (int)height);
            instance.Parameters(se, jtc, -1);
            res4 = ImageNew.SubImageWH((BufferedImage)instance.Filter(source, 6), (int)sx, (int)sy, (int)width, (int)height);
            if (!ImageTools.areEqual((BufferedImage)res1, (BufferedImage)res2)) {
                text = "Average Byte, 1 vs 2, type=" + se.getType() + ", order=" + se.getOrder();
                this.LogError(source, res1, res2, text);
                Assertions.fail(text);
            }
            if (!ImageTools.areEqual((BufferedImage)res1, (BufferedImage)res3)) {
                text = "Average Byte, 1 vs 3, type=" + se.getType() + ", order=" + se.getOrder();
                this.LogError(source, res1, res3, text);
                Assertions.fail(text);
            }
            if (!ImageTools.areEqual((BufferedImage)res1, (BufferedImage)res4)) {
                text = "Average Byte, 1 vs 4, type=" + se.getType() + ", order=" + se.getOrder();
                this.LogError(source, res1, res4, text);
                Assertions.fail(text);
            }
            if (!ImageTools.areEqual((BufferedImage)res2, (BufferedImage)res3)) {
                text = "Average Byte, 2 vs 3, type=" + se.getType() + ", order=" + se.getOrder();
                this.LogError(source, res2, res3, text);
                Assertions.fail(text);
            }
            if (!ImageTools.areEqual((BufferedImage)res2, (BufferedImage)res4)) {
                text = "Average Byte, 2 vs 4, type=" + se.getType() + ", order=" + se.getOrder();
                this.LogError(source, res2, res4, text);
                Assertions.fail(text);
            }
            if (!ImageTools.areEqual((BufferedImage)res3, (BufferedImage)res4)) {
                text = "Average Byte, 3 vs 4, type=" + se.getType() + ", order=" + se.getOrder();
                this.LogError(source, res3, res4, text);
                Assertions.fail(text);
            }
            res4 = null;
            res3 = null;
            res2 = null;
            res1 = null;
            source = null;
        }
        for (StructuringElement se : ses) {
            source = ImageNew.Random((int)this.getRandomDim(256, 13), (int)this.getRandomDim(256, 13), (int)11);
            sx = se.getOrder();
            sy = se.getOrder();
            width = source.getWidth() - 2 * sx;
            height = source.getHeight() - 2 * sy;
            instance.Parameters(se, null, -1);
            res1 = ImageNew.SubImageWH((BufferedImage)instance.Filter(source, 4), (int)sx, (int)sy, (int)width, (int)height);
            instance.Parameters(se, butterfly, -1);
            res2 = ImageNew.SubImageWH((BufferedImage)instance.Filter(source, 3), (int)sx, (int)sy, (int)width, (int)height);
            instance.Parameters(se, jtr, -1);
            res3 = ImageNew.SubImageWH((BufferedImage)instance.Filter(source, 5), (int)sx, (int)sy, (int)width, (int)height);
            instance.Parameters(se, jtc, -1);
            res4 = ImageNew.SubImageWH((BufferedImage)instance.Filter(source, 6), (int)sx, (int)sy, (int)width, (int)height);
            if (!ImageTools.areEqual((BufferedImage)res1, (BufferedImage)res2)) {
                text = "Average UShort, 1 vs 2, type=" + se.getType() + ", order=" + se.getOrder();
                this.LogError(source, res1, res2, text);
                Assertions.fail(text);
            }
            if (!ImageTools.areEqual((BufferedImage)res1, (BufferedImage)res3)) {
                text = "Average UShort, 1 vs 3, type=" + se.getType() + ", order=" + se.getOrder();
                this.LogError(source, res1, res3, text);
                Assertions.fail(text);
            }
            if (!ImageTools.areEqual((BufferedImage)res1, (BufferedImage)res4)) {
                text = "Average UShort, 1 vs 4, type=" + se.getType() + ", order=" + se.getOrder();
                this.LogError(source, res1, res4, text);
                Assertions.fail(text);
            }
            if (!ImageTools.areEqual((BufferedImage)res2, (BufferedImage)res3)) {
                text = "Average UShort, 2 vs 3, type=" + se.getType() + ", order=" + se.getOrder();
                this.LogError(source, res2, res3, text);
                Assertions.fail(text);
            }
            if (!ImageTools.areEqual((BufferedImage)res2, (BufferedImage)res4)) {
                text = "Average UShort, 2 vs 4, type=" + se.getType() + ", order=" + se.getOrder();
                this.LogError(source, res2, res4, text);
                Assertions.fail(text);
            }
            if (!ImageTools.areEqual((BufferedImage)res3, (BufferedImage)res4)) {
                text = "Average UShort, 3 vs 4, type=" + se.getType() + ", order=" + se.getOrder();
                this.LogError(source, res3, res4, text);
                Assertions.fail(text);
            }
            res4 = null;
            res3 = null;
            res2 = null;
            res1 = null;
            source = null;
        }
    }

    @Test
    public void testFilter_DV_int() {
        DV res3;
        DV res2;
        DV res1;
        int sizez;
        int sizey;
        int sizex;
        int sz;
        int sy;
        int sx;
        DV source;
        System.out.println("Filter(DV, nbCPU)");
        Average instance = new Average();
        StructuringElement3D[] ses = new StructuringElement3D[]{Average.CreateMask3D(1, -1), Average.CreateMask3D(3, -1), Average.CreateMask3D(6, -1), Average.CreateMask3D(1, -2), Average.CreateMask3D(4, -2), Average.CreateMask3D(11, -2)};
        int BaseDim = 128;
        int VarDim = 13;
        JTransformsReal jtr = new JTransformsReal(false, true);
        JTransformsComplex jtc = new JTransformsComplex();
        for (StructuringElement3D se : ses) {
            source = DvNew.Random((int)this.getRandomDim(128, 13), (int)this.getRandomDim(128, 13), (int)this.getRandomDim(128, 13), (int)1, (int)8);
            sx = se.getOrder();
            sy = se.getOrder();
            sz = se.getOrder();
            sizex = source.SizeX - 2 * sx;
            sizey = source.SizeY - 2 * sy;
            sizez = source.SizeZ - 2 * sz;
            instance.Parameters(se, null, -1);
            res1 = DvNew.Crop((DV)instance.Filter(source, 4), (int)sx, (int)sy, (int)sz, (int)sizex, (int)sizey, (int)sizez);
            instance.Parameters(se, jtc, -1);
            res2 = DvNew.Crop((DV)instance.Filter(source, 6), (int)sx, (int)sy, (int)sz, (int)sizex, (int)sizey, (int)sizez);
            instance.Parameters(se, jtr, -1);
            res3 = DvNew.Crop((DV)instance.Filter(source, 5), (int)sx, (int)sy, (int)sz, (int)sizex, (int)sizey, (int)sizez);
            if (!DvTools.areEqual((DV)res1, (DV)res2)) {
                Assertions.fail("Average 3D Byte, 1 vs 2, type=" + se.getType() + ", order=" + se.getOrder());
            }
            if (!DvTools.areEqual((DV)res1, (DV)res3)) {
                Assertions.fail("Average 3D Byte, 1 vs 3, type=" + se.getType() + ", order=" + se.getOrder());
            }
            if (!DvTools.areEqual((DV)res2, (DV)res3)) {
                Assertions.fail("Average 3D Byte, 2 vs 3, type=" + se.getType() + ", order=" + se.getOrder());
            }
            res3 = null;
            res2 = null;
            res1 = null;
            source = null;
        }
        for (StructuringElement3D se : ses) {
            source = DvNew.Random((int)this.getRandomDim(128, 13), (int)this.getRandomDim(128, 13), (int)this.getRandomDim(128, 13), (int)1, (int)16);
            sx = se.getOrder();
            sy = se.getOrder();
            sz = se.getOrder();
            sizex = source.SizeX - 2 * sx;
            sizey = source.SizeY - 2 * sy;
            sizez = source.SizeZ - 2 * sz;
            instance.Parameters(se, null, -1);
            res1 = DvNew.Crop((DV)instance.Filter(source, 4), (int)sx, (int)sy, (int)sz, (int)sizex, (int)sizey, (int)sizez);
            instance.Parameters(se, jtc, -1);
            res2 = DvNew.Crop((DV)instance.Filter(source, 6), (int)sx, (int)sy, (int)sz, (int)sizex, (int)sizey, (int)sizez);
            instance.Parameters(se, jtr, -1);
            res3 = DvNew.Crop((DV)instance.Filter(source, 5), (int)sx, (int)sy, (int)sz, (int)sizex, (int)sizey, (int)sizez);
            if (!DvTools.areEqual((DV)res1, (DV)res2)) {
                Assertions.fail("Average 3D Byte, 1 vs 2, type=" + se.getType() + ", order=" + se.getOrder());
            }
            if (!DvTools.areEqual((DV)res1, (DV)res3)) {
                Assertions.fail("Average 3D Byte, 1 vs 3, type=" + se.getType() + ", order=" + se.getOrder());
            }
            if (!DvTools.areEqual((DV)res2, (DV)res3)) {
                Assertions.fail("Average 3D Byte, 2 vs 3, type=" + se.getType() + ", order=" + se.getOrder());
            }
            res3 = null;
            res2 = null;
            res1 = null;
            source = null;
        }
    }
}

