/*
 * Decompiled with CFR 0.152.
 */
package processing.filters;

import dv.DV;
import dv.DvNew;
import imageTiTi.ImageNew;
import java.awt.image.BufferedImage;
import java.util.List;
import mathematics.primitives.pointsTiTi.CoordinatesWeighted;
import morphee.MorphoFilter;
import morphee.StructuringElement;
import morphee.StructuringElement3D;
import processing.filters.ConvolutionFilter;

public class Average
implements MorphoFilter {
    private ConvolutionFilter filter = null;

    public Average() {
        this.filter = new ConvolutionFilter();
    }

    public Average(ConvolutionFilter filter) {
        this.filter = filter;
    }

    public BufferedImage Filter(BufferedImage source, StructuringElement se, int nbCPU) {
        BufferedImage result = ImageNew.Same((BufferedImage)source);
        this.Filter(source, se, result, nbCPU);
        return result;
    }

    public void Filter(BufferedImage source, StructuringElement se, BufferedImage result, int nbCPU) {
        this.setStructuringElement(se);
        this.Filter(source, result, nbCPU);
    }

    public BufferedImage Filter(BufferedImage source, int nbCPU) {
        BufferedImage result = ImageNew.Same((BufferedImage)source);
        this.Filter(source, result, nbCPU);
        return result;
    }

    public void Filter(BufferedImage source, BufferedImage result, int nbCPU) {
        this.filter.Filter(source, result, nbCPU);
    }

    public DV Filter(DV source, int nbCPU) {
        DV result = DvNew.Same((DV)source);
        this.Filter(source, result, nbCPU);
        return result;
    }

    public void Filter(DV source, DV result, int nbCPU) {
        this.filter.Filter(source, result, nbCPU);
    }

    public DV Filter(DV source, StructuringElement3D se, int nbCPU) {
        this.setStructuringElement3D(se);
        return this.Filter(source, nbCPU);
    }

    public void Filter(DV source, StructuringElement3D se, DV result, int nbCPU) {
        this.setStructuringElement3D(se);
        this.Filter(source, result, nbCPU);
    }

    public static StructuringElement CreateMask(int radius, int type) {
        StructuringElement se = new StructuringElement(new Object[]{radius, type});
        Average.CreateMask(se);
        return se;
    }

    public static void CreateMask(StructuringElement se) {
        double w = 1.0 / (double)se.getSE().length;
        CoordinatesWeighted[] coords = se.getSE();
        for (int i2 = 0; i2 < se.getSE().length; ++i2) {
            coords[i2].Wd = w;
        }
        coords = null;
        se.CheckIfFlat();
        se.ComputeSumOfWeights();
    }

    public static StructuringElement3D CreateMask3D(int radius, int type) {
        StructuringElement3D se = new StructuringElement3D(new Object[]{radius, type});
        Average.CreateMask3D(se);
        return se;
    }

    public static void CreateMask3D(StructuringElement3D se) {
        double w = 1.0 / (double)se.getSE().length;
        CoordinatesWeighted[] coords = se.getSE();
        for (int i2 = 0; i2 < se.getSE().length; ++i2) {
            coords[i2].Wd = w;
        }
        coords = null;
        se.CheckIfFlat();
        se.ComputeSumOfWeights();
    }

    public void setStructuringElement(StructuringElement se) {
        this.filter.setStructuringElement(se);
    }

    public StructuringElement getStructuringElement() {
        return this.filter.getStructuringElement();
    }

    public StructuringElement3D getStructuringElement3D() {
        return this.filter.getStructuringElement3D();
    }

    public void setStructuringElement3D(StructuringElement3D se) {
        this.filter.setStructuringElement3D(se);
    }

    public void Parameters(Object ... parameters) {
        this.filter.Parameters(parameters);
    }

    public List<Object> Parameters() {
        return this.filter.Parameters();
    }

    public int BorderEffectSizeX() {
        return this.filter.BorderEffectSizeX();
    }

    public int BorderEffectSizeY() {
        return this.filter.BorderEffectSizeY();
    }

    public int BorderEffectSizeZ() {
        return this.filter.BorderEffectSizeZ();
    }

    public Average Clone() {
        return new Average((ConvolutionFilter)this.filter.Clone());
    }
}

