/*
 * Decompiled with CFR 0.152.
 */
package processing.filters;

import dv.DV;
import imageTiTi.ImageNew;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.util.List;
import processing.filters.SignalFilter;

public class AbsoluteChannelGap
implements SignalFilter {
    public BufferedImage Filter(BufferedImage source, int nbCPU) {
        BufferedImage result = ImageNew.Same((BufferedImage)source);
        this.Filter(source, result, nbCPU);
        return result;
    }

    public void Filter(BufferedImage source, BufferedImage result, int nbCPU) {
        if (!ImageTools.areDimensionsAndTypeEqual((BufferedImage)source, (BufferedImage)result)) {
            throw new IllegalArgumentException("Images source and result have different types or dimensions.");
        }
        switch (source.getType()) {
            case 5: {
                byte[] bbsrc = ((DataBufferByte)source.getRaster().getDataBuffer()).getData();
                byte[] bbres = ((DataBufferByte)result.getRaster().getDataBuffer()).getData();
                for (int x = 0; x < bbsrc.length; x += 3) {
                    int b = bbsrc[x] & 0xFF;
                    int g = bbsrc[x + 1] & 0xFF;
                    int r = bbsrc[x + 2] & 0xFF;
                    bbres[x] = (byte)Math.abs(b - g);
                    bbres[x + 1] = (byte)Math.abs(b - r);
                    bbres[x + 2] = (byte)Math.abs(g - r);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("");
            }
        }
    }

    public DV Filter(DV source, int nbCPU) {
        DV result = new DV(source.SizeX, source.SizeY, source.SizeZ, source.Channel * (source.Channel - 1) >> 1, source.Type);
        this.Filter(source, result, nbCPU);
        return result;
    }

    public void Filter(DV source, DV result, int nbCPU) {
        if (source.SizeX != result.SizeX) {
            throw new IllegalArgumentException("DV source and result have different types.");
        }
        if (source.Type != result.Type) {
            throw new IllegalArgumentException("DV source and result have different types.");
        }
        if (source.Channel == 1) {
            throw new IllegalArgumentException("The DV source has a single channel.");
        }
        int channel = source.Channel * (source.Channel - 1) >> 1;
        if (result.Channel != channel) {
            throw new IllegalArgumentException(channel + " channels required into the DV result.");
        }
        switch (source.Type) {
            case 8: {
                int cn = 0;
                for (int c1 = 0; c1 < source.Channel - 1; ++c1) {
                    byte[] bbsrc1 = source.getDataBufferByte(c1);
                    int c2 = 0;
                    while (c2 < source.Channel) {
                        byte[] bbsrc2 = source.getDataBufferByte(c2);
                        byte[] bbres = result.getDataBufferByte(cn);
                        for (int x = 0; x < bbsrc1.length; ++x) {
                            bbres[x] = (byte)Math.abs((bbsrc2[x] & 0xFF) - (bbsrc1[x] & 0xFF));
                        }
                        ++c1;
                        ++cn;
                    }
                }
                break;
            }
            case 16: {
                int cn = 0;
                for (int c1 = 0; c1 < source.Channel - 1; ++c1) {
                    short[] sbsrc1 = source.getDataBufferShort(c1);
                    int c2 = 0;
                    while (c2 < source.Channel) {
                        short[] sbsrc2 = source.getDataBufferShort(c2);
                        short[] sbres = result.getDataBufferShort(cn);
                        for (int x = 0; x < sbsrc1.length; ++x) {
                            sbres[x] = (short)Math.abs((sbsrc2[x] & 0xFF) - (sbsrc1[x] & 0xFF));
                        }
                        ++c1;
                        ++cn;
                    }
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("");
            }
        }
    }

    public int BorderEffectSizeX() {
        return 0;
    }

    public int BorderEffectSizeY() {
        return 0;
    }

    public int BorderEffectSizeZ() {
        return 0;
    }

    public void Parameters(Object ... parameters) {
    }

    public List<Object> Parameters() {
        return null;
    }

    public SignalFilter Clone() {
        return new AbsoluteChannelGap();
    }
}

