/*
 * Decompiled with CFR 0.152.
 */
package processing.effects;

import dv.DV;
import imageTiTi.ImageNew;
import imageTiTi.ImageOperations;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import processing.filters.DynamicExpansion;
import processing.filters.Gaussian;
import processing.filters.SignalFilter;
import processing.filters.gradients.SignalGradient;
import processing.thresholding.Binary;

public class Blooming
implements SignalFilter {
    private SignalGradient gradient = null;
    private SignalFilter threshold = new Binary();
    private SignalFilter filter = new Gaussian();
    private DynamicExpansion dynexp = new DynamicExpansion();

    public BufferedImage Filter(BufferedImage source, int nbCPU) {
        BufferedImage result = ImageNew.Same((BufferedImage)source);
        this.Filter(source, result, nbCPU);
        return result;
    }

    public void Filter(BufferedImage source, BufferedImage result, int nbCPU) {
        BufferedImage resgrad = null;
        BufferedImage resgradthres = null;
        BufferedImage resexp = null;
        BufferedImage resflow = null;
        switch (source.getType()) {
            case 10: {
                resgrad = this.gradient.Filter(source, nbCPU);
                resgradthres = this.threshold.Filter(resgrad, nbCPU);
                resflow = this.filter.Filter(resgradthres, nbCPU);
                resexp = this.dynexp.Filter(resflow, 0, 255, nbCPU);
                ImageOperations.Maximum((BufferedImage)source, (BufferedImage)resexp, (BufferedImage)result);
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported.");
            }
        }
        resgrad = null;
        resgradthres = null;
        resflow = null;
        resexp = null;
    }

    public DV Filter(DV source, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public void Filter(DV source, DV result, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public void Parameters(Object ... parameters) {
        if (parameters.length != 4) {
            throw new IllegalArgumentException("Exactly 1 parameter required.");
        }
        this.gradient = (SignalGradient)parameters[0];
        this.threshold.Parameters(new Object[]{(Integer)parameters[1]});
        this.filter.Parameters(new Object[]{(Integer)parameters[2], (Double)parameters[3]});
    }

    public List<Object> Parameters() {
        ArrayList<Object> list = new ArrayList<Object>(4);
        list.add(this.gradient);
        list.add((Integer)this.threshold.Parameters().get(0));
        list.add((Integer)this.filter.Parameters().get(0));
        list.add((Double)this.filter.Parameters().get(1));
        return list;
    }

    public int BorderEffectSizeX() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public int BorderEffectSizeY() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public int BorderEffectSizeZ() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public SignalGradient Clone() {
        throw new UnsupportedOperationException("Not supported (yet).");
    }
}

