/*
 * Decompiled with CFR 0.152.
 */
package processing.denoising;

import arrayTiTi.ArrayArithmetic;
import arrayTiTi.ArrayComparator;
import arrayTiTi.ArrayConverter;
import dv.DV;
import dv.DvFeatures;
import dv.DvNew;
import dv.DvOperations;
import imageTiTi.ImageConverter;
import imageTiTi.ImageFeatures;
import imageTiTi.ImageNew;
import imageTiTi.ImageOperations;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferDouble;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import morphee.StructuringElement;
import morphee.StructuringElement3D;
import processing.denoising.PrimalDualL1L1;
import processing.filters.SignalFilter;
import processing.filters.gradients.Gradient;
import processing.filters.gradients.SignalGradient;

public class PrimalDualL2L1
implements SignalFilter {
    public int MaximumIterations = 500;
    public int MinimumIterations = 50;
    public double Epsilon = 0.001;
    private double Lambda = 0.05;
    private double Sigma = 0.5;
    private double Theta = 0.5;
    private boolean Circular = true;
    private List<Double> Primal = new ArrayList<Double>(3 * this.MinimumIterations);
    private List<Double> Stop = new ArrayList<Double>(3 * this.MinimumIterations);
    private final DvFeatures DF = new DvFeatures();
    private final ImageFeatures IF = new ImageFeatures();
    private int[][] GradX = new int[][]{{0, 0, 0}, {0, 1, 0}, {0, -1, 0}};
    private int[][] GradXT = new int[][]{{0, -1, 0}, {0, 1, 0}, {0, 0, 0}};
    private int[][] GradY = new int[][]{{0, 0, 0}, {0, 1, -1}, {0, 0, 0}};
    private int[][] GradYT = new int[][]{{0, 0, 0}, {-1, 1, 0}, {0, 0, 0}};
    private StructuringElement sex = new StructuringElement(this.GradX);
    private StructuringElement sext = new StructuringElement(this.GradXT);
    private StructuringElement sey = new StructuringElement(this.GradY);
    private StructuringElement seyt = new StructuringElement(this.GradYT);
    private int[][][] GX = new int[][][]{new int[][]{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}, new int[][]{{0, 0, 0}, {0, 1, 0}, {0, -1, 0}}, new int[][]{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}};
    private int[][][] GXT = new int[][][]{new int[][]{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}, new int[][]{{0, -1, 0}, {0, 1, 0}, {0, 0, 0}}, new int[][]{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}};
    private int[][][] GY = new int[][][]{new int[][]{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}, new int[][]{{0, 0, 0}, {0, 1, -1}, {0, 0, 0}}, new int[][]{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}};
    private int[][][] GYT = new int[][][]{new int[][]{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}, new int[][]{{0, 0, 0}, {-1, 1, 0}, {0, 0, 0}}, new int[][]{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}};
    private int[][][] GZ = new int[][][]{new int[][]{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}, new int[][]{{0, 0, 0}, {0, 1, 0}, {0, 0, 0}}, new int[][]{{0, 0, 0}, {0, -1, 0}, {0, 0, 0}}};
    private int[][][] GZT = new int[][][]{new int[][]{{0, 0, 0}, {0, -1, 0}, {0, 0, 0}}, new int[][]{{0, 0, 0}, {0, 1, 0}, {0, 0, 0}}, new int[][]{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}};
    private StructuringElement3D se3x = new StructuringElement3D(this.GX);
    private StructuringElement3D se3xt = new StructuringElement3D(this.GXT);
    private StructuringElement3D se3y = new StructuringElement3D(this.GY);
    private StructuringElement3D se3yt = new StructuringElement3D(this.GYT);
    private StructuringElement3D se3z = new StructuringElement3D(this.GZ);
    private StructuringElement3D se3zt = new StructuringElement3D(this.GZT);
    private Gradient Kx = new Gradient();
    private Gradient Ky = new Gradient();
    private Gradient Kz = new Gradient();

    public PrimalDualL2L1() {
        this.Kx.HowCorrect(0);
        this.Ky.HowCorrect(0);
        this.Kz.HowCorrect(0);
    }

    public void Kill() {
        this.Primal.clear();
        this.Stop.clear();
        this.Stop = null;
        this.Primal = null;
        this.sex.Kill();
        this.sex = null;
        this.sey.Kill();
        this.sey = null;
        this.sext.Kill();
        this.sext = null;
        this.seyt.Kill();
        this.seyt = null;
        this.se3x.Kill();
        this.se3x = null;
        this.se3y.Kill();
        this.se3y = null;
        this.se3z.Kill();
        this.se3z = null;
        this.se3xt.Kill();
        this.se3xt = null;
        this.se3yt.Kill();
        this.se3yt = null;
        this.se3zt.Kill();
        this.se3zt = null;
        this.Kx.Kill();
        this.Kx = null;
        this.Ky.Kill();
        this.Ky = null;
        this.Kz.Kill();
        this.Kz = null;
        this.GradYT = null;
        this.GradXT = null;
        this.GradY = null;
        this.GradX = null;
        this.GZT = null;
        this.GZ = null;
        this.GYT = null;
        this.GY = null;
        this.GXT = null;
        this.GX = null;
    }

    public BufferedImage Filter(BufferedImage source, int nbCPU) {
        BufferedImage result = ImageNew.Same((BufferedImage)source);
        this.Filter(source, result, nbCPU);
        return result;
    }

    public void Filter(BufferedImage source, BufferedImage result, int nbCPU) {
        this.Filter(source, this.Lambda, result, nbCPU);
    }

    public void Filter(BufferedImage source, double lambda, BufferedImage result, int nbCPU) {
        BufferedImage G = ImageNew.Double((int)source.getWidth(), (int)source.getHeight(), (int)1);
        double[] gbuffer = ((DataBufferDouble)G.getRaster().getDataBuffer()).getData();
        this.Lambda(lambda);
        double sigma = this.Sigma;
        double theta = this.Theta;
        this.Primal.clear();
        this.Stop.clear();
        int width = source.getWidth();
        int height = source.getHeight();
        int length = width * height;
        int channel = source.getRaster().getNumBands();
        BufferedImage X = ImageNew.Same((BufferedImage)G);
        double[] xbuffer = ((DataBufferDouble)X.getRaster().getDataBuffer()).getData();
        BufferedImage X_ = ImageNew.Same((BufferedImage)X);
        double[] x_buffer = ((DataBufferDouble)X_.getRaster().getDataBuffer()).getData();
        BufferedImage Xold = ImageNew.Same((BufferedImage)G);
        double[] xoldbuffer = ((DataBufferDouble)Xold.getRaster().getDataBuffer()).getData();
        BufferedImage[] Y = new BufferedImage[]{ImageNew.Same((BufferedImage)X), ImageNew.Same((BufferedImage)X)};
        double[][] ybuffer = new double[][]{((DataBufferDouble)Y[0].getRaster().getDataBuffer()).getData(), ((DataBufferDouble)Y[1].getRaster().getDataBuffer()).getData()};
        BufferedImage tmp = ImageNew.Same((BufferedImage)G);
        double[] tmpbuffer = ((DataBufferDouble)tmp.getRaster().getDataBuffer()).getData();
        BufferedImage tmp2 = ImageNew.Same((BufferedImage)G);
        double[] tmpbuffer2 = ((DataBufferDouble)tmp2.getRaster().getDataBuffer()).getData();
        BufferedImage imgray = null;
        block8: for (int c = 0; c < channel; ++c) {
            switch (source.getType()) {
                case 10: {
                    ArrayConverter.UnsignedByteToDouble((byte[])((DataBufferByte)source.getRaster().getDataBuffer()).getData(), (double[])gbuffer);
                    break;
                }
                case 5: {
                    if (imgray == null) {
                        imgray = ImageNew.Same((BufferedImage)source, (int)10);
                    }
                    ImageConverter.Channel((BufferedImage)source, (int)c, (BufferedImage)imgray);
                    ArrayConverter.UnsignedByteToDouble((byte[])((DataBufferByte)imgray.getRaster().getDataBuffer()).getData(), (double[])gbuffer);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Image type not supported (yet).");
                }
            }
            ImageNew.Copy((BufferedImage)G, (BufferedImage)X);
            ImageNew.Copy((BufferedImage)G, (BufferedImage)X_);
            this.Kx.setStructuringElement(this.sex);
            this.Ky.setStructuringElement(this.sey);
            this.ComputePrimal(X, G, lambda, (SignalGradient)this.Kx, (SignalGradient)this.Ky, tmp, tmp2, nbCPU);
            int iter = 0;
            do {
                ImageNew.Copy((BufferedImage)X, (BufferedImage)Xold);
                this.Kx.Filter(X_, tmp, nbCPU);
                ArrayArithmetic.AddTimes((double[])tmpbuffer, (int)0, (double)sigma, (double[])ybuffer[0], (int)0, (double[])ybuffer[0], (int)0, (int)length);
                this.Ky.Filter(X_, tmp, nbCPU);
                ArrayArithmetic.AddTimes((double[])tmpbuffer, (int)0, (double)sigma, (double[])ybuffer[1], (int)0, (double[])ybuffer[1], (int)0, (int)length);
                if (this.Circular) {
                    ArrayArithmetic.Multiply((double[])ybuffer[0], (double[])ybuffer[0], (double[])tmpbuffer);
                    ArrayArithmetic.Multiply((double[])ybuffer[1], (double[])ybuffer[1], (double[])tmpbuffer2);
                    ArrayArithmetic.Add((double[])tmpbuffer, (double[])tmpbuffer2, (double[])tmpbuffer);
                    ArrayArithmetic.Sqrt((double[])tmpbuffer, (double[])tmpbuffer);
                    for (int i2 = 0; i2 < tmpbuffer.length; ++i2) {
                        tmpbuffer[i2] = tmpbuffer[i2] < 1.0 ? 1.0 : 1.0 / tmpbuffer[i2];
                    }
                    ArrayArithmetic.Multiply((double[])ybuffer[0], (double[])tmpbuffer, (double[])ybuffer[0]);
                    ArrayArithmetic.Multiply((double[])ybuffer[1], (double[])tmpbuffer, (double[])ybuffer[1]);
                } else {
                    ArrayComparator.Compare((double[])ybuffer[0], (String)">", (double)-1.0, (double[])ybuffer[0], (double)-1.0, (double[])ybuffer[0]);
                    ArrayComparator.Compare((double[])ybuffer[0], (String)"<", (double)1.0, (double[])ybuffer[0], (double)1.0, (double[])ybuffer[0]);
                    ArrayComparator.Compare((double[])ybuffer[1], (String)">", (double)-1.0, (double[])ybuffer[1], (double)-1.0, (double[])ybuffer[1]);
                    ArrayComparator.Compare((double[])ybuffer[1], (String)"<", (double)1.0, (double[])ybuffer[1], (double)1.0, (double[])ybuffer[1]);
                }
                this.Kx.setStructuringElement(this.sext);
                this.Kx.Filter(Y[0], tmp, nbCPU);
                this.Ky.setStructuringElement(this.seyt);
                this.Ky.Filter(Y[1], tmp2, nbCPU);
                ArrayArithmetic.Add((double[])tmpbuffer, (int)0, (double[])tmpbuffer2, (int)0, (double[])tmpbuffer, (int)0, (int)length);
                ArrayArithmetic.Multiply((double[])tmpbuffer, (double)(1.0 - this.Sigma), (double[])tmpbuffer);
                ArrayArithmetic.Subtract((double[])xbuffer, (double[])tmpbuffer, (double[])xbuffer);
                this.ProximalOperatorL2(xbuffer, 1.0 - this.Sigma, lambda, gbuffer, xbuffer);
                ArrayArithmetic.Subtract((double[])xbuffer, (double[])xoldbuffer, (double[])tmpbuffer);
                ArrayArithmetic.AddTimes((double[])tmpbuffer, (int)0, (double)theta, (double[])xbuffer, (int)0, (double[])x_buffer, (int)0, (int)length);
                this.Kx.setStructuringElement(this.sex);
                this.Ky.setStructuringElement(this.sey);
                this.ComputePrimal(X, G, lambda, (SignalGradient)this.Kx, (SignalGradient)this.Ky, tmp, tmp2, nbCPU);
            } while (++iter < this.MaximumIterations && (iter < this.MinimumIterations || this.Primal.get(this.Primal.size() - 1) < this.Primal.get(this.Primal.size() - 2)) && (iter < this.MinimumIterations || this.Epsilon < Math.abs(this.Stop.get(this.Stop.size() - 1) - this.Stop.get(this.Stop.size() - 2)) / (double)length));
            switch (result.getType()) {
                case 10: {
                    ArrayComparator.Compare((double[])xbuffer, (String)">", (double)0.0, (double[])xbuffer, (double)0.0, (double[])xbuffer);
                    ArrayComparator.Compare((double[])xbuffer, (String)"<", (double)255.0, (double[])xbuffer, (double)255.0, (double[])xbuffer);
                    ArrayConverter.DoubleToByte((double[])xbuffer, (byte[])((DataBufferByte)result.getRaster().getDataBuffer()).getData());
                    continue block8;
                }
                case 5: {
                    ArrayComparator.Compare((double[])xbuffer, (String)">", (double)0.0, (double[])xbuffer, (double)0.0, (double[])xbuffer);
                    ArrayComparator.Compare((double[])xbuffer, (String)"<", (double)255.0, (double[])xbuffer, (double)255.0, (double[])xbuffer);
                    ArrayConverter.DoubleToByte((double[])xbuffer, (byte[])((DataBufferByte)imgray.getRaster().getDataBuffer()).getData());
                    ImageConverter.SetChannel((BufferedImage)imgray, (int)c, (BufferedImage)result);
                    continue block8;
                }
                default: {
                    throw new IllegalArgumentException("Image type not supported (yet).");
                }
            }
        }
        tmpbuffer2 = null;
        tmpbuffer = null;
        ybuffer[1] = null;
        ybuffer[0] = null;
        xoldbuffer = null;
        x_buffer = null;
        xbuffer = null;
        gbuffer = null;
        ybuffer = null;
        imgray = null;
        tmp2 = null;
        tmp = null;
        Y[1] = null;
        Y[0] = null;
        Xold = null;
        X_ = null;
        X = null;
        G = null;
        Y = null;
        System.gc();
    }

    private void ProximalOperatorL2(double[] X, double Tau, double Lambda, double[] G, double[] result) {
        double TauLambda = Tau * Lambda;
        double TauLambda1 = TauLambda + 1.0;
        for (int i2 = 0; i2 < X.length; ++i2) {
            result[i2] = (X[i2] + TauLambda * G[i2]) / TauLambda1;
        }
    }

    private void ComputePrimal(BufferedImage X, BufferedImage G, double lambda, SignalGradient Kx, SignalGradient Ky, BufferedImage tmp, BufferedImage tmp2, int nbCPU) {
        double integral3;
        double integral2;
        double[] tmpbuffer = ((DataBufferDouble)tmp.getRaster().getDataBuffer()).getData();
        double[] tmpbuffer2 = ((DataBufferDouble)tmp2.getRaster().getDataBuffer()).getData();
        ImageOperations.Differences((BufferedImage)X, (BufferedImage)G, (BufferedImage)tmp);
        this.IF.Integral(tmp);
        this.Stop.add(this.IF.IntegralDouble());
        ArrayArithmetic.Multiply((double[])tmpbuffer, (double[])tmpbuffer, (double[])tmpbuffer);
        this.IF.Integral(tmp);
        double integral1 = this.IF.IntegralDouble();
        Kx.Filter(X, tmp, nbCPU);
        Ky.Filter(X, tmp2, nbCPU);
        if (this.Circular) {
            ArrayArithmetic.Multiply((double[])tmpbuffer, (double[])tmpbuffer, (double[])tmpbuffer);
            ArrayArithmetic.Multiply((double[])tmpbuffer2, (double[])tmpbuffer2, (double[])tmpbuffer2);
            ArrayArithmetic.Add((double[])tmpbuffer, (double[])tmpbuffer2, (double[])tmpbuffer);
            ArrayArithmetic.Sqrt((double[])tmpbuffer, (double[])tmpbuffer);
            this.IF.Integral(tmp);
            integral2 = this.IF.IntegralDouble();
            integral3 = 0.0;
        } else {
            ArrayArithmetic.Abs((double[])tmpbuffer, (double[])tmpbuffer);
            this.IF.Integral(tmp);
            integral2 = this.IF.IntegralDouble();
            ArrayArithmetic.Abs((double[])tmpbuffer2, (double[])tmpbuffer2);
            this.IF.Integral(tmp2);
            integral3 = this.IF.IntegralDouble();
        }
        this.Primal.add(lambda / 2.0 * integral1 + integral2 + integral3);
        tmpbuffer2 = null;
        tmpbuffer = null;
    }

    public DV Filter(DV source, int nbCPU) {
        DV result = DvNew.Same((DV)source);
        this.Filter(source, result, nbCPU);
        return result;
    }

    public void Filter(DV source, DV result, int nbCPU) {
        this.Filter(source, this.Lambda, result, nbCPU);
    }

    public void Filter(DV source, double lambda, DV result, int nbCPU) {
        DV G = new DV(source.SizeX, source.SizeY, source.SizeZ, 1, 64);
        double[] gbuffer = G.getDataBufferDouble(0);
        this.Lambda(lambda);
        double sigma = this.Sigma;
        double theta = this.Theta;
        this.Primal.clear();
        this.Stop.clear();
        int length = source.Length;
        int channel = source.Channel;
        DV X = DvNew.Same((DV)G);
        double[] xbuffer = X.getDataBufferDouble(0);
        DV X_ = DvNew.Same((DV)X);
        double[] x_buffer = X_.getDataBufferDouble(0);
        DV Xold = DvNew.Same((DV)G);
        double[] xoldbuffer = Xold.getDataBufferDouble(0);
        DV[] Y = new DV[]{DvNew.Same((DV)X), DvNew.Same((DV)X), DvNew.Same((DV)X)};
        double[][] ybuffer = new double[][]{Y[0].getDataBufferDouble(0), Y[1].getDataBufferDouble(0), Y[2].getDataBufferDouble(0)};
        DV tmp = DvNew.Same((DV)G);
        double[] tmpbuffer = tmp.getDataBufferDouble(0);
        DV tmp2 = DvNew.Same((DV)G);
        double[] tmpbuffer2 = tmp2.getDataBufferDouble(0);
        DV tmp3 = DvNew.Same((DV)G);
        double[] tmpbuffer3 = tmp3.getDataBufferDouble(0);
        block6: for (int c = 0; c < channel; ++c) {
            switch (source.Type) {
                case 8: {
                    ArrayConverter.UnsignedByteToDouble((byte[])source.getDataBufferByte(c), (double[])gbuffer);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("DV type not supported (yet).");
                }
            }
            DvNew.Copy((DV)G, (DV)X);
            DvNew.Copy((DV)G, (DV)X_);
            this.Kx.setStructuringElement3D(this.se3x);
            this.Ky.setStructuringElement3D(this.se3y);
            this.Kz.setStructuringElement3D(this.se3z);
            this.ComputePrimal(X, G, lambda, (SignalGradient)this.Kx, (SignalGradient)this.Ky, (SignalGradient)this.Kz, tmp, tmp2, tmp3, nbCPU);
            int iter = 0;
            do {
                DvNew.Copy((DV)X, (DV)Xold);
                this.Kx.Filter(X_, tmp, nbCPU);
                ArrayArithmetic.AddTimes((double[])tmpbuffer, (int)0, (double)sigma, (double[])ybuffer[0], (int)0, (double[])ybuffer[0], (int)0, (int)length);
                this.Ky.Filter(X_, tmp, nbCPU);
                ArrayArithmetic.AddTimes((double[])tmpbuffer, (int)0, (double)sigma, (double[])ybuffer[1], (int)0, (double[])ybuffer[1], (int)0, (int)length);
                this.Kz.Filter(X_, tmp, nbCPU);
                ArrayArithmetic.AddTimes((double[])tmpbuffer, (int)0, (double)sigma, (double[])ybuffer[2], (int)0, (double[])ybuffer[2], (int)0, (int)length);
                if (this.Circular) {
                    ArrayArithmetic.Multiply((double[])ybuffer[0], (double[])ybuffer[0], (double[])tmpbuffer);
                    ArrayArithmetic.Multiply((double[])ybuffer[1], (double[])ybuffer[1], (double[])tmpbuffer2);
                    ArrayArithmetic.Multiply((double[])ybuffer[2], (double[])ybuffer[2], (double[])tmpbuffer3);
                    ArrayArithmetic.Add((double[])tmpbuffer, (double[])tmpbuffer2, (double[])tmpbuffer);
                    ArrayArithmetic.Add((double[])tmpbuffer, (double[])tmpbuffer3, (double[])tmpbuffer);
                    ArrayArithmetic.Sqrt((double[])tmpbuffer, (double[])tmpbuffer);
                    for (int i2 = 0; i2 < tmpbuffer.length; ++i2) {
                        tmpbuffer[i2] = tmpbuffer[i2] < 1.0 ? 1.0 : 1.0 / tmpbuffer[i2];
                    }
                    ArrayArithmetic.Multiply((double[])ybuffer[0], (double[])tmpbuffer, (double[])ybuffer[0]);
                    ArrayArithmetic.Multiply((double[])ybuffer[1], (double[])tmpbuffer, (double[])ybuffer[1]);
                    ArrayArithmetic.Multiply((double[])ybuffer[2], (double[])tmpbuffer, (double[])ybuffer[2]);
                } else {
                    ArrayComparator.Compare((double[])ybuffer[0], (String)">", (double)-1.0, (double[])ybuffer[0], (double)-1.0, (double[])ybuffer[0]);
                    ArrayComparator.Compare((double[])ybuffer[0], (String)"<", (double)1.0, (double[])ybuffer[0], (double)1.0, (double[])ybuffer[0]);
                    ArrayComparator.Compare((double[])ybuffer[1], (String)">", (double)-1.0, (double[])ybuffer[1], (double)-1.0, (double[])ybuffer[1]);
                    ArrayComparator.Compare((double[])ybuffer[1], (String)"<", (double)1.0, (double[])ybuffer[1], (double)1.0, (double[])ybuffer[1]);
                    ArrayComparator.Compare((double[])ybuffer[2], (String)">", (double)-1.0, (double[])ybuffer[2], (double)-1.0, (double[])ybuffer[2]);
                    ArrayComparator.Compare((double[])ybuffer[2], (String)"<", (double)1.0, (double[])ybuffer[2], (double)1.0, (double[])ybuffer[2]);
                }
                this.Kx.setStructuringElement3D(this.se3xt);
                this.Kx.Filter(Y[0], tmp, nbCPU);
                this.Ky.setStructuringElement3D(this.se3yt);
                this.Ky.Filter(Y[1], tmp2, nbCPU);
                this.Kz.setStructuringElement3D(this.se3zt);
                this.Kz.Filter(Y[2], tmp3, nbCPU);
                ArrayArithmetic.Add((double[])tmpbuffer, (int)0, (double[])tmpbuffer2, (int)0, (double[])tmpbuffer, (int)0, (int)length);
                ArrayArithmetic.Add((double[])tmpbuffer, (int)0, (double[])tmpbuffer3, (int)0, (double[])tmpbuffer, (int)0, (int)length);
                ArrayArithmetic.Multiply((double[])tmpbuffer, (double)(1.0 - this.Sigma), (double[])tmpbuffer);
                ArrayArithmetic.Subtract((double[])xbuffer, (double[])tmpbuffer, (double[])xbuffer);
                this.ProximalOperatorL2(xbuffer, 1.0 - this.Sigma, lambda, gbuffer, xbuffer);
                ArrayArithmetic.Subtract((double[])xbuffer, (double[])xoldbuffer, (double[])tmpbuffer);
                ArrayArithmetic.AddTimes((double[])tmpbuffer, (int)0, (double)theta, (double[])xbuffer, (int)0, (double[])x_buffer, (int)0, (int)length);
                this.Kx.setStructuringElement3D(this.se3x);
                this.Ky.setStructuringElement3D(this.se3y);
                this.Kz.setStructuringElement3D(this.se3z);
                this.ComputePrimal(X, G, lambda, (SignalGradient)this.Kx, (SignalGradient)this.Ky, (SignalGradient)this.Kz, tmp, tmp2, tmp3, nbCPU);
            } while (++iter < this.MaximumIterations && (iter < this.MinimumIterations || this.Primal.get(this.Primal.size() - 1) < this.Primal.get(this.Primal.size() - 2)) && (iter < this.MinimumIterations || this.Epsilon < Math.abs(this.Stop.get(this.Stop.size() - 1) - this.Stop.get(this.Stop.size() - 2)) / (double)length));
            switch (result.Type) {
                case 8: {
                    ArrayComparator.Compare((double[])xbuffer, (String)">", (double)0.0, (double[])xbuffer, (double)0.0, (double[])xbuffer);
                    ArrayComparator.Compare((double[])xbuffer, (String)"<", (double)255.0, (double[])xbuffer, (double)255.0, (double[])xbuffer);
                    ArrayConverter.DoubleToByte((double[])xbuffer, (byte[])result.getDataBufferByte(c));
                    continue block6;
                }
                default: {
                    throw new IllegalArgumentException("DV type not supported (yet).");
                }
            }
        }
        tmpbuffer3 = null;
        tmpbuffer2 = null;
        tmpbuffer = null;
        ybuffer[2] = null;
        ybuffer[1] = null;
        ybuffer[0] = null;
        xoldbuffer = null;
        x_buffer = null;
        xbuffer = null;
        gbuffer = null;
        ybuffer = null;
        G.Kill();
        X.Kill();
        X_.Kill();
        Xold.Kill();
        Y[0].Kill();
        Y[1].Kill();
        Y[2].Kill();
        tmp.Kill();
        tmp2.Kill();
        tmp3.Kill();
        tmp3 = null;
        tmp2 = null;
        tmp = null;
        Y[2] = null;
        Y[1] = null;
        Y[0] = null;
        Xold = null;
        X_ = null;
        X = null;
        G = null;
        Y = null;
        System.gc();
    }

    private void ComputePrimal(DV X, DV G, double lambda, SignalGradient Kx, SignalGradient Ky, SignalGradient Kz, DV tmp, DV tmp2, DV tmp3, int nbCPU) {
        double integral3;
        double integral4;
        double integral2;
        double[] tmpbuffer = tmp.getDataBufferDouble(0);
        double[] tmpbuffer2 = tmp2.getDataBufferDouble(0);
        double[] tmpbuffer3 = tmp3.getDataBufferDouble(0);
        DvOperations.Differences((DV)X, (DV)G, (DV)tmp);
        this.DF.Integral(tmp, 0);
        this.Stop.add(this.DF.IntegralDouble);
        ArrayArithmetic.Multiply((double[])tmpbuffer, (double[])tmpbuffer, (double[])tmpbuffer);
        this.DF.Integral(tmp, 0);
        double integral1 = this.DF.IntegralDouble;
        Kx.Filter(X, tmp, nbCPU);
        Ky.Filter(X, tmp2, nbCPU);
        Kz.Filter(X, tmp3, nbCPU);
        if (this.Circular) {
            ArrayArithmetic.Multiply((double[])tmpbuffer, (double[])tmpbuffer, (double[])tmpbuffer);
            ArrayArithmetic.Multiply((double[])tmpbuffer2, (double[])tmpbuffer2, (double[])tmpbuffer2);
            ArrayArithmetic.Multiply((double[])tmpbuffer3, (double[])tmpbuffer3, (double[])tmpbuffer3);
            ArrayArithmetic.Add((double[])tmpbuffer, (double[])tmpbuffer2, (double[])tmpbuffer);
            ArrayArithmetic.Add((double[])tmpbuffer, (double[])tmpbuffer3, (double[])tmpbuffer);
            ArrayArithmetic.Sqrt((double[])tmpbuffer, (double[])tmpbuffer);
            this.DF.Integral(tmp, 0);
            integral2 = this.DF.IntegralDouble;
            integral4 = 0.0;
            integral3 = 0.0;
        } else {
            ArrayArithmetic.Abs((double[])tmpbuffer, (double[])tmpbuffer);
            this.DF.Integral(tmp, 0);
            integral2 = this.IF.IntegralDouble();
            ArrayArithmetic.Abs((double[])tmpbuffer2, (double[])tmpbuffer2);
            this.DF.Integral(tmp2, 0);
            integral3 = this.DF.IntegralDouble;
            ArrayArithmetic.Abs((double[])tmpbuffer3, (double[])tmpbuffer3);
            this.DF.Integral(tmp3, 0);
            integral4 = this.DF.IntegralDouble;
        }
        this.Primal.add(lambda / 2.0 * integral1 + integral2 + integral3 + integral4);
        tmpbuffer3 = null;
        tmpbuffer2 = null;
        tmpbuffer = null;
    }

    public double[] Primal() {
        double[] primal = new double[this.Primal.size()];
        Iterator<Double> iter = this.Primal.iterator();
        for (int i2 = 0; i2 < primal.length; ++i2) {
            primal[i2] = iter.next();
        }
        iter = null;
        return primal;
    }

    public double[] Stop() {
        double[] stop = new double[this.Stop.size()];
        Iterator<Double> iter = this.Stop.iterator();
        for (int i2 = 0; i2 < stop.length; ++i2) {
            stop[i2] = iter.next();
        }
        iter = null;
        return stop;
    }

    public void Lambda(double Lambda) {
        if (Lambda < 0.0) {
            throw new IllegalArgumentException("Lambda must be into the range [0, 1]..");
        }
        if (1.0 < Lambda) {
            throw new IllegalArgumentException("Lambda must be into the range [0, 1]..");
        }
        this.Lambda = Lambda;
    }

    public double Lambda() {
        return this.Lambda;
    }

    public void Theta(double Theta) {
        if (Theta < 0.0) {
            throw new IllegalArgumentException("Theta must be into the range [0, 2]. Strongly encouraged [0, 1].");
        }
        if (2.0 < Theta) {
            throw new IllegalArgumentException("Theta must be into the range [0, 2]. Strongly encouraged [0, 1].");
        }
        this.Theta = Theta;
    }

    public double Theta() {
        return this.Theta;
    }

    public void Sigma(double Sigma) {
        if (Sigma < 0.1) {
            throw new IllegalArgumentException("Sigma must be into the range [0.1, 0.9].");
        }
        if (0.9 < Sigma) {
            throw new IllegalArgumentException("Sigma must be into the range [0.1, 0.9].");
        }
        this.Sigma = Sigma;
    }

    public double Sigma() {
        return this.Sigma;
    }

    public void Circular(boolean Circular) {
        this.Circular = Circular;
    }

    public boolean Circular() {
        return this.Circular;
    }

    public int BorderEffectSizeX() {
        return 1;
    }

    public int BorderEffectSizeY() {
        return 1;
    }

    public int BorderEffectSizeZ() {
        return 1;
    }

    public void Parameters(Object ... parameters) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public List<Object> Parameters() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public SignalFilter Clone() {
        PrimalDualL1L1 clone = new PrimalDualL1L1();
        clone.Circular(this.Circular);
        clone.Epsilon = this.Epsilon;
        clone.Lambda(this.Lambda);
        clone.Sigma(this.Sigma);
        clone.Theta(this.Theta);
        return clone;
    }
}

