/*
 * Decompiled with CFR 0.152.
 */
package processing.denoising;

import arrayTiTi.ArrayArithmetic;
import arrayTiTi.ArrayComparator;
import arrayTiTi.ArrayConverter;
import dv.DV;
import imageTiTi.ImageConverter;
import imageTiTi.ImageFeatures;
import imageTiTi.ImageNew;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferDouble;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import morphee.StructuringElement;
import processing.filters.SignalFilter;
import processing.filters.gradients.Gradient;
import processing.filters.gradients.SignalGradient;

public class PrimalDualHuber
implements SignalFilter {
    public int MaximumIterations = 750;
    public int MinimumIterations = 25;
    public double Epsilon = 0.001;
    private final double Theta = 0.5;
    private final ImageFeatures IF = new ImageFeatures();
    private final int[][] GradX = new int[][]{{0, 0, 0}, {0, 1, 0}, {0, -1, 0}};
    private final int[][] GradXT = new int[][]{{0, -1, 0}, {0, 1, 0}, {0, 0, 0}};
    private final int[][] GradY = new int[][]{{0, 0, 0}, {0, 1, -1}, {0, 0, 0}};
    private final int[][] GradYT = new int[][]{{0, 0, 0}, {-1, 1, 0}, {0, 0, 0}};
    private final StructuringElement sex = new StructuringElement(this.GradX);
    private final StructuringElement sext = new StructuringElement(this.GradXT);
    private final StructuringElement sey = new StructuringElement(this.GradY);
    private final StructuringElement seyt = new StructuringElement(this.GradYT);
    private final Gradient Kx = new Gradient();
    private final Gradient Ky = new Gradient();
    private final List<Double> Primal = new ArrayList<Double>(3 * this.MinimumIterations);
    private final List<Double> Stop = new ArrayList<Double>(3 * this.MinimumIterations);

    public PrimalDualHuber() {
        this.Kx.HowCorrect(0);
        this.Ky.HowCorrect(0);
    }

    public void Kill() {
        throw new UnsupportedOperationException("Method not implemented (yet).");
    }

    public BufferedImage Filter(BufferedImage source, int nbCPU) {
        BufferedImage result = ImageNew.Same((BufferedImage)source);
        this.Filter(source, result, nbCPU);
        return result;
    }

    public void Filter(BufferedImage source, BufferedImage result, int nbCPU) {
    }

    public void Filter(BufferedImage source, double Lambda, double Sigma, double AlphaMatching, double AlphaReg, BufferedImage result, int nbCPU) {
        BufferedImage R = ImageNew.Double((int)source.getWidth(), (int)source.getHeight(), (int)1);
        double[] rbuffer = ((DataBufferDouble)R.getRaster().getDataBuffer()).getData();
        double sigma = Sigma;
        double multiplier = Lambda / (Lambda + sigma * AlphaReg);
        this.Primal.clear();
        this.Stop.clear();
        int width = source.getWidth();
        int height = source.getHeight();
        int length = width * height;
        int channel = source.getRaster().getNumBands();
        BufferedImage X = ImageNew.Same((BufferedImage)R);
        double[] xbuffer = ((DataBufferDouble)X.getRaster().getDataBuffer()).getData();
        BufferedImage X_ = ImageNew.Same((BufferedImage)X);
        double[] x_buffer = ((DataBufferDouble)X_.getRaster().getDataBuffer()).getData();
        BufferedImage Xold = ImageNew.Same((BufferedImage)X);
        double[] xoldbuffer = ((DataBufferDouble)Xold.getRaster().getDataBuffer()).getData();
        BufferedImage[] Y = new BufferedImage[]{ImageNew.Same((BufferedImage)X), ImageNew.Same((BufferedImage)X)};
        double[][] ybuffer = new double[][]{((DataBufferDouble)Y[0].getRaster().getDataBuffer()).getData(), ((DataBufferDouble)Y[1].getRaster().getDataBuffer()).getData()};
        BufferedImage tmp = ImageNew.Same((BufferedImage)X);
        double[] tmpbuffer = ((DataBufferDouble)tmp.getRaster().getDataBuffer()).getData();
        BufferedImage tmp2 = ImageNew.Same((BufferedImage)X);
        double[] tmpbuffer2 = ((DataBufferDouble)tmp2.getRaster().getDataBuffer()).getData();
        BufferedImage imgray = null;
        block8: for (int c = 0; c < channel; ++c) {
            switch (source.getType()) {
                case 10: {
                    ArrayConverter.UnsignedByteToDouble((byte[])((DataBufferByte)source.getRaster().getDataBuffer()).getData(), (double[])rbuffer);
                    break;
                }
                case 5: {
                    if (imgray == null) {
                        imgray = ImageNew.Same((BufferedImage)source, (int)10);
                    }
                    ImageConverter.Channel((BufferedImage)source, (int)c, (BufferedImage)imgray);
                    ArrayConverter.UnsignedByteToDouble((byte[])((DataBufferByte)imgray.getRaster().getDataBuffer()).getData(), (double[])rbuffer);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Image type not supported (yet).");
                }
            }
            ImageNew.Copy((BufferedImage)R, (BufferedImage)X);
            ImageNew.Copy((BufferedImage)R, (BufferedImage)X_);
            Arrays.fill(ybuffer[0], 0.0);
            Arrays.fill(ybuffer[1], 0.0);
            this.Kx.setStructuringElement(this.sex);
            this.Ky.setStructuringElement(this.sey);
            this.ComputePrimal(X, R, Lambda, AlphaReg, AlphaMatching, (SignalGradient)this.Kx, (SignalGradient)this.Ky, tmp, nbCPU);
            int iter = 0;
            do {
                ImageNew.Copy((BufferedImage)X, (BufferedImage)Xold);
                this.Kx.Filter(X_, tmp, nbCPU);
                ArrayArithmetic.AddTimes((double[])tmpbuffer, (int)0, (double)sigma, (double[])ybuffer[0], (int)0, (double[])ybuffer[0], (int)0, (int)length);
                ArrayArithmetic.Multiply((double[])ybuffer[0], (double)multiplier, (double[])ybuffer[0]);
                this.BoxProjection(ybuffer[0], -Lambda, Lambda, ybuffer[0]);
                this.Ky.Filter(X_, tmp, nbCPU);
                ArrayArithmetic.AddTimes((double[])tmpbuffer, (int)0, (double)sigma, (double[])ybuffer[1], (int)0, (double[])ybuffer[1], (int)0, (int)length);
                ArrayArithmetic.Multiply((double[])ybuffer[1], (double)multiplier, (double[])ybuffer[1]);
                this.BoxProjection(ybuffer[1], -Lambda, Lambda, ybuffer[1]);
                this.Kx.setStructuringElement(this.sext);
                this.Kx.Filter(Y[0], tmp, nbCPU);
                this.Ky.setStructuringElement(this.seyt);
                this.Ky.Filter(Y[1], tmp2, nbCPU);
                ArrayArithmetic.Add((double[])tmpbuffer, (int)0, (double[])tmpbuffer2, (int)0, (double[])tmpbuffer, (int)0, (int)length);
                ArrayArithmetic.Multiply((double[])tmpbuffer, (double)(1.0 - sigma), (double[])tmpbuffer);
                ArrayArithmetic.Subtract((double[])xbuffer, (double[])tmpbuffer, (double[])xbuffer);
                this.ProximalOperatorHuber(xbuffer, 1.0 - sigma, Lambda, rbuffer, tmpbuffer, xbuffer);
                ArrayArithmetic.Subtract((double[])xbuffer, (double[])xoldbuffer, (double[])tmpbuffer);
                ArrayArithmetic.AddTimes((double[])tmpbuffer, (int)0, (double)0.5, (double[])xbuffer, (int)0, (double[])x_buffer, (int)0, (int)length);
                this.Kx.setStructuringElement(this.sex);
                this.Ky.setStructuringElement(this.sey);
                this.ComputePrimal(X, R, Lambda, AlphaReg, AlphaMatching, (SignalGradient)this.Kx, (SignalGradient)this.Ky, tmp, nbCPU);
            } while (++iter < this.MaximumIterations && this.Primal.get(this.Primal.size() - 1) < this.Primal.get(this.Primal.size() - 2) && (iter < this.MinimumIterations || this.Epsilon < Math.abs(this.Stop.get(this.Stop.size() - 1) - this.Stop.get(this.Stop.size() - 2)) / (double)length));
            if (this.Primal.get(this.Primal.size() - 2) < this.Primal.get(this.Primal.size() - 1)) {
                System.out.flush();
                System.err.println("Warning: PrimalDual Huber!");
                System.err.flush();
            }
            switch (result.getType()) {
                case 10: {
                    ArrayComparator.Compare((double[])xbuffer, (String)">", (double)0.0, (double[])xbuffer, (double)0.0, (double[])xbuffer);
                    ArrayComparator.Compare((double[])xbuffer, (String)"<", (double)255.0, (double[])xbuffer, (double)255.0, (double[])xbuffer);
                    ArrayConverter.DoubleToByte((double[])xbuffer, (byte[])((DataBufferByte)result.getRaster().getDataBuffer()).getData());
                    continue block8;
                }
                case 5: {
                    ArrayComparator.Compare((double[])xbuffer, (String)">", (double)0.0, (double[])xbuffer, (double)0.0, (double[])xbuffer);
                    ArrayComparator.Compare((double[])xbuffer, (String)"<", (double)255.0, (double[])xbuffer, (double)255.0, (double[])xbuffer);
                    ArrayConverter.DoubleToByte((double[])xbuffer, (byte[])((DataBufferByte)imgray.getRaster().getDataBuffer()).getData());
                    ImageConverter.SetChannel((BufferedImage)imgray, (int)c, (BufferedImage)result);
                    continue block8;
                }
                default: {
                    throw new IllegalArgumentException("Image type not supported (yet).");
                }
            }
        }
    }

    private void BoxProjection(double[] x, double min, double max, double[] result) {
        ArrayComparator.Compare((double[])x, (String)">", (double)min, (double[])x, (double)min, (double[])result);
        ArrayComparator.Compare((double[])result, (String)"<", (double)max, (double[])result, (double)max, (double[])result);
    }

    private void ProximalOperatorHuber(double[] X, double Tau, double Lambda, double[] R, double[] tmp, double[] result) {
        double TauLambda = Tau * Lambda;
        double[] rho = tmp;
        ArrayArithmetic.Subtract((double[])X, (double[])R, (double[])rho);
        for (int i2 = 0; i2 < X.length; ++i2) {
            result[i2] = rho[i2] > TauLambda ? X[i2] - TauLambda : (rho[i2] < -TauLambda ? X[i2] + TauLambda : R[i2]);
        }
    }

    private void ComputePrimal(BufferedImage X, BufferedImage R, double lambda, double AlphaReg, double AlphaMatching, SignalGradient Kx, SignalGradient Ky, BufferedImage tmp, int nbCPU) {
        double[] tmpbuffer = ((DataBufferDouble)tmp.getRaster().getDataBuffer()).getData();
        ArrayArithmetic.Subtract((double[])((DataBufferDouble)X.getRaster().getDataBuffer()).getData(), (double[])((DataBufferDouble)R.getRaster().getDataBuffer()).getData(), (double[])tmpbuffer);
        this.HuberNorm(tmpbuffer, AlphaMatching, tmpbuffer);
        this.IF.Integral(tmp);
        this.Stop.add(this.IF.IntegralDouble());
        double integral1 = this.IF.IntegralDouble();
        Kx.Filter(X, tmp, nbCPU);
        this.HuberNorm(tmpbuffer, AlphaReg, tmpbuffer);
        ArrayArithmetic.Multiply((double[])tmpbuffer, (double)lambda, (double[])tmpbuffer);
        this.IF.Integral(tmp);
        double integral2 = this.IF.IntegralDouble();
        Ky.Filter(X, tmp, nbCPU);
        this.HuberNorm(tmpbuffer, AlphaReg, tmpbuffer);
        ArrayArithmetic.Multiply((double[])tmpbuffer, (double)lambda, (double[])tmpbuffer);
        this.IF.Integral(tmp);
        double integral3 = this.IF.IntegralDouble();
        this.Primal.add(integral1 + integral2 + integral3);
        tmpbuffer = null;
    }

    private void HuberNorm(double[] x, double alpha, double[] result) {
        double a2 = 2.0 * alpha;
        double ad2 = alpha / 2.0;
        for (int i2 = 0; i2 < x.length; ++i2) {
            result[i2] = Math.abs(x[i2]) < alpha ? x[i2] * x[i2] / a2 : Math.abs(x[i2]) - ad2;
        }
    }

    public DV Filter(DV source, int nbCPU) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void Filter(DV source, DV result, int nbCPU) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public double[] Primal() {
        double[] primal = new double[this.Primal.size()];
        Iterator<Double> iter = this.Primal.iterator();
        for (int i2 = 0; i2 < primal.length; ++i2) {
            primal[i2] = iter.next();
        }
        iter = null;
        return primal;
    }

    public double[] Stop() {
        double[] stop = new double[this.Stop.size()];
        Iterator<Double> iter = this.Stop.iterator();
        for (int i2 = 0; i2 < stop.length; ++i2) {
            stop[i2] = iter.next();
        }
        iter = null;
        return stop;
    }

    public int BorderEffectSizeX() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public int BorderEffectSizeY() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public int BorderEffectSizeZ() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void Parameters(Object ... parameters) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public List<Object> Parameters() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public SignalFilter Clone() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

