/*
 * Decompiled with CFR 0.152.
 */
package processing.bigdata;

import dv.DV;
import dv.DvConverter;
import dv.DvOperations;
import imageTiTi.ImageIO;
import imageTiTi.ImageNew;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import listTiTi.Queue;
import mathematics.Maths;
import processing.filters.SignalFilter;
import stackTiTi.StackIO;
import stackTiTi.StackNew;
import utils.strings.IntGenerator;
import utils.strings.StringToolsImageDV;

public class BigDataProcessor {
    private BDPthread[] threads = null;
    private Queue<Integer> threadsfree = new Queue();

    public synchronized void Kill() {
        for (BDPthread thread : this.threads) {
            thread.Kill();
        }
        this.threadsfree.clear();
        this.threadsfree = null;
        Arrays.fill(this.threads, null);
        this.threads = null;
    }

    public void Process(File[] filenames, SignalFilter filter, int maxsize, int imrestype, File result, String prefix, int nbSubVolumes, int nbCPU) throws IOException {
        if (!result.isDirectory()) {
            throw new IllegalArgumentException("The result file is not a directory.");
        }
        if (!result.exists()) {
            result.mkdirs();
        }
        BufferedImage[] images = StackIO.ReadImageSequence(filenames);
        BufferedImage[] results = StackNew.Same(images, imrestype);
        this.Process(images, filter, maxsize, results, nbSubVolumes, nbCPU);
        IntGenerator igen = new IntGenerator(0, filenames.length);
        for (BufferedImage result1 : results) {
            ImageIO.Write(result1, result.getAbsolutePath() + "/" + prefix + "_" + igen.Next() + ".png", 6);
        }
        for (int i2 = 0; i2 < results.length; ++i2) {
            results[i2] = null;
            images[i2] = null;
        }
        results = null;
        images = null;
        igen = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Process(BufferedImage[] images, SignalFilter filter, int maxsize, BufferedImage[] results, int nbSubVolumes, int nbCPU) {
        int bex = filter.BorderEffectSizeX();
        int bey = filter.BorderEffectSizeY();
        int bez = filter.BorderEffectSizeZ();
        int width = images[0].getWidth();
        int height = images[0].getHeight();
        int depth = images.length;
        int SizeX = Math.min(maxsize, Maths.PreviousPower2((int)width));
        int SizeY = Math.min(maxsize, Maths.PreviousPower2((int)height));
        int SizeZ = Math.min(maxsize, Maths.PreviousPower2((int)depth));
        int pushx = SizeX - (bex << 1);
        int pushy = SizeY - (bey << 1);
        int pushz = SizeZ - (bez << 1);
        if (this.threads == null || this.threads.length != nbSubVolumes) {
            if (this.threads != null) {
                for (BDPthread thread : this.threads) {
                    thread.Kill();
                }
                Arrays.fill(this.threads, null);
            }
            this.threads = null;
            this.threads = new BDPthread[nbSubVolumes];
            this.threads[0] = new BDPthread(0, this, filter);
            this.threads[0].start();
            for (int i2 = 1; i2 < this.threads.length; ++i2) {
                this.threads[i2] = new BDPthread(i2, this, filter.Clone());
                this.threads[i2].start();
            }
        }
        for (int z = 0; z < depth; z += pushz) {
            for (int y = 0; y < height; y += pushy) {
                for (int x = 0; x < width; x += pushx) {
                    int imsx = x;
                    int imsy = y;
                    int imsz = z;
                    if (width - x < SizeX) {
                        imsx = width - SizeX;
                    }
                    if (height - y < SizeY) {
                        imsy = height - SizeY;
                    }
                    if (depth - z < SizeZ) {
                        imsz = depth - SizeZ;
                    }
                    int lx = x == 0 || width <= x + SizeX ? SizeX - bex : pushx;
                    int dvsx = x == 0 ? 0 : bex;
                    int ly = y == 0 || height <= y + SizeY ? SizeY - bey : pushy;
                    int dvsy = y == 0 ? 0 : bey;
                    int lz = z == 0 || depth <= z + SizeZ ? SizeZ - bez : pushz;
                    int dvsz = z == 0 ? 0 : bez;
                    int free = -1;
                    try {
                        free = this.getFreeThread();
                    }
                    catch (InterruptedException ex) {
                        ex.printStackTrace();
                        System.exit(0);
                    }
                    Object object = this.threads[free].lock;
                    synchronized (object) {
                        this.threads[free].Parameters(images, SizeX, SizeY, SizeZ, imsx, imsy, imsz, results, dvsx, dvsy, dvsz, lx, ly, lz, nbCPU);
                        this.threads[free].lock.notify();
                    }
                    if (imsx == width - SizeX) {
                        x = width;
                    }
                    if (imsy == height - SizeY) {
                        y = height;
                    }
                    if (imsz != depth - SizeZ) continue;
                    z = depth;
                }
            }
        }
        BigDataProcessor bigDataProcessor = this;
        synchronized (bigDataProcessor) {
            while (this.threadsfree.size() != nbSubVolumes) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage[] Process(File[] images, SignalFilter filter, int maxsize, int nbSubVolumes, BufferedImage ressample, boolean SaveResults, String resdirectory, String suffix, int nbCPU) throws IOException {
        int i2;
        String output = null;
        if (SaveResults) {
            File out = new File(resdirectory);
            if (!out.exists()) {
                out.mkdirs();
            }
            output = out.getAbsolutePath();
        }
        Object[] sources = new BufferedImage[images.length];
        Object[] results = new BufferedImage[images.length];
        sources[0] = ImageIO.Read(images[0]);
        int width = sources[0].getWidth();
        int height = sources[0].getHeight();
        int depth = images.length;
        boolean[] written = new boolean[images.length];
        Arrays.fill(written, false);
        sources[0] = null;
        String ext = StringToolsImageDV.FindExtension((String)images[0].getName());
        int bex = filter.BorderEffectSizeX();
        int bey = filter.BorderEffectSizeY();
        int bez = filter.BorderEffectSizeZ();
        int SizeX = Math.min(maxsize, Maths.PreviousPower2((int)width));
        int SizeY = Math.min(maxsize, Maths.PreviousPower2((int)height));
        int SizeZ = Math.min(maxsize, Maths.PreviousPower2((int)depth));
        int pushx = SizeX - (bex << 1);
        int pushy = SizeY - (bey << 1);
        int pushz = SizeZ - (bez << 1);
        if (this.threads == null || this.threads.length != nbSubVolumes) {
            if (this.threads != null) {
                for (BDPthread thread : this.threads) {
                    thread.Kill();
                }
                Arrays.fill(this.threads, null);
            }
            this.threads = null;
            this.threads = new BDPthread[nbSubVolumes];
            this.threads[0] = new BDPthread(0, this, filter);
            this.threads[0].start();
            for (i2 = 1; i2 < this.threads.length; ++i2) {
                this.threads[i2] = new BDPthread(i2, this, filter.Clone());
                this.threads[i2].start();
            }
        }
        for (int z = 0; z < depth; z += pushz) {
            int i3;
            if (SaveResults) {
                for (i3 = z - 1; 0 <= i3 && sources[i3] != null && !written[i3]; --i3) {
                    switch (results[i3].getRaster().getDataBuffer().getDataType()) {
                        case 4: {
                            ImageIO.WriteJAI((BufferedImage)results[i3], output + "/" + images[i3].getName().replace("." + ext, suffix + ".tif"), 8);
                            break;
                        }
                        default: {
                            ImageIO.Write((BufferedImage)results[i3], output + "/" + images[i3].getName().replace("." + ext, suffix + ".png"), 6);
                        }
                    }
                    written[i3] = true;
                    if (i3 >= depth - SizeZ - 1) continue;
                    sources[i3] = null;
                    results[i3] = null;
                }
                System.gc();
            }
            if (depth <= (i3 = z + maxsize - 1)) {
                i3 = depth - 1;
            }
            while (i3 >= z) {
                if (sources[i3] == null) {
                    sources[i3] = ImageIO.Read(images[i3]);
                    results[i3] = ImageNew.Same((BufferedImage)ressample);
                }
                --i3;
            }
            for (int y = 0; y < height; y += pushy) {
                for (int x = 0; x < width; x += pushx) {
                    int imsx = x;
                    int imsy = y;
                    int imsz = z;
                    if (width - x < SizeX) {
                        imsx = width - SizeX;
                    }
                    if (height - y < SizeY) {
                        imsy = height - SizeY;
                    }
                    if (depth - z < SizeZ) {
                        imsz = depth - SizeZ;
                    }
                    int lx = x == 0 || width <= x + SizeX ? SizeX - bex : pushx;
                    int dvsx = x == 0 ? 0 : bex;
                    int ly = y == 0 || height <= y + SizeY ? SizeY - bey : pushy;
                    int dvsy = y == 0 ? 0 : bey;
                    int lz = z == 0 || depth <= z + SizeZ ? SizeZ - bez : pushz;
                    int dvsz = z == 0 ? 0 : bez;
                    int free = -1;
                    try {
                        free = this.getFreeThread();
                    }
                    catch (InterruptedException ex) {
                        ex.printStackTrace();
                        System.exit(0);
                    }
                    Object object = this.threads[free].lock;
                    synchronized (object) {
                        this.threads[free].Parameters((BufferedImage[])sources, SizeX, SizeY, SizeZ, imsx, imsy, imsz, (BufferedImage[])results, dvsx, dvsy, dvsz, lx, ly, lz, nbCPU);
                        this.threads[free].lock.notify();
                    }
                    if (imsx == width - SizeX) {
                        x = width;
                    }
                    if (imsy == height - SizeY) {
                        y = height;
                    }
                    if (imsz != depth - SizeZ) continue;
                    z = depth;
                }
            }
            BigDataProcessor bigDataProcessor = this;
            synchronized (bigDataProcessor) {
                while (this.threadsfree.size() != nbSubVolumes) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                continue;
            }
        }
        if (SaveResults) {
            for (i2 = depth - 1; 0 <= i2 && sources[i2] != null && !written[i2]; --i2) {
                switch (results[i2].getRaster().getDataBuffer().getDataType()) {
                    case 4: {
                        ImageIO.WriteJAI((BufferedImage)results[i2], output + "/" + images[i2].getName().replace("." + ext, suffix + ".tif"), 8);
                        break;
                    }
                    default: {
                        ImageIO.Write((BufferedImage)results[i2], output + "/" + images[i2].getName().replace("." + ext, suffix + ".png"), 6);
                    }
                }
                written[i2] = true;
            }
            System.out.flush();
            System.err.flush();
            for (i2 = 0; i2 < depth; ++i2) {
                if (written[i2]) continue;
                System.err.println("Souci! written[" + i2 + "]");
            }
            System.err.flush();
            Arrays.fill(results, null);
            results = null;
        }
        Arrays.fill(sources, null);
        sources = null;
        written = null;
        System.gc();
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void addFreeThread(int number) {
        Queue<Integer> queue = this.threadsfree;
        synchronized (queue) {
            this.threadsfree.Push(number);
        }
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized int getFreeThread() throws InterruptedException {
        int free;
        while (this.threadsfree.isEmpty()) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        Queue<Integer> queue = this.threadsfree;
        synchronized (queue) {
            free = this.threadsfree.FrontPop();
        }
        return free;
    }

    private class BDPthread
    extends Thread {
        private BigDataProcessor parent = null;
        private int number = -1;
        private BufferedImage[] images = null;
        private BufferedImage[] results = null;
        private int SizeX;
        private int SizeY;
        private int SizeZ;
        private int imsx;
        private int imsy;
        private int imsz;
        private int dvsx;
        private int dvsy;
        private int dvsz;
        private int lx;
        private int ly;
        private int lz;
        private int nbCPU = 1;
        public SignalFilter filter = null;
        private DV dvtmp = null;
        private DV dvres = null;
        public final Object lock = new Object();
        private boolean exit = false;

        public BDPthread(int number, BigDataProcessor parent, SignalFilter filter) {
            this.parent = parent;
            this.number = number;
            this.filter = filter;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void Kill() {
            if (this.dvtmp != null) {
                this.dvtmp.Kill();
            }
            if (this.dvres != null) {
                this.dvres.Kill();
            }
            this.images = null;
            if (this.results != null) {
                for (int i2 = 0; i2 < this.results.length; ++i2) {
                    this.results[i2] = null;
                }
            }
            this.results = null;
            this.filter = null;
            this.parent = null;
            this.exit = true;
            Object object = this.lock;
            synchronized (object) {
                this.lock.notify();
            }
        }

        public void Parameters(BufferedImage[] images, int SizeX, int SizeY, int SizeZ, int imsx, int imsy, int imsz, BufferedImage[] results, int dvsx, int dvsy, int dvsz, int lx, int ly, int lz, int nbCPU) {
            this.images = images;
            this.SizeX = SizeX;
            this.SizeY = SizeY;
            this.SizeZ = SizeZ;
            this.imsx = imsx;
            this.imsy = imsy;
            this.imsz = imsz;
            this.results = results;
            this.dvsx = dvsx;
            this.dvsy = dvsy;
            this.dvsz = dvsz;
            this.lx = lx;
            this.ly = ly;
            this.lz = lz;
            this.nbCPU = nbCPU;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                Object object = this.lock;
                synchronized (object) {
                    try {
                        this.parent.addFreeThread(this.number);
                        this.lock.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                if (this.exit) {
                    return;
                }
                if (this.dvtmp == null || this.dvtmp.SizeX != this.SizeX || this.dvtmp.SizeY != this.SizeY || this.dvtmp.SizeZ != this.SizeZ) {
                    if (this.dvtmp != null) {
                        this.dvtmp.Kill();
                    }
                    switch (this.images[0].getType()) {
                        case 10: {
                            this.dvtmp = new DV(this.SizeX, this.SizeY, this.SizeZ, 1, 8);
                            break;
                        }
                        case 11: {
                            this.dvtmp = new DV(this.SizeX, this.SizeY, this.SizeZ, 1, 16);
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Image type not supported (yet).");
                        }
                    }
                    block7 : switch (this.results[0].getType()) {
                        case 10: {
                            this.dvres = new DV(this.SizeX, this.SizeY, this.SizeZ, 1, 8);
                            break;
                        }
                        case 11: {
                            this.dvres = new DV(this.SizeX, this.SizeY, this.SizeZ, 1, 16);
                            break;
                        }
                        case 0: {
                            switch (this.results[0].getRaster().getDataBuffer().getDataType()) {
                                case 4: {
                                    this.dvres = new DV(this.SizeX, this.SizeY, this.SizeZ, 1, -32);
                                    break block7;
                                }
                                case 5: {
                                    this.dvres = new DV(this.SizeX, this.SizeY, this.SizeZ, 1, 64);
                                    break block7;
                                }
                            }
                            throw new IllegalArgumentException("DataBuffer type not supported (yet).");
                        }
                        default: {
                            throw new IllegalArgumentException("Image type not supported (yet).");
                        }
                    }
                }
                DvConverter.BufferedImageToDV(this.images, this.imsx, this.imsy, this.SizeX, this.SizeY, this.imsz, this.SizeZ, this.dvtmp, 0, 0, 0);
                DvOperations.Fill((DV)this.dvres, (int)0, (int)0);
                this.filter.Filter(this.dvtmp, this.dvres, this.nbCPU);
                DvConverter.DVtoBufferedImage(this.dvres, this.dvsx, this.dvsy, this.dvsz, this.lx, this.ly, this.lz, this.results, this.imsx + this.dvsx, this.imsy + this.dvsy, this.imsz + this.dvsz);
            }
        }
    }
}

