/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params;

import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.jupiter.api.Named;
import org.junit.jupiter.api.extension.AfterTestExecutionCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.ParameterizedTestMethodContext;
import org.junit.platform.commons.util.AnnotationUtils;

class ParameterizedTestParameterResolver
implements ParameterResolver,
AfterTestExecutionCallback {
    private static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create(ParameterizedTestParameterResolver.class);
    private final ParameterizedTestMethodContext methodContext;
    private final Object[] arguments;

    ParameterizedTestParameterResolver(ParameterizedTestMethodContext methodContext, Object[] arguments) {
        this.methodContext = methodContext;
        this.arguments = arguments;
    }

    @Override
    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        Executable declaringExecutable = parameterContext.getDeclaringExecutable();
        Method testMethod = extensionContext.getTestMethod().orElse(null);
        int parameterIndex = parameterContext.getIndex();
        if (!declaringExecutable.equals(testMethod)) {
            return false;
        }
        if (this.methodContext.isAggregator(parameterIndex)) {
            return true;
        }
        if (this.methodContext.hasAggregator()) {
            return parameterIndex < this.methodContext.indexOfFirstAggregator();
        }
        return parameterIndex < this.arguments.length;
    }

    @Override
    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return this.methodContext.resolve(parameterContext, this.extractPayloads(this.arguments));
    }

    @Override
    public void afterTestExecution(ExtensionContext context) {
        ParameterizedTest parameterizedTest = AnnotationUtils.findAnnotation(context.getRequiredTestMethod(), ParameterizedTest.class).get();
        if (!parameterizedTest.autoCloseArguments()) {
            return;
        }
        ExtensionContext.Store store = context.getStore(NAMESPACE);
        AtomicInteger argumentIndex = new AtomicInteger();
        Arrays.stream(this.arguments).filter(AutoCloseable.class::isInstance).map(AutoCloseable.class::cast).map(CloseableArgument::new).forEach(closeable -> store.put("closeableArgument#" + argumentIndex.incrementAndGet(), closeable));
    }

    private Object[] extractPayloads(Object[] arguments) {
        return Arrays.stream(arguments).map(argument -> {
            if (argument instanceof Named) {
                return ((Named)argument).getPayload();
            }
            return argument;
        }).toArray();
    }

    private static class CloseableArgument
    implements ExtensionContext.Store.CloseableResource {
        private final AutoCloseable autoCloseable;

        CloseableArgument(AutoCloseable autoCloseable) {
            this.autoCloseable = autoCloseable;
        }

        @Override
        public void close() throws Throwable {
            this.autoCloseable.close();
        }
    }
}

