/*
 * Decompiled with CFR 0.152.
 */
package morphee.segmentation.watershed.others;

import imageTiTi.ImageConverter;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.util.LinkedList;

public class WatershedRough {
    protected int width;
    protected int height;
    protected int[][] image = null;
    protected final int GRAYLEVEL = 256;
    protected int[][] rmap = null;
    protected int maxid = 0;
    protected int WATERSHED = -1;
    protected ListOfPixels[] explorelist;
    protected int[] dx8 = new int[]{-1, 0, 1, 1, 1, 0, -1, -1};
    protected int[] dy8 = new int[]{-1, -1, -1, 0, 1, 1, 1, 0};

    public boolean[][] Process(BufferedImage image, int step, boolean isBrightOnDark) {
        if (ImageTools.isColored((BufferedImage)image)) {
            throw new IllegalArgumentException("Only gray level or binary images supported.");
        }
        return this.Process(ImageConverter.ImageToInt((BufferedImage)image), step, isBrightOnDark);
    }

    public boolean[][] Process(int[][] image, int step, boolean isBrightOnDark) {
        int x;
        int y;
        if (image == null) {
            throw new NullPointerException("image = null");
        }
        this.image = image;
        this.width = image[0].length;
        this.height = image.length;
        if (isBrightOnDark) {
            for (y = 0; y < this.height; ++y) {
                for (x = 0; x < this.width; ++x) {
                    this.image[y][x] = 255 - this.image[y][x];
                }
            }
        }
        this.init();
        int level = 0;
        int yoffset = 0;
        while (level < 256) {
            Pixel p;
            while ((p = this.nextPixel(level, step)) != null) {
                this.extend(p);
            }
            Pixel seed = this.findSeed(level, yoffset);
            if (seed != null) {
                this.rmap[seed.y][seed.x] = ++this.maxid;
                yoffset = seed.y;
                this.explorelist[level].add(seed);
                continue;
            }
            ++level;
            yoffset = 0;
        }
        boolean[][] shedmap = new boolean[this.height][this.width];
        for (y = 0; y < this.height; ++y) {
            for (x = 0; x < this.width; ++x) {
                if (this.rmap[y][x] != this.WATERSHED) continue;
                shedmap[y][x] = true;
            }
        }
        this.clear();
        return shedmap;
    }

    private Pixel findSeed(int level, int yoffset) {
        for (int y = yoffset; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                if (this.image[y][x] != level || this.rmap[y][x] != 0) continue;
                return new Pixel(x, y, level);
            }
        }
        return null;
    }

    private Pixel nextPixel(int level, int step) {
        for (int i2 = level; i2 < level + step && i2 < 256; ++i2) {
            if (this.explorelist[i2].isEmpty()) continue;
            return (Pixel)this.explorelist[i2].remove(0);
        }
        return null;
    }

    private void extend(Pixel p) {
        int region = this.rmap[p.y][p.x];
        if (region == this.WATERSHED) {
            return;
        }
        for (int k = 0; k < 8; ++k) {
            int xk = p.x + this.dx8[k];
            int yk = p.y + this.dy8[k];
            if (xk < 0 || xk >= this.width || yk < 0 || yk >= this.height) continue;
            int vk = this.image[yk][xk];
            int rk = this.rmap[yk][xk];
            if (rk == -1) continue;
            if (rk == 0) {
                this.rmap[yk][xk] = region;
                this.explorelist[vk].add(new Pixel(xk, yk, vk));
                continue;
            }
            if (rk == region) continue;
            this.rmap[yk][xk] = -1;
        }
    }

    private void init() {
        this.clear();
        this.maxid = 0;
        this.rmap = new int[this.height][this.width];
        this.explorelist = new ListOfPixels[256];
        for (int i2 = 0; i2 < 256; ++i2) {
            this.explorelist[i2] = new ListOfPixels();
        }
    }

    private void clear() {
        this.rmap = null;
        this.explorelist = null;
    }

    protected class ListOfPixels
    extends LinkedList<Pixel> {
        private static final long serialVersionUID = 4427339098173811379L;

        protected ListOfPixels() {
        }
    }

    protected class Pixel {
        int x;
        int y;
        int level;

        public Pixel(int x, int y, int l) {
            this.x = x;
            this.y = y;
            this.level = l;
        }
    }
}

