/*
 * Decompiled with CFR 0.152.
 */
package morphee.segmentation.watershed.others;

import arrayTiTi.ArrayFeatures;
import arrayTiTi.ArrayTools;
import imageTiTi.ImageConverter;
import imageTiTi.ImageFeatures;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.PriorityQueue;
import mathematics.primitives.pointsTiTi.Coordinates;
import mathematics.primitives.pointsTiTi.CoordinatesWeighted;

@Deprecated
public class WatershedOld {
    private final ArrayFeatures AF = new ArrayFeatures();
    private final ImageFeatures IF = new ImageFeatures();
    private int width;
    private int height;
    private int size;
    private int maxlevel = -1;
    private PriorityQueue<WatershedPoint> queue = new PriorityQueue();
    private List<Coordinates> edges = new ArrayList<Coordinates>(517);
    private int[] pixels;
    private int[] oldpixels;
    private int[] nouv2pixel;
    private int[] labels = null;
    private int[] areas;
    private int[] outlines;
    private int[] grayscale;

    public void Process(BufferedImage image, List<CoordinatesWeighted> markersin, List<CoordinatesWeighted> markersout, boolean EightConnex) {
        int i2;
        int nbNobg = 0;
        CoordinatesWeighted p = null;
        this.Initializations(image);
        for (i2 = 0; i2 < markersin.size(); ++i2) {
            p = markersin.get(i2);
            this.addPoint(p.X, p.Y, p.Wi);
            if (nbNobg >= p.Wi) continue;
            nbNobg = p.Wi;
        }
        for (i2 = 0; i2 < markersout.size(); ++i2) {
            p = markersout.get(i2);
            this.addPoint(p.X, p.Y, nbNobg + 1);
        }
        int nbLabels = 0 < markersout.size() ? nbNobg + 2 : nbNobg + 1;
        this.Initialization2(nbLabels);
        this.Process(EightConnex ? 8 : 4, nbLabels);
    }

    public void Process(BufferedImage image, BufferedImage markersin, BufferedImage markersout, boolean EightConnex) {
        int nbLabels;
        int x;
        int y;
        this.Initializations(image);
        for (y = 0; y < this.height; ++y) {
            for (x = 0; x < this.width; ++x) {
                if (markersin.getRaster().getSample(x, y, 0) == 0) continue;
                this.addPoint(x, y, markersin.getRaster().getSample(x, y, 0));
            }
        }
        int nbNobg = (int)this.IF.Maximum(markersin);
        if (!ImageTools.isBlack((BufferedImage)markersout)) {
            for (y = 0; y < this.height; ++y) {
                for (x = 0; x < this.width; ++x) {
                    if (markersout.getRaster().getSample(x, y, 0) == 0) continue;
                    this.addPoint(x, y, nbNobg + 1);
                }
            }
            nbLabels = nbNobg + 2;
        } else {
            nbLabels = nbNobg + 1;
        }
        this.Initialization2(nbLabels);
        this.Process(EightConnex ? 8 : 4, nbLabels);
    }

    public void Process(BufferedImage image, int[] markersin, int[] markersout, boolean EightConnex) {
        int nbLabels;
        int x;
        int y;
        if (markersout != null && !ArrayTools.areDimensionsEqual((int[])markersin, (int[])markersout)) {
            throw new IllegalArgumentException("Arrays have different dimensions.");
        }
        if (image.getWidth() * image.getHeight() != markersin.length) {
            throw new IllegalArgumentException("Image and array(s) have different dimensions.");
        }
        this.Initializations(image);
        int pos = 0;
        for (y = 0; y < this.height; ++y) {
            x = 0;
            while (x < this.width) {
                if (markersin[pos] != 0) {
                    this.addPoint(x, y, markersin[pos]);
                }
                ++x;
                ++pos;
            }
        }
        int nbNobg = this.AF.Maximum(markersin);
        if (markersout != null && !ArrayTools.isEqual((int[])markersout, (int)0)) {
            pos = 0;
            for (y = 0; y < this.height; ++y) {
                x = 0;
                while (x < this.width) {
                    if (markersout[pos] != 0) {
                        this.addPoint(x, y, nbNobg + 1);
                    }
                    ++x;
                    ++pos;
                }
            }
            nbLabels = nbNobg + 2;
        } else {
            nbLabels = nbNobg + 1;
        }
        this.Initialization2(nbLabels);
        this.Process(EightConnex ? 8 : 4, nbLabels);
    }

    public void Process(BufferedImage image, int[][] markersin, int[][] markersout, boolean EightConnex) {
        int nbLabels;
        int x;
        int y;
        if (markersout != null && !ArrayTools.areDimensionsEqual((int[][])markersin, (int[][])markersout)) {
            throw new IllegalArgumentException("Arrays have different dimensions.");
        }
        if (image.getWidth() != markersin[0].length || image.getHeight() != markersin.length) {
            throw new IllegalArgumentException("Image and array(s) have different dimensions.");
        }
        this.Initializations(image);
        for (y = 0; y < this.height; ++y) {
            for (x = 0; x < this.width; ++x) {
                if (markersin[y][x] == 0) continue;
                this.addPoint(x, y, markersin[y][x]);
            }
        }
        int nbNobg = this.AF.Maximum(markersin);
        if (markersout != null && !ArrayTools.isEqual((int[][])markersout, (int)0)) {
            for (y = 0; y < this.height; ++y) {
                for (x = 0; x < this.width; ++x) {
                    if (markersout[y][x] == 0) continue;
                    this.addPoint(x, y, nbNobg + 1);
                }
            }
            nbLabels = nbNobg + 2;
        } else {
            nbLabels = nbNobg + 1;
        }
        this.Initialization2(nbLabels);
        this.Process(EightConnex ? 8 : 4, nbLabels);
    }

    private void Process(int connexity, int nbLabels) {
        int i2;
        int y;
        int x;
        WatershedPoint p = null;
        while (!this.queue.isEmpty()) {
            p = this.queue.poll();
            x = p.X;
            y = p.Y;
            int pos = y * this.width + x;
            int value = this.pixels[pos];
            int index = this.nouv2pixel[pos];
            for (i2 = 0; i2 < connexity; ++i2) {
                int posnew;
                int Y;
                int X;
                switch (i2) {
                    case 0: {
                        X = x - 1;
                        Y = y;
                        break;
                    }
                    case 1: {
                        X = x;
                        Y = y - 1;
                        break;
                    }
                    case 2: {
                        X = x + 1;
                        Y = y;
                        break;
                    }
                    case 3: {
                        X = x;
                        Y = y + 1;
                        break;
                    }
                    case 4: {
                        X = x + 1;
                        Y = y + 1;
                        break;
                    }
                    case 5: {
                        X = x - 1;
                        Y = y + 1;
                        break;
                    }
                    case 6: {
                        X = x - 1;
                        Y = y - 1;
                        break;
                    }
                    case 7: {
                        X = x + 1;
                        Y = y - 1;
                        break;
                    }
                    default: {
                        throw new Error("Bug! Must not occured.");
                    }
                }
                if (0 > X || X >= this.width || 0 > Y || Y >= this.height) continue;
                switch (i2) {
                    case 0: {
                        posnew = pos - 1;
                        break;
                    }
                    case 1: {
                        posnew = pos - this.width;
                        break;
                    }
                    case 2: {
                        posnew = pos + 1;
                        break;
                    }
                    case 3: {
                        posnew = pos + this.width;
                        break;
                    }
                    case 4: {
                        posnew = pos + this.width + 1;
                        break;
                    }
                    case 5: {
                        posnew = pos + this.width - 1;
                        break;
                    }
                    case 6: {
                        posnew = pos - this.width - 1;
                        break;
                    }
                    case 7: {
                        posnew = pos - this.width + 1;
                        break;
                    }
                    default: {
                        throw new Error("Bug! Must not occured.");
                    }
                }
                int index2 = this.nouv2pixel[posnew];
                if (index2 != 0) continue;
                this.queue.add(new WatershedPoint(X, Y, this.maxlevel - value));
                this.nouv2pixel[posnew] = index;
            }
        }
        int nb = nbLabels - 1;
        for (i2 = 0; i2 < this.size; ++i2) {
            this.labels[i2] = this.nouv2pixel[i2] == nb ? 0 : this.nouv2pixel[i2];
        }
        this.edges.clear();
        i2 = 0;
        for (y = 0; y < this.height; ++y) {
            x = 0;
            while (x < this.width) {
                int n = this.nouv2pixel[i2] - 1;
                this.areas[n] = this.areas[n] + 1;
                int n2 = this.nouv2pixel[i2] - 1;
                this.grayscale[n2] = this.grayscale[n2] + this.oldpixels[i2];
                if (x != this.width - 1 && this.nouv2pixel[i2] != this.nouv2pixel[i2 + 1]) {
                    int n3 = this.nouv2pixel[i2] - 1;
                    this.outlines[n3] = this.outlines[n3] + 1;
                    int n4 = this.nouv2pixel[i2 + 1] - 1;
                    this.outlines[n4] = this.outlines[n4] + 1;
                    this.edges.add(new Coordinates(x, y));
                }
                if (y != this.height - 1 && this.nouv2pixel[i2] != this.nouv2pixel[i2 + this.width]) {
                    int n5 = this.nouv2pixel[i2] - 1;
                    this.outlines[n5] = this.outlines[n5] + 1;
                    int n6 = this.nouv2pixel[i2 + this.width] - 1;
                    this.outlines[n6] = this.outlines[n6] + 1;
                    this.edges.add(new Coordinates(x, y));
                }
                ++x;
                ++i2;
            }
        }
    }

    private void Initializations(BufferedImage image) {
        switch (image.getType()) {
            case 12: {
                this.maxlevel = 1;
                break;
            }
            case 10: {
                this.maxlevel = 255;
                break;
            }
            case 11: {
                this.maxlevel = 65535;
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported.");
            }
        }
        this.width = image.getWidth();
        this.height = image.getHeight();
        this.size = this.width * this.height;
        this.queue.clear();
        if (this.oldpixels == null || this.size != this.oldpixels.length) {
            this.oldpixels = ImageConverter.ImageToIntArray1D((BufferedImage)image);
            this.pixels = Arrays.copyOf(this.oldpixels, this.oldpixels.length);
            this.nouv2pixel = new int[this.pixels.length];
            this.labels = new int[this.pixels.length];
        } else {
            ImageConverter.ImageToArray1D((BufferedImage)image, (int[])this.oldpixels);
            System.arraycopy(this.oldpixels, 0, this.pixels, 0, this.oldpixels.length);
            Arrays.fill(this.nouv2pixel, 0);
        }
    }

    private void Initialization2(int nbLabels) {
        if (this.areas == null || this.areas.length != nbLabels) {
            this.areas = null;
            this.areas = new int[nbLabels];
            this.outlines = null;
            this.outlines = new int[nbLabels];
            this.grayscale = null;
            this.grayscale = new int[nbLabels];
            return;
        }
        Arrays.fill(this.areas, 0);
        Arrays.fill(this.outlines, 0);
        Arrays.fill(this.grayscale, 0);
    }

    private void addPoint(int x, int y, int lab) {
        if (lab <= 0) {
            throw new IllegalArgumentException("Bad label value of an internal marker: " + lab + " <= 0.");
        }
        int index = y * this.width + x;
        this.nouv2pixel[index] = lab;
        this.queue.add(new WatershedPoint(x, y, this.maxlevel - this.pixels[index]));
    }

    public int[] Labels() {
        return this.labels;
    }

    public int[] Areas() {
        return this.areas;
    }

    public List<Coordinates> Edges() {
        return this.edges;
    }

    public BufferedImage Contour() {
        BufferedImage Contour = new BufferedImage(this.width, this.height, 12);
        WritableRaster wr = Contour.getRaster();
        for (int i2 = 0; i2 < this.edges.size(); ++i2) {
            Coordinates p = this.edges.get(i2);
            wr.setSample(p.X, p.Y, 0, 1);
        }
        wr = null;
        return Contour;
    }

    private class WatershedPoint
    extends CoordinatesWeighted
    implements Comparable<WatershedPoint> {
        public WatershedPoint(int x, int y) {
            super(x, y, -1);
        }

        public WatershedPoint(int x, int y, int w) {
            super(x, y, -1, 0, w);
        }

        @Override
        public int compareTo(WatershedPoint p) {
            return p.Wi - this.Wi;
        }
    }
}

