/*
 * Decompiled with CFR 0.152.
 */
package morphee.segmentation.watershed.galactic;

import arrayTiTi.ArrayOperations;
import imageTiTi.ImageNew;
import imageTiTi.ImageOperations;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.io.IOException;
import java.util.Arrays;
import listTiTi.Stack;
import morphee.segmentation.watershed.galactic.PWsorts;
import morphee.segmentation.watershed.galactic.PWtools;

public class PowerWatershed {
    private final double epsilon = 1.0E-6;
    private final int SIZE_MAX_PLATEAU = 10000000;
    private int[][] Edges = null;
    private BufferedImage improba = null;
    private BufferedImage result = null;
    public boolean Call_GC_After = true;
    private int MAX;

    public void Compute(BufferedImage image, BufferedImage seeds, Algorithms algo, boolean geodesic) throws IOException {
        boolean quicksort = false;
        int ds = 1;
        int rs = seeds.getWidth();
        int cs = seeds.getHeight();
        System.err.println("CAUTION: bug not fixed (yet).");
        switch (image.getType()) {
            case 10: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported (yet).");
            }
        }
        if (this.result == null || !ImageTools.areDimensionsAndTypeEqual((BufferedImage)image, (BufferedImage)this.result)) {
            this.result = null;
            this.result = ImageNew.Same((BufferedImage)image);
        } else {
            ImageOperations.Fill((BufferedImage)this.result, (int)0);
        }
        int N = rs * cs * ds;
        int M = ds * rs * (cs - 1) + ds * (rs - 1) * cs + (ds - 1) * cs * rs;
        int[] index_seeds = new int[N];
        int[] index_labels = new int[N];
        int j = 0;
        int nblabels = 0;
        block3 : switch (seeds.getType()) {
            case 10: {
                byte[] bbs = ((DataBufferByte)seeds.getRaster().getDataBuffer()).getData();
                for (int i2 = 0; i2 < N; ++i2) {
                    if (0 >= (bbs[i2] & 0xFF)) continue;
                    index_seeds[j] = i2;
                    index_labels[j] = bbs[i2] & 0xFF;
                    ++j;
                    if ((bbs[i2] & 0xFF) <= nblabels) continue;
                    nblabels = bbs[i2] & 0xFF;
                }
                bbs = null;
                break;
            }
            case 0: {
                switch (seeds.getRaster().getDataBuffer().getDataType()) {
                    case 3: {
                        int[] ibs = ((DataBufferInt)seeds.getRaster().getDataBuffer()).getData();
                        for (int i3 = 0; i3 < N; ++i3) {
                            if (0 >= ibs[i3]) continue;
                            index_seeds[j] = i3;
                            index_labels[j] = ibs[i3];
                            ++j;
                            if (ibs[i3] <= nblabels) continue;
                            nblabels = ibs[i3];
                        }
                        ibs = null;
                        break block3;
                    }
                }
                throw new IllegalArgumentException("DataBuffer type not supported (yet).");
            }
            default: {
                throw new IllegalArgumentException("Image type not supported (yet).");
            }
        }
        int size_seeds = j;
        if (this.Edges == null || this.Edges[0].length != M) {
            this.Edges = null;
            this.Edges = new int[2][M];
        } else {
            ArrayOperations.Fill((int[][])this.Edges, (int)0);
        }
        this.compute_edges(this.Edges, rs, cs, ds);
        int max_weight = 255;
        int[] weights = new int[M];
        switch (algo) {
            case Kruskal: {
                this.grey_weights(image, weights, this.Edges, index_seeds, size_seeds, geodesic, quicksort);
                this.Kruskal(this.Edges, weights, max_weight, index_seeds, index_labels, size_seeds, rs, cs, ds, nblabels, seeds, this.result);
                break;
            }
            case PrimRBtree: {
                throw new IllegalArgumentException("Not supported (yet).");
            }
            case PowerWatershed: {
                int[] normal_weights = this.grey_weights_PW(image, this.Edges, index_seeds, size_seeds, weights, quicksort);
                if (this.improba == null || !ImageTools.areDimensionsAndTypeEqual((BufferedImage)image, (BufferedImage)this.improba)) {
                    this.improba = null;
                    this.improba = ImageNew.Same((BufferedImage)image);
                }
                if (geodesic) {
                    this.PowerWatershed_q2(this.Edges, weights, weights, max_weight, index_seeds, index_labels, size_seeds, rs, cs, ds, nblabels, quicksort, seeds, this.improba, this.result);
                    break;
                }
                this.PowerWatershed_q2(this.Edges, weights, normal_weights, max_weight, index_seeds, index_labels, size_seeds, rs, cs, ds, nblabels, quicksort, seeds, this.improba, this.result);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown algorithm.");
            }
        }
        weights = null;
        index_seeds = null;
        index_labels = null;
        if (this.Call_GC_After) {
            System.gc();
        }
    }

    public BufferedImage Probabilities() {
        return this.improba;
    }

    public BufferedImage Result() {
        return this.result;
    }

    public void PowerWatershed_q2(int[][] edges, int[] weights, int[] normal_weights, int max_weight, int[] seeds, int[] labels, int size_seeds, int rs, int cs, int ds, int nb_labels, boolean quicksort, BufferedImage markers, BufferedImage img_proba, BufferedImage imres) {
        int xr;
        double val;
        int k;
        int j;
        int i2;
        int N = rs * cs * ds;
        int M = ds * rs * (cs - 1) + ds * (rs - 1) * cs + (ds - 1) * cs * rs;
        int nb_neighbor_edges = 6;
        if (ds > 1) {
            nb_neighbor_edges = 12;
        }
        boolean success = false;
        int nblbl1 = nb_labels - 1;
        Stack<Integer> LIFO = null;
        Stack<Integer> LCP = null;
        boolean[] indic_E = null;
        boolean[] indic_P = null;
        int[] indic_VP = null;
        int[] Rnk = null;
        int[] Fth = null;
        int[] local_seeds = null;
        int[] LCVP = null;
        int[] Es = null;
        int[] NEs = null;
        if (indic_P == null || indic_P.length != M) {
            LIFO = new Stack<Integer>(M);
            LCP = new Stack<Integer>(M);
            indic_E = new boolean[M];
            indic_P = new boolean[M];
            indic_VP = new int[N];
            Rnk = new int[N];
            Fth = new int[N];
            local_seeds = new int[N];
            LCVP = new int[N];
            Es = new int[M];
            NEs = new int[M];
        }
        Arrays.fill(indic_E, false);
        Arrays.fill(indic_P, false);
        Arrays.fill(indic_VP, 0);
        Arrays.fill(Rnk, 0);
        float[][] proba = new float[nblbl1][N];
        ArrayOperations.Fill((float[][])proba, (float)-1.0f);
        int[][] edgesLCP = new int[2][M];
        for (i2 = 0; i2 < size_seeds; ++i2) {
            for (j = 0; j < nblbl1; ++j) {
                proba[j][seeds[i2]] = labels[i2] == j + 1 ? 1.0f : 0.0f;
            }
        }
        for (k = 0; k < N; ++k) {
            Fth[k] = k;
        }
        float[][] local_labels = new float[nblbl1][N];
        int[] sorted_weights = new int[M];
        for (k = 0; k < M; ++k) {
            sorted_weights[k] = weights[k];
            Es[k] = k;
        }
        if (quicksort) {
            PWsorts.BucketSort(sorted_weights, Es, M, max_weight + 1);
        } else {
            PWsorts.QuickSortStochastic_dec(sorted_weights, Es, 0, M - 1);
        }
        int cpt_aretes = 0;
        int Ncpt_aretes = 0;
        while (cpt_aretes < M) {
            int re2;
            int re1;
            int e2;
            int e1;
            int x;
            int e_max;
            do {
                e_max = Es[cpt_aretes];
            } while (++cpt_aretes != M && indic_E[e_max]);
            if (cpt_aretes == M) break;
            LIFO.Push(e_max);
            indic_P[e_max] = true;
            indic_E[e_max] = true;
            LCP.Push(e_max);
            int nb_vertices = 0;
            int nb_edges = 0;
            int wmax = weights[e_max];
            while (!LIFO.Empty()) {
                x = (Integer)LIFO.TopPop();
                e1 = edges[0][x];
                e2 = edges[1][x];
                re1 = PowerWatershed.element_find(e1, Fth);
                re2 = PowerWatershed.element_find(e2, Fth);
                if (proba[0][re1] < 0.0f || proba[0][re2] < 0.0f) {
                    if (indic_VP[e1] == 0) {
                        LCVP[nb_vertices] = e1;
                        ++nb_vertices;
                        indic_VP[e1] = 1;
                    }
                    if (indic_VP[e2] == 0) {
                        LCVP[nb_vertices] = e2;
                        ++nb_vertices;
                        indic_VP[e2] = 1;
                    }
                    edgesLCP[0][nb_edges] = e1;
                    edgesLCP[1][nb_edges] = e2;
                    NEs[nb_edges] = x;
                    ++nb_edges;
                }
                for (k = 1; k <= nb_neighbor_edges; ++k) {
                    int y = ds > 1 ? PowerWatershed.neighbor_edge_3D(e1, e2, x, k, rs, cs, ds) : PowerWatershed.neighbor_edge(x, k, rs, cs, ds);
                    if (y == -1 || indic_P[y] || weights[y] != wmax) continue;
                    indic_P[y] = true;
                    LIFO.Push(y);
                    LCP.Push(y);
                    indic_E[y] = true;
                }
            }
            for (j = 0; j < nb_vertices; ++j) {
                indic_VP[LCVP[j]] = 0;
            }
            for (j = 0; j < LCP.Size(); ++j) {
                indic_P[((Integer)LCP.get((int)j)).intValue()] = false;
            }
            if (nb_edges > 0) {
                int p = 0;
                boolean different_seeds = false;
                for (i2 = 0; i2 < nblbl1; ++i2) {
                    val = -0.5;
                    for (j = 0; j < nb_vertices; ++j) {
                        x = LCVP[j];
                        xr = PowerWatershed.element_find(x, Fth);
                        if (!(Math.abs((double)proba[i2][xr] - val) > 1.0E-6) || !(proba[i2][xr] >= 0.0f)) continue;
                        ++p;
                        val = proba[i2][xr];
                    }
                    if (p >= 2) {
                        different_seeds = true;
                        break;
                    }
                    p = 0;
                }
                if (different_seeds) {
                    for (k = 0; k < nb_edges; ++k) {
                        sorted_weights[k] = normal_weights[NEs[k]];
                    }
                    if (quicksort) {
                        PWsorts.BucketSort(sorted_weights, NEs, nb_edges, max_weight + 1);
                    } else {
                        PWsorts.QuickSortStochastic_dec(sorted_weights, NEs, 0, nb_edges - 1);
                    }
                    nb_vertices = 0;
                    int Nnb_edges = 0;
                    for (Ncpt_aretes = 0; Ncpt_aretes < nb_edges; ++Ncpt_aretes) {
                        int Ne_max = NEs[Ncpt_aretes];
                        e1 = edges[0][Ne_max];
                        e2 = edges[1][Ne_max];
                        if (normal_weights[Ne_max] != wmax) {
                            PowerWatershed.merge_node(e1, e2, Rnk, Fth, proba, nb_labels);
                            continue;
                        }
                        re1 = PowerWatershed.element_find(e1, Fth);
                        if (re1 == (re2 = PowerWatershed.element_find(e2, Fth)) || !(proba[0][re1] < 0.0f) && !(proba[0][re2] < 0.0f)) continue;
                        if (indic_VP[re1] == 0) {
                            LCVP[nb_vertices] = re1;
                            ++nb_vertices;
                            indic_VP[re1] = 1;
                        }
                        if (indic_VP[re2] == 0) {
                            LCVP[nb_vertices] = re2;
                            ++nb_vertices;
                            indic_VP[re2] = 1;
                        }
                        edgesLCP[0][Nnb_edges] = re1;
                        edgesLCP[1][Nnb_edges] = re2;
                        ++Nnb_edges;
                    }
                    for (i2 = 0; i2 < nblbl1; ++i2) {
                        k = 0;
                        for (j = 0; j < nb_vertices; ++j) {
                            xr = LCVP[j];
                            if (!(proba[i2][xr] >= 0.0f)) continue;
                            local_labels[i2][k] = proba[i2][xr];
                            local_seeds[k] = xr;
                            ++k;
                        }
                    }
                    if (nb_vertices < 10000000) {
                        success = PowerWatershed.RandomWalker(edgesLCP, Nnb_edges, LCVP, indic_VP, nb_vertices, local_seeds, local_labels, k, nb_labels, proba);
                    }
                    if (nb_vertices >= 10000000 || !success) {
                        System.err.println("Plateau of a big size (" + nb_vertices + " vertices," + Nnb_edges + " edges) the RW is not performed on it\n");
                        for (j = 0; j < Nnb_edges; ++j) {
                            e1 = edgesLCP[0][j];
                            e2 = edgesLCP[1][j];
                            PowerWatershed.merge_node(e1, e2, Rnk, Fth, proba, nb_labels);
                        }
                    }
                    for (j = 0; j < nb_vertices; ++j) {
                        indic_VP[LCVP[j]] = 0;
                    }
                } else {
                    for (j = 0; j < nb_edges; ++j) {
                        e1 = edgesLCP[0][j];
                        e2 = edgesLCP[1][j];
                        PowerWatershed.merge_node(e1, e2, Rnk, Fth, proba, nb_labels);
                    }
                }
            }
            LCP.Flush();
        }
        for (i2 = 0; i2 < N; ++i2) {
            j = i2;
            xr = i2;
            while (Fth[i2] != i2) {
                i2 = xr;
                xr = Fth[i2];
            }
            for (k = 0; k < nblbl1; ++k) {
                proba[k][j] = proba[k][i2];
            }
            i2 = j;
        }
        byte[] Temp = ((DataBufferByte)imres.getRaster().getDataBuffer()).getData();
        byte[] Temp2 = ((DataBufferByte)img_proba.getRaster().getDataBuffer()).getData();
        int[] Lut = new int[nblbl1 + 1];
        block0 : switch (markers.getType()) {
            case 10: {
                boolean found;
                byte[] bbmarkers = ((DataBufferByte)markers.getRaster().getDataBuffer()).getData();
                for (i2 = 0; i2 < bbmarkers.length; ++i2) {
                    if ((bbmarkers[i2] & 0xFF) == 0) continue;
                    found = false;
                    for (k = 0; k < nblbl1; ++k) {
                        if ((double)proba[k][i2] != 1.0) continue;
                        Lut[k] = bbmarkers[i2] & 0xFF;
                        found = true;
                    }
                    if (found) continue;
                    Lut[k] = bbmarkers[i2] & 0xFF;
                }
                break;
            }
            case 0: {
                boolean found;
                switch (markers.getRaster().getDataBuffer().getDataType()) {
                    case 3: {
                        int[] ibmarkers = ((DataBufferInt)markers.getRaster().getDataBuffer()).getData();
                        for (i2 = 0; i2 < ibmarkers.length; ++i2) {
                            if (ibmarkers[i2] == 0) continue;
                            found = false;
                            for (k = 0; k < nblbl1; ++k) {
                                if ((double)proba[k][i2] != 1.0) continue;
                                Lut[k] = ibmarkers[i2];
                                found = true;
                            }
                            if (found) continue;
                            Lut[k] = ibmarkers[i2];
                        }
                        break block0;
                    }
                    default: {
                        throw new IllegalArgumentException("DataBuffer type not supported (yet).");
                    }
                }
            }
            default: {
                throw new IllegalArgumentException("Marker image type not supported (yet).");
            }
        }
        for (j = 0; j < N; ++j) {
            double maxi = 0.0;
            int argmax = 0;
            val = 1.0;
            for (k = 0; k < nblbl1; ++k) {
                if ((double)proba[k][j] > maxi) {
                    maxi = proba[k][j];
                    argmax = k;
                }
                val -= (double)proba[k][j];
            }
            if (val > maxi) {
                argmax = k;
            }
            Temp[j] = (byte)Lut[argmax];
        }
        for (j = 0; j < N; ++j) {
            Temp2[j] = (byte)(255.0 - 255.0 * (double)proba[0][j] + 0.5);
        }
        LCP.Clear();
        LIFO.Clear();
        for (i2 = 0; i2 < 2; ++i2) {
            edgesLCP[i2] = null;
        }
        edgesLCP = null;
        Rnk = null;
        local_seeds = null;
        for (i2 = 0; i2 < nblbl1; ++i2) {
            local_labels[i2] = null;
        }
        local_labels = null;
        LCVP = null;
        Es = null;
        NEs = null;
        indic_E = null;
        indic_VP = null;
        indic_P = null;
        Fth = null;
        for (i2 = 0; i2 < nblbl1; ++i2) {
            proba[i2] = null;
        }
        proba = null;
        sorted_weights = null;
        Temp2 = null;
        Temp = null;
        Lut = null;
    }

    private void Kruskal(int[][] edges, int[] weights, int max_weight, int[] seeds, int[] labels, int size_seeds, int rs, int cs, int ds, int nblabels, BufferedImage markers, BufferedImage imres) {
        int y;
        int x;
        int k;
        int i2;
        int N = rs * cs * ds;
        int M = ds * rs * (cs - 1) + ds * (rs - 1) * cs + (ds - 1) * cs * rs;
        int numvoisins = 6;
        Stack<Integer> LIFO = new Stack<Integer>(M);
        int[] Mrk = new int[N];
        for (i2 = 0; i2 < size_seeds; ++i2) {
            Mrk[seeds[i2]] = labels[i2];
        }
        int[] Rnk = new int[N];
        int[] Fth = new int[N];
        for (k = 0; k < N; ++k) {
            Fth[k] = k;
        }
        int[] Es = new int[M];
        for (k = 0; k < M; ++k) {
            Es[k] = k;
        }
        int[] sorted_weights = new int[M];
        System.arraycopy(weights, 0, sorted_weights, 0, M);
        PWsorts.BucketSort(sorted_weights, Es, M, max_weight + 1);
        sorted_weights = null;
        int nb_arete = 0;
        int cpt_aretes = 0;
        while (nb_arete < N - size_seeds) {
            int e_max = Es[cpt_aretes];
            ++cpt_aretes;
            int e1 = edges[0][e_max];
            int e2 = edges[1][e_max];
            x = PowerWatershed.element_find(e1, Fth);
            if (x == (y = PowerWatershed.element_find(e2, Fth)) || 1 <= Mrk[x] && 1 <= Mrk[y]) continue;
            int root = PowerWatershed.element_link(x, y, Rnk, Fth);
            ++nb_arete;
            if (1 <= Mrk[x]) {
                Mrk[root] = Mrk[x];
                continue;
            }
            if (1 > Mrk[y]) continue;
            Mrk[root] = Mrk[y];
        }
        int[] Map2 = new int[N];
        int[] Map22 = new int[N];
        for (i2 = 0; i2 < N; ++i2) {
            Map22[i2] = PowerWatershed.element_find(i2, Fth);
        }
        boolean[] Fullseeds = new boolean[N];
        Arrays.fill(Fullseeds, false);
        for (i2 = 0; i2 < size_seeds; ++i2) {
            Fullseeds[seeds[i2]] = true;
            Map2[seeds[i2]] = labels[i2];
        }
        Arrays.fill(Mrk, 0);
        for (i2 = 0; i2 < size_seeds; ++i2) {
            LIFO.Push(seeds[i2]);
            while (!LIFO.isEmpty()) {
                x = (Integer)LIFO.TopPop();
                Mrk[x] = 1;
                for (k = 1; k <= numvoisins; ++k) {
                    y = this.neighbor(x, k, rs, cs, ds);
                    if (y == -1 || Map22[y] != Map22[seeds[i2]] || Fullseeds[y] || Mrk[y] != 0) continue;
                    LIFO.Push(y);
                    Map2[y] = labels[i2];
                    Mrk[y] = 1;
                }
            }
            LIFO.Flush();
        }
        int[] Lut = new int[nblabels + 1];
        switch (markers.getType()) {
            case 10: {
                byte[] bbmarkers = ((DataBufferByte)markers.getRaster().getDataBuffer()).getData();
                for (i2 = 0; i2 < bbmarkers.length; ++i2) {
                    if ((bbmarkers[i2] & 0xFF) == 0) continue;
                    Lut[Map2[i2]] = bbmarkers[i2] & 0xFF;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Marker image type not supported (yet).");
            }
        }
        byte[] Temp = ((DataBufferByte)imres.getRaster().getDataBuffer()).getData();
        for (int j = 0; j < N; ++j) {
            Temp[j] = (byte)Lut[Map2[j]];
        }
        Temp = null;
        Lut = null;
        LIFO.Flush();
        Rnk = null;
        Fth = null;
        Mrk = null;
        Fullseeds = null;
        Es = null;
        Map22 = null;
        Map2 = null;
    }

    private void compute_edges(int[][] ed, int rs, int cs, int ds) {
        int M = 0;
        int rs_cs = rs * cs;
        for (int k = 0; k < ds; ++k) {
            int j;
            int i2;
            for (i2 = 0; i2 < cs; ++i2) {
                for (j = 0; j < rs; ++j) {
                    if (i2 >= cs - 1) continue;
                    ed[0][M] = j + i2 * rs + k * rs_cs;
                    ed[1][M] = j + (i2 + 1) * rs + k * rs_cs;
                    ++M;
                }
            }
            for (i2 = 0; i2 < cs; ++i2) {
                for (j = 0; j < rs; ++j) {
                    if (j >= rs - 1) continue;
                    ed[0][M] = j + i2 * rs + k * rs_cs;
                    ed[1][M] = j + 1 + i2 * rs + k * rs_cs;
                    ++M;
                }
            }
            if (k == ds - 1) continue;
            for (int l = k * rs_cs; l < (k + 1) * rs_cs; ++l) {
                ed[0][M] = l;
                ed[1][M] = l + rs_cs;
                ++M;
            }
        }
    }

    int neighbor_node_edge(int i2, int k, int rs, int cs, int ds) {
        int rs_cs = rs * cs;
        int zp = i2 % rs_cs;
        int z = i2 / rs_cs;
        int V = (cs - 1) * rs;
        int H = (rs - 1) * cs;
        switch (k) {
            case 1: {
                if (zp % rs >= rs - 1) {
                    return -1;
                }
                return zp + V - zp / rs + z * (V + H + rs_cs);
            }
            case 3: {
                if (zp % rs == 0) {
                    return -1;
                }
                return zp + V - zp / rs - 1 + z * (V + H + rs_cs);
            }
            case 2: {
                if (zp / rs >= cs - 1) {
                    return -1;
                }
                return zp + z * (V + H + rs_cs);
            }
            case 4: {
                if (zp / rs == 0) {
                    return -1;
                }
                return zp - rs + z * (V + H + rs_cs);
            }
            case 5: {
                if (z == 0) {
                    return -1;
                }
                return z * (V + H) + zp + (z - 1) * rs_cs;
            }
            case 6: {
                if (z >= ds - 1) {
                    return -1;
                }
                return (z + 1) * (V + H) + zp + z * rs_cs;
            }
            case -1: {
                return i2 + rs_cs;
            }
            case 0: {
                return i2 + rs_cs * 2;
            }
        }
        throw new Error("Default. Should never happened");
    }

    private void grey_weights(BufferedImage image, int[] weights, int[][] edges, int[] seeds, int size_seeds, boolean geod, boolean quicksort) {
        int ds = 1;
        byte[] img = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
        int rs = image.getWidth();
        int cs = image.getHeight();
        int M = ds * rs * (cs - 1) + ds * (rs - 1) * cs + (ds - 1) * cs * rs;
        if (!geod) {
            for (int i2 = 0; i2 < M; ++i2) {
                weights[i2] = 255 - Math.abs((img[edges[0][i2]] & 0xFF) - (img[edges[1][i2]] & 0xFF));
            }
        } else {
            int[] weights_tmp = new int[M];
            int[] seeds_function = new int[M];
            Arrays.fill(seeds_function, 0);
            int numvoisins = 4;
            if (ds > 1) {
                numvoisins = 6;
            }
            for (int i3 = 0; i3 < M; ++i3) {
                weights_tmp[i3] = 255 - Math.abs((img[edges[0][i3]] & 0xFF) - (img[edges[1][i3]] & 0xFF));
            }
            for (int j = 0; j < size_seeds; ++j) {
                for (int k = 1; k <= numvoisins; ++k) {
                    int n = this.neighbor_node_edge(seeds[j], k, rs, cs, ds);
                    if (n == -1) continue;
                    seeds_function[n] = weights_tmp[n];
                }
            }
            this.gageodilate_union_find(seeds_function, weights_tmp, weights, edges, rs, cs, ds, 255, quicksort);
            weights_tmp = null;
            seeds_function = null;
        }
    }

    private int[] grey_weights_PW(BufferedImage image, int[][] ed, int[] seeds, int size_seeds, int[] weights, boolean quicksort) {
        int ds = 1;
        byte[] img = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
        int rs = image.getWidth();
        int cs = image.getHeight();
        int M = ds * rs * (cs - 1) + ds * (rs - 1) * cs + (ds - 1) * cs * rs;
        int[] normal_weights = new int[M];
        int[] seeds_function = new int[M];
        Arrays.fill(seeds_function, 0);
        int numvoisins = 4;
        if (ds > 1) {
            numvoisins = 6;
        }
        for (int i2 = 0; i2 < M; ++i2) {
            normal_weights[i2] = 255 - Math.abs((img[ed[0][i2]] & 0xFF) - (img[ed[1][i2]] & 0xFF));
        }
        for (int j = 0; j < size_seeds; ++j) {
            for (int k = 1; k <= numvoisins; ++k) {
                int n = this.neighbor_node_edge(seeds[j], k, rs, cs, ds);
                if (n == -1) continue;
                seeds_function[n] = normal_weights[n];
            }
        }
        this.gageodilate_union_find(seeds_function, normal_weights, weights, ed, rs, cs, ds, 255, quicksort);
        seeds_function = null;
        image = null;
        return normal_weights;
    }

    private void element_link_geod_dilate(int n, int p, int[] Fth, int[] G, int[] O) {
        int r = PowerWatershed.element_find(n, Fth);
        if (r != p) {
            if (G[r] == G[p] || G[p] >= O[r]) {
                Fth[r] = p;
                O[p] = Math.max(O[r], O[p]);
            } else {
                O[p] = this.MAX;
            }
        }
    }

    public static int element_find(int x, int[] Fth) {
        if (Fth[x] != x) {
            Fth[x] = PowerWatershed.element_find(Fth[x], Fth);
        }
        return Fth[x];
    }

    public static int element_link(int x, int y, int[] Rnk, int[] Fth) {
        if (Rnk[x] > Rnk[y]) {
            int t = x;
            x = y;
            y = t;
        }
        if (Rnk[x] == Rnk[y]) {
            int n = y;
            Rnk[n] = Rnk[n] + 1;
        }
        Fth[x] = y;
        return y;
    }

    public static void merge_node(int e1, int e2, int[] Rnk, int[] Fth, float[][] proba, int nb_labels) {
        block2: {
            int nblbl;
            int re2;
            int re1;
            block3: {
                re1 = PowerWatershed.element_find(e1, Fth);
                if (re1 == (re2 = PowerWatershed.element_find(e2, Fth)) || proba[0][re1] >= 0.0f && proba[0][re2] >= 0.0f) break block2;
                nblbl = nb_labels - 1;
                PowerWatershed.element_link(re1, re2, Rnk, Fth);
                if (!(proba[0][re2] >= 0.0f) || !(proba[0][re1] < 0.0f)) break block3;
                for (int k = 0; k < nblbl; ++k) {
                    proba[k][re1] = proba[k][re2];
                }
                break block2;
            }
            if (!(proba[0][re1] >= 0.0f) || !(proba[0][re2] < 0.0f)) break block2;
            for (int k = 0; k < nblbl; ++k) {
                proba[k][re2] = proba[k][re1];
            }
        }
    }

    private void gageodilate_union_find(int[] F, int[] G, int[] O, int[][] ed, int rs, int cs, int ds, int max_weight, boolean quicksort) {
        int n;
        int i2;
        int p;
        int k;
        int M = ds * rs * (cs - 1) + ds * (rs - 1) * cs + (ds - 1) * cs * rs;
        boolean[] Mrk = new boolean[M];
        Arrays.fill(Mrk, false);
        int[] Fth = new int[M];
        int[] Es = new int[M];
        for (k = 0; k < M; ++k) {
            Fth[k] = k;
            O[k] = F[k];
            F[k] = G[k];
            Es[k] = k;
        }
        this.MAX = max_weight;
        if (quicksort) {
            PWsorts.BucketSortCroiss(F, Es, M, this.MAX + 1);
        } else {
            PWsorts.QuickSortStochastic_inc(F, Es, 0, M - 1);
        }
        if (ds == 1) {
            for (k = M - 1; k >= 0; --k) {
                p = Es[k];
                for (i2 = 1; i2 <= 6; ++i2) {
                    n = PowerWatershed.neighbor_edge(p, i2, rs, cs, ds);
                    if (n != -1 && Mrk[n]) {
                        this.element_link_geod_dilate(n, p, Fth, G, O);
                    }
                    Mrk[p] = true;
                }
            }
        } else {
            for (k = M - 1; k >= 0; --k) {
                p = Es[k];
                for (i2 = 1; i2 <= 12; ++i2) {
                    n = PowerWatershed.neighbor_edge_3D(ed[0][p], ed[1][p], p, i2, rs, cs, ds);
                    if (n != -1 && Mrk[n]) {
                        this.element_link_geod_dilate(n, p, Fth, G, O);
                    }
                    Mrk[p] = true;
                }
            }
        }
        for (k = 0; k < M; ++k) {
            p = Es[k];
            if (Fth[p] == p) {
                if (O[p] != this.MAX) continue;
                O[p] = G[p];
                continue;
            }
            O[p] = O[Fth[p]];
        }
        Fth = null;
        Es = null;
        Mrk = null;
    }

    public static boolean RandomWalker(int[][] index_edges, int M, int[] index, int[] indic_vertex, int N, int[] index_seeds, float[][] boundary_values, int numb_boundary, int nb_labels, float[][] proba) {
        int i2;
        boolean[] seeded_vertex = new boolean[N];
        Arrays.fill(seeded_vertex, false);
        int[] indic_sparse = new int[N];
        int[] nb_same_edges = new int[M];
        for (i2 = 0; i2 < N; ++i2) {
            indic_vertex[index[i2]] = i2;
        }
        for (int j = 0; j < M; ++j) {
            int v1 = indic_vertex[index_edges[0][j]];
            int v2 = indic_vertex[index_edges[1][j]];
            if (v1 < v2) {
                for (i2 = 0; i2 < 2; ++i2) {
                    index_edges[i2][j] = indic_vertex[index_edges[i2][j]];
                    int n = index_edges[i2][j];
                    indic_sparse[n] = indic_sparse[n] + 1;
                }
                continue;
            }
            index_edges[1][j] = v1;
            index_edges[0][j] = v2;
            int n = index_edges[0][j];
            indic_sparse[n] = indic_sparse[n] + 1;
            int n2 = index_edges[1][j];
            indic_sparse[n2] = indic_sparse[n2] + 1;
        }
        PWsorts.SortEdges(index_edges, M, nb_same_edges);
        for (i2 = 0; i2 < numb_boundary; ++i2) {
            index_seeds[i2] = indic_vertex[index_seeds[i2]];
            seeded_vertex[index_seeds[i2]] = true;
        }
        PWtools.CS A2 = new PWtools.CS(N - numb_boundary, N - numb_boundary, M * 2 + N, 1, 1);
        if (PWtools.fill_A(A2, N, M, numb_boundary, index_edges, seeded_vertex, indic_sparse, nb_same_edges)) {
            PWtools.CS A = PWtools.cs_compress(A2);
            PWtools.cs_spfree(A2);
            A2 = null;
            PWtools.CS B2 = new PWtools.CS(N - numb_boundary, numb_boundary, 2 * M + N, 1, 1);
            PWtools.fill_B(B2, N, M, numb_boundary, index_edges, seeded_vertex, indic_sparse, nb_same_edges);
            PWtools.CS B = PWtools.cs_compress(B2);
            PWtools.cs_spfree(B2);
            B2 = null;
            PWtools.CS X = new PWtools.CS(numb_boundary, 1, numb_boundary, 1, 1);
            double[] b = new double[N - numb_boundary];
            for (int l = 0; l < nb_labels - 1; ++l) {
                int k;
                int rnz = 0;
                i2 = 0;
                while (i2 < numb_boundary) {
                    X.x[rnz] = boundary_values[l][i2];
                    X.p[rnz] = 0;
                    X.i[rnz] = i2++;
                    ++rnz;
                }
                X.nz = rnz;
                X.m = numb_boundary;
                X.n = 1;
                PWtools.CS X2 = PWtools.cs_compress(X);
                PWtools.CS b_tmp = PWtools.cs_multiply(B, X2);
                Arrays.fill(b, 0, N - numb_boundary, 0.0);
                for (i2 = 0; i2 < b_tmp.nzmax; ++i2) {
                    b[b_tmp.i[i2]] = -b_tmp.x[i2];
                }
                PWtools.cs_lusol(1, A, b, 1.0E-7);
                int cpt = 0;
                for (k = 0; k < N; ++k) {
                    if (seeded_vertex[k]) continue;
                    proba[l][index[k]] = (float)b[cpt];
                    ++cpt;
                }
                for (k = 0; k < numb_boundary; ++k) {
                    proba[l][index[index_seeds[k]]] = boundary_values[l][k];
                }
                PWtools.cs_spfree(X2);
                PWtools.cs_spfree(b_tmp);
            }
            seeded_vertex = null;
            indic_sparse = null;
            nb_same_edges = null;
            PWtools.cs_spfree(X);
            PWtools.cs_spfree(A);
            PWtools.cs_spfree(B);
            X = null;
            B = null;
            A = null;
            b = null;
            return true;
        }
        seeded_vertex = null;
        indic_sparse = null;
        nb_same_edges = null;
        return false;
    }

    public static int neighbor_edge_3D(int node1, int node2, int i2, int k, int rs, int cs, int ds) {
        if (ds == 1) {
            return PowerWatershed.neighbor_edge(i2, k, rs, cs, ds);
        }
        int index = -1;
        int rs_cs = rs * cs;
        int V = (cs - 1) * rs;
        int H = (rs - 1) * cs;
        if (k <= 6) {
            int zp = node1 % rs_cs;
            int z = node1 / rs_cs;
            switch (k) {
                case 1: {
                    if (zp % rs >= rs - 1) {
                        return -1;
                    }
                    index = zp + V - zp / rs + z * (V + H + rs_cs);
                    break;
                }
                case 2: {
                    if (zp / rs >= cs - 1) {
                        return -1;
                    }
                    index = zp + z * (V + H + rs_cs);
                    break;
                }
                case 3: {
                    if (zp % rs == 0) {
                        return -1;
                    }
                    index = zp + V - zp / rs - 1 + z * (V + H + rs_cs);
                    break;
                }
                case 4: {
                    if (zp / rs == 0) {
                        return -1;
                    }
                    index = zp - rs + z * (V + H + rs_cs);
                    break;
                }
                case 5: {
                    if (z == 0) {
                        return -1;
                    }
                    index = z * (V + H) + zp + (z - 1) * rs_cs;
                    break;
                }
                case 6: {
                    if (z >= ds - 1) {
                        return -1;
                    }
                    index = (z + 1) * (V + H) + zp + z * rs_cs;
                    break;
                }
                default: {
                    throw new Error("Should occured???");
                }
            }
        } else {
            int zp = node2 % rs_cs;
            int z = node2 / rs_cs;
            switch (k - 6) {
                case 1: {
                    if (zp % rs >= rs - 1) {
                        return -1;
                    }
                    index = zp + V - zp / rs + z * (V + H + rs_cs);
                    break;
                }
                case 3: {
                    if (zp % rs == 0) {
                        return -1;
                    }
                    index = zp + V - zp / rs - 1 + z * (V + H + rs_cs);
                    break;
                }
                case 2: {
                    if (zp / rs >= cs - 1) {
                        return -1;
                    }
                    index = zp + z * (V + H + rs_cs);
                    break;
                }
                case 4: {
                    if (zp / rs == 0) {
                        return -1;
                    }
                    index = zp - rs + z * (V + H + rs_cs);
                    break;
                }
                case 5: {
                    if (z == 0) {
                        return -1;
                    }
                    index = z * (V + H) + zp + (z - 1) * rs_cs;
                    break;
                }
                case 6: {
                    if (z >= ds - 1) {
                        return -1;
                    }
                    index = (z + 1) * (V + H) + zp + z * rs_cs;
                    break;
                }
                default: {
                    throw new Error("Should occured???");
                }
            }
        }
        if (index == i2) {
            return -1;
        }
        return index;
    }

    public static int neighbor_edge(int i2, int k, int rs, int cs, int ds) {
        int V = (cs - 1) * rs;
        if (i2 >= V) {
            switch (k) {
                case 1: {
                    if (i2 - V < rs - 1) {
                        return -1;
                    }
                    return ((i2 - V) / (rs - 1) - 1) * rs + (i2 - V) % (rs - 1) + 1;
                }
                case 2: {
                    if (i2 - V < rs - 1) {
                        return -1;
                    }
                    return ((i2 - V) / (rs - 1) - 1) * rs + (i2 - V) % (rs - 1);
                }
                case 3: {
                    if ((i2 - V) % (rs - 1) == 0) {
                        return -1;
                    }
                    return i2 - 1;
                }
                case 4: {
                    if (i2 > (rs - 1) * cs + V - rs) {
                        return -1;
                    }
                    return ((i2 - V) / (rs - 1) - 1) * rs + (i2 - V) % (rs - 1) + rs;
                }
                case 5: {
                    if (i2 > (rs - 1) * cs + V - rs) {
                        return -1;
                    }
                    return ((i2 - V) / (rs - 1) - 1) * rs + (i2 - V) % (rs - 1) + rs + 1;
                }
                case 6: {
                    if ((i2 - V) % (rs - 1) == rs - 2) {
                        return -1;
                    }
                    return i2 + 1;
                }
            }
            throw new Error("Should occured???");
        }
        switch (k) {
            case 1: {
                if (i2 < rs) {
                    return -1;
                }
                return i2 - rs;
            }
            case 2: {
                if (i2 % rs == 0) {
                    return -1;
                }
                return i2 + V - i2 / rs - 1;
            }
            case 3: {
                if (i2 % rs == 0) {
                    return -1;
                }
                return i2 + V - i2 / rs - 1 + rs - 1;
            }
            case 4: {
                if (i2 >= V - rs) {
                    return -1;
                }
                return i2 + rs;
            }
            case 5: {
                if (i2 % rs == rs - 1) {
                    return -1;
                }
                return i2 + V - i2 / rs + rs - 1;
            }
            case 6: {
                if (i2 % rs == rs - 1) {
                    return -1;
                }
                return i2 + V - i2 / rs;
            }
        }
        throw new Error("Should occured???");
    }

    private int neighbor(int i2, int k, int rs, int cs, int ds) {
        int rs_cs = rs * cs;
        int z = i2 / rs_cs;
        int x = i2 / (rs * ds);
        int y = i2 % rs;
        switch (k) {
            case 1: {
                if (y >= rs - 1) {
                    return -1;
                }
                return i2 + 1;
            }
            case 3: {
                if (y == 0) {
                    return -1;
                }
                return i2 - 1;
            }
            case 2: {
                if (x >= cs - 1) {
                    return -1;
                }
                return i2 + rs;
            }
            case 4: {
                if (x == 0) {
                    return -1;
                }
                return i2 - rs;
            }
            case 5: {
                if (z >= ds - 1) {
                    return -1;
                }
                return i2 + rs_cs;
            }
            case 6: {
                if (z == 0) {
                    return -1;
                }
                return i2 - rs_cs;
            }
            case 0: {
                return rs_cs;
            }
            case -1: {
                return rs_cs + 1;
            }
        }
        return -1;
    }

    public static enum Algorithms {
        PowerWatershed,
        Kruskal,
        PrimRBtree;

    }
}

