/*
 * Decompiled with CFR 0.152.
 */
package morphee.segmentation.watershed.galactic;

import java.util.Arrays;
import utils.pointers.IntPointer;

public class PWtools {
    public static void cs_spfree(CS M) {
        M.p = null;
        M.i = null;
        M.x = null;
    }

    public static void cs_sfree(CSS S) {
        if (S == null) {
            return;
        }
        S.pinv = null;
        S.q = null;
        S.parent = null;
        S.cp = null;
        S.leftmost = null;
    }

    public static void cs_nfree(CSN N) {
        if (N == null) {
            return;
        }
        PWtools.cs_spfree(N.L);
        PWtools.cs_spfree(N.U);
        N.pinv = null;
        N.B = null;
    }

    public static boolean CS_TRIPLET(CS A) {
        return A != null && 0 <= A.nz;
    }

    public static int CS_FLIP(int i2) {
        return -i2 - 2;
    }

    public static int CS_UNFLIP(int i2) {
        return i2 < 0 ? PWtools.CS_FLIP(i2) : i2;
    }

    public static int CS_MARKED(int[] w, int j) {
        return w[j] < 0 ? 1 : 0;
    }

    public static void CS_MARK(int[] w, int j) {
        w[j] = PWtools.CS_FLIP(w[j]);
    }

    public static boolean CS_CSC(CS A) {
        return A != null && A.nz == -1;
    }

    public static boolean fill_A(CS A, int N, int M, int numb_boundary, int[][] index_edges, boolean[] seeded_vertex, int[] indic_sparse, int[] nb_same_edges) {
        int k;
        int rnz = 0;
        for (k = 0; k < N; ++k) {
            if (seeded_vertex[k]) continue;
            A.x[rnz] = indic_sparse[k];
            A.i[rnz] = rnz;
            A.p[rnz] = rnz;
            ++rnz;
        }
        int rnzs = 0;
        int rnzu = 0;
        for (k = 0; k < N; ++k) {
            indic_sparse[k] = seeded_vertex[k] ? rnzs++ : rnzu++;
        }
        for (k = 0; k < M; ++k) {
            if (seeded_vertex[index_edges[0][k]] || seeded_vertex[index_edges[1][k]]) continue;
            A.x[rnz] = -nb_same_edges[k] - 1;
            A.i[rnz] = indic_sparse[index_edges[0][k]];
            A.p[rnz] = indic_sparse[index_edges[1][k]];
            A.x[++rnz] = -nb_same_edges[k] - 1;
            A.p[rnz] = indic_sparse[index_edges[0][k]];
            A.i[rnz] = indic_sparse[index_edges[1][k]];
            ++rnz;
            k += nb_same_edges[k];
        }
        A.nz = rnz;
        A.m = N - numb_boundary;
        A.n = N - numb_boundary;
        return true;
    }

    public static void fill_B(CS B, int N, int M, int numb_boundary, int[][] index_edges, boolean[] seeded_vertex, int[] indic_sparse, int[] nb_same_edges) {
        int rnz = 0;
        for (int k = 0; k < M; ++k) {
            if (seeded_vertex[index_edges[0][k]]) {
                B.x[rnz] = -nb_same_edges[k] - 1;
                B.p[rnz] = indic_sparse[index_edges[0][k]];
                B.i[rnz] = indic_sparse[index_edges[1][k]];
                ++rnz;
                k += nb_same_edges[k];
                continue;
            }
            if (!seeded_vertex[index_edges[1][k]]) continue;
            B.x[rnz] = -nb_same_edges[k] - 1;
            B.p[rnz] = indic_sparse[index_edges[1][k]];
            B.i[rnz] = indic_sparse[index_edges[0][k]];
            ++rnz;
            k += nb_same_edges[k];
        }
        B.nz = rnz;
        B.m = N - numb_boundary;
        B.n = numb_boundary;
    }

    public static double cs_cumsum(int[] p, int[] c, int n) {
        int nz = 0;
        double nz2 = 0.0;
        if (p == null || c == null) {
            throw new IllegalArgumentException("Null");
        }
        for (int i2 = 0; i2 < n; ++i2) {
            p[i2] = nz;
            nz += c[i2];
            nz2 += (double)c[i2];
            c[i2] = p[i2];
        }
        p[n] = nz;
        return nz2;
    }

    public static CS cs_compress(CS T) {
        int k;
        if (!PWtools.CS_TRIPLET(T)) {
            throw new IllegalArgumentException("Null");
        }
        int m = T.m;
        int n = T.n;
        int[] Ti = T.i;
        int[] Tj = T.p;
        double[] Tx = T.x;
        int nz = T.nz;
        CS C = new CS(m, n, nz, Tx != null ? 1 : 0, 0);
        int[] w = new int[n];
        int[] Cp = C.p;
        int[] Ci = C.i;
        double[] Cx = C.x;
        for (k = 0; k < nz; ++k) {
            int n2 = Tj[k];
            w[n2] = w[n2] + 1;
        }
        PWtools.cs_cumsum(Cp, w, n);
        for (k = 0; k < nz; ++k) {
            int n3 = Tj[k];
            w[n3] = w[n3] + 1;
            Ci[p] = Ti[k];
            if (Cx == null) continue;
            Cx[p] = Tx[k];
        }
        w = null;
        Tj = null;
        Ti = null;
        Tx = null;
        Cx = null;
        Ci = null;
        Cp = null;
        return C;
    }

    public static int cs_diag(int i2, int j) {
        return i2 != j ? 1 : 0;
    }

    public static int cs_fkeep_cs_diag(CS A) {
        int nz = 0;
        double[] Ax = null;
        if (!PWtools.CS_CSC(A)) {
            throw new IllegalArgumentException("Null");
        }
        int n = A.n;
        int[] Ap = A.p;
        int[] Ai = A.i;
        Ax = A.x;
        for (int j = 0; j < n; ++j) {
            Ap[j] = nz;
            for (int p = Ap[j]; p < Ap[j + 1]; ++p) {
                if (PWtools.cs_diag(Ai[p], j) == 0) continue;
                if (Ax != null) {
                    Ax[nz] = Ax[p];
                }
                Ai[nz++] = Ai[p];
            }
        }
        Ap[n] = nz;
        PWtools.cs_sprealloc(A, 0);
        Ai = null;
        Ap = null;
        Ax = null;
        return nz;
    }

    public static int cs_wclear(int mark, int lemax, int[] w, int n) {
        if (mark < 2 || mark + lemax < 0) {
            for (int k = 0; k < n; ++k) {
                if (w[k] == 0) continue;
                w[k] = 1;
            }
            mark = 2;
        }
        return mark;
    }

    public static int cs_wclear(int mark, int lemax, int[] w, int start, int n) {
        if (mark < 2 || mark + lemax < 0) {
            for (int k = 0; k < n; ++k) {
                if (w[start + k] == 0) continue;
                w[start + k] = 1;
            }
            mark = 2;
        }
        return mark;
    }

    public static int cs_tdfs(int j, int k, int[] W, int head, int next, int[] post, int stack) {
        int top = 0;
        W[stack + 0] = j;
        while (top >= 0) {
            int p = W[stack + top];
            int i2 = W[head + p];
            if (i2 == -1) {
                --top;
                post[k++] = p;
                continue;
            }
            W[head + p] = W[next + i2];
            W[stack + ++top] = i2;
        }
        return k;
    }

    public static int[] cs_amd(int order, CS A) {
        int e;
        int d;
        int i2;
        int k;
        int p;
        int j;
        int p2;
        int[] ATi;
        int[] ATp;
        CS C;
        int lemax = 0;
        int mindeg = 0;
        int nel = 0;
        if (!PWtools.CS_CSC(A) || order <= 0 || order > 3) {
            throw new IllegalArgumentException("");
        }
        CS AT = PWtools.cs_transpose(A, 0);
        int m = A.m;
        int n = A.n;
        int dense = Math.max(16, (int)(10.0 * Math.sqrt(n) + 0.5));
        dense = Math.min(n - 2, dense);
        if (order == 1 && n == m) {
            C = PWtools.cs_add(A, AT, 0.0, 0.0);
        } else if (order == 2) {
            ATp = AT.p;
            ATi = AT.i;
            p2 = 0;
            for (j = 0; j < m; ++j) {
                ATp[j] = p2;
                if (ATp[j + 1] - p > dense) continue;
                for (p = ATp[j]; p < ATp[j + 1]; ++p) {
                    ATi[p2++] = ATi[p];
                }
            }
            ATp[m] = p2;
            CS A2 = PWtools.cs_transpose(AT, 0);
            C = A2 != null ? PWtools.cs_multiply(AT, A2) : null;
            PWtools.cs_spfree(A2);
            A2 = null;
        } else {
            C = PWtools.cs_multiply(AT, A);
        }
        PWtools.cs_spfree(AT);
        AT = null;
        if (C == null) {
            return null;
        }
        PWtools.cs_fkeep_cs_diag(C);
        int[] Cp = C.p;
        int cnz = Cp[n];
        int[] P = new int[n + 1];
        int[] W = new int[8 * (n + 1)];
        int t = cnz + cnz / 5 + 2 * n;
        if (P == null || W == null || PWtools.cs_sprealloc(C, t) == 0) {
            return null;
        }
        int[] len = W;
        int nv = n + 1;
        int next = 2 * (n + 1);
        int head = 3 * (n + 1);
        int elen = 4 * (n + 1);
        int degree = 5 * (n + 1);
        int w = 6 * (n + 1);
        int hhead = 7 * (n + 1);
        int[] last = P;
        for (k = 0; k < n; ++k) {
            len[k] = Cp[k + 1] - Cp[k];
        }
        len[n] = 0;
        int nzmax = C.nzmax;
        int[] Ci = C.i;
        for (i2 = 0; i2 <= n; ++i2) {
            W[head + i2] = -1;
            last[i2] = -1;
            W[next + i2] = -1;
            W[hhead + i2] = -1;
            W[nv + i2] = 1;
            W[w + i2] = 1;
            W[elen + i2] = 0;
            W[degree + i2] = len[i2];
        }
        int mark = PWtools.cs_wclear(0, 0, W, w, n);
        W[elen + n] = -2;
        Cp[n] = -1;
        W[w + n] = 0;
        for (i2 = 0; i2 < n; ++i2) {
            d = W[degree + i2];
            if (d == 0) {
                W[elen + i2] = -2;
                ++nel;
                Cp[i2] = -1;
                W[w + i2] = 0;
                continue;
            }
            if (d > dense) {
                W[nv + i2] = 0;
                W[elen + i2] = -1;
                ++nel;
                Cp[i2] = PWtools.CS_FLIP(n);
                int n2 = nv + n;
                W[n2] = W[n2] + 1;
                continue;
            }
            if (W[head + d] != -1) {
                last[W[head + d]] = i2;
            }
            W[next + i2] = W[head + d];
            W[head + d] = i2;
        }
        while (nel < n) {
            int h;
            int eln;
            int pk;
            int nvi;
            int ln;
            int pk1;
            k = -1;
            while (mindeg < n && (k = W[head + mindeg]) == -1) {
                ++mindeg;
            }
            if (W[next + k] != -1) {
                last[W[next + k]] = -1;
            }
            W[head + mindeg] = W[next + k];
            int elenk = W[elen + k];
            int nvk = W[nv + k];
            nel += nvk;
            if (elenk > 0 && cnz + mindeg >= nzmax) {
                for (j = 0; j < n; ++j) {
                    p = Cp[j];
                    if (p < 0) continue;
                    Cp[j] = Ci[p];
                    Ci[p] = PWtools.CS_FLIP(j);
                }
                p = 0;
                int q = 0;
                while (p < cnz) {
                    if ((j = PWtools.CS_FLIP(Ci[p++])) < 0) continue;
                    Ci[q] = Cp[j];
                    Cp[j] = q++;
                    for (int k3 = 0; k3 < len[j] - 1; ++k3) {
                        Ci[q++] = Ci[p++];
                    }
                }
                cnz = q;
            }
            int dk = 0;
            W[nv + k] = -nvk;
            p = Cp[k];
            int pk2 = pk1 = elenk == 0 ? p : cnz;
            for (int k1 = 1; k1 <= elenk + 1; ++k1) {
                int pj;
                if (k1 > elenk) {
                    e = k;
                    pj = p;
                    ln = len[k] - elenk;
                } else {
                    e = Ci[p++];
                    pj = Cp[e];
                    ln = len[e];
                }
                for (int k2 = 1; k2 <= ln; ++k2) {
                    if ((nvi = W[nv + (i2 = Ci[pj++])]) <= 0) continue;
                    dk += nvi;
                    W[nv + i2] = -nvi;
                    Ci[pk2++] = i2;
                    if (W[next + i2] != -1) {
                        last[W[next + i2]] = last[i2];
                    }
                    if (last[i2] != -1) {
                        W[next + last[i2]] = W[next + i2];
                        continue;
                    }
                    W[head + W[degree + i2]] = W[next + i2];
                }
                if (e == k) continue;
                Cp[e] = PWtools.CS_FLIP(k);
                W[w + e] = 0;
            }
            if (elenk != 0) {
                cnz = pk2;
            }
            W[degree + k] = dk;
            Cp[k] = pk1;
            len[k] = pk2 - pk1;
            W[elen + k] = -2;
            mark = PWtools.cs_wclear(mark, lemax, W, w, n);
            for (pk = pk1; pk < pk2; ++pk) {
                i2 = Ci[pk];
                eln = W[elen + i2];
                if (eln <= 0) continue;
                nvi = -W[nv + i2];
                int wnvi = mark - nvi;
                for (p = Cp[i2]; p <= Cp[i2] + eln - 1; ++p) {
                    e = Ci[p];
                    if (W[w + e] >= mark) {
                        int n3 = w + e;
                        W[n3] = W[n3] - nvi;
                        continue;
                    }
                    if (W[w + e] == 0) continue;
                    W[w + e] = W[degree + e] + wnvi;
                }
            }
            for (pk = pk1; pk < pk2; ++pk) {
                i2 = Ci[pk];
                int p1 = Cp[i2];
                p2 = p1 + W[elen + i2] - 1;
                int pn = p1;
                d = 0;
                h = 0;
                for (p = p1; p <= p2; ++p) {
                    e = Ci[p];
                    if (W[w + e] == 0) continue;
                    int dext = W[w + e] - mark;
                    if (dext > 0) {
                        d += dext;
                        Ci[pn++] = e;
                        h += e;
                        continue;
                    }
                    Cp[e] = PWtools.CS_FLIP(k);
                    W[w + e] = 0;
                }
                W[elen + i2] = pn - p1 + 1;
                int p3 = pn;
                int p4 = p1 + len[i2];
                for (p = p2 + 1; p < p4; ++p) {
                    j = Ci[p];
                    int nvj = W[nv + j];
                    if (nvj <= 0) continue;
                    d += nvj;
                    Ci[pn++] = j;
                    h += j;
                }
                if (d == 0) {
                    Cp[i2] = PWtools.CS_FLIP(k);
                    nvi = -W[nv + i2];
                    dk -= nvi;
                    nvk += nvi;
                    nel += nvi;
                    W[nv + i2] = 0;
                    W[elen + i2] = -1;
                    continue;
                }
                W[degree + i2] = Math.min(W[degree + i2], d);
                Ci[pn] = Ci[p3];
                Ci[p3] = Ci[p1];
                Ci[p1] = k;
                len[i2] = pn - p1 + 1;
                W[next + i2] = W[hhead + (h %= n)];
                W[hhead + h] = i2;
                last[i2] = h;
            }
            W[degree + k] = dk;
            lemax = Math.max(lemax, dk);
            mark = PWtools.cs_wclear(mark + lemax, lemax, W, w, n);
            for (pk = pk1; pk < pk2; ++pk) {
                i2 = Ci[pk];
                if (W[nv + i2] >= 0) continue;
                h = last[i2];
                i2 = W[hhead + h];
                W[hhead + h] = -1;
                while (i2 != -1 && W[next + i2] != -1) {
                    ln = len[i2];
                    eln = W[elen + i2];
                    for (p = Cp[i2] + 1; p <= Cp[i2] + ln - 1; ++p) {
                        W[w + Ci[p]] = mark;
                    }
                    int jlast = i2;
                    j = W[next + i2];
                    while (j != -1) {
                        boolean ok = len[j] == ln && W[elen + j] == eln;
                        for (p = Cp[j] + 1; ok && p <= Cp[j] + ln - 1; ++p) {
                            if (W[w + Ci[p]] == mark) continue;
                            ok = false;
                        }
                        if (ok) {
                            Cp[j] = PWtools.CS_FLIP(i2);
                            int n4 = nv + i2;
                            W[n4] = W[n4] + W[nv + j];
                            W[nv + j] = 0;
                            W[elen + j] = -1;
                            W[next + jlast] = j = W[next + j];
                            continue;
                        }
                        jlast = j;
                        j = W[next + j];
                    }
                    i2 = W[next + i2];
                    ++mark;
                }
            }
            p = pk1;
            for (pk = pk1; pk < pk2; ++pk) {
                i2 = Ci[pk];
                nvi = -W[nv + i2];
                if (nvi <= 0) continue;
                W[nv + i2] = nvi;
                d = W[degree + i2] + dk - nvi;
                if (W[head + (d = Math.min(d, n - nel - nvi))] != -1) {
                    last[W[head + d]] = i2;
                }
                W[next + i2] = W[head + d];
                last[i2] = -1;
                W[head + d] = i2;
                mindeg = Math.min(mindeg, d);
                W[degree + i2] = d;
                Ci[p++] = i2;
            }
            W[nv + k] = nvk;
            len[k] = p - pk1;
            if (len[k] == 0) {
                Cp[k] = -1;
                W[w + k] = 0;
            }
            if (elenk == 0) continue;
            cnz = p;
        }
        for (i2 = 0; i2 < n; ++i2) {
            Cp[i2] = PWtools.CS_FLIP(Cp[i2]);
        }
        for (j = 0; j <= n; ++j) {
            W[head + j] = -1;
        }
        for (j = n; j >= 0; --j) {
            if (W[nv + j] > 0) continue;
            W[next + j] = W[head + Cp[j]];
            W[head + Cp[j]] = j;
        }
        for (e = n; e >= 0; --e) {
            if (W[nv + e] <= 0 || Cp[e] == -1) continue;
            W[next + e] = W[head + Cp[e]];
            W[head + Cp[e]] = e;
        }
        k = 0;
        for (i2 = 0; i2 <= n; ++i2) {
            if (Cp[i2] != -1) continue;
            k = PWtools.cs_tdfs(i2, k, W, head, next, P, w);
        }
        PWtools.cs_spfree(C);
        C = null;
        W = null;
        ATi = null;
        ATp = null;
        len = null;
        W = null;
        last = null;
        Ci = null;
        Cp = null;
        return P;
    }

    public static int[] cs_etree(CS A, int ata) {
        int i2;
        int[] w;
        int m = A.m;
        int n = A.n;
        int[] Ap = A.p;
        int[] Ai = A.i;
        int[] parent = new int[n];
        int[] ancestor = w = new int[n + (ata != 0 ? m : 0)];
        int prev = n;
        if (ata != 0) {
            for (i2 = 0; i2 < m; ++i2) {
                w[prev + i2] = -1;
            }
        }
        for (int k = 0; k < n; ++k) {
            parent[k] = -1;
            ancestor[k] = -1;
            for (int p = Ap[k]; p < Ap[k + 1]; ++p) {
                int n2 = i2 = ata != 0 ? w[prev + Ai[p]] : Ai[p];
                while (i2 != -1 && i2 < k) {
                    int inext = ancestor[i2];
                    ancestor[i2] = k;
                    if (inext == -1) {
                        parent[i2] = k;
                    }
                    i2 = inext;
                }
                if (ata == 0) continue;
                w[prev + Ai[p]] = k;
            }
        }
        w = null;
        ancestor = null;
        Ai = null;
        Ap = null;
        return parent;
    }

    public static int[] cs_post(int[] parent, int n) {
        int j;
        int k = 0;
        if (parent == null) {
            throw new IllegalArgumentException("Null");
        }
        int[] post = new int[n];
        int[] w = new int[3 * n];
        int head = 0;
        int next = n;
        int stack = 2 * n;
        for (j = 0; j < n; ++j) {
            w[head + j] = -1;
        }
        for (j = n - 1; j >= 0; --j) {
            if (parent[j] == -1) continue;
            w[next + j] = w[head + parent[j]];
            w[head + parent[j]] = j;
        }
        for (j = 0; j < n; ++j) {
            if (parent[j] != -1) continue;
            k = PWtools.cs_tdfs(j, k, w, head, next, post, stack);
        }
        w = null;
        return post;
    }

    public static void init_ata(CS AT, int[] post, int[] w, IntPointer head, IntPointer next) {
        int k;
        int m = AT.n;
        int n = AT.m;
        int[] ATp = AT.p;
        int[] ATi = AT.i;
        head.value = 4 * n;
        next.value = 5 * n + 1;
        for (k = 0; k < n; ++k) {
            w[post[k]] = k;
        }
        int i2 = 0;
        while (i2 < m) {
            k = n;
            for (int p = ATp[i2]; p < ATp[i2 + 1]; ++p) {
                k = Math.min(k, w[ATi[p]]);
            }
            w[next.value + i2] = w[head.value + k];
            w[head.value + k] = i2++;
        }
    }

    public static int cs_leaf(int i2, int j, int[] w, int first, int maxfirst, int prevleaf, int[] ancestor, IntPointer jleaf) {
        if (ancestor == null || jleaf == null) {
            return -1;
        }
        jleaf.value = 0;
        if (i2 <= j || w[first + j] <= w[maxfirst + i2]) {
            return -1;
        }
        w[maxfirst + i2] = w[first + j];
        int jprev = w[prevleaf + i2];
        w[prevleaf + i2] = j;
        int n = jleaf.value = jprev == -1 ? 1 : 2;
        if (jleaf.value == 1) {
            return i2;
        }
        int q = jprev;
        while (q != ancestor[q]) {
            q = ancestor[q];
        }
        int s = jprev;
        while (s != q) {
            int sparent = ancestor[s];
            ancestor[s] = q;
            s = sparent;
        }
        return q;
    }

    public static int cs_sprealloc(CS A, int nzmax) {
        if (nzmax <= 0) {
            nzmax = PWtools.CS_CSC(A) ? A.p[A.n] : A.nz;
        }
        int[] ii = new int[nzmax];
        System.arraycopy(A.i, 0, ii, 0, Math.min(nzmax, A.i.length));
        A.i = null;
        A.i = ii;
        if (PWtools.CS_TRIPLET(A)) {
            int[] pp = new int[nzmax];
            System.arraycopy(A.p, 0, pp, 0, Math.min(nzmax, A.p.length));
            A.p = null;
            A.p = pp;
        }
        if (A.x != null) {
            double[] xx = new double[nzmax];
            System.arraycopy(A.x, 0, xx, 0, Math.min(nzmax, A.x.length));
            A.x = null;
            A.x = xx;
        }
        A.nzmax = nzmax;
        return 1;
    }

    public static int cs_dfs(int j, CS G, int top, int[] xi, int pstack, int[] pinv) {
        int head = 0;
        if (!PWtools.CS_CSC(G) || xi == null) {
            throw new IllegalArgumentException("Null");
        }
        int[] Gp = G.p;
        int[] Gi = G.i;
        xi[0] = j;
        while (head >= 0) {
            int jnew;
            j = xi[head];
            int n = jnew = pinv != null ? pinv[j] : j;
            if (PWtools.CS_MARKED(Gp, j) == 0) {
                PWtools.CS_MARK(Gp, j);
                xi[pstack + head] = jnew < 0 ? 0 : PWtools.CS_UNFLIP(Gp[jnew]);
            }
            boolean done = true;
            int p2 = jnew < 0 ? 0 : PWtools.CS_UNFLIP(Gp[jnew + 1]);
            for (int p = xi[pstack + head]; p < p2; ++p) {
                int i2 = Gi[p];
                if (PWtools.CS_MARKED(Gp, i2) != 0) continue;
                xi[pstack + head] = p;
                xi[++head] = i2;
                done = false;
                break;
            }
            if (!done) continue;
            --head;
            xi[--top] = j;
        }
        Gi = null;
        Gp = null;
        return top;
    }

    public static int cs_reach(CS G, CS B, int k, int[] xi, int[] pinv) {
        int p;
        if (!PWtools.CS_CSC(G) || !PWtools.CS_CSC(B) || xi == null) {
            throw new IllegalArgumentException("Null");
        }
        int n = G.n;
        int[] Bp = B.p;
        int[] Bi = B.i;
        int[] Gp = G.p;
        int top = n;
        for (p = Bp[k]; p < Bp[k + 1]; ++p) {
            if (PWtools.CS_MARKED(Gp, Bi[p]) != 0) continue;
            top = PWtools.cs_dfs(Bi[p], G, top, xi, n, pinv);
        }
        for (p = top; p < n; ++p) {
            PWtools.CS_MARK(Gp, xi[p]);
        }
        Gp = null;
        Bi = null;
        Bp = null;
        return top;
    }

    public static int cs_spsolve(CS G, CS B, int k, int[] xi, double[] x, int[] pinv, int lo) {
        int top;
        int p;
        if (!PWtools.CS_CSC(G) || !PWtools.CS_CSC(B) || xi == null || x == null) {
            throw new IllegalArgumentException("Null");
        }
        int[] Gp = G.p;
        int[] Gi = G.i;
        double[] Gx = G.x;
        int n = G.n;
        int[] Bp = B.p;
        int[] Bi = B.i;
        double[] Bx = B.x;
        for (p = top = PWtools.cs_reach(G, B, k, xi, pinv); p < n; ++p) {
            x[xi[p]] = 0.0;
        }
        for (p = Bp[k]; p < Bp[k + 1]; ++p) {
            x[Bi[p]] = Bx[p];
        }
        for (int px = top; px < n; ++px) {
            int q;
            int J;
            int j = xi[px];
            int n2 = J = pinv != null ? pinv[j] : j;
            if (J < 0) continue;
            int n3 = j;
            x[n3] = x[n3] / Gx[lo != 0 ? Gp[J] : Gp[J + 1] - 1];
            int n4 = q = lo != 0 ? Gp[J + 1] : Gp[J + 1] - 1;
            for (p = lo != 0 ? Gp[J] + 1 : Gp[J]; p < q; ++p) {
                int n5 = Gi[p];
                x[n5] = x[n5] - Gx[p] * x[j];
            }
        }
        Bi = null;
        Bp = null;
        Gi = null;
        Gp = null;
        return top;
    }

    public static int[] cs_counts(CS A, int[] parent, int[] post, int ata) {
        int i2;
        int j;
        int k;
        int[] colcount;
        IntPointer head = new IntPointer();
        IntPointer next = new IntPointer();
        IntPointer jleaf = new IntPointer();
        if (!PWtools.CS_CSC(A) || parent == null || post == null) {
            throw new IllegalArgumentException("Null");
        }
        int m = A.m;
        int n = A.n;
        int s = 4 * n + (ata != 0 ? n + m + 1 : 0);
        int[] delta = colcount = new int[n];
        int[] w = new int[s];
        CS AT = PWtools.cs_transpose(A, 0);
        int[] ancestor = w;
        int maxfirst = n;
        int prevleaf = 2 * n;
        int first = 3 * n;
        for (k = 0; k < s; ++k) {
            w[k] = -1;
        }
        for (k = 0; k < n; ++k) {
            j = post[k];
            int n2 = delta[j] = w[first + j] == -1 ? 1 : 0;
            while (j != -1 && w[first + j] == -1) {
                w[first + j] = k;
                j = parent[j];
            }
        }
        int[] ATp = AT.p;
        int[] ATi = AT.i;
        if (ata != 0) {
            PWtools.init_ata(AT, post, w, head, next);
        }
        for (i2 = 0; i2 < n; ++i2) {
            ancestor[i2] = i2;
        }
        for (k = 0; k < n; ++k) {
            int J;
            j = post[k];
            if (parent[j] != -1) {
                int n3 = parent[j];
                delta[n3] = delta[n3] - 1;
            }
            int n4 = J = ata != 0 ? w[head.value + k] : j;
            while (J != -1) {
                for (int p = ATp[J]; p < ATp[J + 1]; ++p) {
                    i2 = ATi[p];
                    int q = PWtools.cs_leaf(i2, j, w, first, maxfirst, prevleaf, ancestor, jleaf);
                    if (jleaf.value >= 1) {
                        int n5 = j;
                        delta[n5] = delta[n5] + 1;
                    }
                    if (jleaf.value != 2) continue;
                    int n6 = q;
                    delta[n6] = delta[n6] - 1;
                }
                J = ata != 0 ? w[next.value + J] : -1;
            }
            if (parent[j] == -1) continue;
            ancestor[j] = parent[j];
        }
        for (j = 0; j < n; ++j) {
            if (parent[j] == -1) continue;
            int n7 = parent[j];
            colcount[n7] = colcount[n7] + colcount[j];
        }
        AT = null;
        delta = null;
        w = null;
        ancestor = null;
        ATi = null;
        ATp = null;
        next = null;
        head = null;
        jleaf = null;
        return colcount;
    }

    public static int cs_vcount(CS A, CSS S) {
        int i2;
        int k;
        int n = A.n;
        int m = A.m;
        int[] Ap = A.p;
        int[] Ai = A.i;
        int[] parent = S.parent;
        int[] pinv = new int[m + n];
        S.pinv = pinv;
        int[] leftmost = new int[m];
        S.leftmost = leftmost;
        int[] w = new int[m + 3 * n];
        if (pinv == null || w == null || leftmost == null) {
            w = null;
            throw new IllegalArgumentException("Null");
        }
        int next = 0;
        int head = m;
        int tail = m + n;
        int nque = m + 2 * n;
        for (k = 0; k < n; ++k) {
            w[head + k] = -1;
        }
        for (k = 0; k < n; ++k) {
            w[tail + k] = -1;
        }
        for (k = 0; k < n; ++k) {
            w[nque + k] = 0;
        }
        Arrays.fill(leftmost, -1);
        for (k = n - 1; k >= 0; --k) {
            for (int p = Ap[k]; p < Ap[k + 1]; ++p) {
                leftmost[Ai[p]] = k;
            }
        }
        for (i2 = m - 1; i2 >= 0; --i2) {
            pinv[i2] = -1;
            k = leftmost[i2];
            if (k == -1) continue;
            int n2 = nque + k;
            int n3 = w[n2];
            w[n2] = n3 + 1;
            if (n3 == 0) {
                w[tail + k] = i2;
            }
            w[next + i2] = w[head + k];
            w[head + k] = i2;
        }
        S.lnz = 0.0;
        S.m2 = m;
        for (k = 0; k < n; ++k) {
            i2 = w[head + k];
            S.lnz += 1.0;
            if (i2 < 0) {
                i2 = S.m2++;
            }
            pinv[i2] = k;
            int n4 = nque + k;
            w[n4] = w[n4] - 1;
            if (w[n4] <= 0) continue;
            S.lnz += (double)w[nque + k];
            int pa = parent[k];
            if (pa == -1) continue;
            if (w[nque + pa] == 0) {
                w[tail + pa] = w[tail + k];
            }
            w[next + w[tail + k]] = w[head + pa];
            w[head + pa] = w[next + i2];
            int n5 = nque + pa;
            w[n5] = w[n5] + w[nque + k];
        }
        for (i2 = 0; i2 < m; ++i2) {
            if (pinv[i2] >= 0) continue;
            pinv[i2] = k++;
        }
        leftmost = null;
        pinv = null;
        parent = null;
        Ai = null;
        Ap = null;
        w = null;
        return 1;
    }

    public static CSS cs_sqr(int order, CS A, int qr) {
        boolean ok = true;
        if (!PWtools.CS_CSC(A)) {
            throw new IllegalArgumentException("Null");
        }
        int n = A.n;
        CSS S = new CSS();
        S.q = PWtools.cs_amd(order, A);
        if (order != 0 && S.q == null) {
            throw new IllegalArgumentException("Null");
        }
        if (qr != 0) {
            CS C = order != 0 ? PWtools.cs_permute(A, null, S.q, 0) : A;
            S.parent = PWtools.cs_etree(C, 1);
            int[] post = PWtools.cs_post(S.parent, n);
            S.cp = PWtools.cs_counts(C, S.parent, post, 1);
            post = null;
            boolean bl = ok = C != null && S.parent != null && S.cp != null && PWtools.cs_vcount(C, S) != 0;
            if (ok) {
                S.unz = 0.0;
                for (int k = 0; k < n; ++k) {
                    S.unz += (double)S.cp[k];
                }
            }
            boolean bl2 = ok = ok && S.lnz >= 0.0 && S.unz >= 0.0;
            if (order != 0) {
                PWtools.cs_spfree(C);
                C = null;
            }
        } else {
            S.lnz = S.unz = (double)(4 * A.p[n] + n);
        }
        return ok ? S : null;
    }

    public static int cs_ipvec(int[] p, double[] b, double[] x, int n) {
        if (x == null || b == null) {
            throw new IllegalArgumentException("Null");
        }
        for (int k = 0; k < n; ++k) {
            x[p != null ? p[k] : k] = b[k];
        }
        return 1;
    }

    public static int cs_lsolve(CS L, double[] x) {
        if (!PWtools.CS_CSC(L) || x == null) {
            throw new IllegalArgumentException("Null");
        }
        int n = L.n;
        int[] Lp = L.p;
        int[] Li2 = L.i;
        double[] Lx = L.x;
        for (int j = 0; j < n; ++j) {
            int n2 = j;
            x[n2] = x[n2] / Lx[Lp[j]];
            for (int p = Lp[j] + 1; p < Lp[j + 1]; ++p) {
                int n3 = Li2[p];
                x[n3] = x[n3] - Lx[p] * x[j];
            }
        }
        Li2 = null;
        Lp = null;
        Lx = null;
        return 1;
    }

    public static int cs_usolve(CS U, double[] x) {
        if (!PWtools.CS_CSC(U) || x == null) {
            throw new IllegalArgumentException("Null");
        }
        int n = U.n;
        int[] Up = U.p;
        int[] Ui = U.i;
        double[] Ux = U.x;
        for (int j = n - 1; j >= 0; --j) {
            int n2 = j;
            x[n2] = x[n2] / Ux[Up[j + 1] - 1];
            for (int p = Up[j]; p < Up[j + 1] - 1; ++p) {
                int n3 = Ui[p];
                x[n3] = x[n3] - Ux[p] * x[j];
            }
        }
        Ui = null;
        Up = null;
        Ux = null;
        return 1;
    }

    public static int cs_scatter(CS A, int j, double beta, int[] w, double[] x, int mark, CS C, int nz) {
        if (!PWtools.CS_CSC(A) || w == null || !PWtools.CS_CSC(C)) {
            throw new IllegalArgumentException("Null");
        }
        int[] Ap = A.p;
        int[] Ai = A.i;
        double[] Ax = A.x;
        int[] Ci = C.i;
        if (x != null) {
            for (int p = Ap[j]; p < Ap[j + 1]; ++p) {
                int i2 = Ai[p];
                if (w[i2] < mark) {
                    w[i2] = mark;
                    Ci[nz++] = i2;
                    x[i2] = beta * Ax[p];
                    continue;
                }
                int n = i2;
                x[n] = x[n] + beta * Ax[p];
            }
        } else {
            for (int p = Ap[j]; p < Ap[j + 1]; ++p) {
                int i3 = Ai[p];
                if (w[i3] >= mark) continue;
                w[i3] = mark;
                Ci[nz++] = i3;
            }
        }
        Ci = null;
        Ai = null;
        Ap = null;
        Ax = null;
        return nz;
    }

    public static CSN cs_lu(CS A, CSS S, double tol) {
        int p;
        double[] Ux;
        int[] Ui;
        double[] Lx;
        int[] Li2;
        CS U;
        CS L;
        if (!PWtools.CS_CSC(A) || S == null) {
            throw new IllegalArgumentException("Null");
        }
        int n = A.n;
        int[] q = S.q;
        int lnz = (int)S.lnz;
        int unz = (int)S.unz;
        double[] x = new double[n];
        int[] xi = new int[2 * n];
        CSN N = new CSN();
        N.L = L = new CS(n, n, lnz, 1, 0);
        N.U = U = new CS(n, n, unz, 1, 0);
        int[] pinv = new int[n];
        N.pinv = pinv;
        if (L == null || U == null || pinv == null) {
            return null;
        }
        int[] Lp = L.p;
        int[] Up = U.p;
        Arrays.fill(x, 0.0);
        Arrays.fill(pinv, -1);
        Arrays.fill(Lp, 0);
        unz = 0;
        lnz = 0;
        for (int k = 0; k < n; ++k) {
            int i2;
            Lp[k] = lnz;
            Up[k] = unz;
            if (lnz + n > L.nzmax) {
                PWtools.cs_sprealloc(L, 2 * L.nzmax + n);
            }
            if (unz + n > U.nzmax) {
                PWtools.cs_sprealloc(U, 2 * U.nzmax + n);
            }
            Li2 = L.i;
            Lx = L.x;
            Ui = U.i;
            Ux = U.x;
            int col = q != null ? q[k] : k;
            int top = PWtools.cs_spsolve(L, A, col, xi, x, pinv, 1);
            int ipiv = -1;
            double a = -1.0;
            for (p = top; p < n; ++p) {
                i2 = xi[p];
                if (pinv[i2] < 0) {
                    double d;
                    double t = Math.abs(x[i2]);
                    if (!(d > a)) continue;
                    a = t;
                    ipiv = i2;
                    continue;
                }
                Ui[unz] = pinv[i2];
                Ux[unz++] = x[i2];
            }
            if (ipiv == -1 || a <= 0.0) {
                return null;
            }
            if (pinv[col] < 0 && Math.abs(x[col]) >= a * tol) {
                ipiv = col;
            }
            double pivot = x[ipiv];
            Ui[unz] = k;
            Ux[unz++] = pivot;
            pinv[ipiv] = k;
            Li2[lnz] = ipiv;
            Lx[lnz++] = 1.0;
            for (p = top; p < n; ++p) {
                i2 = xi[p];
                if (pinv[i2] < 0) {
                    Li2[lnz] = i2;
                    Lx[lnz++] = x[i2] / pivot;
                }
                x[i2] = 0.0;
            }
        }
        Lp[n] = lnz;
        Up[n] = unz;
        Li2 = L.i;
        for (p = 0; p < lnz; ++p) {
            Li2[p] = pinv[Li2[p]];
        }
        PWtools.cs_sprealloc(L, 0);
        PWtools.cs_sprealloc(U, 0);
        Ux = null;
        Lx = null;
        x = null;
        q = null;
        xi = null;
        pinv = null;
        Ui = null;
        Up = null;
        Li2 = null;
        Lp = null;
        return N;
    }

    public static CS cs_add(CS A, CS B, double alpha, double beta) {
        int nz = 0;
        if (!PWtools.CS_CSC(A) || !PWtools.CS_CSC(B)) {
            throw new IllegalArgumentException("!CS_CSC(A) || !CS_CSC(B)");
        }
        if (A.m != B.m || A.n != B.n) {
            throw new IllegalArgumentException("A.m != B.m || A.n != B.n");
        }
        int m = A.m;
        int anz = A.p[A.n];
        int n = B.n;
        int[] Bp = B.p;
        double[] Bx = B.x;
        int bnz = Bp[n];
        int[] w = new int[m];
        int values = A.x != null && Bx != null ? 1 : 0;
        double[] x = values != 0 ? new double[m] : null;
        CS C = new CS(m, n, anz + bnz, values, 0);
        int[] Cp = C.p;
        int[] Ci = C.i;
        double[] Cx = C.x;
        for (int j = 0; j < n; ++j) {
            Cp[j] = nz;
            nz = PWtools.cs_scatter(A, j, alpha, w, x, j + 1, C, nz);
            nz = PWtools.cs_scatter(B, j, beta, w, x, j + 1, C, nz);
            if (values == 0) continue;
            for (int p = Cp[j]; p < nz; ++p) {
                Cx[p] = x[Ci[p]];
            }
        }
        Cp[n] = nz;
        PWtools.cs_sprealloc(C, 0);
        w = null;
        Cx = null;
        Bx = null;
        x = null;
        Bp = null;
        Ci = null;
        Cp = null;
        return C;
    }

    public static int cs_lusol(int order, CS A, double[] b, double tol) {
        int ok;
        if (!PWtools.CS_CSC(A) || b == null) {
            throw new IllegalArgumentException("Null");
        }
        int n = A.n;
        CSS S = PWtools.cs_sqr(order, A, 0);
        CSN N = PWtools.cs_lu(A, S, tol);
        double[] x = new double[n];
        int n2 = ok = S != null && N != null && x != null ? 1 : 0;
        if (ok != 0) {
            PWtools.cs_ipvec(N.pinv, b, x, n);
            PWtools.cs_lsolve(N.L, x);
            PWtools.cs_usolve(N.U, x);
            PWtools.cs_ipvec(S.q, x, b, n);
        }
        x = null;
        PWtools.cs_sfree(S);
        S = null;
        PWtools.cs_nfree(N);
        N = null;
        return ok;
    }

    public static CS cs_multiply(CS A, CS B) {
        double[] Cx;
        int[] Ci;
        int nz = 0;
        if (!PWtools.CS_CSC(A) || !PWtools.CS_CSC(B)) {
            throw new IllegalArgumentException("Null");
        }
        if (A.n != B.m) {
            throw new IllegalArgumentException("A.n != B.m");
        }
        int m = A.m;
        int anz = A.p[A.n];
        int n = B.n;
        int[] Bp = B.p;
        int[] Bi = B.i;
        double[] Bx = B.x;
        int bnz = Bp[n];
        int[] w = new int[m];
        int values = A.x != null && Bx != null ? 1 : 0;
        double[] x = values != 0 ? new double[m] : null;
        CS C = new CS(m, n, anz + bnz, values, 0);
        if (C == null || w == null || values != 0 && x == null) {
            throw new IllegalArgumentException("Null");
        }
        int[] Cp = C.p;
        for (int j = 0; j < n; ++j) {
            int p;
            if (nz + m > C.nzmax && PWtools.cs_sprealloc(C, 2 * C.nzmax + m) == 0) {
                return null;
            }
            Ci = C.i;
            Cx = C.x;
            Cp[j] = nz;
            for (p = Bp[j]; p < Bp[j + 1]; ++p) {
                nz = PWtools.cs_scatter(A, Bi[p], Bx != null ? Bx[p] : 1.0, w, x, j + 1, C, nz);
            }
            if (values == 0) continue;
            for (p = Cp[j]; p < nz; ++p) {
                Cx[p] = x[Ci[p]];
            }
        }
        Cp[n] = nz;
        PWtools.cs_sprealloc(C, 0);
        Bi = null;
        w = null;
        Bp = null;
        Ci = null;
        Cp = null;
        Cx = null;
        Bx = null;
        x = null;
        return C;
    }

    public static CS cs_permute(CS A, int[] pinv, int[] q, int values) {
        int nz = 0;
        int m = A.m;
        int n = A.n;
        int[] Ap = A.p;
        int[] Ai = A.i;
        double[] Ax = A.x;
        CS C = new CS(m, n, Ap[n], values != 0 && Ax != null ? 1 : 0, 0);
        int[] Cp = C.p;
        int[] Ci = C.i;
        double[] Cx = C.x;
        for (int k = 0; k < n; ++k) {
            Cp[k] = nz;
            int j = q != null ? q[k] : k;
            for (int t = Ap[j]; t < Ap[j + 1]; ++t) {
                if (Cx != null) {
                    Cx[nz] = Ax[t];
                }
                Ci[nz++] = pinv != null ? pinv[Ai[t]] : Ai[t];
            }
        }
        Cp[n] = nz;
        Ax = null;
        Cx = null;
        Ci = null;
        Cp = null;
        Ai = null;
        Ap = null;
        return C;
    }

    public static CS cs_transpose(CS A, int values) {
        int p;
        if (!PWtools.CS_CSC(A)) {
            throw new IllegalArgumentException("Null");
        }
        int m = A.m;
        int n = A.n;
        int[] Ap = A.p;
        int[] Ai = A.i;
        double[] Ax = A.x;
        CS C = new CS(n, m, Ap[n], values != 0 && Ax != null ? 1 : 0, 0);
        int[] w = new int[m];
        int[] Cp = C.p;
        int[] Ci = C.i;
        double[] Cx = C.x;
        for (p = 0; p < Ap[n]; ++p) {
            int n2 = Ai[p];
            w[n2] = w[n2] + 1;
        }
        PWtools.cs_cumsum(Cp, w, m);
        for (int j = 0; j < n; ++j) {
            for (p = Ap[j]; p < Ap[j + 1]; ++p) {
                int n3 = Ai[p];
                w[n3] = w[n3] + 1;
                Ci[q] = j;
                if (Cx == null) continue;
                Cx[q] = Ax[p];
            }
        }
        w = null;
        Ai = null;
        Ap = null;
        Ci = null;
        Cp = null;
        Ax = null;
        Cx = null;
        return C;
    }

    public static class Rbt {
        int max;
        int util;
        int maxutil;
        RbtElt root;
        RbtElt nil;
        RbtElt libre;
        RbtElt[] elts = new RbtElt[1];

        public Rbt(int taillemax) {
            this.max = taillemax;
            this.util = 0;
            this.maxutil = 0;
        }
    }

    public static class RbtElt {
        int auxdata;
        double key;
        char color;
        RbtElt left;
        RbtElt right;
        RbtElt parent;
    }

    public static class CSD {
        public int[] p;
        public int[] q;
        public int[] r;
        public int[] s;
        public int nb;
        public int[] rr = new int[5];
        public int[] cc = new int[5];
    }

    public static class CSN {
        public CS L;
        public CS U;
        public int[] pinv;
        public double[] B;
    }

    public static class CSS {
        public int[] pinv;
        public int[] q;
        public int[] parent;
        public int[] cp;
        public int[] leftmost;
        public int m2;
        public double lnz;
        public double unz;
    }

    public static class CS {
        public int nzmax;
        public int m;
        public int n;
        public int[] p;
        public int[] i;
        public double[] x;
        public int nz;

        public CS(int m, int n, int nzmax, int values, int triplet) {
            this.m = m;
            this.n = n;
            this.nzmax = nzmax = Math.max(nzmax, 1);
            this.nz = triplet != 0 ? 0 : -1;
            this.p = new int[Math.max(triplet != 0 ? nzmax : n + 1, 1)];
            this.i = new int[Math.max(1, nzmax)];
            this.x = values != 0 ? new double[Math.max(1, nzmax)] : null;
        }
    }
}

