/*
 * Decompiled with CFR 0.152.
 */
package morphee.segmentation.watershed.galactic;

import arrayTiTi.ArrayOperations;
import java.util.ArrayList;

public class PWsorts {
    public static void BucketSort(int[] A, int[] I, int r, int N) {
        int i2;
        int[] H = new int[N];
        for (i2 = 0; i2 < r; ++i2) {
            int n = A[i2];
            H[n] = H[n] + 1;
        }
        ArrayList Bucket = new ArrayList(N);
        for (i2 = 0; i2 < N; ++i2) {
            Bucket.add(new ArrayList(H[i2]));
        }
        for (i2 = 0; i2 < r; ++i2) {
            ((ArrayList)Bucket.get(A[i2])).add(i2);
        }
        int j = 0;
        for (i2 = N - 1; i2 >= 0; --i2) {
            while (!((ArrayList)Bucket.get(i2)).isEmpty()) {
                I[j] = (Integer)((ArrayList)Bucket.get(i2)).remove(((ArrayList)Bucket.get(i2)).size() - 1);
                A[j] = i2;
                ++j;
            }
        }
        H = null;
        Bucket = null;
    }

    public static void BucketSortCroiss(int[] A, int[] I, int r, int N) {
        PWsorts.BucketSort(A, I, r, N);
        ArrayOperations.Reverse((int[])A, (int)0, (int)r);
        ArrayOperations.Reverse((int[])I, (int)0, (int)r);
    }

    private static int Partitionner(int[] A, int[] I, int p, int r) {
        int x = A[p];
        int i2 = p - 1;
        int j = r + 1;
        while (true) {
            if (A[--j] > x) {
                continue;
            }
            while (A[++i2] < x) {
            }
            if (i2 >= j) break;
            int t = A[i2];
            A[i2] = A[j];
            A[j] = t;
            int t1 = I[i2];
            I[i2] = I[j];
            I[j] = t1;
        }
        return j;
    }

    private static int PartitionStochastique(int[] A, int[] I, int p, int r) {
        int q = p + (int)(Math.random() * (double)(r - p + 1));
        int t = A[p];
        A[p] = A[q];
        A[q] = t;
        int t1 = I[p];
        I[p] = I[q];
        I[q] = t1;
        return PWsorts.Partitionner(A, I, p, r);
    }

    public static void QuickSortStochastic(int[] A, int[] I, int p, int r) {
        if (p < r) {
            int q = PWsorts.PartitionStochastique(A, I, p, r);
            PWsorts.QuickSortStochastic(A, I, p, q);
            PWsorts.QuickSortStochastic(A, I, q + 1, r);
        }
    }

    public static void QuickSortStochastic_inc(int[] A, int[] I, int p, int r) {
        PWsorts.QuickSortStochastic_dec(A, I, p, r);
        ArrayOperations.Reverse((int[])A, (int)p, (int)(r + 1));
        ArrayOperations.Reverse((int[])I, (int)p, (int)(r + 1));
    }

    public static void QuickSortStochastic_dec(int[] A, int[] I, int p, int r) {
        if (p < r) {
            int q = PWsorts.PartitionStochastique_dec(A, I, p, r);
            PWsorts.QuickSortStochastic_dec(A, I, p, q);
            PWsorts.QuickSortStochastic_dec(A, I, q + 1, r);
        }
    }

    private static int PartitionStochastique_dec(int[] A, int[] I, int p, int r) {
        int q = p + (int)(Math.random() * (double)(r - p + 1));
        int t = A[p];
        A[p] = A[q];
        A[q] = t;
        int t1 = I[p];
        I[p] = I[q];
        I[q] = t1;
        return PWsorts.Partitionner_dec(A, I, p, r);
    }

    private static int Partitionner_dec(int[] A, int[] I, int p, int r) {
        int x = A[p];
        int i2 = p - 1;
        int j = r + 1;
        while (true) {
            if (A[--j] < x) {
                continue;
            }
            while (A[++i2] > x) {
            }
            if (i2 >= j) break;
            int t = A[i2];
            A[i2] = A[j];
            A[j] = t;
            int t1 = I[i2];
            I[i2] = I[j];
            I[j] = t1;
        }
        return j;
    }

    public static void SortEdges(int[][] index_edges, int M, int[] nb_same_edges) {
        int j;
        int i2;
        PWsorts.QuickSortStochastic(index_edges[0], index_edges[1], 0, M - 1);
        for (i2 = 0; i2 < M; ++i2) {
            j = i2;
            while (i2 < M - 1 && index_edges[0][i2] == index_edges[0][i2 + 1]) {
                ++i2;
            }
            if (i2 == j) continue;
            PWsorts.QuickSortStochastic(index_edges[1], index_edges[0], 0, i2 - j);
        }
        for (i2 = 0; i2 < M; ++i2) {
            j = 0;
            while (i2 + j < M - 1 && index_edges[0][i2 + j] == index_edges[0][i2 + j + 1] && index_edges[1][i2 + j] == index_edges[1][i2 + j + 1]) {
                ++j;
            }
            nb_same_edges[i2] = j;
        }
    }
}

