/*
 * Decompiled with CFR 0.152.
 */
package morphee.segmentation.watershed;

import imageTiTi.ImageNew;
import imageTiTi.ImageOperations;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.util.Arrays;
import morphee.StructuringElement;
import morphee.segmentation.watershed.Watershed;
import processing.thresholding.Binary;

public class WatershedStochastic {
    private Watershed watershed = new Watershed();
    private Binary binary = new Binary();
    private BufferedImage markers = null;
    private BufferedImage votes = null;

    public void Compute(BufferedImage image, int iterations, int nbmarkers, StructuringElement se) {
        int width = image.getWidth();
        int height = image.getHeight();
        if (this.markers == null || !ImageTools.areDimensionsEqual((BufferedImage)image, (BufferedImage)this.markers)) {
            this.markers = null;
            this.markers = ImageNew.Integer((int)width, (int)height, (int)1);
            this.votes = null;
            this.votes = ImageNew.Integer((int)width, (int)height, (int)1);
        } else {
            ImageOperations.Fill((BufferedImage)this.votes, (int)0);
        }
        int[] ibvotes = ((DataBufferInt)this.votes.getRaster().getDataBuffer()).getData();
        int[] ibmarkers = ((DataBufferInt)this.markers.getRaster().getDataBuffer()).getData();
        block4: for (int i2 = 0; i2 < iterations; ++i2) {
            Arrays.fill(ibmarkers, 0);
            int n = 1;
            while (n <= nbmarkers) {
                int x;
                while (ibmarkers[x = (int)(Math.random() * (double)ibmarkers.length)] != 0) {
                }
                ibmarkers[x] = n++;
            }
            this.watershed.watershed(image, this.markers, se);
            BufferedImage edges = this.watershed.Edges();
            switch (edges.getType()) {
                case 10: {
                    byte[] bbedges = ((DataBufferByte)edges.getRaster().getDataBuffer()).getData();
                    for (n = 0; n < bbedges.length; ++n) {
                        if ((bbedges[n] & 0xFF) == 0) continue;
                        int n2 = n;
                        ibvotes[n2] = ibvotes[n2] + 1;
                    }
                    bbedges = null;
                    continue block4;
                }
                case 11: {
                    short[] sbedges = ((DataBufferUShort)edges.getRaster().getDataBuffer()).getData();
                    for (n = 0; n < sbedges.length; ++n) {
                        if ((sbedges[n] & 0xFFFF) == 0) continue;
                        int n3 = n;
                        ibvotes[n3] = ibvotes[n3] + 1;
                    }
                    sbedges = null;
                }
            }
        }
        ibmarkers = null;
        ibvotes = null;
    }

    public BufferedImage Result(int threshold) {
        return this.binary.Filter(this.votes, threshold, 1);
    }

    public BufferedImage VoteMap() {
        return this.votes;
    }
}

