/*
 * Decompiled with CFR 0.152.
 */
package morphee.segmentation.watershed;

import dv.DV;
import dv.DvComparator;
import dv.DvNew;
import dv.DvOperations;
import dv.DvTools;
import imageTiTi.ImageComparator;
import imageTiTi.ImageNew;
import imageTiTi.ImageOperations;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.PriorityQueue;
import mathematics.primitives.pointsTiTi.CoordinatesWeighted;
import morphee.StructuringElement;
import morphee.StructuringElement3D;

public class Watershed {
    private final int HQ_FORBIDDEN = -1;
    private final int HQ_CANDIDATE = 0;
    private final int HQ_QUEUED = 1;
    private final int HQ_LABELED = 2;
    private final int HQ_WS_LINE = 3;
    private int width = -1;
    private int height = -1;
    private int Index = 0;
    private int[] statPixels = null;
    private BufferedImage imLines = null;
    private BufferedImage imBasins = null;
    private DV dvLines = null;
    private DV dvBasins = null;
    private List<Integer> dOffsets = null;
    private List<Integer> tmpOffsets = null;

    private void initWatershedHierarchicalQueue(BufferedImage imIn, PriorityQueue<wsp> hq, int minx, int miny, int maxx, int maxy) {
        int popy = this.width - maxx + minx;
        this.Index = 0;
        int[] lblPixels = ((DataBufferInt)this.imBasins.getRaster().getDataBuffer()).getData();
        Arrays.fill(this.statPixels, -1);
        switch (imIn.getType()) {
            case 10: {
                byte[] bbinPixels = ((DataBufferByte)imIn.getRaster().getDataBuffer()).getData();
                int y = miny;
                int pos = miny * this.width + minx;
                while (y < maxy) {
                    int x = minx;
                    while (x < maxx) {
                        if (lblPixels[pos] != 0) {
                            hq.add(new wsp(x, y, 0, pos, bbinPixels[pos] & 0xFF, this.Index++));
                            this.statPixels[pos] = 2;
                        } else {
                            this.statPixels[pos] = 0;
                        }
                        ++x;
                        ++pos;
                    }
                    ++y;
                    pos += popy;
                }
                bbinPixels = null;
                break;
            }
            case 11: {
                short[] sbinPixels = ((DataBufferUShort)imIn.getRaster().getDataBuffer()).getData();
                int y = miny;
                int pos = miny * this.width + minx;
                while (y < maxy) {
                    int x = minx;
                    while (x < maxx) {
                        if (lblPixels[pos] != 0) {
                            hq.add(new wsp(x, y, 0, pos, sbinPixels[pos] & 0xFFFF, this.Index++));
                            this.statPixels[pos] = 2;
                        } else {
                            this.statPixels[pos] = 0;
                        }
                        ++x;
                        ++pos;
                    }
                    ++y;
                    pos += popy;
                }
                sbinPixels = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported (yet).");
            }
        }
        lblPixels = null;
    }

    private void processWatershedHierarchicalQueue(BufferedImage imIn, PriorityQueue<wsp> hq, StructuringElement se, int minx, int miny, int maxx, int maxy) {
        int i2;
        CoordinatesWeighted[] setab = se.getSE();
        boolean it_start = false;
        int it_end = setab.length;
        boolean it_off_start = false;
        wsp token = null;
        if (this.dOffsets == null) {
            this.dOffsets = new ArrayList<Integer>(it_end << 1);
        } else {
            this.dOffsets.clear();
        }
        for (i2 = 0; i2 < it_end; ++i2) {
            CoordinatesWeighted cw = setab[i2];
            this.dOffsets.add(cw.X + cw.Y * this.width);
            cw = null;
        }
        if (this.tmpOffsets == null) {
            this.tmpOffsets = new ArrayList<Integer>(imIn.getHeight() * imIn.getWidth());
        } else {
            this.tmpOffsets.clear();
        }
        int[] lblPixels = ((DataBufferInt)this.imBasins.getRaster().getDataBuffer()).getData();
        byte[] bbinPixels = null;
        short[] sbinPixels = null;
        switch (imIn.getType()) {
            case 10: {
                bbinPixels = ((DataBufferByte)imIn.getRaster().getDataBuffer()).getData();
                break;
            }
            case 11: {
                sbinPixels = ((DataBufferUShort)imIn.getRaster().getDataBuffer()).getData();
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported (yet).");
            }
        }
        while (!hq.isEmpty()) {
            token = hq.poll();
            int curOffset = token.offset;
            int x0 = token.x;
            int y0 = token.y;
            this.statPixels[curOffset] = 2;
            int it = 0;
            int it_off = 0;
            while (it < it_end) {
                CoordinatesWeighted itcw = setab[it];
                if (itcw.X != 0 || itcw.Y != 0) {
                    int x = x0 + itcw.X;
                    int y = y0 + itcw.Y;
                    if (minx <= x && x < maxx && miny <= y && y < maxy) {
                        int nbOffset = curOffset + this.dOffsets.get(it_off);
                        int nbStat = this.statPixels[nbOffset];
                        if (nbStat == 0) {
                            this.tmpOffsets.add(nbOffset);
                        } else if (nbStat == 2) {
                            if (lblPixels[curOffset] == 0) {
                                lblPixels[curOffset] = lblPixels[nbOffset];
                            } else if (lblPixels[curOffset] != lblPixels[nbOffset]) {
                                this.statPixels[curOffset] = 3;
                            }
                        }
                    }
                }
                itcw = null;
                ++it;
                ++it_off;
            }
            if (this.statPixels[curOffset] == 2 && !this.tmpOffsets.isEmpty()) {
                switch (imIn.getType()) {
                    case 10: {
                        int rest;
                        int div;
                        int stit;
                        int t_it;
                        for (t_it = 0; t_it != this.tmpOffsets.size(); ++t_it) {
                            stit = this.tmpOffsets.get(t_it);
                            div = stit / this.width;
                            rest = stit % this.width;
                            hq.add(new wsp(rest, div, 0, stit, bbinPixels[stit] & 0xFF, this.Index++));
                            this.statPixels[stit] = 1;
                        }
                        break;
                    }
                    case 11: {
                        int rest;
                        int div;
                        int stit;
                        int t_it;
                        for (t_it = 0; t_it != this.tmpOffsets.size(); ++t_it) {
                            stit = this.tmpOffsets.get(t_it);
                            div = stit / this.width;
                            rest = stit % this.width;
                            hq.add(new wsp(rest, div, 0, stit, sbinPixels[stit] & 0xFFFF, this.Index++));
                            this.statPixels[stit] = 1;
                        }
                        break;
                    }
                }
            }
            token = null;
            this.tmpOffsets.clear();
        }
        for (i2 = 0; i2 < lblPixels.length; ++i2) {
            if (this.statPixels[i2] != 0) continue;
            this.statPixels[i2] = 3;
        }
        lblPixels = null;
        bbinPixels = null;
        sbinPixels = null;
        lblPixels = null;
    }

    public void watershed(BufferedImage imIn, BufferedImage imMarkers, StructuringElement se) {
        this.watershed(imIn, imMarkers, se, 0, 0, imIn.getWidth(), imIn.getHeight());
    }

    public void watershed(BufferedImage imIn, BufferedImage imMarkers, StructuringElement se, int minx, int miny, int maxx, int maxy) {
        if (!ImageTools.areDimensionsEqual((BufferedImage)imIn, (BufferedImage)imMarkers)) {
            throw new IllegalArgumentException("Images have different dimensions.");
        }
        if (se.getOrder() != 1) {
            throw new IllegalArgumentException("Structuring element is not unitary (order = 1).");
        }
        if (se.getType() != -1 && se.getType() != -2) {
            throw new IllegalArgumentException("The structuring element must be of type SQUARE (8-connexity) or DISK (4-connexity).");
        }
        if (imMarkers.getRaster().getDataBuffer().getDataType() != 3) {
            throw new IllegalArgumentException("The imMarkers must have a DataBuffer of type int (DataBuffer.TYPE_INT).");
        }
        this.width = imIn.getWidth();
        this.height = imIn.getHeight();
        PriorityQueue<wsp> piorityqueue = new PriorityQueue<wsp>(((maxx - minx) * (maxy - miny) >> 2) * 3);
        if (this.statPixels == null || imIn.getRaster().getDataBuffer().getSize() != this.statPixels.length) {
            this.statPixels = new int[imIn.getRaster().getDataBuffer().getSize()];
        }
        if (this.imLines == null || !ImageTools.areDimensionsAndTypeEqual((BufferedImage)imIn, (BufferedImage)this.imLines)) {
            this.imLines = ImageNew.Same((BufferedImage)imIn);
        } else {
            ImageOperations.Fill((BufferedImage)this.imLines, (int)0);
        }
        if (this.imBasins == null || !ImageTools.areDimensionsAndTypeEqual((BufferedImage)imMarkers, (BufferedImage)this.imBasins)) {
            this.imBasins = ImageNew.Same((BufferedImage)imMarkers);
        }
        ImageNew.Copy((BufferedImage)imMarkers, (BufferedImage)this.imBasins);
        this.initWatershedHierarchicalQueue(imIn, piorityqueue, minx, miny, maxx, maxy);
        this.processWatershedHierarchicalQueue(imIn, piorityqueue, se, minx, miny, maxx, maxy);
        ImageComparator.Compare((BufferedImage)this.imBasins, (String)"!=", (int)-1, (BufferedImage)this.imBasins, (int)0, (BufferedImage)this.imBasins);
        piorityqueue.clear();
        piorityqueue = null;
        switch (imIn.getType()) {
            case 10: {
                byte[] bbpixOut = ((DataBufferByte)this.imLines.getRaster().getDataBuffer()).getData();
                int wsVal = 255;
                for (int i2 = 0; i2 < this.statPixels.length; ++i2) {
                    if (this.statPixels[i2] != 3) continue;
                    bbpixOut[i2] = (byte)wsVal;
                }
                bbpixOut = null;
                break;
            }
            case 11: {
                short[] sbpixOut = ((DataBufferUShort)this.imLines.getRaster().getDataBuffer()).getData();
                int wsVal = 65535;
                for (int i3 = 0; i3 < this.statPixels.length; ++i3) {
                    if (this.statPixels[i3] != 3) continue;
                    sbpixOut[i3] = (short)wsVal;
                }
                sbpixOut = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported (yet).");
            }
        }
    }

    public void watershed(BufferedImage imIn, List<CoordinatesWeighted> markers, StructuringElement se) {
        this.watershed(imIn, markers, se, 0, 0, imIn.getWidth(), imIn.getHeight());
    }

    public void watershed(BufferedImage imIn, List<CoordinatesWeighted> markers, StructuringElement se, int minx, int miny, int maxx, int maxy) {
        int i2;
        if (se.getOrder() != 1) {
            throw new IllegalArgumentException("Structuring element is not unitary (order = 1).");
        }
        if (se.getType() != -1 && se.getType() != -2) {
            throw new IllegalArgumentException("The structuring element must be of type SQUARE (8-connexity) or DISK (4-connexity).");
        }
        if (markers.isEmpty()) {
            throw new IllegalArgumentException("Empty list => No marker.");
        }
        this.width = imIn.getWidth();
        this.height = imIn.getHeight();
        PriorityQueue<wsp> piorityqueue = new PriorityQueue<wsp>(((maxx - minx) * (maxy - miny) >> 2) * 3);
        if (this.statPixels == null || imIn.getRaster().getDataBuffer().getSize() != this.statPixels.length) {
            this.statPixels = new int[imIn.getRaster().getDataBuffer().getSize()];
        }
        if (this.imLines == null || !ImageTools.areDimensionsAndTypeEqual((BufferedImage)imIn, (BufferedImage)this.imLines)) {
            this.imLines = ImageNew.Same((BufferedImage)imIn);
        } else {
            ImageOperations.Fill((BufferedImage)this.imLines, (int)0);
        }
        if (this.imBasins == null || !ImageTools.areDimensionsEqual((BufferedImage)imIn, (BufferedImage)this.imBasins)) {
            this.imBasins = ImageNew.Integer((int)imIn.getWidth(), (int)imIn.getHeight(), (int)1);
        } else {
            ImageOperations.Fill((BufferedImage)this.imBasins, (int)0);
        }
        int[] lblPixels = ((DataBufferInt)this.imBasins.getRaster().getDataBuffer()).getData();
        for (i2 = 0; i2 < markers.size(); ++i2) {
            CoordinatesWeighted c = markers.get(i2);
            lblPixels[c.Y * this.width + c.X] = c.Wi;
        }
        this.initWatershedHierarchicalQueue(imIn, piorityqueue, minx, miny, maxx, maxy);
        this.processWatershedHierarchicalQueue(imIn, piorityqueue, se, minx, miny, maxx, maxy);
        ImageComparator.Compare((BufferedImage)this.imBasins, (String)"!=", (int)-1, (BufferedImage)this.imBasins, (int)0, (BufferedImage)this.imBasins);
        piorityqueue.clear();
        piorityqueue = null;
        switch (imIn.getType()) {
            case 10: {
                byte[] bbpixOut = ((DataBufferByte)this.imLines.getRaster().getDataBuffer()).getData();
                int wsVal = 255;
                for (i2 = 0; i2 < this.statPixels.length; ++i2) {
                    if (this.statPixels[i2] != 3) continue;
                    bbpixOut[i2] = (byte)wsVal;
                }
                bbpixOut = null;
                break;
            }
            case 11: {
                short[] sbpixOut = ((DataBufferUShort)this.imLines.getRaster().getDataBuffer()).getData();
                int wsVal = 65535;
                for (i2 = 0; i2 < this.statPixels.length; ++i2) {
                    if (this.statPixels[i2] != 3) continue;
                    sbpixOut[i2] = (short)wsVal;
                }
                sbpixOut = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported (yet).");
            }
        }
    }

    private void initWatershedHierarchicalQueue(DV dvIn, PriorityQueue<wsp> hq, int minx, int miny, int minz, int maxx, int maxy, int maxz) {
        hq.clear();
        this.Index = 0;
        int popy = this.width - maxx + minx;
        int popz = (this.height - maxy + miny) * this.width;
        int[] lblPixels = this.dvBasins.getDataBufferInt(0);
        Arrays.fill(this.statPixels, -1);
        switch (dvIn.Type) {
            case 8: {
                byte[] bbinPixels = dvIn.getDataBufferByte(0);
                int z = minz;
                int pos = dvIn.Position(minx, miny, minz);
                while (z < maxz) {
                    int y = miny;
                    while (y < maxy) {
                        int x = minx;
                        while (x < maxx) {
                            if (lblPixels[pos] != 0) {
                                hq.add(new wsp(x, y, z, pos, bbinPixels[pos] & 0xFF, this.Index++));
                                this.statPixels[pos] = 2;
                            } else {
                                this.statPixels[pos] = 0;
                            }
                            ++x;
                            ++pos;
                        }
                        ++y;
                        pos += popy;
                    }
                    ++z;
                    pos += popz;
                }
                bbinPixels = null;
                break;
            }
            case 16: {
                short[] sbinPixels = dvIn.getDataBufferShort(0);
                int z = minz;
                int pos = dvIn.Position(minx, miny, minz);
                while (z < maxz) {
                    int y = miny;
                    while (y < maxy) {
                        int x = minx;
                        while (x < maxx) {
                            if (lblPixels[pos] != 0) {
                                hq.add(new wsp(x, y, z, pos, sbinPixels[pos] & 0xFFFF, this.Index++));
                                this.statPixels[pos] = 2;
                            } else {
                                this.statPixels[pos] = 0;
                            }
                            ++x;
                            ++pos;
                        }
                        ++y;
                        pos += popy;
                    }
                    ++z;
                    pos += popz;
                }
                sbinPixels = null;
                break;
            }
            case 32: {
                int[] ibinPixels = dvIn.getDataBufferInt(0);
                int z = minz;
                int pos = dvIn.Position(minx, miny, minz);
                while (z < maxz) {
                    int y = miny;
                    while (y < maxy) {
                        int x = minx;
                        while (x < maxx) {
                            if (lblPixels[pos] != 0) {
                                hq.add(new wsp(x, y, z, pos, ibinPixels[pos], this.Index++));
                                this.statPixels[pos] = 2;
                            } else {
                                this.statPixels[pos] = 0;
                            }
                            ++x;
                            ++pos;
                        }
                        ++y;
                        pos += popy;
                    }
                    ++z;
                    pos += popz;
                }
                ibinPixels = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("DV type not supported (yet).");
            }
        }
        lblPixels = null;
    }

    private void processWatershedHierarchicalQueue(DV dvIn, PriorityQueue<wsp> hq, StructuringElement3D se, int minx, int miny, int minz, int maxx, int maxy, int maxz) {
        int i2;
        CoordinatesWeighted[] setab = se.getSE();
        boolean it_start = false;
        int it_end = setab.length;
        boolean it_off_start = false;
        wsp token = null;
        if (this.dOffsets == null) {
            this.dOffsets = new ArrayList<Integer>(it_end << 1);
        } else {
            this.dOffsets.clear();
        }
        for (i2 = 0; i2 < it_end; ++i2) {
            CoordinatesWeighted cw = setab[i2];
            this.dOffsets.add(dvIn.Position(cw.X, cw.Y, cw.Z));
            cw = null;
        }
        if (this.tmpOffsets == null) {
            this.tmpOffsets = new ArrayList<Integer>(dvIn.Length);
        } else {
            this.tmpOffsets.clear();
        }
        int[] lblPixels = this.dvBasins.getDataBufferInt(0);
        byte[] bbinPixels = null;
        short[] sbinPixels = null;
        int[] ibinPixels = null;
        switch (dvIn.Type) {
            case 8: {
                bbinPixels = dvIn.getDataBufferByte(0);
                break;
            }
            case 16: {
                sbinPixels = dvIn.getDataBufferShort(0);
                break;
            }
            case 32: {
                ibinPixels = dvIn.getDataBufferInt(0);
                break;
            }
            default: {
                throw new IllegalArgumentException("DV type not supported (yet).");
            }
        }
        while (!hq.isEmpty()) {
            int z;
            int y;
            int x;
            token = hq.poll();
            int curOffset = token.offset;
            int x0 = token.x;
            int y0 = token.y;
            int z0 = token.z;
            this.statPixels[curOffset] = 2;
            int it = 0;
            int it_off = 0;
            while (it < it_end) {
                CoordinatesWeighted itcw = setab[it];
                if (itcw.X != 0 || itcw.Y != 0 || itcw.Z != 0) {
                    x = x0 + itcw.X;
                    y = y0 + itcw.Y;
                    z = z0 + itcw.Z;
                    if (minx <= x && x < maxx && miny <= y && y < maxy && minz <= z && z < maxz) {
                        int nbOffset = curOffset + this.dOffsets.get(it_off);
                        int nbStat = this.statPixels[nbOffset];
                        if (nbStat == 0) {
                            this.tmpOffsets.add(nbOffset);
                        } else if (nbStat == 2) {
                            if (lblPixels[curOffset] == 0) {
                                lblPixels[curOffset] = lblPixels[nbOffset];
                            } else if (lblPixels[curOffset] != lblPixels[nbOffset]) {
                                this.statPixels[curOffset] = 3;
                            }
                        }
                    }
                }
                itcw = null;
                ++it;
                ++it_off;
            }
            if (this.statPixels[curOffset] == 2 && !this.tmpOffsets.isEmpty()) {
                switch (dvIn.Type) {
                    case 8: {
                        int stit;
                        int t_it;
                        for (t_it = 0; t_it != this.tmpOffsets.size(); ++t_it) {
                            stit = this.tmpOffsets.get(t_it);
                            z = stit / dvIn.LayerSize;
                            y = stit % dvIn.LayerSize / this.width;
                            x = stit % this.width;
                            hq.add(new wsp(x, y, z, stit, bbinPixels[stit] & 0xFF, this.Index++));
                            this.statPixels[stit] = 1;
                        }
                        break;
                    }
                    case 16: {
                        int stit;
                        int t_it;
                        for (t_it = 0; t_it != this.tmpOffsets.size(); ++t_it) {
                            stit = this.tmpOffsets.get(t_it);
                            z = stit / dvIn.LayerSize;
                            y = stit % dvIn.LayerSize / this.width;
                            x = stit % this.width;
                            hq.add(new wsp(x, y, z, stit, sbinPixels[stit] & 0xFFFF, this.Index++));
                            this.statPixels[stit] = 1;
                        }
                        break;
                    }
                    case 32: {
                        int stit;
                        int t_it;
                        for (t_it = 0; t_it != this.tmpOffsets.size(); ++t_it) {
                            stit = this.tmpOffsets.get(t_it);
                            z = stit / dvIn.LayerSize;
                            y = stit % dvIn.LayerSize / this.width;
                            x = stit % this.width;
                            hq.add(new wsp(x, y, z, stit, ibinPixels[stit], this.Index++));
                            this.statPixels[stit] = 1;
                        }
                        break;
                    }
                }
            }
            token = null;
            this.tmpOffsets.clear();
        }
        for (i2 = 0; i2 < lblPixels.length; ++i2) {
            if (this.statPixels[i2] != 0) continue;
            this.statPixels[i2] = 3;
        }
        lblPixels = null;
        bbinPixels = null;
        sbinPixels = null;
        lblPixels = null;
    }

    public void watershed(DV dvIn, DV dvMarkers, StructuringElement3D se) {
        this.watershed(dvIn, dvMarkers, se, 0, 0, 0, dvIn.SizeX, dvIn.SizeY, dvIn.SizeZ);
    }

    public void watershed(DV dvIn, DV dvMarkers, StructuringElement3D se, int minx, int miny, int minz, int maxx, int maxy, int maxz) {
        if (se.getOrder() != 1) {
            throw new IllegalArgumentException("Structuring element is not unitary (order = 1).");
        }
        if (se.getType() != -1 && se.getType() != -2) {
            throw new IllegalArgumentException("The structuring element must be of type CUBE (26-neighborhood) or SPHERE (6-neighborhood).");
        }
        if (dvMarkers.Type != 32) {
            throw new IllegalArgumentException("The dvMarkers must of type TYPE_INT_GRAY.");
        }
        this.width = dvIn.SizeX;
        this.height = dvIn.SizeY;
        PriorityQueue<wsp> piorityqueue = new PriorityQueue<wsp>(((maxx - minx) * (maxy - miny) * (maxz - minz) >> 2) * 3);
        if (this.statPixels == null || dvIn.Length != this.statPixels.length) {
            this.statPixels = null;
            this.statPixels = new int[dvIn.Length];
        }
        if (this.dvLines == null || !DvTools.areDimensionsAndTypeEqual((DV)dvIn, (DV)this.dvLines)) {
            this.dvLines = DvNew.Same((DV)dvIn);
        } else {
            DvOperations.Fill((DV)this.dvLines, (int)0);
        }
        if (this.dvBasins == null || !DvTools.areDimensionsAndTypeEqual((DV)dvMarkers, (DV)this.dvBasins)) {
            this.dvBasins = DvNew.Same((DV)dvMarkers);
        }
        DvNew.Copy((DV)dvMarkers, (DV)this.dvBasins);
        this.initWatershedHierarchicalQueue(dvIn, piorityqueue, minx, miny, minz, maxx, maxy, maxz);
        this.processWatershedHierarchicalQueue(dvIn, piorityqueue, se, minx, miny, minz, maxx, maxy, maxz);
        DvComparator.Compare((DV)this.dvBasins, (String)"!=", (int)-1, (DV)this.dvBasins, (int)0, (DV)this.dvBasins);
        piorityqueue.clear();
        piorityqueue = null;
        switch (dvIn.Type) {
            case 8: {
                byte[] bbpixOut = this.dvLines.getDataBufferByte(0);
                int wsVal = 255;
                for (int i2 = 0; i2 < this.statPixels.length; ++i2) {
                    if (this.statPixels[i2] != 3) continue;
                    bbpixOut[i2] = (byte)wsVal;
                }
                bbpixOut = null;
                break;
            }
            case 16: {
                short[] sbpixOut = this.dvLines.getDataBufferShort(0);
                int wsVal = 65535;
                for (int i3 = 0; i3 < this.statPixels.length; ++i3) {
                    if (this.statPixels[i3] != 3) continue;
                    sbpixOut[i3] = (short)wsVal;
                }
                sbpixOut = null;
                break;
            }
            case 32: {
                int[] ibpixOut = this.dvLines.getDataBufferInt(0);
                int wsVal = Integer.MAX_VALUE;
                for (int i4 = 0; i4 < this.statPixels.length; ++i4) {
                    if (this.statPixels[i4] != 3) continue;
                    ibpixOut[i4] = wsVal;
                }
                ibpixOut = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("DV type not supported (yet).");
            }
        }
    }

    public void watershed(DV dvIn, List<CoordinatesWeighted> markers, StructuringElement3D se) {
        this.watershed(dvIn, markers, se, 0, 0, 0, dvIn.SizeX, dvIn.SizeY, dvIn.SizeZ);
    }

    public void watershed(DV dvIn, List<CoordinatesWeighted> markers, StructuringElement3D se, int minx, int miny, int minz, int maxx, int maxy, int maxz) {
        int i2;
        if (se.getOrder() != 1) {
            throw new IllegalArgumentException("The structuring element is not unitary (order = 1).");
        }
        if (se.getType() != -1 && se.getType() != -2) {
            throw new IllegalArgumentException("The structuring element must be of type CUBE (26-connexity) or SPHERE (6-connexity).");
        }
        if (markers.isEmpty()) {
            throw new IllegalArgumentException("Empty list => No marker.");
        }
        this.width = dvIn.SizeX;
        this.height = dvIn.SizeY;
        PriorityQueue<wsp> piorityqueue = new PriorityQueue<wsp>(((maxx - minx) * (maxy - miny) * (maxz - minz) >> 2) * 3);
        if (this.statPixels == null || dvIn.Length != this.statPixels.length) {
            this.statPixels = null;
            this.statPixels = new int[dvIn.Length];
        }
        if (this.dvLines == null || !DvTools.areDimensionsAndTypeEqual((DV)dvIn, (DV)this.dvLines)) {
            this.dvLines = null;
            this.dvLines = DvNew.Same((DV)dvIn);
        }
        DvOperations.Fill((DV)this.dvLines, (int)0);
        if (this.dvBasins == null || !DvTools.areDimensionsEqual((DV)dvIn, (DV)this.dvBasins)) {
            this.dvBasins = null;
            this.dvBasins = new DV(dvIn.SizeX, dvIn.SizeY, dvIn.SizeZ, 1, 32);
        }
        DvOperations.Fill((DV)this.dvBasins, (int)0);
        int[] lblPixels = this.dvBasins.getDataBufferInt(0);
        for (i2 = 0; i2 < markers.size(); ++i2) {
            CoordinatesWeighted c = markers.get(i2);
            lblPixels[c.Z * dvIn.LayerSize + c.Y * this.width + c.X] = c.Wi;
            c = null;
        }
        this.initWatershedHierarchicalQueue(dvIn, piorityqueue, minx, miny, minz, maxx, maxy, maxz);
        this.processWatershedHierarchicalQueue(dvIn, piorityqueue, se, minx, miny, minz, maxx, maxy, maxz);
        DvComparator.Compare((DV)this.dvBasins, (String)"!=", (int)-1, (DV)this.dvBasins, (int)0, (DV)this.dvBasins);
        piorityqueue.clear();
        piorityqueue = null;
        switch (dvIn.Type) {
            case 8: {
                byte[] bbpixOut = this.dvLines.getDataBufferByte(0);
                int wsVal = 255;
                for (i2 = 0; i2 < this.statPixels.length; ++i2) {
                    if (this.statPixels[i2] != 3) continue;
                    bbpixOut[i2] = (byte)wsVal;
                }
                bbpixOut = null;
                break;
            }
            case 16: {
                short[] sbpixOut = this.dvLines.getDataBufferShort(0);
                int wsVal = 65535;
                for (i2 = 0; i2 < this.statPixels.length; ++i2) {
                    if (this.statPixels[i2] != 3) continue;
                    sbpixOut[i2] = (short)wsVal;
                }
                sbpixOut = null;
                break;
            }
            case 32: {
                int[] ibpixOut = this.dvLines.getDataBufferInt(0);
                int wsVal = Integer.MAX_VALUE;
                for (i2 = 0; i2 < this.statPixels.length; ++i2) {
                    if (this.statPixels[i2] != 3) continue;
                    ibpixOut[i2] = wsVal;
                }
                ibpixOut = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("DV type not supported (yet).");
            }
        }
    }

    public BufferedImage Edges() {
        return this.imLines;
    }

    public BufferedImage Basins() {
        return this.imBasins;
    }

    public DV Edges3D() {
        return this.dvLines;
    }

    public DV Basins3D() {
        return this.dvBasins;
    }

    private class wsp
    implements Comparable<wsp> {
        public int x;
        public int y;
        public int z;
        public int value;
        public int offset;
        public int index;

        public wsp(int x, int y, int z, int offset, int value, int index) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.offset = offset;
            this.value = value;
            this.index = index;
        }

        @Override
        public int compareTo(wsp p) {
            if (this.value != p.value) {
                return p.value < this.value ? 1 : -1;
            }
            return p.index < this.index ? 1 : -1;
        }
    }
}

