/*
 * Decompiled with CFR 0.152.
 */
package morphee.segmentation.minmax;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferUShort;
import java.util.Arrays;
import measures.cclh.UnionFindCcl;

public class Maxima {
    private UnionFindCcl ufl = new UnionFindCcl();
    private int[] maxima = null;
    private int[] labels = null;

    public void Kill() {
        this.labels = null;
        this.maxima = null;
        this.ufl.Kill();
    }

    public void Filter(BufferedImage source, int BackGround, boolean EightConnex) {
        int x;
        int height = source.getHeight();
        int width = source.getWidth();
        int height1 = height - 1;
        int width1 = width - 1;
        int size = width * height;
        if (source.getWidth() == 1 || source.getHeight() == 1) {
            throw new IllegalArgumentException("The image must avec at least two columns and two rows.");
        }
        int nbcc = this.ufl.Label(source, BackGround, EightConnex);
        if (this.maxima == null || this.maxima.length != nbcc + 1) {
            this.maxima = null;
            this.maxima = new int[nbcc + 1];
        }
        Arrays.fill(this.maxima, 1);
        if (this.labels == null || this.labels.length != size) {
            this.labels = null;
            this.labels = new int[size];
        }
        System.arraycopy(this.ufl.Labels1D(), 0, this.labels, 0, this.labels.length);
        int pos = 0;
        int px = 1;
        int py = width;
        int pxy = width + 1;
        int pyx = width - 1;
        switch (source.getType()) {
            case 10: {
                int lab;
                int val;
                byte[] bytebufferin = ((DataBufferByte)source.getRaster().getDataBuffer()).getData();
                int y = 0;
                while (y < height1) {
                    x = 0;
                    while (x < width1) {
                        val = bytebufferin[pos] & 0xFF;
                        lab = this.labels[pos];
                        if (val < (bytebufferin[px] & 0xFF)) {
                            this.maxima[lab] = 0;
                        } else if (val > (bytebufferin[px] & 0xFF)) {
                            this.maxima[this.labels[px]] = 0;
                        }
                        if (val < (bytebufferin[py] & 0xFF)) {
                            this.maxima[lab] = 0;
                        } else if (val > (bytebufferin[py] & 0xFF)) {
                            this.maxima[this.labels[py]] = 0;
                        }
                        if (EightConnex) {
                            if (val < (bytebufferin[pxy] & 0xFF)) {
                                this.maxima[lab] = 0;
                            } else if (val > (bytebufferin[pxy] & 0xFF)) {
                                this.maxima[this.labels[pxy]] = 0;
                            }
                            if (0 < x) {
                                if (val < (bytebufferin[pyx] & 0xFF)) {
                                    this.maxima[lab] = 0;
                                } else if (val > (bytebufferin[pyx] & 0xFF)) {
                                    this.maxima[this.labels[pyx]] = 0;
                                }
                            }
                        }
                        ++x;
                        ++pos;
                        ++px;
                        ++py;
                        ++pxy;
                        ++pyx;
                    }
                    ++y;
                    ++pos;
                    ++px;
                    ++py;
                    ++pxy;
                    ++pyx;
                }
                break;
            }
            case 11: {
                int lab;
                int val;
                short[] shortbufferin = ((DataBufferUShort)source.getRaster().getDataBuffer()).getData();
                int y = 0;
                while (y < height1) {
                    x = 0;
                    while (x < width1) {
                        val = shortbufferin[pos] & 0xFFFF;
                        lab = this.labels[pos];
                        if (val < (shortbufferin[px] & 0xFFFF)) {
                            this.maxima[lab] = 0;
                        } else if (val > (shortbufferin[px] & 0xFFFF)) {
                            this.maxima[this.labels[px]] = 0;
                        }
                        if (val < (shortbufferin[py] & 0xFFFF)) {
                            this.maxima[lab] = 0;
                        } else if (val > (shortbufferin[py] & 0xFFFF)) {
                            this.maxima[this.labels[py]] = 0;
                        }
                        if (EightConnex) {
                            if (val < (shortbufferin[pxy] & 0xFFFF)) {
                                this.maxima[lab] = 0;
                            } else if (val > (shortbufferin[pxy] & 0xFFFF)) {
                                this.maxima[this.labels[pxy]] = 0;
                            }
                            if (0 < x) {
                                if (val < (shortbufferin[pyx] & 0xFFFF)) {
                                    this.maxima[lab] = 0;
                                } else if (val > (shortbufferin[pyx] & 0xFFFF)) {
                                    this.maxima[this.labels[pyx]] = 0;
                                }
                            }
                        }
                        ++x;
                        ++pos;
                        ++px;
                        ++py;
                        ++pxy;
                        ++pyx;
                    }
                    ++y;
                    ++pos;
                    ++px;
                    ++py;
                    ++pxy;
                    ++pyx;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported.");
            }
        }
        for (x = 0; x < size; ++x) {
            if (this.maxima[this.labels[x]] != 0) continue;
            this.labels[x] = 0;
        }
        this.ufl.Label(this.labels, width, height, 0, EightConnex);
        System.arraycopy(this.ufl.Labels1D(), 0, this.labels, 0, this.labels.length);
    }

    public void Filter(int[] source, int width, int height, int BackGround, boolean EightConnex) {
        int x;
        int height1 = height - 1;
        int width1 = width - 1;
        int size = width * height;
        if (width <= 1 || height <= 1) {
            throw new IllegalArgumentException("The image must have at least two columns and rows.");
        }
        int nbcc = this.ufl.Label(source, width, height, BackGround, EightConnex);
        if (this.maxima == null || this.maxima.length != nbcc + 1) {
            this.maxima = null;
            this.maxima = new int[nbcc + 1];
        }
        Arrays.fill(this.maxima, 1);
        if (this.labels == null || this.labels.length != size) {
            this.labels = null;
            this.labels = new int[size];
        }
        System.arraycopy(this.ufl.Labels1D(), 0, this.labels, 0, this.labels.length);
        int pos = 0;
        int px = 1;
        int py = width;
        int pxy = width + 1;
        int pyx = width - 1;
        int y = 0;
        while (y < height1) {
            x = 0;
            while (x < width1) {
                int val = source[pos];
                int lab = this.labels[pos];
                if (val < source[px]) {
                    this.maxima[lab] = 0;
                } else if (val > source[px]) {
                    this.maxima[this.labels[px]] = 0;
                }
                if (val < source[py]) {
                    this.maxima[lab] = 0;
                } else if (val > source[py]) {
                    this.maxima[this.labels[py]] = 0;
                }
                if (EightConnex) {
                    if (val < source[pxy]) {
                        this.maxima[lab] = 0;
                    } else if (val > source[pxy]) {
                        this.maxima[this.labels[pxy]] = 0;
                    }
                    if (0 < x) {
                        if (val < source[pyx]) {
                            this.maxima[lab] = 0;
                        } else if (val > source[pyx]) {
                            this.maxima[this.labels[pyx]] = 0;
                        }
                    }
                }
                ++x;
                ++pos;
                ++px;
                ++py;
                ++pxy;
                ++pyx;
            }
            ++y;
            ++pos;
            ++px;
            ++py;
            ++pxy;
            ++pyx;
        }
        for (x = 0; x < size; ++x) {
            if (this.maxima[this.labels[x]] != 0) continue;
            this.labels[x] = 0;
        }
        this.ufl.Label(this.labels, width, height, BackGround, EightConnex);
        System.arraycopy(this.ufl.Labels1D(), 0, this.labels, 0, this.labels.length);
    }

    public void Filter(double[] source, int width, int height, int BackGround, boolean EightConnex) {
        int x;
        int height1 = height - 1;
        int width1 = width - 1;
        int size = width * height;
        if (width <= 1 || height <= 1) {
            throw new IllegalArgumentException("The image/array must have at least two columns and rows.");
        }
        int nbcc = this.ufl.Label(source, width, height, (double)BackGround, EightConnex);
        if (this.maxima == null || this.maxima.length != nbcc + 1) {
            this.maxima = null;
            this.maxima = new int[nbcc + 1];
        }
        Arrays.fill(this.maxima, 1);
        if (this.labels == null || this.labels.length != size) {
            this.labels = null;
            this.labels = new int[size];
        }
        System.arraycopy(this.ufl.Labels1D(), 0, this.labels, 0, this.labels.length);
        int pos = 0;
        int px = 1;
        int py = width;
        int pxy = width + 1;
        int pyx = width - 1;
        int y = 0;
        while (y < height1) {
            x = 0;
            while (x < width1) {
                double val = source[pos];
                int lab = this.labels[pos];
                if (val < source[px]) {
                    this.maxima[lab] = 0;
                } else if (val > source[px]) {
                    this.maxima[this.labels[px]] = 0;
                }
                if (val < source[py]) {
                    this.maxima[lab] = 0;
                } else if (val > source[py]) {
                    this.maxima[this.labels[py]] = 0;
                }
                if (EightConnex) {
                    if (val < source[pxy]) {
                        this.maxima[lab] = 0;
                    } else if (val > source[pxy]) {
                        this.maxima[this.labels[pxy]] = 0;
                    }
                    if (0 < x) {
                        if (val < source[pyx]) {
                            this.maxima[lab] = 0;
                        } else if (val > source[pyx]) {
                            this.maxima[this.labels[pyx]] = 0;
                        }
                    }
                }
                ++x;
                ++pos;
                ++px;
                ++py;
                ++pxy;
                ++pyx;
            }
            ++y;
            ++pos;
            ++px;
            ++py;
            ++pxy;
            ++pyx;
        }
        for (x = 0; x < size; ++x) {
            if (this.maxima[this.labels[x]] != 0) continue;
            this.labels[x] = 0;
        }
        this.ufl.Label(this.labels, width, height, BackGround, EightConnex);
        System.arraycopy(this.ufl.Labels1D(), 0, this.labels, 0, this.labels.length);
    }

    public void Filter(float[] source, int width, int height, int BackGround, boolean EightConnex) {
        int x;
        int height1 = height - 1;
        int width1 = width - 1;
        int size = width * height;
        if (width <= 1 || height <= 1) {
            throw new IllegalArgumentException("The image/array must have at least two columns and rows.");
        }
        int nbcc = this.ufl.Label(source, width, height, (float)BackGround, EightConnex);
        if (this.maxima == null || this.maxima.length != nbcc + 1) {
            this.maxima = null;
            this.maxima = new int[nbcc + 1];
        }
        Arrays.fill(this.maxima, 1);
        if (this.labels == null || this.labels.length != size) {
            this.labels = null;
            this.labels = new int[size];
        }
        System.arraycopy(this.ufl.Labels1D(), 0, this.labels, 0, this.labels.length);
        int pos = 0;
        int px = 1;
        int py = width;
        int pxy = width + 1;
        int pyx = width - 1;
        int y = 0;
        while (y < height1) {
            x = 0;
            while (x < width1) {
                double val = source[pos];
                int lab = this.labels[pos];
                if (val < (double)source[px]) {
                    this.maxima[lab] = 0;
                } else if (val > (double)source[px]) {
                    this.maxima[this.labels[px]] = 0;
                }
                if (val < (double)source[py]) {
                    this.maxima[lab] = 0;
                } else if (val > (double)source[py]) {
                    this.maxima[this.labels[py]] = 0;
                }
                if (EightConnex) {
                    if (val < (double)source[pxy]) {
                        this.maxima[lab] = 0;
                    } else if (val > (double)source[pxy]) {
                        this.maxima[this.labels[pxy]] = 0;
                    }
                    if (0 < x) {
                        if (val < (double)source[pyx]) {
                            this.maxima[lab] = 0;
                        } else if (val > (double)source[pyx]) {
                            this.maxima[this.labels[pyx]] = 0;
                        }
                    }
                }
                ++x;
                ++pos;
                ++px;
                ++py;
                ++pxy;
                ++pyx;
            }
            ++y;
            ++pos;
            ++px;
            ++py;
            ++pxy;
            ++pyx;
        }
        for (x = 0; x < size; ++x) {
            if (this.maxima[this.labels[x]] != 0) continue;
            this.labels[x] = 0;
        }
        this.ufl.Label(this.labels, width, height, BackGround, EightConnex);
        System.arraycopy(this.ufl.Labels1D(), 0, this.labels, 0, this.labels.length);
    }

    public int[] Labels() {
        return this.labels;
    }
}

