/*
 * Decompiled with CFR 0.152.
 */
package morphee.segmentation;

import dv.DV;
import imageTiTi.ImageConverter;
import imageTiTi.ImageNew;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import measures.hedgehop.DistanceMapComputer;
import morphee.MorphoFilter;
import morphee.MorphoFilterMarker;
import morphee.StructuringElement;
import morphee.StructuringElement3D;

public class SkizGeodesic
implements MorphoFilterMarker {
    public DistanceMapComputer dmc = new DistanceMapComputer();
    private BufferedImage markers = null;
    private StructuringElement se = null;

    public BufferedImage Filter(BufferedImage source, StructuringElement se, int nbCPU) {
        this.setStructuringElement(se);
        return this.Filter(source, nbCPU);
    }

    public void Filter(BufferedImage mask, StructuringElement se, BufferedImage result, int nbCPU) {
        this.setStructuringElement(se);
        this.Filter(mask, result, nbCPU);
    }

    public void Filter(BufferedImage markers, BufferedImage mask, StructuringElement se, BufferedImage result) {
        this.setStructuringElement(se);
        this.Marker(markers);
        this.Filter(mask, result, 1);
    }

    public BufferedImage Filter(BufferedImage mask, int nbCPU) {
        BufferedImage result = ImageNew.Same((BufferedImage)mask);
        this.Filter(mask, result, nbCPU);
        return result;
    }

    public void Filter(BufferedImage mask, BufferedImage result, int nbCPU) {
        if (!ImageTools.isGrayLevel((BufferedImage)mask)) {
            throw new IllegalArgumentException("Only gray level images supported.");
        }
        if (!ImageTools.areDimensionsEqual((BufferedImage)mask, (BufferedImage)result)) {
            throw new IllegalArgumentException("Images have different dimensions.");
        }
        if (!ImageTools.areDimensionsEqual((BufferedImage)mask, (BufferedImage)this.markers)) {
            throw new IllegalArgumentException("Images have different dimensions.");
        }
        if (this.markers == null) {
            throw new IllegalStateException("Markers not defined.");
        }
        if (this.se == null) {
            throw new IllegalStateException("Distance/SE not defined, Montanary or Chamfer required.");
        }
        this.dmc.VoronoiGeodesicFromSets(this.markers, mask, this.se);
        ImageConverter.ArrayToImage((int[])this.dmc.getLabels1D(), (BufferedImage)result);
    }

    public StructuringElement getStructuringElement() {
        return this.se;
    }

    public void setStructuringElement(StructuringElement se) {
        this.se = se;
    }

    public DV Filter(DV source, int nbCPU) {
        throw new UnsupportedOperationException("Empty method, not implemented (yet)");
    }

    public void Filter(DV source, DV result, int nbCPU) {
        throw new UnsupportedOperationException("Empty method, not implemented (yet)");
    }

    public DV Filter(DV source, StructuringElement3D se, int nbCPU) {
        throw new UnsupportedOperationException("Empty method, not implemented (yet)");
    }

    public void Filter(DV source, StructuringElement3D se, DV result, int nbCPU) {
        throw new UnsupportedOperationException("Empty method, not implemented (yet)");
    }

    public StructuringElement3D getStructuringElement3D() {
        return null;
    }

    public void setStructuringElement3D(StructuringElement3D se) {
    }

    public float[] MontanariMap() {
        return this.dmc.getMontanariMap1D();
    }

    public int[] ChamferMap() {
        return this.dmc.getChamferMap1D();
    }

    public int[] Labels() {
        return this.dmc.getLabels1D();
    }

    public void Marker(BufferedImage markers) {
        this.markers = markers;
    }

    public BufferedImage Marker() {
        return this.markers;
    }

    public void Parameters(Object ... parameters) {
        if (parameters.length != 1) {
            throw new IllegalArgumentException("Exactly 1 parameter required.");
        }
        this.setStructuringElement((StructuringElement)parameters[0]);
    }

    public List<Object> Parameters() {
        ArrayList<Object> list = new ArrayList<Object>(1);
        list.add(this.se);
        return list;
    }

    public int BorderEffectSizeX() {
        if (this.se == null) {
            throw new IllegalStateException("SE not defined.");
        }
        return this.se.getSizeX() >> 1;
    }

    public int BorderEffectSizeY() {
        if (this.se == null) {
            throw new IllegalStateException("SE not defined.");
        }
        return this.se.getSizeY() >> 1;
    }

    public int BorderEffectSizeZ() {
        if (this.se == null) {
            throw new IllegalStateException("SE not defined.");
        }
        return 0;
    }

    public MorphoFilter Clone() {
        SkizGeodesic sg = new SkizGeodesic();
        sg.Parameters(this.Parameters());
        return sg;
    }

    public void Marker(DV Marker2) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public DV Marker3D() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

