/*
 * Decompiled with CFR 0.152.
 */
package morphee.segmentation;

import dv.DV;
import imageTiTi.ImageConverter;
import imageTiTi.ImageNew;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import java.util.List;
import measures.cclh.ConnectedComponentLabeling;
import measures.cclh.UnionFindCcl;
import measures.hedgehop.DistanceMapComputer;
import morphee.MorphoFilter;
import morphee.StructuringElement;
import morphee.StructuringElement3D;

public class Skiz
implements MorphoFilter {
    private final ConnectedComponentLabeling ccl = new UnionFindCcl();
    private StructuringElement se = null;
    public DistanceMapComputer dmc = new DistanceMapComputer();
    private int BackGround = 0;
    private int width = -1;
    private int height = -1;

    public BufferedImage Filter(BufferedImage source, StructuringElement se, int BackGround, int nbCPU) {
        this.setStructuringElement(se);
        this.BackGround(BackGround);
        return this.Filter(source, nbCPU);
    }

    public BufferedImage Filter(BufferedImage source, StructuringElement se, int nbCPU) {
        this.setStructuringElement(se);
        return this.Filter(source, nbCPU);
    }

    public void Filter(BufferedImage source, StructuringElement se, BufferedImage result, int nbCPU) {
        this.setStructuringElement(se);
        this.Filter(source, result, nbCPU);
    }

    public BufferedImage Filter(BufferedImage source, int nbCPU) {
        BufferedImage result = ImageNew.Same((BufferedImage)source);
        this.Filter(source, result, nbCPU);
        return result;
    }

    public void Filter(BufferedImage source, BufferedImage result, int nbCPU) {
        if (ImageTools.isColored((BufferedImage)source)) {
            throw new IllegalArgumentException("Only gray level or binary images supported.");
        }
        if (this.se == null) {
            throw new IllegalArgumentException("SE/Distance not defined: Montanary or Chamfer required.");
        }
        this.width = source.getWidth();
        this.height = source.getHeight();
        this.ccl.ImportLabels(source);
        this.dmc.VoronoiFromSets(this.ccl.Labels1D(), this.width, this.height, this.se);
        ImageConverter.ArrayToImage((int[])this.dmc.getLabels1D(), (BufferedImage)result);
    }

    public BufferedImage Filter(BufferedImage source, StructuringElement se, boolean labelfirst, float[] constraints, int nbCPU) {
        BufferedImage result = ImageNew.Same((BufferedImage)source);
        this.Filter(source, se, labelfirst, constraints, result, nbCPU);
        return result;
    }

    public void Filter(BufferedImage source, StructuringElement se, boolean labelfirst, float[] constraints, BufferedImage result, int nbCPU) {
        if (ImageTools.isColored((BufferedImage)source)) {
            throw new IllegalArgumentException("Only gray level or binary images supported.");
        }
        if (se == null) {
            throw new IllegalArgumentException("SE/Distance not defined: Montanary required.");
        }
        this.width = source.getWidth();
        this.height = source.getHeight();
        int[] labels = null;
        if (labelfirst) {
            this.ccl.Label(source, this.BackGround, true);
            labels = this.ccl.Labels1D();
        } else {
            switch (source.getRaster().getDataBuffer().getDataType()) {
                case 3: {
                    labels = ((DataBufferInt)source.getRaster().getDataBuffer()).getData();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("If labelfirst is false, then the image must have a DataBufferInt encoding.");
                }
            }
        }
        this.dmc.VoronoiFromSets(labels, this.width, this.height, se, constraints);
        ImageConverter.ArrayToImage((int[])this.dmc.getLabels1D(), (BufferedImage)result);
    }

    public BufferedImage Filter(BufferedImage source, StructuringElement se, int[] constraints, int nbCPU) {
        BufferedImage result = ImageNew.Same((BufferedImage)source);
        this.Filter(source, se, constraints, result, nbCPU);
        return result;
    }

    public void Filter(BufferedImage source, StructuringElement se, int[] constraints, BufferedImage result, int nbCPU) {
        if (ImageTools.isColored((BufferedImage)source)) {
            throw new IllegalArgumentException("Only gray level or binary images supported.");
        }
        if (se == null) {
            throw new IllegalArgumentException("SE/Distance not defined: Chamfer required.");
        }
        this.width = source.getWidth();
        this.height = source.getHeight();
        this.ccl.Label(source, this.BackGround, true);
        this.dmc.VoronoiFromSets(this.ccl.Labels1D(), this.width, this.height, se, constraints);
        ImageConverter.ArrayToImage((int[])this.dmc.getLabels1D(), (BufferedImage)result);
    }

    public StructuringElement getStructuringElement() {
        return this.se;
    }

    public void setStructuringElement(StructuringElement se) {
        this.se = se;
    }

    public BufferedImage ExtractBorders() {
        int[] Labels = this.dmc.getLabels1D();
        BufferedImage Border2 = new BufferedImage(this.width, this.height, 12);
        WritableRaster wr = Border2.getRaster();
        int pos = 0;
        for (int y = 0; y < this.height; ++y) {
            int x = 0;
            while (x < this.width) {
                if (x - 1 >= 0 && Labels[pos - 1] < Labels[pos]) {
                    wr.setSample(x, y, 0, 1);
                } else if (x + 1 < this.width && Labels[pos + 1] < Labels[pos]) {
                    wr.setSample(x, y, 0, 1);
                } else if (y - 1 >= 0 && Labels[pos - this.width] < Labels[pos]) {
                    wr.setSample(x, y, 0, 1);
                } else if (y + 1 < this.height && Labels[pos + this.width] < Labels[pos]) {
                    wr.setSample(x, y, 0, 1);
                }
                ++x;
                ++pos;
            }
        }
        Labels = null;
        wr = null;
        return Border2;
    }

    public DV Filter(DV source, int nbCPU) {
        throw new UnsupportedOperationException("Empty method, not implemented (yet)");
    }

    public void Filter(DV source, DV result, int nbCPU) {
        throw new UnsupportedOperationException("Empty method, not implemented (yet)");
    }

    public DV Filter(DV source, StructuringElement3D se, int nbCPU) {
        throw new UnsupportedOperationException("Empty method, not implemented (yet)");
    }

    public void Filter(DV source, StructuringElement3D se, DV result, int nbCPU) {
        throw new UnsupportedOperationException("Empty method, not implemented (yet)");
    }

    public StructuringElement3D getStructuringElement3D() {
        throw new UnsupportedOperationException("Empty method, not implemented (yet)");
    }

    public void setStructuringElement3D(StructuringElement3D se) {
        throw new UnsupportedOperationException("Empty method, not implemented (yet)");
    }

    public float[] Map() {
        return this.dmc.getMontanariMap1D();
    }

    public int[] Carte() {
        return this.dmc.getChamferMap1D();
    }

    public int[] InputLabels() {
        return this.ccl.Labels1D();
    }

    public int[] OutputLabels() {
        return this.dmc.getLabels1D();
    }

    public int BackGround() {
        return this.BackGround;
    }

    public void BackGround(int BackGround) {
        this.BackGround = BackGround;
    }

    public void Parameters(Object ... parameters) {
        if (parameters.length != 2) {
            throw new IllegalArgumentException("Exactly 2 parameters required.");
        }
        this.setStructuringElement((StructuringElement)parameters[0]);
        this.BackGround((Integer)parameters[1]);
    }

    public List<Object> Parameters() {
        ArrayList<Object> list = new ArrayList<Object>(2);
        list.add(this.se);
        list.add(this.BackGround);
        return list;
    }

    public int BorderEffectSizeX() {
        return 0;
    }

    public int BorderEffectSizeY() {
        return 0;
    }

    public int BorderEffectSizeZ() {
        return 0;
    }

    public MorphoFilter Clone() {
        throw new UnsupportedOperationException("Not supported (yet).");
    }
}

