/*
 * Decompiled with CFR 0.152.
 */
package morphee.residues;

import dv.DV;
import imageTiTi.ImageNew;
import imageTiTi.ImageOperations;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.util.ArrayList;
import java.util.List;
import morphee.MorphoFilter;
import morphee.Open;
import morphee.StructuringElement;
import morphee.StructuringElement3D;

public class UltimateOpening
implements MorphoFilter {
    private int Type = -1;
    private int Orientation = -1;
    private int Iterations = 0;
    private Open open = new Open();
    private BufferedImage imprevious = null;
    private BufferedImage imdiff;
    private BufferedImage Indicators;
    private BufferedImage Residues;
    private BufferedImage Values;

    public BufferedImage Filter(BufferedImage source, int nbCPU) {
        BufferedImage result = ImageNew.Same((BufferedImage)source);
        this.Filter(source, result, nbCPU);
        return result;
    }

    public BufferedImage Filter(BufferedImage source, StructuringElement se, int nbCPU) {
        this.Parameters(se);
        return this.Filter(source, nbCPU);
    }

    public void Filter(BufferedImage source, StructuringElement se, BufferedImage result, int nbCPU) {
        this.Parameters(se);
        this.Filter(source, result, nbCPU);
    }

    public void Filter(BufferedImage source, BufferedImage result, int nbCPU) {
        if (this.Iterations <= 0) {
            throw new IllegalArgumentException("Set parameters first.");
        }
        if (this.imprevious == null || !ImageTools.areDimensionsAndTypeEqual((BufferedImage)source, (BufferedImage)this.imprevious)) {
            this.imprevious = ImageNew.Same((BufferedImage)source);
            this.imdiff = ImageNew.Same((BufferedImage)source);
            this.Indicators = ImageNew.Integer((int)source.getWidth(), (int)source.getHeight(), (int)1);
            this.Residues = ImageNew.Same((BufferedImage)source);
            this.Values = ImageNew.Same((BufferedImage)source);
        }
        StructuringElement se = null;
        ImageNew.Copy((BufferedImage)source, (BufferedImage)this.imprevious);
        ImageOperations.Fill((BufferedImage)this.Residues, (int)0);
        ImageOperations.Fill((BufferedImage)this.Indicators, (int)0);
        ImageOperations.Fill((BufferedImage)this.Values, (int)0);
        int[] indic = ((DataBufferInt)this.Indicators.getRaster().getDataBuffer()).getData();
        for (int size = 1; size <= this.Iterations; ++size) {
            se = new StructuringElement(new Object[]{size, this.Type, this.Orientation});
            this.open.setStructuringElement(se);
            this.open.Filter(source, result, nbCPU);
            ImageOperations.Differences((BufferedImage)this.imprevious, (BufferedImage)result, (BufferedImage)this.imdiff);
            switch (this.imdiff.getType()) {
                case 10: {
                    byte[] byteresid = ((DataBufferByte)this.Residues.getRaster().getDataBuffer()).getData();
                    byte[] bytediff = ((DataBufferByte)this.imdiff.getRaster().getDataBuffer()).getData();
                    byte[] bytevalues = ((DataBufferByte)this.Values.getRaster().getDataBuffer()).getData();
                    byte[] byteresult = ((DataBufferByte)result.getRaster().getDataBuffer()).getData();
                    for (int x = 0; x < indic.length; ++x) {
                        if ((byteresid[x] & 0xFF) >= (bytediff[x] & 0xFF)) continue;
                        byteresid[x] = bytediff[x];
                        indic[x] = size;
                        bytevalues[x] = byteresult[x];
                    }
                    byteresult = null;
                    bytevalues = null;
                    bytediff = null;
                    byteresid = null;
                    break;
                }
                case 11: {
                    short[] shortresid = ((DataBufferUShort)this.Residues.getRaster().getDataBuffer()).getData();
                    short[] shortdiff = ((DataBufferUShort)this.imdiff.getRaster().getDataBuffer()).getData();
                    short[] shortvalues = ((DataBufferUShort)this.Values.getRaster().getDataBuffer()).getData();
                    short[] shortresult = ((DataBufferUShort)result.getRaster().getDataBuffer()).getData();
                    for (int x = 0; x < indic.length; ++x) {
                        if ((shortresid[x] & 0xFFFF) >= (shortdiff[x] & 0xFFFF)) continue;
                        shortresid[x] = shortdiff[x];
                        indic[x] = size;
                        shortvalues[x] = shortresult[x];
                    }
                    shortresult = null;
                    shortvalues = null;
                    shortdiff = null;
                    shortresid = null;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Image type not supported.");
                }
            }
            ImageNew.Copy((BufferedImage)result, (BufferedImage)this.imprevious);
            se = null;
        }
        ImageNew.Copy((BufferedImage)this.Residues, (BufferedImage)result);
    }

    public DV Filter(DV source, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public void Filter(DV source, DV result, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public DV Filter(DV source, StructuringElement3D se, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public void Filter(DV source, StructuringElement3D se, DV result, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public StructuringElement3D getStructuringElement3D() {
        return null;
    }

    public void setStructuringElement3D(StructuringElement3D se) {
    }

    public BufferedImage Indicators() {
        return this.Indicators;
    }

    public BufferedImage Residues() {
        return this.Residues;
    }

    public BufferedImage Values() {
        return this.Values;
    }

    public void Parameters(Object ... parameters) {
        if (parameters.length != 1) {
            throw new IllegalArgumentException("Exactly 1 parameter required.");
        }
        StructuringElement se = (StructuringElement)parameters[0];
        this.Iterations = se.getOrder();
        this.Orientation = se.getOrientation();
        this.Type = se.getType();
        se = null;
    }

    public List<Object> Parameters() {
        ArrayList<Object> params = new ArrayList<Object>(1);
        switch (this.Type) {
            case -11: {
                params.add(new StructuringElement(new Object[]{this.Iterations, this.Type, this.Orientation}));
                break;
            }
            default: {
                params.add(new StructuringElement(new Object[]{this.Iterations, this.Type}));
            }
        }
        return params;
    }

    public StructuringElement getStructuringElement() {
        return new StructuringElement(new Object[]{this.Iterations, this.Type, this.Orientation});
    }

    public void setStructuringElement(StructuringElement ES) {
        this.Parameters(ES);
    }

    public int BorderEffectSizeX() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public int BorderEffectSizeY() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public int BorderEffectSizeZ() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public MorphoFilter Clone() {
        throw new UnsupportedOperationException("Not supported (yet).");
    }
}

