/*
 * Decompiled with CFR 0.152.
 */
package morphee.residues;

import arrayTiTi.ArrayComparator;
import dv.DV;
import imageTiTi.ImageConverter;
import imageTiTi.ImageNew;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import measures.hedgehop.DistanceMapComputer;
import morphee.MorphoFilter;
import morphee.StructuringElement;
import morphee.StructuringElement3D;
import morphee.segmentation.minmax.Maxima;
import processing.filters.SignalFilter;

public class UltimateErode
implements MorphoFilter {
    private StructuringElement se = null;
    private StructuringElement3D se3 = null;
    private DistanceMapComputer dmc = new DistanceMapComputer();
    private Maxima maxima = new Maxima();

    public void Kill() {
        this.dmc.Kill();
        this.maxima.Kill();
    }

    public BufferedImage Filter(BufferedImage source, StructuringElement se, int nbCPU) {
        this.setStructuringElement(se);
        return this.Filter(source, nbCPU);
    }

    public void Filter(BufferedImage source, StructuringElement se, BufferedImage result, int nbCPU) {
        this.setStructuringElement(se);
        this.Filter(source, result, nbCPU);
    }

    public BufferedImage Filter(BufferedImage source, int nbCPU) {
        BufferedImage result = ImageNew.Same((BufferedImage)source);
        this.Filter(source, result, nbCPU);
        return result;
    }

    public void Filter(BufferedImage source, BufferedImage result, int nbCPU) {
        int max;
        if (!ImageTools.areDimensionsAndTypeEqual((BufferedImage)source, (BufferedImage)result)) {
            throw new IllegalArgumentException("Images source and result must have identic dimensions and types.");
        }
        if (this.se == null) {
            throw new IllegalArgumentException("Any distance defined.");
        }
        switch (source.getType()) {
            case 12: {
                max = 1;
                break;
            }
            case 10: {
                max = 255;
                break;
            }
            case 11: {
                max = 65535;
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported.");
            }
        }
        this.dmc.Compute(source, this.se);
        if (this.se.getType() == -14) {
            this.maxima.Filter(this.dmc.getChamferMap1D(), source.getWidth(), source.getHeight(), 0, true);
        } else {
            this.maxima.Filter(this.dmc.getMontanariMap1D(), source.getWidth(), source.getHeight(), 0, true);
        }
        ArrayComparator.Compare((int[])this.maxima.Labels(), (String)"==", (int)0, (int)0, (int)max, (int[])this.maxima.Labels());
        ImageConverter.ArrayToImage((int[])this.maxima.Labels(), (BufferedImage)result);
    }

    public StructuringElement getStructuringElement() {
        return this.se;
    }

    public void setStructuringElement(StructuringElement se) {
        this.se = se;
    }

    public DV Filter(DV source, StructuringElement3D se, int nbCPU) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void Filter(DV source, StructuringElement3D se, DV result, int nbCPU) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public StructuringElement3D getStructuringElement3D() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setStructuringElement3D(StructuringElement3D se) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public DV Filter(DV source, int nbCPU) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void Filter(DV source, DV result, int nbCPU) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void Parameters(Object ... parameters) {
        if (parameters.length != 1) {
            throw new IllegalArgumentException("Exactly 1 parameter required.");
        }
        this.se = (StructuringElement)parameters[0];
    }

    public List<Object> Parameters() {
        ArrayList<Object> params = new ArrayList<Object>(1);
        params.add(this.se);
        return params;
    }

    public int BorderEffectSizeX() {
        return 0;
    }

    public int BorderEffectSizeY() {
        return 0;
    }

    public int BorderEffectSizeZ() {
        return 0;
    }

    public SignalFilter Clone() {
        UltimateErode ue = new UltimateErode();
        if (this.se != null) {
            ue.setStructuringElement(this.se);
        }
        return ue;
    }
}

