/*
 * Decompiled with CFR 0.152.
 */
package morphee.rank.fastRank;

import dv.DV;
import imageTiTi.ImageNew;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferUShort;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import morphee.MorphoFilter;
import morphee.StructuringElement;
import morphee.StructuringElement3D;

public class RankSegmentVertical
implements MorphoFilter {
    private RankSegmentVerticalThread[] threads = null;
    private int nbFreeThreads = 0;
    private int sewidth = 0;
    private int rank;

    public void Kill() {
        if (this.threads != null) {
            for (int i2 = 0; i2 < this.threads.length; ++i2) {
                this.threads[i2].Kill();
            }
            Arrays.fill(this.threads, null);
            this.threads = null;
        }
    }

    public BufferedImage Filter(BufferedImage source, StructuringElement se, int nbCPU) {
        this.setStructuringElement(se);
        return this.Filter(source, nbCPU);
    }

    public void Filter(BufferedImage source, StructuringElement se, BufferedImage result, int nbCPU) {
        this.setStructuringElement(se);
        this.Filter(source, result, nbCPU);
    }

    public BufferedImage Filter(BufferedImage source, int nbCPU) {
        BufferedImage result = ImageNew.Same((BufferedImage)source);
        this.Filter(source, result, nbCPU);
        return result;
    }

    public void Filter(BufferedImage source, BufferedImage result, int nbCPU) {
        if (this.sewidth == 0) {
            throw new IllegalArgumentException("Structuring element's width not defined or less/equals than 0.");
        }
        this.Filter(source, this.sewidth, this.rank, result, nbCPU);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Filter(BufferedImage source, int sewidth, int rank, BufferedImage result, int nbCPU) {
        Object object;
        int i2;
        if (!ImageTools.areDimensionsAndTypeEqual((BufferedImage)source, (BufferedImage)result)) {
            throw new IllegalArgumentException("Image source and result have different dimensions.");
        }
        this.Parameters(sewidth, rank);
        if (this.threads == null || this.threads.length != nbCPU) {
            this.nbFreeThreads = 0;
            this.threads = null;
            this.threads = new RankSegmentVerticalThread[nbCPU];
            for (i2 = 0; i2 < nbCPU; ++i2) {
                this.threads[i2] = new RankSegmentVerticalThread();
                this.threads[i2].start();
            }
            RankSegmentVertical rankSegmentVertical = this;
            synchronized (rankSegmentVertical) {
                while (this.nbFreeThreads != nbCPU) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        this.nbFreeThreads = 0;
        int step = source.getWidth() / nbCPU;
        for (i2 = 0; i2 < nbCPU - 1; ++i2) {
            this.threads[i2].setConditions(source, result, sewidth, rank, i2 * step, (i2 + 1) * step);
            object = this.threads[i2].lock;
            synchronized (object) {
                this.threads[i2].lock.notify();
                continue;
            }
        }
        this.threads[i2].setConditions(source, result, sewidth, rank, i2 * step, source.getWidth());
        object = this.threads[i2].lock;
        synchronized (object) {
            this.threads[i2].lock.notify();
        }
        object = this;
        synchronized (object) {
            while (this.nbFreeThreads != nbCPU) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public DV Filter(DV source, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public void Filter(DV source, DV result, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public DV Filter(DV source, StructuringElement3D se, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public void Filter(DV source, StructuringElement3D se, DV result, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public StructuringElement3D getStructuringElement3D() {
        return null;
    }

    public void setStructuringElement3D(StructuringElement3D se) {
    }

    protected synchronized void addFreeThread() {
        ++this.nbFreeThreads;
        this.notify();
    }

    public StructuringElement getStructuringElement() {
        return new StructuringElement(new Object[]{this.sewidth / 2, -6});
    }

    public void setStructuringElement(StructuringElement ES) {
        this.sewidth = ES.getSize();
    }

    public void Parameters(Object ... parameters) {
        if (parameters.length != 2) {
            throw new IllegalArgumentException("Exactly 2 parameter required.");
        }
        this.sewidth = (Integer)parameters[0];
        this.rank = (Integer)parameters[1];
    }

    public List<Object> Parameters() {
        ArrayList<Object> params = new ArrayList<Object>(2);
        params.add(this.sewidth);
        params.add(this.rank);
        return params;
    }

    public int BorderEffectSizeX() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public int BorderEffectSizeY() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public int BorderEffectSizeZ() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public MorphoFilter Clone() {
        throw new UnsupportedOperationException("Not supported (yet).");
    }

    private class RankSegmentVerticalThread
    extends Thread {
        private WritableRaster wr = null;
        private WritableRaster wrres = null;
        private int channel = 0;
        private int sewidth = 0;
        private double rank = 0.0;
        private int minx;
        private int maxx;
        private int type;
        private int width;
        private int height;
        private short[] shortbufferin = null;
        private short[] shortbufferout = null;
        private byte[] bytebufferin = null;
        private byte[] bytebufferout = null;
        private int[] Hist = null;
        public Object lock = new Object();
        private int flag = -1;
        private int level;
        private int mini;
        private int maxi;
        private boolean Kill = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void Kill() {
            this.wrres = null;
            this.wr = null;
            this.shortbufferin = null;
            this.shortbufferout = null;
            this.bytebufferin = null;
            this.bytebufferout = null;
            this.Hist = null;
            this.Kill = true;
            Object object = this.lock;
            synchronized (object) {
                this.lock.notify();
            }
        }

        public void setConditions(BufferedImage Original, BufferedImage Result, int sewidth, int rank, int minx, int maxx) {
            this.sewidth = sewidth >> 1;
            this.rank = (double)rank / 100.0;
            this.minx = minx;
            this.maxx = maxx;
            this.type = Original.getType();
            this.width = Original.getWidth();
            this.height = Original.getHeight();
            this.bytebufferout = null;
            this.bytebufferin = null;
            this.shortbufferout = null;
            this.shortbufferin = null;
            this.wrres = null;
            this.wr = null;
            switch (Original.getType()) {
                case 12: {
                    this.wr = Original.getRaster();
                    this.wrres = Result.getRaster();
                    if (this.Hist != null && this.Hist.length == 2) break;
                    this.Hist = new int[2];
                    break;
                }
                case 5: 
                case 6: 
                case 10: {
                    this.bytebufferin = ((DataBufferByte)Original.getRaster().getDataBuffer()).getData();
                    this.bytebufferout = ((DataBufferByte)Result.getRaster().getDataBuffer()).getData();
                    this.channel = Original.getRaster().getNumBands();
                    if (this.Hist != null && this.Hist.length == 256) break;
                    this.Hist = new int[256];
                    break;
                }
                case 11: {
                    this.shortbufferin = ((DataBufferUShort)Original.getRaster().getDataBuffer()).getData();
                    this.shortbufferout = ((DataBufferUShort)Result.getRaster().getDataBuffer()).getData();
                    if (this.Hist != null && this.Hist.length == 65535) break;
                    this.Hist = new int[65535];
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported image type.");
                }
            }
            Arrays.fill(this.Hist, 0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            block11: while (true) lbl-1000:
            // 5 sources

            {
                var12_12 = this.lock;
                synchronized (var12_12) {
                    try {
                        RankSegmentVertical.this.addFreeThread();
                        this.lock.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                if (this.Kill) {
                    return;
                }
                sewidthwidth = this.sewidth * this.width;
                switch (this.type) {
                    case 12: {
                        x = this.minx;
                        while (true) {
                            if (x >= this.maxx) ** GOTO lbl-1000
                            this.maxi = 0;
                            this.mini = 1;
                            end = this.sewidth;
                            for (y = 0; y < this.sewidth; ++y) {
                                v0 = auxnext = this.wr.getSample(x, y, 0);
                                this.Hist[v0] = this.Hist[v0] + 1;
                                if (this.maxi < auxnext) {
                                    this.maxi = auxnext;
                                }
                                if (auxnext >= this.mini) continue;
                                this.mini = auxnext;
                            }
                            size = this.sewidth;
                            for (y = 0; y < this.sewidth; ++y) {
                                v1 = auxnext = this.wr.getSample(x, y + this.sewidth, 0);
                                this.Hist[v1] = this.Hist[v1] + 1;
                                if (this.maxi < auxnext) {
                                    this.maxi = auxnext;
                                }
                                if (auxnext < this.mini) {
                                    this.mini = auxnext;
                                }
                                posrank = (int)(this.rank * (double)(++size));
                                this.FindFlagLevel(posrank, size);
                                this.wrres.setSample(x, y, 0, this.flag);
                            }
                            posrank = (int)(this.rank * (double)(2 * this.sewidth) + 0.5);
                            size = 2 * this.sewidth + 1;
                            start = this.sewidth;
                            end = this.height - this.sewidth;
                            for (y = start; y < end; ++y) {
                                v2 = auxnext = this.wr.getSample(x, y + this.sewidth, 0);
                                this.Hist[v2] = this.Hist[v2] + 1;
                                if (this.maxi < auxnext) {
                                    this.maxi = auxnext;
                                }
                                if (auxnext < this.mini) {
                                    this.mini = auxnext;
                                }
                                this.FindFlagLevel(posrank, size);
                                this.wrres.setSample(x, y, 0, this.flag);
                                v3 = this.wr.getSample(x, y - this.sewidth, 0);
                                this.Hist[v3] = this.Hist[v3] - 1;
                                while (this.Hist[this.maxi] == 0) {
                                    --this.maxi;
                                }
                                while (this.Hist[this.mini] == 0) {
                                    ++this.mini;
                                }
                            }
                            size = 2 * this.sewidth;
                            start = end;
                            end = this.height;
                            for (y = start; y < end; ++y) {
                                posrank = (int)(this.rank * (double)size);
                                this.FindFlagLevel(posrank, size--);
                                this.wrres.setSample(x, y, 0, this.flag);
                                v4 = this.wr.getSample(x, y - this.sewidth, 0);
                                this.Hist[v4] = this.Hist[v4] - 1;
                                while (this.Hist[this.maxi] == 0) {
                                    --this.maxi;
                                }
                                while (this.Hist[this.mini] == 0) {
                                    ++this.mini;
                                }
                            }
                            for (y = start; y < end; ++y) {
                                v5 = this.wr.getSample(x, y, 0);
                                this.Hist[v5] = this.Hist[v5] - 1;
                            }
                            ++x;
                        }
                    }
                    case 10: {
                        x = this.minx;
                        while (true) {
                            if (x >= this.maxx) ** GOTO lbl-1000
                            this.maxi = 0;
                            this.mini = 255;
                            end = x + sewidthwidth;
                            for (y = x; y < end; y += this.width) {
                                v6 = auxnext = this.bytebufferin[y] & 255;
                                this.Hist[v6] = this.Hist[v6] + 1;
                                if (this.maxi < auxnext) {
                                    this.maxi = auxnext;
                                }
                                if (auxnext >= this.mini) continue;
                                this.mini = auxnext;
                            }
                            size = this.sewidth;
                            for (y = x; y < end; y += this.width) {
                                v7 = auxnext = this.bytebufferin[y + sewidthwidth] & 255;
                                this.Hist[v7] = this.Hist[v7] + 1;
                                if (this.maxi < auxnext) {
                                    this.maxi = auxnext;
                                }
                                if (auxnext < this.mini) {
                                    this.mini = auxnext;
                                }
                                posrank = (int)(this.rank * (double)(++size));
                                this.FindFlagLevel(posrank, size);
                                this.bytebufferout[y] = (byte)this.flag;
                            }
                            posrank = (int)(this.rank * (double)(2 * this.sewidth) + 0.5);
                            size = 2 * this.sewidth + 1;
                            start = x + sewidthwidth;
                            end = x + (this.height - this.sewidth) * this.width;
                            for (y = start; y < end; y += this.width) {
                                v8 = auxnext = this.bytebufferin[y + sewidthwidth] & 255;
                                this.Hist[v8] = this.Hist[v8] + 1;
                                if (this.maxi < auxnext) {
                                    this.maxi = auxnext;
                                }
                                if (auxnext < this.mini) {
                                    this.mini = auxnext;
                                }
                                this.FindFlagLevel(posrank, size);
                                this.bytebufferout[y] = (byte)this.flag;
                                v9 = this.bytebufferin[y - sewidthwidth] & 255;
                                this.Hist[v9] = this.Hist[v9] - 1;
                                while (this.Hist[this.maxi] == 0) {
                                    --this.maxi;
                                }
                                while (this.Hist[this.mini] == 0) {
                                    ++this.mini;
                                }
                            }
                            size = 2 * this.sewidth;
                            start = end;
                            end = x + this.height * this.width;
                            for (y = start; y < end; y += this.width) {
                                posrank = (int)(this.rank * (double)size);
                                this.FindFlagLevel(posrank, size--);
                                this.bytebufferout[y] = (byte)this.flag;
                                v10 = this.bytebufferin[y - sewidthwidth] & 255;
                                this.Hist[v10] = this.Hist[v10] - 1;
                                while (this.Hist[this.maxi] == 0) {
                                    --this.maxi;
                                }
                                while (this.Hist[this.mini] == 0) {
                                    ++this.mini;
                                }
                            }
                            for (y = start; y < end; y += this.width) {
                                v11 = this.bytebufferin[y] & 255;
                                this.Hist[v11] = this.Hist[v11] - 1;
                            }
                            ++x;
                        }
                    }
                    case 11: {
                        x = this.minx;
                        while (true) {
                            if (x >= this.maxx) ** GOTO lbl-1000
                            this.maxi = 0;
                            this.mini = 65535;
                            end = x + sewidthwidth;
                            for (y = x; y < end; y += this.width) {
                                v12 = auxnext = this.shortbufferin[y] & 65535;
                                this.Hist[v12] = this.Hist[v12] + 1;
                                if (this.maxi < auxnext) {
                                    this.maxi = auxnext;
                                }
                                if (auxnext >= this.mini) continue;
                                this.mini = auxnext;
                            }
                            size = this.sewidth;
                            for (y = x; y < end; y += this.width) {
                                v13 = auxnext = this.shortbufferin[y + sewidthwidth] & 65535;
                                this.Hist[v13] = this.Hist[v13] + 1;
                                if (this.maxi < auxnext) {
                                    this.maxi = auxnext;
                                }
                                if (auxnext < this.mini) {
                                    this.mini = auxnext;
                                }
                                posrank = (int)(this.rank * (double)(++size));
                                this.FindFlagLevel(posrank, size);
                                this.shortbufferout[y] = (short)this.flag;
                            }
                            posrank = (int)(this.rank * (double)(2 * this.sewidth) + 0.5);
                            size = 2 * this.sewidth + 1;
                            start = x + sewidthwidth;
                            end = x + (this.height - this.sewidth) * this.width;
                            for (y = start; y < end; y += this.width) {
                                v14 = auxnext = this.shortbufferin[y + sewidthwidth] & 65535;
                                this.Hist[v14] = this.Hist[v14] + 1;
                                if (this.maxi < auxnext) {
                                    this.maxi = auxnext;
                                }
                                if (auxnext < this.mini) {
                                    this.mini = auxnext;
                                }
                                this.FindFlagLevel(posrank, size);
                                this.shortbufferout[y] = (short)this.flag;
                                v15 = this.shortbufferin[y - sewidthwidth] & 65535;
                                this.Hist[v15] = this.Hist[v15] - 1;
                                while (this.Hist[this.maxi] == 0) {
                                    --this.maxi;
                                }
                                while (this.Hist[this.mini] == 0) {
                                    ++this.mini;
                                }
                            }
                            size = 2 * this.sewidth;
                            start = end;
                            end = x + this.height * this.width;
                            for (y = start; y < end; y += this.width) {
                                posrank = (int)(this.rank * (double)size);
                                this.FindFlagLevel(posrank, size--);
                                this.shortbufferout[y] = (short)this.flag;
                                v16 = this.shortbufferin[y - sewidthwidth] & 65535;
                                this.Hist[v16] = this.Hist[v16] - 1;
                                while (this.Hist[this.maxi] == 0) {
                                    --this.maxi;
                                }
                                while (this.Hist[this.mini] == 0) {
                                    ++this.mini;
                                }
                            }
                            for (y = start; y < end; y += this.width) {
                                v17 = this.shortbufferin[y] & 65535;
                                this.Hist[v17] = this.Hist[v17] - 1;
                            }
                            ++x;
                        }
                    }
                    case 5: 
                    case 6: {
                        widthchannel = this.width * this.channel;
                        sewidthwidthchannel = this.sewidth * this.width * this.channel;
                        x = this.minx;
                        while (true) {
                            if (x >= this.maxx) continue block11;
                            for (c = 0; c < this.channel; ++c) {
                                this.mini = 255;
                                this.maxi = 0;
                                end = (x + sewidthwidth) * this.channel + c;
                                for (y = x * this.channel + c; y < end; y += widthchannel) {
                                    v18 = auxnext = this.bytebufferin[y] & 255;
                                    this.Hist[v18] = this.Hist[v18] + 1;
                                    if (auxnext > this.maxi) {
                                        this.maxi = auxnext;
                                    }
                                    if (auxnext >= this.mini) continue;
                                    this.mini = auxnext;
                                }
                                size = this.sewidth;
                                for (y = x * this.channel + c; y < end; y += widthchannel) {
                                    v19 = auxnext = this.bytebufferin[y + sewidthwidthchannel] & 255;
                                    this.Hist[v19] = this.Hist[v19] + 1;
                                    if (auxnext > this.maxi) {
                                        this.maxi = auxnext;
                                    }
                                    if (auxnext < this.mini) {
                                        this.mini = auxnext;
                                    }
                                    posrank = (int)(this.rank * (double)(++size));
                                    this.FindFlagLevel(posrank, size);
                                    this.bytebufferout[y] = (byte)this.flag;
                                }
                                posrank = (int)(this.rank * (double)(2 * this.sewidth) + 0.5);
                                size = 2 * this.sewidth + 1;
                                start = end;
                                end = (x + (this.height - this.sewidth) * this.width) * this.channel + c;
                                for (y = start; y < end; y += widthchannel) {
                                    v20 = auxnext = this.bytebufferin[y + sewidthwidthchannel] & 255;
                                    this.Hist[v20] = this.Hist[v20] + 1;
                                    if (auxnext > this.maxi) {
                                        this.maxi = auxnext;
                                    }
                                    if (auxnext < this.mini) {
                                        this.mini = auxnext;
                                    }
                                    this.FindFlagLevel(posrank, size);
                                    this.bytebufferout[y] = (byte)this.flag;
                                    v21 = this.bytebufferin[y - sewidthwidthchannel] & 255;
                                    this.Hist[v21] = this.Hist[v21] - 1;
                                    while (this.Hist[this.mini] == 0) {
                                        ++this.mini;
                                    }
                                    while (this.Hist[this.maxi] == 0) {
                                        --this.maxi;
                                    }
                                }
                                size = 2 * this.sewidth;
                                start = end;
                                end = (x + this.height * this.width) * this.channel + c;
                                for (y = start; y < end; y += widthchannel) {
                                    posrank = (int)(this.rank * (double)size);
                                    this.FindFlagLevel(posrank, size--);
                                    this.bytebufferout[y] = (byte)this.flag;
                                    v22 = this.bytebufferin[y - sewidthwidthchannel] & 255;
                                    this.Hist[v22] = this.Hist[v22] - 1;
                                    while (this.Hist[this.mini] == 0) {
                                        ++this.mini;
                                    }
                                    while (this.Hist[this.maxi] == 0) {
                                        --this.maxi;
                                    }
                                }
                                for (y = start; y < end; y += widthchannel) {
                                    v23 = this.bytebufferin[y] & 255;
                                    this.Hist[v23] = this.Hist[v23] - 1;
                                }
                            }
                            ++x;
                        }
                    }
                }
                break;
            }
            throw new IllegalArgumentException("Image type not supported.");
        }

        private void FindFlagLevel(int posrank, int max) {
            int nb = -1;
            if (this.rank < 0.5) {
                this.flag = this.mini;
                while (true) {
                    if (this.Hist[this.flag] == 0) {
                        ++this.flag;
                        continue;
                    }
                    this.level = 1;
                    ++nb;
                    while (this.level < this.Hist[this.flag] && nb < posrank) {
                        ++this.level;
                        ++nb;
                    }
                    if (nb >= posrank) break;
                    ++this.flag;
                }
                return;
            }
            this.flag = this.maxi;
            while (true) {
                if (this.Hist[this.flag] == 0) {
                    --this.flag;
                    continue;
                }
                this.level = 1;
                --max;
                while (this.level < this.Hist[this.flag] && posrank < max) {
                    ++this.level;
                    --max;
                }
                if (posrank >= max) break;
                --this.flag;
            }
        }
    }
}

