/*
 * Decompiled with CFR 0.152.
 */
package morphee.rank.fastRank;

import dv.DV;
import imageTiTi.ImageNew;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferUShort;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import morphee.MorphoFilter;
import morphee.StructuringElement;
import morphee.StructuringElement3D;

public class RankSegmentHorizontal
implements MorphoFilter {
    private RankSegmentHorizontalThread[] threads = null;
    private int nbFreeThreads = 0;
    private int sewidth = 0;
    private int rank;

    public void Kill() {
        if (this.threads != null) {
            for (int i2 = 0; i2 < this.threads.length; ++i2) {
                this.threads[i2].Kill();
            }
            Arrays.fill(this.threads, null);
            this.threads = null;
        }
    }

    public BufferedImage Filter(BufferedImage source, StructuringElement se, int nbCPU) {
        this.setStructuringElement(se);
        return this.Filter(source, nbCPU);
    }

    public void Filter(BufferedImage source, StructuringElement se, BufferedImage result, int nbCPU) {
        this.setStructuringElement(se);
        this.Filter(source, result, nbCPU);
    }

    public BufferedImage Filter(BufferedImage source, int nbCPU) {
        BufferedImage result = ImageNew.Same((BufferedImage)source);
        this.Filter(source, result, nbCPU);
        return result;
    }

    public void Filter(BufferedImage source, BufferedImage result, int nbCPU) {
        if (this.sewidth == 0) {
            throw new IllegalArgumentException("Structuring element's width not defined or less/equals than 0.");
        }
        this.Filter(source, this.sewidth, this.rank, result, nbCPU);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Filter(BufferedImage source, int sewidth, int rank, BufferedImage result, int nbCPU) {
        Object object;
        int i2;
        if (!ImageTools.areDimensionsAndTypeEqual((BufferedImage)source, (BufferedImage)result)) {
            throw new IllegalArgumentException("Image source and result have different dimensions.");
        }
        this.Parameters(sewidth, rank);
        if (this.threads == null || this.threads.length != nbCPU) {
            this.nbFreeThreads = 0;
            this.threads = null;
            this.threads = new RankSegmentHorizontalThread[nbCPU];
            for (i2 = 0; i2 < nbCPU; ++i2) {
                this.threads[i2] = new RankSegmentHorizontalThread();
                this.threads[i2].start();
            }
            RankSegmentHorizontal rankSegmentHorizontal = this;
            synchronized (rankSegmentHorizontal) {
                while (this.nbFreeThreads != nbCPU) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        this.nbFreeThreads = 0;
        int step = source.getHeight() / nbCPU;
        for (i2 = 0; i2 < nbCPU - 1; ++i2) {
            this.threads[i2].setConditions(source, result, sewidth, rank, i2 * step, (i2 + 1) * step);
            object = this.threads[i2].lock;
            synchronized (object) {
                this.threads[i2].lock.notify();
                continue;
            }
        }
        this.threads[i2].setConditions(source, result, sewidth, rank, i2 * step, source.getHeight());
        object = this.threads[i2].lock;
        synchronized (object) {
            this.threads[i2].lock.notify();
        }
        object = this;
        synchronized (object) {
            while (this.nbFreeThreads != nbCPU) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public DV Filter(DV source, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public void Filter(DV source, DV result, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public DV Filter(DV source, StructuringElement3D se, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public void Filter(DV source, StructuringElement3D se, DV result, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public StructuringElement3D getStructuringElement3D() {
        return null;
    }

    public void setStructuringElement3D(StructuringElement3D se) {
    }

    protected synchronized void addFreeThread() {
        ++this.nbFreeThreads;
        this.notify();
    }

    public StructuringElement getStructuringElement() {
        return new StructuringElement(new Object[]{this.sewidth >> 1, -5});
    }

    public void setStructuringElement(StructuringElement ES) {
        this.sewidth = ES.getSize();
    }

    public void Parameters(Object ... parameters) {
        if (parameters.length != 2) {
            throw new IllegalArgumentException("Exactly 2 parameter required.");
        }
        this.sewidth = (Integer)parameters[0];
        this.rank = (Integer)parameters[1];
    }

    public List<Object> Parameters() {
        ArrayList<Object> params = new ArrayList<Object>(2);
        params.add(this.sewidth);
        params.add(this.rank);
        return params;
    }

    public int BorderEffectSizeX() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public int BorderEffectSizeY() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public int BorderEffectSizeZ() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public MorphoFilter Clone() {
        throw new UnsupportedOperationException("Not supported (yet).");
    }

    private class RankSegmentHorizontalThread
    extends Thread {
        private WritableRaster wr = null;
        private WritableRaster wrres = null;
        private int channel = 0;
        private int sewidth = 0;
        private double rank = 0.0;
        private int miny;
        private int maxy;
        private int type;
        private int width;
        private short[] shortbufferin = null;
        private short[] shortbufferout = null;
        private byte[] bytebufferin = null;
        private byte[] bytebufferout = null;
        private int[] Hist = null;
        public Object lock = new Object();
        private int flag = -1;
        private int level;
        private int mini;
        private int maxi;
        private boolean Kill = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void Kill() {
            this.wrres = null;
            this.wr = null;
            this.shortbufferin = null;
            this.shortbufferout = null;
            this.bytebufferin = null;
            this.bytebufferout = null;
            this.Hist = null;
            this.Kill = true;
            Object object = this.lock;
            synchronized (object) {
                this.lock.notify();
            }
        }

        public void setConditions(BufferedImage Original, BufferedImage Result, int sewidth, int rank, int miny, int maxy) {
            this.sewidth = sewidth >> 1;
            this.rank = (double)rank / 100.0;
            this.miny = miny;
            this.maxy = maxy;
            this.type = Original.getType();
            this.width = Original.getWidth();
            this.bytebufferout = null;
            this.bytebufferin = null;
            this.shortbufferout = null;
            this.shortbufferin = null;
            this.wrres = null;
            this.wr = null;
            switch (Original.getType()) {
                case 12: {
                    this.wr = Original.getRaster();
                    this.wrres = Result.getRaster();
                    if (this.Hist != null && this.Hist.length == 2) break;
                    this.Hist = new int[2];
                    break;
                }
                case 5: 
                case 6: 
                case 10: {
                    this.bytebufferin = ((DataBufferByte)Original.getRaster().getDataBuffer()).getData();
                    this.bytebufferout = ((DataBufferByte)Result.getRaster().getDataBuffer()).getData();
                    this.channel = Original.getRaster().getNumBands();
                    if (this.Hist != null && this.Hist.length == 256) break;
                    this.Hist = new int[256];
                    break;
                }
                case 11: {
                    this.shortbufferin = ((DataBufferUShort)Original.getRaster().getDataBuffer()).getData();
                    this.shortbufferout = ((DataBufferUShort)Result.getRaster().getDataBuffer()).getData();
                    if (this.Hist != null && this.Hist.length == 65535) break;
                    this.Hist = new int[65535];
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported image type.");
                }
            }
            Arrays.fill(this.Hist, 0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            block11: while (true) lbl-1000:
            // 5 sources

            {
                var11_11 = this.lock;
                synchronized (var11_11) {
                    try {
                        RankSegmentHorizontal.this.addFreeThread();
                        this.lock.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                if (this.Kill) {
                    return;
                }
                switch (this.type) {
                    case 12: {
                        y = this.miny;
                        while (true) {
                            if (y >= this.maxy) ** GOTO lbl-1000
                            this.maxi = 0;
                            this.mini = 1;
                            end = this.sewidth;
                            for (x = 0; x < end; ++x) {
                                v0 = auxnext = this.wr.getSample(x, y, 0);
                                this.Hist[v0] = this.Hist[v0] + 1;
                                if (this.maxi < auxnext) {
                                    this.maxi = auxnext;
                                }
                                if (auxnext >= this.mini) continue;
                                this.mini = auxnext;
                            }
                            size = this.sewidth;
                            for (x = 0; x < end; ++x) {
                                v1 = auxnext = this.wr.getSample(x + this.sewidth, y, 0);
                                this.Hist[v1] = this.Hist[v1] + 1;
                                if (this.maxi < auxnext) {
                                    this.maxi = auxnext;
                                }
                                if (auxnext < this.mini) {
                                    this.mini = auxnext;
                                }
                                posrank = (int)(this.rank * (double)(++size));
                                this.FindFlagLevel(posrank, size);
                                this.wrres.setSample(x, y, 0, this.flag);
                            }
                            posrank = (int)(this.rank * (double)(this.sewidth << 1) + 0.5);
                            size = (this.sewidth << 1) + 1;
                            start = end;
                            end = this.width - this.sewidth;
                            for (x = start; x < end; ++x) {
                                v2 = auxnext = this.wr.getSample(x + this.sewidth, y, 0);
                                this.Hist[v2] = this.Hist[v2] + 1;
                                if (this.maxi < auxnext) {
                                    this.maxi = auxnext;
                                }
                                if (auxnext < this.mini) {
                                    this.mini = auxnext;
                                }
                                this.FindFlagLevel(posrank, size);
                                this.wrres.setSample(x, y, 0, this.flag);
                                v3 = this.wr.getSample(x - this.sewidth, y, 0);
                                this.Hist[v3] = this.Hist[v3] - 1;
                                while (this.Hist[this.mini] == 0) {
                                    ++this.mini;
                                }
                                while (this.Hist[this.maxi] == 0) {
                                    --this.maxi;
                                }
                            }
                            size = this.sewidth << 1;
                            start = end;
                            end = this.width;
                            for (x = start; x < end; ++x) {
                                posrank = (int)(this.rank * (double)size);
                                this.FindFlagLevel(posrank, size--);
                                this.wrres.setSample(x, y, 0, this.flag);
                                v4 = this.wr.getSample(x - this.sewidth, y, 0);
                                this.Hist[v4] = this.Hist[v4] - 1;
                                while (this.Hist[this.maxi] == 0) {
                                    --this.maxi;
                                }
                                while (this.Hist[this.mini] == 0) {
                                    ++this.mini;
                                }
                            }
                            for (x = start; x < end; ++x) {
                                v5 = this.wr.getSample(x, y, 0);
                                this.Hist[v5] = this.Hist[v5] - 1;
                            }
                            ++y;
                        }
                    }
                    case 10: {
                        y = this.miny;
                        while (true) {
                            if (y >= this.maxy) ** GOTO lbl-1000
                            this.maxi = 0;
                            this.mini = 255;
                            pos = y * this.width;
                            end = pos + this.sewidth;
                            for (x = pos; x < end; ++x) {
                                v6 = auxnext = this.bytebufferin[x] & 255;
                                this.Hist[v6] = this.Hist[v6] + 1;
                                if (this.maxi < auxnext) {
                                    this.maxi = auxnext;
                                }
                                if (auxnext >= this.mini) continue;
                                this.mini = auxnext;
                            }
                            size = this.sewidth;
                            for (x = pos; x < end; ++x) {
                                v7 = auxnext = this.bytebufferin[x + this.sewidth] & 255;
                                this.Hist[v7] = this.Hist[v7] + 1;
                                if (this.maxi < auxnext) {
                                    this.maxi = auxnext;
                                }
                                if (auxnext < this.mini) {
                                    this.mini = auxnext;
                                }
                                posrank = (int)(this.rank * (double)(++size));
                                this.FindFlagLevel(posrank, size);
                                this.bytebufferout[x] = (byte)this.flag;
                            }
                            posrank = (int)(this.rank * (double)(2 * this.sewidth) + 0.5);
                            size = (this.sewidth << 1) + 1;
                            start = end;
                            end = pos + this.width - this.sewidth;
                            for (x = start; x < end; ++x) {
                                v8 = auxnext = this.bytebufferin[x + this.sewidth] & 255;
                                this.Hist[v8] = this.Hist[v8] + 1;
                                if (this.maxi < auxnext) {
                                    this.maxi = auxnext;
                                }
                                if (auxnext < this.mini) {
                                    this.mini = auxnext;
                                }
                                this.FindFlagLevel(posrank, size);
                                this.bytebufferout[x] = (byte)this.flag;
                                v9 = this.bytebufferin[x - this.sewidth] & 255;
                                this.Hist[v9] = this.Hist[v9] - 1;
                                while (this.Hist[this.mini] == 0) {
                                    ++this.mini;
                                }
                                while (this.Hist[this.maxi] == 0) {
                                    --this.maxi;
                                }
                            }
                            size = this.sewidth << 1;
                            start = end;
                            end = pos + this.width;
                            for (x = start; x < end; ++x) {
                                posrank = (int)(this.rank * (double)size);
                                this.FindFlagLevel(posrank, size--);
                                this.bytebufferout[x] = (byte)this.flag;
                                v10 = this.bytebufferin[x - this.sewidth] & 255;
                                this.Hist[v10] = this.Hist[v10] - 1;
                                while (this.Hist[this.maxi] == 0) {
                                    --this.maxi;
                                }
                                while (this.Hist[this.mini] == 0) {
                                    ++this.mini;
                                }
                            }
                            for (x = start; x < end; ++x) {
                                v11 = this.bytebufferin[x] & 255;
                                this.Hist[v11] = this.Hist[v11] - 1;
                            }
                            ++y;
                        }
                    }
                    case 11: {
                        y = this.miny;
                        while (true) {
                            if (y >= this.maxy) ** GOTO lbl-1000
                            this.maxi = 0;
                            this.mini = 65535;
                            pos = y * this.width;
                            end = pos + this.sewidth;
                            for (x = pos; x < end; ++x) {
                                v12 = auxnext = this.shortbufferin[x] & 65535;
                                this.Hist[v12] = this.Hist[v12] + 1;
                                if (this.maxi < auxnext) {
                                    this.maxi = auxnext;
                                }
                                if (auxnext >= this.mini) continue;
                                this.mini = auxnext;
                            }
                            size = this.sewidth;
                            for (x = pos; x < end; ++x) {
                                v13 = auxnext = this.shortbufferin[x + this.sewidth] & 65535;
                                this.Hist[v13] = this.Hist[v13] + 1;
                                if (this.maxi < auxnext) {
                                    this.maxi = auxnext;
                                }
                                if (auxnext < this.mini) {
                                    this.mini = auxnext;
                                }
                                posrank = (int)(this.rank * (double)(++size));
                                this.FindFlagLevel(posrank, size);
                                this.shortbufferout[x] = (short)this.flag;
                            }
                            posrank = (int)(this.rank * (double)(this.sewidth << 1) + 0.5);
                            size = (this.sewidth << 1) + 1;
                            start = end;
                            end = pos + this.width - this.sewidth;
                            for (x = start; x < end; ++x) {
                                v14 = auxnext = this.shortbufferin[x + this.sewidth] & 65535;
                                this.Hist[v14] = this.Hist[v14] + 1;
                                if (this.maxi < auxnext) {
                                    this.maxi = auxnext;
                                }
                                if (auxnext < this.mini) {
                                    this.mini = auxnext;
                                }
                                this.FindFlagLevel(posrank, size);
                                this.shortbufferout[x] = (short)this.flag;
                                v15 = this.shortbufferin[x - this.sewidth] & 65535;
                                this.Hist[v15] = this.Hist[v15] - 1;
                                while (this.Hist[this.mini] == 0) {
                                    ++this.mini;
                                }
                                while (this.Hist[this.maxi] == 0) {
                                    --this.maxi;
                                }
                            }
                            size = this.sewidth << 1;
                            start = end;
                            end = pos + this.width;
                            for (x = start; x < end; ++x) {
                                posrank = (int)(this.rank * (double)size);
                                this.FindFlagLevel(posrank, size--);
                                this.shortbufferout[x] = (short)this.flag;
                                v16 = this.shortbufferin[x - this.sewidth] & 65535;
                                this.Hist[v16] = this.Hist[v16] - 1;
                                while (this.Hist[this.maxi] == 0) {
                                    --this.maxi;
                                }
                                while (this.Hist[this.mini] == 0) {
                                    ++this.mini;
                                }
                            }
                            for (x = start; x < end; ++x) {
                                v17 = this.shortbufferin[x] & 65535;
                                this.Hist[v17] = this.Hist[v17] - 1;
                            }
                            ++y;
                        }
                    }
                    case 5: 
                    case 6: {
                        sewidthchannel = this.sewidth * this.channel;
                        y = this.miny;
                        while (true) {
                            if (y >= this.maxy) continue block11;
                            for (c = 0; c < this.channel; ++c) {
                                this.maxi = 0;
                                this.mini = 255;
                                pos = y * this.width;
                                end = (pos + this.sewidth) * this.channel + c;
                                for (x = pos * this.channel + c; x < end; x += this.channel) {
                                    v18 = auxnext = this.bytebufferin[x] & 255;
                                    this.Hist[v18] = this.Hist[v18] + 1;
                                    if (auxnext > this.maxi) {
                                        this.maxi = auxnext;
                                    }
                                    if (auxnext >= this.mini) continue;
                                    this.mini = auxnext;
                                }
                                size = this.sewidth;
                                for (x = pos * this.channel + c; x < end; x += this.channel) {
                                    v19 = auxnext = this.bytebufferin[x + sewidthchannel] & 255;
                                    this.Hist[v19] = this.Hist[v19] + 1;
                                    if (auxnext > this.maxi) {
                                        this.maxi = auxnext;
                                    }
                                    if (auxnext < this.mini) {
                                        this.mini = auxnext;
                                    }
                                    posrank = (int)(this.rank * (double)(++size));
                                    this.FindFlagLevel(posrank, size);
                                    this.bytebufferout[x] = (byte)this.flag;
                                }
                                posrank = (int)(this.rank * (double)(this.sewidth << 1) + 0.5);
                                size = (this.sewidth << 1) + 1;
                                start = end;
                                end = (pos + this.width - this.sewidth) * this.channel + c;
                                for (x = start; x < end; x += this.channel) {
                                    v20 = auxnext = this.bytebufferin[x + sewidthchannel] & 255;
                                    this.Hist[v20] = this.Hist[v20] + 1;
                                    if (auxnext > this.maxi) {
                                        this.maxi = auxnext;
                                    }
                                    if (auxnext < this.mini) {
                                        this.mini = auxnext;
                                    }
                                    this.FindFlagLevel(posrank, size);
                                    this.bytebufferout[x] = (byte)this.flag;
                                    v21 = this.bytebufferin[x - sewidthchannel] & 255;
                                    this.Hist[v21] = this.Hist[v21] - 1;
                                    while (this.Hist[this.maxi] == 0) {
                                        --this.maxi;
                                    }
                                    while (this.Hist[this.mini] == 0) {
                                        ++this.mini;
                                    }
                                }
                                size = this.sewidth << 1;
                                start = end;
                                end = (pos + this.width) * this.channel + c;
                                for (x = start; x < end; x += this.channel) {
                                    posrank = (int)(this.rank * (double)size);
                                    this.FindFlagLevel(posrank, size--);
                                    this.bytebufferout[x] = (byte)this.flag;
                                    v22 = this.bytebufferin[x - sewidthchannel] & 255;
                                    this.Hist[v22] = this.Hist[v22] - 1;
                                    while (this.Hist[this.maxi] == 0) {
                                        --this.maxi;
                                    }
                                    while (this.Hist[this.mini] == 0) {
                                        ++this.mini;
                                    }
                                }
                                for (x = start; x < end; x += this.channel) {
                                    v23 = this.bytebufferin[x] & 255;
                                    this.Hist[v23] = this.Hist[v23] - 1;
                                }
                            }
                            ++y;
                        }
                    }
                }
                break;
            }
            throw new IllegalArgumentException("Image type not supported.");
        }

        private void FindFlagLevel(int posrank, int max) {
            int nb = -1;
            if (this.rank < 0.5) {
                this.flag = this.mini;
                while (true) {
                    if (this.Hist[this.flag] == 0) {
                        ++this.flag;
                        continue;
                    }
                    this.level = 1;
                    ++nb;
                    while (this.level < this.Hist[this.flag] && nb < posrank) {
                        ++this.level;
                        ++nb;
                    }
                    if (nb >= posrank) break;
                    ++this.flag;
                }
                return;
            }
            this.flag = this.maxi;
            while (true) {
                if (this.Hist[this.flag] == 0) {
                    --this.flag;
                    continue;
                }
                this.level = 1;
                --max;
                while (this.level < this.Hist[this.flag] && posrank < max) {
                    ++this.level;
                    --max;
                }
                if (posrank >= max) break;
                --this.flag;
            }
        }
    }
}

