/*
 * Decompiled with CFR 0.152.
 */
package morphee.rank;

import dv.DV;
import imageTiTi.ImageNew;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferUShort;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mathematics.primitives.pointsTiTi.CoordinatesWeighted;
import morphee.MorphoFilter;
import morphee.StructuringElement;
import morphee.StructuringElement3D;

public class WeightedRank
implements MorphoFilter {
    public static final int MAX = 100;
    public static final int QUARTILE1 = 75;
    public static final int MEDIAN = 50;
    public static final int QUARTILE3 = 25;
    public static final int MIN = 0;
    private StructuringElement SE = null;
    private WeightedRankThread[] threads = null;
    private int nbFreeThreads = 0;
    private int rank = 100;

    public BufferedImage Filter(BufferedImage source, StructuringElement SE, int rank, int nbCPU) {
        this.Parameters(SE, rank);
        return this.Filter(source, nbCPU);
    }

    public void Filter(BufferedImage source, StructuringElement SE, int rank, BufferedImage result, int nbCPU) {
        this.Parameters(SE, rank);
        this.Filter(source, result, nbCPU);
    }

    public BufferedImage Filter(BufferedImage source, StructuringElement se, int nbCPU) {
        this.setStructuringElement(se);
        return this.Filter(source, nbCPU);
    }

    public void Filter(BufferedImage source, StructuringElement se, BufferedImage result, int nbCPU) {
        this.setStructuringElement(se);
        this.Filter(source, result, nbCPU);
    }

    public BufferedImage Filter(BufferedImage source, int nbCPU) {
        BufferedImage result = ImageNew.Same((BufferedImage)source);
        this.Filter(source, result, nbCPU);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Filter(BufferedImage source, BufferedImage result, int nbCPU) {
        Object object;
        int i2;
        if (nbCPU < 1) {
            throw new IllegalArgumentException("nbCPU < 1.");
        }
        if (this.SE == null) {
            throw new IllegalArgumentException("Any structuring element defined.");
        }
        if (!ImageTools.areDimensionsAndTypeEqual((BufferedImage)result, (BufferedImage)result)) {
            throw new IllegalArgumentException("Images source and result must have identic dimensions and types.");
        }
        if (this.threads == null || this.threads.length < nbCPU) {
            this.nbFreeThreads = 0;
            this.threads = null;
            this.threads = new WeightedRankThread[nbCPU];
            for (i2 = 0; i2 < nbCPU; ++i2) {
                this.threads[i2] = new WeightedRankThread();
                this.threads[i2].start();
            }
            WeightedRank weightedRank = this;
            synchronized (weightedRank) {
                while (this.nbFreeThreads != nbCPU) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        this.nbFreeThreads = 0;
        int step = source.getHeight() / nbCPU;
        for (i2 = 0; i2 < nbCPU - 1; ++i2) {
            this.threads[i2].setConditions(source, result, this.SE, this.rank, 0, i2 * step, source.getWidth(), (i2 + 1) * step);
            object = this.threads[i2].lock;
            synchronized (object) {
                this.threads[i2].lock.notify();
                continue;
            }
        }
        this.threads[i2].setConditions(source, result, this.SE, this.rank, 0, i2 * step, source.getWidth(), source.getHeight());
        object = this.threads[i2].lock;
        synchronized (object) {
            this.threads[i2].lock.notify();
        }
        object = this;
        synchronized (object) {
            while (this.nbFreeThreads != nbCPU) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public DV Filter(DV source, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public void Filter(DV source, DV result, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public DV Filter(DV source, StructuringElement3D se, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public void Filter(DV source, StructuringElement3D se, DV result, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public StructuringElement3D getStructuringElement3D() {
        return null;
    }

    public void setStructuringElement3D(StructuringElement3D se) {
    }

    protected synchronized void addFreeThread() {
        ++this.nbFreeThreads;
        this.notify();
    }

    public StructuringElement getStructuringElement() {
        return this.SE;
    }

    public void setStructuringElement(StructuringElement SE) {
        this.SE = SE;
    }

    public void Parameters(Object ... parameters) {
        if (parameters.length != 2) {
            throw new IllegalArgumentException("Exactly 2 parameters required.");
        }
        this.SE = (StructuringElement)parameters[0];
        this.SetRank((Integer)parameters[1]);
    }

    public List<Object> Parameters() {
        ArrayList<Object> params = new ArrayList<Object>(2);
        params.add(this.SE);
        params.add(this.rank);
        return params;
    }

    private void SetRank(int rank) {
        switch (rank) {
            case 0: 
            case 25: 
            case 50: 
            case 75: 
            case 100: {
                this.rank = rank;
                break;
            }
            default: {
                if (rank < 0) {
                    throw new IllegalArgumentException("Unknown or bad value of rank (< 0).");
                }
                if (100 < rank) {
                    throw new IllegalArgumentException("Unknown or bad value of rank (> 100).");
                }
                this.rank = rank;
            }
        }
    }

    public int BorderEffectSizeX() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public int BorderEffectSizeY() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public int BorderEffectSizeZ() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public MorphoFilter Clone() {
        throw new UnsupportedOperationException("Not supported (yet).");
    }

    private class WeightedRankThread
    extends Thread {
        private WritableRaster wro = null;
        private WritableRaster wrr = null;
        private StructuringElement stel = null;
        private int order = 0;
        private int length = 0;
        private CoordinatesWeighted[] se = null;
        private int[] sexy = null;
        private int minx;
        private int miny;
        private int maxx;
        private int maxy;
        private int type;
        private int width;
        private int height;
        private int channel;
        private int widthchannel;
        private short[] shortbufferin = null;
        private short[] shortbufferout = null;
        private byte[] bytebufferin = null;
        private byte[] bytebufferout = null;
        public Object lock = new Object();
        private int[] buffer = null;
        private int FixN = 0;

        public void setConditions(BufferedImage Original, BufferedImage Result, StructuringElement SE, int rank, int minx, int miny, int maxx, int maxy) {
            this.order = SE.getSize() >> 1;
            this.se = SE.getSE();
            this.length = this.se.length;
            this.minx = minx;
            this.miny = miny;
            this.maxx = maxx;
            this.maxy = maxy;
            this.width = Original.getWidth();
            this.height = Original.getHeight();
            this.type = Original.getType();
            if (this.buffer == null || this.buffer.length != (int)SE.getSumOfWeights()) {
                this.buffer = null;
                this.buffer = new int[(int)SE.getSumOfWeights()];
            }
            this.FixN = (int)((double)(this.buffer.length - 1) * (double)rank / 100.0 + 0.5);
            switch (rank) {
                case 0: {
                    this.FixN = 0;
                    break;
                }
                case 100: {
                    this.FixN = this.buffer.length - 1;
                    break;
                }
                case 75: {
                    this.FixN = 3 * this.buffer.length / 4;
                    break;
                }
                case 50: {
                    this.FixN = this.buffer.length / 2;
                    break;
                }
                case 25: {
                    this.FixN = this.buffer.length / 4;
                }
            }
            switch (Original.getType()) {
                case 1: 
                case 2: 
                case 4: 
                case 12: {
                    this.wro = Original.getRaster();
                    this.wrr = Result.getRaster();
                    break;
                }
                case 10: {
                    if (this.stel == null || !this.stel.equals(SE)) {
                        if (this.sexy == null || this.sexy.length != this.se.length) {
                            this.sexy = null;
                            this.sexy = new int[this.se.length];
                        }
                        for (int i2 = 0; i2 < this.se.length; ++i2) {
                            this.sexy[i2] = this.se[i2].X + this.se[i2].Y * this.width;
                        }
                    }
                    this.bytebufferin = ((DataBufferByte)Original.getRaster().getDataBuffer()).getData();
                    this.bytebufferout = ((DataBufferByte)Result.getRaster().getDataBuffer()).getData();
                    break;
                }
                case 5: 
                case 6: {
                    this.channel = Original.getRaster().getNumBands();
                    this.widthchannel = this.width * this.channel;
                    if (this.stel == null || !this.stel.equals(SE)) {
                        if (this.sexy == null || this.sexy.length != this.se.length) {
                            this.sexy = null;
                            this.sexy = new int[this.se.length];
                        }
                        for (int i3 = 0; i3 < this.se.length; ++i3) {
                            this.sexy[i3] = this.se[i3].X * this.channel + this.se[i3].Y * this.widthchannel;
                        }
                    }
                    this.bytebufferin = ((DataBufferByte)Original.getRaster().getDataBuffer()).getData();
                    this.bytebufferout = ((DataBufferByte)Result.getRaster().getDataBuffer()).getData();
                    break;
                }
                case 11: {
                    if (this.stel == null || !this.stel.equals(SE)) {
                        if (this.sexy == null || this.sexy.length != this.se.length) {
                            this.sexy = null;
                            this.sexy = new int[this.se.length];
                        }
                        for (int i4 = 0; i4 < this.se.length; ++i4) {
                            this.sexy[i4] = this.se[i4].X + this.se[i4].Y * this.width;
                        }
                    }
                    this.shortbufferin = ((DataBufferUShort)Original.getRaster().getDataBuffer()).getData();
                    this.shortbufferout = ((DataBufferUShort)Result.getRaster().getDataBuffer()).getData();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported image type.");
                }
            }
            this.stel = SE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            coord = null;
            block12: while (true) {
                var15_15 = this.lock;
                synchronized (var15_15) {
                    try {
                        WeightedRank.this.addFreeThread();
                        this.lock.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                MinX = this.minx < this.order ? this.order : this.minx;
                MinY = this.miny < this.order ? this.order : this.miny;
                MaxX = this.maxx >= this.width - this.order ? this.width - this.order : this.maxx;
                MaxY = this.maxy >= this.height - this.order ? this.height - this.order : this.maxy;
                switch (this.type) {
                    case 12: {
                        for (i = MinY; i < MaxY; ++i) {
                            for (j = MinX; j < MaxX; ++j) {
                                nb = 0;
                                for (l = 0; l < this.length; ++l) {
                                    coord = this.se[l];
                                    v = this.wro.getSample(j + coord.X, i + coord.Y, 0);
                                    w = coord.Wi;
                                    for (k = 0; k < w; ++k) {
                                        this.buffer[nb++] = v;
                                    }
                                }
                                this.wrr.setSample(j, i, 0, this.SortAndFind());
                            }
                        }
                        i = this.miny;
                        while (true) {
                            if (i >= this.maxy) continue block12;
                            for (j = this.minx; j < this.maxx; ++j) {
                                if (i >= this.order && j >= this.order && i < this.height - this.order && j < this.width - this.order) continue;
                                nb = 0;
                                for (l = 0; l < this.length; ++l) {
                                    coord = this.se[l];
                                    if (i + coord.Y < 0 || i + coord.Y >= this.height || j + coord.X < 0 || j + coord.X >= this.width) continue;
                                    v = this.wro.getSample(j + coord.X, i + coord.Y, 0);
                                    w = coord.Wi;
                                    for (k = 0; k < w; ++k) {
                                        this.buffer[nb++] = v;
                                    }
                                }
                                this.wrr.setSample(j, i, 0, this.SortAndFind(nb));
                            }
                            ++i;
                        }
                    }
                    case 10: {
                        i = MinY;
                        pos = MinY * this.width;
                        while (i < MaxY) {
                            for (j = MinX; j < MaxX; ++j) {
                                nb = 0;
                                for (l = 0; l < this.length; ++l) {
                                    v = this.bytebufferin[pos + this.sexy[l] + j] & 255;
                                    w = this.se[l].Wi;
                                    for (k = 0; k < w; ++k) {
                                        this.buffer[nb++] = v;
                                    }
                                }
                                this.bytebufferout[pos + j] = (byte)this.SortAndFind();
                            }
                            ++i;
                            pos += this.width;
                        }
                        i = this.miny;
                        pos = this.miny * this.width;
                        while (true) {
                            if (i >= this.maxy) continue block12;
                            for (j = this.minx; j < this.maxx; ++j) {
                                if (i >= this.order && j >= this.order && i < this.height - this.order && j < this.width - this.order) continue;
                                nb = 0;
                                for (l = 0; l < this.length; ++l) {
                                    coord = this.se[l];
                                    if (i + coord.Y < 0 || i + coord.Y >= this.height || j + coord.X < 0 || j + coord.X >= this.width) continue;
                                    v = this.bytebufferin[pos + this.sexy[l] + j] & 255;
                                    w = coord.Wi;
                                    for (k = 0; k < w; ++k) {
                                        this.buffer[nb++] = v;
                                    }
                                }
                                this.bytebufferout[pos + j] = (byte)this.SortAndFind(nb);
                            }
                            ++i;
                            pos += this.width;
                        }
                    }
                    case 5: 
                    case 6: {
                        c = 0;
                        while (true) {
                            if (c >= this.channel) continue block12;
                            i = MinY;
                            pos = MinY * this.widthchannel;
                            while (i < MaxY) {
                                j = MinX;
                                jchannel = j * this.channel;
                                while (j < MaxX) {
                                    nb = 0;
                                    for (l = 0; l < this.length; ++l) {
                                        v = this.bytebufferin[pos + this.sexy[l] + jchannel + c] & 255;
                                        w = this.se[l].Wi;
                                        for (k = 0; k < w; ++k) {
                                            this.buffer[nb++] = v;
                                        }
                                    }
                                    this.bytebufferout[pos + jchannel + c] = (byte)this.SortAndFind();
                                    ++j;
                                    jchannel += this.channel;
                                }
                                ++i;
                                pos += this.widthchannel;
                            }
                            i = this.miny;
                            pos = this.miny * this.widthchannel;
                            while (i < this.maxy) {
                                j = this.minx;
                                jchannel = j * this.channel;
                                while (j < this.maxx) {
                                    if (i < this.order || j < this.order || i >= this.height - this.order || j >= this.width - this.order) {
                                        nb = 0;
                                        for (l = 0; l < this.length; ++l) {
                                            coord = this.se[l];
                                            if (i + coord.Y < 0 || i + coord.Y >= this.height || j + coord.X < 0 || j + coord.X >= this.width) continue;
                                            v = this.bytebufferin[pos + this.sexy[l] + jchannel + c] & 255;
                                            w = coord.Wi;
                                            for (k = 0; k < w; ++k) {
                                                this.buffer[nb++] = v;
                                            }
                                        }
                                        this.bytebufferout[pos + jchannel + c] = (byte)this.SortAndFind(nb);
                                    }
                                    ++j;
                                    jchannel += this.channel;
                                }
                                ++i;
                                pos += this.widthchannel;
                            }
                            ++c;
                        }
                    }
                    case 11: {
                        i = MinY;
                        pos = MinY * this.width;
                        while (i < MaxY) {
                            for (j = MinX; j < MaxX; ++j) {
                                nb = 0;
                                for (l = 0; l < this.length; ++l) {
                                    v = this.shortbufferin[pos + this.sexy[l] + j] & 65535;
                                    w = this.se[l].Wi;
                                    for (k = 0; k < w; ++k) {
                                        this.buffer[nb++] = v;
                                    }
                                }
                                this.shortbufferout[pos + j] = (short)this.SortAndFind();
                            }
                            ++i;
                            pos += this.width;
                        }
                        i = this.miny;
                        pos = this.miny * this.width;
                        while (true) {
                            if (i >= this.maxy) continue block12;
                            for (j = this.minx; j < this.maxx; ++j) {
                                if (i >= this.order && j >= this.order && i < this.height - this.order && j < this.width - this.order) continue;
                                nb = 0;
                                for (l = 0; l < this.length; ++l) {
                                    coord = this.se[l];
                                    if (i + coord.Y < 0 || i + coord.Y >= this.height || j + coord.X < 0 || j + coord.X >= this.width) continue;
                                    v = this.shortbufferin[pos + this.sexy[l] + j] & 65535;
                                    w = coord.Wi;
                                    for (k = 0; k < w; ++k) {
                                        this.buffer[nb++] = v;
                                    }
                                }
                                this.shortbufferout[pos + j] = (short)this.SortAndFind(nb);
                            }
                            ++i;
                            pos += this.width;
                        }
                    }
                    case 1: 
                    case 2: 
                    case 4: {
                        c = 0;
                        while (true) {
                            if (c < this.channel) ** break;
                            continue block12;
                            for (i = MinY; i < MaxY; ++i) {
                                for (j = MinX; j < MaxX; ++j) {
                                    nb = 0;
                                    for (l = 0; l < this.length; ++l) {
                                        coord = this.se[l];
                                        v = this.wro.getSample(j + coord.X, i + coord.Y, c);
                                        w = coord.Wi;
                                        for (k = 0; k < w; ++k) {
                                            this.buffer[nb++] = v;
                                        }
                                    }
                                    this.wrr.setSample(j, i, c, this.SortAndFind());
                                }
                            }
                            for (i = this.miny; i < this.maxy; ++i) {
                                for (j = this.minx; j < this.maxx; ++j) {
                                    if (i >= this.order && j >= this.order && i < this.height - this.order && j < this.width - this.order) continue;
                                    nb = 0;
                                    for (l = 0; l < this.length; ++l) {
                                        coord = this.se[l];
                                        if (i + coord.Y < 0 || i + coord.Y >= this.height || j + coord.X < 0 || j + coord.X >= this.width) continue;
                                        v = this.wro.getSample(j + coord.X, i + coord.Y, c);
                                        w = coord.Wi;
                                        for (k = 0; k < w; ++k) {
                                            this.buffer[nb++] = v;
                                        }
                                    }
                                    this.wrr.setSample(j, i, c, this.SortAndFind(nb));
                                }
                            }
                            ++c;
                        }
                    }
                }
                break;
            }
            throw new IllegalArgumentException("Color type not yet supported.");
        }

        private int SortAndFind() {
            Arrays.sort(this.buffer);
            return this.buffer[this.FixN];
        }

        private int SortAndFind(int N) {
            Arrays.sort(this.buffer, 0, N);
            switch (WeightedRank.this.rank) {
                case 0: {
                    return this.buffer[0];
                }
                case 100: {
                    return this.buffer[N - 1];
                }
                case 75: {
                    return this.buffer[3 * N / 4];
                }
                case 50: {
                    return this.buffer[N / 2];
                }
                case 25: {
                    return this.buffer[N / 4];
                }
            }
            return this.buffer[WeightedRank.this.rank * N / 100];
        }
    }
}

