/*
 * Decompiled with CFR 0.152.
 */
package morphee.rank;

import dv.DV;
import imageTiTi.ImageNew;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferUShort;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mathematics.primitives.pointsTiTi.CoordinatesWeighted;
import morphee.MorphoFilter;
import morphee.StructuringElement;
import morphee.StructuringElement3D;
import morphee.rank.fastRank.RankSegmentDiagonal135;
import morphee.rank.fastRank.RankSegmentDiagonal45;
import morphee.rank.fastRank.RankSegmentHorizontal;
import morphee.rank.fastRank.RankSegmentVertical;

public class RankFV
implements MorphoFilter {
    public static final int MAX = 100;
    public static final int QUARTILE1 = 75;
    public static final int MEDIAN = 50;
    public static final int QUARTILE3 = 25;
    public static final int MIN = 0;
    public static final int ADAPTATIVE = -1;
    private RankSegmentDiagonal135 rsd135 = new RankSegmentDiagonal135();
    private RankSegmentDiagonal45 rsd45 = new RankSegmentDiagonal45();
    private RankSegmentHorizontal rsh = new RankSegmentHorizontal();
    private RankSegmentVertical rsv = new RankSegmentVertical();
    private StructuringElement SE = null;
    private RankThread[] threads = null;
    private RankHeavyThread[] heavythreads = null;
    private int nbFreeThreads = 0;
    private int rank = 100;
    private int ForbiddenValue = -1;

    public void Kill() {
        int i2;
        if (this.SE != null) {
            this.SE.Kill();
        }
        if (this.threads != null) {
            for (i2 = 0; i2 < this.threads.length; ++i2) {
                this.threads[i2].Kill();
            }
            Arrays.fill(this.threads, null);
            this.threads = null;
        }
        if (this.heavythreads != null) {
            for (i2 = 0; i2 < this.heavythreads.length; ++i2) {
                this.heavythreads[i2].Kill();
            }
            Arrays.fill(this.heavythreads, null);
            this.heavythreads = null;
        }
        this.rsd135.Kill();
        this.rsd45.Kill();
        this.rsh.Kill();
        this.rsv.Kill();
    }

    public BufferedImage Filter(BufferedImage source, StructuringElement SE, int rank, int forbiddenvalue, int nbCPU) {
        this.Parameters(SE, rank, forbiddenvalue);
        return this.Filter(source, nbCPU);
    }

    public void Filter(BufferedImage source, StructuringElement SE, int rank, int forbiddenvalue, BufferedImage result, int nbCPU) {
        this.Parameters(SE, rank, forbiddenvalue);
        this.Filter(source, result, nbCPU);
    }

    public BufferedImage Filter(BufferedImage source, StructuringElement se, int nbCPU) {
        this.setStructuringElement(se);
        return this.Filter(source, nbCPU);
    }

    public void Filter(BufferedImage source, StructuringElement se, BufferedImage result, int nbCPU) {
        this.setStructuringElement(se);
        this.Filter(source, result, nbCPU);
    }

    public BufferedImage Filter(BufferedImage source, int nbCPU) {
        BufferedImage result = ImageNew.Same((BufferedImage)source);
        this.Filter(source, result, nbCPU);
        return result;
    }

    public void Filter(BufferedImage source, BufferedImage result, int nbCPU) {
        if (nbCPU < 1) {
            throw new IllegalArgumentException("nbCPU < 1.");
        }
        if (this.SE == null) {
            throw new IllegalArgumentException("Any structuring element defined.");
        }
        if (!ImageTools.areDimensionsAndTypeEqual((BufferedImage)result, (BufferedImage)result)) {
            throw new IllegalArgumentException("Images source and result must have identic dimensions and types.");
        }
        if (source.getType() != 11 && this.SE.isIterable()) {
            switch (this.SE.getType()) {
                case -3: {
                    this.rsd135.Filter(source, this.SE.getSize(), this.rank, result, nbCPU);
                    return;
                }
                case -4: {
                    this.rsd45.Filter(source, this.SE.getSize(), this.rank, result, nbCPU);
                    return;
                }
                case -5: {
                    this.rsh.Filter(source, this.SE.getSize(), this.rank, result, nbCPU);
                    return;
                }
                case -6: {
                    this.rsv.Filter(source, this.SE.getSize(), this.rank, result, nbCPU);
                    return;
                }
            }
        }
        if (this.SE.isHeavy()) {
            this.FilterHeavy(source, result, nbCPU);
        } else {
            this.FilterNormal(source, result, nbCPU);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void FilterHeavy(BufferedImage source, BufferedImage result, int nbCPU) {
        Object object;
        int i2;
        if (this.heavythreads == null || this.heavythreads.length != nbCPU) {
            this.nbFreeThreads = 0;
            this.heavythreads = null;
            this.heavythreads = new RankHeavyThread[nbCPU];
            for (i2 = 0; i2 < nbCPU; ++i2) {
                this.heavythreads[i2] = new RankHeavyThread();
                this.heavythreads[i2].start();
            }
            RankFV rankFV = this;
            synchronized (rankFV) {
                while (this.nbFreeThreads != nbCPU) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        this.nbFreeThreads = 0;
        int step = source.getHeight() / nbCPU;
        for (i2 = 0; i2 < nbCPU - 1; ++i2) {
            this.heavythreads[i2].setConditions(source, result, this.SE, this.rank, 0, i2 * step, source.getWidth(), (i2 + 1) * step);
            object = this.heavythreads[i2].lock;
            synchronized (object) {
                this.heavythreads[i2].lock.notify();
                continue;
            }
        }
        this.heavythreads[i2].setConditions(source, result, this.SE, this.rank, 0, i2 * step, source.getWidth(), source.getHeight());
        object = this.heavythreads[i2].lock;
        synchronized (object) {
            this.heavythreads[i2].lock.notify();
        }
        object = this;
        synchronized (object) {
            while (this.nbFreeThreads != nbCPU) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void FilterNormal(BufferedImage source, BufferedImage result, int nbCPU) {
        Object object;
        int i2;
        if (this.threads == null || this.threads.length != nbCPU) {
            this.nbFreeThreads = 0;
            this.threads = null;
            this.threads = new RankThread[nbCPU];
            for (i2 = 0; i2 < nbCPU; ++i2) {
                this.threads[i2] = new RankThread();
                this.threads[i2].start();
            }
            RankFV rankFV = this;
            synchronized (rankFV) {
                while (this.nbFreeThreads != nbCPU) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        this.nbFreeThreads = 0;
        int step = source.getHeight() / nbCPU;
        for (i2 = 0; i2 < nbCPU - 1; ++i2) {
            this.threads[i2].setConditions(source, result, this.SE, this.rank, 0, i2 * step, source.getWidth(), (i2 + 1) * step);
            object = this.threads[i2].lock;
            synchronized (object) {
                this.threads[i2].lock.notify();
                continue;
            }
        }
        this.threads[i2].setConditions(source, result, this.SE, this.rank, 0, i2 * step, source.getWidth(), source.getHeight());
        object = this.threads[i2].lock;
        synchronized (object) {
            this.threads[i2].lock.notify();
        }
        object = this;
        synchronized (object) {
            while (this.nbFreeThreads != nbCPU) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public DV Filter(DV source, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public void Filter(DV source, DV result, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public DV Filter(DV source, StructuringElement3D se, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public void Filter(DV source, StructuringElement3D se, DV result, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public StructuringElement3D getStructuringElement3D() {
        return null;
    }

    public void setStructuringElement3D(StructuringElement3D se) {
    }

    protected synchronized void addFreeThread() {
        ++this.nbFreeThreads;
        this.notify();
    }

    public StructuringElement getStructuringElement() {
        return this.SE;
    }

    public void setStructuringElement(StructuringElement SE) {
        this.SE = SE;
    }

    public void Parameters(Object ... parameters) {
        if (parameters.length != 3) {
            throw new IllegalArgumentException("Exactly 3 parameters required.");
        }
        this.SE = (StructuringElement)parameters[0];
        this.SetRank((Integer)parameters[1]);
        this.ForbiddenValue = (Integer)parameters[2];
        if (this.ForbiddenValue < 0) {
            throw new IllegalArgumentException("ForbiddenValue < 0.");
        }
    }

    public List<Object> Parameters() {
        ArrayList<Object> params = new ArrayList<Object>(3);
        params.add(this.SE);
        params.add(this.rank);
        params.add(this.ForbiddenValue);
        return params;
    }

    public int BorderEffectSizeX() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public int BorderEffectSizeY() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public int BorderEffectSizeZ() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public MorphoFilter Clone() {
        throw new UnsupportedOperationException("Not supported (yet).");
    }

    private void SetRank(int rank) {
        switch (rank) {
            case -1: 
            case 0: 
            case 25: 
            case 50: 
            case 75: 
            case 100: {
                this.rank = rank;
                break;
            }
            default: {
                if (rank < 0) {
                    throw new IllegalArgumentException("Unknown or bad value of rank (< 0).");
                }
                if (100 < rank) {
                    throw new IllegalArgumentException("Unknown or bad value of rank (> 100).");
                }
                this.rank = rank;
            }
        }
    }

    private class RankHeavyThread
    extends Thread {
        private StructuringElement stel = null;
        private int order = 0;
        private int length = 0;
        private CoordinatesWeighted[] se = null;
        private CoordinatesWeighted[] forward = null;
        private CoordinatesWeighted[] backward = null;
        private int[] sexy = null;
        private int[] forwardxy = null;
        private int[] backwardxy = null;
        private int minx;
        private int miny;
        private int maxx;
        private int maxy;
        private int type;
        private int width;
        private int height;
        private short[] shortbufferin = null;
        private short[] shortbufferout = null;
        private byte[] bytebufferin = null;
        private byte[] bytebufferout = null;
        public Object lock = new Object();
        private int[] buffer = null;
        private int[] Hist = null;
        private double rankdouble = 0.0;
        private int mini;
        private int maxi;
        private int level;
        private int flag;
        private boolean Kill = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void Kill() {
            this.stel = null;
            this.backward = null;
            this.forward = null;
            this.se = null;
            this.shortbufferin = null;
            this.shortbufferout = null;
            this.bytebufferin = null;
            this.bytebufferout = null;
            this.backwardxy = null;
            this.forwardxy = null;
            this.Hist = null;
            this.buffer = null;
            this.Kill = true;
            Object object = this.lock;
            synchronized (object) {
                this.lock.notify();
            }
        }

        public void setConditions(BufferedImage Original, BufferedImage Result, StructuringElement SE, int rank, int minx, int miny, int maxx, int maxy) {
            this.order = SE.getSize() >> 1;
            this.rankdouble = (double)rank / 100.0;
            this.se = SE.getSE();
            this.forward = SE.getForward();
            this.backward = SE.getBackward();
            this.length = this.se.length;
            this.minx = minx;
            this.miny = miny;
            this.maxx = maxx;
            this.maxy = maxy;
            this.width = Original.getWidth();
            this.height = Original.getHeight();
            this.type = Original.getType();
            if (this.buffer == null || this.buffer.length != this.length) {
                this.buffer = null;
                this.buffer = new int[this.length];
            }
            switch (Original.getType()) {
                case 10: {
                    if (this.stel == null || !this.stel.equals(SE)) {
                        int i2;
                        if (this.forwardxy == null || this.forwardxy.length != this.forward.length || this.backwardxy == null || this.backwardxy.length != this.backward.length) {
                            this.forwardxy = null;
                            this.backwardxy = null;
                            this.backwardxy = new int[this.backward.length];
                            this.forwardxy = new int[this.forward.length];
                        }
                        if (this.sexy == null || this.sexy.length != this.se.length) {
                            this.sexy = null;
                            this.sexy = new int[this.se.length];
                        }
                        for (i2 = 0; i2 < this.backward.length; ++i2) {
                            this.backwardxy[i2] = this.backward[i2].X + this.backward[i2].Y * this.width;
                            this.forwardxy[i2] = this.forward[i2].X + this.forward[i2].Y * this.width;
                        }
                        for (i2 = 0; i2 < this.se.length; ++i2) {
                            this.sexy[i2] = this.se[i2].X + this.se[i2].Y * this.width;
                        }
                    }
                    if (this.Hist == null || this.Hist.length != 256) {
                        this.Hist = null;
                        this.Hist = new int[256];
                    }
                    this.bytebufferin = ((DataBufferByte)Original.getRaster().getDataBuffer()).getData();
                    this.bytebufferout = ((DataBufferByte)Result.getRaster().getDataBuffer()).getData();
                    break;
                }
                case 11: {
                    if (this.stel == null || !this.stel.equals(SE)) {
                        int i3;
                        if (this.forwardxy == null || this.forwardxy.length != this.forward.length || this.backwardxy == null || this.backwardxy.length != this.backward.length) {
                            this.forwardxy = null;
                            this.backwardxy = null;
                            this.backwardxy = new int[this.backward.length];
                            this.forwardxy = new int[this.forward.length];
                        }
                        if (this.sexy == null || this.sexy.length != this.se.length) {
                            this.sexy = null;
                            this.sexy = new int[this.se.length];
                        }
                        for (i3 = 0; i3 < this.backward.length; ++i3) {
                            this.backwardxy[i3] = this.backward[i3].X + this.backward[i3].Y * this.width;
                            this.forwardxy[i3] = this.forward[i3].X + this.forward[i3].Y * this.width;
                        }
                        for (i3 = 0; i3 < this.se.length; ++i3) {
                            this.sexy[i3] = this.se[i3].X + this.se[i3].Y * this.width;
                        }
                    }
                    this.shortbufferin = ((DataBufferUShort)Original.getRaster().getDataBuffer()).getData();
                    this.shortbufferout = ((DataBufferUShort)Result.getRaster().getDataBuffer()).getData();
                    if (this.Hist != null && this.Hist.length == 65536) break;
                    this.Hist = null;
                    this.Hist = new int[65536];
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported image type.");
                }
            }
            this.stel = SE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            coord = null;
            block9: while (true) lbl-1000:
            // 3 sources

            {
                var9_10 = this.lock;
                synchronized (var9_10) {
                    try {
                        RankFV.this.addFreeThread();
                        this.lock.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                if (this.Kill) {
                    return;
                }
                MinX = this.minx < this.order ? this.order : this.minx;
                MinY = this.miny < this.order ? this.order : this.miny;
                MaxX = this.maxx >= this.width - this.order ? this.width - this.order : this.maxx;
                MaxY = this.maxy >= this.height - this.order ? this.height - this.order : this.maxy;
                switch (this.type) {
                    case 10: {
                        i = this.miny;
                        pos = this.miny * this.width;
                        while (true) {
                            if (i >= this.maxy) ** GOTO lbl-1000
                            if (i < MinY || MaxY <= i) {
                                size = 0;
                                this.maxi = 0;
                                this.mini = 255;
                                for (l = 0; l < this.length; ++l) {
                                    coord = this.se[l];
                                    if (0 > coord.X || 0 > i + coord.Y || i + coord.Y >= this.height || (v = this.bytebufferin[pos + this.sexy[l]] & 255) == RankFV.this.ForbiddenValue) continue;
                                    v0 = v;
                                    this.Hist[v0] = this.Hist[v0] + 1;
                                    if (this.maxi < v) {
                                        this.maxi = v;
                                    }
                                    if (this.mini > v) {
                                        this.mini = v;
                                    }
                                    ++size;
                                }
                                posrank = (int)(this.rankdouble * (double)size);
                                this.FindFlagLevel(posrank, size);
                                this.bytebufferout[pos] = (byte)this.flag;
                                for (j = 1; j < MinX + 1; ++j) {
                                    for (l = 0; l < this.forward.length; ++l) {
                                        coord = this.forward[l];
                                        if (0 > j + coord.X || 0 > i + coord.Y || i + coord.Y >= this.height || (v = this.bytebufferin[pos + this.forwardxy[l] + j] & 255) == RankFV.this.ForbiddenValue) continue;
                                        v1 = v;
                                        this.Hist[v1] = this.Hist[v1] + 1;
                                        if (this.maxi < v) {
                                            this.maxi = v;
                                        }
                                        if (this.mini > v) {
                                            this.mini = v;
                                        }
                                        ++size;
                                    }
                                    for (l = 0; l < this.backward.length; ++l) {
                                        coord = this.backward[l];
                                        if (0 > j + coord.X || 0 > i + coord.Y || i + coord.Y >= this.height || (v = this.bytebufferin[pos + this.backwardxy[l] + j] & 255) == RankFV.this.ForbiddenValue) continue;
                                        v2 = v;
                                        this.Hist[v2] = this.Hist[v2] - 1;
                                        if (--size > 0) {
                                            while (this.Hist[this.maxi] == 0) {
                                                --this.maxi;
                                            }
                                            while (this.Hist[this.mini] == 0) {
                                                ++this.mini;
                                            }
                                            continue;
                                        }
                                        this.maxi = 0;
                                        this.mini = 255;
                                    }
                                    posrank = (int)(this.rankdouble * (double)size);
                                    this.FindFlagLevel(posrank, size);
                                    this.bytebufferout[pos + j] = (byte)this.flag;
                                }
                                while (j < MaxX) {
                                    for (l = 0; l < this.forward.length; ++l) {
                                        coord = this.forward[l];
                                        if (0 > i + coord.Y || i + coord.Y >= this.height || (v = this.bytebufferin[pos + this.forwardxy[l] + j] & 255) == RankFV.this.ForbiddenValue) continue;
                                        v3 = v;
                                        this.Hist[v3] = this.Hist[v3] + 1;
                                        if (this.maxi < v) {
                                            this.maxi = v;
                                        }
                                        if (this.mini > v) {
                                            this.mini = v;
                                        }
                                        ++size;
                                    }
                                    for (l = 0; l < this.backward.length; ++l) {
                                        coord = this.backward[l];
                                        if (0 > i + coord.Y || i + coord.Y >= this.height || (v = this.bytebufferin[pos + this.backwardxy[l] + j] & 255) == RankFV.this.ForbiddenValue) continue;
                                        v4 = v;
                                        this.Hist[v4] = this.Hist[v4] - 1;
                                        if (--size > 0) {
                                            while (this.Hist[this.maxi] == 0) {
                                                --this.maxi;
                                            }
                                            while (this.Hist[this.mini] == 0) {
                                                ++this.mini;
                                            }
                                            continue;
                                        }
                                        this.maxi = 0;
                                        this.mini = 255;
                                    }
                                    posrank = (int)(this.rankdouble * (double)size);
                                    this.FindFlagLevel(posrank, size);
                                    this.bytebufferout[pos + j] = (byte)this.flag;
                                    ++j;
                                }
                                while (j < this.maxx) {
                                    for (l = 0; l < this.forward.length; ++l) {
                                        coord = this.forward[l];
                                        if (j + coord.X >= this.width || 0 > i + coord.Y || i + coord.Y >= this.height || (v = this.bytebufferin[pos + this.forwardxy[l] + j] & 255) == RankFV.this.ForbiddenValue) continue;
                                        v5 = v;
                                        this.Hist[v5] = this.Hist[v5] + 1;
                                        if (this.maxi < v) {
                                            this.maxi = v;
                                        }
                                        if (this.mini > v) {
                                            this.mini = v;
                                        }
                                        ++size;
                                    }
                                    for (l = 0; l < this.backward.length; ++l) {
                                        coord = this.backward[l];
                                        if (j + coord.X >= this.width || 0 > i + coord.Y || i + coord.Y >= this.height || (v = this.bytebufferin[pos + this.backwardxy[l] + j] & 255) == RankFV.this.ForbiddenValue) continue;
                                        v6 = v;
                                        this.Hist[v6] = this.Hist[v6] - 1;
                                        if (--size > 0) {
                                            while (this.Hist[this.maxi] == 0) {
                                                --this.maxi;
                                            }
                                            while (this.Hist[this.mini] == 0) {
                                                ++this.mini;
                                            }
                                            continue;
                                        }
                                        this.maxi = 0;
                                        this.mini = 255;
                                    }
                                    posrank = (int)(this.rankdouble * (double)size);
                                    this.FindFlagLevel(posrank, size);
                                    this.bytebufferout[pos + j] = (byte)this.flag;
                                    ++j;
                                }
                                Arrays.fill(this.Hist, 0);
                            } else {
                                size = 0;
                                this.maxi = 0;
                                this.mini = 255;
                                for (l = 0; l < this.length; ++l) {
                                    coord = this.se[l];
                                    if (0 > coord.X || (v = this.bytebufferin[pos + this.sexy[l]] & 255) == RankFV.this.ForbiddenValue) continue;
                                    v7 = v;
                                    this.Hist[v7] = this.Hist[v7] + 1;
                                    if (this.maxi < v) {
                                        this.maxi = v;
                                    }
                                    if (this.mini > v) {
                                        this.mini = v;
                                    }
                                    ++size;
                                }
                                posrank = (int)(this.rankdouble * (double)size);
                                this.FindFlagLevel(posrank, size);
                                this.bytebufferout[pos] = (byte)this.flag;
                                for (j = 1; j < MinX + 1; ++j) {
                                    for (l = 0; l < this.forward.length; ++l) {
                                        coord = this.forward[l];
                                        v = this.bytebufferin[pos + this.forwardxy[l] + j] & 255;
                                        if (v == RankFV.this.ForbiddenValue) continue;
                                        v8 = v;
                                        this.Hist[v8] = this.Hist[v8] + 1;
                                        if (this.maxi < v) {
                                            this.maxi = v;
                                        }
                                        if (this.mini > v) {
                                            this.mini = v;
                                        }
                                        ++size;
                                    }
                                    for (l = 0; l < this.backward.length; ++l) {
                                        coord = this.backward[l];
                                        if (j + coord.X < 0 || (v = this.bytebufferin[pos + this.backwardxy[l] + j] & 255) == RankFV.this.ForbiddenValue) continue;
                                        v9 = v;
                                        this.Hist[v9] = this.Hist[v9] - 1;
                                        if (--size > 0) {
                                            while (this.Hist[this.maxi] == 0) {
                                                --this.maxi;
                                            }
                                            while (this.Hist[this.mini] == 0) {
                                                ++this.mini;
                                            }
                                            continue;
                                        }
                                        this.maxi = 0;
                                        this.mini = 255;
                                    }
                                    posrank = (int)(this.rankdouble * (double)size);
                                    this.FindFlagLevel(posrank, size);
                                    this.bytebufferout[pos + j] = (byte)this.flag;
                                }
                                while (j < MaxX) {
                                    for (l = 0; l < this.forward.length; ++l) {
                                        coord = this.forward[l];
                                        v = this.bytebufferin[pos + this.forwardxy[l] + j] & 255;
                                        if (v == RankFV.this.ForbiddenValue) continue;
                                        v10 = v;
                                        this.Hist[v10] = this.Hist[v10] + 1;
                                        if (this.maxi < v) {
                                            this.maxi = v;
                                        }
                                        if (this.mini > v) {
                                            this.mini = v;
                                        }
                                        ++size;
                                    }
                                    for (l = 0; l < this.backward.length; ++l) {
                                        coord = this.backward[l];
                                        v = this.bytebufferin[pos + this.backwardxy[l] + j] & 255;
                                        if (v == RankFV.this.ForbiddenValue) continue;
                                        v11 = v;
                                        this.Hist[v11] = this.Hist[v11] - 1;
                                        if (--size > 0) {
                                            while (this.Hist[this.maxi] == 0) {
                                                --this.maxi;
                                            }
                                            while (this.Hist[this.mini] == 0) {
                                                ++this.mini;
                                            }
                                            continue;
                                        }
                                        this.maxi = 0;
                                        this.mini = 255;
                                    }
                                    posrank = (int)(this.rankdouble * (double)size);
                                    this.FindFlagLevel(posrank, size);
                                    this.bytebufferout[pos + j] = (byte)this.flag;
                                    ++j;
                                }
                                while (j < this.maxx) {
                                    for (l = 0; l < this.forward.length; ++l) {
                                        coord = this.forward[l];
                                        if (j + coord.X >= this.width || (v = this.bytebufferin[pos + this.forwardxy[l] + j] & 255) == RankFV.this.ForbiddenValue) continue;
                                        v12 = v;
                                        this.Hist[v12] = this.Hist[v12] + 1;
                                        if (this.maxi < v) {
                                            this.maxi = v;
                                        }
                                        if (this.mini > v) {
                                            this.mini = v;
                                        }
                                        ++size;
                                    }
                                    for (l = 0; l < this.backward.length; ++l) {
                                        coord = this.backward[l];
                                        v = this.bytebufferin[pos + this.backwardxy[l] + j] & 255;
                                        if (v == RankFV.this.ForbiddenValue) continue;
                                        v13 = v;
                                        this.Hist[v13] = this.Hist[v13] - 1;
                                        if (--size > 0) {
                                            while (this.Hist[this.maxi] == 0) {
                                                --this.maxi;
                                            }
                                            while (this.Hist[this.mini] == 0) {
                                                ++this.mini;
                                            }
                                            continue;
                                        }
                                        this.maxi = 0;
                                        this.mini = 255;
                                    }
                                    posrank = (int)(this.rankdouble * (double)size);
                                    this.FindFlagLevel(posrank, size);
                                    this.bytebufferout[pos + j] = (byte)this.flag;
                                    ++j;
                                }
                                Arrays.fill(this.Hist, 0);
                            }
                            ++i;
                            pos += this.width;
                        }
                    }
                    case 11: {
                        i = this.miny;
                        pos = this.miny * this.width;
                        while (true) {
                            if (i >= this.maxy) continue block9;
                            if (i < MinY || MaxY <= i) {
                                size = 0;
                                this.maxi = 0;
                                this.mini = 65535;
                                for (l = 0; l < this.length; ++l) {
                                    coord = this.se[l];
                                    if (0 > coord.X || 0 > i + coord.Y || i + coord.Y >= this.height || (v = this.shortbufferin[pos + this.sexy[l]] & 65535) == RankFV.this.ForbiddenValue) continue;
                                    v14 = v;
                                    this.Hist[v14] = this.Hist[v14] + 1;
                                    if (this.maxi < v) {
                                        this.maxi = v;
                                    }
                                    if (this.mini > v) {
                                        this.mini = v;
                                    }
                                    ++size;
                                }
                                posrank = (int)(this.rankdouble * (double)size);
                                this.FindFlagLevel(posrank, size);
                                this.shortbufferout[pos] = (short)this.flag;
                                for (j = 1; j < MinX + 1; ++j) {
                                    for (l = 0; l < this.forward.length; ++l) {
                                        coord = this.forward[l];
                                        if (0 > coord.X || 0 > i + coord.Y || i + coord.Y >= this.height || (v = this.shortbufferin[pos + this.forwardxy[l] + j] & 65535) == RankFV.this.ForbiddenValue) continue;
                                        v15 = v;
                                        this.Hist[v15] = this.Hist[v15] + 1;
                                        if (this.maxi < v) {
                                            this.maxi = v;
                                        }
                                        if (this.mini > v) {
                                            this.mini = v;
                                        }
                                        ++size;
                                    }
                                    for (l = 0; l < this.backward.length; ++l) {
                                        coord = this.backward[l];
                                        if (0 > j + coord.X || 0 > i + coord.Y || i + coord.Y >= this.height || (v = this.shortbufferin[pos + this.backwardxy[l] + j] & 65535) == RankFV.this.ForbiddenValue) continue;
                                        v16 = v;
                                        this.Hist[v16] = this.Hist[v16] - 1;
                                        if (--size > 0) {
                                            while (this.Hist[this.maxi] == 0) {
                                                --this.maxi;
                                            }
                                            while (this.Hist[this.mini] == 0) {
                                                ++this.mini;
                                            }
                                            continue;
                                        }
                                        this.maxi = 0;
                                        this.mini = 65535;
                                    }
                                    posrank = (int)(this.rankdouble * (double)size);
                                    this.FindFlagLevel(posrank, size);
                                    this.shortbufferout[pos + j] = (short)this.flag;
                                }
                                while (j < MaxX) {
                                    for (l = 0; l < this.forward.length; ++l) {
                                        coord = this.forward[l];
                                        if (0 > i + coord.Y || i + coord.Y >= this.height || (v = this.shortbufferin[pos + this.forwardxy[l] + j] & 65535) == RankFV.this.ForbiddenValue) continue;
                                        v17 = v;
                                        this.Hist[v17] = this.Hist[v17] + 1;
                                        if (this.maxi < v) {
                                            this.maxi = v;
                                        }
                                        if (this.mini > v) {
                                            this.mini = v;
                                        }
                                        ++size;
                                    }
                                    for (l = 0; l < this.backward.length; ++l) {
                                        coord = this.backward[l];
                                        if (0 > i + coord.Y || i + coord.Y >= this.height || (v = this.shortbufferin[pos + this.backwardxy[l] + j] & 65535) == RankFV.this.ForbiddenValue) continue;
                                        v18 = v;
                                        this.Hist[v18] = this.Hist[v18] - 1;
                                        if (--size > 0) {
                                            while (this.Hist[this.maxi] == 0) {
                                                --this.maxi;
                                            }
                                            while (this.Hist[this.mini] == 0) {
                                                ++this.mini;
                                            }
                                            continue;
                                        }
                                        this.maxi = 0;
                                        this.mini = 65535;
                                    }
                                    posrank = (int)(this.rankdouble * (double)size);
                                    this.FindFlagLevel(posrank, size);
                                    this.shortbufferout[pos + j] = (short)this.flag;
                                    ++j;
                                }
                                while (j < this.maxx) {
                                    for (l = 0; l < this.forward.length; ++l) {
                                        coord = this.forward[l];
                                        if (j + coord.X >= this.width || 0 > i + coord.Y || i + coord.Y >= this.height || (v = this.shortbufferin[pos + this.forwardxy[l] + j] & 65535) == RankFV.this.ForbiddenValue) continue;
                                        v19 = v;
                                        this.Hist[v19] = this.Hist[v19] + 1;
                                        if (this.maxi < v) {
                                            this.maxi = v;
                                        }
                                        if (this.mini > v) {
                                            this.mini = v;
                                        }
                                        ++size;
                                    }
                                    for (l = 0; l < this.backward.length; ++l) {
                                        coord = this.backward[l];
                                        if (j + coord.X >= this.width || 0 > i + coord.Y || i + coord.Y >= this.height || (v = this.shortbufferin[pos + this.backwardxy[l] + j] & 65535) == RankFV.this.ForbiddenValue) continue;
                                        v20 = v;
                                        this.Hist[v20] = this.Hist[v20] - 1;
                                        if (--size > 0) {
                                            while (this.Hist[this.maxi] == 0) {
                                                --this.maxi;
                                            }
                                            while (this.Hist[this.mini] == 0) {
                                                ++this.mini;
                                            }
                                            continue;
                                        }
                                        this.maxi = 0;
                                        this.mini = 65535;
                                    }
                                    posrank = (int)(this.rankdouble * (double)size);
                                    this.FindFlagLevel(posrank, size);
                                    this.shortbufferout[pos + j] = (short)this.flag;
                                    ++j;
                                }
                                Arrays.fill(this.Hist, 0);
                            } else {
                                size = 0;
                                this.maxi = 0;
                                this.mini = 65535;
                                for (l = 0; l < this.length; ++l) {
                                    if (0 > this.se[l].X || (v = this.shortbufferin[pos + this.sexy[l]] & 65535) == RankFV.this.ForbiddenValue) continue;
                                    v21 = v;
                                    this.Hist[v21] = this.Hist[v21] + 1;
                                    if (this.maxi < v) {
                                        this.maxi = v;
                                    }
                                    if (this.mini > v) {
                                        this.mini = v;
                                    }
                                    ++size;
                                }
                                posrank = (int)(this.rankdouble * (double)size);
                                this.FindFlagLevel(posrank, size);
                                this.shortbufferout[pos] = (short)this.flag;
                                for (j = 1; j < MinX + 1; ++j) {
                                    for (l = 0; l < this.forward.length; ++l) {
                                        coord = this.forward[l];
                                        v = this.shortbufferin[pos + this.forwardxy[l] + j] & 65535;
                                        if (v == RankFV.this.ForbiddenValue) continue;
                                        v22 = v;
                                        this.Hist[v22] = this.Hist[v22] + 1;
                                        if (this.maxi < v) {
                                            this.maxi = v;
                                        }
                                        if (this.mini > v) {
                                            this.mini = v;
                                        }
                                        ++size;
                                    }
                                    for (l = 0; l < this.backward.length; ++l) {
                                        if (j + this.backward[l].X < 0 || (v = this.shortbufferin[pos + this.backwardxy[l] + j] & 65535) == RankFV.this.ForbiddenValue) continue;
                                        v23 = v;
                                        this.Hist[v23] = this.Hist[v23] - 1;
                                        if (--size > 0) {
                                            while (this.Hist[this.maxi] == 0) {
                                                --this.maxi;
                                            }
                                            while (this.Hist[this.mini] == 0) {
                                                ++this.mini;
                                            }
                                            continue;
                                        }
                                        this.maxi = 0;
                                        this.mini = 65535;
                                    }
                                    posrank = (int)(this.rankdouble * (double)size);
                                    this.FindFlagLevel(posrank, size);
                                    this.shortbufferout[pos + j] = (short)this.flag;
                                }
                                while (j < MaxX) {
                                    for (l = 0; l < this.forward.length; ++l) {
                                        v = this.shortbufferin[pos + this.forwardxy[l] + j] & 65535;
                                        if (v == RankFV.this.ForbiddenValue) continue;
                                        v24 = v;
                                        this.Hist[v24] = this.Hist[v24] + 1;
                                        if (this.maxi < v) {
                                            this.maxi = v;
                                        }
                                        if (this.mini > v) {
                                            this.mini = v;
                                        }
                                        ++size;
                                    }
                                    for (l = 0; l < this.backward.length; ++l) {
                                        v = this.shortbufferin[pos + this.backwardxy[l] + j] & 65535;
                                        if (v == RankFV.this.ForbiddenValue) continue;
                                        v25 = v;
                                        this.Hist[v25] = this.Hist[v25] - 1;
                                        if (--size > 0) {
                                            while (this.Hist[this.maxi] == 0) {
                                                --this.maxi;
                                            }
                                            while (this.Hist[this.mini] == 0) {
                                                ++this.mini;
                                            }
                                            continue;
                                        }
                                        this.maxi = 0;
                                        this.mini = 65535;
                                    }
                                    posrank = (int)(this.rankdouble * (double)size);
                                    this.FindFlagLevel(posrank, size);
                                    this.shortbufferout[pos + j] = (short)this.flag;
                                    ++j;
                                }
                                while (j < this.maxx) {
                                    for (l = 0; l < this.forward.length; ++l) {
                                        if (j + this.forward[l].X >= this.width || (v = this.shortbufferin[pos + this.forwardxy[l] + j] & 65535) == RankFV.this.ForbiddenValue) continue;
                                        v26 = v;
                                        this.Hist[v26] = this.Hist[v26] + 1;
                                        if (this.maxi < v) {
                                            this.maxi = v;
                                        }
                                        if (this.mini > v) {
                                            this.mini = v;
                                        }
                                        ++size;
                                    }
                                    for (l = 0; l < this.backward.length; ++l) {
                                        coord = this.backward[l];
                                        v = this.shortbufferin[pos + this.backwardxy[l] + j] & 65535;
                                        if (v == RankFV.this.ForbiddenValue) continue;
                                        v27 = v;
                                        this.Hist[v27] = this.Hist[v27] - 1;
                                        if (--size > 0) {
                                            while (this.Hist[this.maxi] == 0) {
                                                --this.maxi;
                                            }
                                            while (this.Hist[this.mini] == 0) {
                                                ++this.mini;
                                            }
                                            continue;
                                        }
                                        this.maxi = 0;
                                        this.mini = 65535;
                                    }
                                    posrank = (int)(this.rankdouble * (double)size);
                                    this.FindFlagLevel(posrank, size);
                                    this.shortbufferout[pos + j] = (short)this.flag;
                                    ++j;
                                }
                                Arrays.fill(this.Hist, 0);
                            }
                            ++i;
                            pos += this.width;
                        }
                    }
                }
                break;
            }
            throw new IllegalArgumentException("Color type not yet supported.");
        }

        private void FindFlagLevel(int posrank, int max) {
            int nb = -1;
            if (max == 0) {
                this.flag = 0;
                return;
            }
            if ((double)RankFV.this.rank < 0.5) {
                this.flag = this.mini;
                while (true) {
                    if (this.Hist[this.flag] == 0) {
                        ++this.flag;
                        continue;
                    }
                    this.level = 1;
                    ++nb;
                    while (this.level < this.Hist[this.flag] && nb < posrank) {
                        ++this.level;
                        ++nb;
                    }
                    if (nb >= posrank) break;
                    ++this.flag;
                }
                return;
            }
            this.flag = this.maxi;
            while (true) {
                if (this.Hist[this.flag] == 0) {
                    --this.flag;
                    continue;
                }
                this.level = 1;
                --max;
                while (this.level < this.Hist[this.flag] && posrank < max) {
                    ++this.level;
                    --max;
                }
                if (posrank >= max) break;
                --this.flag;
            }
        }
    }

    private class RankThread
    extends Thread {
        private WritableRaster wro = null;
        private WritableRaster wrr = null;
        private StructuringElement stel = null;
        private int order = 0;
        private int length = 0;
        private CoordinatesWeighted[] se = null;
        private int[] sexy = null;
        private int minx;
        private int miny;
        private int maxx;
        private int maxy;
        private int type;
        private int width;
        private int height;
        private int channel;
        private int widthchannel;
        private short[] shortbufferin = null;
        private short[] shortbufferout = null;
        private byte[] bytebufferin = null;
        private byte[] bytebufferout = null;
        public Object lock = new Object();
        private int[] buffer = null;
        private int FixN = 0;
        private boolean Kill = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void Kill() {
            this.stel = null;
            this.se = null;
            this.shortbufferin = null;
            this.shortbufferout = null;
            this.bytebufferin = null;
            this.bytebufferout = null;
            this.sexy = null;
            this.buffer = null;
            this.Kill = true;
            Object object = this.lock;
            synchronized (object) {
                this.lock.notify();
            }
        }

        public void setConditions(BufferedImage Original, BufferedImage Result, StructuringElement SE, int rank, int minx, int miny, int maxx, int maxy) {
            this.order = SE.getSize() >> 1;
            this.se = SE.getSE();
            this.length = this.se.length;
            this.minx = minx;
            this.miny = miny;
            this.maxx = maxx;
            this.maxy = maxy;
            this.width = Original.getWidth();
            this.height = Original.getHeight();
            this.type = Original.getType();
            if (this.buffer == null || this.buffer.length != this.length) {
                this.buffer = null;
                this.buffer = new int[this.length];
            }
            this.FixN = (int)((double)(this.length - 1) * (double)rank / 100.0 + 0.5);
            switch (rank) {
                case 0: {
                    this.FixN = 0;
                    break;
                }
                case 100: {
                    this.FixN = this.length - 1;
                    break;
                }
                case 75: {
                    this.FixN = 3 * this.length / 4;
                    break;
                }
                case 50: {
                    this.FixN = this.length / 2;
                    break;
                }
                case 25: {
                    this.FixN = this.length / 4;
                }
            }
            switch (Original.getType()) {
                case 1: 
                case 2: 
                case 4: {
                    this.wro = Original.getRaster();
                    this.wrr = Result.getRaster();
                    break;
                }
                case 10: {
                    if (this.stel == null || !this.stel.equals(SE)) {
                        if (this.sexy == null || this.sexy.length != this.se.length) {
                            this.sexy = null;
                            this.sexy = new int[this.se.length];
                        }
                        for (int i2 = 0; i2 < this.se.length; ++i2) {
                            this.sexy[i2] = this.se[i2].X + this.se[i2].Y * this.width;
                        }
                    }
                    this.bytebufferin = ((DataBufferByte)Original.getRaster().getDataBuffer()).getData();
                    this.bytebufferout = ((DataBufferByte)Result.getRaster().getDataBuffer()).getData();
                    break;
                }
                case 5: 
                case 6: {
                    this.channel = Original.getRaster().getNumBands();
                    this.widthchannel = this.width * this.channel;
                    if (this.stel == null || !this.stel.equals(SE)) {
                        if (this.sexy == null || this.sexy.length != this.se.length) {
                            this.sexy = null;
                            this.sexy = new int[this.se.length];
                        }
                        for (int i3 = 0; i3 < this.se.length; ++i3) {
                            this.sexy[i3] = this.se[i3].X * this.channel + this.se[i3].Y * this.widthchannel;
                        }
                    }
                    this.bytebufferin = ((DataBufferByte)Original.getRaster().getDataBuffer()).getData();
                    this.bytebufferout = ((DataBufferByte)Result.getRaster().getDataBuffer()).getData();
                    break;
                }
                case 11: {
                    if (this.stel == null || !this.stel.equals(SE)) {
                        if (this.sexy == null || this.sexy.length != this.se.length) {
                            this.sexy = null;
                            this.sexy = new int[this.se.length];
                        }
                        for (int i4 = 0; i4 < this.se.length; ++i4) {
                            this.sexy[i4] = this.se[i4].X + this.se[i4].Y * this.width;
                        }
                    }
                    this.shortbufferin = ((DataBufferUShort)Original.getRaster().getDataBuffer()).getData();
                    this.shortbufferout = ((DataBufferUShort)Result.getRaster().getDataBuffer()).getData();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported image type.");
                }
            }
            this.stel = SE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            coord = null;
            block11: while (true) {
                var9_10 = this.lock;
                synchronized (var9_10) {
                    try {
                        RankFV.this.addFreeThread();
                        this.lock.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                if (this.Kill) {
                    return;
                }
                MinX = this.minx < this.order ? this.order : this.minx;
                MinY = this.miny < this.order ? this.order : this.miny;
                MaxX = this.maxx >= this.width - this.order ? this.width - this.order : this.maxx;
                MaxY = this.maxy >= this.height - this.order ? this.height - this.order : this.maxy;
                switch (this.type) {
                    case 10: {
                        i = MinY;
                        pos = MinY * this.width;
                        while (i < MaxY) {
                            for (j = MinX; j < MaxX; ++j) {
                                nb = 0;
                                for (l = 0; l < this.length; ++l) {
                                    v = this.bytebufferin[pos + this.sexy[l] + j] & 255;
                                    if (v == RankFV.this.ForbiddenValue) continue;
                                    this.buffer[nb++] = v;
                                }
                                this.bytebufferout[pos + j] = (byte)(nb == this.length ? this.SortAndFind() : this.SortAndFind(nb));
                            }
                            ++i;
                            pos += this.width;
                        }
                        i = this.miny;
                        pos = this.miny * this.width;
                        while (true) {
                            if (i >= this.maxy) continue block11;
                            for (j = this.minx; j < this.maxx; ++j) {
                                if (i >= this.order && j >= this.order && i < this.height - this.order && j < this.width - this.order) continue;
                                nb = 0;
                                for (l = 0; l < this.length; ++l) {
                                    coord = this.se[l];
                                    if (i + coord.Y < 0 || i + coord.Y >= this.height || j + coord.X < 0 || j + coord.X >= this.width || (v = this.bytebufferin[pos + this.sexy[l] + j] & 255) == RankFV.this.ForbiddenValue) continue;
                                    this.buffer[nb++] = v;
                                }
                                this.bytebufferout[pos + j] = (byte)this.SortAndFind(nb);
                            }
                            ++i;
                            pos += this.width;
                        }
                    }
                    case 5: 
                    case 6: {
                        c = 0;
                        while (true) {
                            if (c >= this.channel) continue block11;
                            i = MinY;
                            pos = MinY * this.widthchannel;
                            while (i < MaxY) {
                                j = MinX;
                                jchannel = j * this.channel;
                                while (j < MaxX) {
                                    nb = 0;
                                    for (l = 0; l < this.length; ++l) {
                                        v = this.bytebufferin[pos + this.sexy[l] + jchannel + c] & 255;
                                        if (v == RankFV.this.ForbiddenValue) continue;
                                        this.buffer[nb++] = v;
                                    }
                                    this.bytebufferout[pos + jchannel + c] = (byte)(nb == this.length ? this.SortAndFind() : this.SortAndFind(nb));
                                    ++j;
                                    jchannel += this.channel;
                                }
                                ++i;
                                pos += this.widthchannel;
                            }
                            i = this.miny;
                            pos = this.miny * this.widthchannel;
                            while (i < this.maxy) {
                                j = this.minx;
                                jchannel = j * this.channel;
                                while (j < this.maxx) {
                                    if (i < this.order || j < this.order || i >= this.height - this.order || j >= this.width - this.order) {
                                        nb = 0;
                                        for (l = 0; l < this.length; ++l) {
                                            coord = this.se[l];
                                            if (i + coord.Y < 0 || i + coord.Y >= this.height || j + coord.X < 0 || j + coord.X >= this.width || (v = this.bytebufferin[pos + this.sexy[l] + jchannel + c] & 255) == RankFV.this.ForbiddenValue) continue;
                                            this.buffer[nb++] = v;
                                        }
                                        this.bytebufferout[pos + jchannel + c] = (byte)this.SortAndFind(nb);
                                    }
                                    ++j;
                                    jchannel += this.channel;
                                }
                                ++i;
                                pos += this.widthchannel;
                            }
                            ++c;
                        }
                    }
                    case 11: {
                        i = MinY;
                        pos = MinY * this.width;
                        while (i < MaxY) {
                            for (j = MinX; j < MaxX; ++j) {
                                nb = 0;
                                for (l = 0; l < this.length; ++l) {
                                    v = this.shortbufferin[pos + this.sexy[l] + j] & 65535;
                                    if (v == RankFV.this.ForbiddenValue) continue;
                                    this.buffer[nb++] = v;
                                }
                                this.shortbufferout[pos + j] = (short)(nb == this.length ? this.SortAndFind() : this.SortAndFind(nb));
                            }
                            ++i;
                            pos += this.width;
                        }
                        i = this.miny;
                        pos = this.miny * this.width;
                        while (true) {
                            if (i >= this.maxy) continue block11;
                            for (j = this.minx; j < this.maxx; ++j) {
                                if (i >= this.order && j >= this.order && i < this.height - this.order && j < this.width - this.order) continue;
                                nb = 0;
                                for (l = 0; l < this.length; ++l) {
                                    coord = this.se[l];
                                    if (i + coord.Y < 0 || i + coord.Y >= this.height || j + coord.X < 0 || j + coord.X >= this.width || (v = this.shortbufferin[pos + this.sexy[l] + j] & 65535) == RankFV.this.ForbiddenValue) continue;
                                    this.buffer[nb++] = v;
                                }
                                this.shortbufferout[pos + j] = (short)this.SortAndFind(nb);
                            }
                            ++i;
                            pos += this.width;
                        }
                    }
                    case 1: 
                    case 2: 
                    case 4: {
                        for (i = MinY; i < MaxY; ++i) {
                            for (j = MinX; j < MaxX; ++j) {
                                for (c = 0; c < this.channel; ++c) {
                                    nb = 0;
                                    for (l = 0; l < this.length; ++l) {
                                        coord = this.se[l];
                                        v = this.wro.getSample(j + coord.X, i + coord.Y, c);
                                        if (v == RankFV.this.ForbiddenValue) continue;
                                        this.buffer[nb++] = v;
                                    }
                                    this.wrr.setSample(j, i, c, nb == this.length ? this.SortAndFind() : this.SortAndFind(nb));
                                }
                            }
                        }
                        i = this.miny;
                        while (true) {
                            if (i < this.maxy) ** break;
                            continue block11;
                            for (j = this.minx; j < this.maxx; ++j) {
                                if (i >= this.order && j >= this.order && i < this.height - this.order && j < this.width - this.order) continue;
                                for (c = 0; c < this.channel; ++c) {
                                    nb = 0;
                                    for (l = 0; l < this.length; ++l) {
                                        coord = this.se[l];
                                        if (i + coord.Y < 0 || i + coord.Y >= this.height || j + coord.X < 0 || j + coord.X >= this.width || (v = this.wro.getSample(j + coord.X, i + coord.Y, c)) == RankFV.this.ForbiddenValue) continue;
                                        this.buffer[nb++] = v;
                                    }
                                    this.wrr.setSample(j, i, c, this.SortAndFind(nb));
                                }
                            }
                            ++i;
                        }
                    }
                }
                break;
            }
            throw new IllegalArgumentException("Color type not yet supported.");
        }

        private int SortAndFind() {
            Arrays.sort(this.buffer);
            if (RankFV.this.rank != -1) {
                return this.buffer[this.FixN];
            }
            double k = 0.0;
            double cste = this.buffer[this.length - 1] - this.buffer[0];
            for (int i2 = 0; i2 < this.length; ++i2) {
                k += (double)this.buffer[i2] - (double)this.buffer[0] - cste * (double)i2 / (double)this.length;
            }
            k /= (double)this.length * cste;
            int r = (int)((double)this.length * (k += 0.5));
            return this.buffer[r];
        }

        private int SortAndFind(int N) {
            if (N == 0) {
                return 0;
            }
            Arrays.sort(this.buffer, 0, N);
            switch (RankFV.this.rank) {
                case 0: {
                    return this.buffer[0];
                }
                case 100: {
                    return this.buffer[N - 1];
                }
                case 75: {
                    return this.buffer[3 * N / 4];
                }
                case 50: {
                    return this.buffer[N / 2];
                }
                case 25: {
                    return this.buffer[N / 4];
                }
                case -1: {
                    double k = 0.0;
                    double cste = this.buffer[N] - this.buffer[0];
                    for (int i2 = 0; i2 < N; ++i2) {
                        k += (double)this.buffer[i2] - (double)this.buffer[0] - cste * (double)i2 / (double)N;
                    }
                    k /= (double)N * cste;
                    int r = (int)((double)N * (k += 0.5));
                    return this.buffer[r];
                }
            }
            return this.buffer[RankFV.this.rank * N / 100];
        }
    }
}

