/*
 * Decompiled with CFR 0.152.
 */
package morphee.rank;

import arrayTiTi.ArrayNew;
import dv.DV;
import dv.DvNew;
import dv.DvTools;
import imageTiTi.ImageNew;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.util.List;
import morphee.MorphoFilter;
import morphee.StructuringElement;
import morphee.StructuringElement3D;
import morphee.rank.Rank;

public class RankCloseOpen
implements MorphoFilter {
    public static final int MAX = 100;
    public static final int QUARTILE1 = 75;
    public static final int MEDIAN = 50;
    public static final int QUARTILE3 = 25;
    public static final int MIN = 0;
    private Rank rankfilter = new Rank();
    private StructuringElement SE = null;
    private StructuringElement3D SE3 = null;
    private int rank = -1;
    private BufferedImage temp = null;
    private DV tmpdv = null;
    private byte[] bytetmp = null;
    private short[] shorttmp = null;
    private int[] inttmp = null;
    private double[] doubletmp = null;

    public BufferedImage Filter(BufferedImage source, StructuringElement se, int nbCPU) {
        this.setStructuringElement(se);
        return this.Filter(source, nbCPU);
    }

    public void Filter(BufferedImage source, StructuringElement se, BufferedImage result, int nbCPU) {
        this.setStructuringElement(se);
        this.Filter(source, result, nbCPU);
    }

    public BufferedImage Filter(BufferedImage source, int nbCPU) {
        BufferedImage result = ImageNew.Same((BufferedImage)source);
        this.Filter(source, result, nbCPU);
        return result;
    }

    public void Filter(BufferedImage source, BufferedImage result, int nbCPU) {
        if (this.SE == null) {
            throw new IllegalArgumentException("Structuring element is not defined.");
        }
        if (this.rank < 0) {
            throw new IllegalArgumentException("Rank is not defined.");
        }
        this.Filter(source, this.SE, this.rank, result, nbCPU);
    }

    public void Filter(BufferedImage source, StructuringElement se, int rank, BufferedImage result, int nbCPU) {
        if (nbCPU < 1) {
            throw new IllegalArgumentException("nbCPU < 1.");
        }
        if (!ImageTools.areDimensionsAndTypeEqual((BufferedImage)source, (BufferedImage)result)) {
            throw new IllegalArgumentException("Images source and result must have identic dimensions and types.");
        }
        this.setStructuringElement(se);
        if (this.temp == null || !ImageTools.areDimensionsAndTypeEqual((BufferedImage)source, (BufferedImage)this.temp)) {
            this.temp = null;
            this.temp = ImageNew.Same((BufferedImage)source);
        }
        this.rankfilter.Filter(source, this.SE, rank, this.temp, nbCPU);
        this.rankfilter.Filter(this.temp, this.SE, 100 - rank, result, nbCPU);
    }

    public StructuringElement getStructuringElement() {
        return this.SE;
    }

    public void setStructuringElement(StructuringElement SE) {
        this.SE = SE;
    }

    public DV Filter(DV source, int nbCPU) {
        DV result = DvNew.Same((DV)source);
        this.Filter(source, result, nbCPU);
        return result;
    }

    public DV Filter(DV source, StructuringElement3D se, int nbCPU) {
        this.setStructuringElement3D(se);
        return this.Filter(source, nbCPU);
    }

    public void Filter(DV source, StructuringElement3D se, DV result, int nbCPU) {
        this.setStructuringElement3D(se);
        this.Filter(source, result, nbCPU);
    }

    public void Filter(DV source, DV result, int nbCPU) {
        if (this.SE3 == null) {
            throw new IllegalArgumentException("The Structuring element is not defined.");
        }
        if (this.rank < 0) {
            throw new IllegalArgumentException("The Rank is not defined.");
        }
        this.Filter(source, this.SE3, this.rank, result, nbCPU);
    }

    public void Filter(DV source, StructuringElement3D se, int rank, DV result, int nbCPU) {
        if (nbCPU < 1) {
            throw new IllegalArgumentException("nbCPU < 1.");
        }
        if (!DvTools.areDimensionsAndTypeEqual((DV)source, (DV)result)) {
            throw new IllegalArgumentException("DV source and result must have identic dimensions and types.");
        }
        this.setStructuringElement3D(se);
        if (this.tmpdv == null || !DvTools.areDimensionsAndTypeEqual((DV)source, (DV)this.tmpdv)) {
            this.tmpdv = null;
            this.tmpdv = DvNew.Same((DV)source);
        }
        this.rankfilter.Filter(source, this.SE3, rank, this.tmpdv, nbCPU);
        this.rankfilter.Filter(this.tmpdv, this.SE3, 100 - rank, result, nbCPU);
    }

    public StructuringElement3D getStructuringElement3D() {
        return this.rankfilter.getStructuringElement3D();
    }

    public void setStructuringElement3D(StructuringElement3D se) {
        this.rankfilter.setStructuringElement3D(this.SE3);
    }

    public byte[] Filter(byte[] source, StructuringElement SE, int rank, int nbCPU) {
        this.setStructuringElement(SE);
        this.rank = rank;
        return this.Filter(source, nbCPU);
    }

    public byte[] Filter(byte[] source, int rank, int nbCPU) {
        byte[] result = ArrayNew.Same((byte[])source);
        this.rank = rank;
        this.Filter(source, result, nbCPU);
        return result;
    }

    public void Filter(byte[] source, StructuringElement SE, int rank, byte[] result, int nbCPU) {
        this.setStructuringElement(SE);
        this.rank = rank;
        this.Filter(source, result, nbCPU);
    }

    public void Filter(byte[] source, int rank, byte[] result, int nbCPU) {
        this.rank = rank;
        this.Filter(source, result, nbCPU);
    }

    public byte[] Filter(byte[] source, StructuringElement SE, int nbCPU) {
        this.setStructuringElement(SE);
        return this.Filter(source, nbCPU);
    }

    public byte[] Filter(byte[] source, int nbCPU) {
        byte[] result = ArrayNew.Same((byte[])source);
        this.Filter(source, result, nbCPU);
        return result;
    }

    public void Filter(byte[] source, StructuringElement SE, byte[] result, int nbCPU) {
        this.setStructuringElement(SE);
        this.Filter(source, result, nbCPU);
    }

    public void Filter(byte[] source, byte[] result, int nbCPU) {
        if (this.SE == null) {
            throw new IllegalArgumentException("Any structuring element defined.");
        }
        if (source.length != result.length) {
            throw new IllegalArgumentException("Arrays source and result must have equal dimension.");
        }
        if (this.SE.getType() != -5) {
            throw new IllegalArgumentException("The structuring element must be of type HORIZONTAL.");
        }
        if (this.bytetmp == null || source.length != this.bytetmp.length) {
            this.bytetmp = null;
            this.bytetmp = ArrayNew.Same((byte[])source);
        }
        this.rankfilter.Filter(source, this.SE, this.rank, this.bytetmp, nbCPU);
        this.rankfilter.Filter(this.bytetmp, this.SE, 100 - this.rank, result, nbCPU);
    }

    public short[] Filter(short[] source, StructuringElement SE, int rank, int nbCPU) {
        this.setStructuringElement(SE);
        this.rank = rank;
        return this.Filter(source, nbCPU);
    }

    public short[] Filter(short[] source, int rank, int nbCPU) {
        short[] result = ArrayNew.Same((short[])source);
        this.rank = rank;
        this.Filter(source, result, nbCPU);
        return result;
    }

    public void Filter(short[] source, StructuringElement SE, int rank, short[] result, int nbCPU) {
        this.setStructuringElement(SE);
        this.rank = rank;
        this.Filter(source, result, nbCPU);
    }

    public void Filter(short[] source, int rank, short[] result, int nbCPU) {
        this.rank = rank;
        this.Filter(source, result, nbCPU);
    }

    public short[] Filter(short[] source, StructuringElement SE, int nbCPU) {
        this.setStructuringElement(SE);
        return this.Filter(source, nbCPU);
    }

    public short[] Filter(short[] source, int nbCPU) {
        short[] result = ArrayNew.Same((short[])source);
        this.Filter(source, result, nbCPU);
        return result;
    }

    public void Filter(short[] source, StructuringElement SE, short[] result, int nbCPU) {
        this.setStructuringElement(SE);
        this.Filter(source, result, nbCPU);
    }

    public void Filter(short[] source, short[] result, int nbCPU) {
        if (this.SE == null) {
            throw new IllegalArgumentException("Any structuring element defined.");
        }
        if (source.length != result.length) {
            throw new IllegalArgumentException("Arrays source and result must have equal dimension.");
        }
        if (this.SE.getType() != -5) {
            throw new IllegalArgumentException("The structuring element must be of type HORIZONTAL.");
        }
        if (this.shorttmp == null || source.length != this.shorttmp.length) {
            this.shorttmp = null;
            this.shorttmp = ArrayNew.Same((short[])source);
        }
        this.rankfilter.Filter(source, this.SE, this.rank, this.shorttmp, nbCPU);
        this.rankfilter.Filter(this.shorttmp, this.SE, 100 - this.rank, result, nbCPU);
    }

    public int[] Filter(int[] source, StructuringElement SE, int rank, int nbCPU) {
        this.setStructuringElement(SE);
        this.rank = rank;
        return this.Filter(source, nbCPU);
    }

    public int[] Filter(int[] source, int rank, int nbCPU) {
        int[] result = ArrayNew.Same((int[])source);
        this.rank = rank;
        this.Filter(source, result, nbCPU);
        return result;
    }

    public void Filter(int[] source, StructuringElement SE, int rank, int[] result, int nbCPU) {
        this.setStructuringElement(SE);
        this.rank = rank;
        this.Filter(source, result, nbCPU);
    }

    public void Filter(int[] source, int rank, int[] result, int nbCPU) {
        this.rank = rank;
        this.Filter(source, result, nbCPU);
    }

    public int[] Filter(int[] source, StructuringElement SE, int nbCPU) {
        this.setStructuringElement(SE);
        return this.Filter(source, nbCPU);
    }

    public int[] Filter(int[] source, int nbCPU) {
        int[] result = ArrayNew.Same((int[])source);
        this.Filter(source, result, nbCPU);
        return result;
    }

    public void Filter(int[] source, StructuringElement SE, int[] result, int nbCPU) {
        this.setStructuringElement(SE);
        this.Filter(source, result, nbCPU);
    }

    public void Filter(int[] source, int[] result, int nbCPU) {
        if (this.SE == null) {
            throw new IllegalArgumentException("Any structuring element defined.");
        }
        if (source.length != result.length) {
            throw new IllegalArgumentException("Arrays source and result must have equal dimension.");
        }
        if (this.SE.getType() != -5) {
            throw new IllegalArgumentException("The structuring element must be of type HORIZONTAL.");
        }
        if (this.inttmp == null || source.length != this.inttmp.length) {
            this.inttmp = null;
            this.inttmp = ArrayNew.Same((int[])source);
        }
        this.rankfilter.Filter(source, this.SE, this.rank, this.inttmp, nbCPU);
        this.rankfilter.Filter(this.inttmp, this.SE, 100 - this.rank, result, nbCPU);
    }

    public double[] Filter(double[] source, StructuringElement SE, int rank, int nbCPU) {
        this.setStructuringElement(SE);
        this.rank = rank;
        return this.Filter(source, nbCPU);
    }

    public double[] Filter(double[] source, int rank, int nbCPU) {
        double[] result = ArrayNew.Same((double[])source);
        this.rank = rank;
        this.Filter(source, result, nbCPU);
        return result;
    }

    public void Filter(double[] source, StructuringElement SE, int rank, double[] result, int nbCPU) {
        this.setStructuringElement(SE);
        this.rank = rank;
        this.Filter(source, result, nbCPU);
    }

    public void Filter(double[] source, int rank, double[] result, int nbCPU) {
        this.rank = rank;
        this.Filter(source, result, nbCPU);
    }

    public double[] Filter(double[] source, StructuringElement SE, int nbCPU) {
        this.setStructuringElement(SE);
        return this.Filter(source, nbCPU);
    }

    public double[] Filter(double[] source, int nbCPU) {
        double[] result = ArrayNew.Same((double[])source);
        this.Filter(source, result, nbCPU);
        return result;
    }

    public void Filter(double[] source, StructuringElement SE, double[] result, int nbCPU) {
        this.setStructuringElement(SE);
        this.Filter(source, result, nbCPU);
    }

    public void Filter(double[] source, double[] result, int nbCPU) {
        if (this.SE == null) {
            throw new IllegalArgumentException("Any structuring element defined.");
        }
        if (source.length != result.length) {
            throw new IllegalArgumentException("Arrays source and result must have equal dimension.");
        }
        if (this.SE.getType() != -5) {
            throw new IllegalArgumentException("The structuring element must be of type HORIZONTAL.");
        }
        if (this.doubletmp == null || source.length != this.doubletmp.length) {
            this.doubletmp = null;
            this.doubletmp = ArrayNew.Same((double[])source);
        }
        this.rankfilter.Filter(source, this.SE, this.rank, this.doubletmp, nbCPU);
        this.rankfilter.Filter(this.doubletmp, this.SE, 100 - this.rank, result, nbCPU);
    }

    public void Parameters(Object ... parameters) {
        if (parameters.length != 2) {
            throw new IllegalArgumentException("Exactly 2 parameters required.");
        }
        if (parameters[0] instanceof StructuringElement) {
            this.setStructuringElement((StructuringElement)parameters[0]);
        } else if (parameters[0] instanceof StructuringElement3D) {
            this.setStructuringElement3D((StructuringElement3D)parameters[0]);
        } else {
            throw new IllegalArgumentException("The first parameter is not a structuring element.");
        }
        this.rank = (Integer)parameters[1];
        this.rankfilter.Parameters(parameters);
    }

    public List<Object> Parameters() {
        return this.rankfilter.Parameters();
    }

    public int BorderEffectSizeX() {
        return this.rankfilter.BorderEffectSizeX();
    }

    public int BorderEffectSizeY() {
        return this.rankfilter.BorderEffectSizeY();
    }

    public int BorderEffectSizeZ() {
        return this.rankfilter.BorderEffectSizeZ();
    }

    public MorphoFilter Clone() {
        RankCloseOpen clone = new RankCloseOpen();
        clone.Parameters(this.Parameters());
        return clone;
    }
}

