/*
 * Decompiled with CFR 0.152.
 */
package morphee.rank;

import arrayTiTi.ArrayNew;
import dv.DV;
import dv.DvNew;
import dv.DvTools;
import imageTiTi.ImageNew;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferUShort;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mathematics.primitives.pointsTiTi.CoordinatesWeighted;
import morphee.MorphoFilter;
import morphee.StructuringElement;
import morphee.StructuringElement3D;
import morphee.rank.fastRank.RankSegmentDiagonal135;
import morphee.rank.fastRank.RankSegmentDiagonal45;
import morphee.rank.fastRank.RankSegmentHorizontal;
import morphee.rank.fastRank.RankSegmentVertical;

public class Rank
implements MorphoFilter {
    public static final int MAX = 100;
    public static final int QUARTILE1 = 75;
    public static final int MEDIAN = 50;
    public static final int QUARTILE3 = 25;
    public static final int MIN = 0;
    public static final int ADAPTIVE = -1;
    private RankSegmentDiagonal135 rsd135 = new RankSegmentDiagonal135();
    private RankSegmentDiagonal45 rsd45 = new RankSegmentDiagonal45();
    private RankSegmentHorizontal rsh = new RankSegmentHorizontal();
    private RankSegmentVertical rsv = new RankSegmentVertical();
    private StructuringElement SE = null;
    private StructuringElement3D SE3 = null;
    private RankThread[] threads = null;
    private RankHeavyThread[] heavythreads = null;
    private Rank3dThread[] threads3d = null;
    private RankHeavy3dThread[] heavy3dthreads = null;
    private int nbFreeThreads = 0;
    private int rank = 50;
    private int[] intbuffer = null;
    private double[] doublebuffer = null;
    private int FixN = -1;

    public void Kill() {
        int i2;
        if (this.SE != null) {
            this.SE.Kill();
        }
        if (this.SE3 != null) {
            this.SE3.Kill();
        }
        if (this.threads != null) {
            for (i2 = 0; i2 < this.threads.length; ++i2) {
                this.threads[i2].Kill();
            }
            Arrays.fill(this.threads, null);
            this.threads = null;
        }
        if (this.heavythreads != null) {
            for (i2 = 0; i2 < this.heavythreads.length; ++i2) {
                this.heavythreads[i2].Kill();
            }
            Arrays.fill(this.heavythreads, null);
            this.heavythreads = null;
        }
        if (this.threads3d != null) {
            for (i2 = 0; i2 < this.threads3d.length; ++i2) {
                this.threads3d[i2].Kill();
            }
            Arrays.fill(this.threads3d, null);
            this.threads3d = null;
        }
        if (this.heavy3dthreads != null) {
            for (i2 = 0; i2 < this.heavy3dthreads.length; ++i2) {
                this.heavy3dthreads[i2].Kill();
            }
            Arrays.fill(this.heavy3dthreads, null);
            this.heavy3dthreads = null;
        }
        this.intbuffer = null;
        this.doublebuffer = null;
        this.rsd135.Kill();
        this.rsd45.Kill();
        this.rsh.Kill();
        this.rsv.Kill();
    }

    public BufferedImage Filter(BufferedImage source, StructuringElement SE, int rank, int nbCPU) {
        this.setStructuringElement(SE);
        this.SetRank(rank);
        return this.Filter(source, nbCPU);
    }

    public void Filter(BufferedImage source, StructuringElement SE, int rank, BufferedImage result, int nbCPU) {
        this.setStructuringElement(SE);
        this.SetRank(rank);
        this.Filter(source, result, nbCPU);
    }

    public BufferedImage Filter(BufferedImage source, StructuringElement se, int nbCPU) {
        this.setStructuringElement(se);
        return this.Filter(source, nbCPU);
    }

    public void Filter(BufferedImage source, StructuringElement se, BufferedImage result, int nbCPU) {
        this.setStructuringElement(se);
        this.Filter(source, result, nbCPU);
    }

    public BufferedImage Filter(BufferedImage source, int nbCPU) {
        BufferedImage result = ImageNew.Same((BufferedImage)source);
        this.Filter(source, result, nbCPU);
        return result;
    }

    public void Filter(BufferedImage source, BufferedImage result, int nbCPU) {
        if (nbCPU < 1) {
            throw new IllegalArgumentException("nbCPU < 1.");
        }
        if (this.SE == null) {
            throw new IllegalArgumentException("Any structuring element defined.");
        }
        if (!ImageTools.areDimensionsAndTypeEqual((BufferedImage)source, (BufferedImage)result)) {
            throw new IllegalArgumentException("Images source and result must have identic dimensions and types.");
        }
        if (source.getType() != 11 && this.SE.isIterable()) {
            switch (this.SE.getType()) {
                case -3: {
                    this.rsd135.Filter(source, this.SE.getSize(), this.rank, result, nbCPU);
                    return;
                }
                case -4: {
                    this.rsd45.Filter(source, this.SE.getSize(), this.rank, result, nbCPU);
                    return;
                }
                case -5: {
                    this.rsh.Filter(source, this.SE.getSize(), this.rank, result, nbCPU);
                    return;
                }
                case -6: {
                    this.rsv.Filter(source, this.SE.getSize(), this.rank, result, nbCPU);
                    return;
                }
            }
        }
        this.SE.PreComputePositions(source.getWidth(), source.getRaster().getNumBands());
        if (this.SE.isHeavy()) {
            this.FilterHeavy(source, result, nbCPU);
        } else {
            this.FilterNormal(source, result, nbCPU);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void FilterHeavy(BufferedImage source, BufferedImage result, int nbCPU) {
        Object object;
        int i2;
        if (this.heavythreads == null || this.heavythreads.length != nbCPU) {
            this.nbFreeThreads = 0;
            this.heavythreads = null;
            this.heavythreads = new RankHeavyThread[nbCPU];
            for (i2 = 0; i2 < nbCPU; ++i2) {
                this.heavythreads[i2] = new RankHeavyThread();
                this.heavythreads[i2].start();
            }
            Rank rank = this;
            synchronized (rank) {
                while (this.nbFreeThreads != nbCPU) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        this.nbFreeThreads = 0;
        int step = source.getHeight() / nbCPU;
        for (i2 = 0; i2 < nbCPU - 1; ++i2) {
            this.heavythreads[i2].setConditions(source, result, this.SE, this.rank, 0, i2 * step, source.getWidth(), (i2 + 1) * step);
            object = this.heavythreads[i2].lock;
            synchronized (object) {
                this.heavythreads[i2].lock.notify();
                continue;
            }
        }
        this.heavythreads[i2].setConditions(source, result, this.SE, this.rank, 0, i2 * step, source.getWidth(), source.getHeight());
        object = this.heavythreads[i2].lock;
        synchronized (object) {
            this.heavythreads[i2].lock.notify();
        }
        object = this;
        synchronized (object) {
            while (this.nbFreeThreads != nbCPU) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void FilterNormal(BufferedImage source, BufferedImage result, int nbCPU) {
        Object object;
        int i2;
        if (this.threads == null || this.threads.length != nbCPU) {
            this.nbFreeThreads = 0;
            this.threads = null;
            this.threads = new RankThread[nbCPU];
            for (i2 = 0; i2 < nbCPU; ++i2) {
                this.threads[i2] = new RankThread();
                this.threads[i2].start();
            }
            Rank rank = this;
            synchronized (rank) {
                while (this.nbFreeThreads != nbCPU) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        this.nbFreeThreads = 0;
        int step = source.getHeight() / nbCPU;
        for (i2 = 0; i2 < nbCPU - 1; ++i2) {
            this.threads[i2].setConditions(source, result, this.SE, this.rank, 0, i2 * step, source.getWidth(), (i2 + 1) * step);
            object = this.threads[i2].lock;
            synchronized (object) {
                this.threads[i2].lock.notify();
                continue;
            }
        }
        this.threads[i2].setConditions(source, result, this.SE, this.rank, 0, i2 * step, source.getWidth(), source.getHeight());
        object = this.threads[i2].lock;
        synchronized (object) {
            this.threads[i2].lock.notify();
        }
        object = this;
        synchronized (object) {
            while (this.nbFreeThreads != nbCPU) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public StructuringElement getStructuringElement() {
        return this.SE;
    }

    public void setStructuringElement(StructuringElement SE) {
        this.SE = SE;
    }

    public DV Filter(DV source, StructuringElement3D SE, int rank, int nbCPU) {
        this.setStructuringElement3D(SE);
        this.SetRank(rank);
        return this.Filter(source, nbCPU);
    }

    public void Filter(DV source, StructuringElement3D SE, int rank, DV result, int nbCPU) {
        this.setStructuringElement3D(SE);
        this.SetRank(rank);
        this.Filter(source, result, nbCPU);
    }

    public DV Filter(DV source, int nbCPU) {
        DV result = DvNew.Same((DV)source);
        this.Filter(source, result, nbCPU);
        return result;
    }

    public DV Filter(DV source, StructuringElement3D se, int nbCPU) {
        this.setStructuringElement3D(se);
        return this.Filter(source, nbCPU);
    }

    public void Filter(DV source, StructuringElement3D se, DV result, int nbCPU) {
        this.setStructuringElement3D(se);
        this.Filter(source, result, nbCPU);
    }

    public void Filter(DV source, DV result, int nbCPU) {
        if (nbCPU < 1) {
            throw new IllegalArgumentException("nbCPU < 1.");
        }
        if (this.SE3 == null) {
            throw new IllegalArgumentException("Any 3D structuring element defined.");
        }
        if (!DvTools.areDimensionsAndTypeEqual((DV)source, (DV)result)) {
            throw new IllegalArgumentException("DV source and result must have identic dimensions and types.");
        }
        this.SE3.PreComputePositions(source.SizeX, source.SizeY);
        if (this.SE3.isHeavy()) {
            this.FilterHeavy(source, result, nbCPU);
        } else {
            this.FilterNormal(source, result, nbCPU);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void FilterHeavy(DV source, DV result, int nbCPU) {
        Object object;
        int i2;
        if (this.heavy3dthreads == null || this.heavy3dthreads.length != nbCPU) {
            this.nbFreeThreads = 0;
            this.heavy3dthreads = null;
            this.heavy3dthreads = new RankHeavy3dThread[nbCPU];
            for (i2 = 0; i2 < nbCPU; ++i2) {
                this.heavy3dthreads[i2] = new RankHeavy3dThread();
                this.heavy3dthreads[i2].start();
            }
            Rank rank = this;
            synchronized (rank) {
                while (this.nbFreeThreads != nbCPU) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        this.nbFreeThreads = 0;
        int step = source.SizeZ / nbCPU;
        for (i2 = 0; i2 < nbCPU - 1; ++i2) {
            this.heavy3dthreads[i2].setConditions(source, result, this.SE3, this.rank, 0, 0, i2 * step, source.SizeX, source.SizeY, (i2 + 1) * step);
            object = this.heavy3dthreads[i2].lock;
            synchronized (object) {
                this.heavy3dthreads[i2].lock.notify();
                continue;
            }
        }
        this.heavy3dthreads[i2].setConditions(source, result, this.SE3, this.rank, 0, 0, i2 * step, source.SizeX, source.SizeY, source.SizeZ);
        object = this.heavy3dthreads[i2].lock;
        synchronized (object) {
            this.heavy3dthreads[i2].lock.notify();
        }
        object = this;
        synchronized (object) {
            while (this.nbFreeThreads != nbCPU) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void FilterNormal(DV source, DV result, int nbCPU) {
        Object object;
        int i2;
        if (this.threads3d == null || this.threads3d.length != nbCPU) {
            this.nbFreeThreads = 0;
            this.threads3d = null;
            this.threads3d = new Rank3dThread[nbCPU];
            for (i2 = 0; i2 < nbCPU; ++i2) {
                this.threads3d[i2] = new Rank3dThread();
                this.threads3d[i2].start();
            }
            Rank rank = this;
            synchronized (rank) {
                while (this.nbFreeThreads != nbCPU) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        this.nbFreeThreads = 0;
        int step = source.SizeZ / nbCPU;
        for (i2 = 0; i2 < nbCPU - 1; ++i2) {
            this.threads3d[i2].setConditions(source, result, this.SE3, this.rank, 0, 0, i2 * step, source.SizeX, source.SizeY, (i2 + 1) * step);
            object = this.threads3d[i2].lock;
            synchronized (object) {
                this.threads3d[i2].lock.notify();
                continue;
            }
        }
        this.threads3d[i2].setConditions(source, result, this.SE3, this.rank, 0, 0, i2 * step, source.SizeX, source.SizeY, source.SizeZ);
        object = this.threads3d[i2].lock;
        synchronized (object) {
            this.threads3d[i2].lock.notify();
        }
        object = this;
        synchronized (object) {
            while (this.nbFreeThreads != nbCPU) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public StructuringElement3D getStructuringElement3D() {
        return this.SE3;
    }

    public void setStructuringElement3D(StructuringElement3D se) {
        this.SE3 = se;
    }

    public byte[] Filter(byte[] source, StructuringElement SE, int rank, int nbCPU) {
        this.setStructuringElement(SE);
        this.rank = rank;
        return this.Filter(source, nbCPU);
    }

    public byte[] Filter(byte[] source, int rank, int nbCPU) {
        byte[] result = ArrayNew.Same((byte[])source);
        this.rank = rank;
        this.Filter(source, result, nbCPU);
        return result;
    }

    public void Filter(byte[] source, StructuringElement SE, int rank, byte[] result, int nbCPU) {
        this.setStructuringElement(SE);
        this.rank = rank;
        this.Filter(source, result, nbCPU);
    }

    public void Filter(byte[] source, int rank, byte[] result, int nbCPU) {
        this.rank = rank;
        this.Filter(source, result, nbCPU);
    }

    public byte[] Filter(byte[] source, StructuringElement SE, int nbCPU) {
        this.setStructuringElement(SE);
        return this.Filter(source, nbCPU);
    }

    public byte[] Filter(byte[] source, int nbCPU) {
        byte[] result = ArrayNew.Same((byte[])source);
        this.Filter(source, result, nbCPU);
        return result;
    }

    public void Filter(byte[] source, StructuringElement SE, byte[] result, int nbCPU) {
        this.setStructuringElement(SE);
        this.Filter(source, result, nbCPU);
    }

    public void Filter(byte[] source, byte[] result, int nbCPU) {
        if (this.SE == null) {
            throw new IllegalArgumentException("Any structuring element defined.");
        }
        if (source.length != result.length) {
            throw new IllegalArgumentException("Arrays source and result must have equal dimension.");
        }
        if (this.SE.getType() != -5) {
            throw new IllegalArgumentException("The structuring element must be of type HORIZONTAL.");
        }
        int length = source.length;
        int order = this.SE.getOrder();
        int sewidth = this.SE.getSize();
        if (this.intbuffer == null || this.intbuffer.length != sewidth) {
            this.intbuffer = null;
            this.intbuffer = new int[sewidth];
        }
        this.FixN = this.FindRankPosition(sewidth);
        int x = 0;
        int limsup = order + 1;
        while (x < order) {
            ArrayNew.CopyUnsigned((byte[])source, (int)0, (int[])this.intbuffer, (int)0, (int)limsup);
            Arrays.sort(this.intbuffer, 0, limsup);
            result[x] = (byte)this.intbuffer[this.FindRankPosition(limsup)];
            ++x;
            ++limsup;
        }
        int liminf = 0;
        while (limsup <= length) {
            ArrayNew.CopyUnsigned((byte[])source, (int)liminf, (int[])this.intbuffer, (int)0, (int)sewidth);
            Arrays.sort(this.intbuffer);
            result[x] = (byte)this.intbuffer[this.FixN];
            ++x;
            ++liminf;
            ++limsup;
        }
        --sewidth;
        while (x < length) {
            ArrayNew.CopyUnsigned((byte[])source, (int)liminf, (int[])this.intbuffer, (int)0, (int)sewidth);
            Arrays.sort(this.intbuffer, 0, sewidth);
            result[x] = (byte)this.intbuffer[this.FindRankPosition(sewidth)];
            ++x;
            ++liminf;
            --sewidth;
        }
    }

    public short[] Filter(short[] source, StructuringElement SE, int rank, int nbCPU) {
        this.setStructuringElement(SE);
        this.rank = rank;
        return this.Filter(source, nbCPU);
    }

    public short[] Filter(short[] source, int rank, int nbCPU) {
        short[] result = ArrayNew.Same((short[])source);
        this.rank = rank;
        this.Filter(source, result, nbCPU);
        return result;
    }

    public void Filter(short[] source, StructuringElement SE, int rank, short[] result, int nbCPU) {
        this.setStructuringElement(SE);
        this.rank = rank;
        this.Filter(source, result, nbCPU);
    }

    public void Filter(short[] source, int rank, short[] result, int nbCPU) {
        this.rank = rank;
        this.Filter(source, result, nbCPU);
    }

    public short[] Filter(short[] source, StructuringElement SE, int nbCPU) {
        this.setStructuringElement(SE);
        return this.Filter(source, nbCPU);
    }

    public short[] Filter(short[] source, int nbCPU) {
        short[] result = ArrayNew.Same((short[])source);
        this.Filter(source, result, nbCPU);
        return result;
    }

    public void Filter(short[] source, StructuringElement SE, short[] result, int nbCPU) {
        this.setStructuringElement(SE);
        this.Filter(source, result, nbCPU);
    }

    public void Filter(short[] source, short[] result, int nbCPU) {
        if (this.SE == null) {
            throw new IllegalArgumentException("Any structuring element defined.");
        }
        if (source.length != result.length) {
            throw new IllegalArgumentException("Arrays source and result must have equal dimension.");
        }
        if (this.SE.getType() != -5) {
            throw new IllegalArgumentException("The structuring element must be of type HORIZONTAL.");
        }
        int length = source.length;
        int order = this.SE.getOrder();
        int sewidth = this.SE.getSize();
        if (this.intbuffer == null || this.intbuffer.length != sewidth) {
            this.intbuffer = null;
            this.intbuffer = new int[sewidth];
        }
        this.FixN = this.FindRankPosition(sewidth);
        int x = 0;
        int limsup = order + 1;
        while (x < order) {
            ArrayNew.CopyUnsigned((short[])source, (int)0, (int[])this.intbuffer, (int)0, (int)limsup);
            Arrays.sort(this.intbuffer, 0, limsup);
            result[x] = (short)this.intbuffer[this.FindRankPosition(limsup)];
            ++x;
            ++limsup;
        }
        int liminf = 0;
        while (limsup <= length) {
            ArrayNew.CopyUnsigned((short[])source, (int)liminf, (int[])this.intbuffer, (int)0, (int)sewidth);
            Arrays.sort(this.intbuffer);
            result[x] = (short)this.intbuffer[this.FixN];
            ++x;
            ++liminf;
            ++limsup;
        }
        --sewidth;
        while (x < length) {
            ArrayNew.CopyUnsigned((short[])source, (int)liminf, (int[])this.intbuffer, (int)0, (int)sewidth);
            Arrays.sort(this.intbuffer, 0, sewidth);
            result[x] = (short)this.intbuffer[this.FindRankPosition(sewidth)];
            ++x;
            ++liminf;
            --sewidth;
        }
    }

    public int[] Filter(int[] source, StructuringElement SE, int rank, int nbCPU) {
        this.setStructuringElement(SE);
        this.rank = rank;
        return this.Filter(source, nbCPU);
    }

    public int[] Filter(int[] source, int rank, int nbCPU) {
        int[] result = ArrayNew.Same((int[])source);
        this.rank = rank;
        this.Filter(source, result, nbCPU);
        return result;
    }

    public void Filter(int[] source, StructuringElement SE, int rank, int[] result, int nbCPU) {
        this.setStructuringElement(SE);
        this.rank = rank;
        this.Filter(source, result, nbCPU);
    }

    public void Filter(int[] source, int rank, int[] result, int nbCPU) {
        this.rank = rank;
        this.Filter(source, result, nbCPU);
    }

    public int[] Filter(int[] source, StructuringElement SE, int nbCPU) {
        this.setStructuringElement(SE);
        return this.Filter(source, nbCPU);
    }

    public int[] Filter(int[] source, int nbCPU) {
        int[] result = ArrayNew.Same((int[])source);
        this.Filter(source, result, nbCPU);
        return result;
    }

    public void Filter(int[] source, StructuringElement SE, int[] result, int nbCPU) {
        this.setStructuringElement(SE);
        this.Filter(source, result, nbCPU);
    }

    public void Filter(int[] source, int[] result, int nbCPU) {
        if (this.SE == null) {
            throw new IllegalArgumentException("Any structuring element defined.");
        }
        if (source.length != result.length) {
            throw new IllegalArgumentException("Arrays source and result must have equal dimension.");
        }
        if (this.SE.getType() != -5) {
            throw new IllegalArgumentException("The structuring element must be of type HORIZONTAL.");
        }
        int length = source.length;
        int order = this.SE.getOrder();
        int sewidth = this.SE.getSize();
        if (this.intbuffer == null || this.intbuffer.length != sewidth) {
            this.intbuffer = null;
            this.intbuffer = new int[sewidth];
        }
        this.FixN = this.FindRankPosition(sewidth);
        int x = 0;
        int limsup = order + 1;
        while (x < order) {
            System.arraycopy(source, 0, this.intbuffer, 0, limsup);
            Arrays.sort(this.intbuffer, 0, limsup);
            result[x] = this.intbuffer[this.FindRankPosition(limsup)];
            ++x;
            ++limsup;
        }
        int liminf = 0;
        while (limsup <= length) {
            System.arraycopy(source, liminf, this.intbuffer, 0, sewidth);
            Arrays.sort(this.intbuffer);
            result[x] = this.intbuffer[this.FixN];
            ++x;
            ++liminf;
            ++limsup;
        }
        --sewidth;
        while (x < length) {
            System.arraycopy(source, liminf, this.intbuffer, 0, sewidth);
            Arrays.sort(this.intbuffer, 0, sewidth);
            result[x] = this.intbuffer[this.FindRankPosition(sewidth)];
            ++x;
            ++liminf;
            --sewidth;
        }
    }

    public double[] Filter(double[] source, StructuringElement SE, int rank, int nbCPU) {
        this.setStructuringElement(SE);
        this.rank = rank;
        return this.Filter(source, nbCPU);
    }

    public double[] Filter(double[] source, int rank, int nbCPU) {
        double[] result = ArrayNew.Same((double[])source);
        this.rank = rank;
        this.Filter(source, result, nbCPU);
        return result;
    }

    public void Filter(double[] source, StructuringElement SE, int rank, double[] result, int nbCPU) {
        this.setStructuringElement(SE);
        this.rank = rank;
        this.Filter(source, result, nbCPU);
    }

    public void Filter(double[] source, int rank, double[] result, int nbCPU) {
        this.rank = rank;
        this.Filter(source, result, nbCPU);
    }

    public double[] Filter(double[] source, StructuringElement SE, int nbCPU) {
        this.setStructuringElement(SE);
        return this.Filter(source, nbCPU);
    }

    public double[] Filter(double[] source, int nbCPU) {
        double[] result = ArrayNew.Same((double[])source);
        this.Filter(source, result, nbCPU);
        return result;
    }

    public void Filter(double[] source, StructuringElement SE, double[] result, int nbCPU) {
        this.setStructuringElement(SE);
        this.Filter(source, result, nbCPU);
    }

    public void Filter(double[] source, double[] result, int nbCPU) {
        if (this.SE == null) {
            throw new IllegalArgumentException("Any structuring element defined.");
        }
        if (source.length != result.length) {
            throw new IllegalArgumentException("Arrays source and result must have equal dimension.");
        }
        if (this.SE.getType() != -5) {
            throw new IllegalArgumentException("The structuring element must be of type HORIZONTAL.");
        }
        int length = source.length;
        int order = this.SE.getOrder();
        int sewidth = this.SE.getSize();
        if (this.doublebuffer == null || this.doublebuffer.length != sewidth) {
            this.doublebuffer = null;
            this.doublebuffer = new double[sewidth];
        }
        this.FixN = this.FindRankPosition(sewidth);
        int x = 0;
        int limsup = order + 1;
        while (x < order) {
            System.arraycopy(source, 0, this.doublebuffer, 0, limsup);
            Arrays.sort(this.doublebuffer, 0, limsup);
            result[x] = this.doublebuffer[this.FindRankPosition(limsup)];
            ++x;
            ++limsup;
        }
        int liminf = 0;
        while (limsup <= length) {
            System.arraycopy(source, liminf, this.doublebuffer, 0, sewidth);
            Arrays.sort(this.doublebuffer);
            result[x] = this.doublebuffer[this.FixN];
            ++x;
            ++liminf;
            ++limsup;
        }
        --sewidth;
        while (x < length) {
            System.arraycopy(source, liminf, this.doublebuffer, 0, sewidth);
            Arrays.sort(this.doublebuffer, 0, sewidth);
            result[x] = this.doublebuffer[this.FindRankPosition(sewidth)];
            ++x;
            ++liminf;
            --sewidth;
        }
    }

    private int FindRankPosition(int N) {
        switch (this.rank) {
            case 0: {
                return 0;
            }
            case 100: {
                return N - 1;
            }
            case 75: {
                return 3 * N >> 2;
            }
            case 50: {
                return N >> 1;
            }
            case 25: {
                return N >> 2;
            }
        }
        return this.rank * N / 100;
    }

    protected synchronized void addFreeThread() {
        ++this.nbFreeThreads;
        this.notify();
    }

    public void Parameters(Object ... parameters) {
        if (parameters.length != 2) {
            throw new IllegalArgumentException("Exactly 2 parameters required.");
        }
        if (parameters[0] instanceof StructuringElement) {
            this.setStructuringElement((StructuringElement)parameters[0]);
        } else if (parameters[0] instanceof StructuringElement3D) {
            this.setStructuringElement3D((StructuringElement3D)parameters[0]);
        } else {
            throw new IllegalArgumentException("The first parameter must be a structuring element.");
        }
        this.SetRank((Integer)parameters[1]);
    }

    public List<Object> Parameters() {
        ArrayList<Object> params = new ArrayList<Object>(2);
        if (this.SE != null) {
            params.add(this.SE);
        } else {
            params.add(this.SE3);
        }
        params.add(this.rank);
        return params;
    }

    private void SetRank(int rank) {
        switch (rank) {
            case -1: 
            case 0: 
            case 25: 
            case 50: 
            case 75: 
            case 100: {
                this.rank = rank;
                break;
            }
            default: {
                if (rank < 0) {
                    throw new IllegalArgumentException("Unknown or bad value of rank (< 0).");
                }
                if (100 < rank) {
                    throw new IllegalArgumentException("Unknown or bad value of rank (> 100).");
                }
                this.rank = rank;
            }
        }
    }

    public int BorderEffectSizeX() {
        if (this.SE != null) {
            return this.SE.getSizeX() >> 1;
        }
        if (this.SE3 != null) {
            return this.SE3.getSizeX() >> 1;
        }
        throw new IllegalStateException("Any structuring element defined.");
    }

    public int BorderEffectSizeY() {
        if (this.SE != null) {
            return this.SE.getSizeY() >> 1;
        }
        if (this.SE3 != null) {
            return this.SE3.getSizeY() >> 1;
        }
        throw new IllegalStateException("Any structuring element defined.");
    }

    public int BorderEffectSizeZ() {
        if (this.SE != null) {
            return 0;
        }
        if (this.SE3 != null) {
            return this.SE3.getSizeX() >> 1;
        }
        throw new IllegalStateException("Any structuring element defined.");
    }

    public MorphoFilter Clone() {
        Rank clone = new Rank();
        if (this.SE != null) {
            clone.setStructuringElement(this.SE);
        }
        if (this.SE3 != null) {
            clone.setStructuringElement3D(this.SE3);
        }
        clone.SetRank(this.rank);
        return clone;
    }

    private class RankHeavy3dThread
    extends Thread {
        private DV source;
        private DV result;
        private int order = 0;
        private int length = 0;
        private CoordinatesWeighted[] se = null;
        private CoordinatesWeighted[] forward = null;
        private CoordinatesWeighted[] backward = null;
        private int minx;
        private int miny;
        private int minz;
        private int maxx;
        private int maxy;
        private int maxz;
        private int width;
        private int height;
        private int depth;
        public Object lock = new Object();
        private int[] buffer = null;
        private int[] Hist = null;
        private int FixN = 0;
        private double rankdouble = 0.0;
        private int mini;
        private int maxi;
        private int level;
        private int flag;
        private boolean Kill = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void Kill() {
            this.result = null;
            this.source = null;
            this.backward = null;
            this.forward = null;
            this.se = null;
            this.Hist = null;
            this.buffer = null;
            this.Kill = true;
            Object object = this.lock;
            synchronized (object) {
                this.lock.notify();
            }
        }

        public void setConditions(DV Original, DV Result, StructuringElement3D SE, int rank, int minx, int miny, int minz, int maxx, int maxy, int maxz) {
            this.source = Original;
            this.result = Result;
            this.order = SE.getSize() >> 1;
            this.rankdouble = (double)rank / 100.0;
            this.se = SE.getSE();
            this.forward = SE.getForward();
            this.backward = SE.getBackward();
            this.length = this.se.length;
            this.minx = minx;
            this.miny = miny;
            this.minz = minz;
            this.maxx = maxx;
            this.maxy = maxy;
            this.maxz = maxz;
            this.width = Original.SizeX;
            this.height = Original.SizeY;
            this.depth = Original.SizeZ;
            if (this.buffer == null || this.buffer.length != this.length) {
                this.buffer = null;
                this.buffer = new int[this.length];
            }
            this.FixN = (int)((double)(this.length - 1) * (double)rank / 100.0 + 0.5);
            switch (rank) {
                case 0: {
                    this.FixN = 0;
                    break;
                }
                case 100: {
                    this.FixN = this.length - 1;
                    break;
                }
                case 75: {
                    this.FixN = 3 * this.length >> 2;
                    break;
                }
                case 50: {
                    this.FixN = this.length >> 1;
                    break;
                }
                case 25: {
                    this.FixN = this.length >> 2;
                }
            }
            switch (Original.Type) {
                case 8: {
                    if (this.Hist != null && this.Hist.length == 256) break;
                    this.Hist = null;
                    this.Hist = new int[256];
                    break;
                }
                case 16: {
                    if (this.Hist != null && this.Hist.length == 65536) break;
                    this.Hist = null;
                    this.Hist = new int[65536];
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported DV type.");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            coord = null;
            block9: while (true) lbl-1000:
            // 3 sources

            {
                var11_12 = this.lock;
                synchronized (var11_12) {
                    try {
                        Rank.this.addFreeThread();
                        this.lock.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                if (this.Kill) {
                    return;
                }
                MinX = this.minx < this.order ? this.order : this.minx;
                MinY = this.miny < this.order ? this.order : this.miny;
                MinZ = this.minz < this.order ? this.order : this.minz;
                MaxX = this.maxx >= this.width - this.order ? this.width - this.order : this.maxx;
                MaxY = this.maxy >= this.height - this.order ? this.height - this.order : this.maxy;
                MaxZ = this.maxz >= this.depth - this.order ? this.depth - this.order : this.maxz;
                switch (this.source.Type) {
                    case 8: {
                        c = 0;
                        while (true) {
                            if (c >= this.source.Channel) ** GOTO lbl-1000
                            bytebufferin = this.source.getDataBufferByte(c);
                            bytebufferout = this.result.getDataBufferByte(c);
                            for (z = this.minz; z < this.maxz; ++z) {
                                y = this.miny;
                                pos = this.source.Position(0, y, z);
                                while (y < this.maxy) {
                                    if (y < MinY || MaxY <= y || z < MinZ || MaxZ <= z) {
                                        size = 0;
                                        this.maxi = 0;
                                        this.mini = 255;
                                        for (l = 0; l < this.length; ++l) {
                                            coord = this.se[l];
                                            if (0 > coord.X || 0 > y + coord.Y || y + coord.Y >= this.height || 0 > z + coord.Z || z + coord.Z >= this.depth) continue;
                                            v0 = v = bytebufferin[pos + this.se[l].Pos] & 255;
                                            this.Hist[v0] = this.Hist[v0] + 1;
                                            if (this.maxi < v) {
                                                this.maxi = v;
                                            }
                                            if (this.mini > v) {
                                                this.mini = v;
                                            }
                                            ++size;
                                        }
                                        posrank = (int)(this.rankdouble * (double)size);
                                        this.FindFlagLevel(posrank, size);
                                        bytebufferout[pos] = (byte)this.flag;
                                        for (x = 1; x <= MinX; ++x) {
                                            for (l = 0; l < this.forward.length; ++l) {
                                                coord = this.forward[l];
                                                if (0 > x + coord.X || 0 > y + coord.Y || y + coord.Y >= this.height || 0 > z + coord.Z || z + coord.Z >= this.depth) continue;
                                                v1 = v = bytebufferin[pos + this.forward[l].Pos + x] & 255;
                                                this.Hist[v1] = this.Hist[v1] + 1;
                                                if (this.maxi < v) {
                                                    this.maxi = v;
                                                }
                                                if (this.mini > v) {
                                                    this.mini = v;
                                                }
                                                ++size;
                                            }
                                            for (l = 0; l < this.backward.length; ++l) {
                                                coord = this.backward[l];
                                                if (0 > x + coord.X || 0 > y + coord.Y || y + coord.Y >= this.height || 0 > z + coord.Z || z + coord.Z >= this.depth) continue;
                                                v2 = bytebufferin[pos + this.backward[l].Pos + x] & 255;
                                                this.Hist[v2] = this.Hist[v2] - 1;
                                                while (this.Hist[this.maxi] == 0) {
                                                    --this.maxi;
                                                }
                                                while (this.Hist[this.mini] == 0) {
                                                    ++this.mini;
                                                }
                                                --size;
                                            }
                                            posrank = (int)(this.rankdouble * (double)size);
                                            this.FindFlagLevel(posrank, size);
                                            bytebufferout[pos + x] = (byte)this.flag;
                                        }
                                        while (x < MaxX) {
                                            for (l = 0; l < this.forward.length; ++l) {
                                                coord = this.forward[l];
                                                if (0 > y + coord.Y || y + coord.Y >= this.height || 0 > z + coord.Z || z + coord.Z >= this.depth) continue;
                                                v3 = v = bytebufferin[pos + this.forward[l].Pos + x] & 255;
                                                this.Hist[v3] = this.Hist[v3] + 1;
                                                if (this.maxi < v) {
                                                    this.maxi = v;
                                                }
                                                if (this.mini > v) {
                                                    this.mini = v;
                                                }
                                                ++size;
                                            }
                                            for (l = 0; l < this.backward.length; ++l) {
                                                coord = this.backward[l];
                                                if (0 > y + coord.Y || y + coord.Y >= this.height || 0 > z + coord.Z || z + coord.Z >= this.depth) continue;
                                                v4 = bytebufferin[pos + this.backward[l].Pos + x] & 255;
                                                this.Hist[v4] = this.Hist[v4] - 1;
                                                while (this.Hist[this.maxi] == 0) {
                                                    --this.maxi;
                                                }
                                                while (this.Hist[this.mini] == 0) {
                                                    ++this.mini;
                                                }
                                                --size;
                                            }
                                            posrank = (int)(this.rankdouble * (double)size);
                                            this.FindFlagLevel(posrank, size);
                                            bytebufferout[pos + x] = (byte)this.flag;
                                            ++x;
                                        }
                                        while (x < this.maxx) {
                                            for (l = 0; l < this.forward.length; ++l) {
                                                coord = this.forward[l];
                                                if (x + coord.X >= this.width || 0 > y + coord.Y || y + coord.Y >= this.height || 0 > z + coord.Z || z + coord.Z >= this.depth) continue;
                                                v5 = v = bytebufferin[pos + this.forward[l].Pos + x] & 255;
                                                this.Hist[v5] = this.Hist[v5] + 1;
                                                if (this.maxi < v) {
                                                    this.maxi = v;
                                                }
                                                if (this.mini > v) {
                                                    this.mini = v;
                                                }
                                                ++size;
                                            }
                                            for (l = 0; l < this.backward.length; ++l) {
                                                coord = this.backward[l];
                                                if (x + coord.X >= this.width || 0 > y + coord.Y || y + coord.Y >= this.height || 0 > z + coord.Z || z + coord.Z >= this.depth) continue;
                                                v6 = bytebufferin[pos + this.backward[l].Pos + x] & 255;
                                                this.Hist[v6] = this.Hist[v6] - 1;
                                                while (this.Hist[this.maxi] == 0) {
                                                    --this.maxi;
                                                }
                                                while (this.Hist[this.mini] == 0) {
                                                    ++this.mini;
                                                }
                                                --size;
                                            }
                                            posrank = (int)(this.rankdouble * (double)size);
                                            this.FindFlagLevel(posrank, size);
                                            bytebufferout[pos + x] = (byte)this.flag;
                                            ++x;
                                        }
                                        Arrays.fill(this.Hist, 0);
                                    } else {
                                        size = 0;
                                        this.maxi = 0;
                                        this.mini = 255;
                                        for (l = 0; l < this.length; ++l) {
                                            coord = this.se[l];
                                            if (0 > coord.X) continue;
                                            v7 = v = bytebufferin[pos + this.se[l].Pos] & 255;
                                            this.Hist[v7] = this.Hist[v7] + 1;
                                            if (this.maxi < v) {
                                                this.maxi = v;
                                            }
                                            if (this.mini > v) {
                                                this.mini = v;
                                            }
                                            ++size;
                                        }
                                        posrank = (int)(this.rankdouble * (double)size);
                                        this.FindFlagLevel(posrank, size);
                                        bytebufferout[pos] = (byte)this.flag;
                                        for (x = 1; x <= MinX; ++x) {
                                            for (l = 0; l < this.forward.length; ++l) {
                                                coord = this.forward[l];
                                                v8 = v = bytebufferin[pos + this.forward[l].Pos + x] & 255;
                                                this.Hist[v8] = this.Hist[v8] + 1;
                                                if (this.maxi < v) {
                                                    this.maxi = v;
                                                }
                                                if (this.mini > v) {
                                                    this.mini = v;
                                                }
                                                ++size;
                                            }
                                            for (l = 0; l < this.backward.length; ++l) {
                                                coord = this.backward[l];
                                                if (x + coord.X < 0) continue;
                                                v9 = bytebufferin[pos + this.backward[l].Pos + x] & 255;
                                                this.Hist[v9] = this.Hist[v9] - 1;
                                                while (this.Hist[this.maxi] == 0) {
                                                    --this.maxi;
                                                }
                                                while (this.Hist[this.mini] == 0) {
                                                    ++this.mini;
                                                }
                                                --size;
                                            }
                                            posrank = (int)(this.rankdouble * (double)size);
                                            this.FindFlagLevel(posrank, size);
                                            bytebufferout[pos + x] = (byte)this.flag;
                                        }
                                        while (x < MaxX) {
                                            for (l = 0; l < this.forward.length; ++l) {
                                                coord = this.forward[l];
                                                v10 = v = bytebufferin[pos + this.forward[l].Pos + x] & 255;
                                                this.Hist[v10] = this.Hist[v10] + 1;
                                                if (this.maxi < v) {
                                                    this.maxi = v;
                                                }
                                                if (this.mini > v) {
                                                    this.mini = v;
                                                }
                                                ++size;
                                            }
                                            for (l = 0; l < this.backward.length; ++l) {
                                                coord = this.backward[l];
                                                v11 = bytebufferin[pos + this.backward[l].Pos + x] & 255;
                                                this.Hist[v11] = this.Hist[v11] - 1;
                                                while (this.Hist[this.maxi] == 0) {
                                                    --this.maxi;
                                                }
                                                while (this.Hist[this.mini] == 0) {
                                                    ++this.mini;
                                                }
                                                --size;
                                            }
                                            posrank = (int)(this.rankdouble * (double)size);
                                            this.FindFlagLevel(posrank, size);
                                            bytebufferout[pos + x] = (byte)this.flag;
                                            ++x;
                                        }
                                        while (x < this.maxx) {
                                            for (l = 0; l < this.forward.length; ++l) {
                                                coord = this.forward[l];
                                                if (x + coord.X >= this.width) continue;
                                                v12 = v = bytebufferin[pos + this.forward[l].Pos + x] & 255;
                                                this.Hist[v12] = this.Hist[v12] + 1;
                                                if (this.maxi < v) {
                                                    this.maxi = v;
                                                }
                                                if (this.mini > v) {
                                                    this.mini = v;
                                                }
                                                ++size;
                                            }
                                            for (l = 0; l < this.backward.length; ++l) {
                                                coord = this.backward[l];
                                                v13 = bytebufferin[pos + this.backward[l].Pos + x] & 255;
                                                this.Hist[v13] = this.Hist[v13] - 1;
                                                while (this.Hist[this.maxi] == 0) {
                                                    --this.maxi;
                                                }
                                                while (this.Hist[this.mini] == 0) {
                                                    ++this.mini;
                                                }
                                                --size;
                                            }
                                            posrank = (int)(this.rankdouble * (double)size);
                                            this.FindFlagLevel(posrank, size);
                                            bytebufferout[pos + x] = (byte)this.flag;
                                            ++x;
                                        }
                                        Arrays.fill(this.Hist, 0);
                                    }
                                    ++y;
                                    pos += this.width;
                                }
                            }
                            bytebufferout = null;
                            bytebufferin = null;
                            ++c;
                        }
                    }
                    case 16: {
                        c = 0;
                        while (true) {
                            if (c >= this.source.Channel) continue block9;
                            shortbufferin = this.source.getDataBufferShort(c);
                            shortbufferout = this.result.getDataBufferShort(c);
                            for (z = this.minz; z < this.maxz; ++z) {
                                y = this.miny;
                                pos = this.source.Position(0, y, z);
                                while (y < this.maxy) {
                                    if (y < MinY || MaxY <= y || z < MinZ || MaxZ <= z) {
                                        size = 0;
                                        this.maxi = 0;
                                        this.mini = 255;
                                        for (l = 0; l < this.length; ++l) {
                                            coord = this.se[l];
                                            if (0 > coord.X || 0 > y + coord.Y || y + coord.Y >= this.height || 0 > z + coord.Z || z + coord.Z >= this.depth) continue;
                                            v14 = v = shortbufferin[pos + this.se[l].Pos] & 65535;
                                            this.Hist[v14] = this.Hist[v14] + 1;
                                            if (this.maxi < v) {
                                                this.maxi = v;
                                            }
                                            if (this.mini > v) {
                                                this.mini = v;
                                            }
                                            ++size;
                                        }
                                        posrank = (int)(this.rankdouble * (double)size);
                                        this.FindFlagLevel(posrank, size);
                                        shortbufferout[pos] = (short)this.flag;
                                        for (x = 1; x <= MinX; ++x) {
                                            for (l = 0; l < this.forward.length; ++l) {
                                                coord = this.forward[l];
                                                if (0 > x + coord.X || 0 > y + coord.Y || y + coord.Y >= this.height || 0 > z + coord.Z || z + coord.Z >= this.depth) continue;
                                                v15 = v = shortbufferin[pos + this.forward[l].Pos + x] & 65535;
                                                this.Hist[v15] = this.Hist[v15] + 1;
                                                if (this.maxi < v) {
                                                    this.maxi = v;
                                                }
                                                if (this.mini > v) {
                                                    this.mini = v;
                                                }
                                                ++size;
                                            }
                                            for (l = 0; l < this.backward.length; ++l) {
                                                coord = this.backward[l];
                                                if (0 > x + coord.X || 0 > y + coord.Y || y + coord.Y >= this.height || 0 > z + coord.Z || z + coord.Z >= this.depth) continue;
                                                v16 = shortbufferin[pos + this.backward[l].Pos + x] & 65535;
                                                this.Hist[v16] = this.Hist[v16] - 1;
                                                while (this.Hist[this.maxi] == 0) {
                                                    --this.maxi;
                                                }
                                                while (this.Hist[this.mini] == 0) {
                                                    ++this.mini;
                                                }
                                                --size;
                                            }
                                            posrank = (int)(this.rankdouble * (double)size);
                                            this.FindFlagLevel(posrank, size);
                                            shortbufferout[pos + x] = (short)this.flag;
                                        }
                                        while (x < MaxX) {
                                            for (l = 0; l < this.forward.length; ++l) {
                                                coord = this.forward[l];
                                                if (0 > y + coord.Y || y + coord.Y >= this.height || 0 > z + coord.Z || z + coord.Z >= this.depth) continue;
                                                v17 = v = shortbufferin[pos + this.forward[l].Pos + x] & 65535;
                                                this.Hist[v17] = this.Hist[v17] + 1;
                                                if (this.maxi < v) {
                                                    this.maxi = v;
                                                }
                                                if (this.mini > v) {
                                                    this.mini = v;
                                                }
                                                ++size;
                                            }
                                            for (l = 0; l < this.backward.length; ++l) {
                                                coord = this.backward[l];
                                                if (0 > y + coord.Y || y + coord.Y >= this.height || 0 > z + coord.Z || z + coord.Z >= this.depth) continue;
                                                v18 = shortbufferin[pos + this.backward[l].Pos + x] & 65535;
                                                this.Hist[v18] = this.Hist[v18] - 1;
                                                while (this.Hist[this.maxi] == 0) {
                                                    --this.maxi;
                                                }
                                                while (this.Hist[this.mini] == 0) {
                                                    ++this.mini;
                                                }
                                                --size;
                                            }
                                            posrank = (int)(this.rankdouble * (double)size);
                                            this.FindFlagLevel(posrank, size);
                                            shortbufferout[pos + x] = (short)this.flag;
                                            ++x;
                                        }
                                        while (x < this.maxx) {
                                            for (l = 0; l < this.forward.length; ++l) {
                                                coord = this.forward[l];
                                                if (x + coord.X >= this.width || 0 > y + coord.Y || y + coord.Y >= this.height || 0 > z + coord.Z || z + coord.Z >= this.depth) continue;
                                                v19 = v = shortbufferin[pos + this.forward[l].Pos + x] & 65535;
                                                this.Hist[v19] = this.Hist[v19] + 1;
                                                if (this.maxi < v) {
                                                    this.maxi = v;
                                                }
                                                if (this.mini > v) {
                                                    this.mini = v;
                                                }
                                                ++size;
                                            }
                                            for (l = 0; l < this.backward.length; ++l) {
                                                coord = this.backward[l];
                                                if (x + coord.X >= this.width || 0 > y + coord.Y || y + coord.Y >= this.height || 0 > z + coord.Z || z + coord.Z >= this.depth) continue;
                                                v20 = shortbufferin[pos + this.backward[l].Pos + x] & 65535;
                                                this.Hist[v20] = this.Hist[v20] - 1;
                                                while (this.Hist[this.maxi] == 0) {
                                                    --this.maxi;
                                                }
                                                while (this.Hist[this.mini] == 0) {
                                                    ++this.mini;
                                                }
                                                --size;
                                            }
                                            posrank = (int)(this.rankdouble * (double)size);
                                            this.FindFlagLevel(posrank, size);
                                            shortbufferout[pos + x] = (short)this.flag;
                                            ++x;
                                        }
                                        Arrays.fill(this.Hist, 0);
                                    } else {
                                        size = 0;
                                        this.maxi = 0;
                                        this.mini = 255;
                                        for (l = 0; l < this.length; ++l) {
                                            coord = this.se[l];
                                            if (0 > coord.X) continue;
                                            v21 = v = shortbufferin[pos + this.se[l].Pos] & 65535;
                                            this.Hist[v21] = this.Hist[v21] + 1;
                                            if (this.maxi < v) {
                                                this.maxi = v;
                                            }
                                            if (this.mini > v) {
                                                this.mini = v;
                                            }
                                            ++size;
                                        }
                                        posrank = (int)(this.rankdouble * (double)size);
                                        this.FindFlagLevel(posrank, size);
                                        shortbufferout[pos] = (short)this.flag;
                                        for (x = 1; x <= MinX; ++x) {
                                            for (l = 0; l < this.forward.length; ++l) {
                                                coord = this.forward[l];
                                                v22 = v = shortbufferin[pos + this.forward[l].Pos + x] & 65535;
                                                this.Hist[v22] = this.Hist[v22] + 1;
                                                if (this.maxi < v) {
                                                    this.maxi = v;
                                                }
                                                if (this.mini > v) {
                                                    this.mini = v;
                                                }
                                                ++size;
                                            }
                                            for (l = 0; l < this.backward.length; ++l) {
                                                coord = this.backward[l];
                                                if (x + coord.X < 0) continue;
                                                v23 = shortbufferin[pos + this.backward[l].Pos + x] & 65535;
                                                this.Hist[v23] = this.Hist[v23] - 1;
                                                while (this.Hist[this.maxi] == 0) {
                                                    --this.maxi;
                                                }
                                                while (this.Hist[this.mini] == 0) {
                                                    ++this.mini;
                                                }
                                                --size;
                                            }
                                            posrank = (int)(this.rankdouble * (double)size);
                                            this.FindFlagLevel(posrank, size);
                                            shortbufferout[pos + x] = (short)this.flag;
                                        }
                                        while (x < MaxX) {
                                            for (l = 0; l < this.forward.length; ++l) {
                                                coord = this.forward[l];
                                                v24 = v = shortbufferin[pos + this.forward[l].Pos + x] & 65535;
                                                this.Hist[v24] = this.Hist[v24] + 1;
                                                if (this.maxi < v) {
                                                    this.maxi = v;
                                                }
                                                if (this.mini > v) {
                                                    this.mini = v;
                                                }
                                                ++size;
                                            }
                                            for (l = 0; l < this.backward.length; ++l) {
                                                coord = this.backward[l];
                                                v25 = shortbufferin[pos + this.backward[l].Pos + x] & 65535;
                                                this.Hist[v25] = this.Hist[v25] - 1;
                                                while (this.Hist[this.maxi] == 0) {
                                                    --this.maxi;
                                                }
                                                while (this.Hist[this.mini] == 0) {
                                                    ++this.mini;
                                                }
                                                --size;
                                            }
                                            posrank = (int)(this.rankdouble * (double)size);
                                            this.FindFlagLevel(posrank, size);
                                            shortbufferout[pos + x] = (short)this.flag;
                                            ++x;
                                        }
                                        while (x < this.maxx) {
                                            for (l = 0; l < this.forward.length; ++l) {
                                                coord = this.forward[l];
                                                if (x + coord.X >= this.width) continue;
                                                v26 = v = shortbufferin[pos + this.forward[l].Pos + x] & 65535;
                                                this.Hist[v26] = this.Hist[v26] + 1;
                                                if (this.maxi < v) {
                                                    this.maxi = v;
                                                }
                                                if (this.mini > v) {
                                                    this.mini = v;
                                                }
                                                ++size;
                                            }
                                            for (l = 0; l < this.backward.length; ++l) {
                                                coord = this.backward[l];
                                                v27 = shortbufferin[pos + this.backward[l].Pos + x] & 65535;
                                                this.Hist[v27] = this.Hist[v27] - 1;
                                                while (this.Hist[this.maxi] == 0) {
                                                    --this.maxi;
                                                }
                                                while (this.Hist[this.mini] == 0) {
                                                    ++this.mini;
                                                }
                                                --size;
                                            }
                                            posrank = (int)(this.rankdouble * (double)size);
                                            this.FindFlagLevel(posrank, size);
                                            shortbufferout[pos + x] = (short)this.flag;
                                            ++x;
                                        }
                                        Arrays.fill(this.Hist, 0);
                                    }
                                    ++y;
                                    pos += this.width;
                                }
                            }
                            shortbufferout = null;
                            shortbufferin = null;
                            ++c;
                        }
                    }
                }
                break;
            }
            throw new IllegalArgumentException("DV type not supported (yet).");
        }

        private int SortAndFind() {
            Arrays.sort(this.buffer);
            if (Rank.this.rank != -1) {
                return this.buffer[this.FixN];
            }
            double k = 0.0;
            double cste = this.buffer[this.length - 1] - this.buffer[0];
            for (int i2 = 0; i2 < this.length; ++i2) {
                k += (double)this.buffer[i2] - (double)this.buffer[0] - cste * (double)i2 / (double)this.length;
            }
            k /= (double)this.length * cste;
            int r = (int)((double)this.length * (k += 0.5));
            return this.buffer[r];
        }

        private int SortAndFind(int N) {
            Arrays.sort(this.buffer, 0, N);
            switch (Rank.this.rank) {
                case 0: {
                    return this.buffer[0];
                }
                case 100: {
                    return this.buffer[N - 1];
                }
                case 75: {
                    return this.buffer[3 * N >> 2];
                }
                case 50: {
                    return this.buffer[N >> 1];
                }
                case 25: {
                    return this.buffer[N >> 2];
                }
                case -1: {
                    double k = 0.0;
                    double cste = this.buffer[N] - this.buffer[0];
                    for (int i2 = 0; i2 < N; ++i2) {
                        k += (double)this.buffer[i2] - (double)this.buffer[0] - cste * (double)i2 / (double)N;
                    }
                    k /= (double)N * cste;
                    int r = (int)((double)N * (k += 0.5));
                    return this.buffer[r];
                }
            }
            return this.buffer[Rank.this.rank * N / 100];
        }

        private void FindFlagLevel(int posrank, int max) {
            int nb = -1;
            if ((double)Rank.this.rank < 0.5) {
                this.flag = this.mini;
                while (true) {
                    if (this.Hist[this.flag] == 0) {
                        ++this.flag;
                        continue;
                    }
                    this.level = 1;
                    ++nb;
                    while (this.level < this.Hist[this.flag] && nb < posrank) {
                        ++this.level;
                        ++nb;
                    }
                    if (nb >= posrank) break;
                    ++this.flag;
                }
                return;
            }
            this.flag = this.maxi;
            while (true) {
                if (this.Hist[this.flag] == 0) {
                    --this.flag;
                    continue;
                }
                this.level = 1;
                --max;
                while (this.level < this.Hist[this.flag] && posrank < max) {
                    ++this.level;
                    --max;
                }
                if (posrank >= max) break;
                --this.flag;
            }
        }
    }

    private class Rank3dThread
    extends Thread {
        private DV source;
        private DV result;
        private int order = 0;
        private int length = 0;
        private CoordinatesWeighted[] se = null;
        private int minx;
        private int miny;
        private int minz;
        private int maxx;
        private int maxy;
        private int maxz;
        private int width;
        private int height;
        private int depth;
        public Object lock = new Object();
        private int[] buffer = null;
        private int FixN = 0;
        private boolean Kill = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void Kill() {
            this.result = null;
            this.source = null;
            this.se = null;
            this.buffer = null;
            this.Kill = true;
            Object object = this.lock;
            synchronized (object) {
                this.lock.notify();
            }
        }

        public void setConditions(DV Original, DV Result, StructuringElement3D SE, int rank, int minx, int miny, int minz, int maxx, int maxy, int maxz) {
            this.source = Original;
            this.result = Result;
            this.order = SE.getSize() >> 1;
            this.se = SE.getSE();
            this.length = this.se.length;
            this.minx = minx;
            this.miny = miny;
            this.minz = minz;
            this.maxx = maxx;
            this.maxy = maxy;
            this.maxz = maxz;
            this.width = Original.SizeX;
            this.height = Original.SizeY;
            this.depth = Original.SizeZ;
            if (this.buffer == null || this.buffer.length != this.length) {
                this.buffer = null;
                this.buffer = new int[this.length];
            }
            this.FixN = (int)((double)(this.length - 1) * (double)rank / 100.0 + 0.5);
            switch (rank) {
                case 0: {
                    this.FixN = 0;
                    break;
                }
                case 100: {
                    this.FixN = this.length - 1;
                    break;
                }
                case 75: {
                    this.FixN = 3 * this.length >> 2;
                    break;
                }
                case 50: {
                    this.FixN = this.length >> 1;
                    break;
                }
                case 25: {
                    this.FixN = this.length >> 2;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            coord = null;
            block10: while (true) lbl-1000:
            // 4 sources

            {
                var9_10 = this.lock;
                synchronized (var9_10) {
                    try {
                        Rank.this.addFreeThread();
                        this.lock.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                if (this.Kill) {
                    return;
                }
                popy = this.source.SizeX - this.maxx + this.minx;
                popz = (this.source.SizeY - this.maxy + this.miny) * this.source.SizeX;
                wior = this.width - this.order;
                heor = this.height - this.order;
                deor = this.depth - this.order;
                MinX = this.minx < this.order ? this.order : this.minx;
                MinY = this.miny < this.order ? this.order : this.miny;
                MinZ = this.minz < this.order ? this.order : this.minz;
                MaxX = this.maxx >= this.width - this.order ? this.width - this.order : this.maxx;
                MaxY = this.maxy >= this.height - this.order ? this.height - this.order : this.maxy;
                MaxZ = this.maxz >= this.depth - this.order ? this.depth - this.order : this.maxz;
                PopY = this.source.SizeX - MaxX + MinX;
                PopZ = (this.source.SizeY - MaxY + MinY) * this.source.SizeX;
                switch (this.source.Type) {
                    case 8: {
                        c = 0;
                        while (true) {
                            if (c >= this.source.Channel) ** GOTO lbl-1000
                            bytebufferin = this.source.getDataBufferByte(c);
                            bytebufferout = this.result.getDataBufferByte(c);
                            z = MinZ;
                            pos = this.source.Position(MinX, MinY, MinZ);
                            while (z < MaxZ) {
                                y = MinY;
                                while (y < MaxY) {
                                    x = MinX;
                                    while (x < MaxX) {
                                        for (l = 0; l < this.length; ++l) {
                                            this.buffer[l] = bytebufferin[pos + this.se[l].Pos] & 255;
                                        }
                                        bytebufferout[pos] = (byte)this.SortAndFind();
                                        ++x;
                                        ++pos;
                                    }
                                    ++y;
                                    pos += PopY;
                                }
                                ++z;
                                pos += PopZ;
                            }
                            z = this.minz;
                            pos = this.source.Position(this.minx, this.miny, this.minz);
                            while (z < this.maxz) {
                                y = this.miny;
                                while (y < this.maxy) {
                                    x = this.minx;
                                    while (x < this.maxx) {
                                        if (x < this.order || y < this.order || z < this.order || wior <= x || heor <= y || deor <= z) {
                                            nb = 0;
                                            for (l = 0; l < this.length; ++l) {
                                                coord = this.se[l];
                                                if (0 > z + coord.Z || z + coord.Z >= this.depth || 0 > y + coord.Y || y + coord.Y >= this.height || 0 > x + coord.X || x + coord.X >= this.width) continue;
                                                this.buffer[nb++] = bytebufferin[pos + this.se[l].Pos] & 255;
                                            }
                                            bytebufferout[pos] = (byte)this.SortAndFind(nb);
                                        }
                                        ++x;
                                        ++pos;
                                    }
                                    ++y;
                                    pos += popy;
                                }
                                ++z;
                                pos += popz;
                            }
                            bytebufferout = null;
                            bytebufferin = null;
                            ++c;
                        }
                    }
                    case 16: {
                        c = 0;
                        while (true) {
                            if (c >= this.source.Channel) ** GOTO lbl-1000
                            shortbufferin = this.source.getDataBufferShort(c);
                            shortbufferout = this.result.getDataBufferShort(c);
                            z = MinZ;
                            pos = this.source.Position(MinX, MinY, MinZ);
                            while (z < MaxZ) {
                                y = MinY;
                                while (y < MaxY) {
                                    x = MinX;
                                    while (x < MaxX) {
                                        for (l = 0; l < this.length; ++l) {
                                            this.buffer[l] = shortbufferin[pos + this.se[l].Pos] & 65535;
                                        }
                                        shortbufferout[pos] = (short)this.SortAndFind();
                                        ++x;
                                        ++pos;
                                    }
                                    ++y;
                                    pos += PopY;
                                }
                                ++z;
                                pos += PopZ;
                            }
                            z = this.minz;
                            pos = this.source.Position(this.minx, this.miny, this.minz);
                            while (z < this.maxz) {
                                y = this.miny;
                                while (y < this.maxy) {
                                    x = this.minx;
                                    while (x < this.maxx) {
                                        if (x < this.order || y < this.order || z < this.order || wior <= x || heor <= y || deor <= z) {
                                            nb = 0;
                                            for (l = 0; l < this.length; ++l) {
                                                coord = this.se[l];
                                                if (0 > z + coord.Z || z + coord.Z >= this.depth || 0 > y + coord.Y || y + coord.Y >= this.height || 0 > x + coord.X || x + coord.X >= this.width) continue;
                                                this.buffer[nb++] = shortbufferin[pos + this.se[l].Pos] & 65535;
                                            }
                                            shortbufferout[pos] = (short)this.SortAndFind(nb);
                                        }
                                        ++x;
                                        ++pos;
                                    }
                                    ++y;
                                    pos += popy;
                                }
                                ++z;
                                pos += popz;
                            }
                            shortbufferout = null;
                            shortbufferin = null;
                            ++c;
                        }
                    }
                    case 32: {
                        c = 0;
                        while (true) {
                            if (c >= this.source.Channel) continue block10;
                            intbufferin = this.source.getDataBufferInt(c);
                            intbufferout = this.result.getDataBufferInt(c);
                            z = MinZ;
                            pos = this.source.Position(MinX, MinY, MinZ);
                            while (z < MaxZ) {
                                y = MinY;
                                while (y < MaxY) {
                                    x = MinX;
                                    while (x < MaxX) {
                                        for (l = 0; l < this.length; ++l) {
                                            this.buffer[l] = intbufferin[pos + this.se[l].Pos];
                                        }
                                        intbufferout[pos] = this.SortAndFind();
                                        ++x;
                                        ++pos;
                                    }
                                    ++y;
                                    pos += PopY;
                                }
                                ++z;
                                pos += PopZ;
                            }
                            z = this.minz;
                            pos = this.source.Position(this.minx, this.miny, this.minz);
                            while (z < this.maxz) {
                                y = this.miny;
                                while (y < this.maxy) {
                                    x = this.minx;
                                    while (x < this.maxx) {
                                        if (x < this.order || y < this.order || z < this.order || wior <= x || heor <= y || deor <= z) {
                                            nb = 0;
                                            for (l = 0; l < this.length; ++l) {
                                                coord = this.se[l];
                                                if (0 > z + coord.Z || z + coord.Z >= this.depth || 0 > y + coord.Y || y + coord.Y >= this.height || 0 > x + coord.X || x + coord.X >= this.width) continue;
                                                this.buffer[nb++] = intbufferin[pos + this.se[l].Pos];
                                            }
                                            intbufferout[pos] = this.SortAndFind(nb);
                                        }
                                        ++x;
                                        ++pos;
                                    }
                                    ++y;
                                    pos += popy;
                                }
                                ++z;
                                pos += popz;
                            }
                            intbufferout = null;
                            intbufferin = null;
                            ++c;
                        }
                    }
                }
                break;
            }
            throw new IllegalArgumentException("DV type not supported (yet).");
        }

        private int SortAndFind() {
            Arrays.sort(this.buffer);
            if (Rank.this.rank != -1) {
                return this.buffer[this.FixN];
            }
            double k = 0.0;
            double cste = this.buffer[this.length - 1] - this.buffer[0];
            for (int i2 = 0; i2 < this.length; ++i2) {
                k += (double)this.buffer[i2] - (double)this.buffer[0] - cste * (double)i2 / (double)this.length;
            }
            k /= (double)this.length * cste;
            int r = (int)((double)this.length * (k += 0.5));
            return this.buffer[r];
        }

        private int SortAndFind(int N) {
            Arrays.sort(this.buffer, 0, N);
            switch (Rank.this.rank) {
                case 0: {
                    return this.buffer[0];
                }
                case 100: {
                    return this.buffer[N - 1];
                }
                case 75: {
                    return this.buffer[3 * N >> 2];
                }
                case 50: {
                    return this.buffer[N >> 1];
                }
                case 25: {
                    return this.buffer[N >> 2];
                }
                case -1: {
                    double k = 0.0;
                    double cste = this.buffer[N] - this.buffer[0];
                    for (int i2 = 0; i2 < N; ++i2) {
                        k += (double)this.buffer[i2] - (double)this.buffer[0] - cste * (double)i2 / (double)N;
                    }
                    k /= (double)N * cste;
                    int r = (int)((double)N * (k += 0.5));
                    return this.buffer[r];
                }
            }
            return this.buffer[Rank.this.rank * N / 100];
        }
    }

    private class RankHeavyThread
    extends Thread {
        private WritableRaster wro = null;
        private WritableRaster wrr = null;
        private int order = 0;
        private int length = 0;
        private CoordinatesWeighted[] se = null;
        private CoordinatesWeighted[] forward = null;
        private CoordinatesWeighted[] backward = null;
        private int minx;
        private int miny;
        private int maxx;
        private int maxy;
        private int type;
        private int width;
        private int height;
        private int channel;
        private int widthchannel;
        private short[] shortbufferin = null;
        private short[] shortbufferout = null;
        private byte[] bytebufferin = null;
        private byte[] bytebufferout = null;
        public Object lock = new Object();
        private int[] buffer = null;
        private int[] Hist = null;
        private int FixN = 0;
        private double rankdouble = 0.0;
        private int mini;
        private int maxi;
        private int level;
        private int flag;
        private boolean Kill = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void Kill() {
            this.wrr = null;
            this.wro = null;
            this.backward = null;
            this.forward = null;
            this.se = null;
            this.shortbufferin = null;
            this.shortbufferout = null;
            this.bytebufferin = null;
            this.bytebufferout = null;
            this.Hist = null;
            this.buffer = null;
            this.Kill = true;
            Object object = this.lock;
            synchronized (object) {
                this.lock.notify();
            }
        }

        public void setConditions(BufferedImage Original, BufferedImage Result, StructuringElement SE, int rank, int minx, int miny, int maxx, int maxy) {
            this.order = SE.getSize() >> 1;
            this.rankdouble = (double)rank / 100.0;
            this.se = SE.getSE();
            this.forward = SE.getForward();
            this.backward = SE.getBackward();
            this.length = this.se.length;
            this.minx = minx;
            this.miny = miny;
            this.maxx = maxx;
            this.maxy = maxy;
            this.width = Original.getWidth();
            this.height = Original.getHeight();
            this.type = Original.getType();
            if (this.buffer == null || this.buffer.length != this.length) {
                this.buffer = null;
                this.buffer = new int[this.length];
            }
            this.FixN = (int)((double)(this.length - 1) * (double)rank / 100.0 + 0.5);
            switch (rank) {
                case 0: {
                    this.FixN = 0;
                    break;
                }
                case 100: {
                    this.FixN = this.length - 1;
                    break;
                }
                case 75: {
                    this.FixN = 3 * this.length >> 2;
                    break;
                }
                case 50: {
                    this.FixN = this.length >> 1;
                    break;
                }
                case 25: {
                    this.FixN = this.length >> 2;
                }
            }
            switch (Original.getType()) {
                case 1: 
                case 2: 
                case 4: 
                case 12: {
                    this.wro = Original.getRaster();
                    this.wrr = Result.getRaster();
                    break;
                }
                case 10: {
                    if (this.Hist == null || this.Hist.length != 256) {
                        this.Hist = null;
                        this.Hist = new int[256];
                    }
                    this.bytebufferin = ((DataBufferByte)Original.getRaster().getDataBuffer()).getData();
                    this.bytebufferout = ((DataBufferByte)Result.getRaster().getDataBuffer()).getData();
                    break;
                }
                case 5: 
                case 6: {
                    this.channel = Original.getRaster().getNumBands();
                    this.widthchannel = this.width * this.channel;
                    if (this.Hist == null || this.Hist.length != 256) {
                        this.Hist = null;
                        this.Hist = new int[256];
                    }
                    this.bytebufferin = ((DataBufferByte)Original.getRaster().getDataBuffer()).getData();
                    this.bytebufferout = ((DataBufferByte)Result.getRaster().getDataBuffer()).getData();
                    break;
                }
                case 11: {
                    this.shortbufferin = ((DataBufferUShort)Original.getRaster().getDataBuffer()).getData();
                    this.shortbufferout = ((DataBufferUShort)Result.getRaster().getDataBuffer()).getData();
                    if (this.Hist != null && this.Hist.length == 65536) break;
                    this.Hist = null;
                    this.Hist = new int[65536];
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported image type.");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            coord = null;
            block12: while (true) {
                var11_12 = this.lock;
                synchronized (var11_12) {
                    try {
                        Rank.this.addFreeThread();
                        this.lock.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                if (this.Kill) {
                    return;
                }
                MinX = this.minx < this.order ? this.order : this.minx;
                MinY = this.miny < this.order ? this.order : this.miny;
                MaxX = this.maxx >= this.width - this.order ? this.width - this.order : this.maxx;
                MaxY = this.maxy >= this.height - this.order ? this.height - this.order : this.maxy;
                switch (this.type) {
                    case 12: {
                        for (i = MinY; i < MaxY; ++i) {
                            for (j = MinX; j < MaxX; ++j) {
                                for (l = 0; l < this.length; ++l) {
                                    coord = this.se[l];
                                    this.buffer[l] = this.wro.getSample(j + coord.X, i + coord.Y, 0);
                                }
                                this.wrr.setSample(j, i, 0, this.SortAndFind());
                            }
                        }
                        i = this.miny;
                        while (true) {
                            if (i >= this.maxy) continue block12;
                            for (j = this.minx; j < this.maxx; ++j) {
                                if (i >= this.order && j >= this.order && i < this.height - this.order && j < this.width - this.order) continue;
                                nb = 0;
                                for (l = 0; l < this.length; ++l) {
                                    coord = this.se[l];
                                    if (i + coord.Y < 0 || i + coord.Y >= this.height || j + coord.X < 0 || j + coord.X >= this.width) continue;
                                    this.buffer[nb++] = this.wro.getSample(j + coord.X, i + coord.Y, 0);
                                }
                                this.wrr.setSample(j, i, 0, this.SortAndFind(nb));
                            }
                            ++i;
                        }
                    }
                    case 10: {
                        i = this.miny;
                        pos = this.miny * this.width;
                        while (true) {
                            if (i >= this.maxy) continue block12;
                            if (i < MinY || MaxY <= i) {
                                size = 0;
                                this.maxi = 0;
                                this.mini = 255;
                                for (l = 0; l < this.length; ++l) {
                                    coord = this.se[l];
                                    if (0 > coord.X || 0 > i + coord.Y || i + coord.Y >= this.height) continue;
                                    v0 = v = this.bytebufferin[pos + this.se[l].Pos] & 255;
                                    this.Hist[v0] = this.Hist[v0] + 1;
                                    if (this.maxi < v) {
                                        this.maxi = v;
                                    }
                                    if (this.mini > v) {
                                        this.mini = v;
                                    }
                                    ++size;
                                }
                                posrank = (int)(this.rankdouble * (double)size);
                                this.FindFlagLevel(posrank, size);
                                this.bytebufferout[pos] = (byte)this.flag;
                                for (j = 1; j < MinX + 1; ++j) {
                                    for (l = 0; l < this.forward.length; ++l) {
                                        coord = this.forward[l];
                                        if (0 > j + coord.X || 0 > i + coord.Y || i + coord.Y >= this.height) continue;
                                        v1 = v = this.bytebufferin[pos + this.forward[l].Pos + j] & 255;
                                        this.Hist[v1] = this.Hist[v1] + 1;
                                        if (this.maxi < v) {
                                            this.maxi = v;
                                        }
                                        if (this.mini > v) {
                                            this.mini = v;
                                        }
                                        ++size;
                                    }
                                    for (l = 0; l < this.backward.length; ++l) {
                                        coord = this.backward[l];
                                        if (0 > j + coord.X || 0 > i + coord.Y || i + coord.Y >= this.height) continue;
                                        v2 = this.bytebufferin[pos + this.backward[l].Pos + j] & 255;
                                        this.Hist[v2] = this.Hist[v2] - 1;
                                        while (this.Hist[this.maxi] == 0) {
                                            --this.maxi;
                                        }
                                        while (this.Hist[this.mini] == 0) {
                                            ++this.mini;
                                        }
                                        --size;
                                    }
                                    posrank = (int)(this.rankdouble * (double)size);
                                    this.FindFlagLevel(posrank, size);
                                    this.bytebufferout[pos + j] = (byte)this.flag;
                                }
                                while (j < MaxX) {
                                    for (l = 0; l < this.forward.length; ++l) {
                                        coord = this.forward[l];
                                        if (0 > i + coord.Y || i + coord.Y >= this.height) continue;
                                        v3 = v = this.bytebufferin[pos + this.forward[l].Pos + j] & 255;
                                        this.Hist[v3] = this.Hist[v3] + 1;
                                        if (this.maxi < v) {
                                            this.maxi = v;
                                        }
                                        if (this.mini > v) {
                                            this.mini = v;
                                        }
                                        ++size;
                                    }
                                    for (l = 0; l < this.backward.length; ++l) {
                                        coord = this.backward[l];
                                        if (0 > i + coord.Y || i + coord.Y >= this.height) continue;
                                        v4 = this.bytebufferin[pos + this.backward[l].Pos + j] & 255;
                                        this.Hist[v4] = this.Hist[v4] - 1;
                                        while (this.Hist[this.maxi] == 0) {
                                            --this.maxi;
                                        }
                                        while (this.Hist[this.mini] == 0) {
                                            ++this.mini;
                                        }
                                        --size;
                                    }
                                    posrank = (int)(this.rankdouble * (double)size);
                                    this.FindFlagLevel(posrank, size);
                                    this.bytebufferout[pos + j] = (byte)this.flag;
                                    ++j;
                                }
                                while (j < this.maxx) {
                                    for (l = 0; l < this.forward.length; ++l) {
                                        coord = this.forward[l];
                                        if (j + coord.X >= this.width || 0 > i + coord.Y || i + coord.Y >= this.height) continue;
                                        v5 = v = this.bytebufferin[pos + this.forward[l].Pos + j] & 255;
                                        this.Hist[v5] = this.Hist[v5] + 1;
                                        if (this.maxi < v) {
                                            this.maxi = v;
                                        }
                                        if (this.mini > v) {
                                            this.mini = v;
                                        }
                                        ++size;
                                    }
                                    for (l = 0; l < this.backward.length; ++l) {
                                        coord = this.backward[l];
                                        if (j + coord.X >= this.width || 0 > i + coord.Y || i + coord.Y >= this.height) continue;
                                        v6 = this.bytebufferin[pos + this.backward[l].Pos + j] & 255;
                                        this.Hist[v6] = this.Hist[v6] - 1;
                                        while (this.Hist[this.maxi] == 0) {
                                            --this.maxi;
                                        }
                                        while (this.Hist[this.mini] == 0) {
                                            ++this.mini;
                                        }
                                        --size;
                                    }
                                    posrank = (int)(this.rankdouble * (double)size);
                                    this.FindFlagLevel(posrank, size);
                                    this.bytebufferout[pos + j] = (byte)this.flag;
                                    ++j;
                                }
                                Arrays.fill(this.Hist, 0);
                            } else {
                                size = 0;
                                this.maxi = 0;
                                this.mini = 255;
                                for (l = 0; l < this.length; ++l) {
                                    coord = this.se[l];
                                    if (0 > coord.X) continue;
                                    v7 = v = this.bytebufferin[pos + this.se[l].Pos] & 255;
                                    this.Hist[v7] = this.Hist[v7] + 1;
                                    if (this.maxi < v) {
                                        this.maxi = v;
                                    }
                                    if (this.mini > v) {
                                        this.mini = v;
                                    }
                                    ++size;
                                }
                                posrank = (int)(this.rankdouble * (double)size);
                                this.FindFlagLevel(posrank, size);
                                this.bytebufferout[pos] = (byte)this.flag;
                                for (j = 1; j < MinX + 1; ++j) {
                                    for (l = 0; l < this.forward.length; ++l) {
                                        coord = this.forward[l];
                                        v8 = v = this.bytebufferin[pos + this.forward[l].Pos + j] & 255;
                                        this.Hist[v8] = this.Hist[v8] + 1;
                                        if (this.maxi < v) {
                                            this.maxi = v;
                                        }
                                        if (this.mini > v) {
                                            this.mini = v;
                                        }
                                        ++size;
                                    }
                                    for (l = 0; l < this.backward.length; ++l) {
                                        coord = this.backward[l];
                                        if (j + coord.X < 0) continue;
                                        v9 = this.bytebufferin[pos + this.backward[l].Pos + j] & 255;
                                        this.Hist[v9] = this.Hist[v9] - 1;
                                        while (this.Hist[this.maxi] == 0) {
                                            --this.maxi;
                                        }
                                        while (this.Hist[this.mini] == 0) {
                                            ++this.mini;
                                        }
                                        --size;
                                    }
                                    posrank = (int)(this.rankdouble * (double)size);
                                    this.FindFlagLevel(posrank, size);
                                    this.bytebufferout[pos + j] = (byte)this.flag;
                                }
                                while (j < MaxX) {
                                    for (l = 0; l < this.forward.length; ++l) {
                                        coord = this.forward[l];
                                        v10 = v = this.bytebufferin[pos + this.forward[l].Pos + j] & 255;
                                        this.Hist[v10] = this.Hist[v10] + 1;
                                        if (this.maxi < v) {
                                            this.maxi = v;
                                        }
                                        if (this.mini > v) {
                                            this.mini = v;
                                        }
                                        ++size;
                                    }
                                    for (l = 0; l < this.backward.length; ++l) {
                                        coord = this.backward[l];
                                        v11 = this.bytebufferin[pos + this.backward[l].Pos + j] & 255;
                                        this.Hist[v11] = this.Hist[v11] - 1;
                                        while (this.Hist[this.maxi] == 0) {
                                            --this.maxi;
                                        }
                                        while (this.Hist[this.mini] == 0) {
                                            ++this.mini;
                                        }
                                        --size;
                                    }
                                    posrank = (int)(this.rankdouble * (double)size);
                                    this.FindFlagLevel(posrank, size);
                                    this.bytebufferout[pos + j] = (byte)this.flag;
                                    ++j;
                                }
                                while (j < this.maxx) {
                                    for (l = 0; l < this.forward.length; ++l) {
                                        coord = this.forward[l];
                                        if (j + coord.X >= this.width) continue;
                                        v12 = v = this.bytebufferin[pos + this.forward[l].Pos + j] & 255;
                                        this.Hist[v12] = this.Hist[v12] + 1;
                                        if (this.maxi < v) {
                                            this.maxi = v;
                                        }
                                        if (this.mini > v) {
                                            this.mini = v;
                                        }
                                        ++size;
                                    }
                                    for (l = 0; l < this.backward.length; ++l) {
                                        coord = this.backward[l];
                                        v13 = this.bytebufferin[pos + this.backward[l].Pos + j] & 255;
                                        this.Hist[v13] = this.Hist[v13] - 1;
                                        while (this.Hist[this.maxi] == 0) {
                                            --this.maxi;
                                        }
                                        while (this.Hist[this.mini] == 0) {
                                            ++this.mini;
                                        }
                                        --size;
                                    }
                                    posrank = (int)(this.rankdouble * (double)size);
                                    this.FindFlagLevel(posrank, size);
                                    this.bytebufferout[pos + j] = (byte)this.flag;
                                    ++j;
                                }
                                Arrays.fill(this.Hist, 0);
                            }
                            ++i;
                            pos += this.width;
                        }
                    }
                    case 5: 
                    case 6: {
                        c = 0;
                        while (true) {
                            if (c >= this.channel) continue block12;
                            i = this.miny;
                            pos = this.miny * this.widthchannel;
                            while (i < this.maxy) {
                                if (i < MinY || MaxY <= i) {
                                    size = 0;
                                    this.maxi = 0;
                                    this.mini = 255;
                                    for (l = 0; l < this.length; ++l) {
                                        coord = this.se[l];
                                        if (0 > coord.X || 0 > i + coord.Y || i + coord.Y >= this.height) continue;
                                        v14 = v = this.bytebufferin[pos + this.se[l].Pos + c] & 255;
                                        this.Hist[v14] = this.Hist[v14] + 1;
                                        if (this.maxi < v) {
                                            this.maxi = v;
                                        }
                                        if (this.mini > v) {
                                            this.mini = v;
                                        }
                                        ++size;
                                    }
                                    posrank = (int)(this.rankdouble * (double)size);
                                    this.FindFlagLevel(posrank, size);
                                    this.bytebufferout[pos + c] = (byte)this.flag;
                                    j = 1;
                                    jchannel = this.channel;
                                    while (j < MinX + 1) {
                                        for (l = 0; l < this.forward.length; ++l) {
                                            coord = this.forward[l];
                                            if (0 > j + coord.X || 0 > i + coord.Y || i + coord.Y >= this.height) continue;
                                            v15 = v = this.bytebufferin[pos + this.forward[l].Pos + jchannel + c] & 255;
                                            this.Hist[v15] = this.Hist[v15] + 1;
                                            if (this.maxi < v) {
                                                this.maxi = v;
                                            }
                                            if (this.mini > v) {
                                                this.mini = v;
                                            }
                                            ++size;
                                        }
                                        for (l = 0; l < this.backward.length; ++l) {
                                            coord = this.backward[l];
                                            if (0 > j + coord.X || 0 > i + coord.Y || i + coord.Y >= this.height) continue;
                                            v16 = this.bytebufferin[pos + this.backward[l].Pos + jchannel + c] & 255;
                                            this.Hist[v16] = this.Hist[v16] - 1;
                                            while (this.Hist[this.maxi] == 0) {
                                                --this.maxi;
                                            }
                                            while (this.Hist[this.mini] == 0) {
                                                ++this.mini;
                                            }
                                            --size;
                                        }
                                        posrank = (int)(this.rankdouble * (double)size);
                                        this.FindFlagLevel(posrank, size);
                                        this.bytebufferout[pos + jchannel + c] = (byte)this.flag;
                                        ++j;
                                        jchannel += this.channel;
                                    }
                                    while (j < MaxX) {
                                        for (l = 0; l < this.forward.length; ++l) {
                                            coord = this.forward[l];
                                            if (0 > i + coord.Y || i + coord.Y >= this.height) continue;
                                            v17 = v = this.bytebufferin[pos + this.forward[l].Pos + jchannel + c] & 255;
                                            this.Hist[v17] = this.Hist[v17] + 1;
                                            if (this.maxi < v) {
                                                this.maxi = v;
                                            }
                                            if (this.mini > v) {
                                                this.mini = v;
                                            }
                                            ++size;
                                        }
                                        for (l = 0; l < this.backward.length; ++l) {
                                            coord = this.backward[l];
                                            if (0 > i + coord.Y || i + coord.Y >= this.height) continue;
                                            v18 = this.bytebufferin[pos + this.backward[l].Pos + jchannel + c] & 255;
                                            this.Hist[v18] = this.Hist[v18] - 1;
                                            while (this.Hist[this.maxi] == 0) {
                                                --this.maxi;
                                            }
                                            while (this.Hist[this.mini] == 0) {
                                                ++this.mini;
                                            }
                                            --size;
                                        }
                                        posrank = (int)(this.rankdouble * (double)size);
                                        this.FindFlagLevel(posrank, size);
                                        this.bytebufferout[pos + jchannel + c] = (byte)this.flag;
                                        ++j;
                                        jchannel += this.channel;
                                    }
                                    while (j < this.maxx) {
                                        for (l = 0; l < this.forward.length; ++l) {
                                            coord = this.forward[l];
                                            if (j + coord.X >= this.width || 0 > i + coord.Y || i + coord.Y >= this.height) continue;
                                            v19 = v = this.bytebufferin[pos + this.forward[l].Pos + jchannel + c] & 255;
                                            this.Hist[v19] = this.Hist[v19] + 1;
                                            if (this.maxi < v) {
                                                this.maxi = v;
                                            }
                                            if (this.mini > v) {
                                                this.mini = v;
                                            }
                                            ++size;
                                        }
                                        for (l = 0; l < this.backward.length; ++l) {
                                            coord = this.backward[l];
                                            if (j + coord.X >= this.width || 0 > i + coord.Y || i + coord.Y >= this.height) continue;
                                            v20 = this.bytebufferin[pos + this.backward[l].Pos + jchannel + c] & 255;
                                            this.Hist[v20] = this.Hist[v20] - 1;
                                            while (this.Hist[this.maxi] == 0) {
                                                --this.maxi;
                                            }
                                            while (this.Hist[this.mini] == 0) {
                                                ++this.mini;
                                            }
                                            --size;
                                        }
                                        posrank = (int)(this.rankdouble * (double)size);
                                        this.FindFlagLevel(posrank, size);
                                        this.bytebufferout[pos + j * this.channel + c] = (byte)this.flag;
                                        ++j;
                                        jchannel += this.channel;
                                    }
                                    Arrays.fill(this.Hist, 0);
                                } else {
                                    size = 0;
                                    this.maxi = 0;
                                    this.mini = 255;
                                    for (l = 0; l < this.length; ++l) {
                                        coord = this.se[l];
                                        if (0 > coord.X) continue;
                                        v21 = v = this.bytebufferin[pos + this.se[l].Pos + c] & 255;
                                        this.Hist[v21] = this.Hist[v21] + 1;
                                        if (this.maxi < v) {
                                            this.maxi = v;
                                        }
                                        if (this.mini > v) {
                                            this.mini = v;
                                        }
                                        ++size;
                                    }
                                    posrank = (int)(this.rankdouble * (double)size);
                                    this.FindFlagLevel(posrank, size);
                                    this.bytebufferout[pos + c] = (byte)this.flag;
                                    j = 1;
                                    jchannel = this.channel;
                                    while (j < MinX + 1) {
                                        for (l = 0; l < this.forward.length; ++l) {
                                            v22 = v = this.bytebufferin[pos + this.forward[l].Pos + jchannel + c] & 255;
                                            this.Hist[v22] = this.Hist[v22] + 1;
                                            if (this.maxi < v) {
                                                this.maxi = v;
                                            }
                                            if (this.mini > v) {
                                                this.mini = v;
                                            }
                                            ++size;
                                        }
                                        for (l = 0; l < this.backward.length; ++l) {
                                            if (j + this.backward[l].X < 0) continue;
                                            v23 = this.bytebufferin[pos + this.backward[l].Pos + jchannel + c] & 255;
                                            this.Hist[v23] = this.Hist[v23] - 1;
                                            while (this.Hist[this.maxi] == 0) {
                                                --this.maxi;
                                            }
                                            while (this.Hist[this.mini] == 0) {
                                                ++this.mini;
                                            }
                                            --size;
                                        }
                                        posrank = (int)(this.rankdouble * (double)size);
                                        this.FindFlagLevel(posrank, size);
                                        this.bytebufferout[pos + jchannel + c] = (byte)this.flag;
                                        ++j;
                                        jchannel += this.channel;
                                    }
                                    while (j < MaxX) {
                                        for (l = 0; l < this.forward.length; ++l) {
                                            v24 = v = this.bytebufferin[pos + this.forward[l].Pos + jchannel + c] & 255;
                                            this.Hist[v24] = this.Hist[v24] + 1;
                                            if (this.maxi < v) {
                                                this.maxi = v;
                                            }
                                            if (this.mini > v) {
                                                this.mini = v;
                                            }
                                            ++size;
                                        }
                                        for (l = 0; l < this.backward.length; ++l) {
                                            v25 = this.bytebufferin[pos + this.backward[l].Pos + jchannel + c] & 255;
                                            this.Hist[v25] = this.Hist[v25] - 1;
                                            while (this.Hist[this.maxi] == 0) {
                                                --this.maxi;
                                            }
                                            while (this.Hist[this.mini] == 0) {
                                                ++this.mini;
                                            }
                                            --size;
                                        }
                                        posrank = (int)(this.rankdouble * (double)size);
                                        this.FindFlagLevel(posrank, size);
                                        this.bytebufferout[pos + jchannel + c] = (byte)this.flag;
                                        ++j;
                                        jchannel += this.channel;
                                    }
                                    while (j < this.maxx) {
                                        for (l = 0; l < this.forward.length; ++l) {
                                            if (j + this.forward[l].X >= this.width) continue;
                                            v26 = v = this.bytebufferin[pos + this.forward[l].Pos + jchannel + c] & 255;
                                            this.Hist[v26] = this.Hist[v26] + 1;
                                            if (this.maxi < v) {
                                                this.maxi = v;
                                            }
                                            if (this.mini > v) {
                                                this.mini = v;
                                            }
                                            ++size;
                                        }
                                        for (l = 0; l < this.backward.length; ++l) {
                                            v27 = this.bytebufferin[pos + this.backward[l].Pos + jchannel + c] & 255;
                                            this.Hist[v27] = this.Hist[v27] - 1;
                                            while (this.Hist[this.maxi] == 0) {
                                                --this.maxi;
                                            }
                                            while (this.Hist[this.mini] == 0) {
                                                ++this.mini;
                                            }
                                            --size;
                                        }
                                        posrank = (int)(this.rankdouble * (double)size);
                                        this.FindFlagLevel(posrank, size);
                                        this.bytebufferout[pos + jchannel + c] = (byte)this.flag;
                                        ++j;
                                        jchannel += this.channel;
                                    }
                                    Arrays.fill(this.Hist, 0);
                                }
                                ++i;
                                pos += this.widthchannel;
                            }
                            ++c;
                        }
                    }
                    case 11: {
                        i = this.miny;
                        pos = this.miny * this.width;
                        while (true) {
                            if (i >= this.maxy) continue block12;
                            if (i < MinY || MaxY <= i) {
                                size = 0;
                                this.maxi = 0;
                                this.mini = 65535;
                                for (l = 0; l < this.length; ++l) {
                                    coord = this.se[l];
                                    if (0 > coord.X || 0 > i + coord.Y || i + coord.Y >= this.height) continue;
                                    v28 = v = this.shortbufferin[pos + this.se[l].Pos] & 65535;
                                    this.Hist[v28] = this.Hist[v28] + 1;
                                    if (this.maxi < v) {
                                        this.maxi = v;
                                    }
                                    if (this.mini > v) {
                                        this.mini = v;
                                    }
                                    ++size;
                                }
                                posrank = (int)(this.rankdouble * (double)size);
                                this.FindFlagLevel(posrank, size);
                                this.shortbufferout[pos] = (short)this.flag;
                                for (j = 1; j < MinX + 1; ++j) {
                                    for (l = 0; l < this.forward.length; ++l) {
                                        coord = this.forward[l];
                                        if (0 > coord.X || 0 > i + coord.Y || i + coord.Y >= this.height) continue;
                                        v29 = v = this.shortbufferin[pos + this.forward[l].Pos + j] & 65535;
                                        this.Hist[v29] = this.Hist[v29] + 1;
                                        if (this.maxi < v) {
                                            this.maxi = v;
                                        }
                                        if (this.mini > v) {
                                            this.mini = v;
                                        }
                                        ++size;
                                    }
                                    for (l = 0; l < this.backward.length; ++l) {
                                        coord = this.backward[l];
                                        if (0 > j + coord.X || 0 > i + coord.Y || i + coord.Y >= this.height) continue;
                                        v30 = this.shortbufferin[pos + this.backward[l].Pos + j] & 65535;
                                        this.Hist[v30] = this.Hist[v30] - 1;
                                        while (this.Hist[this.maxi] == 0) {
                                            --this.maxi;
                                        }
                                        while (this.Hist[this.mini] == 0) {
                                            ++this.mini;
                                        }
                                        --size;
                                    }
                                    posrank = (int)(this.rankdouble * (double)size);
                                    this.FindFlagLevel(posrank, size);
                                    this.shortbufferout[pos + j] = (short)this.flag;
                                }
                                while (j < MaxX) {
                                    for (l = 0; l < this.forward.length; ++l) {
                                        coord = this.forward[l];
                                        if (0 > i + coord.Y || i + coord.Y >= this.height) continue;
                                        v31 = v = this.shortbufferin[pos + this.forward[l].Pos + j] & 65535;
                                        this.Hist[v31] = this.Hist[v31] + 1;
                                        if (this.maxi < v) {
                                            this.maxi = v;
                                        }
                                        if (this.mini > v) {
                                            this.mini = v;
                                        }
                                        ++size;
                                    }
                                    for (l = 0; l < this.backward.length; ++l) {
                                        coord = this.backward[l];
                                        if (0 > i + coord.Y || i + coord.Y >= this.height) continue;
                                        v32 = this.shortbufferin[pos + this.backward[l].Pos + j] & 65535;
                                        this.Hist[v32] = this.Hist[v32] - 1;
                                        while (this.Hist[this.maxi] == 0) {
                                            --this.maxi;
                                        }
                                        while (this.Hist[this.mini] == 0) {
                                            ++this.mini;
                                        }
                                        --size;
                                    }
                                    posrank = (int)(this.rankdouble * (double)size);
                                    this.FindFlagLevel(posrank, size);
                                    this.shortbufferout[pos + j] = (short)this.flag;
                                    ++j;
                                }
                                while (j < this.maxx) {
                                    for (l = 0; l < this.forward.length; ++l) {
                                        coord = this.forward[l];
                                        if (j + coord.X >= this.width || 0 > i + coord.Y || i + coord.Y >= this.height) continue;
                                        v33 = v = this.shortbufferin[pos + this.forward[l].Pos + j] & 65535;
                                        this.Hist[v33] = this.Hist[v33] + 1;
                                        if (this.maxi < v) {
                                            this.maxi = v;
                                        }
                                        if (this.mini > v) {
                                            this.mini = v;
                                        }
                                        ++size;
                                    }
                                    for (l = 0; l < this.backward.length; ++l) {
                                        coord = this.backward[l];
                                        if (j + coord.X >= this.width || 0 > i + coord.Y || i + coord.Y >= this.height) continue;
                                        v34 = this.shortbufferin[pos + this.backward[l].Pos + j] & 65535;
                                        this.Hist[v34] = this.Hist[v34] - 1;
                                        while (this.Hist[this.maxi] == 0) {
                                            --this.maxi;
                                        }
                                        while (this.Hist[this.mini] == 0) {
                                            ++this.mini;
                                        }
                                        --size;
                                    }
                                    posrank = (int)(this.rankdouble * (double)size);
                                    this.FindFlagLevel(posrank, size);
                                    this.shortbufferout[pos + j] = (short)this.flag;
                                    ++j;
                                }
                                Arrays.fill(this.Hist, 0);
                            } else {
                                size = 0;
                                this.maxi = 0;
                                this.mini = 65535;
                                for (l = 0; l < this.length; ++l) {
                                    if (0 > this.se[l].X) continue;
                                    v35 = v = this.shortbufferin[pos + this.se[l].Pos] & 65535;
                                    this.Hist[v35] = this.Hist[v35] + 1;
                                    if (this.maxi < v) {
                                        this.maxi = v;
                                    }
                                    if (this.mini > v) {
                                        this.mini = v;
                                    }
                                    ++size;
                                }
                                posrank = (int)(this.rankdouble * (double)size);
                                this.FindFlagLevel(posrank, size);
                                this.shortbufferout[pos] = (short)this.flag;
                                for (j = 1; j < MinX + 1; ++j) {
                                    for (l = 0; l < this.forward.length; ++l) {
                                        coord = this.forward[l];
                                        v36 = v = this.shortbufferin[pos + this.forward[l].Pos + j] & 65535;
                                        this.Hist[v36] = this.Hist[v36] + 1;
                                        if (this.maxi < v) {
                                            this.maxi = v;
                                        }
                                        if (this.mini > v) {
                                            this.mini = v;
                                        }
                                        ++size;
                                    }
                                    for (l = 0; l < this.backward.length; ++l) {
                                        if (j + this.backward[l].X < 0) continue;
                                        v37 = this.shortbufferin[pos + this.backward[l].Pos + j] & 65535;
                                        this.Hist[v37] = this.Hist[v37] - 1;
                                        while (this.Hist[this.maxi] == 0) {
                                            --this.maxi;
                                        }
                                        while (this.Hist[this.mini] == 0) {
                                            ++this.mini;
                                        }
                                        --size;
                                    }
                                    posrank = (int)(this.rankdouble * (double)size);
                                    this.FindFlagLevel(posrank, size);
                                    this.shortbufferout[pos + j] = (short)this.flag;
                                }
                                while (j < MaxX) {
                                    for (l = 0; l < this.forward.length; ++l) {
                                        v38 = v = this.shortbufferin[pos + this.forward[l].Pos + j] & 65535;
                                        this.Hist[v38] = this.Hist[v38] + 1;
                                        if (this.maxi < v) {
                                            this.maxi = v;
                                        }
                                        if (this.mini > v) {
                                            this.mini = v;
                                        }
                                        ++size;
                                    }
                                    for (l = 0; l < this.backward.length; ++l) {
                                        v39 = this.shortbufferin[pos + this.backward[l].Pos + j] & 65535;
                                        this.Hist[v39] = this.Hist[v39] - 1;
                                        while (this.Hist[this.maxi] == 0) {
                                            --this.maxi;
                                        }
                                        while (this.Hist[this.mini] == 0) {
                                            ++this.mini;
                                        }
                                        --size;
                                    }
                                    posrank = (int)(this.rankdouble * (double)size);
                                    this.FindFlagLevel(posrank, size);
                                    this.shortbufferout[pos + j] = (short)this.flag;
                                    ++j;
                                }
                                while (j < this.maxx) {
                                    for (l = 0; l < this.forward.length; ++l) {
                                        if (j + this.forward[l].X >= this.width) continue;
                                        v40 = v = this.shortbufferin[pos + this.forward[l].Pos + j] & 65535;
                                        this.Hist[v40] = this.Hist[v40] + 1;
                                        if (this.maxi < v) {
                                            this.maxi = v;
                                        }
                                        if (this.mini > v) {
                                            this.mini = v;
                                        }
                                        ++size;
                                    }
                                    for (l = 0; l < this.backward.length; ++l) {
                                        coord = this.backward[l];
                                        v41 = this.shortbufferin[pos + this.backward[l].Pos + j] & 65535;
                                        this.Hist[v41] = this.Hist[v41] - 1;
                                        while (this.Hist[this.maxi] == 0) {
                                            --this.maxi;
                                        }
                                        while (this.Hist[this.mini] == 0) {
                                            ++this.mini;
                                        }
                                        --size;
                                    }
                                    posrank = (int)(this.rankdouble * (double)size);
                                    this.FindFlagLevel(posrank, size);
                                    this.shortbufferout[pos + j] = (short)this.flag;
                                    ++j;
                                }
                                Arrays.fill(this.Hist, 0);
                            }
                            ++i;
                            pos += this.width;
                        }
                    }
                    case 1: 
                    case 2: 
                    case 4: {
                        for (i = MinY; i < MaxY; ++i) {
                            for (j = MinX; j < MaxX; ++j) {
                                for (c = 0; c < this.channel; ++c) {
                                    for (l = 0; l < this.length; ++l) {
                                        coord = this.se[l];
                                        this.buffer[l] = this.wro.getSample(j + coord.X, i + coord.Y, c);
                                    }
                                    this.wrr.setSample(j, i, c, this.SortAndFind());
                                }
                            }
                        }
                        i = this.miny;
                        while (true) {
                            if (i < this.maxy) ** break;
                            continue block12;
                            for (j = this.minx; j < this.maxx; ++j) {
                                if (i >= this.order && j >= this.order && i < this.height - this.order && j < this.width - this.order) continue;
                                for (c = 0; c < this.channel; ++c) {
                                    nb = 0;
                                    for (l = 0; l < this.length; ++l) {
                                        coord = this.se[l];
                                        if (i + coord.Y < 0 || i + coord.Y >= this.height || j + coord.X < 0 || j + coord.X >= this.width) continue;
                                        this.buffer[nb++] = this.wro.getSample(j + coord.X, i + coord.Y, c);
                                    }
                                    this.wrr.setSample(j, i, c, this.SortAndFind(nb));
                                }
                            }
                            ++i;
                        }
                    }
                }
                break;
            }
            throw new IllegalArgumentException("Color type not yet supported.");
        }

        private int SortAndFind() {
            Arrays.sort(this.buffer);
            if (Rank.this.rank != -1) {
                return this.buffer[this.FixN];
            }
            double k = 0.0;
            double cste = this.buffer[this.length - 1] - this.buffer[0];
            for (int i2 = 0; i2 < this.length; ++i2) {
                k += (double)this.buffer[i2] - (double)this.buffer[0] - cste * (double)i2 / (double)this.length;
            }
            k /= (double)this.length * cste;
            int r = (int)((double)this.length * (k += 0.5));
            return this.buffer[r];
        }

        private int SortAndFind(int N) {
            Arrays.sort(this.buffer, 0, N);
            switch (Rank.this.rank) {
                case 0: {
                    return this.buffer[0];
                }
                case 100: {
                    return this.buffer[N - 1];
                }
                case 75: {
                    return this.buffer[3 * N >> 2];
                }
                case 50: {
                    return this.buffer[N >> 1];
                }
                case 25: {
                    return this.buffer[N >> 2];
                }
                case -1: {
                    double k = 0.0;
                    double cste = this.buffer[N] - this.buffer[0];
                    for (int i2 = 0; i2 < N; ++i2) {
                        k += (double)this.buffer[i2] - (double)this.buffer[0] - cste * (double)i2 / (double)N;
                    }
                    k /= (double)N * cste;
                    int r = (int)((double)N * (k += 0.5));
                    return this.buffer[r];
                }
            }
            return this.buffer[Rank.this.rank * N / 100];
        }

        private void FindFlagLevel(int posrank, int max) {
            int nb = -1;
            if ((double)Rank.this.rank < 0.5) {
                this.flag = this.mini;
                while (true) {
                    if (this.Hist[this.flag] == 0) {
                        ++this.flag;
                        continue;
                    }
                    this.level = 1;
                    ++nb;
                    while (this.level < this.Hist[this.flag] && nb < posrank) {
                        ++this.level;
                        ++nb;
                    }
                    if (nb >= posrank) break;
                    ++this.flag;
                }
                return;
            }
            this.flag = this.maxi;
            while (true) {
                if (this.Hist[this.flag] == 0) {
                    --this.flag;
                    continue;
                }
                this.level = 1;
                --max;
                while (this.level < this.Hist[this.flag] && posrank < max) {
                    ++this.level;
                    --max;
                }
                if (posrank >= max) break;
                --this.flag;
            }
        }
    }

    private class RankThread
    extends Thread {
        private WritableRaster wro = null;
        private WritableRaster wrr = null;
        private int order = 0;
        private int length = 0;
        private CoordinatesWeighted[] se = null;
        private int minx;
        private int miny;
        private int maxx;
        private int maxy;
        private int type;
        private int width;
        private int height;
        private int channel;
        private int widthchannel;
        private short[] shortbufferin = null;
        private short[] shortbufferout = null;
        private byte[] bytebufferin = null;
        private byte[] bytebufferout = null;
        public Object lock = new Object();
        private int[] buffer = null;
        private int FixN = 0;
        private boolean Kill = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void Kill() {
            this.wrr = null;
            this.wro = null;
            this.se = null;
            this.shortbufferin = null;
            this.shortbufferout = null;
            this.bytebufferin = null;
            this.bytebufferout = null;
            this.buffer = null;
            this.Kill = true;
            Object object = this.lock;
            synchronized (object) {
                this.lock.notify();
            }
        }

        public void setConditions(BufferedImage Original, BufferedImage Result, StructuringElement SE, int rank, int minx, int miny, int maxx, int maxy) {
            this.order = SE.getSize() >> 1;
            this.se = SE.getSE();
            this.length = this.se.length;
            this.minx = minx;
            this.miny = miny;
            this.maxx = maxx;
            this.maxy = maxy;
            this.width = Original.getWidth();
            this.height = Original.getHeight();
            this.type = Original.getType();
            if (this.buffer == null || this.buffer.length != this.length) {
                this.buffer = null;
                this.buffer = new int[this.length];
            }
            this.FixN = (int)((double)(this.length - 1) * (double)rank / 100.0 + 0.5);
            switch (rank) {
                case 0: {
                    this.FixN = 0;
                    break;
                }
                case 100: {
                    this.FixN = this.length - 1;
                    break;
                }
                case 75: {
                    this.FixN = 3 * this.length >> 2;
                    break;
                }
                case 50: {
                    this.FixN = this.length >> 1;
                    break;
                }
                case 25: {
                    this.FixN = this.length >> 2;
                }
            }
            switch (Original.getType()) {
                case 1: 
                case 2: 
                case 4: 
                case 12: {
                    this.wro = Original.getRaster();
                    this.wrr = Result.getRaster();
                    break;
                }
                case 10: {
                    this.bytebufferin = ((DataBufferByte)Original.getRaster().getDataBuffer()).getData();
                    this.bytebufferout = ((DataBufferByte)Result.getRaster().getDataBuffer()).getData();
                    break;
                }
                case 5: 
                case 6: {
                    this.channel = Original.getRaster().getNumBands();
                    this.widthchannel = this.width * this.channel;
                    this.bytebufferin = ((DataBufferByte)Original.getRaster().getDataBuffer()).getData();
                    this.bytebufferout = ((DataBufferByte)Result.getRaster().getDataBuffer()).getData();
                    break;
                }
                case 11: {
                    this.shortbufferin = ((DataBufferUShort)Original.getRaster().getDataBuffer()).getData();
                    this.shortbufferout = ((DataBufferUShort)Result.getRaster().getDataBuffer()).getData();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported image type.");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            coord = null;
            block12: while (true) {
                var8_9 = this.lock;
                synchronized (var8_9) {
                    try {
                        Rank.this.addFreeThread();
                        this.lock.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                if (this.Kill) {
                    return;
                }
                MinX = this.minx < this.order ? this.order : this.minx;
                MinY = this.miny < this.order ? this.order : this.miny;
                MaxX = this.maxx >= this.width - this.order ? this.width - this.order : this.maxx;
                MaxY = this.maxy >= this.height - this.order ? this.height - this.order : this.maxy;
                switch (this.type) {
                    case 12: {
                        for (i = MinY; i < MaxY; ++i) {
                            for (j = MinX; j < MaxX; ++j) {
                                for (l = 0; l < this.length; ++l) {
                                    coord = this.se[l];
                                    this.buffer[l] = this.wro.getSample(j + coord.X, i + coord.Y, 0);
                                }
                                this.wrr.setSample(j, i, 0, this.SortAndFind());
                            }
                        }
                        i = this.miny;
                        while (true) {
                            if (i >= this.maxy) continue block12;
                            for (j = this.minx; j < this.maxx; ++j) {
                                if (i >= this.order && j >= this.order && i < this.height - this.order && j < this.width - this.order) continue;
                                nb = 0;
                                for (l = 0; l < this.length; ++l) {
                                    coord = this.se[l];
                                    if (i + coord.Y < 0 || i + coord.Y >= this.height || j + coord.X < 0 || j + coord.X >= this.width) continue;
                                    this.buffer[nb++] = this.wro.getSample(j + coord.X, i + coord.Y, 0);
                                }
                                this.wrr.setSample(j, i, 0, this.SortAndFind(nb));
                            }
                            ++i;
                        }
                    }
                    case 10: {
                        i = MinY;
                        pos = MinY * this.width;
                        while (i < MaxY) {
                            for (j = MinX; j < MaxX; ++j) {
                                for (l = 0; l < this.length; ++l) {
                                    this.buffer[l] = this.bytebufferin[pos + this.se[l].Pos + j] & 255;
                                }
                                this.bytebufferout[pos + j] = (byte)this.SortAndFind();
                            }
                            ++i;
                            pos += this.width;
                        }
                        i = this.miny;
                        pos = this.miny * this.width;
                        while (true) {
                            if (i >= this.maxy) continue block12;
                            for (j = this.minx; j < this.maxx; ++j) {
                                if (i >= this.order && j >= this.order && i < this.height - this.order && j < this.width - this.order) continue;
                                nb = 0;
                                for (l = 0; l < this.length; ++l) {
                                    coord = this.se[l];
                                    if (i + coord.Y < 0 || i + coord.Y >= this.height || j + coord.X < 0 || j + coord.X >= this.width) continue;
                                    this.buffer[nb++] = this.bytebufferin[pos + this.se[l].Pos + j] & 255;
                                }
                                this.bytebufferout[pos + j] = (byte)this.SortAndFind(nb);
                            }
                            ++i;
                            pos += this.width;
                        }
                    }
                    case 5: 
                    case 6: {
                        c = 0;
                        while (true) {
                            if (c >= this.channel) continue block12;
                            i = MinY;
                            pos = MinY * this.widthchannel + c;
                            while (i < MaxY) {
                                j = MinX;
                                jchannel = j * this.channel;
                                while (j < MaxX) {
                                    for (l = 0; l < this.length; ++l) {
                                        this.buffer[l] = this.bytebufferin[pos + this.se[l].Pos + jchannel] & 255;
                                    }
                                    this.bytebufferout[pos + jchannel] = (byte)this.SortAndFind();
                                    ++j;
                                    jchannel += this.channel;
                                }
                                ++i;
                                pos += this.widthchannel;
                            }
                            i = this.miny;
                            pos = this.miny * this.widthchannel + c;
                            while (i < this.maxy) {
                                j = this.minx;
                                jchannel = j * this.channel;
                                while (j < this.maxx) {
                                    if (i < this.order || j < this.order || i >= this.height - this.order || j >= this.width - this.order) {
                                        nb = 0;
                                        for (l = 0; l < this.length; ++l) {
                                            coord = this.se[l];
                                            if (i + coord.Y < 0 || i + coord.Y >= this.height || j + coord.X < 0 || j + coord.X >= this.width) continue;
                                            this.buffer[nb++] = this.bytebufferin[pos + this.se[l].Pos + jchannel] & 255;
                                        }
                                        this.bytebufferout[pos + jchannel + c] = (byte)this.SortAndFind(nb);
                                    }
                                    ++j;
                                    jchannel += this.channel;
                                }
                                ++i;
                                pos += this.widthchannel;
                            }
                            ++c;
                        }
                    }
                    case 11: {
                        i = MinY;
                        pos = MinY * this.width;
                        while (i < MaxY) {
                            for (j = MinX; j < MaxX; ++j) {
                                for (l = 0; l < this.length; ++l) {
                                    this.buffer[l] = this.shortbufferin[pos + this.se[l].Pos + j] & 65535;
                                }
                                this.shortbufferout[pos + j] = (short)this.SortAndFind();
                            }
                            ++i;
                            pos += this.width;
                        }
                        i = this.miny;
                        pos = this.miny * this.width;
                        while (true) {
                            if (i >= this.maxy) continue block12;
                            for (j = this.minx; j < this.maxx; ++j) {
                                if (i >= this.order && j >= this.order && i < this.height - this.order && j < this.width - this.order) continue;
                                nb = 0;
                                for (l = 0; l < this.length; ++l) {
                                    coord = this.se[l];
                                    if (i + coord.Y < 0 || i + coord.Y >= this.height || j + coord.X < 0 || j + coord.X >= this.width) continue;
                                    this.buffer[nb++] = this.shortbufferin[pos + this.se[l].Pos + j] & 65535;
                                }
                                this.shortbufferout[pos + j] = (short)this.SortAndFind(nb);
                            }
                            ++i;
                            pos += this.width;
                        }
                    }
                    case 1: 
                    case 2: 
                    case 4: {
                        for (i = MinY; i < MaxY; ++i) {
                            for (j = MinX; j < MaxX; ++j) {
                                for (c = 0; c < this.channel; ++c) {
                                    for (l = 0; l < this.length; ++l) {
                                        coord = this.se[l];
                                        this.buffer[l] = this.wro.getSample(j + coord.X, i + coord.Y, c);
                                    }
                                    this.wrr.setSample(j, i, c, this.SortAndFind());
                                }
                            }
                        }
                        i = this.miny;
                        while (true) {
                            if (i < this.maxy) ** break;
                            continue block12;
                            for (j = this.minx; j < this.maxx; ++j) {
                                if (i >= this.order && j >= this.order && i < this.height - this.order && j < this.width - this.order) continue;
                                for (c = 0; c < this.channel; ++c) {
                                    nb = 0;
                                    for (l = 0; l < this.length; ++l) {
                                        coord = this.se[l];
                                        if (i + coord.Y < 0 || i + coord.Y >= this.height || j + coord.X < 0 || j + coord.X >= this.width) continue;
                                        this.buffer[nb++] = this.wro.getSample(j + coord.X, i + coord.Y, c);
                                    }
                                    this.wrr.setSample(j, i, c, this.SortAndFind(nb));
                                }
                            }
                            ++i;
                        }
                    }
                }
                break;
            }
            throw new IllegalArgumentException("Color type not yet supported.");
        }

        private int SortAndFind() {
            Arrays.sort(this.buffer);
            if (Rank.this.rank != -1) {
                return this.buffer[this.FixN];
            }
            double k = 0.0;
            double cste = this.buffer[this.length - 1] - this.buffer[0];
            for (int i2 = 0; i2 < this.length; ++i2) {
                k += (double)this.buffer[i2] - (double)this.buffer[0] - cste * (double)i2 / (double)this.length;
            }
            k /= (double)this.length * cste;
            int r = (int)((double)this.length * (k += 0.5));
            return this.buffer[r];
        }

        private int SortAndFind(int N) {
            Arrays.sort(this.buffer, 0, N);
            switch (Rank.this.rank) {
                case 0: {
                    return this.buffer[0];
                }
                case 100: {
                    return this.buffer[N - 1];
                }
                case 75: {
                    return this.buffer[3 * N >> 2];
                }
                case 50: {
                    return this.buffer[N >> 1];
                }
                case 25: {
                    return this.buffer[N >> 2];
                }
                case -1: {
                    double k = 0.0;
                    double cste = this.buffer[N] - this.buffer[0];
                    for (int i2 = 0; i2 < N; ++i2) {
                        k += (double)this.buffer[i2] - (double)this.buffer[0] - cste * (double)i2 / (double)N;
                    }
                    k /= (double)N * cste;
                    int r = (int)((double)N * (k += 0.5));
                    return this.buffer[r];
                }
            }
            return this.buffer[Rank.this.rank * N / 100];
        }
    }
}

