/*
 * Decompiled with CFR 0.152.
 */
package morphee.other;

import arrayTiTi.ArrayFeatures;
import arrayTiTi.ArrayOperations;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import java.util.List;

public class Paths {
    private final ArrayFeatures AF = new ArrayFeatures();
    private PathsThread[] threads = null;
    private final List<Integer> threadsfree = new ArrayList<Integer>(13);
    private int[][] accumulator = null;
    private int[][] connections = null;
    private int[][] markerstart = null;
    private int[][] markersend = null;
    private final int[][][] directions = new int[][][]{new int[][]{{1, 0}, {1, 1}, {1, -1}}, new int[][]{{0, 1}, {-1, 1}, {1, 1}}, new int[][]{{-1, 0}, {-1, 1}, {-1, -1}}, new int[][]{{0, -1}, {-1, -1}, {1, -1}}, new int[][]{{1, 1}, {0, 1}, {1, 0}}, new int[][]{{-1, 1}, {-1, 0}, {0, 1}}, new int[][]{{-1, -1}, {0, -1}, {-1, 0}}, new int[][]{{1, -1}, {1, 0}, {0, -1}}};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Process(BufferedImage source, int[][] markerstart, int[][] markersend, boolean eightconnex, boolean saveconnections, int nbCPU) {
        Object object;
        int width = source.getWidth();
        int height = source.getHeight();
        if (this.accumulator == null || this.accumulator.length != height || this.accumulator[0].length != width) {
            this.accumulator = null;
            this.accumulator = new int[height][width];
        }
        ArrayOperations.Fill((int[][])this.accumulator, (int)0);
        this.markerstart = markerstart;
        this.markersend = markersend;
        if (saveconnections) {
            int max = Math.max(this.AF.Maximum(markerstart), this.AF.Maximum(markersend));
            if (this.connections == null || this.connections.length != max + 1) {
                this.connections = null;
                this.connections = new int[max + 1][max + 1];
            }
            ArrayOperations.Fill((int[][])this.connections, (int)0);
        }
        if (this.threads == null || this.threads.length < nbCPU) {
            this.threadsfree.clear();
            this.threads = null;
            this.threads = new PathsThread[nbCPU];
            for (int i2 = 0; i2 < nbCPU; ++i2) {
                this.threads[i2] = new PathsThread(i2);
                this.threads[i2].start();
            }
            object = this;
            synchronized (object) {
                while (this.threadsfree.size() != nbCPU) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                if (markerstart[y][x] == 0) continue;
                int free = this.getFreeThread();
                this.threads[free].setConditions(source, eightconnex, saveconnections, x, y);
                object = this.threads[free].lock;
                synchronized (object) {
                    this.threads[free].lock.notify();
                    continue;
                }
            }
        }
        object = this;
        synchronized (object) {
            while (this.threadsfree.size() != nbCPU) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private synchronized void IncreaseAccumulator(int x, int y) {
        int[] nArray = this.accumulator[y];
        int n = x;
        nArray[n] = nArray[n] + 1;
    }

    private synchronized void IncreaseConnections(int cc1, int cc2) {
        int[] nArray = this.connections[cc1];
        int n = cc2;
        nArray[n] = nArray[n] + 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void addFreeThread(int number) {
        List<Integer> list = this.threadsfree;
        synchronized (list) {
            this.threadsfree.add(number);
        }
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized int getFreeThread() {
        int free;
        while (this.threadsfree.isEmpty()) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        List<Integer> list = this.threadsfree;
        synchronized (list) {
            free = this.threadsfree.get(0);
            this.threadsfree.remove(0);
        }
        return free;
    }

    public int[][] Accumulator() {
        return this.accumulator;
    }

    public int[][] Connections() {
        return this.connections;
    }

    private class PathsThread
    extends Thread {
        private int number = -1;
        private WritableRaster wr = null;
        private int type;
        private int width;
        private int height;
        private int X;
        private int Y;
        private int max = 0;
        private boolean eightconnex = true;
        private boolean saveconnexions = true;
        private final List<Integer> candidates = new ArrayList<Integer>(5);
        public final Object lock = new Object();

        public PathsThread(int number) {
            this.number = number;
        }

        public void setConditions(BufferedImage source, boolean eightconnex, boolean saveconnexions, int x, int y) {
            this.type = source.getType();
            this.width = source.getWidth();
            this.height = source.getHeight();
            this.X = x;
            this.Y = y;
            this.eightconnex = eightconnex;
            this.saveconnexions = saveconnexions;
            this.wr = null;
            switch (source.getType()) {
                case 10: {
                    this.max = 256;
                    break;
                }
                case 11: {
                    this.max = 65536;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported image type.");
                }
            }
            this.wr = source.getRaster();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            block8: while (true) {
                var8_8 = this.lock;
                synchronized (var8_8) {
                    try {
                        Paths.this.addFreeThread(this.number);
                        this.lock.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                switch (this.type) {
                    case 10: 
                    case 11: 
                    case 12: {
                        for (dir = 0; dir < 4; ++dir) {
                            x = this.X;
                            mark = Paths.this.markerstart[this.Y][this.X];
                            for (y = this.Y; 0 < x && 0 < y && x < this.width - 1 && y < this.height - 1 && (Paths.this.markersend[y][x] == 0 || Paths.this.markersend[y][x] == mark); x += Paths.this.directions[dir][v][0], y += Paths.this.directions[dir][v][1]) {
                                Paths.this.IncreaseAccumulator(x, y);
                                min = this.max;
                                for (i = 0; i < 3; ++i) {
                                    v = this.wr.getSample(x + Paths.this.directions[dir][i][0], y + Paths.this.directions[dir][i][1], 0);
                                    if (v < min) {
                                        min = v;
                                        this.candidates.clear();
                                        this.candidates.add(i);
                                        continue;
                                    }
                                    if (v != min) continue;
                                    this.candidates.add(i);
                                }
                                this.CheckCandidates();
                                v = this.candidates.get(0);
                            }
                            if (!this.saveconnexions || Paths.this.markersend[y][x] == 0 || Paths.this.markersend[y][x] == mark) continue;
                            Paths.this.IncreaseConnections(mark, Paths.this.markersend[y][x]);
                        }
                        if (!this.eightconnex) continue block8;
                        dir = 4;
                        while (true) {
                            if (dir < 8) ** break;
                            continue block8;
                            x = this.X;
                            mark = Paths.this.markerstart[this.Y][this.X];
                            for (y = this.Y; 0 < x && 0 < y && x < this.width - 1 && y < this.height - 1 && (Paths.this.markersend[y][x] == 0 || Paths.this.markersend[y][x] == mark); x += Paths.this.directions[dir][v][0], y += Paths.this.directions[dir][v][1]) {
                                Paths.this.IncreaseAccumulator(x, y);
                                min = this.max;
                                for (i = 0; i < 3; ++i) {
                                    v = this.wr.getSample(x + Paths.this.directions[dir][i][0], y + Paths.this.directions[dir][i][1], 0);
                                    if (v < min) {
                                        min = v;
                                        this.candidates.clear();
                                        this.candidates.add(i);
                                        continue;
                                    }
                                    if (v != min) continue;
                                    this.candidates.add(i);
                                }
                                this.CheckCandidates();
                                v = this.candidates.get(0);
                            }
                            if (this.saveconnexions && Paths.this.markersend[y][x] != 0 && Paths.this.markersend[y][x] != mark) {
                                Paths.this.IncreaseConnections(mark, Paths.this.markersend[y][x]);
                            }
                            ++dir;
                        }
                    }
                }
                break;
            }
            throw new IllegalArgumentException("Image type not supported.");
        }

        private void CheckCandidates() {
            while (1 < this.candidates.size()) {
                this.candidates.remove((int)(Math.random() * (double)this.candidates.size()));
            }
        }
    }
}

