/*
 * Decompiled with CFR 0.152.
 */
package morphee.levelings;

import dv.DV;
import imageTiTi.ImageNew;
import imageTiTi.ImageOperations;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.util.List;
import morphee.Close;
import morphee.Dilate;
import morphee.Erode;
import morphee.Open;
import morphee.StructuringElement;
import morphee.StructuringElement3D;
import morphee.levelings.Leveling;

public class RhoLeveling
implements Leveling {
    private StructuringElement se = new StructuringElement(new Object[]{1, -1});
    protected Dilate dilate = new Dilate(this.se);
    protected Erode erode = new Erode(this.se);
    protected Open open = new Open(this.se);
    protected Close close = new Close(this.se);
    private int Iterations = -1;
    private BufferedImage marker = null;
    private BufferedImage Dil;
    private BufferedImage Cl;
    private BufferedImage Ero;
    private BufferedImage Op;
    private BufferedImage Res;
    private BufferedImage Tmp;

    public RhoLeveling() {
    }

    public RhoLeveling(StructuringElement se) {
        this.setStructuringElement(se);
    }

    @Override
    public BufferedImage Filter(BufferedImage reference, int nbCPU, BufferedImage marker) {
        BufferedImage result = ImageNew.Same((BufferedImage)reference);
        this.Filter(reference, marker, result, nbCPU);
        return result;
    }

    @Override
    public void Filter(BufferedImage reference, BufferedImage marker, BufferedImage result, int nbCPU) {
        this.Marker(marker);
        this.Filter(reference, result, nbCPU);
    }

    public BufferedImage Filter(BufferedImage reference, StructuringElement se, int nbCPU) {
        this.setStructuringElement(se);
        return this.Filter(reference, nbCPU);
    }

    public void Filter(BufferedImage source, StructuringElement se, BufferedImage result, int nbCPU) {
        this.setStructuringElement(se);
        this.Filter(source, result, nbCPU);
    }

    public BufferedImage Filter(BufferedImage reference, int nbCPU) {
        BufferedImage result = ImageNew.Same((BufferedImage)reference);
        this.Filter(reference, result, nbCPU);
        return result;
    }

    public void Filter(BufferedImage reference, BufferedImage result, int nbCPU) {
        if (!ImageTools.areDimensionsAndTypeEqual((BufferedImage)reference, (BufferedImage)this.marker)) {
            throw new IllegalArgumentException("Dimensions or type of reference and marker are different.");
        }
        if (!ImageTools.areDimensionsAndTypeEqual((BufferedImage)reference, (BufferedImage)result)) {
            throw new IllegalArgumentException("Dimensions or type of reference and marker are different.");
        }
        if (this.Ero == null || !ImageTools.areDimensionsAndTypeEqual((BufferedImage)reference, (BufferedImage)this.Ero)) {
            this.Ero = ImageNew.Same((BufferedImage)reference);
            this.Cl = ImageNew.Same((BufferedImage)reference);
            this.Dil = ImageNew.Same((BufferedImage)reference);
            this.Op = ImageNew.Same((BufferedImage)reference);
            this.Res = ImageNew.Same((BufferedImage)reference);
            this.Tmp = ImageNew.Same((BufferedImage)reference);
        }
        ImageNew.Copy((BufferedImage)this.marker, (BufferedImage)result);
        this.Iterations = 0;
        while (true) {
            this.open.Filter(result, this.Op, nbCPU);
            this.dilate.Filter(this.Op, this.Dil, nbCPU);
            ImageOperations.Maximum((BufferedImage)this.Dil, (BufferedImage)result, (BufferedImage)this.Dil);
            this.close.Filter(result, this.Cl, nbCPU);
            this.erode.Filter(this.Cl, this.Ero, nbCPU);
            ImageOperations.Minimum((BufferedImage)this.Ero, (BufferedImage)result, (BufferedImage)this.Ero);
            ImageOperations.Minimum((BufferedImage)reference, (BufferedImage)this.Dil, (BufferedImage)this.Tmp);
            ImageOperations.Maximum((BufferedImage)this.Tmp, (BufferedImage)this.Ero, (BufferedImage)this.Res);
            if (ImageTools.areEqual((BufferedImage)result, (BufferedImage)this.Res)) break;
            ImageNew.Copy((BufferedImage)this.Res, (BufferedImage)result);
            ++this.Iterations;
        }
    }

    public DV Filter(DV source, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public void Filter(DV source, DV result, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public DV Filter(DV source, StructuringElement3D se, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public void Filter(DV source, StructuringElement3D se, DV result, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public StructuringElement3D getStructuringElement3D() {
        return null;
    }

    public void setStructuringElement3D(StructuringElement3D se) {
    }

    public void Marker(BufferedImage marker) {
        this.marker = null;
        this.marker = marker;
    }

    public BufferedImage Marker() {
        return this.marker;
    }

    public StructuringElement getStructuringElement() {
        return this.dilate.getStructuringElement();
    }

    public void setStructuringElement(StructuringElement se) {
        this.close.setStructuringElement(se);
        this.dilate.setStructuringElement(se);
        this.erode.setStructuringElement(se);
        this.open.setStructuringElement(se);
    }

    @Override
    public int Iterations() {
        return this.Iterations;
    }

    public void Parameters(Object ... parameters) {
        if (parameters.length != 1) {
            throw new IllegalArgumentException("Exactly 1 parameter required.");
        }
        this.setStructuringElement((StructuringElement)parameters[0]);
    }

    public List<Object> Parameters() {
        return this.dilate.Parameters();
    }

    public int BorderEffectSizeX() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public int BorderEffectSizeY() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public int BorderEffectSizeZ() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public Leveling Clone() {
        throw new UnsupportedOperationException("Not supported (yet).");
    }
}

