/*
 * Decompiled with CFR 0.152.
 */
package morphee.levelings;

import dv.DV;
import imageTiTi.ImageArithmetic;
import imageTiTi.ImageNew;
import imageTiTi.ImageOperations;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import morphee.Dilate;
import morphee.Erode;
import morphee.MorphoFilter;
import morphee.StructuringElement;
import morphee.StructuringElement3D;
import morphee.levelings.Leveling;

public class LambdaLeveling
implements MorphoFilter,
Leveling {
    private StructuringElement se = new StructuringElement(new Object[]{1, -1});
    protected Dilate dilate = new Dilate(this.se);
    protected Erode erode = new Erode(this.se);
    private int Iterations = -1;
    private int Lambda = 1;
    private BufferedImage marker = null;
    private BufferedImage Dil;
    private BufferedImage DilL;
    private BufferedImage Ero;
    private BufferedImage EroL;
    private BufferedImage Res;
    private BufferedImage Tmp;

    public LambdaLeveling() {
    }

    public LambdaLeveling(int Lambda) {
        this.Lambda(Lambda);
    }

    public BufferedImage Filter(BufferedImage reference, BufferedImage marker, int lambda, int nbCPU) {
        BufferedImage result = ImageNew.Same((BufferedImage)reference);
        this.Filter(reference, marker, result, lambda, nbCPU);
        return result;
    }

    public void Filter(BufferedImage reference, BufferedImage marker, BufferedImage result, int lambda, int nbCPU) {
        this.Marker(marker);
        this.Lambda(this.Lambda);
        this.Filter(reference, result, nbCPU);
    }

    @Override
    public BufferedImage Filter(BufferedImage reference, int nbCPU, BufferedImage marker) {
        BufferedImage result = ImageNew.Same((BufferedImage)reference);
        this.Filter(reference, marker, result, nbCPU);
        return result;
    }

    @Override
    public void Filter(BufferedImage reference, BufferedImage marker, BufferedImage result, int nbCPU) {
        this.Marker(marker);
        this.Filter(reference, result, nbCPU);
    }

    public BufferedImage Filter(BufferedImage reference, StructuringElement se, int nbCPU) {
        this.setStructuringElement(se);
        return this.Filter(reference, nbCPU);
    }

    public void Filter(BufferedImage source, StructuringElement se, BufferedImage result, int nbCPU) {
        this.setStructuringElement(se);
        this.Filter(source, result, nbCPU);
    }

    public BufferedImage Filter(BufferedImage reference, int nbCPU) {
        BufferedImage result = ImageNew.Same((BufferedImage)reference);
        this.Filter(reference, result, nbCPU);
        return result;
    }

    public void Filter(BufferedImage reference, BufferedImage result, int nbCPU) {
        int max = 0;
        switch (reference.getType()) {
            case 10: {
                max = 255;
                break;
            }
            case 11: {
                max = 65535;
                break;
            }
            default: {
                throw new IllegalArgumentException("Only gray level image required.");
            }
        }
        if (!ImageTools.areDimensionsAndTypeEqual((BufferedImage)reference, (BufferedImage)this.marker)) {
            throw new IllegalArgumentException("Dimensions or type of reference and marker are different.");
        }
        if (this.marker == null) {
            throw new IllegalArgumentException("Any marker defined.");
        }
        if (!ImageTools.areDimensionsAndTypeEqual((BufferedImage)reference, (BufferedImage)result)) {
            throw new IllegalArgumentException("Dimensions or type of reference and marker are different.");
        }
        if (this.Ero == null || !ImageTools.areDimensionsAndTypeEqual((BufferedImage)reference, (BufferedImage)this.Ero)) {
            this.Ero = ImageNew.Same((BufferedImage)reference);
            this.EroL = ImageNew.Same((BufferedImage)reference);
            this.Dil = ImageNew.Same((BufferedImage)reference);
            this.DilL = ImageNew.Same((BufferedImage)reference);
            this.Res = ImageNew.Same((BufferedImage)reference);
            this.Tmp = ImageNew.Same((BufferedImage)reference);
        }
        ImageNew.Copy((BufferedImage)this.marker, (BufferedImage)result);
        this.Iterations = 0;
        while (true) {
            ImageArithmetic.Subtract(result, this.Lambda, this.DilL, 0, 0);
            this.dilate.Filter(this.DilL, this.Dil, nbCPU);
            ImageOperations.Maximum((BufferedImage)result, (BufferedImage)this.Dil, (BufferedImage)this.Dil);
            ImageArithmetic.Add(result, this.Lambda, this.EroL, max, max);
            this.erode.Filter(this.EroL, this.Ero, nbCPU);
            ImageOperations.Minimum((BufferedImage)result, (BufferedImage)this.Ero, (BufferedImage)this.Ero);
            ImageOperations.Minimum((BufferedImage)reference, (BufferedImage)this.Dil, (BufferedImage)this.Tmp);
            ImageOperations.Maximum((BufferedImage)this.Tmp, (BufferedImage)this.Ero, (BufferedImage)this.Res);
            if (ImageTools.areEqual((BufferedImage)result, (BufferedImage)this.Res)) break;
            ImageNew.Copy((BufferedImage)this.Res, (BufferedImage)result);
            ++this.Iterations;
        }
    }

    public DV Filter(DV source, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public void Filter(DV source, DV result, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public DV Filter(DV source, StructuringElement3D se, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public void Filter(DV source, StructuringElement3D se, DV result, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public StructuringElement3D getStructuringElement3D() {
        return null;
    }

    public void setStructuringElement3D(StructuringElement3D se) {
    }

    public void Marker(BufferedImage marker) {
        this.marker = null;
        this.marker = marker;
    }

    public BufferedImage Marker() {
        return this.marker;
    }

    public StructuringElement getStructuringElement() {
        return this.se;
    }

    public void setStructuringElement(StructuringElement se) {
    }

    public int Lambda() {
        return this.Lambda;
    }

    public void Lambda(int Lambda) {
        this.Lambda = Lambda;
    }

    @Override
    public int Iterations() {
        return this.Iterations;
    }

    public void Parameters(Object ... parameters) {
        if (parameters.length != 1) {
            throw new IllegalArgumentException("Exactly 1 parameter required.");
        }
        this.Lambda((Integer)parameters[0]);
    }

    public List<Object> Parameters() {
        ArrayList<Object> params = new ArrayList<Object>(1);
        params.add(this.Lambda);
        return params;
    }

    public int BorderEffectSizeX() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public int BorderEffectSizeY() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public int BorderEffectSizeZ() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public Leveling Clone() {
        throw new UnsupportedOperationException("Not supported (yet).");
    }
}

