/*
 * Decompiled with CFR 0.152.
 */
package morphee.granulometry;

import java.awt.image.BufferedImage;
import morphee.granulometry.AntiGranulometryTopHat;
import morphee.granulometry.GranulometryTopHat;
import morphee.levelings.Leveling;

public class PatternSpectrumTopHat {
    private int MinRadius = -1;
    private int MaxRadius = -1;
    private int Step = -1;
    public GranulometryTopHat gran = new GranulometryTopHat();
    public AntiGranulometryTopHat anti = new AntiGranulometryTopHat();
    private double[] Features = null;

    public void Process(BufferedImage source, int MinRadius, int MaxRadius, int Step, Leveling leveling, int ForbidenValue, int nbCPU) {
        int i2;
        double[] features = null;
        this.setParameters(MinRadius, MaxRadius, Step);
        this.gran.Process(source, MinRadius, MaxRadius, Step, leveling, ForbidenValue, nbCPU);
        this.anti.Process(source, MinRadius, MaxRadius, Step, leveling, ForbidenValue, nbCPU);
        if (this.Features == null || this.Features.length != 2 * this.gran.Feature().length + 3) {
            this.Features = null;
            this.Features = new double[2 * this.gran.Feature().length + 3];
        }
        int nb = 0;
        features = this.gran.Feature();
        for (i2 = features.length - 1; i2 >= 0; --i2) {
            this.Features[nb++] = features[i2];
        }
        features = null;
        features = this.anti.Feature();
        for (i2 = 0; i2 < features.length; ++i2) {
            this.Features[nb++] = features[i2];
        }
        features = null;
        double sum = 0.0;
        for (i2 = 0; i2 < nb; ++i2) {
            sum += this.Features[i2];
        }
        double average = sum / (double)nb;
        double var = 0.0;
        for (i2 = 0; i2 < nb; ++i2) {
            var += Math.pow(this.Features[i2] - average, 2.0);
        }
        var = Math.sqrt(var) / (double)nb;
        this.Features[nb] = sum;
        this.Features[nb + 1] = average;
        this.Features[nb + 2] = var;
    }

    public void setParameters(int MinRadius, int MaxRadius, int Step) {
        if (MinRadius <= 0 || MaxRadius < MinRadius) {
            throw new IllegalArgumentException("MinRadius<1 or MaxRadius<MinRadius.");
        }
        if (Step < 1) {
            throw new IllegalArgumentException("Step < 1");
        }
        this.MinRadius = MinRadius;
        this.MaxRadius = MaxRadius;
        this.Step = Step;
    }

    public double[] Feature() {
        return this.Features;
    }

    public double Feature(int x) {
        return this.Features[x];
    }

    public String[] FeaturesNames() {
        int i2;
        int count = 0;
        String[] s = new String[(this.MaxRadius - this.MinRadius) / this.Step + 1 << 4];
        for (i2 = this.MaxRadius; i2 >= this.MinRadius; i2 -= this.Step) {
            s[count++] = "PS_Gran " + (i2 < 10 ? "0" : "") + i2;
        }
        for (i2 = this.MinRadius; i2 <= this.MaxRadius; i2 += this.Step) {
            s[count++] = "PS_Anti " + (i2 < 10 ? "0" : "") + i2;
        }
        s[count++] = "Integral";
        s[count++] = "Average";
        s[count++] = "Variance";
        return s;
    }
}

