/*
 * Decompiled with CFR 0.152.
 */
package morphee.granulometry;

import characterization.ComputableFeatures;
import dv.DV;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.List;
import morphee.granulometry.AntiGranulometryTopHat;
import morphee.granulometry.GranulometryTopHat;
import morphee.levelings.Leveling;

public class PatternSpectrumMultiSE2
implements ComputableFeatures {
    private int MinRadius = -1;
    private int MaxRadius = -1;
    private int Step = -1;
    public GranulometryTopHat[] gran = null;
    public AntiGranulometryTopHat[] anti = null;
    private double[] Features = null;
    protected Leveling leveling = null;
    protected int ForbidenValue = -1;
    protected int nbCPU = 1;

    public PatternSpectrumMultiSE2() {
    }

    public PatternSpectrumMultiSE2(List<Integer> listse) {
        this.setStructuringElements(listse);
    }

    @Override
    public synchronized void Kill() {
        Arrays.fill(this.gran, null);
        Arrays.fill(this.anti, null);
        if (this.leveling != null) {
            this.leveling.Kill();
        }
        this.leveling = null;
        this.Features = null;
    }

    public void Process(BufferedImage source, int MinRadius, int MaxRadius, int Step, Leveling leveling, int ForbidenValue, int nbCPU) {
        int i2;
        if (this.gran == null) {
            throw new Error("Set structuring elements first.");
        }
        double[] features = null;
        this.setParameters(MinRadius, MaxRadius, Step);
        for (int i3 = 0; i3 < this.gran.length; ++i3) {
            this.gran[i3].Process(source, MinRadius, MaxRadius, Step, leveling, ForbidenValue, nbCPU);
            this.anti[i3].Process(source, MinRadius, MaxRadius, Step, leveling, ForbidenValue, nbCPU);
        }
        if (this.Features == null || this.Features.length != 2 * this.gran[0].Feature().length * this.gran.length + 3) {
            this.Features = null;
            this.Features = new double[2 * this.gran[0].Feature().length * this.gran.length + 3];
        }
        int nb = 0;
        for (GranulometryTopHat g : this.gran) {
            features = g.Feature();
            for (i2 = features.length - 1; i2 >= 0; --i2) {
                this.Features[nb++] = features[i2];
            }
            features = null;
        }
        for (AntiGranulometryTopHat anti1 : this.anti) {
            features = anti1.Feature();
            for (i2 = 0; i2 < features.length; ++i2) {
                this.Features[nb++] = features[i2];
            }
            features = null;
        }
        double sum = 0.0;
        for (int i4 = 0; i4 < nb; ++i4) {
            sum += this.Features[i4];
        }
        double average = sum / (double)nb;
        double var = 0.0;
        for (int i5 = 0; i5 < nb; ++i5) {
            var += Math.pow(this.Features[i5] - average, 2.0);
        }
        var = Math.sqrt(var) / (double)nb;
        this.Features[nb] = sum;
        this.Features[nb + 1] = average;
        this.Features[nb + 2] = var;
    }

    @Override
    public void Compute(BufferedImage image, BufferedImage mask, int ForbiddenValue, int nbCPU) {
        this.Process(image, this.MinRadius, this.MaxRadius, this.Step, this.leveling, this.ForbidenValue, nbCPU);
    }

    @Override
    public void Compute(DV dv, int nbCPU) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    @Override
    public void Parameters(Object ... parameters) {
        if (parameters.length != 7) {
            throw new IllegalArgumentException("7 parameters required.");
        }
        this.MinRadius = (Integer)parameters[0];
        this.MaxRadius = (Integer)parameters[1];
        this.Step = (Integer)parameters[2];
        this.leveling = (Leveling)parameters[3];
        this.ForbidenValue = (Integer)parameters[4];
        this.nbCPU = (Integer)parameters[5];
        this.setStructuringElements((List)parameters[6]);
    }

    public void setParameters(int MinRadius, int MaxRadius, int Step) {
        if (MinRadius <= 0 || MaxRadius < MinRadius) {
            throw new IllegalArgumentException("MinRadius<1 or MaxRadius<MinRadius.");
        }
        if (Step < 1) {
            throw new IllegalArgumentException("Step < 1");
        }
        this.MinRadius = MinRadius;
        this.MaxRadius = MaxRadius;
        this.Step = Step;
    }

    public void setStructuringElements(List<Integer> listse) {
        this.gran = null;
        this.gran = new GranulometryTopHat[listse.size()];
        this.anti = null;
        this.anti = new AntiGranulometryTopHat[listse.size()];
        for (int i2 = 0; i2 < this.gran.length; ++i2) {
            this.anti[i2] = new AntiGranulometryTopHat();
            this.anti[i2].setStructuringElementType(listse.get(i2));
            this.gran[i2] = new GranulometryTopHat();
            this.gran[i2].setStructuringElementType(listse.get(i2));
        }
    }

    @Override
    public double[] Features() {
        return this.Features;
    }

    @Override
    public double Feature(int x) {
        return this.Features[x];
    }

    @Override
    public String[] FeaturesNames() {
        int i2;
        int j;
        int count = 0;
        if (this.gran == null) {
            throw new Error("Set structuring elements first.");
        }
        String[] s = new String[2 * ((this.MaxRadius - this.MinRadius) / this.Step + 1) * this.gran.length + 3];
        for (j = 0; j < this.gran.length; ++j) {
            for (i2 = this.MaxRadius; i2 >= this.MinRadius; i2 -= this.Step) {
                s[count++] = "PS_Gran" + (i2 < 10 ? "0" : "") + i2 + "_SE" + (j < 10 ? "0" : "") + j;
            }
        }
        for (j = 0; j < this.anti.length; ++j) {
            for (i2 = this.MinRadius; i2 <= this.MaxRadius; i2 += this.Step) {
                s[count++] = "PS_Anti" + (i2 < 10 ? "0" : "") + i2 + "_SE" + (j < 10 ? "0" : "") + j;
            }
        }
        s[count++] = "Integral";
        s[count++] = "Average";
        s[count++] = "Variance";
        return s;
    }
}

