/*
 * Decompiled with CFR 0.152.
 */
package morphee.granulometry;

import characterization.ComputableFeatures;
import characterization.PreComputable;
import dv.DV;
import java.awt.image.BufferedImage;
import java.util.List;
import morphee.granulometry.AntiGranulometry;
import morphee.granulometry.Granulometry;

public class PatternSpectrumMultiSE
implements ComputableFeatures,
PreComputable {
    private int MinOrder = -1;
    private int MaxOrder = -1;
    private int Step = -1;
    private int ForbiddenValue = -1;
    private Granulometry[] gran = null;
    private AntiGranulometry[] anti = null;
    private double[] Features = null;

    public PatternSpectrumMultiSE() {
    }

    public PatternSpectrumMultiSE(List<Integer> listse) {
        this.setStructuringElements(listse);
    }

    @Override
    public synchronized void Kill() {
        for (Granulometry granulometry : this.gran) {
            granulometry.Kill();
            Object var4_4 = null;
        }
        for (PreComputable preComputable : this.anti) {
            ((AntiGranulometry)preComputable).Kill();
            Object var4_8 = null;
        }
        this.Features = null;
    }

    public void Process(BufferedImage source, BufferedImage mask, int MinOrder, int MaxOrder, int Step, int ForbiddenValue, int nbCPU) {
        if (this.gran == null) {
            throw new Error("Set structuring elements first.");
        }
        this.setParameters(MinOrder, MaxOrder, Step);
        this.ForbiddenValue = ForbiddenValue;
        for (int i2 = 0; i2 < this.gran.length; ++i2) {
            this.gran[i2].Process(source, mask, MinOrder, MaxOrder, Step, ForbiddenValue, -2, nbCPU);
            this.anti[i2].Process(source, mask, MinOrder, MaxOrder, Step, ForbiddenValue, -2, nbCPU);
        }
        this.ComputeFeatures();
    }

    private void ComputeFeatures() {
        int i2;
        int j;
        if (this.Features == null || this.Features.length != 2 * this.gran[0].Features().length * this.gran.length + 3) {
            this.Features = null;
            this.Features = new double[2 * this.gran[0].Features().length * this.gran.length + 3];
        }
        double[] features = null;
        int nb = 0;
        for (j = 0; j < this.gran.length; ++j) {
            features = this.gran[j].Features();
            for (i2 = features.length - 1; i2 >= 0; --i2) {
                this.Features[nb++] = features[i2];
            }
            features = null;
        }
        for (j = 0; j < this.anti.length; ++j) {
            features = this.anti[j].Features();
            for (i2 = 0; i2 < features.length; ++i2) {
                this.Features[nb++] = features[i2];
            }
            features = null;
        }
        double sum = 0.0;
        for (i2 = 0; i2 < nb; ++i2) {
            sum += this.Features[i2];
        }
        double average = sum / (double)nb;
        double var = 0.0;
        for (i2 = 0; i2 < nb; ++i2) {
            var += Math.pow(this.Features[i2] - average, 2.0);
        }
        var = Math.sqrt(var) / (double)nb;
        this.Features[nb] = sum;
        this.Features[nb + 1] = average;
        this.Features[nb + 2] = var;
    }

    @Override
    public void Compute(BufferedImage image, BufferedImage mask, int ForbiddenValue, int nbCPU) {
        this.Process(image, mask, this.MinOrder, this.MaxOrder, this.Step, ForbiddenValue, nbCPU);
    }

    @Override
    public void PreCompute(BufferedImage image, int nbCPU) {
        if (this.gran == null) {
            throw new Error("Parameters must be submited before calling to this method.");
        }
        for (int i2 = 0; i2 < this.gran.length; ++i2) {
            this.anti[i2].PreCompute(image, nbCPU);
            this.gran[i2].PreCompute(image, nbCPU);
        }
    }

    @Override
    public void FastCompute(int startx, int starty, int endx, int endy) {
        for (int i2 = 0; i2 < this.gran.length; ++i2) {
            this.anti[i2].FastCompute(startx, starty, endx, endy);
            this.gran[i2].FastCompute(startx, starty, endx, endy);
        }
        this.ComputeFeatures();
    }

    @Override
    public void Compute(DV dv, int nbCPU) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    @Override
    public void Parameters(Object ... parameters) {
        if (parameters.length != 5) {
            throw new IllegalArgumentException("7 parameters required.");
        }
        this.MinOrder = (Integer)parameters[0];
        this.MaxOrder = (Integer)parameters[1];
        this.Step = (Integer)parameters[2];
        this.ForbiddenValue = (Integer)parameters[3];
        this.setStructuringElements((List)parameters[4]);
    }

    public void setParameters(int MinOrder, int MaxOrder, int Step) {
        if (MinOrder <= 0 || MaxOrder < MinOrder) {
            throw new IllegalArgumentException("MinOrder<1 or MaxOrder<MinOrder.");
        }
        if (Step < 1) {
            throw new IllegalArgumentException("Step < 1");
        }
        this.MinOrder = MinOrder;
        this.MaxOrder = MaxOrder;
        this.Step = Step;
    }

    public void setStructuringElements(List<Integer> listse) {
        this.gran = null;
        this.gran = new Granulometry[listse.size()];
        this.anti = null;
        this.anti = new AntiGranulometry[listse.size()];
        for (int i2 = 0; i2 < this.gran.length; ++i2) {
            this.anti[i2] = new AntiGranulometry();
            this.anti[i2].Parameters(this.MinOrder, this.MaxOrder, this.Step, this.ForbiddenValue, listse.get(i2));
            this.gran[i2] = new Granulometry();
            this.gran[i2].Parameters(this.MinOrder, this.MaxOrder, this.Step, this.ForbiddenValue, listse.get(i2));
        }
    }

    @Override
    public double[] Features() {
        return this.Features;
    }

    @Override
    public double Feature(int x) {
        return this.Features[x];
    }

    @Override
    public String[] FeaturesNames() {
        int i2;
        int j;
        int count = 0;
        if (this.gran == null) {
            throw new Error("Set structuring elements first.");
        }
        String[] s = new String[2 * ((this.MaxOrder - this.MinOrder) / this.Step + 1) * this.gran.length + 3];
        for (j = 0; j < this.gran.length; ++j) {
            for (i2 = this.MaxOrder; i2 >= this.MinOrder; i2 -= this.Step) {
                s[count++] = "PS_Gran" + (i2 < 10 ? "0" : "") + i2 + "_SE" + (j < 10 ? "0" : "") + j;
            }
        }
        for (j = 0; j < this.anti.length; ++j) {
            for (i2 = this.MinOrder; i2 <= this.MaxOrder; i2 += this.Step) {
                s[count++] = "PS_Anti" + (i2 < 10 ? "0" : "") + i2 + "_SE" + (j < 10 ? "0" : "") + j;
            }
        }
        s[count++] = "Integral";
        s[count++] = "Average";
        s[count++] = "Variance";
        return s;
    }
}

