/*
 * Decompiled with CFR 0.152.
 */
package morphee.granulometry;

import characterization.ComputableFeatures;
import dv.DV;
import java.awt.image.BufferedImage;
import morphee.granulometry.AntiGranulometryArea;
import morphee.granulometry.GranulometryArea;
import morphee.levelings.Leveling;

public class PatternSpectrumArea
implements ComputableFeatures {
    private int MinRadius = -1;
    private int MaxRadius = -1;
    private int Step = -1;
    private int ForbiddenValue = -1;
    private Leveling leveling = null;
    public final GranulometryArea gran = new GranulometryArea();
    public final AntiGranulometryArea anti = new AntiGranulometryArea();
    private double[] Features = null;

    @Override
    public synchronized void Kill() {
        if (this.leveling != null) {
            this.leveling.Kill();
        }
        this.gran.Kill();
        this.anti.Kill();
        this.Features = null;
    }

    @Override
    public void Compute(BufferedImage image, BufferedImage mask, int ForbiddenValue, int nbCPU) {
        if (this.Step < 0) {
            throw new Error("Parameters must be set before the call to this method.");
        }
        this.Process(image, mask, this.MinRadius, this.MaxRadius, this.Step, this.leveling, ForbiddenValue, nbCPU);
    }

    public void Process(BufferedImage source, BufferedImage mask, int MinRadius, int MaxRadius, int Step, Leveling leveling, int ForbiddenValue, int nbCPU) {
        int i2;
        double[] features = null;
        this.Parameters(MinRadius, MaxRadius, Step, leveling, ForbiddenValue);
        this.gran.Process(source, mask, MinRadius, MaxRadius, Step, leveling, ForbiddenValue, nbCPU);
        this.anti.Process(source, mask, MinRadius, MaxRadius, Step, leveling, ForbiddenValue, nbCPU);
        if (this.Features == null || this.Features.length != 2 * this.gran.Features().length + 3) {
            this.Features = null;
            this.Features = new double[2 * this.gran.Features().length + 3];
        }
        int nb = 0;
        features = this.gran.Features();
        for (i2 = features.length - 1; i2 >= 0; --i2) {
            this.Features[nb++] = features[i2];
        }
        features = null;
        features = this.anti.Features();
        for (i2 = 0; i2 < features.length; ++i2) {
            this.Features[nb++] = features[i2];
        }
        features = null;
        double sum = 0.0;
        for (int i3 = 0; i3 < nb; ++i3) {
            sum += this.Features[i3];
        }
        double average = sum / (double)nb;
        double var = 0.0;
        for (int i4 = 0; i4 < nb; ++i4) {
            var += Math.pow(this.Features[i4] - average, 2.0);
        }
        var = Math.sqrt(var) / (double)nb;
        this.Features[nb] = sum;
        this.Features[nb + 1] = average;
        this.Features[nb + 2] = var;
    }

    @Override
    public void Compute(DV dv, int nbCPU) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    @Override
    public void Parameters(Object ... parameters) {
        if (parameters.length != 5) {
            throw new IllegalArgumentException("5 parameters required.");
        }
        this.MinRadius = (Integer)parameters[0];
        this.MaxRadius = (Integer)parameters[1];
        this.Step = (Integer)parameters[2];
        this.leveling = (Leveling)parameters[3];
        this.ForbiddenValue = (Integer)parameters[4];
        if (this.MinRadius <= 0 || this.MaxRadius < this.MinRadius) {
            throw new IllegalArgumentException("MinRadius<1 or MaxRadius<MinRadius.");
        }
        if (this.Step < 1) {
            throw new IllegalArgumentException("Step < 1");
        }
    }

    @Override
    public double[] Features() {
        return this.Features;
    }

    @Override
    public double Feature(int x) {
        return this.Features[x];
    }

    @Override
    public String[] FeaturesNames() {
        int i2;
        int count = 0;
        String[] s = new String[2 * ((this.MaxRadius - this.MinRadius) / this.Step + 1) + 3];
        for (i2 = this.MaxRadius; i2 >= this.MinRadius; i2 -= this.Step) {
            s[count++] = "PS_GranArea " + (i2 < 10 ? "0" : "") + i2;
        }
        for (i2 = this.MinRadius; i2 <= this.MaxRadius; i2 += this.Step) {
            s[count++] = "PS_AntiArea " + (i2 < 10 ? "0" : "") + i2;
        }
        s[count++] = "Integral";
        s[count++] = "Average";
        s[count++] = "Variance";
        return s;
    }
}

