/*
 * Decompiled with CFR 0.152.
 */
package morphee.granulometry;

import characterization.ComputableFeatures;
import dv.DV;
import java.awt.image.BufferedImage;
import morphee.granulometry.AntiGranulometry;
import morphee.granulometry.Granulometry;

public class PatternSpectrum
implements ComputableFeatures {
    private int MinOrder = -1;
    private int MaxOrder = -1;
    private int Step = -1;
    private int ForbiddenValue = -1;
    private final int SE = -2;
    public Granulometry gran = new Granulometry();
    public AntiGranulometry anti = new AntiGranulometry();
    private double[] Features = null;

    @Override
    public synchronized void Kill() {
        this.gran.Kill();
        this.anti.Kill();
        this.Features = null;
    }

    @Override
    public void Compute(BufferedImage image, BufferedImage mask, int ForbiddenValue, int nbCPU) {
        if (this.Step < 0) {
            throw new IllegalStateException("Parameters must be set before to call this method.");
        }
        this.Process(image, mask, this.MinOrder, this.MaxOrder, this.Step, ForbiddenValue, -2, nbCPU);
    }

    public void Process(BufferedImage source, BufferedImage mask, int MinOrder, int MaxOrder, int Step, int ForbiddenValue, int Type2, int nbCPU) {
        int i2;
        double[] features = null;
        this.Parameters(MinOrder, MaxOrder, Step, ForbiddenValue, Type2);
        this.gran.Compute(source, mask, ForbiddenValue, nbCPU);
        this.anti.Compute(source, mask, ForbiddenValue, nbCPU);
        if (this.Features == null || this.Features.length != this.gran.Features().length + this.anti.Features().length + 3) {
            this.Features = null;
            this.Features = new double[this.gran.Features().length + this.anti.Features().length + 3];
        }
        int nb = 0;
        features = this.gran.Features();
        for (i2 = features.length - 1; i2 >= 0; --i2) {
            this.Features[nb++] = features[i2];
        }
        features = null;
        features = this.anti.Features();
        for (i2 = 0; i2 < features.length; ++i2) {
            this.Features[nb++] = features[i2];
        }
        features = null;
        double sum = 0.0;
        for (int i3 = 0; i3 < nb; ++i3) {
            sum += this.Features[i3];
        }
        double average = sum / (double)nb;
        double var = 0.0;
        for (int i4 = 0; i4 < nb; ++i4) {
            var += Math.pow(this.Features[i4] - average, 2.0);
        }
        var = Math.sqrt(var) / (double)nb;
        this.Features[nb] = sum;
        this.Features[nb + 1] = average;
        this.Features[nb + 2] = var;
    }

    @Override
    public void Compute(DV dv, int nbCPU) {
        if (this.Step < 0) {
            throw new IllegalStateException("Parameters must be set before to call this method.");
        }
        this.Process(dv, this.MinOrder, this.MaxOrder, this.Step, this.ForbiddenValue, -2, nbCPU);
    }

    public void Process(DV dv, int MinOrder, int MaxOrder, int Step, int ForbiddenValue, int Type2, int nbCPU) {
        int i2;
        double[] features = null;
        this.Parameters(MinOrder, MaxOrder, Step, ForbiddenValue, Type2);
        this.gran.Compute(dv, nbCPU);
        this.anti.Compute(dv, nbCPU);
        if (this.Features == null || this.Features.length != this.gran.Features().length + this.anti.Features().length + 3) {
            this.Features = null;
            this.Features = new double[this.gran.Features().length + this.anti.Features().length + 3];
        }
        int nb = 0;
        features = this.gran.Features();
        for (i2 = features.length - 1; i2 >= 0; --i2) {
            this.Features[nb++] = features[i2];
        }
        features = null;
        features = this.anti.Features();
        for (i2 = 0; i2 < features.length; ++i2) {
            this.Features[nb++] = features[i2];
        }
        features = null;
        double sum = 0.0;
        for (int i3 = 0; i3 < nb; ++i3) {
            sum += this.Features[i3];
        }
        double average = sum / (double)nb;
        double var = 0.0;
        for (int i4 = 0; i4 < nb; ++i4) {
            var += Math.pow(this.Features[i4] - average, 2.0);
        }
        var = Math.sqrt(var) / (double)nb;
        this.Features[nb] = sum;
        this.Features[nb + 1] = average;
        this.Features[nb + 2] = var;
    }

    @Override
    public void Parameters(Object ... parameters) {
        if (parameters.length != 5) {
            throw new IllegalArgumentException("Exaclty 5 parameters required.");
        }
        this.MinOrder = (Integer)parameters[0];
        this.MaxOrder = (Integer)parameters[1];
        this.Step = (Integer)parameters[2];
        this.ForbiddenValue = (Integer)parameters[3];
        this.gran.Parameters(this.MinOrder, this.MaxOrder, this.Step, this.ForbiddenValue, (Integer)parameters[4]);
        this.anti.Parameters(this.MinOrder, this.MaxOrder, this.Step, this.ForbiddenValue, (Integer)parameters[4]);
        this.Features = null;
        this.Features = new double[this.gran.Features().length + this.anti.Features().length + 3];
    }

    @Override
    public int ForbiddenValue() {
        return this.gran.ForbiddenValue();
    }

    @Override
    public double[] Features() {
        return this.Features;
    }

    @Override
    public double Feature(int x) {
        return this.Features[x];
    }

    @Override
    public String[] FeaturesNames() {
        int i2;
        int count = 0;
        String[] s = new String[((this.MaxOrder - this.MinOrder) / this.Step + 1 << 1) + 3];
        for (i2 = this.MaxOrder; i2 >= this.MinOrder; i2 -= this.Step) {
            s[count++] = "PS_Gran_" + this.MinOrder + "_" + this.MaxOrder + "_" + this.Step + "_-2_" + (i2 < 10 ? "0" : "") + i2;
        }
        for (i2 = this.MinOrder; i2 <= this.MaxOrder; i2 += this.Step) {
            s[count++] = "PS_Anti_" + this.MinOrder + "_" + this.MaxOrder + "_" + this.Step + "_-2_" + (i2 < 10 ? "0" : "") + i2;
        }
        s[count++] = "PS_" + this.MinOrder + "_" + this.MaxOrder + "_" + this.Step + "_-2_Integral";
        s[count++] = "PS_" + this.MinOrder + "_" + this.MaxOrder + "_" + this.Step + "_-2_Average";
        s[count++] = "PS_" + this.MinOrder + "_" + this.MaxOrder + "_" + this.Step + "_-2_Variance";
        return s;
    }
}

