/*
 * Decompiled with CFR 0.152.
 */
package morphee.granulometry;

import imageTiTi.ImageFeatures;
import java.awt.image.BufferedImage;
import morphee.StructuringElement;
import morphee.WhiteTopHat;
import morphee.levelings.Leveling;
import processing.filters.Gaussian;

public class GranulometryTopHat {
    private int MinRadius = -1;
    private int MaxRadius = -1;
    private int Step = -1;
    private int ForbiddenValue = -1;
    private int SE = -2;
    private final WhiteTopHat wth = new WhiteTopHat();
    private final Gaussian gauss = new Gaussian(1, 1.0, 2);
    private int[] Integral = null;
    private double[] DistIntegral = null;
    private final ImageFeatures IF = new ImageFeatures();

    public void Process(BufferedImage source, int MinRadius, int MaxRadius, int Step, Leveling leveling, int ForbiddenValue, int nbCPU) {
        this.setParameters(MinRadius, MaxRadius, Step);
        this.ForbiddenValue = ForbiddenValue;
        BufferedImage Reduced = null;
        BufferedImage result = new BufferedImage(source.getWidth(), source.getHeight(), source.getType());
        int R = MinRadius;
        int counter = 0;
        StructuringElement startse = new StructuringElement(new Object[]{MinRadius, this.SE});
        StructuringElement stepse = new StructuringElement(new Object[]{Step, this.SE});
        Reduced = leveling == null ? source : leveling.Filter(source, nbCPU, this.gauss.Filter(source, nbCPU));
        this.Allocate();
        this.Measures(Reduced, counter++);
        this.wth.setStructuringElement(startse);
        this.wth.Filter(Reduced, result, nbCPU);
        this.Measures(result, counter++);
        Reduced = null;
        Reduced = result;
        R += Step;
        while (R <= MaxRadius) {
            this.wth.setStructuringElement(stepse);
            this.wth.Filter(Reduced, result, nbCPU);
            this.Measures(result, counter++);
            Reduced = null;
            Reduced = result;
            R += Step;
        }
        Reduced = null;
        result = null;
        stepse = null;
        startse = null;
        this.ComputeDistributions();
    }

    protected void Measures(BufferedImage image, int Count) {
        this.Integral[Count] = (int)this.IF.Integral(image, this.ForbiddenValue);
    }

    protected void ComputeDistributions() {
        for (int i2 = 0; i2 < this.Integral.length - 1; ++i2) {
            this.DistIntegral[i2] = (double)(this.Integral[i2] - this.Integral[i2 + 1]) / (double)this.Integral[0];
        }
    }

    private void Allocate() {
        int N = (int)((double)(this.MaxRadius - this.MinRadius) / (double)this.Step) + 2;
        this.Integral = null;
        this.Integral = new int[N];
        this.DistIntegral = null;
        this.DistIntegral = new double[N - 1];
    }

    public void setParameters(int MinRadius, int MaxRadius, int Step) {
        if (MinRadius <= 0 || MaxRadius < MinRadius) {
            throw new IllegalArgumentException("MinRadius<1 or MaxRadius<MinRadius.");
        }
        if (Step < 1) {
            throw new IllegalArgumentException("Step < 1");
        }
        this.MinRadius = MinRadius;
        this.MaxRadius = MaxRadius;
        this.Step = Step;
    }

    public void setStructuringElementType(int type) {
        this.SE = type;
    }

    public int getMinRadius() {
        return this.MinRadius;
    }

    public int getMaxRadius() {
        return this.MaxRadius;
    }

    public int getStep() {
        return this.Step;
    }

    public int[] getIntegral() {
        return this.Integral;
    }

    public double[] getDistributionIntegral() {
        return this.DistIntegral;
    }

    public double[] Feature() {
        return this.DistIntegral;
    }

    public double Feature(int x) {
        return this.DistIntegral[x];
    }

    public String[] FeaturesNames() {
        int count = 0;
        String[] s = new String[(this.MaxRadius - this.MinRadius) / this.Step + 1];
        for (int i2 = this.MinRadius; i2 <= this.MaxRadius; i2 += this.Step) {
            s[count++] = "Granulometry " + (i2 < 10 ? "0" : "") + i2;
        }
        return s;
    }
}

