/*
 * Decompiled with CFR 0.152.
 */
package morphee.granulometry;

import characterization.ComputableFeatures;
import characterization.PreComputable;
import dv.DV;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.List;
import morphee.granulometry.Granulometry;

public class GranulometryMultiSE
implements ComputableFeatures,
PreComputable {
    private int MinOrder = -1;
    private int MaxOrder = -1;
    private int Step = -1;
    private int ForbiddenValue = -1;
    public Granulometry[] gran = null;
    private double[] Features = null;

    public GranulometryMultiSE() {
    }

    public GranulometryMultiSE(List<Integer> listse) {
        this.setStructuringElements(listse);
    }

    @Override
    public synchronized void Kill() {
        this.Features = null;
        Arrays.fill(this.gran, null);
        this.gran = null;
    }

    public void Process(BufferedImage source, BufferedImage mask, int MinOrder, int MaxOrder, int Step, int ForbiddenValue, int nbCPU) {
        if (this.gran == null) {
            throw new Error("Set structuring elements first.");
        }
        this.setParameters(MinOrder, MaxOrder, Step);
        this.ForbiddenValue = ForbiddenValue;
        for (Granulometry g : this.gran) {
            g.Process(source, mask, MinOrder, MaxOrder, Step, ForbiddenValue, -2, nbCPU);
        }
        this.ComputeFeatures();
    }

    private void ComputeFeatures() {
        if (this.Features == null || this.Features.length != this.gran[0].Features().length * this.gran.length + 3) {
            this.Features = null;
            this.Features = new double[this.gran[0].Features().length * this.gran.length + 3];
        }
        double[] features = null;
        int nb = 0;
        for (Granulometry g : this.gran) {
            features = g.Features();
            for (int i2 = 0; i2 < features.length; ++i2) {
                this.Features[nb++] = features[i2];
            }
            features = null;
        }
        double sum = 0.0;
        for (int i3 = 0; i3 < nb; ++i3) {
            sum += this.Features[i3];
        }
        double average = sum / (double)nb;
        double var = 0.0;
        for (int i4 = 0; i4 < nb; ++i4) {
            var += Math.pow(this.Features[i4] - average, 2.0);
        }
        var = Math.sqrt(var) / (double)nb;
        this.Features[nb] = sum;
        this.Features[nb + 1] = average;
        this.Features[nb + 2] = var;
    }

    @Override
    public void Compute(BufferedImage image, BufferedImage mask, int ForbiddenValue, int nbCPU) {
        this.Process(image, mask, this.MinOrder, this.MaxOrder, this.Step, ForbiddenValue, nbCPU);
    }

    @Override
    public void PreCompute(BufferedImage image, int nbCPU) {
        if (this.gran == null) {
            throw new Error("Parameters must be submited before calling to this method.");
        }
        for (Granulometry g : this.gran) {
            g.PreCompute(image, nbCPU);
        }
    }

    @Override
    public void FastCompute(int startx, int starty, int endx, int endy) {
        for (Granulometry g : this.gran) {
            g.FastCompute(startx, starty, endx, endy);
        }
        this.ComputeFeatures();
    }

    @Override
    public void Compute(DV dv, int nbCPU) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    @Override
    public void Parameters(Object ... parameters) {
        if (parameters.length != 5) {
            throw new IllegalArgumentException("7 parameters required.");
        }
        this.MinOrder = (Integer)parameters[0];
        this.MaxOrder = (Integer)parameters[1];
        this.Step = (Integer)parameters[2];
        this.ForbiddenValue = (Integer)parameters[3];
        this.setStructuringElements((List)parameters[4]);
    }

    public void setParameters(int MinOrder, int MaxOrder, int Step) {
        if (MinOrder <= 0 || MaxOrder < MinOrder) {
            throw new IllegalArgumentException("MinOrder<1 or MaxOrder<MinOrder.");
        }
        if (Step < 1) {
            throw new IllegalArgumentException("Step < 1");
        }
        this.MinOrder = MinOrder;
        this.MaxOrder = MaxOrder;
        this.Step = Step;
    }

    public void setStructuringElements(List<Integer> listse) {
        this.gran = null;
        this.gran = new Granulometry[listse.size()];
        for (int i2 = 0; i2 < this.gran.length; ++i2) {
            this.gran[i2] = new Granulometry();
            this.gran[i2].Parameters(this.MinOrder, this.MaxOrder, this.Step, this.ForbiddenValue, listse.get(i2));
        }
    }

    @Override
    public double[] Features() {
        return this.Features;
    }

    @Override
    public double Feature(int x) {
        return this.Features[x];
    }

    @Override
    public String[] FeaturesNames() {
        int count = 0;
        if (this.gran == null) {
            throw new Error("Set structuring elements first.");
        }
        String[] s = new String[((this.MaxOrder - this.MinOrder) / this.Step + 1) * this.gran.length + 3];
        for (int j = 0; j < this.gran.length; ++j) {
            for (int i2 = this.MinOrder; i2 <= this.MaxOrder; i2 += this.Step) {
                s[count++] = "GranMSE_Order" + (i2 < 10 ? "0" : "") + i2 + "_SE" + (j < 10 ? "0" : "") + j;
            }
        }
        s[count++] = "Integral";
        s[count++] = "Average";
        s[count++] = "Variance";
        return s;
    }
}

