/*
 * Decompiled with CFR 0.152.
 */
package morphee.granulometry;

import characterization.ComputableFeatures;
import characterization.PreComputable;
import dv.DV;
import dv.DvFeatures;
import dv.DvNew;
import imageTiTi.ImageComparator;
import imageTiTi.ImageFeatures;
import imageTiTi.ImageNew;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.util.Arrays;
import morphee.Open;
import morphee.StructuringElement;
import morphee.StructuringElement3D;

public class Granulometry
implements ComputableFeatures,
PreComputable {
    private int MinOrder = -1;
    private int MaxOrder = -1;
    private int Step = -1;
    private int ForbiddenValue = -1;
    private Open open = new Open();
    private int SE = -2;
    private long[] Integral = null;
    private double[] DistIntegral = null;
    private BufferedImage[] preprocessed = null;
    private final DvFeatures DF = new DvFeatures();
    private final ImageFeatures IF = new ImageFeatures();

    @Override
    public synchronized void Kill() {
        this.open.Kill();
        this.open = null;
        this.Integral = null;
        this.DistIntegral = null;
        Arrays.fill(this.preprocessed, null);
        this.preprocessed = null;
    }

    public void Process(BufferedImage source, BufferedImage mask, int MinOrder, int MaxOrder, int Step, int ForbiddenValue, int Type2, int nbCPU) {
        if (ImageTools.isColored((BufferedImage)source)) {
            throw new IllegalArgumentException("Only gray level or binary images supported.");
        }
        this.setParameters(MinOrder, MaxOrder, Step);
        this.ForbiddenValue = ForbiddenValue;
        this.setStructuringElementType(Type2);
        BufferedImage result = ImageNew.Clone((BufferedImage)source);
        int R = MinOrder;
        int counter = 0;
        if (mask != null) {
            ImageComparator.Compare((BufferedImage)mask, (String)"!=", (int)0, (BufferedImage)source, (int)ForbiddenValue, (BufferedImage)result);
        }
        this.Measures(result, counter++);
        while (R <= MaxOrder) {
            this.open.setStructuringElement(new StructuringElement(new Object[]{R, this.SE}));
            this.open.Filter(source, result, nbCPU);
            if (mask != null) {
                ImageComparator.Compare((BufferedImage)mask, (String)"!=", (int)0, (BufferedImage)result, (int)ForbiddenValue, (BufferedImage)result);
            }
            this.Measures(result, counter++);
            R += Step;
        }
        result = null;
        this.ComputeDistributions();
    }

    @Override
    public void Compute(BufferedImage image, BufferedImage mask, int ForbiddenValue, int nbCPU) {
        this.Process(image, mask, this.MinOrder, this.MaxOrder, this.Step, ForbiddenValue, this.SE, nbCPU);
    }

    @Override
    public void PreCompute(BufferedImage image, int nbCPU) {
        if (this.MinOrder < 1) {
            throw new Error("Set parameters before to call this method.");
        }
        int nb = 0;
        this.Allocate();
        this.preprocessed[nb++] = ImageNew.Clone((BufferedImage)image);
        for (int R = this.MinOrder; R <= this.MaxOrder; R += this.Step) {
            this.open.setStructuringElement(new StructuringElement(new Object[]{R, this.SE}));
            this.preprocessed[nb++] = this.open.Filter(image, nbCPU);
        }
    }

    @Override
    public void Compute(DV dv, int nbCPU) {
        this.Process(dv, this.MinOrder, this.MaxOrder, this.Step, this.ForbiddenValue, this.SE, nbCPU);
    }

    public void Process(DV dv, int MinOrder, int MaxOrder, int Step, int ForbiddenValue, int Type2, int nbCPU) {
        if (dv.Channel != 1) {
            throw new IllegalArgumentException("Single channel DV required.");
        }
        this.setParameters(MinOrder, MaxOrder, Step);
        this.ForbiddenValue = ForbiddenValue;
        this.setStructuringElementType(Type2);
        DV result = DvNew.Same((DV)dv);
        int counter = 0;
        this.Measures(dv, counter++);
        for (int R = MinOrder; R <= MaxOrder; R += Step) {
            this.open.setStructuringElement3D(new StructuringElement3D(new Object[]{R, this.SE}));
            this.open.Filter(dv, result, nbCPU);
            this.Measures(result, counter++);
        }
        result.Kill();
        result = null;
        this.ComputeDistributions();
    }

    @Override
    public void FastCompute(int startx, int starty, int endx, int endy) {
        for (int i2 = 0; i2 < this.preprocessed.length; ++i2) {
            this.Integral[i2] = 0L;
            WritableRaster wr = this.preprocessed[i2].getRaster();
            for (int y = starty; y <= endy; ++y) {
                for (int x = startx; x <= endx; ++x) {
                    if (wr.getSample(x, y, 0) == this.ForbiddenValue) continue;
                    int n = i2;
                    this.Integral[n] = this.Integral[n] + (long)wr.getSample(x, y, 0);
                }
            }
            wr = null;
        }
        this.ComputeDistributions();
    }

    protected void Measures(BufferedImage image, int Count) {
        this.Integral[Count] = this.IF.Integral(image, this.ForbiddenValue);
    }

    protected void Measures(DV dv, int Count) {
        this.Integral[Count] = this.DF.Integral(dv, this.ForbiddenValue);
    }

    protected void ComputeDistributions() {
        for (int i2 = 0; i2 < this.Integral.length - 1; ++i2) {
            this.DistIntegral[i2] = (double)(this.Integral[i2] - this.Integral[i2 + 1]) / (double)this.Integral[0];
        }
    }

    private void Allocate() {
        int N = (int)((double)(this.MaxOrder - this.MinOrder) / (double)this.Step) + 2;
        if (this.Integral == null || this.Integral.length != N) {
            this.Integral = null;
            this.Integral = new long[N];
            this.DistIntegral = null;
            this.DistIntegral = new double[N - 1];
            this.preprocessed = null;
            this.preprocessed = new BufferedImage[N];
        }
    }

    public void setParameters(int MinOrder, int MaxOrder, int Step) {
        if (MinOrder <= 0 || MaxOrder < MinOrder) {
            throw new IllegalArgumentException("MinOrder<1 or MaxOrder<MinOrder.");
        }
        if (Step < 1) {
            throw new IllegalArgumentException("Step < 1");
        }
        this.MinOrder = MinOrder;
        this.MaxOrder = MaxOrder;
        this.Step = Step;
        this.Allocate();
    }

    public void setStructuringElementType(int type) {
        this.SE = type;
    }

    @Override
    public void Parameters(Object ... parameters) {
        if (parameters.length != 5) {
            throw new IllegalArgumentException("5 parameters required.");
        }
        this.setParameters((Integer)parameters[0], (Integer)parameters[1], (Integer)parameters[2]);
        this.ForbiddenValue = (Integer)parameters[3];
        this.setStructuringElementType((Integer)parameters[4]);
    }

    public int getMinOrder() {
        return this.MinOrder;
    }

    public int getMaxOrder() {
        return this.MaxOrder;
    }

    public int getStep() {
        return this.Step;
    }

    public long[] getIntegral() {
        return this.Integral;
    }

    public double[] getDistributionIntegral() {
        return this.DistIntegral;
    }

    @Override
    public double[] Features() {
        return this.DistIntegral;
    }

    @Override
    public double Feature(int x) {
        return this.DistIntegral[x];
    }

    @Override
    public String[] FeaturesNames() {
        int count = 0;
        String[] s = new String[(this.MaxOrder - this.MinOrder) / this.Step + 1];
        for (int i2 = this.MinOrder; i2 <= this.MaxOrder; i2 += this.Step) {
            s[count++] = "Granulometry_" + this.MinOrder + "_" + this.MaxOrder + "_" + this.Step + "_" + this.SE + "_" + (i2 < 10 ? "0" : "") + i2;
        }
        return s;
    }

    @Override
    public int ForbiddenValue() {
        return this.ForbiddenValue;
    }
}

