/*
 * Decompiled with CFR 0.152.
 */
package morphee.granulometry;

import java.awt.image.BufferedImage;
import measures.histogram.Histogram;
import morphee.BlackTopHat;
import morphee.StructuringElement;
import morphee.levelings.Leveling;
import processing.filters.Gaussian;

public class AntiGranulometryTopHat {
    private int MinRadius = -1;
    private int MaxRadius = -1;
    private int Step = -1;
    private int ForbidenValue = -1;
    private int SE = -2;
    private final Histogram histo = new Histogram();
    private final BlackTopHat bth = new BlackTopHat();
    private final Gaussian gauss = new Gaussian(1, 1.0, 2);
    private int[] Integral = null;
    private double[] DistributionIntegral = null;

    public void Process(BufferedImage source, int MinRadius, int MaxRadius, int Step, Leveling leveling, int ForbidenValue, int nbCPU) {
        this.setParameters(MinRadius, MaxRadius, Step);
        this.ForbidenValue = ForbidenValue;
        BufferedImage Reduced = null;
        BufferedImage result = new BufferedImage(source.getWidth(), source.getHeight(), source.getType());
        int R = MinRadius;
        int counter = 0;
        StructuringElement startse = new StructuringElement(new Object[]{MinRadius, this.SE});
        StructuringElement stepse = new StructuringElement(new Object[]{Step, this.SE});
        Reduced = leveling == null ? source : leveling.Filter(source, nbCPU, this.gauss.Filter(source, nbCPU));
        this.Allocate();
        this.Measures(Reduced, counter++);
        this.bth.setStructuringElement(startse);
        this.bth.Filter(Reduced, result, nbCPU);
        this.Measures(result, counter++);
        Reduced = null;
        Reduced = result;
        R += Step;
        while (R <= MaxRadius) {
            this.bth.setStructuringElement(stepse);
            this.bth.Filter(Reduced, result, nbCPU);
            this.Measures(result, counter++);
            Reduced = null;
            Reduced = result;
            R += Step;
        }
        result = null;
        Reduced = null;
        stepse = null;
        startse = null;
        this.ComputeDistributions();
    }

    protected void Measures(BufferedImage image, int Count) {
        this.histo.Fill(image);
        this.Integral[Count] = this.getIntegral(this.histo.getValues(0));
    }

    protected void ComputeDistributions() {
        for (int i2 = 0; i2 < this.Integral.length - 1; ++i2) {
            this.DistributionIntegral[i2] = (double)(this.Integral[i2 + 1] - this.Integral[i2]) / (double)this.Integral[0];
        }
    }

    private int getIntegral(int[] histogram) {
        int sum = 0;
        for (int i2 = 0; i2 < histogram.length; ++i2) {
            if (i2 == this.ForbidenValue) continue;
            sum += i2 * histogram[i2];
        }
        return sum;
    }

    private void Allocate() {
        int N = (int)((double)(this.MaxRadius - this.MinRadius) / (double)this.Step) + 2;
        this.Integral = null;
        this.Integral = new int[N];
        this.DistributionIntegral = null;
        this.DistributionIntegral = new double[N - 1];
    }

    public void setParameters(int MinRadius, int MaxRadius, int Step) {
        if (MinRadius <= 0 || MaxRadius < MinRadius) {
            throw new IllegalArgumentException("MinRadius<1 or MaxRadius<MinRadius.");
        }
        if (Step < 1) {
            throw new IllegalArgumentException("Step < 1");
        }
        this.MinRadius = MinRadius;
        this.MaxRadius = MaxRadius;
        this.Step = Step;
    }

    public void setStructuringElementType(int type) {
        this.SE = type;
    }

    public int getMinRadius() {
        return this.MinRadius;
    }

    public int getMaxRadius() {
        return this.MaxRadius;
    }

    public int getStep() {
        return this.Step;
    }

    public int[] getIntegral() {
        return this.Integral;
    }

    public double[] getDistributionIntegral() {
        return this.DistributionIntegral;
    }

    public double[] Feature() {
        return this.DistributionIntegral;
    }

    public double Feature(int x) {
        return this.DistributionIntegral[x];
    }

    public String[] FeaturesNames() {
        int count = 0;
        String[] s = new String[(this.MaxRadius - this.MinRadius) / this.Step + 1];
        for (int i2 = this.MinRadius; i2 <= this.MaxRadius; i2 += this.Step) {
            s[count++] = "AntiGranulometry " + (i2 < 10 ? "0" : "") + i2;
        }
        return s;
    }
}

