/*
 * Decompiled with CFR 0.152.
 */
package morphee.granulometry;

import characterization.ComputableFeatures;
import characterization.PreComputable;
import dv.DV;
import imageTiTi.ImageComparator;
import imageTiTi.ImageFeatures;
import imageTiTi.ImageNew;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.util.Arrays;
import morphee.filters.AreaClosing;
import morphee.levelings.Leveling;
import processing.filters.Gaussian;

public class AntiGranulometryArea
implements ComputableFeatures,
PreComputable {
    private int MinRadius = -1;
    private int MaxRadius = -1;
    private int Step = -1;
    private int ForbiddenValue = -1;
    protected Leveling leveling = null;
    private final AreaClosing areaclose = new AreaClosing();
    private final Gaussian gauss = new Gaussian(1, 1.0, 2);
    private int[] Integral = null;
    private double[] DistIntegral = null;
    private BufferedImage[] preprocessed = null;
    private final ImageFeatures IF = new ImageFeatures();

    @Override
    public synchronized void Kill() {
        if (this.leveling != null) {
            this.leveling.Kill();
        }
        this.areaclose.Kill();
        this.gauss.Kill();
        this.Integral = null;
        this.DistIntegral = null;
        Arrays.fill(this.preprocessed, null);
        this.preprocessed = null;
    }

    public void Process(BufferedImage source, BufferedImage mask, int MinRadius, int MaxRadius, int Step, Leveling leveling, int ForbiddenValue, int nbCPU) {
        this.setParameters(MinRadius, MaxRadius, Step);
        this.ForbiddenValue = ForbiddenValue;
        BufferedImage Reduced = null;
        int R = MinRadius;
        int counter = 0;
        Reduced = leveling == null ? source : leveling.Filter(source, nbCPU, this.gauss.Filter(source, nbCPU));
        BufferedImage result = ImageNew.Clone((BufferedImage)Reduced);
        this.Allocate();
        if (mask != null) {
            ImageComparator.Compare((BufferedImage)mask, (String)"!=", (int)0, (BufferedImage)Reduced, (int)ForbiddenValue, (BufferedImage)result);
        }
        this.Measures(result, counter++);
        while (R <= MaxRadius) {
            this.areaclose.Filter(Reduced, result, R, true);
            if (mask != null) {
                ImageComparator.Compare((BufferedImage)mask, (String)"!=", (int)0, (BufferedImage)result, (int)ForbiddenValue, (BufferedImage)result);
            }
            this.Measures(result, counter++);
            R += Step;
        }
        result = null;
        Reduced = null;
        this.ComputeDistributions();
    }

    @Override
    public void Compute(BufferedImage image, BufferedImage mask, int ForbiddenValue, int nbCPU) {
        this.Process(image, mask, this.MinRadius, this.MaxRadius, this.Step, this.leveling, ForbiddenValue, nbCPU);
    }

    @Override
    public void PreCompute(BufferedImage image, int nbCPU) {
        if (this.MinRadius < 1) {
            throw new Error("Set parameters before to call this method.");
        }
        BufferedImage Reduced = null;
        Reduced = this.leveling == null ? image : this.leveling.Filter(image, nbCPU, this.gauss.Filter(image, nbCPU));
        int nb = 0;
        this.Allocate();
        this.preprocessed[nb++] = ImageNew.Clone((BufferedImage)image);
        for (int R = this.MinRadius; R <= this.MaxRadius; R += this.Step) {
            this.preprocessed[nb++] = this.areaclose.Filter(Reduced, R, true);
        }
    }

    @Override
    public void FastCompute(int startx, int starty, int endx, int endy) {
        for (int i2 = 0; i2 < this.preprocessed.length; ++i2) {
            this.Integral[i2] = 0;
            WritableRaster wr = this.preprocessed[i2].getRaster();
            for (int y = starty; y <= endy; ++y) {
                for (int x = startx; x <= endx; ++x) {
                    if (wr.getSample(x, y, 0) == this.ForbiddenValue) continue;
                    int n = i2;
                    this.Integral[n] = this.Integral[n] + wr.getSample(x, y, 0);
                }
            }
            wr = null;
        }
        this.ComputeDistributions();
    }

    @Override
    public void Compute(DV dv, int nbCPU) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    protected void Measures(BufferedImage image, int Count) {
        this.Integral[Count] = (int)this.IF.Integral(image, this.ForbiddenValue);
    }

    protected void ComputeDistributions() {
        for (int i2 = 0; i2 < this.Integral.length - 1; ++i2) {
            this.DistIntegral[i2] = (double)(this.Integral[i2 + 1] - this.Integral[i2]) / (double)this.Integral[0];
        }
    }

    private void Allocate() {
        int N = (int)((double)(this.MaxRadius - this.MinRadius) / (double)this.Step) + 2;
        if (this.Integral == null || this.Integral.length != N) {
            this.Integral = null;
            this.Integral = new int[N];
            this.DistIntegral = null;
            this.DistIntegral = new double[N - 1];
            this.preprocessed = null;
            this.preprocessed = new BufferedImage[N];
        }
    }

    public void setParameters(int MinRadius, int MaxRadius, int Step) {
        if (MinRadius <= 0 || MaxRadius < MinRadius) {
            throw new IllegalArgumentException("MinRadius<1 or MaxRadius<MinRadius.");
        }
        if (Step < 1) {
            throw new IllegalArgumentException("Step < 1");
        }
        this.MinRadius = MinRadius;
        this.MaxRadius = MaxRadius;
        this.Step = Step;
    }

    @Override
    public void Parameters(Object ... parameters) {
        if (parameters.length != 5) {
            throw new IllegalArgumentException("5 parameters required.");
        }
        this.MinRadius = (Integer)parameters[0];
        this.MaxRadius = (Integer)parameters[1];
        this.Step = (Integer)parameters[2];
        this.leveling = (Leveling)parameters[3];
        this.ForbiddenValue = (Integer)parameters[4];
    }

    public int getMinRadius() {
        return this.MinRadius;
    }

    public int getMaxRadius() {
        return this.MaxRadius;
    }

    public int getStep() {
        return this.Step;
    }

    public int[] getIntegral() {
        return this.Integral;
    }

    public double[] getDistributionIntegral() {
        return this.DistIntegral;
    }

    @Override
    public double[] Features() {
        return this.DistIntegral;
    }

    @Override
    public double Feature(int x) {
        return this.DistIntegral[x];
    }

    @Override
    public String[] FeaturesNames() {
        int count = 0;
        String[] s = new String[(this.MaxRadius - this.MinRadius) / this.Step + 1];
        for (int i2 = this.MinRadius; i2 <= this.MaxRadius; i2 += this.Step) {
            s[count++] = "AntiGranulometryArea " + (i2 < 10 ? "0" : "") + i2;
        }
        return s;
    }
}

