/*
 * Decompiled with CFR 0.152.
 */
package morphee.gradients;

import arrayTiTi.ArrayConverter;
import arrayTiTi.ArrayFeatures;
import dv.DV;
import imageTiTi.ImageNew;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferUShort;
import java.util.ArrayList;
import java.util.List;
import morphee.Dilate;
import morphee.Erode;
import morphee.MorphoFilter;
import morphee.StructuringElement;
import morphee.StructuringElement3D;
import processing.filters.DynamicExpansion;
import processing.filters.gradients.SignalGradient;

public class Laplacian
implements SignalGradient,
MorphoFilter {
    private final Erode erode = new Erode();
    private final Dilate dilate = new Dilate();
    private StructuringElement se = null;
    private final DynamicExpansion de = new DynamicExpansion();
    private int HowCorrect = 2;
    private int width;
    private int height;
    private int size;
    private int[] res = null;
    private BufferedImage resero;
    private BufferedImage resdil;
    private final ArrayFeatures AF = new ArrayFeatures();

    public BufferedImage Filter(BufferedImage source, StructuringElement se, int nbCPU) {
        this.setStructuringElement(se);
        return this.Filter(source, nbCPU);
    }

    public void Filter(BufferedImage source, StructuringElement se, BufferedImage result, int nbCPU) {
        this.setStructuringElement(se);
        this.Filter(source, result, nbCPU);
    }

    public BufferedImage Filter(BufferedImage source, int nbCPU) {
        BufferedImage result = ImageNew.Same((BufferedImage)source);
        this.Filter(source, result, nbCPU);
        return result;
    }

    public void Filter(BufferedImage source, BufferedImage result, int nbCPU) {
        this.Filter(source, result, this.se, this.HowCorrect, nbCPU);
    }

    public void Filter(BufferedImage Original, BufferedImage Result, StructuringElement se, int HowCorrect, int nbCPU) {
        int x;
        int MAX;
        if (!ImageTools.areDimensionsAndTypeEqual((BufferedImage)Original, (BufferedImage)Result)) {
            throw new IllegalArgumentException("Images have different dimensions or type.");
        }
        this.width = Original.getWidth();
        this.height = Original.getHeight();
        this.size = this.width * this.height;
        if (this.res == null || this.res.length != this.size) {
            this.res = null;
            this.res = new int[this.size];
            this.resdil = null;
            this.resero = null;
            this.resero = ImageNew.Same((BufferedImage)Original);
            this.resdil = ImageNew.Same((BufferedImage)Original);
        }
        this.setStructuringElement(se);
        this.dilate.Filter(Original, this.resdil, nbCPU);
        this.erode.Filter(Original, this.resero, nbCPU);
        switch (Original.getType()) {
            case 5: 
            case 6: 
            case 10: {
                MAX = 255;
                byte[] bytebufferin = ((DataBufferByte)Original.getRaster().getDataBuffer()).getData();
                byte[] bytebufferero = ((DataBufferByte)this.resero.getRaster().getDataBuffer()).getData();
                byte[] bytebufferdil = ((DataBufferByte)this.resdil.getRaster().getDataBuffer()).getData();
                for (x = 0; x < this.size; ++x) {
                    this.res[x] = (bytebufferdil[x] & 0xFF) + (bytebufferero[x] & 0xFF) - 2 * (bytebufferin[x] & 0xFF);
                }
                bytebufferdil = null;
                bytebufferero = null;
                bytebufferin = null;
                break;
            }
            case 11: {
                MAX = 65535;
                short[] shortbufferin = ((DataBufferUShort)Original.getRaster().getDataBuffer()).getData();
                short[] shortbufferero = ((DataBufferUShort)this.resero.getRaster().getDataBuffer()).getData();
                short[] shortbufferdil = ((DataBufferUShort)this.resdil.getRaster().getDataBuffer()).getData();
                for (x = 0; x < this.size; ++x) {
                    this.res[x] = (shortbufferdil[x] & 0xFFFF) + (shortbufferero[x] & 0xFFFF) - 2 * (shortbufferin[x] & 0xFFFF);
                }
                shortbufferdil = null;
                shortbufferero = null;
                shortbufferin = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Default: image type not supported.");
            }
        }
        switch (HowCorrect) {
            case 0: {
                break;
            }
            case 2: {
                for (x = 0; x < this.size; ++x) {
                    this.res[x] = Math.abs(this.res[x]);
                }
            }
            case 1: {
                int min = this.AF.Minimum(this.res);
                int max = this.AF.Maximum(this.res);
                if (min >= 0 && MAX >= max) break;
                this.de.Filter(this.res, this.res, min, max, 0, MAX);
                break;
            }
            default: {
                throw new IllegalArgumentException("HowCorrect value unknown.");
            }
        }
        switch (Original.getType()) {
            case 5: 
            case 6: 
            case 10: {
                byte[] bytebufferout = ((DataBufferByte)Result.getRaster().getDataBuffer()).getData();
                for (x = 0; x < bytebufferout.length; ++x) {
                    bytebufferout[x] = (byte)this.res[x];
                }
                bytebufferout = null;
                break;
            }
            case 11: {
                short[] shortbufferout = ((DataBufferUShort)Result.getRaster().getDataBuffer()).getData();
                for (x = 0; x < shortbufferout.length; ++x) {
                    shortbufferout[x] = (short)this.res[x];
                }
                shortbufferout = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Default: image type not supported.");
            }
        }
    }

    public DV Filter(DV source, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public void Filter(DV source, DV result, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public DV Filter(DV source, StructuringElement3D se, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public void Filter(DV source, StructuringElement3D se, DV result, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public StructuringElement3D getStructuringElement3D() {
        return null;
    }

    public void setStructuringElement3D(StructuringElement3D se) {
    }

    public StructuringElement getStructuringElement() {
        return this.dilate.getStructuringElement();
    }

    public void setStructuringElement(StructuringElement se) {
        this.se = se;
        this.dilate.setStructuringElement(se);
        this.erode.setStructuringElement(se);
    }

    public int[] getRes() {
        return this.res;
    }

    public int[][] getResult() {
        return ArrayConverter.to2D((int[])this.res, (int)this.width, (int)this.height);
    }

    public void HowCorrect(int howcorrect) {
    }

    public int HowCorrect() {
        return -1;
    }

    public void Parameters(Object ... parameters) {
        if (parameters.length != 2) {
            throw new IllegalArgumentException("Two parameters required.");
        }
        this.setStructuringElement((StructuringElement)parameters[0]);
        this.HowCorrect = (Integer)parameters[1];
    }

    public List<Object> Parameters() {
        ArrayList<Object> list = new ArrayList<Object>(2);
        list.add(this.se);
        list.add(this.HowCorrect);
        return list;
    }

    public int BorderEffectSizeX() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public int BorderEffectSizeY() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public int BorderEffectSizeZ() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public MorphoFilter Clone() {
        throw new UnsupportedOperationException("Not supported (yet).");
    }
}

