/*
 * Decompiled with CFR 0.152.
 */
package morphee.geodesic;

import dv.DV;
import imageTiTi.ImageNew;
import imageTiTi.ImageOperations;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.util.List;
import morphee.Dilate;
import morphee.MorphoFilterMarker;
import morphee.Open;
import morphee.StructuringElement;
import morphee.StructuringElement3D;

public class ViscousReconstructionApp
implements MorphoFilterMarker {
    private Dilate dilate = new Dilate(new StructuringElement(new Object[]{1, -1}));
    private Open open = new Open(new StructuringElement(new Object[]{1, -1}));
    private BufferedImage marker = null;
    private BufferedImage rec = null;
    private BufferedImage dilated = null;
    private BufferedImage opened = null;

    public void Filter(BufferedImage reference, BufferedImage marker, BufferedImage result, int nbCPU) {
        this.Marker(marker);
        this.Filter(reference, result, nbCPU);
    }

    public BufferedImage Filter(BufferedImage reference, int nbCPU, BufferedImage marker) {
        this.Marker(marker);
        return this.Filter(reference, nbCPU);
    }

    public BufferedImage Filter(BufferedImage source, StructuringElement se, int nbCPU) {
        this.setStructuringElement(se);
        return this.Filter(source, nbCPU);
    }

    public void Filter(BufferedImage source, StructuringElement se, BufferedImage result, int nbCPU) {
        this.setStructuringElement(se);
        this.Filter(source, result, nbCPU);
    }

    public BufferedImage Filter(BufferedImage source, int nbCPU) {
        BufferedImage result = ImageNew.Same((BufferedImage)source);
        this.Filter(source, result, nbCPU);
        return result;
    }

    public void Filter(BufferedImage reference, BufferedImage result, int nbCPU) {
        if (this.marker == null) {
            throw new Error("Any marker defined.");
        }
        if (ImageTools.isColored((BufferedImage)this.marker)) {
            throw new IllegalArgumentException("Colored images not supported.");
        }
        if (!ImageTools.areDimensionsAndTypeEqual((BufferedImage)reference, (BufferedImage)this.marker)) {
            throw new IllegalArgumentException("Images reference and marker must have identic type.");
        }
        if (this.rec == null || !ImageTools.areDimensionsAndTypeEqual((BufferedImage)reference, (BufferedImage)this.rec)) {
            this.rec = ImageNew.Same((BufferedImage)reference);
            this.dilated = ImageNew.Same((BufferedImage)reference);
            this.opened = ImageNew.Same((BufferedImage)reference);
        }
        ImageNew.Copy((BufferedImage)this.marker, (BufferedImage)this.rec);
        this.open.Filter(reference, this.opened, nbCPU);
        while (!ImageTools.areEqual((BufferedImage)result, (BufferedImage)this.rec)) {
            ImageNew.Copy((BufferedImage)this.rec, (BufferedImage)result);
            this.dilate.Filter(result, this.dilated, nbCPU);
            ImageOperations.Minimum((BufferedImage)this.dilated, (BufferedImage)this.opened, (BufferedImage)this.rec);
        }
    }

    public DV Filter(DV source, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public void Filter(DV source, DV result, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public DV Filter(DV source, StructuringElement3D se, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public void Filter(DV source, StructuringElement3D se, DV result, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public StructuringElement3D getStructuringElement3D() {
        return null;
    }

    public void setStructuringElement3D(StructuringElement3D se) {
    }

    public void Marker(BufferedImage marker) {
        this.marker = null;
        this.marker = marker;
    }

    public BufferedImage Marker() {
        return this.marker;
    }

    public void Marker(DV Marker2) {
        throw new Error("Method not implemented (yet).");
    }

    public DV Marker3D() {
        throw new Error("Method not implemented (yet).");
    }

    public StructuringElement getStructuringElement() {
        return null;
    }

    public void setStructuringElement(StructuringElement ES) {
    }

    public void Parameters(Object ... parameters) {
    }

    public List<Object> Parameters() {
        return null;
    }

    public int BorderEffectSizeX() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public int BorderEffectSizeY() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public int BorderEffectSizeZ() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public MorphoFilterMarker Clone() {
        throw new UnsupportedOperationException("Not supported (yet).");
    }
}

