/*
 * Decompiled with CFR 0.152.
 */
package morphee.geodesic;

import arrayTiTi.ArrayNew;
import arrayTiTi.ArrayTools;
import dv.DV;
import imageTiTi.ImageNew;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.WritableRaster;
import java.util.List;
import java.util.PriorityQueue;
import morphee.MorphoFilterMarker;
import morphee.StructuringElement;
import morphee.StructuringElement3D;

public class UnderBuildFAH
implements MorphoFilterMarker {
    private PriorityQueue<Pix> pq = new PriorityQueue(13011);
    private BufferedImage marker = null;
    private PriorityQueue<PixDouble> pqdouble = new PriorityQueue(13011);
    private double[][] markerdouble = null;

    public BufferedImage Filter(BufferedImage reference, int nbCPU, BufferedImage marker) {
        BufferedImage result = ImageNew.Same((BufferedImage)reference);
        this.Filter(reference, marker, result, nbCPU);
        return result;
    }

    public void Filter(BufferedImage reference, BufferedImage marker, BufferedImage result, int nbCPU) {
        this.Marker(marker);
        this.Filter(reference, result, nbCPU);
    }

    public BufferedImage Filter(BufferedImage source, StructuringElement se, int nbCPU) {
        this.setStructuringElement(se);
        return this.Filter(source, nbCPU);
    }

    public void Filter(BufferedImage source, StructuringElement se, BufferedImage result, int nbCPU) {
        this.setStructuringElement(se);
        this.Filter(source, result, nbCPU);
    }

    public BufferedImage Filter(BufferedImage source, int nbCPU) {
        BufferedImage result = ImageNew.Same((BufferedImage)source);
        this.Filter(source, result, nbCPU);
        return result;
    }

    public void Filter(BufferedImage reference, BufferedImage result, int nbCPU) {
        if (!ImageTools.areDimensionsAndTypeEqual((BufferedImage)reference, (BufferedImage)this.marker)) {
            throw new IllegalArgumentException("Dimensions or type of reference and marker are different.");
        }
        Pix pix = null;
        int height = reference.getHeight();
        int width = reference.getWidth();
        ImageNew.Copy((BufferedImage)this.marker, (BufferedImage)result);
        this.pq.clear();
        switch (reference.getType()) {
            case 12: {
                int Color2;
                int x;
                int y;
                WritableRaster wr = reference.getRaster();
                WritableRaster wrres = result.getRaster();
                for (y = 0; y < height; ++y) {
                    for (x = 0; x < width; ++x) {
                        Color2 = wrres.getSample(x, y, 0);
                        if (Color2 <= 0) continue;
                        this.pq.add(new Pix(x, y, Color2));
                    }
                }
                while (!this.pq.isEmpty()) {
                    int min;
                    pix = this.pq.poll();
                    x = pix.x;
                    y = pix.y;
                    Color2 = pix.v;
                    if (y - 1 >= 0 && (min = Math.min(wr.getSample(x, y - 1, 0), Color2)) > wrres.getSample(x, y - 1, 0)) {
                        this.Mark(x, y - 1, wrres, min);
                    }
                    if (y + 1 < height && (min = Math.min(wr.getSample(x, y + 1, 0), Color2)) > wrres.getSample(x, y + 1, 0)) {
                        this.Mark(x, y + 1, wrres, min);
                    }
                    if (x - 1 >= 0 && (min = Math.min(wr.getSample(x - 1, y, 0), Color2)) > wrres.getSample(x - 1, y, 0)) {
                        this.Mark(x - 1, y, wrres, min);
                    }
                    if (x + 1 < width && (min = Math.min(wr.getSample(x + 1, y, 0), Color2)) > wrres.getSample(x + 1, y, 0)) {
                        this.Mark(x + 1, y, wrres, min);
                    }
                    if (x - 1 >= 0 && y - 1 >= 0 && (min = Math.min(wr.getSample(x - 1, y - 1, 0), Color2)) > wrres.getSample(x - 1, y - 1, 0)) {
                        this.Mark(x - 1, y - 1, wrres, min);
                    }
                    if (x + 1 < width && y - 1 >= 0 && (min = Math.min(wr.getSample(x + 1, y - 1, 0), Color2)) > wrres.getSample(x + 1, y - 1, 0)) {
                        this.Mark(x + 1, y - 1, wrres, min);
                    }
                    if (x - 1 >= 0 && y + 1 < height && (min = Math.min(wr.getSample(x - 1, y + 1, 0), Color2)) > wrres.getSample(x - 1, y + 1, 0)) {
                        this.Mark(x - 1, y + 1, wrres, min);
                    }
                    if (x + 1 >= width || y + 1 >= height || (min = Math.min(wr.getSample(x + 1, y + 1, 0), Color2)) <= wrres.getSample(x + 1, y + 1, 0)) continue;
                    this.Mark(x + 1, y + 1, wrres, min);
                }
                wrres = null;
                wr = null;
                break;
            }
            case 10: {
                int Color3;
                int x;
                int y;
                byte[] bytebufferin = ((DataBufferByte)reference.getRaster().getDataBuffer()).getData();
                byte[] bytebufferout = ((DataBufferByte)result.getRaster().getDataBuffer()).getData();
                int pos = 0;
                for (y = 0; y < height; ++y) {
                    x = 0;
                    while (x < width) {
                        Color3 = bytebufferout[pos] & 0xFF;
                        if (Color3 > 0) {
                            this.pq.add(new Pix(x, y, Color3));
                        }
                        ++x;
                        ++pos;
                    }
                }
                while (!this.pq.isEmpty()) {
                    int min;
                    pix = this.pq.poll();
                    x = pix.x;
                    y = pix.y;
                    Color3 = pix.v;
                    pos = x + y * width;
                    if (y - 1 >= 0 && (min = Math.min(bytebufferin[pos - width] & 0xFF, Color3)) > (bytebufferout[pos - width] & 0xFF)) {
                        this.Mark(x, y - 1, bytebufferout, width, min);
                    }
                    if (y + 1 < height && (min = Math.min(bytebufferin[pos + width] & 0xFF, Color3)) > (bytebufferout[pos + width] & 0xFF)) {
                        this.Mark(x, y + 1, bytebufferout, width, min);
                    }
                    if (x - 1 >= 0 && (min = Math.min(bytebufferin[pos - 1] & 0xFF, Color3)) > (bytebufferout[pos - 1] & 0xFF)) {
                        this.Mark(x - 1, y, bytebufferout, width, min);
                    }
                    if (x + 1 < width && (min = Math.min(bytebufferin[pos + 1] & 0xFF, Color3)) > (bytebufferout[pos + 1] & 0xFF)) {
                        this.Mark(x + 1, y, bytebufferout, width, min);
                    }
                    if (x - 1 >= 0 && y - 1 >= 0 && (min = Math.min(bytebufferin[pos - width - 1] & 0xFF, Color3)) > (bytebufferout[pos - width - 1] & 0xFF)) {
                        this.Mark(x - 1, y - 1, bytebufferout, width, min);
                    }
                    if (x + 1 < width && y - 1 >= 0 && (min = Math.min(bytebufferin[pos - width + 1] & 0xFF, Color3)) > (bytebufferout[pos - width + 1] & 0xFF)) {
                        this.Mark(x + 1, y - 1, bytebufferout, width, min);
                    }
                    if (x - 1 >= 0 && y + 1 < height && (min = Math.min(bytebufferin[pos + width - 1] & 0xFF, Color3)) > (bytebufferout[pos + width - 1] & 0xFF)) {
                        this.Mark(x - 1, y + 1, bytebufferout, width, min);
                    }
                    if (x + 1 >= width || y + 1 >= height || (min = Math.min(bytebufferin[pos + width + 1] & 0xFF, Color3)) <= (bytebufferout[pos + width + 1] & 0xFF)) continue;
                    this.Mark(x + 1, y + 1, bytebufferout, width, min);
                }
                break;
            }
            case 11: {
                int Color4;
                int x;
                int y;
                short[] shortbufferin = ((DataBufferUShort)reference.getRaster().getDataBuffer()).getData();
                short[] shortbufferout = ((DataBufferUShort)result.getRaster().getDataBuffer()).getData();
                int pos = 0;
                for (y = 0; y < height; ++y) {
                    x = 0;
                    while (x < width) {
                        Color4 = shortbufferout[pos] & 0xFFFF;
                        if (Color4 > 0) {
                            this.pq.add(new Pix(x, y, Color4));
                        }
                        ++x;
                        ++pos;
                    }
                }
                while (!this.pq.isEmpty()) {
                    int min;
                    pix = this.pq.poll();
                    x = pix.x;
                    y = pix.y;
                    Color4 = pix.v;
                    pos = x + y * width;
                    if (y - 1 >= 0 && (min = Math.min(shortbufferin[pos - width] & 0xFFFF, Color4)) > (shortbufferout[pos - width] & 0xFFFF)) {
                        this.Mark(x, y - 1, shortbufferout, width, min);
                    }
                    if (y + 1 < height && (min = Math.min(shortbufferin[pos + width] & 0xFFFF, Color4)) > (shortbufferout[pos + width] & 0xFFFF)) {
                        this.Mark(x, y + 1, shortbufferout, width, min);
                    }
                    if (x - 1 >= 0 && (min = Math.min(shortbufferin[pos - 1] & 0xFFFF, Color4)) > (shortbufferout[pos - 1] & 0xFFFF)) {
                        this.Mark(x - 1, y, shortbufferout, width, min);
                    }
                    if (x + 1 < width && (min = Math.min(shortbufferin[pos + 1] & 0xFFFF, Color4)) > (shortbufferout[pos + 1] & 0xFFFF)) {
                        this.Mark(x + 1, y, shortbufferout, width, min);
                    }
                    if (x - 1 >= 0 && y - 1 >= 0 && (min = Math.min(shortbufferin[pos - width - 1] & 0xFFFF, Color4)) > (shortbufferout[pos - width - 1] & 0xFFFF)) {
                        this.Mark(x - 1, y - 1, shortbufferout, width, min);
                    }
                    if (x + 1 < width && y - 1 >= 0 && (min = Math.min(shortbufferin[pos - width + 1] & 0xFFFF, Color4)) > (shortbufferout[pos - width + 1] & 0xFFFF)) {
                        this.Mark(x + 1, y - 1, shortbufferout, width, min);
                    }
                    if (x - 1 >= 0 && y + 1 < height && (min = Math.min(shortbufferin[pos + width - 1] & 0xFFFF, Color4)) > (shortbufferout[pos + width - 1] & 0xFFFF)) {
                        this.Mark(x - 1, y + 1, shortbufferout, width, min);
                    }
                    if (x + 1 >= width || y + 1 >= height || (min = Math.min(shortbufferin[pos + width + 1] & 0xFFFF, Color4)) <= (shortbufferout[pos + width + 1] & 0xFFFF)) continue;
                    this.Mark(x + 1, y + 1, shortbufferout, width, min);
                }
                break;
            }
            case 0: {
                switch (reference.getRaster().getDataBuffer().getDataType()) {
                    case 3: {
                        int Color5;
                        int x;
                        int y;
                        int[] intbufferin = ((DataBufferInt)reference.getRaster().getDataBuffer()).getData();
                        int[] intbufferout = ((DataBufferInt)result.getRaster().getDataBuffer()).getData();
                        int pos = 0;
                        for (y = 0; y < height; ++y) {
                            x = 0;
                            while (x < width) {
                                Color5 = intbufferout[pos];
                                if (Color5 > 0) {
                                    this.pq.add(new Pix(x, y, Color5));
                                }
                                ++x;
                                ++pos;
                            }
                        }
                        while (!this.pq.isEmpty()) {
                            int min;
                            pix = this.pq.poll();
                            x = pix.x;
                            y = pix.y;
                            Color5 = pix.v;
                            pos = x + y * width;
                            if (y - 1 >= 0 && (min = Math.min(intbufferin[pos - width], Color5)) > intbufferout[pos - width]) {
                                this.Mark(x, y - 1, intbufferout, width, min);
                            }
                            if (y + 1 < height && (min = Math.min(intbufferin[pos + width], Color5)) > intbufferout[pos + width]) {
                                this.Mark(x, y + 1, intbufferout, width, min);
                            }
                            if (x - 1 >= 0 && (min = Math.min(intbufferin[pos - 1], Color5)) > intbufferout[pos - 1]) {
                                this.Mark(x - 1, y, intbufferout, width, min);
                            }
                            if (x + 1 < width && (min = Math.min(intbufferin[pos + 1], Color5)) > intbufferout[pos + 1]) {
                                this.Mark(x + 1, y, intbufferout, width, min);
                            }
                            if (x - 1 >= 0 && y - 1 >= 0 && (min = Math.min(intbufferin[pos - width - 1], Color5)) > intbufferout[pos - width - 1]) {
                                this.Mark(x - 1, y - 1, intbufferout, width, min);
                            }
                            if (x + 1 < width && y - 1 >= 0 && (min = Math.min(intbufferin[pos - width + 1], Color5)) > intbufferout[pos - width + 1]) {
                                this.Mark(x + 1, y - 1, intbufferout, width, min);
                            }
                            if (x - 1 >= 0 && y + 1 < height && (min = Math.min(intbufferin[pos + width - 1], Color5)) > intbufferout[pos + width - 1]) {
                                this.Mark(x - 1, y + 1, intbufferout, width, min);
                            }
                            if (x + 1 >= width || y + 1 >= height || (min = Math.min(intbufferin[pos + width + 1], Color5)) <= intbufferout[pos + width + 1]) continue;
                            this.Mark(x + 1, y + 1, intbufferout, width, min);
                        }
                        break;
                    }
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported.");
            }
        }
    }

    private void Mark(int x, int y, WritableRaster raster, int value) {
        this.pq.add(new Pix(x, y, value));
        raster.setSample(x, y, 0, value);
    }

    private void Mark(int x, int y, byte[] raster, int width, int value) {
        this.pq.add(new Pix(x, y, value));
        raster[x + y * width] = (byte)value;
    }

    private void Mark(int x, int y, short[] raster, int width, int value) {
        this.pq.add(new Pix(x, y, value));
        raster[x + y * width] = (short)value;
    }

    private void Mark(int x, int y, int[] raster, int width, int value) {
        this.pq.add(new Pix(x, y, value));
        raster[x + y * width] = value;
    }

    public DV Filter(DV source, int nbCPU) {
        throw new UnsupportedOperationException("Empty method, not implemented (yet)");
    }

    public void Filter(DV source, DV result, int nbCPU) {
        throw new UnsupportedOperationException("Empty method, not implemented (yet)");
    }

    public DV Filter(DV source, StructuringElement3D se, int nbCPU) {
        throw new UnsupportedOperationException("Empty method, not implemented (yet)");
    }

    public void Filter(DV source, StructuringElement3D se, DV result, int nbCPU) {
        throw new UnsupportedOperationException("Empty method, not implemented (yet)");
    }

    public StructuringElement3D getStructuringElement3D() {
        return null;
    }

    public void setStructuringElement3D(StructuringElement3D se) {
    }

    public double[][] Filter(double[][] reference, int nbCPU, double[][] marker) {
        double[][] result = ArrayNew.Same((double[][])reference);
        this.Filter(reference, marker, result, nbCPU);
        return result;
    }

    public void Filter(double[][] reference, double[][] marker, double[][] result, int nbCPU) {
        this.Marker(marker);
        this.Filter(reference, result, nbCPU);
    }

    public double[][] Filter(double[][] reference, int nbCPU) {
        double[][] result = ArrayNew.Same((double[][])reference);
        this.Filter(reference, result, nbCPU);
        return result;
    }

    public void Filter(double[][] reference, double[][] result, int nbCPU) {
        int x;
        int y;
        if (!ArrayTools.areDimensionsEqual((double[][])reference, (double[][])this.markerdouble)) {
            throw new IllegalArgumentException("Dimensions or type of reference and marker are different.");
        }
        PixDouble pix = null;
        int height = reference.length;
        int width = reference[0].length;
        ArrayNew.Copy((double[][])this.markerdouble, (double[][])result);
        this.pqdouble.clear();
        for (y = 0; y < height; ++y) {
            for (x = 0; x < width; ++x) {
                this.pqdouble.add(new PixDouble(x, y, result[y][x]));
            }
        }
        while (!this.pqdouble.isEmpty()) {
            double min;
            pix = this.pqdouble.poll();
            x = pix.x;
            y = pix.y;
            double Color2 = pix.v;
            if (y - 1 >= 0 && (min = Math.min(reference[y - 1][x], Color2)) > result[y - 1][x]) {
                this.Mark(x, y - 1, result, min);
            }
            if (y + 1 < height && (min = Math.min(reference[y + 1][x], Color2)) > result[y + 1][x]) {
                this.Mark(x, y + 1, result, min);
            }
            if (x - 1 >= 0 && (min = Math.min(reference[y][x - 1], Color2)) > result[y][x - 1]) {
                this.Mark(x - 1, y, result, min);
            }
            if (x + 1 < width && (min = Math.min(reference[y][x + 1], Color2)) > result[y][x + 1]) {
                this.Mark(x + 1, y, result, min);
            }
            if (x - 1 >= 0 && y - 1 >= 0 && (min = Math.min(reference[y - 1][x - 1], Color2)) > result[y - 1][x - 1]) {
                this.Mark(x - 1, y - 1, result, min);
            }
            if (x + 1 < width && y - 1 >= 0 && (min = Math.min(reference[y - 1][x + 1], Color2)) > result[y - 1][x + 1]) {
                this.Mark(x + 1, y - 1, result, min);
            }
            if (x - 1 >= 0 && y + 1 < height && (min = Math.min(reference[y + 1][x - 1], Color2)) > result[y + 1][x - 1]) {
                this.Mark(x - 1, y + 1, result, min);
            }
            if (x + 1 >= width || y + 1 >= height || !((min = Math.min(reference[y + 1][x + 1], Color2)) > result[y + 1][x + 1])) continue;
            this.Mark(x + 1, y + 1, result, min);
        }
    }

    private void Mark(int x, int y, double[][] array, double value) {
        this.pqdouble.add(new PixDouble(x, y, value));
        array[y][x] = value;
    }

    public void Marker(BufferedImage marker) {
        this.marker = null;
        this.marker = marker;
    }

    public BufferedImage Marker() {
        return this.marker;
    }

    public void Marker(DV Marker2) {
        throw new Error("Method not implemented (yet).");
    }

    public DV Marker3D() {
        throw new Error("Method not implemented (yet).");
    }

    public void Marker(double[][] marker) {
        this.markerdouble = null;
        this.markerdouble = marker;
    }

    public double[][] MarkerDouble() {
        return this.markerdouble;
    }

    public StructuringElement getStructuringElement() {
        return null;
    }

    public void setStructuringElement(StructuringElement ES) {
    }

    public void Parameters(Object ... parameters) {
    }

    public List<Object> Parameters() {
        return null;
    }

    public int BorderEffectSizeX() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public int BorderEffectSizeY() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public int BorderEffectSizeZ() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public MorphoFilterMarker Clone() {
        throw new UnsupportedOperationException("Not supported (yet).");
    }

    private class PixDouble
    implements Comparable<PixDouble> {
        public int x;
        public int y;
        public double v;

        public PixDouble(int x, int y, double v) {
            this.x = x;
            this.y = y;
            this.v = v;
        }

        @Override
        public int compareTo(PixDouble o) {
            if (o.v - this.v > 0.0) {
                return 1;
            }
            if (o.v - this.v < 0.0) {
                return -1;
            }
            return 0;
        }
    }

    private class Pix
    implements Comparable<Pix> {
        public int x;
        public int y;
        public int v;

        public Pix(int x, int y, int v) {
            this.x = x;
            this.y = y;
            this.v = v;
        }

        @Override
        public int compareTo(Pix o) {
            return o.v - this.v;
        }
    }
}

